//@ui5-bundle sap/ui/layout/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/AlignedFlowLayout", ["sap/ui/core/Core","sap/ui/core/Control","./library","sap/ui/core/ResizeHandler","./AlignedFlowLayoutRenderer","sap/ui/dom/units/Rem"],function(e,t,i,n,s,r){"use strict";var o=t.extend("sap.ui.layout.AlignedFlowLayout",{metadata:{library:"sap.ui.layout",properties:{minItemWidth:{type:"sap.ui.core.AbsoluteCSSSize",defaultValue:"12rem"},maxItemWidth:{type:"sap.ui.core.AbsoluteCSSSize",defaultValue:"24rem"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},endContent:{type:"sap.ui.core.Control",multiple:true}}},renderer:s});o.prototype.init=function(){if(typeof ResizeObserver==="function"){this.oResizeObserver=new ResizeObserver(this.onResize.bind(this));this.fLayoutWidth=0;this.fEndItemWidth=0}else{this._sResizeHandlerContainerListenerID=n.register(this,this.onResizeHandler.bind(this))}this.fnReflow=this.reflow.bind(this);this.bReflowSuspended=false};o.prototype.exit=function(){this.fnReflow=null;this.disconnectResizeObserver();this.oResizeObserver=null;this.fLayoutWidth=undefined;this.fEndItemWidth=undefined;this.disconnectResizeHandler();this._sResizeHandlerContainerListenerID="";this._sResizeHandlerEndItemListenerID=""};o.prototype.onAfterRenderingOrThemeChanged=function(){window.requestAnimationFrame(function(){var t=this.getDomRef(),i=this.getDomRef("endItem"),n=!!(this.hasContent()&&t&&i);if(n){var s=window.getComputedStyle(t,null),r=s.getPropertyValue("padding-top"),o=i.style;if(e.getConfiguration().getRTL()){o.left=s.getPropertyValue("padding-left")}else{o.right=s.getPropertyValue("padding-right")}o.bottom=r}var f={domRef:t,endItemDomRef:i};this.reflow(f)}.bind(this))};o.prototype.onBeforeRendering=function(){this.disconnectResizeObserver();this.disconnectResizeHandlerForEndItem()};o.prototype.onAfterRendering=function(){this.observeSizeChangesIfRequired();this.onAfterRenderingOrThemeChanged()};o.prototype.onThemeChanged=o.prototype.onAfterRenderingOrThemeChanged;o.prototype.onResizeHandler=function(e){if(e.size.width!==e.oldSize.width){this.reflow()}};o.prototype.onResize=function(e){var t=this.getDomRef();this.bReflowSuspended=this.bReflowSuspended||this.unobserveSizeChangesIfReflowSuspended(t);if(this.bReflowSuspended){return}var i,n=e[0],s=f(this.fLayoutWidth,n,t),r=n.contentRect.width,o=n.contentRect.height;if(s){this.fLayoutWidth=r;this.fLayoutHeight=o}else{i=this.getDomRef("endItem");s=f(this.fEndItemWidth,n,i);if(s){this.fEndItemWidth=r;this.fLayoutHeight=o}else if(this.fLayoutHeight!==o){this.fLayoutHeight=o}else{return}}window.requestAnimationFrame(function(){var e={domRef:t,endItemDomRef:i};this.reflow(e)}.bind(this))};o.prototype.reflow=function(t){if(this.bReflowSuspended){this.bReflowSuspended=false;if(this.oResizeObserver){this.observeSizeChangesIfRequired()}}var i=this.getContent();if(i.length===0||!i[0].isActive()){return}t=t||{};var n=t.domRef||this.getDomRef();if(!n){return}var s=t.endItemDomRef||this.getDomRef("endItem"),r=this.getLastItemDomRef();if(!s||!r){if(!n.offsetParent){return}this.toggleDisplayOfSpacers(n);return}var o=n.lastElementChild;a(n,o);if(!n.offsetParent){return}var f=o.style,h=s.offsetHeight,d=s.offsetWidth,u=r.offsetTop,l=r.offsetLeft,p,g;var m=window.getComputedStyle(r);if(e.getConfiguration().getRTL()){var R=Number.parseFloat(m.marginLeft);g=l-R}else{var c=Number.parseFloat(m.marginRight);var v=l+r.offsetWidth+c;g=n.offsetWidth-v}var y=window.getComputedStyle(s);var b=Number.parseFloat(y.marginLeft);var z=Number.parseFloat(y.marginRight);var I=g>=b+d+z;if(I){if(this.checkItemsWrapping(n)){if(s.offsetTop<u){f.height=Math.max(0,h-u)+"px";if(r.offsetTop>=s.offsetTop){p=s.offsetLeft;l=r.offsetLeft;if(p>=l&&p<=l+r.offsetWidth){f.height=h+"px"}}f.display="block"}else{f.height="0";f.display=""}}else{if(s.offsetTop<u){f.height=h+"px"}f.display="block"}}else{f.height=h+"px";f.display="block"}var C=d+"px";f.width=C;f.minWidth=C;f.marginLeft=b+"px";f.marginRight=z+"px";this.toggleDisplayOfSpacers(n)};o.prototype.toggleDisplayOfSpacers=function(e){var t=this.getRenderer().CSS_CLASS+"OneLine",i=true;if(this.checkItemsWrapping(e,i)){e.classList.remove(t)}else{e.classList.add(t)}};function f(e,t,i){var n=.25,s=t.contentRect.width;return i===t.target&&Math.abs(s-e)>=n}function a(e,t){var i=t&&t.style;if(i){i.width="";i.height="";i.display="";i.marginLeft="";i.marginRight=""}e.classList.remove(e.classList.item(0)+"OneLine")}o.prototype.checkItemsWrapping=function(e,t){e=e||this.getDomRef();if(!e){return false}var i=e.firstElementChild,n=this.getLastItemDomRef();if(!i||!n){return false}var s=i.offsetTop,r=n.offsetTop,o=i.offsetHeight;if(r>=s+o){return true}if(t){return false}var f=this.getDomRef("endItem");return!!f&&f.offsetTop>=s+o};o.prototype.getLastItemDomRef=function(){var e=this.getContent(),t=e.length;if(t){var i=e[t-1],n=i.getDomRef();if(n){return n.parentElement}}return null};o.prototype.getLastVisibleDomRef=function(){return this.getDomRef("endItem")||this.getLastItemDomRef()};o.prototype.computeNumberOfSpacers=function(){var e=this.getContent().length;if(e===0){return 0}var t=e,i=this.getMinItemWidth(),n;if(i.lastIndexOf("rem")!==-1){n=r.toPx(i)}else if(i.lastIndexOf("px")!==-1){n=parseFloat(i)}if(n){var s=Math.max(document.documentElement.clientWidth,window.screen.width);t=Math.abs(s/n)}t=Math.min(t,e-1);t=Math.max(1,t);t=Math.floor(t);return t};o.prototype.observeSizeChangesIfRequired=function(){if(this.hasContent()){this.observeSizeChanges()}};o.prototype.observeSizeChanges=function(){var e=this.getDomRef();if(!e){return}var t=this.getDomRef("endItem");if(this.oResizeObserver){this.oResizeObserver.observe(e);if(t){this.oResizeObserver.observe(t)}return}if(t){this._sResizeHandlerEndItemListenerID=n.register(t,this.onResizeHandler.bind(this))}};o.prototype.unobserveSizeChanges=function(e){if(this.oResizeObserver&&e){this.oResizeObserver.unobserve(e)}};o.prototype.unobserveSizeChangesIfReflowSuspended=function(e){var t=n.isSuspended(e,this.fnReflow);if(t){this.unobserveSizeChanges(e);this.unobserveSizeChanges(this.getDomRef("endItem"));return true}return false};o.prototype.disconnectResizeObserver=function(){if(this.oResizeObserver){this.oResizeObserver.disconnect()}};o.prototype.disconnectResizeHandler=function(){if(this._sResizeHandlerContainerListenerID){n.deregister(this._sResizeHandlerContainerListenerID)}this.disconnectResizeHandlerForEndItem()};o.prototype.disconnectResizeHandlerForEndItem=function(){if(this._sResizeHandlerEndItemListenerID){n.deregister(this._sResizeHandlerEndItemListenerID)}};o.prototype.hasContent=function(){return this.getContent().length>0};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/AlignedFlowLayoutRenderer", ["./library"],function(e){"use strict";var t={apiVersion:2};t.CSS_CLASS="sapUiAFLayout";t.render=function(e,n){var r=n.getContent();e.openStart("div",n);e.class(t.CSS_CLASS);if(r.length===0){e.class(t.CSS_CLASS+"NoContent")}e.openEnd();this.renderItems(e,n,r);this.renderEndItem(e,n);this.renderSpacers(e,n);e.close("div")};t.renderItems=function(e,t,n){n=n||t.getContent();n.forEach(function(n){this.renderItem(e,t,n)},this)};t.renderItem=function(e,n,r){e.openStart("div");e.class(t.CSS_CLASS+"Item");e.style("flex-basis",n.getMinItemWidth());e.style("max-width",n.getMaxItemWidth());e.openEnd();e.renderControl(r);e.close("div")};t.renderEndItem=function(e,n,r){r=r||n.getEndContent();if(r.length){e.openStart("div",n.getId()+"-endItem");e.class(t.CSS_CLASS+"End");if(n.getContent().length){e.style("flex-basis",n.getMinItemWidth())}e.openEnd();r.forEach(function(t){this.renderEndContent(e,n,t)},this);e.close("div")}};t.renderEndContent=function(e,t,n){e.renderControl(n)};t.renderSpacers=function(e,n){var r=n.computeNumberOfSpacers(),i=n.getMinItemWidth(),s=n.getMaxItemWidth(),d=t.CSS_CLASS,o=n.getId(),a=o+"-spacer",S=o+"-spacerlast";for(var c=0;c<r;c++){var l=c===r-1,C=l?S:a+c;e.openStart("div",C);e.class(d+"Item");e.class(d+"Spacer");e.style("flex-basis",i);e.style("max-width",s);e.openEnd();e.close("div")}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/AssociativeSplitter", ["./Splitter","./SplitterRenderer","sap/base/Log"],function(e,t,i){"use strict";var s=e.extend("sap.ui.layout.AssociativeSplitter",{metadata:{associations:{associatedContentAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"associatedContentArea"}}},renderer:t});s.prototype.init=function(){e.prototype.init.call(this);this._keyListeners={increase:this._onKeyboardResize.bind(this,"inc",1),decrease:this._onKeyboardResize.bind(this,"dec",1),increaseMore:this._onKeyboardResize.bind(this,"incMore",2),decreaseMore:this._onKeyboardResize.bind(this,"decMore",2),max:this._onKeyboardResize.bind(this,"max",1),min:this._onKeyboardResize.bind(this,"min",1)};this._enableKeyboardListeners()};s.prototype.addAssociatedContentArea=function(e){this._ensureLayoutData(e);return this.addAssociation("associatedContentAreas",e)};s.prototype._enableKeyboardListeners=function(){e.prototype._enableKeyboardListeners.call(this);this.onsaprightmodifiers=this._keyListeners.increase;this.onsapleftmodifiers=this._keyListeners.decrease;this.onsapupmodifiers=this._keyListeners.decrease;this.onsapdownmodifiers=this._keyListeners.increase;this.onsapright=this._keyListeners.increaseMore;this.onsapdown=this._keyListeners.increaseMore;this.onsapleft=this._keyListeners.decreaseMore;this.onsapup=this._keyListeners.decreaseMore;this.onsapend=this._keyListeners.max;this.onsaphome=this._keyListeners.min;this._keyboardEnabled=true};s.prototype._getContentAreas=function(){var e=this.getAssociatedContentAreas()||[];var t=this.getContentAreas();var i=e.map(function(e){return sap.ui.getCore().byId(e)}).filter(function(e){return e});return t.concat(i)};s.prototype.ondblclick=function(e){var t=this.getId(),i,s;if(!(e.target.contains(this._oLastDOMclicked)&&this._oLastDOMclicked.id.indexOf(t+"-splitbar")>-1)){return}i=parseInt(this._oLastDOMclicked.id.substr((t+"-splitbar-").length));s=this._getContentAreas()[i];s._currentPosition=this.getCalculatedSizes()[i];s._lastPosition=s._lastPosition||s._currentPosition;if(s._currentPosition===s._lastPosition){this._resizeContents(i,this.getCalculatedSizes()[i]*-1,true)}else{this._resizeContents(i,s._lastPosition,true);s._lastPosition=null}};s.prototype._calcPercentBasedSizes=function(t,i){var s=this._getContentAreas(),n=this._calcAvailableContentSize();if(t.length===1&&s.length===1){this._calculatedSizes[t[0]]=n;i-=n}else{i=e.prototype._calcPercentBasedSizes.apply(this,arguments)}return i};s.prototype._logConstraintsViolated=function(){i.warning("The set sizes and minimal sizes of the splitter contents are bigger than the available space in the UI. "+"Consider enabling the pagination mechanism by setting the 'requiredParentWidth' property of the panes",null,"sap.ui.layout.ResponsiveSplitter")};s.prototype.containsControl=function(e){var t=this._getContentAreas(),i,s;for(s=0;s<t.length;s++){i=t[s];if(i.isA("sap.ui.layout.AssociativeSplitter")){if(i.containsControl(e)){return true}}else{if(i.getId()===e){return true}}}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/BlockLayout", ["sap/ui/core/Control","./library","sap/ui/core/ResizeHandler","./BlockLayoutRenderer"],function(e,t,i,n){"use strict";var r=e.extend("sap.ui.layout.BlockLayout",{metadata:{library:"sap.ui.layout",properties:{background:{type:"sap.ui.layout.BlockBackgroundType",group:"Appearance",defaultValue:"Default"},keepFontSize:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.layout.BlockLayoutRow",multiple:true}},designtime:"sap/ui/layout/designtime/BlockLayout.designtime"},renderer:n});r.CONSTANTS={SIZES:{S:600,M:1024,L:1440,XL:null}};r.prototype.init=function(){this._currentBreakpoint=null};r.prototype.onBeforeRendering=function(){this._detachResizeHandler()};r.prototype.onAfterRendering=function(){this._onParentResize();this._notifySizeListeners()};r.prototype._onParentResize=function(){var e,t=this.getDomRef(),i=t.clientWidth,n=r.CONSTANTS.SIZES;this._detachResizeHandler();if(i>0){this._removeBreakpointClasses();for(e in n){if(n.hasOwnProperty(e)&&(n[e]===null||n[e]>i)){if(this._currentBreakpoint!=e){this._currentBreakpoint=e;this._notifySizeListeners()}this.addStyleClass("sapUiBlockLayoutSize"+e,true);break}}}this._attachResizeHandler()};r.prototype._notifySizeListeners=function(){var e=this;this.getContent().forEach(function(t){t._onParentSizeChange(e._currentBreakpoint)})};r.prototype._removeBreakpointClasses=function(){var e=r.CONSTANTS.SIZES;for(var t in e){if(e.hasOwnProperty(t)){this.removeStyleClass("sapUiBlockLayoutSize"+t,true)}}};r.prototype._attachResizeHandler=function(){if(!this._parentResizeHandler){this._parentResizeHandler=i.register(this,this._onParentResize.bind(this))}};r.prototype._detachResizeHandler=function(){if(this._parentResizeHandler){i.deregister(this._parentResizeHandler);this._parentResizeHandler=null}};r.prototype.exit=function(){this._detachResizeHandler()};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/BlockLayoutCell", ["sap/ui/core/Control","./library","./BlockLayoutCellRenderer","sap/base/Log","sap/ui/thirdparty/jquery"],function(t,e,a,o,jQuery){"use strict";var i=t.extend("sap.ui.layout.BlockLayoutCell",{metadata:{library:"sap.ui.layout",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleAlignment:{type:"sap.ui.core.HorizontalAlign",group:"Appearance",defaultValue:"Begin"},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:"Auto"},width:{type:"int",group:"Appearance",defaultValue:0},backgroundColorSet:{type:"sap.ui.layout.BlockLayoutCellColorSet",group:"Appearance"},backgroundColorShade:{type:"sap.ui.layout.BlockLayoutCellColorShade",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},titleLink:{type:"sap.ui.core.Control",multiple:false}},designtime:"sap/ui/layout/designtime/BlockLayoutCell.designtime"},renderer:a});i.prototype.setLayoutData=function(t){this.setAggregation("layoutData",t,true);var e=this.getParent();if(e){var a=jQuery.Event("LayoutDataChange");a.srcControl=this;e._handleEvent(a)}if(t&&this.getWidth()!=0){this.getLayoutData().setSize(this.getWidth())}return this};i.prototype.setWidth=function(t){this.setProperty("width",t);if(this.getLayoutData()&&this.getLayoutData().isA("sap.ui.layout.BlockLayoutCellData")){this.getLayoutData().setSize(t)}return this};i.prototype.setTitleLink=function(t){if(t&&t.getMetadata().getName()!=="sap.m.Link"){o.warning("sap.ui.layout.BlockLayoutCell "+this.getId()+": Can't add value for titleLink aggregation different than sap.m.Link.");return this}this.setAggregation("titleLink",t);return this};i.prototype._setParentRowScrollable=function(t){this._parentRowScrollable=t};i.prototype._getParentRowScrollable=function(){return this._parentRowScrollable};i.prototype._setFlexWidth=function(t){this._flexWidth=t};i.prototype._getFlexWidth=function(){return this._flexWidth};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/BlockLayoutCellData", ["sap/ui/core/LayoutData","./library"],function(e,t){"use strict";var a=e.extend("sap.ui.layout.BlockLayoutCellData",{metadata:{library:"sap.ui.layout",properties:{sSize:{type:"int",group:"Appearance",defaultValue:1},mSize:{type:"int",group:"Appearance",defaultValue:1},lSize:{type:"int",group:"Appearance",defaultValue:1},xlSize:{type:"int",group:"Appearance",defaultValue:1}}}});a.prototype.breakRowOnSSize=true;a.prototype.breakRowOnMSize=false;a.prototype.breakRowOnLSize=false;a.prototype.breakRowOnXlSize=false;a.prototype.setSize=function(e){this.setProperty("mSize",e);this.setProperty("lSize",e);this.setProperty("xlSize",e);var t=this.getParent();if(t&&t.getParent()){t.getParent().invalidate()}return this};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/BlockLayoutCellRenderer", ["./library","sap/ui/core/library","sap/base/Log"],function(e,t,l){"use strict";var i=t.TitleLevel;var n={apiVersion:2};n.render=function(e,t){this.startCell(e,t);this.addContent(e,t);this.endCell(e)};n.startCell=function(e,t){var l=this.getCellColor(e,t);e.openStart("div",t).class("sapUiBlockLayoutCell");l&&e.class(l);this.setWidth(e,t);e.openEnd()};n.getCellColor=function(e,t){var i=t.getBackgroundColorSet(),n=t.getBackgroundColorShade();if(!i&&!n){return""}else if(i&&!n||!i&&n){l.warning("Both, backgroundColorSet and backgroundColorShade should be defined. ColoSet is not applied to "+t.getId()+".");return""}i=i.replace("ColorSet","");n=n.replace("Shade","");return"sapUiBlockLayoutCellColor"+i+n};n.setWidth=function(e,t){var l=t.getWidth();if(t._getParentRowScrollable()){if(l!==0){e.style("width",l+"%")}}else{this.addFlex(e,t._getFlexWidth())}};n.addFlex=function(e,t){e.style("-webkit-flex",t);e.style("-ms-flex",t);e.style("flex",t)};n.addTitle=function(e,t){var l=t.getTitleLink();var n=t.getTitle();if(n||l){var o="sapUiBlockCell"+t.getTitleAlignment(),r="sapUiBlockCellTitle "+o;if(t.getContent().length===0){r+=" sapUiBlockCellTitleNoContent"}var a=t.getTitleLevel(),s=a===i.Auto,d=s?"h2":a.toLowerCase();var c=r.split(" ");e.openStart(d,this.getTitleId(t));for(var C=0;C<c.length;C++){e.class(c[C])}e.openEnd();if(l){e.renderControl(l)}else{e.text(n)}e.close(d)}};n.getTitleId=function(e){return e.getId()+"-Title"};n.hasTitle=function(e){return e.getTitleLink()||e.getTitle()};n.addContent=function(e,t){var l=t.getContent(),i=this.hasTitle(t);e.openStart("div").class("sapUiBlockCellContent");if(t.getTitleAlignment()==="Center"){e.class("sapUiBlockCellCenteredContent")}e.openEnd();if(i){this.addTitle(e,t)}l.forEach(e.renderControl,e);e.close("div")};n.endCell=function(e){e.close("div")};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/BlockLayoutRenderer", ["./library"],function(t){"use strict";var o=t.BlockRowColorSets;var e={apiVersion:2};e.render=function(t,o){this.startLayout(t,o);this.addContent(t,o);this.endLayout(t)};e.startLayout=function(t,o){t.openStart("div",o).class("sapUiBlockLayout").class("sapUiBlockLayoutBackground"+o.getBackground());if(o.getKeepFontSize()){t.class("sapUiBlockLayoutKeepFontSize")}t.openEnd()};e.addContent=function(t,e){var n=e.getContent(),a=Object.keys(o).map(function(t){return o[t]}),r=a.length;n.forEach(function(o,e,n){var s=o.getRowColorSet()||a[e%r],i="sapUiBlockLayoutBackground"+s,u=e&&n[e-1]||null;if(u&&u.hasStyleClass(i)){o.removeStyleClass(i);i+="Inverted"}if(i){o.addStyleClass(i)}t.renderControl(o)})};e.endLayout=function(t){t.close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/BlockLayoutRow", ["sap/ui/core/Control","./library","sap/ui/layout/BlockLayoutCellData","./BlockLayoutRowRenderer","sap/base/Log"],function(t,e,a,r,o){"use strict";var n=e.BlockBackgroundType;var s=e.BlockRowColorSets;var l=t.extend("sap.ui.layout.BlockLayoutRow",{metadata:{library:"sap.ui.layout",properties:{scrollable:{type:"boolean",group:"Appearance",defaultValue:false},rowColorSet:{type:"sap.ui.layout.BlockRowColorSets",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.layout.BlockLayoutCell",multiple:true,singularName:"content"}},associations:{accentCells:{type:"sap.ui.layout.BlockLayoutCell",multiple:true,singularName:"accentCell"}},designtime:"sap/ui/layout/designtime/BlockLayoutRow.designtime"},renderer:r});l.prototype.init=function(){this._applyLayoutData={}};l.prototype.addContent=function(t){this._ensureLayoutData(t);return this.addAggregation("content",t)};l.prototype.insertContent=function(t,e){this._ensureLayoutData(t);return this.insertAggregation("content",t,e)};l.prototype.onBeforeRendering=function(){var t=this.getContent(),e=this;t.forEach(function(t,a){e._ensureLayoutData(t);t._setParentRowScrollable(e.getScrollable())});this._calculateBreakpointRendering()};l.prototype.setRowColorSet=function(e){var a=Array.prototype.slice.call(arguments),r=t.prototype.setProperty.apply(this,["rowColorSet"].concat(a)),o="sapUiBlockLayoutBackground"+e,n=this.getParent(),l=n&&n.getBackground(),i=n&&n.indexOfAggregation("content",this),u=n&&n.getContent(),c=i&&u[i-1]||null,y=u&&u[i+1]||null,g=Object.keys(s).map(function(t){return s[t]}),p=false;if(c&&c._hasStyleClass(o,l,p,e)){o+="Inverted";p=true}g.forEach(function(t){var e="sapUiBlockLayoutBackground"+t,a=e+"Inverted";if(this._hasStyleClass(e,l,false,t)){this.removeStyleClass(e,true)}else if(this._hasStyleClass(a,l,true,t)){this.removeStyleClass(a,true)}},this);this.addStyleClass(o,true);if(y&&y._hasStyleClass(o,l,p,e)){y.setRowColorSet(e)}this.invalidate();return r};l.prototype.addAccentCell=function(t){var e,a=t&&t.getId?t.getId():t,r=this.getParent(),s=r&&(r.getBackground()||"");e=this.addAssociation("accentCells",t);if(!r){return this}if([n.Accent,n.Mixed].indexOf(s)===-1){o.warning(a+" was not set as accent cell. Accent cells could be set only for 'Accent' and 'Mixed' layout backgrounds.");return this}return e};l.prototype._ensureLayoutData=function(t){var e=t.getLayoutData();if(!e||!(e instanceof a)){t.setLayoutData(new a)}};l.prototype._onParentSizeChange=function(t){this._currentSize=t;this._calculateBreakpointRendering();this.invalidate()};l.prototype._getCellArangementForCurrentSize=function(){if(!this._arrangements||!this._currentSize){return null}return this._arrangements[this._currentSize]};l.prototype._calculateBreakpointRendering=function(){if(!this._currentSize){return}this._arrangements={S:this._calcArrangementForSize("S"),M:this._calcArrangementForSize("M"),L:this._calcArrangementForSize("L"),XL:this._calcArrangementForSize("Xl")}};l.prototype._calcArrangementForSize=function(t){var e=this.getContent();if(e.length>=3&&t==="M"&&e.length<5){return this._generateArrangementForMCase()}else{return this._generateArrangement(t)}};l.prototype._generateArrangement=function(t){var e,a=0,r=[],o=[],n=[[]],s=this.getContent();s.forEach(function(a){e=a.getLayoutData();o.push(e["breakRowOn"+t+"Size"]);r.push(e["get"+t+"Size"]())});r.forEach(function(t,e){n[a].push(t);if(o[e+1]){a++;n[a]=[]}});return n};l.prototype._generateArrangementForMCase=function(){var t=this.getContent();if(t.length===3&&this._isAllCellsHasSameWidth("M")){return[[1,1,1]]}else if(t.length===3){return[[1,1],[1]]}else if(t.length===4){return[[1,1],[1,1]]}};l.prototype._isAllCellsHasSameWidth=function(t){var e,a=this.getContent(),r=a[0].getLayoutData()["get"+t+"Size"]();for(var o=1;o<a.length;o++){e=a[o].getLayoutData()["get"+t+"Size"]();if(e!==r){return false}}return true};l.prototype._processMixedCellStyles=function(t,e){var a,r;if(!e||!e.length){return this}a=this.getParent();r=a&&(a.hasStyleClass("sapUiBlockLayoutSizeL")||a.hasStyleClass("sapUiBlockLayoutSizeXL"));e.forEach(function(e){var a,l;if(r&&e.getId()===t&&e.getWidth()===1){e.addStyleClass("sapContrast").addStyleClass("sapContrastPlus");a=s;l=this._hasStyleClass("sapUiBlockLayoutBackground"+a.ColorSet1,n.Mixed,false,a.ColorSet1)||this._hasStyleClass("sapUiBlockLayoutBackground"+a.ColorSet1,n.Mixed,true,a.ColorSet1);if(l){e.addStyleClass("sapUiBlockLayoutBackgroundContrast2")}}else if((!r||e.getId()!==t)&&(e.hasStyleClass("sapContrast")||e.hasStyleClass("sapContrastPlus"))){e.removeStyleClass("sapContrast").removeStyleClass("sapContrastPlus").removeStyleClass("sapUiBlockLayoutBackgroundContrast2");this.removeAssociation("accentCells",e);o.warning(t+" was removed as accent cell. Only one cell at a time could be accented for Mixed layout background")}},this);return this};l.prototype._processAccentCellStyles=function(t,e){var a,r,o,n=0,s=0,l=Array.prototype.slice.call(t);if(!t||!t.length){return this}for(n=0;n<e.length;n++){a=e[n];r=a.getId();if(!l.length){break}if(l.indexOf(r)>-1){s++;o="sapUiBlockLayoutBackgroundColorSetGray"+(s%2+1);if(a.hasStyleClass(o)){continue}l.splice(l.indexOf(r),1);a.removeStyleClass("sapUiBlockLayoutBackgroundColorSetGray1").removeStyleClass("sapUiBlockLayoutBackgroundColorSetGray2").addStyleClass(o)}}return this};l.prototype._hasStyleClass=function(t,e,a,r){var o=n,l=s,i,u,c;if([o.Light,o.Mixed].indexOf(e)===-1){return this.hasStyleClass(t)}else if(this.hasStyleClass(t)){return true}c=[[l.ColorSet1,l.ColorSet3],[l.ColorSet2,l.ColorSet4]];for(i=0;i<=c.length;i++){if(c[i]&&c[i].indexOf(r)>-1){break}}if(!c[i]){return false}u=c[i].map(function(t){return"sapUiBlockLayoutBackground"+t+(a?"Inverted":"")});return u.some(this.hasStyleClass,this)};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/BlockLayoutRowRenderer", ["./library"],function(e){"use strict";var l=e.BlockBackgroundType;var t={apiVersion:2};t.render=function(e,l){this.startRow(e,l);this.renderContent(e,l);this.endRow(e,l)};t.startRow=function(e,l){e.openStart("div",l).class("sapUiBlockLayoutRow");this.addRowRenderingClass(e,l);e.openEnd()};t.addRowRenderingClass=function(e,l){if(l.getScrollable()){e.class("sapUiBlockScrollingRow");if(l.getContent().length>=6){e.class("sapUiBlockScrollingNarrowCells")}}else{e.class("sapUiBlockHorizontalCellsRow")}};t.renderContent=function(e,t){var n=t.getContent(),o=t.getScrollable(),a=t.getParent().getBackground(),s=t.getAccentCells(),r=0,i;n.forEach(function(e,l){l%2==0?e.addStyleClass("sapUiBlockLayoutOddCell"):e.addStyleClass("sapUiBlockLayoutEvenCell");if(o){e.addStyleClass("sapUiBlockScrollableCell")}else{e.addStyleClass("sapUiBlockHorizontalCell")}});switch(a){case l.Mixed:if(s.length>0){t._processMixedCellStyles(s[s.length-1],n)}break;case l.Accent:t._processAccentCellStyles(s,n);break}var c=t._getCellArangementForCurrentSize();if(o){n.forEach(e.renderControl,e)}else if(c){for(var d=0;d<c.length;d++){var C=c[d];e.openStart("div");e.style("display","flex");e.openEnd();for(var g=0;g<C.length;g++){i=C[g];n[r]._setFlexWidth(i);e.renderControl(n[r]);r++}e.close("div")}}};t.endRow=function(e){e.close("div")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/DynamicSideContent", ["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/layout/library","./DynamicSideContentRenderer"],function(jQuery,t,e,i,s,n){"use strict";var r=s.SideContentPosition;var o=s.SideContentFallDown;var a=s.SideContentVisibility;var h=t.extend("sap.ui.layout.DynamicSideContent",{metadata:{library:"sap.ui.layout",properties:{showSideContent:{type:"boolean",group:"Appearance",defaultValue:true},showMainContent:{type:"boolean",group:"Appearance",defaultValue:true},sideContentVisibility:{type:"sap.ui.layout.SideContentVisibility",group:"Appearance",defaultValue:a.ShowAboveS},sideContentFallDown:{type:"sap.ui.layout.SideContentFallDown",group:"Appearance",defaultValue:o.OnMinimumWidth},equalSplit:{type:"boolean",group:"Appearance",defaultValue:false},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false},sideContentPosition:{type:"sap.ui.layout.SideContentPosition",group:"Appearance",defaultValue:r.End},mcSpan:{type:"int",defaultValue:0,visibility:"hidden"},scSpan:{type:"int",defaultValue:0,visibility:"hidden"}},defaultAggregation:"mainContent",events:{breakpointChanged:{parameters:{currentBreakpoint:{type:"string"}}}},aggregations:{mainContent:{type:"sap.ui.core.Control",multiple:true},sideContent:{type:"sap.ui.core.Control",multiple:true}},designTime:"sap/ui/layout/designtime/DynamicSideContent.designtime",dnd:{draggable:false,droppable:true}},renderer:n});var l="S",d="M",C="L",u="XL",p="sapUiHidden",S="sapUiDSCSpan12",_="sapUiDSCMCFixed",g="sapUiDSCSCFixed",c=3,f=4,y=6,b=8,w=9,V=12,M="Invalid Breakpoint. Expected: S, M, L or XL",m="SCGridCell",P="MCGridCell",k=720,v=1024,B=1440;h.prototype.setSideContentVisibility=function(t,e){this.setProperty("sideContentVisibility",t,true);if(!e&&this.$().length){this._setResizeData(this.getCurrentBreakpoint());this._changeGridState()}return this};h.prototype.setShowSideContent=function(t,e){if(t===this.getShowSideContent()){return this}this.setProperty("showSideContent",t,true);this._SCVisible=t;if(!e&&this.$().length){this._setResizeData(this.getCurrentBreakpoint(),this.getEqualSplit());if(this._currentBreakpoint===l){this._MCVisible=true}this._changeGridState()}return this};h.prototype.setShowMainContent=function(t,e){if(t===this.getShowMainContent()){return this}this.setProperty("showMainContent",t,true);this._MCVisible=t;if(!e&&this.$().length){this._setResizeData(this.getCurrentBreakpoint(),this.getEqualSplit());if(this._currentBreakpoint===l){this._SCVisible=true}this._changeGridState()}return this};h.prototype.isSideContentVisible=function(){if(this._currentBreakpoint===l){return this._SCVisible&&this.getProperty("showSideContent")}else{return this.getProperty("showSideContent")}};h.prototype.isMainContentVisible=function(){if(this._currentBreakpoint===l){return this._MCVisible&&this.getProperty("showMainContent")}else{return this.getProperty("showMainContent")}};h.prototype.setEqualSplit=function(t){this._MCVisible=true;this._SCVisible=true;this.setProperty("equalSplit",t,true);if(this._currentBreakpoint){this._setResizeData(this._currentBreakpoint,t);this._changeGridState()}return this};h.prototype.addSideContent=function(t){this.addAggregation("sideContent",t,true);this._rerenderControl(this.getAggregation("sideContent"),this.$(m));return this};h.prototype.addMainContent=function(t){this.addAggregation("mainContent",t,true);this._rerenderControl(this.getAggregation("mainContent"),this.$(P));return this};h.prototype.toggle=function(){if(this._currentBreakpoint===l){if(!this.getProperty("showMainContent")){this.setShowMainContent(true,true);this._MCVisible=false}if(!this.getProperty("showSideContent")){this.setShowSideContent(true,true);this._SCVisible=false}if(this._MCVisible&&!this._SCVisible){this._SCVisible=true;this._MCVisible=false}else if(!this._MCVisible&&this._SCVisible){this._MCVisible=true;this._SCVisible=false}this._changeGridState()}return this};h.prototype.getCurrentBreakpoint=function(){return this._currentBreakpoint};h.prototype.onBeforeRendering=function(){this._detachContainerResizeListener();this._SCVisible=this._SCVisible===undefined?this.getProperty("showSideContent"):this._SCVisible;this._MCVisible=this._MCVisible===undefined?this.getProperty("showMainContent"):this._MCVisible;if(!this.getContainerQuery()){this._iWindowWidth=jQuery(window).width();this._setBreakpointFromWidth(this._iWindowWidth);this._setResizeData(this._currentBreakpoint,this.getEqualSplit())}};h.prototype.onAfterRendering=function(){if(this.getContainerQuery()){this._attachContainerResizeListener();this._adjustToScreenSize()}else{var t=this;jQuery(window).on("resize",function(){t._adjustToScreenSize()})}this._changeGridState();this._initScrolling()};h.prototype.onThemeChanged=function(){if(this.getContainerQuery()){this._adjustToScreenSize()}};h.prototype.exit=function(){this._detachContainerResizeListener();if(this._oSCScroller){this._oSCScroller.destroy();this._oSCScroller=null}if(this._oMCScroller){this._oMCScroller.destroy();this._oMCScroller=null}};h.prototype.getScrollDelegate=function(t){var e=this.getParent(),i=t.getParent(),s=t.sParentAggregationName,n=this.getShowMainContent()&&this._MCVisible,r=this.getShowSideContent()&&this._SCVisible;while(i&&i.getId()!==this.getId()){s=i.sParentAggregationName;i=i.getParent()}if(!t){return}else if(s==="sideContent"&&!r||s==="mainContent"&&!n){return}else if(!this._isContentOnFullHeight(s)){while(e&&(!e.getScrollDelegate||!e.getScrollDelegate())){e=e.getParent()}if(e){return e.getScrollDelegate()}}this._initScrolling();if(this._oMCScroller&&this._oSCScroller){while(t&&t.getId()!==this.getId()){if(t.sParentAggregationName==="mainContent"&&n){return this._oMCScroller}if(t.sParentAggregationName==="sideContent"&&r){return this._oSCScroller}t=t.getParent()}}return};h.prototype._isContentOnFullHeight=function(t){var e=this.getShowMainContent()&&this._MCVisible,i=this.getShowSideContent()&&this._SCVisible,s=this.getProperty("mcSpan"),n=this.getProperty("scSpan"),r=t==="mainContent"&&e&&(s===V&&!i||s!==V),o=t==="sideContent"&&i&&(n===V&&!e||n!==V);return r||o};h.prototype._rerenderControl=function(t,e){if(this.getDomRef()){var i=sap.ui.getCore().createRenderManager();this.getRenderer().renderControls(i,t);i.flush(e[0]);i.destroy()}return this};h.prototype._initScrolling=function(){var t=this.getId(),e=t+"-"+m,s=t+"-"+P;if(!this._oSCScroller&&!this._oMCScroller){this._oSCScroller=new i(this,null,{scrollContainerId:e,horizontal:false,vertical:true});this._oMCScroller=new i(this,null,{scrollContainerId:s,horizontal:false,vertical:true})}};h.prototype._attachContainerResizeListener=function(){setTimeout(function(){this._sContainerResizeListener=e.register(this,this._adjustToScreenSize.bind(this))}.bind(this),0)};h.prototype._detachContainerResizeListener=function(){if(this._sContainerResizeListener){e.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null}};h.prototype._getBreakPointFromWidth=function(t){if(t<=k&&this._currentBreakpoint!==l){return l}else if(t>k&&t<=v&&this._currentBreakpoint!==d){return d}else if(t>v&&t<=B&&this._currentBreakpoint!==C){return C}else if(t>B&&this._currentBreakpoint!==u){return u}return this._currentBreakpoint};h.prototype._setBreakpointFromWidth=function(t){var e=this._getBreakPointFromWidth(t),i=this.getCurrentBreakpoint();this._currentBreakpoint=e;if(i!==undefined){e!==i&&this.fireBreakpointChanged({currentBreakpoint:this._currentBreakpoint})}};h.prototype._adjustToScreenSize=function(){if(this.getContainerQuery()){this._iWindowWidth=this.$().parent().width()}else{this._iWindowWidth=jQuery(window).width()}this._setResizeData(this._getBreakPointFromWidth(this._iWindowWidth),this.getEqualSplit());this._changeGridState();this._setBreakpointFromWidth(this._iWindowWidth)};h.prototype._setResizeData=function(t,e){var i=this.getSideContentVisibility(),s=this.getSideContentFallDown();if(!e){switch(t){case l:this._setSpanSize(V,V);if(this.getProperty("showSideContent")&&this.getProperty("showMainContent")&&this._MCVisible){this._SCVisible=i===a.AlwaysShow}this._bFixedSideContent=false;break;case d:var n=Math.ceil(33.333/100*this._iWindowWidth);if(s===o.BelowL||s===o.BelowXL||n<=320&&s===o.OnMinimumWidth){this._setSpanSize(V,V);this._bFixedSideContent=false}else{this._setSpanSize(f,b);this._bFixedSideContent=true}this._SCVisible=i===a.ShowAboveS||i===a.AlwaysShow;this._MCVisible=true;break;case C:if(s===o.BelowXL){this._setSpanSize(V,V)}else{this._setSpanSize(f,b)}this._SCVisible=i===a.ShowAboveS||i===a.ShowAboveM||i===a.AlwaysShow;this._MCVisible=true;this._bFixedSideContent=false;break;case u:this._setSpanSize(c,w);this._SCVisible=i!==a.NeverShow;this._MCVisible=true;this._bFixedSideContent=false;break;default:throw new Error(M)}}else{switch(t){case l:this._setSpanSize(V,V);this._SCVisible=false;break;default:this._setSpanSize(y,y);this._SCVisible=true;this._MCVisible=true}this._bFixedSideContent=false}return this};h.prototype._shouldSetHeight=function(){var t,e,i,s,n,r,o;t=this.getProperty("scSpan")+this.getProperty("mcSpan")===V;e=this._MCVisible&&this._SCVisible;i=!this._MCVisible&&this._SCVisible;s=this._MCVisible&&!this._SCVisible;n=i||s;r=this._fixedSideContent;o=this.getSideContentVisibility()===a.NeverShow;return t&&e||n||r||o};h.prototype._changeGridState=function(){var t=this.$(m),e=this.$(P),i=this.getProperty("showMainContent"),s=this.getProperty("showSideContent");if(this._bFixedSideContent){t.removeClass().addClass(g);e.removeClass().addClass(_)}else{t.removeClass(g);e.removeClass(_)}if(this._SCVisible&&this._MCVisible&&s&&i){if(!this._bFixedSideContent){e.removeClass().addClass("sapUiDSCSpan"+this.getProperty("mcSpan"));t.removeClass().addClass("sapUiDSCSpan"+this.getProperty("scSpan"))}if(this._shouldSetHeight()){t.css("height","100%").css("float","left");e.css("height","100%").css("float","left")}else{t.css("height","auto").css("float","none");e.css("height","auto").css("float","none")}}else if(!this._SCVisible&&!this._MCVisible){e.addClass(p);t.addClass(p)}else if(this._MCVisible&&i){e.removeClass().addClass(S);t.addClass(p)}else if(this._SCVisible&&s){t.removeClass().addClass(S);e.addClass(p)}else if(!i&&!s){e.addClass(p);t.addClass(p)}e.addClass("sapUiDSCM");t.addClass("sapUiDSCS")};h.prototype._setSpanSize=function(t,e){this.setProperty("scSpan",t);this.setProperty("mcSpan",e)};return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/DynamicSideContentRenderer", ["sap/ui/layout/library","sap/ui/Device","sap/ui/core/Configuration"],function(e,t,n){"use strict";var i=e.SideContentPosition;var r="SIDE_CONTENT_LABEL";var o={apiVersion:2};o.render=function(e,t){e.openStart("div",t);e.class("sapUiDSC");e.style("height","100%");e.openEnd();this.renderSubControls(e,t);e.close("div")};o.renderSubControls=function(e,t){var r=t.getId(),o=t._shouldSetHeight(),s=n.getRTL(),a=t.getSideContentPosition();if(a===i.Begin&&!s||s&&a===i.End){this._renderSideContent(e,t,r,o);this._renderMainContent(e,t,r,o)}else{this._renderMainContent(e,t,r,o);this._renderSideContent(e,t,r,o)}};o.renderControls=function(e,t){var n=t.length,i=0;for(;i<n;i++){e.renderControl(t[i])}};o._renderMainContent=function(e,t,n,i){e.openStart("div",n+"-MCGridCell");e.class("sapUiDSCM");if(t.getProperty("mcSpan")){if(t.getShowSideContent()&&t._SCVisible){e.class("sapUiDSCSpan"+t.getProperty("mcSpan"))}else{e.class("sapUiDSCSpan12");i=true}}if(i){e.style("height","100%")}e.openEnd();this.renderControls(e,t.getMainContent());e.close("div")};o._renderSideContent=function(e,n,i,o){var s=t.browser.firefox?"div":"aside";e.openStart(s,i+"-SCGridCell");e.class("sapUiDSCS");var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");e.attr("aria-label",a.getText(r));e.accessibilityState(n,{role:"complementary"});if(n.getProperty("scSpan")){if(n.getShowMainContent()&&n._MCVisible){e.class("sapUiDSCSpan"+n.getProperty("scSpan"))}else{e.class("sapUiDSCSpan12");o=true}}if(o){e.style("height","100%")}e.openEnd();this.renderControls(e,n.getSideContent());e.close(s)};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/FixFlex", ["sap/ui/core/Control","sap/ui/core/EnabledPropagator","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","./FixFlexRenderer","sap/ui/layout/library"],function(e,i,t,l,r){"use strict";var s=e.extend("sap.ui.layout.FixFlex",{metadata:{library:"sap.ui.layout",properties:{vertical:{type:"boolean",group:"Appearance",defaultValue:true},fixFirst:{type:"boolean",group:"Misc",defaultValue:true},fixContentSize:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},minFlexSize:{type:"int",defaultValue:0}},aggregations:{fixContent:{type:"sap.ui.core.Control",multiple:true,singularName:"fixContent"},flexContent:{type:"sap.ui.core.Control",multiple:false}},designtime:"sap/ui/layout/designtime/FixFlex.designtime",dnd:{draggable:false,droppable:true}},renderer:r});i.call(s.prototype);s.prototype.init=function(){this._scroller=new l(this,null,{scrollContainerId:this.getId()});this._innerScroller=new l(this,this.getId()+"-FlexibleContainer",{scrollContainerId:this.getId()+"-Flexible"})};s.prototype.exit=function(){this._deregisterControl();if(this._scroller){this._scroller.destroy();this._scroller=null}if(this._innerScroller){this._innerScroller.destroy();this._innerScroller=null}};s.prototype.onBeforeRendering=function(){this._deregisterControl();this._scroller.setVertical(false);this._scroller.setHorizontal(false);var e=this.getMinFlexSize()!==0;this._innerScroller.setVertical(e);this._innerScroller.setHorizontal(e)};s.prototype.onAfterRendering=function(){if(this.getMinFlexSize()!==0){this.sResizeListenerFixFlexScroll=t.register(this.getDomRef(),this._changeScrolling.bind(this));this.sResizeListenerFixFlexScrollFlexPart=t.register(this.getDomRef("Fixed"),this._changeScrolling.bind(this));var e=this.getDomRef("FlexibleContainer").firstChild;if(e){this.sResizeListenerFixFlexContainerScroll=t.register(e,this._changeFlexibleContainerScroll.bind(this))}this._changeScrolling()}};s.prototype.getScrollDelegate=function(){return this._innerScroller};s.prototype._deregisterControl=function(){if(this.sResizeListenerFixFlexScroll){t.deregister(this.sResizeListenerFixFlexScroll);this.sResizeListenerFixFlexScroll=null}if(this.sResizeListenerFixFlexScrollFlexPart){t.deregister(this.sResizeListenerFixFlexScrollFlexPart);this.sResizeListenerFixFlexScrollFlexPart=null}if(this.sResizeListenerFixFlexContainerScroll){t.deregister(this.sResizeListenerFixFlexContainerScroll);this.sResizeListenerFixFlexContainerScroll=null}};s.prototype._changeScrolling=function(){var e,i,t=this.$(),l=this.getMinFlexSize(),r=this.getVertical();if(r){e=this.$().height()-this.$("Fixed").height();i="height"}else{e=this.$().width()-this.$("Fixed").width();i="width"}if(e<=parseInt(this.getMinFlexSize())){t.addClass("sapUiFixFlexScrolling");t.removeClass("sapUiFixFlexInnerScrolling");if(r){this._scroller.setVertical(true);this._innerScroller.setVertical(false)}else{this._scroller.setHorizontal(true);this._innerScroller.setHorizontal(false)}if(this.$("FlexibleContainer").children().height()>l){this.$("Flexible").attr("style","min-"+i+":"+l+"px")}else{this.$("Flexible").attr("style",i+":"+l+"px")}}else{t.addClass("sapUiFixFlexInnerScrolling");t.removeClass("sapUiFixFlexScrolling");if(r){this._scroller.setVertical(false);this._innerScroller.setVertical(true)}else{this._scroller.setHorizontal(false);this._innerScroller.setHorizontal(true)}this._changeFlexibleContainerScroll();this.$("Flexible").removeAttr("style")}};s.prototype._changeFlexibleContainerScroll=function(){var e=this.$("FlexibleContainer"),i=e.height(),t=e.children().height();if(i==t){return}if(i>t){e.removeClass("sapUiFixFlexFlexibleContainerGrowing")}else{e.addClass("sapUiFixFlexFlexibleContainerGrowing")}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/FixFlexRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,i){e.openStart("div",i).class("sapUiFixFlex");if(i.getMinFlexSize()!==0){e.class("sapUiFixFlexInnerScrolling")}if(!i.getVertical()){e.class("sapUiFixFlexRow")}e.openEnd();if(i.getFixFirst()){this.renderFixChild(e,i);this.renderFlexChild(e,i)}else{this.renderFlexChild(e,i);this.renderFixChild(e,i)}e.close("div")};e.renderFixChild=function(e,i){e.openStart("div",i.getId()+"-Fixed").class("sapUiFixFlexFixed");if(i.getFixContentSize()!=="auto"){if(i.getVertical()){e.style("height",i.getFixContentSize())}else{e.style("width",i.getFixContentSize())}}e.openEnd();i.getFixContent().forEach(e.renderControl,e);e.close("div")};e.renderFlexChild=function(e,i){e.openStart("div",i.getId()+"-Flexible").class("sapUiFixFlexFlexible").openEnd();e.openStart("div",i.getId()+"-FlexibleContainer").class("sapUiFixFlexFlexibleContainer");if(i.getMinFlexSize()!==0){if(i.getVertical()){e.style("min-height",i.getMinFlexSize()+"px")}else{e.style("min-width",i.getMinFlexSize()+"px")}}e.openEnd();e.renderControl(i.getFlexContent());e.close("div").close("div")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/Grid", ["sap/ui/core/Control","./library","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/base/ManagedObjectObserver","./GridRenderer","sap/ui/thirdparty/jquery"],function(e,t,i,s,a,n,jQuery){"use strict";var o=e.extend("sap.ui.layout.Grid",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},vSpacing:{type:"float",group:"Dimension",defaultValue:1},hSpacing:{type:"float",group:"Dimension",defaultValue:1},position:{type:"sap.ui.layout.GridPosition",group:"Dimension",defaultValue:"Left"},defaultSpan:{type:"sap.ui.layout.GridSpan",group:"Behavior",defaultValue:"XL3 L3 M6 S12"},defaultIndent:{type:"sap.ui.layout.GridIndent",group:"Behavior",defaultValue:"XL0 L0 M0 S0"},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/ui/layout/designtime/Grid.designtime"},renderer:n});(function(){o.prototype.init=function(){(()=>{var e=t.GridHelper.getLibrarySpecificClass();if(e){this.addStyleClass(e)}})();this._iBreakPointTablet=i.media._predefinedRangeSets[i.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=i.media._predefinedRangeSets[i.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=i.media._predefinedRangeSets[i.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];this._indentXLChanged=false;this._spanXLChanged=false;this._oObserver=new a(o.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["content"]})};o.prototype.onAfterRendering=function(){if(this.getContainerQuery()){this._sContainerResizeListener=s.register(this,jQuery.proxy(this._onParentResize,this));this._onParentResize()}else{this._attachMediaContainerWidthChange(this._handleMediaChange,this,i.media.RANGESETS.SAP_STANDARD_EXTENDED)}};o.prototype.onBeforeRendering=function(){this._cleanup()};o.prototype.exit=function(){this._cleanup();if(this._oObserver){this._oObserver.disconnect();this._oObserver=null}};o.prototype._cleanup=function(){if(this._sContainerResizeListener){s.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null}this._detachMediaContainerWidthChange(this._handleMediaChange,this,i.media.RANGESETS.SAP_STANDARD_EXTENDED)};o.prototype._observeVisibility=function(e){this._oObserver.observe(e,{properties:["visible"]})};o.prototype._unobserveVisibility=function(e){this._oObserver.unobserve(e,{properties:["visible"]})};o.prototype._observeChanges=function(e){var t=e.object,i=e.name,s=e.mutation,a=e.child;if(t===this){if(s==="insert"){this._observeVisibility(a)}else if(s==="remove"){this._unobserveVisibility(a)}}else if(i==="visible"){var n=this.getContent().indexOf(t);jQuery(this.$().children()[n]).toggleClass("sapUiRespGridSpanInvisible",!e.current)}};o.prototype._handleMediaChange=function(e){this._toggleClass(e.name)};o.prototype._setBreakPointTablet=function(e){this._iBreakPointTablet=e};o.prototype._setBreakPointDesktop=function(e){this._iBreakPointDesktop=e};o.prototype._setBreakPointLargeDesktop=function(e){this._iBreakPointLargeDesktop=e};o.prototype.setDefaultIndent=function(e){if(/XL/gi.test(e)){this._setIndentXLChanged(true)}return this.setProperty("defaultIndent",e)};o.prototype._setIndentXLChanged=function(e){this._indentXLChanged=e};o.prototype._getIndentXLChanged=function(){return this._indentXLChanged};o.prototype.setDefaultSpan=function(e){if(/XL/gi.test(e)){this._setSpanXLChanged(true)}return this.setProperty("defaultSpan",e)};o.prototype._setSpanXLChanged=function(e){this._spanXLChanged=e};o.prototype._getSpanXLChanged=function(){return this._spanXLChanged};o.prototype._onParentResize=function(){var e=this.getDomRef();if(!e){this._cleanup();return}if(!jQuery(e).is(":visible")){return}var t=e.clientWidth;if(t<=this._iBreakPointTablet){this._toggleClass("Phone")}else if(t>this._iBreakPointTablet&&t<=this._iBreakPointDesktop){this._toggleClass("Tablet")}else if(t>this._iBreakPointDesktop&&t<=this._iBreakPointLargeDesktop){this._toggleClass("Desktop")}else{this._toggleClass("LargeDesktop")}};o.prototype._toggleClass=function(e){var t=this.$();if(!t){return}if(t.hasClass("sapUiRespGridMedia-Std-"+e)){return}t.toggleClass("sapUiRespGridMedia-Std-"+e,true);if(e==="Phone"){t.toggleClass("sapUiRespGridMedia-Std-Desktop",false).toggleClass("sapUiRespGridMedia-Std-Tablet",false).toggleClass("sapUiRespGridMedia-Std-LargeDesktop",false)}else if(e==="Tablet"){t.toggleClass("sapUiRespGridMedia-Std-Desktop",false).toggleClass("sapUiRespGridMedia-Std-Phone",false).toggleClass("sapUiRespGridMedia-Std-LargeDesktop",false)}else if(e==="LargeDesktop"){t.toggleClass("sapUiRespGridMedia-Std-Desktop",false).toggleClass("sapUiRespGridMedia-Std-Phone",false).toggleClass("sapUiRespGridMedia-Std-Tablet",false)}else{t.toggleClass("sapUiRespGridMedia-Std-Phone",false).toggleClass("sapUiRespGridMedia-Std-Tablet",false).toggleClass("sapUiRespGridMedia-Std-LargeDesktop",false)}this.fireEvent("mediaChanged",{media:e})};o.prototype._getLayoutDataForControl=function(e){var t=e.getLayoutData();if(!t){return undefined}else if(t.isA("sap.ui.layout.GridData")){return t}else if(t.isA("sap.ui.core.VariantLayoutData")){var i=t.getMultipleLayoutData();for(var s=0;s<i.length;s++){var a=i[s];if(a&&a.isA("sap.ui.layout.GridData")){return a}}}};o.prototype.onLayoutDataChange=function(e){if(this.getDomRef()){this.invalidate()}};o.prototype._getAccessibleRole=function(){return null};o.prototype.getAccessibilityInfo=function(){return{children:this.getContent().filter(function(e){return e.$().is(":visible")})}}})();return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/GridData", ["sap/ui/core/LayoutData","./library","sap/base/Log"],function(e,t,n){"use strict";var a=e.extend("sap.ui.layout.GridData",{metadata:{library:"sap.ui.layout",properties:{span:{type:"sap.ui.layout.GridSpan",group:"Behavior",defaultValue:null},spanXL:{type:"int",group:"Behavior",defaultValue:null},spanL:{type:"int",group:"Behavior",defaultValue:null},spanM:{type:"int",group:"Behavior",defaultValue:null},spanS:{type:"int",group:"Behavior",defaultValue:null},indent:{type:"sap.ui.layout.GridIndent",group:"Behavior",defaultValue:null},indentXL:{type:"int",group:"Behavior",defaultValue:null},indentL:{type:"int",group:"Behavior",defaultValue:null},indentM:{type:"int",group:"Behavior",defaultValue:null},indentS:{type:"int",group:"Behavior",defaultValue:null},visibleXL:{type:"boolean",group:"Behavior",defaultValue:true},visibleL:{type:"boolean",group:"Behavior",defaultValue:true},visibleM:{type:"boolean",group:"Behavior",defaultValue:true},visibleS:{type:"boolean",group:"Behavior",defaultValue:true},moveBackwards:{type:"sap.ui.layout.GridIndent",group:"Misc",defaultValue:null},moveForward:{type:"sap.ui.layout.GridIndent",group:"Misc",defaultValue:null},linebreak:{type:"boolean",group:"Misc",defaultValue:false},linebreakXL:{type:"boolean",group:"Misc",defaultValue:false},linebreakL:{type:"boolean",group:"Misc",defaultValue:false},linebreakM:{type:"boolean",group:"Misc",defaultValue:false},linebreakS:{type:"boolean",group:"Misc",defaultValue:false},spanLarge:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},spanMedium:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},spanSmall:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},indentLarge:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},indentMedium:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},indentSmall:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},visibleOnLarge:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},visibleOnMedium:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},visibleOnSmall:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true}}}});(function(){a.prototype._setStylesInternal=function(e){if(e&&e.length>0){this._sStylesInternal=e}else{this._sStylesInternal=undefined}};a.prototype._getEffectiveSpanXLarge=function(){var e=this.getSpanXL();if(e&&e>0&&e<13){return e}var t=/XL([1-9]|1[0-2])(?:\s|$)/i;var n=t.exec(this.getSpan());if(n){var a=n[0];if(a){a=a.toUpperCase();if(a.substr(0,2)==="XL"){return parseInt(a.substr(2))}}}return undefined};a.prototype._getEffectiveSpanLarge=function(){var e=this.getSpanL();if(e&&e>0&&e<13){return e}var t=/\bL([1-9]|1[0-2])(?:\s|$)/i;var n=t.exec(this.getSpan());if(n){var a=n[0];if(a){a=a.toUpperCase();if(a.substr(0,1)==="L"){return parseInt(a.substr(1))}}}return undefined};a.prototype._getEffectiveSpanMedium=function(){var e=this.getSpanM();if(e&&e>0&&e<13){return e}var t=/M([1-9]|1[0-2])(?:\s|$)/i;var n=t.exec(this.getSpan());if(n){var a=n[0];if(a){a=a.toUpperCase();if(a.substr(0,1)==="M"){return parseInt(a.substr(1))}}}return undefined};a.prototype._getEffectiveSpanSmall=function(){var e=this.getSpanS();if(e&&e>0&&e<13){return e}var t=/S([1-9]|1[0-2])(?:\s|$)/i;var n=t.exec(this.getSpan());if(n){var a=n[0];if(a){a=a.toUpperCase();if(a.substr(0,1)==="S"){return parseInt(a.substr(1))}}}return undefined};a.prototype.init=function(){this._bLinebreakXLChanged=false};a.prototype.setLinebreakXL=function(e){this.setProperty("linebreakXL",e);this._bLinebreakXLChanged=true;return this};a.prototype._getLinebreakXLChanged=function(){return this._bLinebreakXLChanged};a.prototype.setSpanLarge=function(e){this.setSpanL(e);n.warning("Deprecated property spanLarge is used, please use spanL instead.");return this};a.prototype.setSpanMedium=function(e){n.warning("Deprecated property spanMedium is used, please use spanM instead.");return this.setSpanM(e)};a.prototype.setSpanSmall=function(e){n.warning("Deprecated property spanSmall is used, please use spanS instead.");return this.setSpanS(e)};a.prototype.setIndentLarge=function(e){n.warning("Deprecated property indentLarge is used, please use indentL instead.");return this.setIndentL(e)};a.prototype.setIndentMedium=function(e){n.warning("Deprecated property indentMedium is used, please use indentM instead.");return this.setIndentM(e)};a.prototype.setIndentSmall=function(e){n.warning("Deprecated property indentSmall is used, please use indentS instead.");return this.setIndentS(e)};a.prototype.setVisibleOnLarge=function(e){n.warning("Deprecated property visibleOnLarge is used, please use visibleL instead.");return this.setVisibleL(e)};a.prototype.setVisibleOnMedium=function(e){n.warning("Deprecated property visibleOnMedium is used, please use visibleM instead.");return this.setVisibleM(e)};a.prototype.setVisibleOnSmall=function(e){n.warning("Deprecated property visibleOnSmall is used, please use visibleS instead.");return this.setVisibleS(e)};a.prototype.getSpanLarge=function(){n.warning("Deprecated property spanLarge is used, please use spanL instead.");return this.getSpanL()};a.prototype.getSpanMedium=function(){n.warning("Deprecated property spanMedium is used, please use spanM instead.");return this.getSpanM()};a.prototype.getSpanSmall=function(){n.warning("Deprecated property spanSmall is used, please use spanS instead.");return this.getSpanS()};a.prototype.getIndentLarge=function(){n.warning("Deprecated property indentLarge is used, please use indentL instead.");return this.getIndentL()};a.prototype.getIndentMedium=function(){n.warning("Deprecated property indentMedium is used, please use indentM instead.");return this.getIndentM()};a.prototype.getIndentSmall=function(){n.warning("Deprecated property indentSmall is used, please use indentS instead.");return this.getIndentS()};a.prototype.getVisibleOnLarge=function(){n.warning("Deprecated property visibleOnLarge is used, please use visibleL instead.");return this.getVisibleL()};a.prototype.getVisibleOnMedium=function(){n.warning("Deprecated property visibleOnMedium is used, please use visibleM instead.");return this.getVisibleM()};a.prototype.getVisibleOnSmall=function(){n.warning("Deprecated property visibleOnSmall is used, please use visibleS instead.");return this.getVisibleS()}})();return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/GridRenderer", ["sap/ui/Device","sap/ui/layout/library"],function(e,s){"use strict";var a=s.GridPosition;var i={apiVersion:2};i.render=function(s,i){var r=/^([X][L](?:[0-9]|1[0-1]))? ?([L](?:[0-9]|1[0-1]))? ?([M](?:[0-9]|1[0-1]))? ?([S](?:[0-9]|1[0-1]))?$/i;var t=/^([X][L](?:[1-9]|1[0-2]))? ?([L](?:[1-9]|1[0-2]))? ?([M](?:[1-9]|1[0-2]))? ?([S](?:[1-9]|1[0-2]))?$/i;s.openStart("div",i);s.class("sapUiRespGrid");var p=i._getCurrentMediaContainerRange(e.media.RANGESETS.SAP_STANDARD_EXTENDED).name;s.class("sapUiRespGridMedia-Std-"+p);var n=i.getHSpacing();if(n===.5){n="05"}else if(n!==0&&n!==1&&n!==2){n=1}s.class("sapUiRespGridHSpace"+n);var l=i.getVSpacing();if(l===.5){l="05"}else if(l!==0&&l!==1&&l!==2){l=1}s.class("sapUiRespGridVSpace"+l);var d=i.getPosition();if(d){d=d.toUpperCase();if(d===a.Center.toUpperCase()){s.class("sapUiRespGridPosCenter")}else if(d===a.Right.toUpperCase()){s.class("sapUiRespGridPosRight")}}var f=i.getWidth();if(f!=="100%"&&f!=="auto"&&f!=="inherit"){if(n===0){s.style("width",f)}else{s.style("width","-webkit-calc("+f+" - "+n+"rem)");s.style("width","calc("+f+" - "+n+"rem)")}}var v=i._getAccessibleRole();var c;if(v){c={role:v}}s.accessibilityState(i,c);s.openEnd();var g=i.getContent();var o=i.getDefaultSpan();var L=["","XL3","L3","M6","S12"];var S=["","XL0","L0","M0","S0"];var U=t.exec(o);var u=i._getSpanXLChanged();var R=i._getIndentXLChanged();var G=i.getDefaultIndent();var b=r.exec(G);for(var X=0;X<g.length;X++){s.openStart("div",i.getId()+"-wrapperfor-"+g[X].getId());var h=i._getLayoutDataForControl(g[X]);var C=false;if(!g[X].getVisible()){s.class("sapUiRespGridSpanInvisible")}if(h){var I=false;if(h.getLinebreak()===true){s.class("sapUiRespGridBreak")}else{if(h.getLinebreakXL()===true){I=true;s.class("sapUiRespGridBreakXL")}if(h.getLinebreakL()===true){if(!I&&!h._getLinebreakXLChanged()){s.class("sapUiRespGridBreakXL")}s.class("sapUiRespGridBreakL")}if(h.getLinebreakM()===true){s.class("sapUiRespGridBreakM")}if(h.getLinebreakS()===true){s.class("sapUiRespGridBreakS")}}var M;var k;var y=h.getSpan();if(!y){M=U}else{M=t.exec(y);if(/XL/gi.test(y)){C=true}}if(M){for(var _=1;_<M.length;_++){var w=M[_];if(!w){w=U[_];if(!w){w=L[_]}}if(w.substr(0,1)==="L"){k=w.substr(1,2)}var B=h.getSpanXL();var D=h.getSpanL();var V=h.getSpanM();var x=h.getSpanS();w=w.toUpperCase();if(w.substr(0,2)==="XL"&&B>0&&B<13){s.class("sapUiRespGridSpanXL"+B);C=true}else if(w.substr(0,1)==="L"&&D>0&&D<13){s.class("sapUiRespGridSpanL"+D);k=D}else if(w.substr(0,1)==="M"&&V>0&&V<13){s.class("sapUiRespGridSpanM"+V)}else if(w.substr(0,1)==="S"&&x>0&&x<13){s.class("sapUiRespGridSpanS"+x)}else{if(w.substr(0,2)!=="XL"||u||C){s.class("sapUiRespGridSpan"+w)}}}if(!u&&!C){s.class("sapUiRespGridSpanXL"+k)}}var E;var H;var A=h.getIndent();if(!A||A.length==0){E=b}else{E=r.exec(A);if(/XL/gi.test(A)){R=true}}if(!E){E=b;if(!E){E=undefined}}var P=h.getIndentXL();var m=h.getIndentL();var F=h.getIndentM();var N=h.getIndentS();if(E){for(var _=1;_<E.length;_++){var T=E[_];if(!T){if(b&&b[_]){T=b[_]}else{T=S[_]}}if(T){T=T.toUpperCase();if(T.substr(0,1)==="L"){H=T.substr(1,2)}if(T.substr(0,2)==="XL"&&P>0&&P<12){s.class("sapUiRespGridIndentXL"+P);R=true}else if(T.substr(0,1)==="L"&&m>0&&m<12){s.class("sapUiRespGridIndentL"+m);H=m}else if(T.substr(0,1)==="M"&&F>0&&F<12){s.class("sapUiRespGridIndentM"+F)}else if(T.substr(0,1)==="S"&&N>0&&N<12){s.class("sapUiRespGridIndentS"+N)}else{if(!/^(XL0)? ?(L0)? ?(M0)? ?(S0)?$/.exec(T)){s.class("sapUiRespGridIndent"+T)}}}}if(!R){if(H&&H>0){s.class("sapUiRespGridIndentXL"+H)}}}if(!h.getVisibleXL()){s.class("sapUiRespGridHiddenXL")}if(!h.getVisibleL()){s.class("sapUiRespGridHiddenL")}if(!h.getVisibleM()){s.class("sapUiRespGridHiddenM")}if(!h.getVisibleS()){s.class("sapUiRespGridHiddenS")}var $=h.getMoveBackwards();if($&&$.length>0){var W=r.exec($);if(W){for(var _=1;_<W.length;_++){var j=W[_];if(j){s.class("sapUiRespGridBwd"+j.toUpperCase())}}}}var q=h.getMoveForward();if(q&&q.length>0){var z=r.exec(q);if(z){for(var _=1;_<z.length;_++){var J=z[_];if(J){s.class("sapUiRespGridFwd"+J.toUpperCase())}}}}if(typeof h._sStylesInternal==="string"){var K=h._sStylesInternal.split(" ");for(var O=0;O<K.length;O++){s.class(K[O])}}}if(!h){var w="";if(U){for(var _=1;_<U.length;_++){w=U[_];if(!w){if(_===1&&U[_+1]){w="X"+U[_+1]}else{w=L[_]}}s.class("sapUiRespGridSpan"+w.toUpperCase())}}else{for(var _=1;_<L.length;_++){w=L[_];s.class("sapUiRespGridSpan"+w.toUpperCase())}}var T="";if(b){for(var _=1;_<b.length;_++){T=b[_];if(!T){if(_===1&&b[_+1]){T="X"+b[_+1]}else{T=S[_]}}if(T.substr(0,1)!=="X"&&T.substr(1,1)!=="0"||T.substr(0,1)=="X"&&T.substr(2,1)!=="0"){s.class("sapUiRespGridIndent"+T.toUpperCase())}}}}s.openEnd();s.renderControl(g[X]);s.close("div")}s.close("div")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/HorizontalLayout", ["sap/ui/core/Control","./library","./HorizontalLayoutRenderer"],function(e,t,a){"use strict";var o=e.extend("sap.ui.layout.HorizontalLayout",{metadata:{library:"sap.ui.layout",properties:{allowWrapping:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},designtime:"sap/ui/layout/designtime/HorizontalLayout.designtime",dnd:{draggable:false,droppable:true}},renderer:a});o.prototype.getAccessibilityInfo=function(){return{children:this.getContent()}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/HorizontalLayoutRenderer", [],function(){"use strict";var r={apiVersion:2};r.render=function(r,a){var e=r;var n=!a.getAllowWrapping();e.openStart("div",a);e.class("sapUiHLayout");if(n){e.class("sapUiHLayoutNoWrap")}e.openEnd();var i=a.getContent();for(var t=0;t<i.length;t++){if(n){e.openStart("div");e.class("sapUiHLayoutChildWrapper");e.openEnd()}e.renderControl(i[t]);if(n){e.close("div")}}e.close("div")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/PaneContainer", ["./library","sap/ui/core/Element","./AssociativeSplitter","sap/ui/core/library"],function(t,e,i,n){"use strict";var r=n.Orientation;var o=e.extend("sap.ui.layout.PaneContainer",{metadata:{library:"sap.ui.layout",properties:{orientation:{type:"sap.ui.core.Orientation",group:"Behavior",defaultValue:r.Horizontal}},defaultAggregation:"panes",aggregations:{panes:{type:"sap.ui.core.Element",multiple:true,singularName:"pane"}},events:{resize:{parameters:{oldSizes:{type:"float[]"},newSizes:{type:"float[]"}}}}}});o.prototype.init=function(){this._oSplitter=new i({orientation:this.getOrientation(),height:"100%",resize:this._onSplitterResize.bind(this)})};o.prototype.exit=function(){this._oSplitter.destroy();this._oSplitter=null};o.prototype._onSplitterResize=function(t){this.fireResize({oldSizes:t.getParameter("oldSizes"),newSizes:t.getParameter("newSizes")})};o.prototype.setOrientation=function(t){this._oSplitter.setOrientation(t);return this.setProperty("orientation",t)};o.prototype._getPanesInInterval=function(t){return this.getPanes().filter(function(e){return e&&e.isA("sap.ui.layout.SplitPane")&&e._isInInterval(t)})};o.prototype.setLayoutData=function(t){this._oSplitter.setLayoutData(t);return this};o.prototype.getLayoutData=function(){return this._oSplitter.getLayoutData()};o.prototype.insertPane=function(t,e){var i=this.insertAggregation("panes",t,e),n={onAfterRendering:function(){this.triggerResize();this.removeEventDelegate(n)}};if(t instanceof o&&t._oSplitter){t._oSplitter.addEventDelegate(n,t._oSplitter)}return i};o.prototype.removePane=function(t){var e=this.removeAggregation("panes",t),i={onAfterRendering:function(){this.triggerResize();this.removeEventDelegate(i)}};this.getPanes().forEach(function(t){if(t instanceof o&&t._oSplitter){t._oSplitter.addEventDelegate(i,t._oSplitter)}});return e};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/ResponsiveFlowLayout", ["sap/ui/core/Configuration","sap/ui/core/Control","sap/ui/core/ResizeHandler","./library","./ResponsiveFlowLayoutData","./ResponsiveFlowLayoutRenderer","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/rect"],function(t,e,i,r,n,o,jQuery){"use strict";var a=e.extend("sap.ui.layout.ResponsiveFlowLayout",{metadata:{library:"sap.ui.layout",properties:{responsive:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}},renderer:o});(function(){a.prototype.init=function(){this._rows=[];this._bIsRegistered=false;this._proxyComputeWidths=l.bind(this);this._iRowCounter=0};a.prototype.exit=function(){delete this._rows;if(this._IntervalCall){clearTimeout(this._IntervalCall);this._IntervalCall=undefined}if(this._resizeHandlerComputeWidthsID){i.deregister(this._resizeHandlerComputeWidthsID)}delete this._resizeHandlerComputeWidthsID;delete this._proxyComputeWidths;if(this.oRm){this.oRm.destroy();delete this.oRm}delete this._$DomRef;delete this._oDomRef;delete this._iRowCounter};var r=function(t){var e=t.getContent();var i=[];var r=-1;var o={},a={};var s="";var h;var l=0,u=0,p=0;var f=false,g=false,c=false;for(var v=0;v<e.length;v++){l=n.MIN_WIDTH;u=n.WEIGHT;f=n.LINEBREAK;g=n.MARGIN;c=n.LINEBREAKABLE;h=d(e[v]);if(h instanceof n){f=h.getLinebreak();l=h.getMinWidth();u=h.getWeight();g=h.getMargin();c=h.getLinebreakable()}if(r<0||f){r++;i.push({height:-1,cont:[]})}p=i[r].cont.length;s=e[v].getId()+"-cont"+r+"_"+p;o={minWidth:l,weight:u,linebreakable:c,padding:g,control:e[v],id:s,breakWith:[]};var m=false;if(!c){for(var C=p;C>0;C--){a=i[r].cont[C-1];if(a.linebreakable){a.breakWith.push(o);m=true;break}}}if(!m){i[r].cont.push(o)}}t._rows=i};var o=function(e,i,r){var n=[];var o=1e7;var a=-1;var s=function(t){var i=jQuery(document.getElementById(e.cont[t].id));if(i.length>0){var r=i[0].offsetLeft;if(o>=r){n.push({cont:[]});a++}o=r;n[a].cont.push(e.cont[t])}};if(t.getRTL()){for(var h=e.cont.length-1;h>=0;h--){s(h)}}else{for(var h=0;h<e.cont.length;h++){s(h)}}return n};var s=function(t,e){var i=[];var r=-1;var n=0;var o=0;var a=0;var s=0,h=0;var l=0,d=0;for(l=0;l<t.cont.length;l++){n=0;o=0;for(d=a;d<=l;d++){o=o+t.cont[d].weight}for(d=a;d<=l;d++){s=e/o*t.cont[d].weight;s=Math.floor(s);h=t.cont[d].minWidth;n+=Math.max(s,h)}if(r==-1||n>e){i.push({cont:[]});if(r!==-1){a=l}r++}i[r].cont.push(t.cont[l])}return i};var h=function(t,e){if(t.length!=e.length){return true}for(var i=0;i<t.length;i++){if(t[i].cont.length!=e[i].cont.length){return true}}return false};a.prototype.renderContent=function(t,e){var i=t,r=0,n=[],o=0,a=0,s=0,h=0,l=0,d=0,u,p=0,f=0,g=[],c=[],v=this.getId(),m="",C=this._getRenderManager();for(o=0;o<i.length;o++){d=0;n.length=0;r=100;c.length=0;c.push("sapUiRFLRow");if(i[o].cont.length<=1){c.push("sapUiRFLCompleteRow")}var _=v+"-row"+this._iRowCounter;var R={};C.writeHeader(_,R,c);l=0;for(a=0;a<i[o].cont.length;a++){l+=i[o].cont[a].weight}for(s=0;s<i[o].cont.length;s++){u=i[o].cont[s];p=0;f=0;if(u.breakWith.length>0){p=u.weight;f=u.minWidth;for(var y=0;y<u.breakWith.length;y++){p+=u.breakWith[y].weight;f+=u.breakWith[y].minWidth}}m=i[o].cont[s].id;c.length=0;R={"min-width":u.breakWith.length>0?f:u.minWidth};d=100/l*u.weight;var w=R["min-width"]/e*100;var W=Math.ceil(w);var b=Math.floor(d);if(b!==100&&W>b){d=W}else{d=b}d=r<d?r:d;r-=d;n.push(d);if(r>0&&s===i[o].cont.length-1){d+=r}c.push("sapUiRFLContainer");R["width"]=d+"%";R["min-width"]=R["min-width"]+"px";C.writeHeader(m,R,c);c.length=0;c.push("sapUiRFLContainerContent");if(u.breakWith.length>0){c.push("sapUiRFLMultiContainerContent")}if(u.padding){c.push("sapUiRFLPaddingClass")}var I=this._addContentClass(u.control,s);if(I){c.push(I)}R={};C.writeHeader("",R,c);if(u.breakWith.length>0){m=i[o].cont[s].id+"-multi0";c.length=0;R={"min-width":f+"px"};var D=100/p*u.weight;D=Math.floor(D);g.push(D);c.push("sapUiRFLMultiContent");R["width"]=D+"%";if(i[o].cont[s].padding){c.push("sapUiRFLPaddingClass")}C.writeHeader(m,R,c);var L=D;C.renderControl(u.control);C.close("div");for(h=0;h<u.breakWith.length;h++){m=u.breakWith[h].id+"-multi"+(h+1);c.length=0;R={"min-width":u.breakWith[h].minWidth+"px"};D=100/p*u.breakWith[h].weight;D=Math.floor(D);g.push(D);L+=D;if(L<100&&h===u.breakWith.length-1){D+=100-L}c.push("sapUiRFLMultiContent");R["width"]=D+"%";if(u.breakWith[h].padding){c.push("sapUiRFLPaddingClass")}C.writeHeader(m,R,c);C.renderControl(u.breakWith[h].control);C.close("div")}}else{C.renderControl(u.control)}C.close("div");C.close("div")}C.close("div");this._iRowCounter++}};var l=function(){this._iRowCounter=0;this._oDomRef=this.getDomRef();if(this._oDomRef){var t=this.getId();var e=jQuery(this._oDomRef).width();var i=false;if(this._rows){for(var r=0;r<this._rows.length;r++){var n=jQuery(document.getElementById(t+"-row"+r));var a=s(this._rows[r],e);var l=o(this._rows[r],n,this);i=h(l,a);var d=this._getElementRect(n);var u=this._rows[r].oRect;if(d&&u){i=i||d.width!==u.width&&d.height!==u.height}if(this._bLayoutDataChanged||i){this._oDomRef.innerHTML="";this._bLayoutDataChanged=false;this.renderContent(a,e)}}if(this._oDomRef.innerHTML===""){this._getRenderManager().flush(this._oDomRef);for(var r=0;r<this._rows.length;r++){var p=this._getElementRect(jQuery(document.getElementById(t+"-row"+r)));this._rows[r].oRect=p}}}}};a.prototype.onBeforeRendering=function(){r(this)};a.prototype.onAfterRendering=function(){this._oDomRef=this.getDomRef();this._$DomRef=jQuery(this._oDomRef);this._proxyComputeWidths();if(this.getResponsive()){if(!this._resizeHandlerComputeWidthsID){this._resizeHandlerComputeWidthsID=i.register(this,a.prototype.rerender.bind(this))}}};a.prototype.onThemeChanged=function(t){if(t.type==="LayoutDataChange"){this._bLayoutDataChanged=true}if(this.getResponsive()&&!this._resizeHandlerComputeWidthsID){this._resizeHandlerComputeWidthsID=i.register(this,a.prototype.rerender.bind(this))}r(this);this._proxyComputeWidths()};a.prototype.setResponsive=function(t){e.prototype.setProperty.call(this,"responsive",t);if(t&&!this._resizeHandlerComputeWidthsID){this._resizeHandlerComputeWidthsID=i.register(this,a.prototype.rerender.bind(this))}else if(this._resizeHandlerComputeWidthsID){if(this._resizeHandlerComputeWidthsID){i.deregister(this._resizeHandlerComputeWidthsID);delete this._resizeHandlerComputeWidthsID}}return this};a.prototype.onLayoutDataChange=a.prototype.onThemeChanged;var d=function(t){var e=t.getLayoutData();if(!e){return undefined}else if(e instanceof n){return e}else if(e.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var i=e.getMultipleLayoutData();for(var r=0;r<i.length;r++){var o=i[r];if(o instanceof n){return o}}}};a.prototype.addContent=function(t){if(t&&this._IntervalCall){clearTimeout(this._IntervalCall);this._IntervalCall=undefined}this.addAggregation("content",t);return this};a.prototype.insertContent=function(t,e){if(t&&this._IntervalCall){clearTimeout(this._IntervalCall);this._IntervalCall=undefined}this.insertAggregation("content",t,e);return this};a.prototype.removeContent=function(t){if(t&&this._IntervalCall){clearTimeout(this._IntervalCall);this._IntervalCall=undefined}this.removeAggregation("content",t)};a.prototype._getAccessibleRole=function(){return null};a.prototype._addContentClass=function(t,e){return null};a.prototype._getElementRect=function(t){var e=t&&t.rect();if(e){e.height=e.height.toFixed(1);e.width=e.width.toFixed(1)}return e};a.prototype._getRenderManager=function(){if(!this.oRm){this.oRm=sap.ui.getCore().createRenderManager();this.oRm.writeHeader=function(t,e,i){this.openStart("div",t);if(e){for(var r in e){if(r==="width"&&e[r]==="100%"){this.class("sapUiRFLFullLength")}this.style(r,e[r])}}for(var n=0;n<i.length;n++){this.class(i[n])}this.openEnd()}}return this.oRm}})();return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/ResponsiveFlowLayoutData", ["sap/ui/core/LayoutData","./library","sap/base/Log"],function(e,t,a){"use strict";var i=e.extend("sap.ui.layout.ResponsiveFlowLayoutData",{metadata:{library:"sap.ui.layout",properties:{minWidth:{type:"int",group:"Misc",defaultValue:100},weight:{type:"int",group:"Misc",defaultValue:1},linebreak:{type:"boolean",group:"Misc",defaultValue:false},margin:{type:"boolean",group:"Misc",defaultValue:true},linebreakable:{type:"boolean",group:"Misc",defaultValue:true}}}});i.MIN_WIDTH=100;i.WEIGHT=1;i.LINEBREAK=false;i.MARGIN=true;i.LINEBREAKABLE=true;i.prototype.setWeight=function(e){if(e>=1){this.setProperty("weight",e)}else{a.warning("Values smaller than 1 are invalid. Default value '1' is used instead",this);this.setProperty("weight",i.WEIGHT)}return this};i.prototype.setLinebreak=function(e){if(this.getLinebreakable()==false&&e){a.warning("Setting 'linebreak' AND 'linebreakable' doesn't make any sense. Please set either 'linebreak' or 'linebreakable'",this)}else{this.setProperty("linebreak",e)}return this};i.prototype.setLinebreakable=function(e){if(this.getLinebreak()===true&&e===false){a.warning("Setting 'linebreak' AND 'linebreakable' doesn't make any sense. Please set either 'linebreak' or 'linebreakable'",this)}else{this.setProperty("linebreakable",e)}return this};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/ResponsiveFlowLayoutRenderer", [],function(){"use strict";var e={apiVersion:2};(function(){e.render=function(e,i){e.openStart("div",i);e.class("sapUiRFL");var n=i._getAccessibleRole();var t;if(n){t={role:n}}e.accessibilityState(i,t);e.openEnd();e.close("div")}})();return e},true);
/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/layout/ResponsiveSplitter", ["./library","./PaneContainer","./ResponsiveSplitterPage","./ResponsiveSplitterRenderer","./ResponsiveSplitterUtilities","./SplitPane","./Splitter","sap/ui/core/Core","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","sap/ui/core/ResizeHandler","sap/ui/core/RenderManager"],function(t,e,i,n,a,s,o,r,l,p,g,u){"use strict";var h=l.extend("sap.ui.layout.ResponsiveSplitter",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"}},defaultAggregation:"rootPaneContainer",aggregations:{rootPaneContainer:{type:"sap.ui.layout.PaneContainer",multiple:false},_pages:{type:"sap.ui.layout.ResponsiveSplitterPage",multiple:true,visibility:"hidden"}},associations:{defaultPane:{type:"sap.ui.layout.SplitPane",multiple:false}},events:{}},renderer:n});var d={MAX_VISIBLE_BUTTONS:7};h.prototype.init=function(){this._aPaneContainers=[];this._aPanes=[];this._oResourceBundle=r.getLibraryResourceBundle("sap.ui.layout");this._oItemNavigation=new p;this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._iDefaultPageIndex=0};h.prototype.onBeforeRendering=function(){var t=this.getRootPaneContainer();if(t){this._oSplitterDelegate=this._oSplitterDelegate||{onAfterRendering:function(){this._setSplitterBarsTooltips(t._oSplitter);this._updatePaginatorButtonsTooltips()}};t._oSplitter.addEventDelegate(this._oSplitterDelegate,this);this._createWidthIntervals();this._createPages();this._detachResizeHandler()}};h.prototype.onAfterRendering=function(){this._parentResizeHandler=g.register(this,this._onParentResize.bind(this));var t=this.getRootPaneContainer();if(t){this._onParentResize();this._updatePaginatorButtonsTooltips()}this._setItemNavigation()};h.prototype.exit=function(){this._detachResizeHandler();this._clearItemNavigation();this._oSplitterDelegate=null};h.prototype._setSplitterBarsTooltips=function(t,e){var i=t.$().find(" > .sapUiLoSplitterBar"),n=t.$().find(" > .sapUiLoSplitterContent"),a="",s,l,p,g;for(var u=0;u<n.length;u++){g=n[u].childNodes[0].id;p=r.byId(g);s=u+1;l=u+2;if(e){a+=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_RESIZE",[e+"."+s,e+"."+l])}else{a+=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_RESIZE",[s,l])}if(i[u]){i[u].setAttribute("title",a);a=""}if(p instanceof o){this._setSplitterBarsTooltips(p,s)}}};h.prototype._updatePaginatorButtonsTooltips=function(){var t=Array.prototype.slice.call(this._getVisibleButtons()),e=this.getRootPaneContainer()._oSplitter.getAssociatedContentAreas().length,i=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_HOME")+" ",n=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_AND"),a="",s=this,o;if(t.length>0){o=t.shift();for(var r=1;r<=e;r++){i+=r;if(r<e-1){i+=", "}else if(r===e-1){i+=" "+n+" "}}o.setAttribute("title",i);[].forEach.call(t,function(t){a=s._oResourceBundle.getText("RESPONSIVE_SPLITTER_GOTO")+" "+(e+1);e+=1;t.setAttribute("title",a)})}};h.prototype.onsapright=function(t){this._handleArrowNavigation(6,"Forward",t)};h.prototype.onsapleft=function(t){this._handleArrowNavigation(0,"Back",t)};h.prototype._setItemNavigation=function(){var t=this._getVisibleButtons(),e=[];this._oItemNavigation.setRootDomRef(this.$().find(".sapUiResponsiveSplitterPaginator")[0]);for(var i=0;i<t.length;i++){if(t[i]){e.push(t[i])}}this._oItemNavigation.setItemDomRefs(e);this._oItemNavigation.setFocusedIndex(this._iDefaultPageIndex)};h.prototype._clearItemNavigation=function(){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation};h.prototype._handleArrowNavigation=function(t,e,i){if(i.target===this._getVisibleButtons()[t]){this["_handlePaginator"+e](i);this._setItemNavigation()}else{return}};h.prototype._onParentResize=function(){var t=this._intervalHasChanged(),e=this.getRootPaneContainer();if(t&&e){this._arrangeContent();this._setPaginatorVisibility()}};h.prototype._detachResizeHandler=function(){if(this._parentResizeHandler){g.deregister(this._parentResizeHandler);this._parentResizeHandler=null}};h.prototype._createWidthIntervals=function(){var t=[];this._aIntervals=[];a.visitPanes(this.getRootPaneContainer(),function(e){var i=e.getRequiredParentWidth();if(t.indexOf(i)==-1){t.push(i)}});t.push(Number.NEGATIVE_INFINITY);t.push(Number.POSITIVE_INFINITY);t.sort(function(t,e){return t-e});for(var e=0;e<t.length-1;e++){var i=new a.splitterInterval(t[e],t[e+1],this.getRootPaneContainer());this._aIntervals.push(i)}};h.prototype._createPages=function(){var t=this._getMaxPageCount(),e=this.getAggregation("_pages")||[],n=e.length;if(n<t){while(n<t){n++;var a=new i;this.addAggregation("_pages",a,true)}}else if(n>t){while(n>t){n--;if(e[n].getDomRef()){u.preserveContent(e[n].getDomRef())}e[n].destroy()}}};h.prototype._intervalHasChanged=function(){var t=this.getDomRef().clientWidth,e=null,i=this._aIntervals;for(var n=0;n<i.length;n++){if(i[n].iFrom<t&&t<=i[n].iTo){e=i[n];break}}if(this._currentInterval!==e){this._currentInterval=e;return true}return false};h.prototype._setPaginatorVisibility=function(){var t=this.$().find(".sapUiResponsiveSplitterPaginatorButton"),e=this.$().find(".sapUiResponsiveSplitterPaginatorNavButton"),i=this.$().find(".sapUiResponsiveSplitterPaginator"),n=this._getHiddenPanes().length+1,a=this._getMaxPageCount(),s=n<d.MAX_VISIBLE_BUTTONS;t.addClass("sapUiResponsiveSplitterHiddenElement");if(a>1&&n>1){this.addStyleClass("sapUiRSVisiblePaginator");t=t.slice(0,s?n:d.MAX_VISIBLE_BUTTONS);t.removeClass("sapUiResponsiveSplitterHiddenElement");t.removeClass("sapUiResponsiveSplitterHiddenPaginatorButton");e.toggleClass("sapUiResponsiveSplitterHiddenPaginatorButton",s);i.toggleClass("sapUiResponsiveSplitterWithNavButtons",!s)}else{this.removeStyleClass("sapUiRSVisiblePaginator")}};h.prototype._getMaxPageCount=function(){var t=0;this._aIntervals.forEach(function(e){if(e.iPagesCount>t){t=e.iPagesCount}});return t};h.prototype._arrangeContent=function(){var t=this.getAggregation("_pages")||[],e=0,i=r.byId(this.getDefaultPane()),n,a,s;this._clearContent();t.forEach(function(t){t.setVisible(false)});this._fillPageContent(this.getRootPaneContainer());if(i){n=i.getContent();if(n){a=n.getId();for(s=0;s<t.length;s++){if(t[s].containsControl(a)){e=s;break}}}}this._iDefaultPageIndex=e;this._activatePage(e)};h.prototype._activatePage=function(t){var e=this.$().find(".sapUiResponsiveSplitterPaginatorButton"),i=this.$().find(".sapUiResponsiveSplitterPaginatorSelectedButton"),n=e.index(i),a=this.getAggregation("_pages")||[];a[n]&&a[n].setVisible(false);a[t]&&a[t].setVisible(true);i.removeClass("sapUiResponsiveSplitterPaginatorSelectedButton");e.eq(t).addClass("sapUiResponsiveSplitterPaginatorSelectedButton");i.attr("aria-selected",false);e.eq(t).attr("aria-selected",true)};h.prototype._fillPageContent=function(t){var i=t instanceof e,n=t instanceof s,a=t.getParent(),o=a instanceof e,r=this.getAggregation("_pages"),l,p,g,u,h,d;if(i&&r){this._aPaneContainers.push(t);p=this._getAllPanesInInterval(t,this._currentInterval.iFrom).length>0;g=t._oSplitter;if(o&&p){a._oSplitter.addAssociatedContentArea(g)}else if(!o){r[0].setContent(g)}t.getPanes().forEach(function(t){this._fillPageContent(t)},this)}else if(n&&r){this._assignDefault(t);this._aPanes.push(t);u=t.getDemandPane();l=this._getHiddenPanes();h=l.length;d=this._getMaxPageCount();var f;if(t._isInInterval(this._currentInterval.iFrom)){a._oSplitter.addAssociatedContentArea(t.getContent())}else if(u&&h<d){for(f=0;f<h;f++){r[f+1].setContent(l[f].getContent())}}else if(u&&h===d){for(f=0;f<h;f++){r[f].setContent(l[f].getContent())}}else if(this._isDefault(t)){r[0].setContent(t.getContent())}}};h.prototype._isDefault=function(t){return this.getDefaultPane()===t.getId()};h.prototype._assignDefault=function(t){var e=this.getDefaultPane();this.setDefaultPane(e||t)};h.prototype._getAllPanesInInterval=function(t,i){var n=[];function a(t){t.getPanes().forEach(function(t){if(t instanceof e){a(t)}else if(t._isInInterval(i)){n.push(t)}});return n}return a(t,i)};h.prototype._getHiddenPanes=function(){return this._aPanes.filter(function(t){return t.getDemandPane()&&!t._isInInterval(this._currentInterval.iFrom)},this)};h.prototype._clearContent=function(){this._aPaneContainers.forEach(function(t){t._oSplitter.removeAllAssociatedContentAreas()});this._aPaneContainers=[];this._aPanes=[]};h.prototype._getVisibleButtons=function(){return this.$().find(".sapUiResponsiveSplitterPaginatorButton:not(.sapUiResponsiveSplitterHiddenElement, .sapUiResponsiveSplitterHiddenPaginatorButton)")};h.prototype._handlePaginatorButtonTap=function(t){var e=t.target,i=t.target.classList,n;if(i&&i.contains("sapUiResponsiveSplitterPaginatorButton")){n=parseInt(e.getAttribute("page-index"));this._activatePage(n)}else if(i&&i.contains("sapUiResponsiveSplitterPaginatorNavButton")){if(i.contains("sapUiResponsiveSplitterPaginatorButtonForward")){this._handlePaginatorForward(t)}else{this._handlePaginatorBack(t)}}};h.prototype._handlePaginatorForward=function(t){var e=this._getVisibleButtons(),i=this._getHiddenPanes().length,n=this.$().find(".sapUiResponsiveSplitterPaginatorButton.sapUiResponsiveSplitterHiddenElement"),a,s=n.filter(function(){a=parseInt(this.getAttribute("page-index"));return a>=d.MAX_VISIBLE_BUTTONS&&a<=i});if(s.length>0){e.first().addClass("sapUiResponsiveSplitterHiddenElement");s.last().removeClass("sapUiResponsiveSplitterHiddenElement")}};h.prototype._handlePaginatorBack=function(t){var e=this._getVisibleButtons(),i=this._getMaxPageCount()-d.MAX_VISIBLE_BUTTONS,n=this.$().find(".sapUiResponsiveSplitterPaginatorButton.sapUiResponsiveSplitterHiddenElement"),a=n.filter(function(){return parseInt(this.getAttribute("page-index"))<i});if(a.length>0){e.last().addClass("sapUiResponsiveSplitterHiddenElement");a.last().removeClass("sapUiResponsiveSplitterHiddenElement")}};h.prototype.ontap=h.prototype._handlePaginatorButtonTap;h.prototype.onsapenter=h.prototype._handlePaginatorButtonTap;h.prototype.onsapspace=h.prototype._handlePaginatorButtonTap;return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/ResponsiveSplitterPage", ["./library","sap/ui/core/Control","sap/ui/core/Core"],function(t,e,n){"use strict";var i=e.extend("sap.ui.layout.ResponsiveSplitterPage",{metadata:{library:"sap.ui.layout",associations:{content:{type:"sap.ui.core.Control",multiple:false,singularName:"content"}}},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e).class("sapUiResponsiveSplitterPage").openEnd();var i=n.byId(e.getAssociation("content"));if(i){t.renderControl(i)}t.close("div")}}});i.prototype.containsControl=function(t){var e=n.byId(this.getAssociation("content"));if(!e){return false}if(e.isA("sap.ui.layout.AssociativeSplitter")){return e.containsControl(t)}return e.getId()===t};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/ResponsiveSplitterRenderer", ["sap/ui/core/Core","sap/ui/core/IconPool"],function(t,e){"use strict";var a=t.getLibraryResourceBundle("sap.ui.layout");var i={apiVersion:2};e.insertFontFaceStyle();i.render=function(t,e){t.openStart("div",e).class("sapUiResponsiveSplitter").style("width",e.getWidth()).style("height",e.getHeight()).openEnd();var a=e.getAggregation("_pages");if(a){a.forEach(t.renderControl,t);this.renderPaginator(t,e)}t.close("div")};i.renderPaginator=function(t,e){var i=e._getMaxPageCount(),s=e.getAggregation("_pages")||[];if(i<=1){return}t.openStart("div").attr("role","navigation").class("sapUiResponsiveSplitterPaginator").openEnd();t.openStart("div").class("sapUiResponsiveSplitterPaginatorNavButton").class("sapUiResponsiveSplitterHiddenPaginatorButton").class("sapUiResponsiveSplitterPaginatorButtonBack").openEnd().close("div");t.openStart("div").class("sapUiResponsiveSplitterPaginatorButtons").attr("role","listbox").attr("aria-multiselectable",true).attr("aria-label",a.getText("RESPONSIVE_SPLITTER_ARIA_PAGINATOR_LABEL"));if(s.length>0){t.attr("aria-controls",s[0].getParent().getId())}t.openEnd();for(var n=0;n<i;n++){t.openStart("div").attr("tabindex",0).attr("page-index",n);if(n===0){t.class("sapUiResponsiveSplitterPaginatorSelectedButton")}t.class("sapUiResponsiveSplitterHiddenElement").class("sapUiResponsiveSplitterPaginatorButton").attr("role","option").attr("aria-selected",false).openEnd().close("div")}t.close("div");t.openStart("div").class("sapUiResponsiveSplitterPaginatorNavButton").class("sapUiResponsiveSplitterHiddenPaginatorButton").class("sapUiResponsiveSplitterPaginatorButtonForward").openEnd().close("div");t.close("div")};return i},true);
/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/layout/ResponsiveSplitterUtilities", [],function(){"use strict";var e={};e.visitPanes=function(i,t){var n,s;if(!i){return}n=i.getPanes();for(var a=0;a<n.length;a++){s=n[a];if(s&&s.isA("sap.ui.layout.SplitPane")){t(s)}else{e.visitPanes(s,t)}}};e.splitterInterval=function(i,t,n){this.iFrom=i;this.iTo=t;this.iPagesCount=0;var s=[],a=[s];e.visitPanes(n,function(e){var t=e.getRequiredParentWidth();var n={demandPane:e.getDemandPane()};if(t<=i){s.push(n)}else{a.push(n)}});if(s.length==0){a.splice(0,1)}this.iPagesCount=a.length;this.aPages=a};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/SplitPane", ["./library","sap/ui/core/Element"],function(t,e){"use strict";var a=e.extend("sap.ui.layout.SplitPane",{metadata:{library:"sap.ui.layout",properties:{demandPane:{type:"boolean",group:"Behavior",defaultValue:true},requiredParentWidth:{type:"int",defaultValue:800}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:false,singularName:"content"}}}});a.prototype.setLayoutData=function(t){var e=this.getContent();if(e){return e.setLayoutData(t)}this._oLayoutData=t;return this};a.prototype.getLayoutData=function(){var t=this.getContent();if(t){return t.getLayoutData()}return this._oLayoutData};a.prototype.setContent=function(t){if(this._oLayoutData){t.setLayoutData(this._oLayoutData);this._oLayoutData=null}return this.setAggregation("content",t)};a.prototype.onLayoutDataChange=function(){var t=this.getParent();if(t){t._oSplitter._delayedResize()}};a.prototype._isInInterval=function(t){return this.getRequiredParentWidth()<=t};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/Splitter", ["sap/ui/core/Control","sap/ui/core/CustomData","./library","sap/ui/core/library","sap/ui/core/ResizeHandler","sap/ui/core/RenderManager","./SplitterRenderer","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/layout/SplitterLayoutData","sap/ui/core/Configuration"],function(e,t,i,r,s,a,o,n,jQuery,h,u){"use strict";var l=r.Orientation;var d=16;var c=e.extend("sap.ui.layout.Splitter",{metadata:{library:"sap.ui.layout",properties:{orientation:{type:"sap.ui.core.Orientation",group:"Behavior",defaultValue:l.Horizontal},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"}},defaultAggregation:"contentAreas",aggregations:{contentAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"contentArea"}},events:{resize:{parameters:{id:{type:"string"},oldSizes:{type:"int[]"},newSizes:{type:"int[]"}}}},designtime:"sap/ui/layout/designtime/Splitter.designtime"},renderer:o});c.prototype.init=function(){this._liveResize=true;this._keyboardEnabled=true;this._bHorizontal=true;this._calculatedSizes=[];this._move={};this._resizeTimeout=null;this._resizeCallback=function(e){this._delayedResize(0)}.bind(this);this._resizeHandlerId=null;this._autoResize=true;this.enableAutoResize();this._boundBarMoveEnd=this._onBarMoveEnd.bind(this);this._boundBarMove=this._onBarMove.bind(this);this._initOrientationProperties();this._bRtl=u.getRTL();this._keyListeners={increase:this._onKeyboardResize.bind(this,"inc",20),decrease:this._onKeyboardResize.bind(this,"dec",20),increaseMore:this._onKeyboardResize.bind(this,"incMore",20),decreaseMore:this._onKeyboardResize.bind(this,"decMore",20),max:this._onKeyboardResize.bind(this,"max",20),min:this._onKeyboardResize.bind(this,"min",20)};this._enableKeyboardListeners()};c.prototype.exit=function(){this.disableAutoResize();delete this._resizeCallback;delete this._boundBarMoveEnd;delete this._boundBarMove;delete this._$SplitterOverlay;delete this._$SplitterOverlayBar};c.prototype.onBeforeRendering=function(){this._initOrientationProperties()};c.prototype.onAfterRendering=function(){this._$SplitterOverlay=this.$("overlay");this._$SplitterOverlayBar=this.$("overlayBar");this._resize()};c.prototype.triggerResize=function(e){if(e){this._resize()}else{this._delayedResize()}};c.prototype.resetContentAreasSizes=function(){var e=this._getContentAreas();for(var t=0;t<e.length;t++){e[t].getLayoutData().setSize("auto")}};c.prototype.getCalculatedSizes=function(){return this._calculatedSizes};c.prototype.enableAutoResize=function(e){if(e&&!this._autoResize){return}this._autoResize=true;var t=this;sap.ui.getCore().attachInit(function(){t._resizeHandlerId=s.register(t,t._resizeCallback)});this._delayedResize()};c.prototype.disableAutoResize=function(e){s.deregister(this._resizeHandlerId);if(!e){this._autoResize=false}};c.prototype.enableLiveResize=function(){this._liveResize=true;this.removeStyleClass("sapUiLoSplitterAnimated")};c.prototype.disableLiveResize=function(){this._liveResize=false;this.addStyleClass("sapUiLoSplitterAnimated")};c.prototype.enableKeyboardSupport=function(){var e=this.$().find(".sapUiLoSplitterBar");e.attr("tabindex","0");this._enableKeyboardListeners()};c.prototype.disableKeyboardSupport=function(){var e=this.$().find(".sapUiLoSplitterBar");e.attr("tabindex","-1");this._disableKeyboardListeners()};c.prototype.onLayoutDataChange=function(){this._delayedResize()};c.prototype.ontouchstart=function(e){if(this._ignoreTouch){return}var t=this._getBar(e.target);if(!t){return}if(!e.changedTouches||!e.changedTouches[0]){return}this._ignoreMouse=true;this._onBarMoveStart(e.changedTouches[0],t,true)};c.prototype.onmousedown=function(e){if(this._ignoreMouse){return}var t=this._getBar(e.target);if(!t){return}this._ignoreTouch=true;this._onBarMoveStart(e,t);this._oLastDOMclicked=t};c.prototype._onBarMoveStart=function(e,t,i){var r=this.getId();this.disableAutoResize(true);var s=e[this._moveCord];var a=parseInt(t.id.substr((r+"-splitbar-").length));var o=jQuery(t);var n=this.getCalculatedSizes();var h=this._bHorizontal?o.outerWidth():o.outerHeight();var u=this._getContentAreas();var l=u[a].getLayoutData();var d=u[a+1].getLayoutData();if(!l.getResizable()||!d.getResizable()){v(i);return}var c=0-h;for(var p=0;p<=a;++p){c+=n[p]+h}this._move={start:s,relStart:c,barNum:a,$bar:o,c1Size:n[a],c1MinSize:l.getMinSize(),c2Size:n[a+1],c2MinSize:d.getMinSize()};if(i){document.addEventListener("touchend",this._boundBarMoveEnd);document.addEventListener("touchmove",this._boundBarMove)}else{document.addEventListener("mouseup",this._boundBarMoveEnd);document.addEventListener("mousemove",this._boundBarMove)}this._$SplitterOverlay.css("display","block");this._$SplitterOverlayBar.css(this._sizeDirNot,"");this._move.$bar.css("visibility","hidden");this._onBarMove(e)};c.prototype._onBarMove=function(e){if(e.preventDefault&&!e.changedTouches){e.preventDefault()}var t=e;if(e.changedTouches&&e.changedTouches[0]){t=t.changedTouches[0]}var i=t[this._moveCord];var r=i-this._move.start;if(this.getOrientation()==l.Horizontal&&this._bRtl){r=-r}var s=this._move.c1Size+r;var a=this._move.c2Size-r;var o=s>=0&&a>=0&&s>=this._move.c1MinSize&&a>=this._move.c2MinSize;if(o){this._$SplitterOverlayBar.css(this._sizeDir,this._move.relStart+r);if(this._liveResize){var n=this._move["start"]-t[this._moveCord];if(this.getOrientation()==l.Horizontal&&this._bRtl){n=-n}this._resizeContents(this._move["barNum"],-n,false)}}};c.prototype._onBarMoveEnd=function(e){this._ignoreMouse=false;this._ignoreTouch=false;var t=e;if(e.changedTouches&&e.changedTouches[0]){t=t.changedTouches[0]}var i=t[this._moveCord];var r=this._move["start"]-i;if(this.getOrientation()==l.Horizontal&&this._bRtl){r=-r}this._resizeContents(this._move["barNum"],-r,true);this._move.$bar.css("visibility","");this._$SplitterOverlay.css("display","");document.removeEventListener("mouseup",this._boundBarMoveEnd);document.removeEventListener("mousemove",this._boundBarMove);document.removeEventListener("touchend",this._boundBarMoveEnd);document.removeEventListener("touchmove",this._boundBarMove);this.enableAutoResize(true);if(this._move.$bar){this._move.$bar.trigger("focus")}};c.prototype._resizeContents=function(e,t,i){if(isNaN(t)){n.warning("Splitter: Received invalid resizing values - resize aborted.");return}var r=this._getContentAreas();var s=r[e].getLayoutData();var a=r[e+1].getLayoutData();var o=s.getSize();var h=a.getSize();var u=this.$("content-"+e);var l=this.$("content-"+(e+1));var d=parseFloat(this._move.c1Size).toFixed(5);var c=parseFloat(this._move.c2Size).toFixed(5);var p=parseFloat(d)+t;var v=parseFloat(c)-t;var _=parseInt(s.getMinSize());var f=parseInt(a.getMinSize());var g,z;var y;if(p<_){y=_-p;t+=y;p=_;v-=y}else if(v<f){y=f-v;t-=y;v=f;p-=y}if(i){var b=this._calcAvailableContentSize();if(o==="auto"&&h!=="auto"){z=this._calcAreaSizeWithUnit(v,b,a._getSizeUnit());a.setSize(z);a._markModified()}else if(o!=="auto"&&h==="auto"){g=this._calcAreaSizeWithUnit(p,b,s._getSizeUnit());s.setSize(g);s._markModified()}else{g=this._calcAreaSizeWithUnit(p,b,s._getSizeUnit());z=this._calcAreaSizeWithUnit(v,b,a._getSizeUnit());s.setSize(g);a.setSize(z);s._markModified();a._markModified()}}else{var S=this._getTotalSize();g=this._pxToPercent(p,S);z=this._pxToPercent(v,S);u.css(this._sizeType,g);l.css(this._sizeType,z)}};c.prototype._calcAreaSizeWithUnit=function(e,t,i){if(i==="px"){return e+"px"}if(i==="rem"){return e/d+"rem"}return this._pxToPercent(e,t)};c.prototype._pxToPercent=function(e,t){return e*100/t+"%"};c.prototype._delayedResize=function(e){if(e===undefined){e=0}if(this.getDomRef()){clearTimeout(this._resizeTimeout);this._resizeTimeout=setTimeout(this._resize.bind(this),e)}};c.prototype._resizeBars=function(e){var t,i,r=this._bHorizontal?this.$().innerHeight():this.$().innerWidth();for(t=0;t<e.length-1;++t){i=this.$("splitbar-"+t);i.css(this._sizeTypeNot,"")}for(t=0;t<e.length-1;++t){i=this.$("splitbar-"+t);i.css(this._sizeType,"");i.css(this._sizeTypeNot,r+"px")}};c.prototype._resize=function(){var e=this.getDomRef();if(!e||a.getPreserveAreaRef().contains(e)||e.scrollHeight===0||e.scrollWidth===0){return}var t=0,i;var r=this._getContentAreas();this._resizeBars(r);var s=this.getCalculatedSizes();this._recalculateSizes();var o=this.getCalculatedSizes();var n=false;for(t=0;t<o.length;++t){if(o[t]!==0){n=true;break}}if(!n){this._delayedResize(100);return}var h=true;for(t=0;t<r.length;++t){var u=this.$("content-"+t);var l=r[t];u.css(this._sizeType,o[t]+"px");u.css(this._sizeTypeNot,"");var d=l.getLayoutData();var c=d&&d.getResizable();if(t>0){var v=c&&h;i=this.$("splitbar-"+(t-1));i.toggleClass("sapUiLoSplitterNoResize",!v);i.attr("tabindex",v&&this._keyboardEnabled?"0":"-1")}h=c}this._resizeBars(r);if(p(s,o)){this.fireResize({oldSizes:s,newSizes:o})}};c.prototype._getTotalSize=function(){return this._bHorizontal?this.$().innerWidth():this.$().innerHeight()};c.prototype._calcAvailableContentSize=function(){return this._getTotalSize()-this._calcBarsSize()};c.prototype._calcBarsSize=function(){var e=0,t=this._getContentAreas().length-1;for(var i=0;i<t;i++){e+=this._bHorizontal?this.$("splitbar-"+i).outerWidth():this.$("splitbar-"+i).outerHeight()}return e};c.prototype._recalculateSizes=function(){var e,t,i,r;var s=[];var a=this._getContentAreas();var o=this._calcAvailableContentSize();var h=[];var u=[];var l=[];this._calculatedSizes=[];for(e=0;e<a.length;++e){s.push(a[e].getLayoutData().getSize())}for(e=0;e<s.length;++e){var c=s[e];var p;if(c.indexOf("rem")>-1){p=parseFloat(c)*d;o-=p;this._calculatedSizes[e]=p}else if(c.indexOf("px")>-1){p=parseInt(c);o-=p;this._calculatedSizes[e]=p}else if(c.indexOf("%")>-1){l.push(e)}else if(c==="auto"){if(a[e].getLayoutData().getMinSize()!==0){u.push(e)}else{h.push(e)}}else{n.error("Illegal size value: "+s[e])}}var v=false;if(o<0){v=true;o=0}o=this._calcPercentBasedSizes(l,o);if(o<0){v=true;o=0}var _=Math.floor(o/(u.length+h.length),0);for(e=0;e<u.length;++e){t=_;i=u[e];r=a[i].getLayoutData().getMinSize();if(t>o){t=o}if(t<r){t=r}this._calculatedSizes[i]=t;o-=t}if(o<0){v=true;o=0}var f=h.length;_=Math.floor(o/f,0);for(e=0;e<f;++e){i=h[e];this._calculatedSizes[i]=_;o-=_}if(v){this._logConstraintsViolated()}};c.prototype._calcPercentBasedSizes=function(e,t){var i=this._getContentAreas(),r=this._calcAvailableContentSize();for(let n=0;n<e.length;++n){var s=e[n];var a=parseFloat(i[s].getLayoutData().getSize())/100*r;var o=i[s].getLayoutData().getMinSize();if(a<o){a=o}this._calculatedSizes[s]=a;t-=a}var n=i.filter(function(e){return e.getLayoutData().getSize()==="auto"}).reduce(function(e,t){return e+t.getLayoutData().getMinSize()},0);if(t<n){var h=Math.abs(t-n);for(var u=e.length-1;u>=0;u--){var l=e[u],d=i[l],c=this._calculatedSizes[l],p=d.getLayoutData();if(p._isMarked()){var v=c-h;if(v<p.getMinSize()){v=p.getMinSize()}this._calculatedSizes[l]=v;var _=c-v;h-=_;t+=_}if(h<=0){break}}}return t};c.prototype._logConstraintsViolated=function(){n.warning("The set sizes and minimal sizes of the splitter contents are bigger than the available space in the UI.",null,"sap.ui.layout.Splitter")};c.prototype._initOrientationProperties=function(){this._bHorizontal=this.getOrientation()===l.Horizontal;if(this._bHorizontal){this._sizeDirNot="top";this._sizeTypeNot="height";this._sizeType="width";this._moveCord="pageX";if(this._bRtl){this._sizeDir="right"}else{this._sizeDir="left"}}else{this._moveCord="pageY";this._sizeType="height";this._sizeTypeNot="width";this._sizeDir="top";this._sizeDirNot="left"}};c.prototype._onKeyboardResize=function(e,t,i){var r=this.getId()+"-splitbar-";if(!i||!i.target||!i.target.id||i.target.id.indexOf(r)!==0){return}var s=999999;var a=parseInt(i.target.id.substr(r.length));var o=this.getCalculatedSizes();this._move.c1Size=o[a];this._move.c2Size=o[a+1];var h=0;switch(e){case"inc":h=t;break;case"incMore":h=t*10;break;case"dec":h=0-t;break;case"decMore":h=0-t*10;break;case"max":h=s;break;case"min":h=0-s;break;default:n.warn("[Splitter] Invalid keyboard resize type");break}this._resizeContents(a,h,true)};c.prototype._enableKeyboardListeners=function(){this.onsapright=this._keyListeners.increase;this.onsapdown=this._keyListeners.increase;this.onsapleft=this._keyListeners.decrease;this.onsapup=this._keyListeners.decrease;this.onsappageup=this._keyListeners.decreaseMore;this.onsappagedown=this._keyListeners.increaseMore;this.onsapend=this._keyListeners.max;this.onsaphome=this._keyListeners.min;this._keyboardEnabled=true};c.prototype._disableKeyboardListeners=function(){delete this.onsapincreasemodifiers;delete this.onsapdecreasemodifiers;delete this.onsapendmodifiers;delete this.onsaphomemodifiers;this._keyboardEnabled=false};c.prototype._getBar=function(e){var t=e,i=this.getId();if(t.classList.contains("sapUiLoSplitterBarGripIcon")){t=e.parentElement}if(t.classList.contains("sapUiLoSplitterBarDecorationBefore")||t.classList.contains("sapUiLoSplitterBarDecorationAfter")||t.classList.contains("sapUiLoSplitterBarGrip")){t=t.parentElement}if(!t.id||t.id.indexOf(i+"-splitbar")!==0){return null}return t};function p(e,t){if(e===t){return false}if(!e||!t||e.length===undefined||t.length===undefined){return true}if(e.length!=t.length){return true}for(var i=0;i<e.length;++i){if(e[i]!==t[i]){return true}}return false}function v(e){var t=function(t){if(!e){t.preventDefault()}};var i=null;i=function(){document.removeEventListener("touchend",i);document.removeEventListener("touchmove",t);document.removeEventListener("mouseup",i);document.removeEventListener("mousemove",t)};if(e){this._ignoreMouse=true;document.addEventListener("touchend",i);document.addEventListener("touchmove",t)}else{document.addEventListener("mouseup",i);document.addEventListener("mousemove",t)}}c.prototype._ensureLayoutData=function(e){var t=e.getLayoutData();if(t&&(!t.getResizable||!t.getSize||!t.getMinSize)){n.warning('Content "'+e.getId()+'" for the Splitter contained wrong LayoutData. '+"The LayoutData has been replaced with default values.");t=null}if(!t){e.setLayoutData(new h)}};c.prototype.invalidate=function(i){var r=i&&this.indexOfContentArea(i)!=-1||i&&i instanceof t&&i.getWriteToDom()||i===undefined;if(r){e.prototype.invalidate.apply(this,arguments)}};c.prototype.addContentArea=function(e){this._ensureLayoutData(e);return this.addAggregation("contentAreas",e)};c.prototype.insertContentArea=function(e,t){this._ensureLayoutData(e);return this.insertAggregation("contentAreas",e,t)};c.prototype._getContentAreas=function(){return this.getContentAreas()};return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/SplitterLayoutData", ["sap/ui/core/LayoutData","./library"],function(e,t){"use strict";var i=e.extend("sap.ui.layout.SplitterLayoutData",{metadata:{library:"sap.ui.layout",properties:{resizable:{type:"boolean",group:"Behavior",defaultValue:true},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},minSize:{type:"int",group:"Dimension",defaultValue:0}}}});i.prototype.init=function(){e.prototype.init.apply(this,arguments);this._bIsModified=false};i.prototype._markModified=function(){this._bIsModified=true};i.prototype._isMarked=function(){return this._bIsModified};i.prototype._getSizeUnit=function(){const e=this.getSize();if(e.includes("px")){return"px"}if(e.includes("rem")){return"rem"}if(e.includes("%")){return"%"}return"auto"};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/SplitterRenderer", ["sap/ui/core/library","sap/ui/core/Core","sap/ui/core/Configuration"],function(e,t,i){"use strict";var r=e.Orientation;var a=t.getLibraryResourceBundle("sap.ui.layout");var o={apiVersion:2};o.render=function(e,t){var a=t.getOrientation()===r.Horizontal,o=a?"sapUiLoSplitterH":"sapUiLoSplitterV",n=i.getAnimationMode(),s=n!==i.AnimationMode.none&&n!==i.AnimationMode.minimal;e.openStart("div",t).class("sapUiLoSplitter").class(o);if(s&&!t._liveResize){e.class("sapUiLoSplitterAnimated")}e.style("width",t.getWidth()).style("height",t.getHeight()).openEnd();this.renderContentAreas(e,t);e.close("div")};o.renderContentAreas=function(e,t){var i=t.getId(),a=t.getOrientation()===r.Horizontal,n=a?"width":"height",s=t._getContentAreas(),p=s.length,l=t.getCalculatedSizes();s.forEach(function(r,s){var d=r.getLayoutData(),c="0";if(l[s]){c=l[s]+"px"}else if(d){c=d.getSize()}e.openStart("section",i+"-content-"+s).style(n,c).class("sapUiLoSplitterContent").openEnd();e.renderControl(r);e.close("section");if(s<p-1){o.renderBar(e,a,t.getId()+"-splitbar-"+s,"sapUiLoSplitterBar")}});e.openStart("div",i+"-overlay").class("sapUiLoSplitterOverlay").openEnd();o.renderBar(e,a,i+"-overlayBar","sapUiLoSplitterOverlayBar");e.close("div")};o.renderBar=function(e,t,i,r){e.openStart("div",i).attr("role","separator").attr("title",a.getText("SPLITTER_MOVE")).attr("aria-orientation",t?"vertical":"horizontal").attr("tabindex",0).class(r).openEnd();o.renderBarGripAndDecorations(e,t);e.close("div")};o.renderBarGripAndDecorations=function(e,t){var i=t?"sap-icon://vertical-grip":"sap-icon://horizontal-grip";e.openStart("div").class("sapUiLoSplitterBarDecorationBefore").openEnd().close("div");e.openStart("div").class("sapUiLoSplitterBarGrip").openEnd().icon(i,["sapUiLoSplitterBarGripIcon"]).close("div");e.openStart("div").class("sapUiLoSplitterBarDecorationAfter").openEnd().close("div")};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/VerticalLayout", ["sap/ui/core/Control","sap/ui/core/EnabledPropagator","./library","./VerticalLayoutRenderer"],function(e,t,a,r){"use strict";var i=e.extend("sap.ui.layout.VerticalLayout",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},dnd:{draggable:false,droppable:true},designtime:"sap/ui/layout/designtime/VerticalLayout.designtime"},renderer:r});i.prototype.getAccessibilityInfo=function(){return{children:this.getContent()}};t.call(i.prototype);return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/VerticalLayoutRenderer", [],function(){"use strict";var t={apiVersion:2};t.render=function(t,e){var i=t;i.openStart("div",e);i.class("sapUiVlt");i.class("sapuiVlt");if(e.getWidth()&&e.getWidth()!=""){i.style("width",e.getWidth())}i.openEnd();var n=e.getContent();for(var s=0;s<n.length;s++){i.openStart("div");i.class("sapUiVltCell");i.class("sapuiVltCell");i.openEnd();i.renderControl(n[s]);i.close("div")}i.close("div")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/changeHandler/AddFormContainer", ["sap/ui/fl/changeHandler/Base","sap/ui/core/util/reflection/JsControlTreeModifier"],function(e,r){"use strict";var t={};t.applyChange=function(r,t,o){var n=o.modifier;var a=o.appComponent;var i=o.view;var l=r.getContent();var u=r.getTexts();if(u&&u.groupLabel&&u.groupLabel.value&&l&&l.group&&(l.group.selector||l.group.id)){var s=u.groupLabel.value;var p=l.group.index;var g=l.group.selector||{id:l.group.id};var c=Object.assign({},g);c.id=c.id+"--title";r.setRevertData({newGroupSelector:g});if(n.bySelector(c,a)){return e.markAsNotApplicable("Control to be created already exists:"+c)}else if(n.bySelector(g,a)){return e.markAsNotApplicable("Control to be created already exists:"+g)}return Promise.resolve().then(function(){return Promise.all([n.createControl("sap.ui.core.Title",a,i,c),n.createControl("sap.ui.layout.form.FormContainer",a,i,g)])}).then(function(e){var r=e[0];var o=e[1];n.setProperty(r,"text",s);return Promise.resolve().then(n.insertAggregation.bind(n,o,"title",r,0,i)).then(n.insertAggregation.bind(n,t,"formContainers",o,p,i))})}else{return Promise.resolve()}};t.completeChangeContent=function(e,t,o){var n=o.appComponent;if(t.newLabel){e.setText("groupLabel",t.newLabel,"XFLD")}else{throw new Error("Cannot create a new group: oSpecificChangeInfo.groupLabel attribute required")}var a={group:{}};if(t.index===undefined){throw new Error("Cannot create a new group: oSpecificChangeInfo.index attribute required")}else{a.group.index=t.index}if(t.newControlId){a.group.selector=r.getSelector(t.newControlId,n)}else{throw new Error("Cannot create a new group: oSpecificChangeInfo.newControlId attribute required")}e.setContent(a)};t.revertChange=function(e,r,t){var o=t.appComponent;var n=t.view;var a=t.modifier;var i=e.getRevertData().newGroupSelector;var l=a.bySelector(i,o,n);return Promise.resolve().then(function(){return a.removeAggregation(r,"formContainers",l)}).then(function(){a.destroy(l);e.resetRevertData()})};t.getChangeVisualizationInfo=function(e){var r=e.getText("groupLabel");return r?{descriptionPayload:{originalLabel:r}}:{}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/changeHandler/AddFormField", ["sap/ui/fl/changeHandler/BaseAddViaDelegate"],function(e){"use strict";var n=e.createAddViaDelegateChangeHandler({addProperty:function(e){var n=e.innerControls;var r=e.modifier;var t=e.view;var a=e.appComponent;var o=e.change;var i=o.getContent();var l=i.newFieldIndex;var u=i.newFieldSelector;var d;var s;return Promise.resolve().then(function(){if(!n.layoutControl){return Promise.resolve().then(r.createControl.bind(r,"sap.ui.layout.form.FormElement",a,t,u)).then(function(e){d=e;return Promise.all([r.insertAggregation(d,"label",n.label,0,t),r.insertAggregation(d,"fields",n.control,0,t)])})}d=n.control;return undefined}).then(function(){s=o.getDependentControl("parentFormContainer",e);return r.insertAggregation(s,"formElements",d,l,t)}).then(function(){if(n.valueHelp){return r.insertAggregation(s,"dependents",n.valueHelp,0,t)}return undefined})},aggregationName:"formElements",parentAlias:"parentFormContainer",fieldSuffix:"-field",supportsDefault:true});return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/changeHandler/AddSimpleFormField", ["sap/ui/fl/changeHandler/BaseAddViaDelegate","sap/ui/core/util/reflection/JsControlTreeModifier"],function(e,r){"use strict";var t="sap.ui.core.Title";var n="sap.m.Toolbar";var a="sap.m.Label";var o="sap.ui.comp.smartfield.SmartLabel";function i(e,r){var i=r.change;var l=r.modifier;var v=i.getContent();var g=v.newFieldIndex;var d=i.getDependentControl("targetContainerHeader",r);var u=e.indexOf(d);var f=0;var c=0;if(e.length===1||e.length===u+1){f=e.length}else{var s=0;for(s=u+1;s<e.length;s++){var p=l.getControlType(e[s]);if(p===a||p===o){if(c===g){f=s;break}c++}if(p===t||p===n){f=s;break}if(s===e.length-1){f=e.length}}}return f}function l(e,r,t){var n=e.slice();n.splice(r,0,t.label,t.control);return n}var v=e.createAddViaDelegateChangeHandler({addProperty:function(e){var r=e.control;var t=e.innerControls;var n=e.modifier;var a=e.appComponent;var o;var v;var g;var d=e.change;var u=d.getRevertData();u.labelSelector=n.getSelector(t.label,a);d.setRevertData(u);return Promise.resolve().then(n.getAggregation.bind(n,r,"content")).then(function(a){o=a;v=i(o,e);g=l(o,v,t);return n.replaceAllAggregation(r,"content",g)}).then(function(){if(t.valueHelp){return n.insertAggregation(r,"dependents",t.valueHelp,0,e.view)}return undefined})},revertAdditionalControls:function(e){var r=e.control;var t=e.change;var n=e.modifier;var a=e.appComponent;var o=t.getRevertData().labelSelector;if(o){var i=n.bySelector(o,a);return Promise.resolve().then(n.removeAggregation.bind(n,r,"content",i)).then(n.destroy.bind(n,i))}return Promise.resolve()},aggregationName:"content",mapParentIdIntoChange:function(e,r,t){var n=t.appComponent;var a=t.view;var o=t.modifier.bySelector(r.parentId,n,a);var i=o.getTitle()||o.getToolbar();if(i){e.addDependentControl(i.getId(),"targetContainerHeader",t)}},parentAlias:"_",fieldSuffix:"",skipCreateLayout:true,supportsDefault:true});v.getChangeVisualizationInfo=function(e,t){var n=e.getRevertData();if(n&&n.labelSelector){return{affectedControls:[r.bySelector(n.labelSelector,t).getParent().getId()],updateRequired:true}}return{affectedControls:[e.getContent().newFieldSelector]}};v.getCondenserInfo=function(){return undefined};return v},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/changeHandler/AddSimpleFormGroup", ["sap/ui/fl/changeHandler/Base","sap/ui/core/util/reflection/JsControlTreeModifier"],function(e,r){"use strict";var t={};t.CONTENT_AGGREGATION="content";var n=function(e,r,t){return t.reduce(function(t,n){return t.then(function(t){if(t!==undefined){return t}var o=e.getControlType(n);if(r.indexOf(o)===-1){return Promise.resolve().then(e.getVisible.bind(e,n)).then(function(e){return e||undefined})}else{return false}})},Promise.resolve())};var o=function(e,r,t,o){var i;var a=-1;if(o===0){return o}return n(e,r,t).then(function(n){if(n){a++}for(var u=0;u<t.length;u++){var l=e.getControlType(t[u]);if(r.indexOf(l)>-1){a++;if(a===o){i=t[u];return t.indexOf(i)}}}return t.length})};t.applyChange=function(r,n,i){var a=i.modifier;var u=i.view;var l=i.appComponent;var f;var g=r.getTexts();var c=r.getContent();if(g&&g.groupLabel&&g.groupLabel.value&&c&&c.group&&(c.group.selector||c.group.id)){var d=c.group.selector;var p;if(d){if(d.idIsLocal){p=l.createId(d.id)}else{p=d.id}}else{p=c.group.id}r.setRevertData({groupId:p});var s=g.groupLabel.value;var v;return Promise.resolve().then(function(){return a.getAggregation(n,t.CONTENT_AGGREGATION)}).then(function(e){if(typeof c.group.index==="number"){return c.group.index}else{v=c.group.relativeIndex;return o(a,["sap.ui.core.Title","sap.m.Title","sap.m.Toolbar","sap.m.OverflowToolbar"],e,v)}}).then(function(r){f=r;if(a.bySelector(p,l)){return e.markAsNotApplicable("Control to be created already exists:"+p)}return a.createControl("sap.ui.core.Title",l,u,p)}).then(function(e){a.setProperty(e,"text",s);return a.insertAggregation(n,"content",e,f,u)})}};t.completeChangeContent=function(e,t,n){var o=n.appComponent;var i={group:{}};if(t.newLabel){e.setText("groupLabel",t.newLabel,"XFLD")}else{throw new Error("oSpecificChangeInfo.newLabel attribute required")}if(t.newControlId){i.group.selector=r.getSelector(t.newControlId,o)}else{throw new Error("oSpecificChangeInfo.newControlId attribute required")}if(t.index===undefined){throw new Error("oSpecificChangeInfo.index attribute required")}else{i.group.relativeIndex=t.index}e.setContent(i)};t.getControlIdFromChangeContent=function(e){var r;if(e&&e.getContent()){r=e.getContent().group.id}return r};t.revertChange=function(e,r,n){var o=n.appComponent;var i=n.view;var a=n.modifier;var u=e.getRevertData().groupId;var l=a.getSelector(u,o);var f=a.bySelector(l,o,i);return Promise.resolve().then(function(){return a.removeAggregation(r,t.CONTENT_AGGREGATION,f)}).then(function(){a.destroy(f);e.resetRevertData()})};t.getChangeVisualizationInfo=function(e,t){var n=e.getContent().group.selector;var o=r.bySelector(n,t).getParent().getId();var i=e.getText("groupLabel");return{affectedControls:[o],updateRequired:true,descriptionPayload:{originalLabel:i}}};t.getCondenserInfo=function(){return undefined};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/changeHandler/HideSimpleForm", ["sap/ui/core/util/reflection/JsControlTreeModifier","sap/base/Log"],function(e,t){"use strict";var n={};var r=function(e,t){var n=t.getControlType(e);return n==="sap.ui.core.Title"||n==="sap.m.Title"||n==="sap.m.Toolbar"||n==="sap.m.OverflowToolbar"};var o=function(e,t){var n;for(n=0;n<e.length;++n){if(r(e[n],t)){return e[n]}}return undefined};function i(e){return e.modifier.targets==="xmlTree"}n.applyChange=function(e,n,a){var s=a.modifier;var u=a.view;var l=a.appComponent;if(i(a)){return Promise.reject(Error("Change cannot be applied in XML. Retrying in JS."))}var g=e.getContent();var f=s.bySelector(g.elementSelector||g.sHideId,l,u);var c;return this._getState(n,s,l).then(function(t){e.setRevertData(t);return s.getAggregation(n,"content")}).then(function(e){c=e}).then(function(){return c.reduce(function(e,t){return e.then(s.insertAggregation.bind(s,n,"dependents",t,0,u))},Promise.resolve())}).then(function(){return c.reduce(function(e,t,r){return e.then(s.insertAggregation.bind(s,n,"content",t,r,u))},Promise.resolve())}).then(function(){var t=-1;var i=e.getChangeType();if(i==="hideSimpleFormField"){c.some(function(e,n){if(e===f){t=n;s.setVisible(e,false)}if(t>=0&&n>t){if(s.getControlType(e)==="sap.m.Label"||s.getControlType(e)==="sap.ui.comp.smartfield.SmartLabel"||r(e,s)){return true}else{s.setVisible(e,false)}}})}else if(i==="removeSimpleFormGroup"){var a=[];var l=o(c,s);var g=l&&!f;c.some(function(e,o){if(!l){s.setVisible(e,false)}else if(g){t=0;s.setVisible(e,false);g=false}else{if(e===f){t=o}if(t>=0&&o>t){if(r(e,s)){if(t===0){a.push(function(){return Promise.resolve().then(s.removeAggregation.bind(s,n,"content",e,u))});a.push(function(){return Promise.resolve().then(s.insertAggregation.bind(s,n,"content",e,0,u))})}return true}else{s.setVisible(e,false)}}}});if(f){a.push(function(){return Promise.resolve().then(s.removeAggregation.bind(s,n,"content",f,u))});a.push(function(){return Promise.resolve().then(s.insertAggregation.bind(s,n,"dependents",f,0,u))})}if(a.length>0){return a.reduce(function(e,t){return e.then(t)},Promise.resolve())}}return Promise.resolve()}).catch(function(n){e.resetRevertData();t.error(n.message||n.name)})};n._getStableElement=function(e){if(e.getMetadata().getName()==="sap.ui.layout.form.FormContainer"){return e.getTitle()||e.getToolbar()}else if(e.getMetadata().getName()==="sap.ui.layout.form.FormElement"){return e.getLabel()}else{return e}};n.completeChangeContent=function(t,n,r){if(n.removedElement&&n.removedElement.id){var o=this._getStableElement(sap.ui.getCore().byId(n.removedElement.id));t.setContent({elementSelector:e.getSelector(o,r.appComponent)});t.addDependentControl(o,"elementSelector",r)}else{throw new Error("oSpecificChangeInfo.removedElement.id attribute required")}};n._getState=function(e,t,n){return Promise.resolve().then(function(){return t.getAggregation(e,"content")}).then(function(e){if(!e){return Promise.reject(new Error("Cannot get control state: 'content' aggregation doesn't exist"))}return{content:e.map(function(r){return{elementSelector:t.getSelector(t.getId(r),n),visible:r.getVisible?r.getVisible():undefined,index:e.indexOf(r)}})}})};n.revertChange=function(e,t,n){var r=e.getRevertData();var o=n.appComponent;var i=n.modifier;return Promise.resolve().then(i.removeAllAggregation.bind(i,t,"content")).then(function(){return r.content.reduce(function(e,r){var a=i.bySelector(r.elementSelector,o,n.view);var s=i.getId(a);return e.then(i.getAggregation.bind(i,t,"dependents")).then(function(e){var r=Promise.resolve();e.some(function(e){var o=i.getId(e);if(o===s){r=r.then(i.removeAggregation.bind(i,t,"dependents",e,n.view));return true}});return r}).then(i.insertAggregation.bind(i,t,"content",a,r.index,n.view)).then(function(){i.setProperty(a,"visible",r.visible)})},Promise.resolve()).then(function(){e.resetRevertData()})})};n.getChangeVisualizationInfo=function(t,n){var r=t.getContent().elementSelector;var o=e.bySelector(r,n);var i=t.getChangeType()==="removeSimpleFormGroup"?o.getParent().getId():o.getParent().getParent().getId();return{affectedControls:[r],displayControls:[i],updateRequired:true}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/changeHandler/MoveSimpleForm", ["sap/ui/core/util/reflection/JsControlTreeModifier","sap/base/util/uid","sap/base/Log"],function(e,t,r){"use strict";var n={};n.CHANGE_TYPE_MOVE_FIELD="moveSimpleFormField";n.CHANGE_TYPE_MOVE_GROUP="moveSimpleFormGroup";n.sTypeTitle="sap.ui.core.Title";n.sTypeMTitle="sap.m.Title";n.sTypeToolBar="sap.m.Toolbar";n.sTypeOverflowToolBar="sap.m.OverflowToolbar";n.sTypeLabel="sap.m.Label";n.sTypeSmartLabel="sap.ui.comp.smartfield.SmartLabel";n.CONTENT_AGGREGATION="content";function o(e,t,r){return r.reduce(function(r,n){return r.then(function(r){if(r!==undefined){return r}var o=e.getControlType(n);if(t.indexOf(o)===-1){return Promise.resolve().then(e.getVisible.bind(e,n)).then(function(e){return e||undefined})}else{return false}})},Promise.resolve())}function a(e,t,r,n,a,i,l){return o(t,i,r).then(function(r){if(r){var o=a.view;var i=a.appComponent;var c;return Promise.resolve().then(t.createControl.bind(t,"sap.ui.core.Title",i,o,l)).then(function(e){c=e;t.setProperty(c,"text","");return t.insertAggregation(n,"content",c,0,o)}).then(function(){var t=e.getRevertData();t.createdTitleSelector=a.modifier.getSelector(c,a.appComponent);e.setRevertData(t)})}return Promise.resolve()}).then(function(){return t.getAggregation(n,"content")})}function i(e,t,r,n){var a;var i=-1;return o(e,t,r).then(function(o){if(o){i++}for(var l=0;l<r.length;l++){var c=e.getControlType(r[l]);if(t.indexOf(c)>-1){i++;if(i===n){a=r[l];break}}}return r.indexOf(a)})}function l(e,t,r){if(t>=e.length||t===-1){return true}var o=r.getControlType(e[t]);return n.sTypeTitle===o||n.sTypeToolBar===o||n.sTypeMTitle===o||n.sTypeOverflowToolBar===o}function c(e,t,r,n){var o=0;for(o=t+1;o<r.length;++o){var a=e.getControlType(r[o]);if(n.indexOf(a)>-1){break}}return o-t}function u(e,t,r){return c(e,r,t,[n.sTypeTitle,n.sTypeMTitle,n.sTypeToolBar,n.sTypeOverflowToolBar,n.sTypeLabel,n.sTypeSmartLabel])}function p(e,t,n,o,a){if(!l(t,n,e)){r.error("Illegal argument. iIndex has to point to a Label.")}else{o=a?o+1:o;var i=0;var c=n;var p;while(c<t.length&&i<o){++i;p=u(e,t,c);c+=p}return c}}function s(e,t,r,n,o){var a=r;for(var i=0;i<o;i++){a.splice(n+i,0,e[t+i])}return a}function g(e){return e.getTitle()||e.getToolbar()}function v(e,t,r){var o=g(t.element);var a=r.modifier.getSelector(e,r.appComponent);var i={elementSelector:r.modifier.getSelector(o,r.appComponent),source:{groupIndex:t.sourceIndex},target:{groupIndex:t.targetIndex}};return{changeType:n.CHANGE_TYPE_MOVE_GROUP,targetSelector:a,movedControl:o,movedElements:[i]}}function d(e,t,r,o,a){var i=a.modifier.getSelector(e,a.appComponent);var l=t.element.getLabel();var c=a.modifier.getSelector(l,a.appComponent);var u=g(o.parent);var p=g(r.parent);var s=a.modifier.getSelector(u,a.appComponent);var v=a.modifier.getSelector(p,a.appComponent);var d={elementSelector:c,source:{groupSelector:v,fieldIndex:t.sourceIndex},target:{groupSelector:s,fieldIndex:t.targetIndex}};return{changeType:n.CHANGE_TYPE_MOVE_FIELD,targetSelector:i,target:u,source:p,movedControl:l,movedElements:[d]}}function f(e,t,r,n,o,a){return Promise.resolve().then(function(){return o.reduce(function(r,n){return r.then(e.insertAggregation.bind(e,t,"dependents",n,0,a))},Promise.resolve())}).then(function(){return n.reduce(function(n,o,i){return n.then(e.insertAggregation.bind(e,t,r.CONTENT_AGGREGATION,o,i,a))},Promise.resolve())})}n.applyChange=function(e,t,o){var l=o.modifier;var g=o.view;var v=o.appComponent;var d;var m;var T;var C=e.getContent();var y=C.movedElements[0];return Promise.resolve().then(function(){return l.getAggregation(t,n.CONTENT_AGGREGATION)}).then(function(S){var h=S.map(function(e){return l.getSelector(e,v)});var E={content:h};e.setRevertData(E);if(e.getChangeType()===n.CHANGE_TYPE_MOVE_FIELD){var I=l.bySelector(y.elementSelector||y.element,v,g);var b=S.indexOf(I);var O=u(l,S,b);d=l.bySelector(y.target.groupSelector||y.target.groupId,v,g);var P=S.indexOf(d);var x=l.bySelector(y.source.groupSelector||y.source.groupId,v,g);var _=S.indexOf(x);var G=p(l,S,P,y.target.fieldIndex,_===P&&y.source.fieldIndex<y.target.fieldIndex);var A=u(l,S,G);m=S.slice();var N=m.slice(b,b+O);var w,L,M,R;if(b<G){w=m.slice(0,b);M=m.slice(b+O,G+A);R=m.slice(G+A,m.length);m=w.concat(M.concat(N.concat(R)))}else if(b>G){L=m.slice(0,G+A);M=m.slice(G+A,b);R=m.slice(b+O,m.length);m=L.concat(N.concat(M.concat(R)))}if(b!=G){return f(l,t,n,m,S,g)}}else if(e.getChangeType()===n.CHANGE_TYPE_MOVE_GROUP){var D=[n.sTypeTitle,n.sTypeToolBar,n.sTypeMTitle,n.sTypeOverflowToolBar];var F=l.bySelector(y.elementSelector||y.element,v,g);return Promise.resolve().then(function(){if(y.target.groupIndex===0||!F){return a(e,l,S,t,o,D,C.newControlId).then(function(e){S=e})}return undefined}).then(function(){T=F?S.indexOf(F):0;return i(l,D,S,y.target.groupIndex)}).then(function(e){d=S[e];var r=c(l,e,S,D);var o=c(l,T,S,D);m=S.slice();m.splice(T,o);e=m.indexOf(d);var a=y.source.groupIndex<y.target.groupIndex?r:0;m=s(S,T,m,e+a,o);return f(l,t,n,m,S,g)})}else{r.warning("Unknown change type detected. Cannot apply to SimpleForm")}})};n.completeChangeContent=function(e,n,o){var a;var i=o.modifier;var l=o.view;var c=o.appComponent;var u=i.bySelector(n.selector,c,l);var p=n.movedElements;if(p.length>1){r.warning("Moving more than 1 Formelement is not yet supported.")}var s=p[0];s.element=sap.ui.getCore().byId(s.id);var g=Object.assign({},n.source);var f=Object.assign({},n.target);if(!f.parent){f.parent=sap.ui.getCore().byId(f.id)}if(!g.parent){g.parent=sap.ui.getCore().byId(g.id)}if(u&&s.element&&f.parent){if(n.changeType==="moveSimpleFormGroup"){a=v(u,s,o)}else if(n.changeType==="moveSimpleFormField"){a=d(u,s,g,f,o)}}else{r.error("Element not found. This may be caused by an unstable id!")}var m={targetSelector:a.targetSelector,movedElements:a.movedElements,newControlId:i.getSelector(l.createId(t()),c)};e.setContent(m);if(a.source&&a.target){e.addDependentControl(a.source,"sourceParent",o);e.addDependentControl(a.target,"targetParent",o)}if(a.movedControl){e.addDependentControl([a.movedControl],"movedElements",o)}};n.revertChange=function(e,t,r){var o=r.modifier;var a=r.appComponent;var i=r.view;var l=e.getRevertData();var c=l.content;return o.getAggregation(t,n.CONTENT_AGGREGATION).then(function(u){var p=c.map(function(e){return o.bySelector(e,a,i)});return f(o,t,n,p,u,i).then(function(){var t=l.createdTitleSelector;var n=r.modifier.bySelector(t,r.appComponent);if(n){n.destroy()}e.resetRevertData();return true})})};n.getChangeVisualizationInfo=function(t,r){var o;var a;var i;var c=t.getContent().movedElements[0];if(c.elementSelector.id){i=e.bySelector(c.elementSelector,r)}else if(t.getContent().newControlId){i=e.bySelector(t.getContent().newControlId,r)}var u=c.source.groupSelector;if(t.getChangeType()===n.CHANGE_TYPE_MOVE_FIELD){var p=e.bySelector(c.source.groupSelector,r);var s=e.bySelector(c.target.groupSelector,r);o=p?p.getParent().getId():null;a=s?s.getParent().getId():null;u={id:o}}else if(!u&&l([i],0,e)){var g=i.getParent();u={id:g.getId()}}var v=i.getParent().getId();return{affectedControls:[v],dependentControls:[u&&u.id?u:t.getContent().targetSelector],updateRequired:true,descriptionPayload:{sourceContainer:o,targetContainer:a}}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/changeHandler/RenameFormContainer", [],function(){"use strict";var e={};var t={TARGET_ALIAS:"target"};e.applyChange=function(e,r,n){var o=n.modifier,i=e.getTexts(),a=e.getDependentControl(t.TARGET_ALIAS,n);return Promise.resolve().then(function(){return o.getAggregation(a,"title")}).then(function(t){if(i&&i.formText&&this._isProvided(i.formText.value)){var r=i.formText.value;var n;if(typeof t==="string"){n=Promise.resolve(o.getProperty(a,"title")).then(function(t){e.setRevertData(t);o.setProperty(a,"title",r)})}else{n=Promise.resolve(o.getProperty(t,"text")).then(function(n){e.setRevertData(n);o.setProperty(t,"text",r)})}return n}}.bind(this))};e.completeChangeContent=function(e,r,n){if(!(r.renamedElement&&r.renamedElement.id)){throw new Error("Rename of the group cannot be executed: oSpecificChangeInfo.renamedElement attribute required")}if(!this._isProvided(r.value)){throw new Error("Rename of the group cannot be executed: oSpecificChangeInfo.value attribute required")}e.addDependentControl(r.renamedElement.id,t.TARGET_ALIAS,n);e.setText("formText",r.value,"XGRP")};e.revertChange=function(e,r,n){var o=e.getRevertData(),i=n.modifier,a=e.getDependentControl(t.TARGET_ALIAS,n);return Promise.resolve().then(function(){return i.getAggregation(a,"title")}).then(function(t){if(typeof t==="string"){i.setProperty(a,"title",o)}else{i.setProperty(t,"text",o)}e.resetRevertData()})};e._isProvided=function(e){return typeof e==="string"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/changeHandler/RenameFormElement", ["sap/ui/fl/changeHandler/condenser/Classification"],function(e){"use strict";var t={};var n=function(e){return typeof e==="string"};t.applyChange=function(e,t,n){var r=n.modifier,a=e.getText("fieldLabel");return Promise.resolve().then(function(){return r.getAggregation(t,"label")}).then(function(n){if(typeof n==="string"){e.setRevertData(n);return r.setProperty(t,"label",a)}return r.getProperty(n,"text").then(function(t){e.setRevertData(t);r.setProperty(n,"text",a)})})};t.completeChangeContent=function(e,t,r){if(!(t.renamedElement&&t.renamedElement.id)){throw new Error("Rename of label cannot be executed: oSpecificChangeInfo.renamedElement attribute required")}if(!n(t.value)){throw new Error("Rename of label cannot be executed: oSpecificChangeInfo.value attribute required")}e.setText("fieldLabel",t.value,"XGRP")};t.revertChange=function(e,t,n){var r=e.getRevertData(),a=n.modifier;return Promise.resolve().then(function(){return a.getAggregation(t,"label")}).then(function(n){if(typeof n==="string"){a.setProperty(t,"label",r)}else{a.setProperty(n,"text",r)}e.resetRevertData()})};t.getChangeVisualizationInfo=function(e){var t=e.getText("fieldLabel");return{descriptionPayload:{originalLabel:e.getRevertData(),newLabel:t}}};t.getCondenserInfo=function(t){return{affectedControl:t.getSelector(),classification:e.LastOneWins,uniqueKey:"label"}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/changeHandler/RenameSimpleForm", ["sap/ui/core/util/reflection/JsControlTreeModifier","sap/base/Log"],function(e,t){"use strict";var r={};r.applyChange=function(e,t,r){var n=r.modifier;var o=r.view;var a=r.appComponent;var i=e.getTexts();var l=e.getContent();var d=l.elementSelector||l.sRenameId;var v=n.bySelector(d,a,o);if(i&&i.formText&&this._isProvided(i.formText.value)){if(!t){return Promise.reject(new Error("no Control provided for renaming"))}return n.getPropertyBindingOrProperty(v,"text").then(function(t){e.setRevertData(t);var r=i.formText.value;n.setPropertyBindingOrProperty(v,"text",r)})}else{return Promise.resolve()}};r.revertChange=function(e,r,n){var o=e.getRevertData();var a=n.appComponent;var i=e.getContent();var l=n.view;var d=n.modifier;var v=i.elementSelector||i.sRenameId;var f=d.bySelector(v,a,l);if(o||o===""){d.setPropertyBindingOrProperty(f,"text",o);f.getParent().invalidate();e.resetRevertData()}else{t.error("Change doesn't contain sufficient information to be reverted. Most Likely the Change didn't go through applyChange.")}};r.completeChangeContent=function(t,r,n){var o={};if(!r.changeType){throw new Error("oSpecificChangeInfo.changeType attribute required")}if(r.renamedElement&&r.renamedElement.id){var a=sap.ui.getCore().byId(r.renamedElement.id);var i;if(r.changeType==="renameLabel"){i=a.getLabel()}else if(r.changeType==="renameTitle"){i=a.getTitle()}o.elementSelector=e.getSelector(i,n.appComponent);t.addDependentControl(i,"elementSelector",n)}else{throw new Error("oSpecificChangeInfo.renamedElement attribute required")}if(this._isProvided(r.value)){t.setText("formText",r.value,"XFLD")}else{throw new Error("oSpecificChangeInfo.value attribute required")}t.setContent(o)};r._isProvided=function(e){return typeof e==="string"};r.getChangeVisualizationInfo=function(t,r){var n=t.getContent().elementSelector;var o=e.bySelector(n,r).getParent().getId();return{affectedControls:[o],updateRequired:true,descriptionPayload:{originalLabel:t.getRevertData(),newLabel:t.getTexts().formText.value}}};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/changeHandler/UnhideSimpleForm", ["sap/ui/core/util/reflection/JsControlTreeModifier"],function(e){"use strict";var t={};function r(e){return e.modifier.targets==="xmlTree"}t.applyChange=function(e,t,n){var o=n.modifier;var i=n.view;var a=n.appComponent;var l=e.getContent();if(r(n)){return Promise.reject(Error("Change cannot be applied in XML. Retrying in JS."))}var p=o.bySelector(l.elementSelector||l.sUnhideId,a,i);return Promise.resolve().then(function(){return o.getAggregation(t,"content")}).then(function(t){var r=-1;if(e.getChangeType()==="unhideSimpleFormField"){e.setRevertData(true);t.some(function(e,t){if(e===p){r=t;o.setVisible(e,true)}if(r>=0&&t>r){if(o.getControlType(e)==="sap.m.Label"||o.getControlType(e)==="sap.ui.comp.smartfield.SmartLabel"||o.getControlType(e)==="sap.ui.core.Title"||o.getControlType(e)==="sap.m.Title"||o.getControlType(e)==="sap.m.Toolbar"||o.getControlType(e)==="sap.m.OverflowToolbar"){return true}o.setVisible(e,true)}})}})};t.completeChangeContent=function(t,r,n){var o={};if(r.sUnhideId){var i=sap.ui.getCore().byId(r.sUnhideId);o.elementSelector=e.getSelector(i,n.appComponent);t.addDependentControl(i,"elementSelector",n)}else if(r.revealedElementId){var a=sap.ui.getCore().byId(r.revealedElementId||r.sUnhideId);var l=a.getLabel();o.elementSelector=e.getSelector(l,n.appComponent);t.addDependentControl(l,"elementSelector",n)}else{throw new Error("oSpecificChangeInfo.revealedElementId attribute required")}t.setContent(o)};t.revertChange=function(e,t,r){var n=r.modifier;var o=r.view;var i=r.appComponent;var a=e.getContent();var l=n.bySelector(a.elementSelector||a.sUnhideId,i,o);return Promise.resolve().then(function(){return n.getAggregation(t,"content")}).then(function(t){var r=-1;if(e.getChangeType()==="unhideSimpleFormField"){t.some(function(e,t){if(e===l){r=t;n.setVisible(e,false)}if(r>=0&&t>r){if(n.getControlType(e)==="sap.m.Label"||n.getControlType(e)==="sap.ui.comp.smartfield.SmartLabel"||n.getControlType(e)==="sap.ui.core.Title"||n.getControlType(e)==="sap.m.Title"||n.getControlType(e)==="sap.m.Toolbar"||n.getControlType(e)==="sap.m.OverflowToolbar"){return true}n.setVisible(e,false)}});e.resetRevertData()}return Promise.resolve()})};t.getChangeVisualizationInfo=function(t,r){return{affectedControls:[e.bySelector(t.getContent().elementSelector,r).getParent().getId()],updateRequired:true}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/cssgrid/CSSGrid", ["sap/ui/core/Control","sap/ui/layout/cssgrid/GridLayoutBase","sap/ui/layout/cssgrid/GridBasicLayout","sap/ui/layout/cssgrid/GridLayoutDelegate","./CSSGridRenderer","sap/ui/base/ManagedObjectObserver","sap/ui/layout/library"],function(e,t,i,a,r,o){"use strict";var s=e.extend("sap.ui.layout.cssgrid.CSSGrid",{metadata:{library:"sap.ui.layout",defaultAggregation:"items",interfaces:["sap.ui.layout.cssgrid.IGridConfigurable"],properties:{width:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},gridTemplateColumns:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridTemplateRows:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridRowGap:{type:"sap.ui.core.CSSSize",defaultValue:""},gridColumnGap:{type:"sap.ui.core.CSSSize",defaultValue:""},gridGap:{type:"sap.ui.layout.cssgrid.CSSGridGapShortHand",defaultValue:""},gridAutoRows:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridAutoColumns:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridAutoFlow:{type:"sap.ui.layout.cssgrid.CSSGridAutoFlow",defaultValue:"Row"}},aggregations:{customLayout:{type:"sap.ui.layout.cssgrid.GridLayoutBase",multiple:false},items:{type:"sap.ui.core.Control",multiple:true,singularName:"item",dnd:true}},dnd:{draggable:false,droppable:true}},renderer:r});s.prototype.getGridDomRefs=function(){return[this.getDomRef()]};s.prototype.getGridLayoutConfiguration=function(){if(this.getCustomLayout()){return this.getCustomLayout()}else{return this._getDefaultGridLayout()}};s.prototype._getDefaultGridLayout=function(){var e=new i({gridTemplateColumns:this.getGridTemplateColumns(),gridTemplateRows:this.getGridTemplateRows(),gridRowGap:this.getGridRowGap(),gridColumnGap:this.getGridColumnGap(),gridGap:this.getGridGap(),gridAutoRows:this.getGridAutoRows(),gridAutoColumns:this.getGridAutoColumns(),gridAutoFlow:this.getGridAutoFlow()});return e};s.prototype.init=function(){this._oItemDelegate={onAfterRendering:this._onAfterItemRendering};this._oGridObserver=new o(this._onGridChange.bind(this));this._oGridObserver.observe(this,{aggregations:["items"]});this._addGridLayoutDelegate()};s.prototype.exit=function(){this._removeGridLayoutDelegate();if(this._oGridObserver){this._oGridObserver.disconnect();this._oGridObserver=null}};s.prototype._addGridLayoutDelegate=function(){if(!this.oGridLayoutDelegate){this.oGridLayoutDelegate=new a;this.addDelegate(this.oGridLayoutDelegate,false,this,false)}};s.prototype._removeGridLayoutDelegate=function(){if(this.oGridLayoutDelegate){this.removeDelegate(this.oGridLayoutDelegate);this.oGridLayoutDelegate.destroy();this.oGridLayoutDelegate=null}};s.prototype._onGridChange=function(e){var t;if(e.name!=="items"||!e.child){return}if(e.mutation==="insert"){t=!e.child.isA("sap.ui.core.HTML");e.child.addDelegate(this._oItemDelegate,t,e.child)}else if(e.mutation==="remove"){e.child.removeEventDelegate(this._oItemDelegate,e.child)}};s.prototype._onAfterItemRendering=function(){t.setItemStyles(this)};s.prototype.onLayoutDataChange=function(e){t.setItemStyles(e.srcControl)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/cssgrid/CSSGridRenderer", [],function(){"use strict";var t={apiVersion:2};t.render=function(t,e){t.openStart("div",e).class("sapUiLayoutCSSGrid");if(e.getWidth()){t.style("width",e.getWidth())}e.getGridLayoutConfiguration().addGridStyles(t);t.openEnd();e.getItems().forEach(t.renderControl,t);t.close("div")};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/cssgrid/GridBasicLayout", ["sap/ui/layout/cssgrid/GridLayoutBase","sap/ui/layout/cssgrid/GridSettings","sap/ui/layout/library"],function(t,i){"use strict";var a=t.extend("sap.ui.layout.cssgrid.GridBasicLayout",{metadata:{library:"sap.ui.layout",properties:{gridTemplateColumns:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridTemplateRows:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridRowGap:{type:"sap.ui.core.CSSSize",defaultValue:""},gridColumnGap:{type:"sap.ui.core.CSSSize",defaultValue:""},gridGap:{type:"sap.ui.layout.cssgrid.CSSGridGapShortHand",defaultValue:""},gridAutoRows:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridAutoColumns:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridAutoFlow:{type:"sap.ui.layout.cssgrid.CSSGridAutoFlow",defaultValue:"Row"}}}});a.prototype.getActiveGridSettings=function(){return new i({gridTemplateColumns:this.getGridTemplateColumns(),gridTemplateRows:this.getGridTemplateRows(),gridRowGap:this.getGridRowGap(),gridColumnGap:this.getGridColumnGap(),gridGap:this.getGridGap(),gridAutoRows:this.getGridAutoRows(),gridAutoColumns:this.getGridAutoColumns(),gridAutoFlow:this.getGridAutoFlow()})};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/cssgrid/GridBoxLayout", ["sap/ui/layout/cssgrid/GridLayoutBase","sap/ui/layout/cssgrid/GridSettings","sap/ui/Device","sap/ui/thirdparty/jquery"],function(t,i,e,jQuery){"use strict";var s=/^([X][L](?:[1-9]|1[0-2]))? ?([L](?:[1-9]|1[0-2]))? ?([M](?:[1-9]|1[0-2]))? ?([S](?:[1-9]|1[0-2]))?$/i;var a=s.exec("XL7 L6 M4 S2");var o={Phone:"sapUiLayoutCSSGridBoxLayoutSizeS",Tablet:"sapUiLayoutCSSGridBoxLayoutSizeM",Desktop:"sapUiLayoutCSSGridBoxLayoutSizeL",LargeDesktop:"sapUiLayoutCSSGridBoxLayoutSizeXL"};var r={XL:"sapUiLayoutCSSGridBoxLayoutSpanXL7",L:"sapUiLayoutCSSGridBoxLayoutSpanL6",M:"sapUiLayoutCSSGridBoxLayoutSpanM4",S:"sapUiLayoutCSSGridBoxLayoutSpanS2"};var n="0.5rem";var p=t.extend("sap.ui.layout.cssgrid.GridBoxLayout",{metadata:{library:"sap.ui.layout",properties:{boxMinWidth:{type:"sap.ui.core.CSSSize",defaultValue:""},boxWidth:{type:"sap.ui.core.CSSSize",defaultValue:""},boxesPerRowConfig:{type:"sap.ui.layout.BoxesPerRowConfig",group:"Behavior",defaultValue:"XL7 L6 M4 S2"}}}});p.prototype.getActiveGridSettings=function(){return new i({gridTemplateColumns:this._getTemplateColumns(),gridGap:n+" "+n})};p.prototype._applySingleGridLayout=function(i){t.prototype._applySingleGridLayout.call(this,i);var e=sap.ui.getCore().byId(i.parentElement.id);if(e&&e.isA("sap.f.GridList")&&e.isGrouped()){this._flattenHeight(e)}};p.prototype.addGridStyles=function(i){t.prototype.addGridStyles.apply(this,arguments);this._addSpanClasses(i);i.class("sapUiLayoutCSSGridBoxLayoutContainer")};p.prototype.onGridAfterRendering=function(t){t.getGridDomRefs().forEach(function(t){if(t.children){for(var i=0;i<t.children.length;i++){if(!t.children[i].classList.contains("sapMGHLI")&&!t.children[i].classList.contains("sapUiBlockLayerTabbable")){t.children[i].classList.add("sapUiLayoutCSSGridItem")}}}});if(!this._hasBoxWidth()){this._applySizeClass(t)}if(t.isA("sap.f.GridList")&&t.getGrowing()){var i=t._oGrowingDelegate._onAfterPageLoaded;t._oGrowingDelegate._onAfterPageLoaded=function(){i.call(t._oGrowingDelegate);if(t.isA("sap.f.GridList")&&t.isGrouped()){this._flattenHeight(t)}}.bind(this)}};p.prototype.isResponsive=function(){return true};p.prototype.onGridResize=function(t){if(t.control&&t.control.isA("sap.f.GridList")&&t.control.isGrouped()){this._flattenHeight(t.control)}if(t){if(!this._hasBoxWidth()){this._applySizeClass(t.control)}}};p.prototype._flattenHeight=function(t){var i=0,e;this._loopOverGridItems(t,function(t){if(!t.classList.contains("sapMGHLI")){t.style.height=""}});this._loopOverGridItems(t,function(t){if(!t.classList.contains("sapMGHLI")){i=Math.max(jQuery(t).outerHeight(),i)}});e=i+"px";this._loopOverGridItems(t,function(t){if(!t.classList.contains("sapMGHLI")){t.style.height=e}})};p.prototype._applySizeClass=function(t){var i=e.media.getCurrentRange("StdExt",t.$().width());if(!i){return}var s=o[i.name];t.getGridDomRefs().forEach(function(t){if(!t.classList.contains(s)){Object.keys(o).map(function(i){t.classList.remove(o[i])});t.classList.add(s)}})};p.prototype._getTemplateColumns=function(){var t="";if(this.getBoxWidth()){t="repeat(auto-fit, "+this.getBoxWidth()+")"}else if(this.getBoxMinWidth()){t="repeat(auto-fit, minmax("+this.getBoxMinWidth()+", 1fr))"}return t};p.prototype._hasBoxWidth=function(){if(this.getBoxWidth()||this.getBoxMinWidth()){return true}else{return false}};p.prototype._addSpanClasses=function(t){var i,e=this.getBoxesPerRowConfig(),o,n,p,l;if(this._hasBoxWidth()){return}if(!e||!e.length===0){i=a}else{i=s.exec(e)}if(i){for(var u=1;u<i.length;u++){var d=i[u];if(!d){continue}d=d.toUpperCase();switch(d.substr(0,1)){case"X":if(d.substr(1,1)==="L"){o=this._getBoxesPerRowClass(d,2)}break;case"L":n=this._getBoxesPerRowClass(d,1);break;case"M":p=this._getBoxesPerRowClass(d,1);break;case"S":l=this._getBoxesPerRowClass(d,1);break;default:break}}}o=o||r.XL;n=n||r.L;p=p||r.M;l=l||r.S;t.class(o).class(n).class(p).class(l)};p.prototype._getBoxesPerRowClass=function(t,i){var e=parseInt(t.substr(i,t.length));if(e&&e>0&&e<13){return"sapUiLayoutCSSGridBoxLayoutSpan"+t}};p.prototype._loopOverGridItems=function(t,i){t.getGridDomRefs().forEach(function(t){if(t&&t.children){for(var e=0;e<t.children.length;e++){if(t.children[e].style.display!=="none"&&t.children[e].style.visibility!=="hidden"){i(t.children[e])}}}})};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/cssgrid/GridItemLayoutData", ["sap/ui/core/LayoutData","sap/ui/layout/library"],function(t){"use strict";var e={gridColumnStart:"grid-column-start",gridColumnEnd:"grid-column-end",gridRowStart:"grid-row-start",gridRowEnd:"grid-row-end",gridColumn:"grid-column",gridRow:"grid-row"};var r=t.extend("sap.ui.layout.cssgrid.GridItemLayoutData",{metadata:{library:"sap.ui.layout",interfaces:["sap.ui.layout.cssgrid.IGridItemLayoutData"],properties:{gridColumnStart:{type:"sap.ui.layout.cssgrid.CSSGridLine",defaultValue:""},gridColumnEnd:{type:"sap.ui.layout.cssgrid.CSSGridLine",defaultValue:""},gridRowStart:{type:"sap.ui.layout.cssgrid.CSSGridLine",defaultValue:""},gridRowEnd:{type:"sap.ui.layout.cssgrid.CSSGridLine",defaultValue:""},gridColumn:{type:"sap.ui.layout.cssgrid.CSSGridLine",defaultValue:""},gridRow:{type:"sap.ui.layout.cssgrid.CSSGridLine",defaultValue:""}}}});r.prototype.setItemStyles=function(t){if(!t){return}var i=this.getMetadata().getProperties();for(var a in e){if(i[a]){var u=this.getProperty(a);if(typeof u!=="undefined"){r._setItemStyle(t,e[a],u)}}}};r.removeItemStyles=function(t){for(var r in e){t.style.removeProperty(e[r])}};r._setItemStyle=function(t,e,r){if(r!=="0"&&!r){t.style.removeProperty(e)}else{t.style.setProperty(e,r)}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/cssgrid/GridLayoutBase", ["sap/ui/base/ManagedObject","./GridItemLayoutData"],function(t,e){"use strict";var r={gridTemplateColumns:"grid-template-columns",gridTemplateRows:"grid-template-rows",gridGap:"grid-gap",gridColumnGap:"grid-column-gap",gridRowGap:"grid-row-gap",gridAutoRows:"grid-auto-rows",gridAutoColumns:"grid-auto-columns",gridAutoFlow:"grid-auto-flow"};var i={Row:"row",Column:"column",RowDense:"row dense",ColumnDense:"column dense"};var o=t.extend("sap.ui.layout.cssgrid.GridLayoutBase",{metadata:{library:"sap.ui.layout",abstract:true}});o.setItemStyles=function(t){if(!t){return}var r=o._getLayoutDataForControl(t),i=t.getDomRef();if(!i){return}if(!r){e.removeItemStyles(i)}else{r.setItemStyles(i)}};o._getLayoutDataForControl=function(t){var e,r,i;if(!t){return undefined}e=t.getLayoutData();if(!e){return undefined}if(e.isA("sap.ui.layout.cssgrid.IGridItemLayoutData")){return e}if(e.isA("sap.ui.core.VariantLayoutData")){r=e.getMultipleLayoutData();for(var o=0;o<r.length;o++){i=r[o];if(i.isA("sap.ui.layout.cssgrid.IGridItemLayoutData")){return i}}}};o.prototype.applyGridLayout=function(t){if(!t){return}t.forEach(this._applySingleGridLayout,this)};o.prototype._applySingleGridLayout=function(t){if(!t){return}t=t instanceof window.HTMLElement?t:t.getDomRef();var e=this.getActiveGridSettings();if(t.style.getPropertyValue("display")!=="grid"){t.style.setProperty("display","grid")}if(e){this._setGridLayout(t,e)}else{this._removeGridLayout(t)}};o.prototype._setGridLayout=function(t,e){var o=e.getMetadata().getProperties(),a,n;for(a in r){if(o[a]){n=e.getProperty(a);if(a==="gridAutoFlow"){n=i[n]}if(n===""&&(a==="gridRowGap"||a==="gridColumnGap")){continue}t.style.setProperty(r[a],n)}}};o.prototype._removeGridLayout=function(t){for(var e in r){t.style.removeProperty(r[e])}};o.prototype.getActiveGridSettings=function(){throw new Error("GridLayoutBase getActiveGridSettings not implemented in child class")};o.prototype.onGridAfterRendering=function(t){};o.prototype.onGridResize=function(t){};o.prototype.isResponsive=function(){return false};o.prototype.addGridStyles=function(t){var e=this.getActiveGridSettings();t.style("display","grid");if(!e||this.isResponsive()){return}var o=e.getMetadata().getProperties();for(var a in r){if(o[a]){var n=e.getProperty(a);if(a==="gridAutoFlow"){n=i[n]}t.style(r[a],n)}}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/cssgrid/GridLayoutDelegate", ["sap/ui/base/Object","sap/ui/core/ResizeHandler"],function(e,i){"use strict";var r=e.extend("sap.ui.layout.cssgrid.GridLayoutDelegate");r.prototype.onBeforeRendering=function(){r.deregisterResizeListener(this)};r.prototype.onAfterRendering=function(){var e=this.getGridLayoutConfiguration();if(!e){return}e.onGridAfterRendering(this);if(e.isResponsive()){e.applyGridLayout(this.getGridDomRefs());r.registerResizeListener(this)}};r.prototype.exit=function(){r.deregisterResizeListener(this)};r.registerResizeListener=function(e){e.__grid__sResizeListenerId=i.register(e,r.onResize.bind(e))};r.deregisterResizeListener=function(e){if(e.__grid__sResizeListenerId){i.deregister(e.__grid__sResizeListenerId);e.__grid__sResizeListenerId=null}};r.onResize=function(e){var i=this.getGridLayoutConfiguration();if(!i){return}i.onGridResize(e);i.applyGridLayout(this.getGridDomRefs())};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/cssgrid/GridResponsiveLayout", ["sap/ui/layout/cssgrid/GridLayoutBase","sap/ui/Device"],function(t,e){"use strict";var i=t.extend("sap.ui.layout.cssgrid.GridResponsiveLayout",{metadata:{library:"sap.ui.layout",properties:{containerQuery:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{layout:{type:"sap.ui.layout.cssgrid.GridSettings",multiple:false},layoutS:{type:"sap.ui.layout.cssgrid.GridSettings",multiple:false},layoutM:{type:"sap.ui.layout.cssgrid.GridSettings",multiple:false},layoutL:{type:"sap.ui.layout.cssgrid.GridSettings",multiple:false},layoutXL:{type:"sap.ui.layout.cssgrid.GridSettings",multiple:false}},events:{layoutChange:{parameters:{layout:{type:"string"}}}}}});i.mSizeClasses={Phone:"sapUiLayoutCSSGridS",Tablet:"sapUiLayoutCSSGridM",Desktop:"sapUiLayoutCSSGridL",LargeDesktop:"sapUiLayoutCSSGridXL"};i.mSizeLayouts={Phone:"layoutS",Tablet:"layoutM",Desktop:"layoutL",LargeDesktop:"layoutXL"};i.prototype.init=function(){this._sActiveLayout="layout"};i.prototype.getActiveGridSettings=function(){return this.getAggregation(this._sActiveLayout)};i.prototype.isResponsive=function(){return true};i.prototype.onGridAfterRendering=function(t){this.setActiveLayout(t,false)};i.prototype.onGridResize=function(t){if(!t||t.size.width===0){return}this.setActiveLayout(t.control,true)};i.prototype.applySizeClass=function(t,e){if(t.hasClass(e)){return}var a=Object.keys(i.mSizeClasses).map(function(t){return i.mSizeClasses[t]});t.removeClass(a.join(" "));t.addClass(e)};i.prototype.setActiveLayout=function(t,a){var s=this.getContainerQuery()?t.$().outerWidth():window.innerWidth;var o=e.media.getCurrentRange("StdExt",s),u=i.mSizeLayouts[o.name],r=this._getLayoutToApply(u);this.applySizeClass(t.$(),i.mSizeClasses[o.name]);if(this._sActiveLayout===r){return}this._sActiveLayout=r;if(a){this.fireLayoutChange({layout:r})}};i.prototype._getLayoutToApply=function(t){if(this.getAggregation(t)){return t}return"layout"};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/cssgrid/GridSettings", ["sap/ui/base/ManagedObject","sap/ui/layout/library"],function(a){"use strict";var u=a.extend("sap.ui.layout.cssgrid.GridSettings",{metadata:{library:"sap.ui.layout",properties:{gridTemplateColumns:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridTemplateRows:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridRowGap:{type:"sap.ui.core.CSSSize",defaultValue:""},gridColumnGap:{type:"sap.ui.core.CSSSize",defaultValue:""},gridGap:{type:"sap.ui.layout.cssgrid.CSSGridGapShortHand",defaultValue:""},gridAutoRows:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridAutoColumns:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridAutoFlow:{type:"sap.ui.layout.cssgrid.CSSGridAutoFlow",defaultValue:"Row"}}}});return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/cssgrid/ResponsiveColumnItemLayoutData", ["sap/ui/core/LayoutData","sap/ui/layout/library"],function(t){"use strict";var e=t.extend("sap.ui.layout.cssgrid.ResponsiveColumnItemLayoutData",{metadata:{library:"sap.ui.layout",interfaces:["sap.ui.layout.cssgrid.IGridItemLayoutData"],properties:{columns:{type:"int",group:"Misc",defaultValue:1},rows:{type:"int",group:"Misc",defaultValue:1}}}});e.prototype.setItemStyles=function(t){t.style.setProperty("grid-row","span "+this.getRows());t.style.setProperty("grid-column","span "+this.getColumns())};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/cssgrid/ResponsiveColumnLayout", ["sap/ui/layout/cssgrid/GridLayoutBase","sap/ui/Device","sap/ui/layout/library"],function(t,e){"use strict";var a="RCLRangeSet";e.media.initRangeSet(a,[600,1024,1280,1440,1680,1920],"px",["S","M","ML","L","XL","XXL","XXXL"],true);var r=t.extend("sap.ui.layout.cssgrid.ResponsiveColumnLayout",{metadata:{library:"sap.ui.layout",properties:{},events:{layoutChange:{parameters:{layout:{type:"string"}}}}}});r.prototype._sCurrentLayoutClassName="";r.prototype.isResponsive=function(){return true};r.prototype.onGridAfterRendering=function(t){this._applyLayout(t)};r.prototype.getActiveGridSettings=function(){return null};r.prototype.onGridResize=function(t){if(!t||t.size.width===0){return}this._applyLayout(t.control)};r.prototype.addGridStyles=function(e){t.prototype.addGridStyles.apply(this,arguments);e.class("sapUiLayoutCSSGridRCL")};r.prototype._applyLayout=function(t){var r=t.getParent(),i=r?r.getDomRef().offsetWidth:t.getDomRef().parentElement.offsetWidth,o=e.media.getCurrentRange(a,i),s="sapUiLayoutCSSGridRCL-Layout"+o.name;if(this._sCurrentLayoutClassName===s){return}t.removeStyleClass(this._sCurrentLayoutClassName);t.addStyleClass(s);this._sCurrentLayoutClassName=s;this.fireLayoutChange({layout:o.name})};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/flexibility/BlockLayoutCell.flexibility", ["sap/ui/fl/changeHandler/BaseRename"],function(e){"use strict";return{hideControl:"default",moveControls:"default",rename:e.createRenameChangeHandler({propertyName:"title",translationTextType:"XTIT"}),unhideControl:"default"}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/flexibility/Form.flexibility", ["sap/ui/layout/changeHandler/AddFormContainer","sap/ui/layout/changeHandler/AddFormField"],function(d,e){"use strict";return{moveControls:"default",addGroup:d,addFormField:e}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/flexibility/FormContainer.flexibility", ["sap/ui/layout/changeHandler/RenameFormContainer","sap/ui/layout/changeHandler/AddFormField"],function(e,a){"use strict";return{hideControl:"default",renameGroup:e,moveControls:"default",addFormField:a}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/flexibility/FormElement.flexibility", ["sap/ui/layout/changeHandler/RenameFormElement"],function(e){"use strict";return{hideControl:"default",unhideControl:"default",renameField:e}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/flexibility/SimpleForm.flexibility", ["sap/ui/layout/changeHandler/RenameSimpleForm","sap/ui/layout/changeHandler/MoveSimpleForm","sap/ui/layout/changeHandler/HideSimpleForm","sap/ui/layout/changeHandler/UnhideSimpleForm","sap/ui/layout/changeHandler/AddSimpleFormGroup","sap/ui/layout/changeHandler/AddSimpleFormField"],function(e,i,l,m,a,r){"use strict";return{renameLabel:e,renameTitle:e,moveSimpleFormField:i,moveSimpleFormGroup:i,hideSimpleFormField:l,unhideSimpleFormField:m,removeSimpleFormGroup:l,addSimpleFormGroup:a,addSimpleFormField:r}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/ColumnContainerData", ["sap/ui/core/LayoutData","sap/ui/layout/library"],function(a,u){"use strict";var e=a.extend("sap.ui.layout.form.ColumnContainerData",{metadata:{library:"sap.ui.layout",properties:{columnsXL:{type:"sap.ui.layout.form.ColumnsXL",group:"Appearance",defaultValue:2},columnsL:{type:"sap.ui.layout.form.ColumnsL",group:"Appearance",defaultValue:2},columnsM:{type:"sap.ui.layout.form.ColumnsM",group:"Appearance",defaultValue:1}}}});return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/ColumnElementData", ["sap/ui/core/LayoutData","sap/ui/layout/library"],function(a,e){"use strict";var l=a.extend("sap.ui.layout.form.ColumnElementData",{metadata:{library:"sap.ui.layout",properties:{cellsLarge:{type:"sap.ui.layout.form.ColumnCells",group:"Appearance",defaultValue:8},cellsSmall:{type:"sap.ui.layout.form.ColumnCells",group:"Appearance",defaultValue:12}}}});return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/ColumnLayout", ["sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/layout/library","./FormLayout","./ColumnLayoutRenderer","sap/ui/thirdparty/jquery"],function(e,t,a,i,l,jQuery){"use strict";var s=i.extend("sap.ui.layout.form.ColumnLayout",{metadata:{library:"sap.ui.layout",properties:{columnsXL:{type:"sap.ui.layout.form.ColumnsXL",group:"Appearance",defaultValue:2},columnsL:{type:"sap.ui.layout.form.ColumnsL",group:"Appearance",defaultValue:2},columnsM:{type:"sap.ui.layout.form.ColumnsM",group:"Appearance",defaultValue:1},labelCellsLarge:{type:"sap.ui.layout.form.ColumnCells",group:"Appearance",defaultValue:4},emptyCellsLarge:{type:"sap.ui.layout.form.EmptyCells",group:"Appearance",defaultValue:0}}},renderer:l});s.prototype.init=function(){i.prototype.init.apply(this,arguments);this._iBreakPointTablet=e.media._predefinedRangeSets[e.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=e.media._predefinedRangeSets[e.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=e.media._predefinedRangeSets[e.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];this._resizeProxy=jQuery.proxy(o,this);if(typeof ResizeObserver==="function"){this._oResizeObserver=new ResizeObserver(this._resizeProxy)}};s.prototype.exit=function(){r.call(this);this._oResizeObserver=undefined};s.prototype.onBeforeRendering=function(e){i.prototype.onBeforeRendering.apply(this,arguments);if(this.getColumnsM()>this.getColumnsL()||this.getColumnsL()>this.getColumnsXL()){throw new Error("Column size not correct defined for "+this)}r.call(this)};s.prototype.onAfterRendering=function(e){if(this._oResizeObserver){var a=this.getDomRef();this._oResizeObserver.observe(a)}else{this._sResizeListener=t.register(this,this._resizeProxy)}n.call(this)};s.prototype.toggleContainerExpanded=function(e){e.$().toggleClass("sapUiFormCLContainerColl",!e.getExpanded())};s.prototype.onLayoutDataChange=function(e){this.invalidate()};s.prototype.onsapup=function(e){this.onsapleft(e)};s.prototype.onsapdown=function(e){this.onsapright(e)};s.prototype.getContainerRenderedDomRef=function(e){return e.getDomRef()};s.prototype.getElementRenderedDomRef=function(e){return e.getDomRef()};s.prototype._getContainerSize=function(e){var t=this.getParent();var a=this.getLayoutDataForElement(e,"sap.ui.layout.form.ColumnContainerData");var i=t.getVisibleFormContainers();var l=i.length;var s=this.getColumnsM();var r=this.getColumnsL();var o=this.getColumnsXL();var n={S:{Size:1,Break:false,FirstRow:false},M:{Size:1,Break:false,FirstRow:false},L:{Size:1,Break:false,FirstRow:false},XL:{Size:1,Break:false,FirstRow:false}};var u=function(e,t,a,i,l){if(a<e){t.Size=Math.floor(e/a);if(l&&t.Size*a<e){t.Size=t.Size+e-t.Size*a}}t.Break=e>1&&i>0&&i%e===0;t.FirstRow=a>1&&i<e};if(a){n.M.Size=a.getColumnsM();n.L.Size=a.getColumnsL();n.XL.Size=a.getColumnsXL();if(n.M.Size>s||n.L.Size>r||n.XL.Size>o){throw new Error("More cells defined for FormContainer "+e.getId()+" than columns on "+this)}}if(l===1){if(!a){n.M.Size=s;n.L.Size=r;n.XL.Size=o}n.S.FirstRow=true;n.M.FirstRow=true;n.L.FirstRow=true;n.XL.FirstRow=true}else{var f=0;var g=0;var m=0;var p;var C=false;var S=0;var L=s;var d=r;var h=o;var y=0;for(y=0;y<l;y++){if(e===i[y]){f=y;p=a}else{p=this.getLayoutDataForElement(i[y],"sap.ui.layout.form.ColumnContainerData")}if(!p){var v=i[y].getVisibleFormElements();if(g<v.length){g=v.length;m=y}S++}else{C=true;L=L-p.getColumnsM();d=d-p.getColumnsL();h=h-p.getColumnsXL()}}n.S.FirstRow=l>1&&f===0;n.S.Break=f>0;if(!C){u(s,n.M,l,f,f===m);u(r,n.L,l,f,f===m);u(o,n.XL,l,f,f===m)}else{if(!a){if(S<L){u(L,n.M,S,f,f===m)}if(S<d){u(d,n.L,S,f,f===m)}if(S<h){u(h,n.XL,S,f,f===m)}}var c={M:{rowColumns:0,lineBreak:false,first:true},L:{rowColumns:0,lineBreak:false,first:true},XL:{rowColumns:0,lineBreak:false,first:true}};var D=function(e,t,a){if(a){if(e.rowColumns+a<=t){e.rowColumns=e.rowColumns+a;e.lineBreak=false}else{e.rowColumns=a;if(t>1){e.lineBreak=true}e.first=false}}else{if(e.rowColumns<t){e.rowColumns++;e.lineBreak=false}else{e.rowColumns=1;if(t>1){e.lineBreak=true}e.first=false}}};for(y=0;y<l;y++){if(e===i[y]){p=a}else{p=this.getLayoutDataForElement(i[y],"sap.ui.layout.form.ColumnContainerData")}D(c.M,s,p?p.getColumnsM():0);D(c.L,r,p?p.getColumnsL():0);D(c.XL,o,p?p.getColumnsXL():0);if(e===i[y]){n.M.Break=c.M.lineBreak;n.L.Break=c.L.lineBreak;n.XL.Break=c.XL.lineBreak;n.M.FirstRow=c.M.first;n.L.FirstRow=c.L.first;n.XL.FirstRow=c.XL.first;break}}}}return n};s.prototype._getFieldSize=function(e){var t=12;var a=this.getLayoutDataForElement(e,"sap.ui.layout.form.ColumnElementData");var i={S:{Size:t,Break:false,Space:0},L:{Size:t,Break:false,Space:0}};var l=t;var s=this.getLabelCellsLarge();if(a){i.S.Size=a.getCellsSmall()===-1?t:a.getCellsSmall();i.L.Size=a.getCellsLarge()===-1?t:a.getCellsLarge()}var r=e.getParent();var o=r.getLabelControl();if(o===e){if(!a||a.getCellsSmall()===-1){i.S.Size=l}if(!a||a.getCellsLarge()===-1){i.L.Size=s}}else{var n=r.getFieldsForRendering();var u=n.length;var f=t;var g=t-this.getEmptyCellsLarge();if(o){var m=this.getLayoutDataForElement(o,"sap.ui.layout.form.ColumnElementData");if(m){l=m.getCellsSmall()===-1?l:m.getCellsSmall();s=m.getCellsLarge()===-1?s:m.getCellsLarge()}if(l<t){f=f-l}if(s<t){g=g-s}}else{l=0;s=0}if(u===1){if(!a||a.getCellsSmall()===-1){i.S.Size=f}else if(o){if(i.S.Size>f){i.S.Break=true}}if(!a||a.getCellsLarge()===-1){i.L.Size=g}else if(o){if(i.L.Size>g){i.L.Break=true}}}else{var p=0;var C=[];var S=[];var L={availableCells:f,first:0,last:999,firstDefault:-1,defaultFields:0};var d=0;var h=0;var y=0;var v;C.push(jQuery.extend({},L));L.availableCells=g;S.push(jQuery.extend({},L));var c=function(e,t,a,i){e[t].last=a-1;e.push(jQuery.extend({},L));t++;e[t].first=a;e[t].availableCells=i;return t};var D=function(e,a,i,l,s){if(e[a].availableCells-e[a].defaultFields<i){if(i<=l){a=c(e,a,s,l)}else{a=c(e,a,s,t)}}e[a].availableCells=e[a].availableCells-i;return a};var F=function(e,t,a,i){if(e[t].availableCells===e[t].defaultFields){t=c(e,t,i,a)}if(e[t].firstDefault<0){e[t].firstDefault=i}e[t].defaultFields++;return t};for(p=0;p<u;p++){if(e!==n[p]){v=this.getLayoutDataForElement(n[p],"sap.ui.layout.form.ColumnElementData")}else{v=a;y=p}if(v&&v.getCellsSmall()>0){d=D(C,d,v.getCellsSmall(),f,p)}else{d=F(C,d,f,p)}if(v&&v.getCellsLarge()>0){h=D(S,h,v.getCellsLarge(),g,p)}else{h=F(S,h,g,p)}}var z=function(e,a,i,l,s){var r=0;var o;for(p=0;p<e.length;p++){if(a>=e[p].first&&a<=e[p].last){o=e[p];break}}if(i<=0){l.Size=Math.floor(o.availableCells/o.defaultFields)}if(a===o.first&&a>0){l.Break=true;if(s>0&&s<t&&l.Size<=t-s){l.Space=s}}if(a===o.firstDefault){r=o.availableCells-o.defaultFields*l.Size;if(r>0){l.Size=l.Size+r}}};z(C,y,a?a.getCellsSmall():-1,i.S,l);z(S,y,a?a.getCellsLarge():-1,i.L,s)}}return i};function r(){if(this._oResizeObserver){this._oResizeObserver.disconnect()}if(this._sResizeListener){t.deregister(this._sResizeListener);this._sResizeListener=undefined}}function o(e,t){window.requestAnimationFrame(function(){n.call(this,e,t)}.bind(this))}function n(e,a){var i=this.getDomRef();if(!i){r.call(this);return}var l=this.$();if(!l.is(":visible")){return}if(t.isSuspended(i,this._resizeProxy)){return}var s=i.clientWidth;var o=1;if(s<=this._iBreakPointTablet){this.toggleStyleClass("sapUiFormCLMedia-Std-Phone",true);this.toggleStyleClass("sapUiFormCLMedia-Std-Desktop",false).toggleStyleClass("sapUiFormCLMedia-Std-Tablet",false).toggleStyleClass("sapUiFormCLMedia-Std-LargeDesktop",false)}else if(s>this._iBreakPointTablet&&s<=this._iBreakPointDesktop){this.toggleStyleClass("sapUiFormCLMedia-Std-Tablet",true);this.toggleStyleClass("sapUiFormCLMedia-Std-Desktop",false).toggleStyleClass("sapUiFormCLMedia-Std-Phone",false).toggleStyleClass("sapUiFormCLMedia-Std-LargeDesktop",false);o=this.getColumnsM()}else if(s>this._iBreakPointDesktop&&s<=this._iBreakPointLargeDesktop){this.toggleStyleClass("sapUiFormCLMedia-Std-Desktop",true);this.toggleStyleClass("sapUiFormCLMedia-Std-Phone",false).toggleStyleClass("sapUiFormCLMedia-Std-Tablet",false).toggleStyleClass("sapUiFormCLMedia-Std-LargeDesktop",false);o=this.getColumnsL()}else{this.toggleStyleClass("sapUiFormCLMedia-Std-LargeDesktop",true);this.toggleStyleClass("sapUiFormCLMedia-Std-Desktop",false).toggleStyleClass("sapUiFormCLMedia-Std-Phone",false).toggleStyleClass("sapUiFormCLMedia-Std-Tablet",false);o=this.getColumnsXL()}var n=this.getLabelCellsLarge()<12&&s/o>this._iBreakPointTablet;this.toggleStyleClass("sapUiFormCLWideColumns",n);this.toggleStyleClass("sapUiFormCLSmallColumns",!n)}s.prototype.getLayoutDataForDelimiter=function(){var e=sap.ui.require("sap/ui/layout/form/ColumnElementData");if(!e){var t;sap.ui.require(["sap/ui/layout/form/ColumnElementData"],function(e){t(new e({cellsLarge:1,cellsSmall:1}))});return new Promise(function(e){t=e})}else{return new e({cellsLarge:1,cellsSmall:1})}};s.prototype.getLayoutDataForSemanticField=function(e,t,a){if(a){if(a.isA("sap.ui.layout.form.ColumnElementData")){a.setCellsLarge(-1).setCellsSmall(11);return a}else{a.destroy()}}var i=sap.ui.require("sap/ui/layout/form/ColumnElementData");if(!i){var l;sap.ui.require(["sap/ui/layout/form/ColumnElementData"],function(e){l(new e({cellsLarge:-1,cellsSmall:11}))});return new Promise(function(e){l=e})}else{return new i({cellsLarge:-1,cellsSmall:11})}};s.prototype.renderControlsForSemanticElement=function(){return true};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/ColumnLayoutRenderer", ["sap/ui/core/Renderer","sap/ui/Device","./FormLayoutRenderer"],function(e,i,r){"use strict";var a=e.extend(r);a.apiVersion=2;a.getMainClass=function(){return"sapUiFormCL"};a.renderContainers=function(e,i,r){var a=r.getVisibleFormContainers();var t=a.length;if(t>0){var n=t===1&&!i.getLayoutDataForElement(a[0],"sap.ui.layout.form.ColumnContainerData");if(!n){var o=i.getColumnsM();var s=i.getColumnsL();var l=i.getColumnsXL();e.openStart("div");e.class("sapUiFormCLContent");e.class("sapUiFormCLColumnsM"+o);e.class("sapUiFormCLColumnsL"+s);e.class("sapUiFormCLColumnsXL"+l);e.openEnd()}for(var C=0;C<t;C++){var c=a[C];this.renderContainer(e,i,c)}if(!n){e.close("div")}}};a.renderContainer=function(e,r,a){var t=a.getExpandable();var n=a.getToolbar();var o=a.getTitle();var s=r._getContainerSize(a);a._checkProperties();e.openStart("section",a);e.class("sapUiFormCLContainer");e.class("sapUiFormCLContainerS"+s.S.Size);e.class("sapUiFormCLContainerM"+s.M.Size);e.class("sapUiFormCLContainerL"+s.L.Size);e.class("sapUiFormCLContainerXL"+s.XL.Size);if(s.M.Break){e.class("sapUiFormCLContainerMBreak")}if(s.L.Break){e.class("sapUiFormCLContainerLBreak")}if(s.XL.Break){e.class("sapUiFormCLContainerXLBreak")}if(s.S.FirstRow){e.class("sapUiFormCLContainerSFirstRow")}if(s.M.FirstRow){e.class("sapUiFormCLContainerMFirstRow")}if(s.L.FirstRow){e.class("sapUiFormCLContainerLFirstRow")}if(s.XL.FirstRow){e.class("sapUiFormCLContainerXLFirstRow")}if(n){e.class("sapUiFormContainerToolbar")}else if(o){e.class("sapUiFormContainerTitle")}if(!a.getExpanded()){e.class("sapUiFormCLContainerColl")}if(a.getTooltip_AsString()){e.attr("title",a.getTooltip_AsString())}this.writeAccessibilityStateContainer(e,a);e.openEnd();this.renderHeader(e,n,o,a._oExpandButton,t,r._sFormSubTitleSize,a.getId());e.openStart("div",a.getId()+"-content").class("sapUiFormCLContainerCont").openEnd();var l=a.getVisibleFormElements();for(var C=0;C<l.length;C++){var c=l[C];if(c.isA("sap.ui.layout.form.SemanticFormElement")&&!c._getEditable()){this.renderSemanticElement(e,r,c)}else{this.renderElement(e,r,c)}if(i.browser.chrome&&C<s.XL.Size-1&&l.length>1&&l.length<=s.XL.Size){e.openStart("div").class("sapUiFormCLElementDummy").openEnd().close("div")}}e.close("div");e.close("section")};a.renderElement=function(e,i,r){var a=r.getLabelControl();var n;e.openStart("div",r);e.class("sapUiFormCLElement");if(r.getTooltip_AsString()){e.attr("title",r.getTooltip_AsString())}e.openEnd();if(a){n=i._getFieldSize(a);t(e,a,n)}var o=r.getFieldsForRendering();if(o&&o.length>0){for(var s=0,l=o.length;s<l;s++){var C=o[s];if(!C.isA("sap.ui.core.IFormContent")){throw new Error(C+" is not a valid Form content! Only use valid content in "+i)}n=i._getFieldSize(C);e.openStart("div");e.class("sapUiFormCLCellsS"+n.S.Size);e.class("sapUiFormCLCellsL"+n.L.Size);if(n.S.Break){e.class("sapUiFormCLCellSBreak")}if(n.L.Break){e.class("sapUiFormCLCellLBreak")}if(n.S.Space){e.class("sapUiFormCLCellSSpace"+n.S.Space)}if(n.L.Space){e.class("sapUiFormCLCellLSpace"+n.L.Space)}e.openEnd();e.renderControl(C);e.close("div")}}e.close("div")};a.renderSemanticElement=function(e,i,r){var a=r.getLabelControl();var n;var o=12;var s=o;var l=o;e.openStart("div",r);e.class("sapUiFormCLElement").class("sapUiFormCLSemanticElement");if(r.getTooltip_AsString()){e.attr("title",r.getTooltip_AsString())}e.openEnd();if(a){n=i._getFieldSize(a);t(e,a,n);if(n.S.Size<s){s=s-n.S.Size}if(n.L.Size<l){l=l-n.L.Size}}e.openStart("div");e.class("sapUiFormCLCellsS"+s);e.class("sapUiFormCLCellsL"+l);e.openEnd();var C=r.getFieldsForRendering();if(C&&C.length>0){for(var c=0,p=C.length;c<p;c++){var m=C[c];if(!m.isA("sap.ui.core.IFormContent")||!m.isA("sap.ui.core.ISemanticFormContent")){throw new Error(m+" is not a valid Form content! Only use valid content in "+i)}e.renderControl(m)}}e.close("div");e.close("div")};function t(e,i,r){e.openStart("div").class("sapUiFormElementLbl").class("sapUiFormCLCellsS"+r.S.Size).class("sapUiFormCLCellsL"+r.L.Size).openEnd();e.renderControl(i);e.close("div")}return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/Form", ["sap/ui/core/Control","sap/ui/base/ManagedObjectObserver","./FormRenderer","./FormHelper"],function(e,t,i,o){"use strict";var r=e.extend("sap.ui.layout.form.Form",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},editable:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"formContainers",aggregations:{formContainers:{type:"sap.ui.layout.form.FormContainer",multiple:true,singularName:"formContainer"},title:{type:"sap.ui.core.Title",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},layout:{type:"sap.ui.layout.form.FormLayout",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/ui/layout/designtime/form/Form.designtime"},renderer:i});r.prototype.init=function(){this._oInitPromise=o.init();this._oObserver=new t(a.bind(this));this._oObserver.observe(this,{properties:["editable"],aggregations:["formContainers"]})};r.prototype.exit=function(){this._oObserver.disconnect();this._oObserver=undefined};r.prototype.toggleContainerExpanded=function(e){var t=this.getLayout();if(t){t.toggleContainerExpanded(e)}};r.prototype.contentOnAfterRendering=function(e,t){var i=this.getLayout();if(i&&i.contentOnAfterRendering){i.contentOnAfterRendering(e,t)}};r.prototype.onLayoutDataChange=function(e){var t=this.getLayout();if(t&&t.onLayoutDataChange){t.onLayoutDataChange(e)}};r.prototype.onBeforeFastNavigationFocus=function(e){var t=this.getLayout();if(t&&t.onBeforeFastNavigationFocus){t.onBeforeFastNavigationFocus(e)}};r.prototype.setEditable=function(e){this.setProperty("editable",e,true);return this};function n(e,t){if(e!=t&&this.getDomRef()){if(e){this.$().addClass("sapUiFormEdit").addClass("sapUiFormEdit-CTX");this.$().removeAttr("aria-readonly")}else{this.$().removeClass("sapUiFormEdit").removeClass("sapUiFormEdit-CTX");this.$().attr("aria-readonly","true")}}var i=this.getFormContainers();for(var o=0;o<i.length;o++){var r=i[o];r._setEditable(e)}}r.prototype.setToolbar=function(e){const t=this.getToolbar();this.setAggregation("toolbar",e);if(this._oInitPromise){this._oInitPromise.then(function(){delete this._oInitPromise;e=o.setToolbar(e,t)}.bind(this))}else{e=o.setToolbar(e,t)}return this};r.prototype.invalidate=function(t){if(!this._bNoInvalidate){e.prototype.invalidate.apply(this,arguments)}};r.prototype.getContainerRenderedDomRef=function(e){var t=this.getLayout();if(t&&t.getContainerRenderedDomRef){return t.getContainerRenderedDomRef(e)}else{return null}};r.prototype.getElementRenderedDomRef=function(e){var t=this.getLayout();if(t&&t.getElementRenderedDomRef){return t.getElementRenderedDomRef(e)}else{return null}};r.prototype.getVisibleFormContainers=function(){var e=this.getFormContainers();var t=[];for(var i=0;i<e.length;i++){var o=e[i];if(o.isVisible()){t.push(o)}}return t};r.prototype._suggestTitleId=function(e){this._sSuggestedTitleId=e;if(this.getDomRef()){this.invalidate()}return this};function a(e){if(e.name==="editable"){n.call(this,e.current,e.old)}else if(e.name==="formContainers"){s.call(this,e.mutation,e.child)}}function s(e,t){if(e==="insert"){t._setEditable(this.getEditable())}}return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/FormContainer", ["sap/ui/core/Element","sap/ui/base/ManagedObjectObserver","sap/ui/core/theming/Parameters","./FormHelper","sap/base/Log"],function(e,t,i,n,o){"use strict";var r=e.extend("sap.ui.layout.form.FormContainer",{metadata:{library:"sap.ui.layout",properties:{expanded:{type:"boolean",group:"Misc",defaultValue:true},expandable:{type:"boolean",group:"Misc",defaultValue:false},visible:{type:"boolean",group:"Misc",defaultValue:true},_editable:{type:"boolean",group:"Misc",defaultValue:false,visibility:"hidden"}},defaultAggregation:"formElements",aggregations:{formElements:{type:"sap.ui.layout.form.FormElement",multiple:true,singularName:"formElement"},title:{type:"sap.ui.core.Title",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},_expandButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/ui/layout/designtime/form/FormContainer.designtime"}});r.prototype.init=function(){this._oInitPromise=n.init();this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");this._oObserver=new t(this._observeChanges.bind(this));this._oObserver.observe(this,{properties:["expanded","expandable"],aggregations:["formElements"]})};r.prototype.exit=function(){if(this._oExpandButton){delete this._oExpandButton}this._rb=undefined;this._oObserver.disconnect();this._oObserver=undefined};function a(e){if(e){if(!this._oExpandButton){if(this._oInitPromise){this._oInitPromise.then(function(){delete this._oInitPromise;s.call(this,n.createButton(this.getId()+"--Exp",p,this))}.bind(this))}else{s.call(this,n.createButton(this.getId()+"--Exp",p,this))}}else{u.call(this)}}}function s(e){if(!this._bIsBeingDestroyed){this._oExpandButton=e;this.setAggregation("_expandButton",this._oExpandButton);u.call(this)}}function l(e){u.call(this);var t=this.getParent();if(t&&t.toggleContainerExpanded){t.toggleContainerExpanded(this)}}r.prototype.setToolbar=function(e){const t=this.getToolbar();this.setAggregation("toolbar",e);if(this._oInitPromise){this._oInitPromise.then(function(){delete this._oInitPromise;e=n.setToolbar(e,t)}.bind(this))}else{e=n.setToolbar(e,t)}return this};r.prototype.contentOnAfterRendering=function(e,t){var i=this.getParent();if(i&&i.contentOnAfterRendering){i.contentOnAfterRendering(e,t)}};r.prototype.onLayoutDataChange=function(e){var t=this.getParent();if(t&&t.onLayoutDataChange){t.onLayoutDataChange(e)}};r.prototype._checkProperties=function(){var e=0;if(this.getExpandable()&&(!this.getTitle()||this.getToolbar())){o.warning("Expander only displayed if title is set",this.getId(),"FormContainer");e=1}return e};r.prototype.getRenderedDomRef=function(){var e=this;var t=this.getParent();if(t&&t.getContainerRenderedDomRef){return t.getContainerRenderedDomRef(e)}else{return null}};r.prototype.getElementRenderedDomRef=function(e){var t=this.getParent();if(t&&t.getElementRenderedDomRef){return t.getElementRenderedDomRef(e)}else{return null}};r.prototype.getVisibleFormElements=function(){var e=this.getFormElements();var t=[];for(var i=0;i<e.length;i++){var n=e[i];if(n.isVisible()){t.push(n)}}return t};r.prototype._setEditable=function(e){var t=this.getProperty("_editable");this.setProperty("_editable",e,true);if(e!==t){var i=this.getFormElements();for(var n=0;n<i.length;n++){var o=i[n];o._setEditable(e)}}};r.prototype.isVisible=function(){return this.getVisible()};function u(){if(!this._oExpandButton){return}var e,t,o,r;if(this.getExpanded()){e=i._getThemeImage("_sap_ui_layout_Form_FormContainerColImageURL");t=i._getThemeImage("_sap_ui_layout_Form_FormContainerColImageDownURL");o="-";r=this._rb.getText("FORM_COLLAPSE")}else{e=i._getThemeImage("_sap_ui_layout_Form_FormContainerExpImageURL");t=i._getThemeImage("_sap_ui_layout_Form_FormContainerExpImageDownURL");o="+";r=this._rb.getText("FORM_EXPAND")}if(e){o=""}n.setButtonContent(this._oExpandButton,o,r,e,t)}function p(e){this.setExpanded(!this.getExpanded())}r.prototype._observeChanges=function(e){if(e.name=="formElements"){d.call(this,e.mutation,e.child)}else if(e.name=="expanded"){l.call(this,e.current)}else if(e.name=="expandable"){a.call(this,e.current)}};function d(e,t){if(e==="insert"){var i=this.getProperty("_editable");t._setEditable(i)}}return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/FormElement", ["sap/ui/core/Element","sap/ui/core/Control","sap/ui/base/ManagedObjectObserver","./FormHelper","sap/base/Log"],function(e,t,i,s,a){"use strict";var r=e.extend("sap.ui.layout.form.FormElement",{metadata:{library:"sap.ui.layout",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true},_editable:{type:"boolean",group:"Misc",defaultValue:false,visibility:"hidden"}},defaultAggregation:"fields",aggregations:{label:{type:"sap.ui.core.Label",altTypes:["string"],multiple:false},_label:{type:"sap.ui.core.Label",multiple:false,visibility:"hidden"},fields:{type:"sap.ui.core.Control",multiple:true,singularName:"field"}},designtime:"sap/ui/layout/designtime/form/FormElement.designtime"}});r.prototype.init=function(){this._oInitPromise=s.init();this._oFieldDelegate={oElement:this,onAfterRendering:f};this._oObserver=new i(this._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["fields"]})};r.prototype.exit=function(){if(this._oLabel){delete this._oLabel}this._oFieldDelegate=undefined;this._oObserver.disconnect();this._oObserver=undefined};r.prototype.setLabel=function(e){if(!this._oLabel){var t=this.getLabel();if(t){if(t.setAlternativeLabelFor){t.setAlternativeLabelFor(null)}if(t.isRequired){t.isRequired=t._sapuiIsRequired;t._sapuiIsRequired=undefined;t.disableRequiredChangeCheck(false)}if(t.isDisplayOnly){t.isDisplayOnly=t._sapuiIsDisplayOnly;t._sapuiIsDisplayOnly=undefined}if(t.isWrapping){t.isWrapping=t._sapuiIsWrapping;t._sapuiIsWrapping=undefined}}}this.setAggregation("label",e);var i=e;if(typeof i==="string"){if(this._oInitPromise){this._oInitPromise.then(function(){delete this._oInitPromise;var e=this.getLabel();if(typeof e==="string"){this._setInternalLabel(e)}}.bind(this))}else{this._setInternalLabel(i)}}else{if(this._oLabel){this._oLabel.destroy();delete this._oLabel}if(i&&i.isRequired){i._sapuiIsRequired=i.isRequired;i.isRequired=o;i.disableRequiredChangeCheck(true)}if(i&&i.isDisplayOnly){i._sapuiIsDisplayOnly=i.isDisplayOnly;i.isDisplayOnly=u}if(i&&i.isWrapping){i._sapuiIsWrapping=i.isWrapping;i.isWrapping=p}h.call(this)}return this};r.prototype._setInternalLabel=function(e){if(!this._oLabel){this._oLabel=s.createLabel(e,this.getId()+"-label");this.setAggregation("_label",this._oLabel);this._oLabel.disableRequiredChangeCheck(true);if(this._oLabel.isRequired){this._oLabel.isRequired=o}if(this._oLabel.isDisplayOnly){this._oLabel.isDisplayOnly=u}if(this._oLabel.setWrapping){this._oLabel.setWrapping(true)}}else{this._oLabel.setText(e)}h.call(this)};r.prototype.destroyLabel=function(){this.destroyAggregation("label");if(this._oLabel){this._oLabel.destroy();delete this._oLabel}return this};r.prototype.getLabelControl=function(){if(this._oLabel){return this._oLabel}else{var e=this.getLabel();if(typeof e==="string"){e=null}return e}};r.prototype.updateFields=function(){var e=this.getFields();var t;var i=0;for(i=0;i<e.length;i++){t=e[i];g.call(this,t)}this.updateAggregation("fields");e=this.getFields();for(i=0;i<e.length;i++){t=e[i];d.call(this,t)}h.call(this);return this};r.prototype.enhanceAccessibilityState=function(e,t){var i=this.getLabelControl();if(i&&i!=e&&e.getMetadata().getAllAssociations().ariaLabelledBy){var s=t["labelledby"];if(!s){s=i.getId()}else{var a=s.split(" ");if(a.indexOf(i.getId())<0){a.splice(0,0,i.getId());s=a.join(" ")}}t["labelledby"]=s}};r.prototype.onLayoutDataChange=function(e){var t=this.getParent();if(t&&t.onLayoutDataChange){t.onLayoutDataChange(e)}};r.prototype.getRenderedDomRef=function(){var e=this;var t=this.getParent();if(t&&t.getElementRenderedDomRef){return t.getElementRenderedDomRef(e)}else{return null}};r.prototype._setEditable=function(e){var t=this._getEditable();this.setProperty("_editable",e,true);if(e!==t){this.invalidateLabel()}};r.prototype._getEditable=function(){return this.getProperty("_editable")};r.prototype.invalidateLabel=function(){var e=this.getLabelControl();if(e&&e.getDomRef()){e.invalidate()}};r.prototype.isVisible=function(){return this.getVisible()};r.prototype.getFieldsForRendering=function(){return this.getFields()};r.prototype._observeChanges=function(e){if(e.object==this){if(e.name=="fields"){l.call(this,e.child,e.mutation)}}else{n.call(this,e)}};function l(e,t){if(t=="insert"){if(!e.isA("sap.ui.core.IFormContent")){a.warning(e+" is not valid Form content",this)}d.call(this,e)}else{g.call(this,e)}h.call(this)}function n(e){if(e.name=="required"||e.name=="editable"){this.invalidateLabel()}}function o(){if(this.getRequired&&this.getRequired()){return true}var e=this.getParent();var t=e.getFields();for(var i=0;i<t.length;i++){var s=t[i];if(s.getRequired&&s.getRequired()===true&&(!s.getEditable||s.getEditable())){return true}}return false}function u(){if(this.getDisplayOnly){if(!this.isPropertyInitial("displayOnly")){return this.getDisplayOnly()}var e=this.getParent();return!e._getEditable()}return false}function p(){if(this.getWrapping&&!this.isPropertyInitial("wrapping")){return this.getWrapping()}return true}function h(){var e=this.getFields();var i=e.length>0?e[0]:null;var s=this._oLabel;if(s){s.setLabelFor(i)}else{s=this.getLabel();if(s instanceof t){s.setAlternativeLabelFor(i)}}}function d(e){e.addDelegate(this._oFieldDelegate);if(!this._bNoObserverChange){if(e.getMetadata().getProperty("required")){this._oObserver.observe(e,{properties:["required"]})}if(e.getMetadata().getProperty("editable")){this._oObserver.observe(e,{properties:["editable"]})}}}function g(e){e.removeDelegate(this._oFieldDelegate);if(!this._bNoObserverChange){this._oObserver.unobserve(e)}}function f(e){var t=this.oElement.getParent();if(t&&t.contentOnAfterRendering){t.contentOnAfterRendering(this.oElement,e.srcControl)}}return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/FormHelper", ["sap/ui/core/Lib","sap/ui/core/library","sap/base/util/merge"],function(t,e,n){"use strict";const i={Label:undefined,Button:undefined,Text:undefined,Library:undefined,init:function(){this.Label=sap.ui.require("sap/m/Label");this.Text=sap.ui.require("sap/m/Text");this.Button=sap.ui.require("sap/m/Button");this.Library=sap.ui.require("sap/m/library");if(!this.Label||!this.Text||!this.Button||!this.Library){if(!this.oInitPromise){this.oInitPromise=new Promise(function(t,e){sap.ui.require(["sap/m/Label","sap/m/Text","sap/m/Button","sap/m/library"],function(e,n,i,r){this.Label=e;this.Text=n;this.Button=i;this.Library=r;t(true)}.bind(this))}.bind(this))}return this.oInitPromise}else if(this.oInitPromise){delete this.oInitPromise}return null},createLabel:function(t,e){return new this.Label(e,{text:t})},createButton:function(t,e,n){const i=new this.Button(t,{type:this.Library.ButtonType.Transparent});i.attachEvent("press",e,n);return i},setButtonContent:function(t,e,n,i,r){t.setText(e);t.setTooltip(n);t.setIcon(i);t.setActiveIcon(r)},addFormClass:function(){return"sapUiFormM"},setToolbar:function(t,e){if(e&&e.setDesign){e.setDesign(e.getDesign(),true)}if(t&&t.setDesign){const e=t.getMetadata().getManagedProperty("design");if(e&&e.type==="sap.m.ToolbarDesign"){t.setDesign(this.Library.ToolbarDesign.Transparent,true)}}return t},getToolbarTitle:function(t){if(t){const e=t.getContent?t.getContent():[];for(let t=0;t<e.length;t++){const n=e[t];if(n.isA("sap.m.Title")){return n.getId()}}return t.getId()}},createDelimiter:function(t,n){return new this.Text(n,{text:t,textAlign:e.TextAlign.Center})},createSemanticDisplayControl:function(t,e){return new this.Text(e,{text:t})},updateDelimiter:function(t,e){t.setText(e)},updateSemanticDisplayControl:function(t,e){t.setText(e)},isArrowKeySupported:function(){return false}};const r={init:function(){return null},createLabel:function(t,e){return new sap.ui.commons.Label(e,{text:t})},createButton:function(t,e,n){const i=new sap.ui.commons.Button(t,{lite:true});i.attachEvent("press",e,n);return i},setButtonContent:function(t,e,n,i,r){t.setText(e);t.setTooltip(n);t.setIcon(i);t.setIconHovered(r)},getToolbarTitle:function(t){return t&&t.getId()}};const o={init:function(){if(t.isLoaded("sap.m")){n(o,i);return this.init()}if(t.isLoaded("sap.ui.commons")&&!t.isLoaded("sap.m")){n(o,r);return this.init()}return null},createLabel:function(t){throw new Error("no Label control available!")},createButton:function(t,e,n){throw new Error("no Button control available!")},setButtonContent:function(t,e,n,i,r){throw new Error("no Button control available!")},addFormClass:function(){return null},setToolbar:function(t,e){return t},getToolbarTitle:function(t){return t&&t.getId()},createDelimiter:function(t,e){throw new Error("no delimiter control available!")},createSemanticDisplayControl:function(t,e){throw new Error("no display control available!")},updateDelimiter:function(t,e){throw new Error("no delimiter control available!")},updateSemanticDisplayControl:function(t,e){throw new Error("no display control available!")},isArrowKeySupported:function(){return true}};return o},false);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/FormLayout", ["sap/ui/core/Control","sap/ui/core/Element","sap/ui/layout/library","./FormLayoutRenderer","./FormHelper","sap/ui/core/theming/Parameters","sap/ui/thirdparty/jquery","sap/ui/core/Configuration","sap/ui/dom/jquery/Selectors"],function(e,t,r,i,n,o,jQuery,a){"use strict";var s=r.BackgroundDesign;var l=e.extend("sap.ui.layout.form.FormLayout",{metadata:{library:"sap.ui.layout",properties:{backgroundDesign:{type:"sap.ui.layout.BackgroundDesign",group:"Appearance",defaultValue:s.Translucent}}},renderer:i});l.prototype.init=function(){this._oInitPromise=n.init();this._sFormTitleSize="H4";this._sFormSubTitleSize="H5"};l.prototype.onBeforeRendering=function(e){this.loadTitleSizes()};l.prototype.contentOnAfterRendering=function(e,t){if(n.isArrowKeySupported()){jQuery(t.getFocusDomRef()).data("sap.InNavArea",true)}if(this.renderControlsForSemanticElement()&&e.isA("sap.ui.layout.form.SemanticFormElement")&&!e._getEditable()){t.$().css("max-width","100%")}else if(t.getWidth&&(!t.getWidth()||t.getWidth()=="auto")&&(!t.getFormDoNotAdjustWidth||!t.getFormDoNotAdjustWidth())){t.$().css("width","100%")}};l.prototype.toggleContainerExpanded=function(e){var t=e.getExpanded();if(this.getDomRef()){if(t){e.$("content").css("display","")}else{e.$("content").css("display","none")}}};l.prototype.getLayoutDataForElement=function(e,t){var r=e.getLayoutData();if(!r){return undefined}else if(r.isA(t)){return r}else if(r.isA("sap.ui.core.VariantLayoutData")){var i=r.getMultipleLayoutData();for(var n=0;n<i.length;n++){var o=i[n];if(o.isA(t)){return o}}}};l.prototype.onsapright=function(e){if(n.isArrowKeySupported()){var t=a.getRTL();if(!t){this.navigateForward(e)}else{this.navigateBack(e)}}};l.prototype.onsapleft=function(e){if(n.isArrowKeySupported()){var t=a.getRTL();if(!t){this.navigateBack(e)}else{this.navigateForward(e)}}};l.prototype.onsapdown=function(e){if(n.isArrowKeySupported()){var t=e.srcControl;var r;var i=this.findElement(t);var o=i.element;t=i.rootControl;if(o&&o.isA("sap.ui.layout.form.FormElement")){r=this.findFieldBelow(t,o)}else if(o&&o.isA("sap.ui.layout.form.FormContainer")){r=this.findFirstFieldOfNextElement(o,0)}if(r){r.focus();e.preventDefault()}}};l.prototype.onsapup=function(e){if(n.isArrowKeySupported()){var t=e.srcControl;var r=0;var i;var o=this.findElement(t);var a=o.element;t=o.rootControl;if(a&&a.isA("sap.ui.layout.form.FormElement")){i=this.findFieldAbove(t,a)}else if(a&&a.isA("sap.ui.layout.form.FormContainer")){var s=a.getParent();r=s.indexOfFormContainer(a);i=this.findLastFieldOfLastElementInPrevContainer(s,r-1)}if(i){i.focus();e.preventDefault()}}};l.prototype.onsaphome=function(e){if(n.isArrowKeySupported()){var t=e.srcControl;var r=0;var i;var o=this.findElement(t);var a=o.element;var s=a.getParent();var l=s.getParent();r=l.indexOfFormContainer(s);i=this.findFirstFieldOfFirstElementInNextContainer(l,r);if(i){i.focus();e.preventDefault()}}};l.prototype.onsaptop=function(e){if(n.isArrowKeySupported()){var t=e.srcControl;var r=this.findElement(t);var i=r.element;var o;var a;if(i&&i.isA("sap.ui.layout.form.FormElement")){a=i.getParent()}else if(i&&i.isA("sap.ui.layout.form.FormContainer")){a=i}var s=a.getParent();o=this.findFirstFieldOfForm(s);if(o){o.focus();e.preventDefault()}}};l.prototype.onsapend=function(e){if(n.isArrowKeySupported()){var t=e.srcControl;var r=0;var i;var o=this.findElement(t);var a=o.element;var s=a.getParent();var l=s.getParent();r=l.indexOfFormContainer(s);i=this.findLastFieldOfLastElementInPrevContainer(l,r);if(i){i.focus();e.preventDefault()}}};l.prototype.onsapbottom=function(e){if(n.isArrowKeySupported()){var t=e.srcControl;var r=this.findElement(t);var i=r.element;var o;var a;if(i&&i.isA("sap.ui.layout.form.FormElement")){a=i.getParent()}else if(i&&i.isA("sap.ui.layout.form.FormContainer")){a=i}var s=a.getParent();var l=s.getFormContainers();var f=l.length;o=this.findLastFieldOfLastElementInPrevContainer(s,f-1);if(o){o.focus();e.preventDefault()}}};l.prototype.onsapexpand=function(e){var t=e.srcControl;var r=this.findElement(t);var i=r.element;var n;if(i.isA("sap.ui.layout.form.FormContainer")){n=i}else{n=i.getParent()}if(n.getExpandable()&&t===n._oExpandButton){n.setExpanded(true)}};l.prototype.onsapcollapse=function(e){var t=e.srcControl;var r=this.findElement(t);var i=r.element;var n;if(i.isA("sap.ui.layout.form.FormContainer")){n=i}else{n=i.getParent()}if(n.getExpandable()&&t===n._oExpandButton){n.setExpanded(false)}};l.prototype.onsapskipforward=function(e){var t=e.srcControl;var r=this.findElement(t);var i=r.element;t=r.rootControl;var n;var o;if(i&&i.isA("sap.ui.layout.form.FormElement")){o=i.getParent()}else if(i&&i.isA("sap.ui.layout.form.FormContainer")){o=i}var a=o.getParent();var s=a.indexOfFormContainer(o);n=this.findFirstFieldOfFirstElementInNextContainer(a,s+1);if(n){n.focus();e.preventDefault()}};l.prototype.onsapskipback=function(e){var t=e.srcControl;var r=this.findElement(t);var i=r.element;t=r.rootControl;var n;var o;if(i&&i.isA("sap.ui.layout.form.FormElement")){o=i.getParent()}else if(i&&i.isA("sap.ui.layout.form.FormContainer")){o=i}var a=o.getParent();var s=a.getFormContainers();var l=a.indexOfFormContainer(o);while(!n&&l>0){var f=s[l-1];if(!f.getExpandable()||f.getExpanded()){n=this.findFirstFieldOfFirstElementInPrevContainer(a,l-1)}l=l-1}if(n&&n!==t.getFocusDomRef()){n.focus();e.preventDefault()}};l.prototype.onBeforeFastNavigationFocus=function(e){if(jQuery.contains(this.getDomRef(),e.source)){e.srcControl=t.closestTo(e.source);if(e.forward){this.onsapskipforward(e)}else{this.onsapskipback(e)}}else{var r=e.forward?this.findFirstFieldOfForm(this.getParent()):this.findFirstFieldOfLastContainerOfForm(this.getParent());if(r){r.focus();e.preventDefault()}}};l.prototype.findElement=function(e){var t=e.getParent();var r=e;while(t&&!t.isA("sap.ui.layout.form.FormElement")&&!t.isA("sap.ui.layout.form.FormContainer")&&!t.isA("sap.ui.layout.form.Form")){r=t;t=t.getParent()}return{rootControl:r,element:t}};l.prototype.navigateForward=function(e){var t=e.srcControl;var r=0;var i;var n=this.findElement(t);var o=n.element;t=n.rootControl;if(o&&o.isA("sap.ui.layout.form.FormElement")){if(t==o.getLabelControl()){r=-1}else{r=o.indexOfField(t)}i=this.findNextFieldOfElement(o,r+1);if(!i){var a=o.getParent();r=a.indexOfFormElement(o);i=this.findFirstFieldOfNextElement(a,r+1);if(!i){var s=a.getParent();r=s.indexOfFormContainer(a);i=this.findFirstFieldOfFirstElementInNextContainer(s,r+1)}}}else if(o&&o.isA("sap.ui.layout.form.FormContainer")){i=this.findFirstFieldOfNextElement(o,0)}if(i){i.focus();e.preventDefault()}};l.prototype.tabForward=function(e){var t;var r=e.srcControl;var i=0;var n;var o=this.findElement(r);var a=o.element;r=o.rootControl;if(a&&a.isA("sap.ui.layout.form.FormElement")){if(r==a.getLabelControl()){i=-1}else{i=a.indexOfField(r)}n=this.findNextFieldOfElement(a,i+1,true);if(!n){var s=a.getParent();i=s.indexOfFormElement(a);n=this.findFirstFieldOfNextElement(s,i+1,true);if(!n){t=s.getParent();i=t.indexOfFormContainer(s);n=this.findFirstFieldOfFirstElementInNextContainer(t,i+1,true)}}}else if(a&&a.isA("sap.ui.layout.form.FormContainer")){n=this.findFirstFieldOfNextElement(a,0,true);if(!n){t=a.getParent();i=t.indexOfFormContainer(a);n=this.findFirstFieldOfFirstElementInNextContainer(t,i+1,true)}}if(n){n.focus();e.preventDefault()}};l.prototype.findNextFieldOfElement=function(e,t,r){var i=e.getFieldsForRendering();var n=i.length;var o;for(var a=t;a<n;a++){var s=i[a];var l=this._getDomRef(s);if(r==true){if((!s.getEditable||s.getEditable())&&(!s.getEnabled||s.getEnabled())&&l){o=l;break}}else{if((!s.getEnabled||s.getEnabled())&&l){o=l;break}}}return o};l.prototype.findFirstFieldOfNextElement=function(e,t,r){var i=e.getFormElements();var n=i.length;var o;var a=t;while(!o&&a<n){var s=i[a];if(r==true){o=this.findNextFieldOfElement(s,0,true)}else{o=this.findNextFieldOfElement(s,0)}a++}return o};l.prototype.findFirstFieldOfForm=function(e){var t=this.findFirstFieldOfFirstElementInNextContainer(e,0);return t};l.prototype.findFirstFieldOfLastContainerOfForm=function(e){var t;var r=e.getFormContainers();var i=r.length;while(!t&&i>0){var n=r[i-1];if(!n.getExpandable()||n.getExpanded()){t=this.findFirstFieldOfFirstElementInPrevContainer(e,i-1)}i=i-1}return t};l.prototype.findFirstFieldOfFirstElementInNextContainer=function(e,t,r){var i=e.getFormContainers();var n=i.length;var o;var a=t;while(!o&&a<n){var s=i[a];if(s.getExpandable()&&r){o=s._oExpandButton.getFocusDomRef();if(o){break}}if(!s.getExpandable()||s.getExpanded()){if(r==true){o=this.findFirstFieldOfNextElement(s,0,true)}else{o=this.findFirstFieldOfNextElement(s,0)}}a++}return o};l.prototype.findFirstFieldOfFirstElementInPrevContainer=function(e,t){var r=e.getFormContainers();var i=r.length;var n;var o=t;while(!n&&o<i&&o>=0){var a=r[o];if(!a.getExpandable()||a.getExpanded()){n=this.findFirstFieldOfNextElement(a,0)}o++}return n};l.prototype.navigateBack=function(e){var t;var r=e.srcControl;var i=0;var n;var o=this.findElement(r);var a=o.element;r=o.rootControl;if(a&&a.isA("sap.ui.layout.form.FormElement")){if(r==a.getLabelControl()){i=0}else{i=a.indexOfField(r)}n=this.findPrevFieldOfElement(a,i-1);if(!n){var s=a.getParent();i=s.indexOfFormElement(a);n=this.findLastFieldOfPrevElement(s,i-1);if(!n){t=s.getParent();i=t.indexOfFormContainer(s);n=this.findLastFieldOfLastElementInPrevContainer(t,i-1)}}}else if(a&&a.isA("sap.ui.layout.form.FormContainer")){t=a.getParent();i=t.indexOfFormContainer(a);n=this.findLastFieldOfLastElementInPrevContainer(t,i-1)}if(n){n.focus();e.preventDefault()}};l.prototype.tabBack=function(e){var t;var r=e.srcControl;var i=0;var n;var o=this.findElement(r);var a=o.element;r=o.rootControl;if(a&&a.isA("sap.ui.layout.form.FormElement")){if(r==a.getLabelControl()){i=0}else{i=a.indexOfField(r)}n=this.findPrevFieldOfElement(a,i-1,true);if(!n){var s=a.getParent();i=s.indexOfFormElement(a);n=this.findLastFieldOfPrevElement(s,i-1,true);if(!n){t=s.getParent();i=t.indexOfFormContainer(s);if(s.getExpandable()){n=s._oExpandButton.getFocusDomRef()}if(!n){n=this.findLastFieldOfLastElementInPrevContainer(t,i-1,true)}}}}else if(a&&a.isA("sap.ui.layout.form.FormContainer")){t=a.getParent();i=t.indexOfFormContainer(a);n=this.findLastFieldOfLastElementInPrevContainer(t,i-1,true)}if(n){n.focus();e.preventDefault()}};l.prototype.findPrevFieldOfElement=function(e,t,r){var i=e.getFieldsForRendering();var n;for(var o=t;o>=0;o--){var a=i[o];var s=this._getDomRef(a);if(r==true){if((!a.getEditable||a.getEditable())&&(!a.getEnabled||a.getEnabled())&&s){n=s;break}}else{if((!a.getEnabled||a.getEnabled())&&s){n=s;break}}}return n};l.prototype.findLastFieldOfPrevElement=function(e,t,r){var i=e.getFormElements();var n;var o=t;while(!n&&o>=0){var a=i[o];var s=a.getFieldsForRendering().length;if(r==true){n=this.findPrevFieldOfElement(a,s-1,true)}else{n=this.findPrevFieldOfElement(a,s-1)}o--}return n};l.prototype.findLastFieldOfLastElementInPrevContainer=function(e,t,r){var i=e.getFormContainers();var n;var o=t;while(!n&&o>=0){var a=i[o];if(a.getExpandable()&&!a.getExpanded()&&r){n=a._oExpandButton.getFocusDomRef();if(n){break}}if(!a.getExpandable()||a.getExpanded()){var s=a.getFormElements().length;if(r==true){n=this.findLastFieldOfPrevElement(a,s-1,true)}else{n=this.findLastFieldOfPrevElement(a,s-1,0)}}o--}return n};l.prototype.findFieldBelow=function(e,t){var r=t.getParent();var i=r.indexOfFormElement(t);var n=this.findFirstFieldOfNextElement(r,i+1);if(!n){var o=r.getParent();i=o.indexOfFormContainer(r);n=this.findFirstFieldOfFirstElementInNextContainer(o,i+1)}return n};l.prototype.findFieldAbove=function(e,t){var r=t.getParent();var i=r.indexOfFormElement(t);var n=r.getFormElements();var o;var a=i-1;while(!o&&a>=0){var s=n[a];o=this.findPrevFieldOfElement(s,0);a--}if(!o){var l=r.getParent();i=l.indexOfFormContainer(r);o=this.findLastFieldOfLastElementInPrevContainer(l,i-1)}return o};l.prototype._getDomRef=function(e){var t=e.getFocusDomRef();if(!jQuery(t).is(":sapFocusable")){t=undefined}return t};l.prototype.getContainerRenderedDomRef=function(e){if(this.getDomRef()){return e.getDomRef()}else{return null}};l.prototype.getElementRenderedDomRef=function(e){if(this.getDomRef()){return e.getDomRef()}else{return null}};l.prototype.getLayoutDataForDelimiter=function(){};l.prototype.getLayoutDataForSemanticField=function(e,t,r){};l.prototype.renderControlsForSemanticElement=function(){return false};l.prototype.loadTitleSizes=function(){var e=o.get({name:["sap.ui.layout.FormLayout:_sap_ui_layout_FormLayout_FormTitleSize","sap.ui.layout.FormLayout:_sap_ui_layout_FormLayout_FormSubTitleSize"],callback:this.applyTitleSizes.bind(this)});if(e&&e.hasOwnProperty("sap.ui.layout.FormLayout:_sap_ui_layout_FormLayout_FormTitleSize")){this.applyTitleSizes(e,true)}};l.prototype.applyTitleSizes=function(e,t){if(e&&(this._sFormTitleSize!==e["sap.ui.layout.FormLayout:_sap_ui_layout_FormLayout_FormTitleSize"]||this._sFormSubTitleSize!==e["sap.ui.layout.FormLayout:_sap_ui_layout_FormLayout_FormSubTitleSize"])){this._sFormTitleSize=e["sap.ui.layout.FormLayout:_sap_ui_layout_FormLayout_FormTitleSize"];this._sFormSubTitleSize=e["sap.ui.layout.FormLayout:_sap_ui_layout_FormLayout_FormSubTitleSize"];if(!t){this.invalidate()}}};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/FormLayoutRenderer", ["sap/ui/core/library","sap/ui/layout/library","sap/ui/layout/form/Form","./FormHelper","sap/ui/core/IconPool"],function(e,t,r,i,n){"use strict";var a=e.TitleLevel;var o=t.BackgroundDesign;var l={apiVersion:2};l.render=function(e,t){var i=t.getParent();if(i&&i instanceof r){this.renderForm(e,t,i)}};l.renderForm=function(e,t,r){var i=r.getToolbar();e.openStart("div",t);e.class(this.getMainClass());if(i){e.class("sapUiFormToolbar")}this.addBackgroundClass(e,t);e.openEnd();this.renderHeader(e,i,r.getTitle(),undefined,false,t._sFormTitleSize,r.getId());this.renderContainers(e,t,r);e.close("div")};l.getMainClass=function(){return"sapUiFormLayout"};l.addBackgroundClass=function(e,t){var r=t.getBackgroundDesign();if(r!=o.Transparent){e.class("sapUiFormBackgr"+r)}};l.renderContainers=function(e,t,r){var i=r.getVisibleFormContainers();for(var n=0,a=i.length;n<a;n++){var o=i[n];this.renderContainer(e,t,o)}};l.renderContainer=function(e,t,r){var i=r.getExpandable();var n=r.getToolbar();var a=r.getTitle();e.openStart("section",r);e.class("sapUiFormContainer");if(n){e.class("sapUiFormContainerToolbar")}else if(a){e.class("sapUiFormContainerTitle")}if(r.getTooltip_AsString()){e.attr("title",r.getTooltip_AsString())}this.writeAccessibilityStateContainer(e,r);e.openEnd();this.renderHeader(e,n,a,r._oExpandButton,i,t._sFormSubTitleSize,r.getId());if(i){e.openStart("div",r.getId()+"-content");if(!r.getExpanded()){e.style("display","none")}e.openEnd()}var o=r.getVisibleFormElements();for(var l=0,s=o.length;l<s;l++){var d=o[l];if(d.isA("sap.ui.layout.form.SemanticFormElement")&&!d._getEditable()){this.renderSemanticElement(e,t,d)}else{this.renderElement(e,t,d)}}if(i){e.close("div")}e.close("section")};l.renderElement=function(e,t,r){var i=r.getLabelControl();e.openStart("div",r);e.class("sapUiFormElement");if(i){e.class("sapUiFormElementLbl")}e.openEnd();if(i){e.renderControl(i)}var n=r.getFieldsForRendering();if(n&&n.length>0){for(var a=0,o=n.length;a<o;a++){var l=n[a];e.renderControl(l)}}e.close("div")};l.renderSemanticElement=function(e,t,r){this.renderElement(e,t,r)};l.renderTitle=function(e,t,r,i,n,o){if(t){if(typeof t!=="string"&&t.getLevel()!=a.Auto){n=t.getLevel()}if(!n){n="H5"}if(typeof t!=="string"){e.openStart(n.toLowerCase(),t);if(t.getTooltip_AsString()){e.attr("title",t.getTooltip_AsString())}if(t.getEmphasized()){e.class("sapUiFormTitleEmph")}}else{e.openStart(n.toLowerCase(),o+"--title")}e.class("sapUiFormTitle");e.class("sapUiFormTitle"+n);if(i&&r){e.class("sapUiFormTitleExpandable")}e.openEnd();if(i&&r){e.renderControl(r)}if(typeof t==="string"){t.split(/\n/).forEach(function(t,r){if(r>0){e.voidStart("br").voidEnd()}e.text(t)})}else{var l=t.getIcon();if(l){var s=[];var d={title:null};d["id"]=t.getId()+"-ico";e.icon(l,s,d)}t.getText().split(/\n/).forEach(function(t,r){if(r>0){e.voidStart("br").voidEnd()}e.text(t)})}e.close(n.toLowerCase())}};l.renderHeader=function(e,t,r,i,n,a,o){if(t){e.renderControl(t)}else{this.renderTitle(e,r,i,n,a,o)}};l.writeAccessibilityStateContainer=function(e,t){var r={};var n=t.getTitle();var a=t.getToolbar();if(a){if(!t.getAriaLabelledBy()||t.getAriaLabelledBy().length==0){var o=i.getToolbarTitle(a);r["labelledby"]={value:o,append:true}}}else if(n){var l="";if(typeof n=="string"){l=t.getId()+"--title"}else{l=n.getId()}r["labelledby"]={value:l,append:true}}if(r["labelledby"]||t.getAriaLabelledBy().length>0){r["role"]="form"}e.accessibilityState(t,r)};return l},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/FormRenderer", ["./FormHelper","sap/base/Log"],function(e,t){"use strict";var a={apiVersion:2};a.render=function(a,i){var l=i.getLayout();var r={role:"form"};a.openStart("div",i).class("sapUiForm").class("sapUiFormLblColon").attr("data-sap-ui-customfastnavgroup","true");var s=e.addFormClass();if(s){a.class(s)}if(i.getEditable()){a.class("sapUiFormEdit");a.class("sapUiFormEdit-CTX")}else{r.readonly=""}if(i.getWidth()){a.style("width",i.getWidth())}if(i.getTooltip_AsString()){a.attr("title",i.getTooltip_AsString())}var o=i.getTitle();var d=i.getToolbar();if(d){if(!i.getAriaLabelledBy()||i.getAriaLabelledBy().length==0){var g=e.getToolbarTitle(d);r["labelledby"]=g}}else if(o){var n="";if(typeof o=="string"){n=i.getId()+"--title"}else{n=o.getId()}r["labelledby"]={value:n,append:true}}else if(i._sSuggestedTitleId){r["labelledby"]={value:i._sSuggestedTitleId,append:true}}a.accessibilityState(i,r);a.openEnd();if(l){a.renderControl(l)}else{t.warning('Form "'+i.getId()+'" - Layout missing!',"Renderer","Form")}a.close("div")};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/GridContainerData", ["sap/ui/core/LayoutData","sap/ui/layout/library"],function(a,t){"use strict";var e=a.extend("sap.ui.layout.form.GridContainerData",{metadata:{library:"sap.ui.layout",properties:{halfGrid:{type:"boolean",group:"Misc",defaultValue:false}}}});return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/GridElementData", ["sap/ui/core/LayoutData","sap/ui/layout/library"],function(a,e){"use strict";var t=a.extend("sap.ui.layout.form.GridElementData",{metadata:{library:"sap.ui.layout",properties:{hCells:{type:"sap.ui.layout.form.GridElementCells",group:"Appearance",defaultValue:"auto"},vCells:{type:"int",group:"Appearance",defaultValue:1}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/GridLayout", ["sap/ui/layout/library","./FormLayout","./GridLayoutRenderer"],function(e,t,r){"use strict";var n=t.extend("sap.ui.layout.form.GridLayout",{metadata:{library:"sap.ui.layout",deprecated:true,properties:{singleColumn:{type:"boolean",group:"Misc",defaultValue:false}}},renderer:r});n.prototype.toggleContainerExpanded=function(e){this.invalidate()};n.prototype.onAfterRendering=function(){var e=this.getParent();if(e){var t=e.getVisibleFormContainers();for(var r=0;r<t.length;r++){var n=t[r];if(n.getExpandable()&&n._oExpandButton){n._oExpandButton.$().attr("tabindex","-1")}}}};n.prototype.onLayoutDataChange=function(e){if(this.getDomRef()){this.invalidate()}};n.prototype.onsaptabnext=function(e){this.tabForward(e)};n.prototype.onsaptabprevious=function(e){this.tabBack(e)};n.prototype.findFieldOfElement=function(e,r,n){if(!n){return t.prototype.findPrevFieldOfElement.apply(this,arguments)}if(!e.isVisible()){return null}var i=e.getFieldsForRendering();var a;var o=i.length;r=o-1;for(var f=r;f>=0;f--){var l=i[f];var d=l.$().offset().left;if(n<d&&f!=0){continue}var s=this._getDomRef(l);if((!l.getEnabled||l.getEnabled())&&s){a=s;break}}return a};n.prototype.findFieldBelow=function(e,t){var r=t.getParent();var n=r.indexOfFormElement(t);var i;if(r.isVisible()){var a=r.getFormElements();var o=a.length;var f=n+1;var l=e.$().offset().left;while(!i&&f<o){var d=a[f];i=this.findFieldOfElement(d,0,l);f++}}if(!i){var s=r.getParent();n=s.indexOfFormContainer(r);i=this.findFirstFieldOfFirstElementInNextContainer(s,n+1)}return i};n.prototype.findFieldAbove=function(e,t){var r=t.getParent();var n=r.indexOfFormElement(t);var i;if(r.isVisible()){var a=r.getFormElements();var o=n-1;var f=e.$().offset().left;while(!i&&o>=0){var l=a[o];i=this.findFieldOfElement(l,0,f);o--}}if(!i){var d=r.getParent();n=d.indexOfFormContainer(r);i=this.findLastFieldOfLastElementInPrevContainer(d,n-1)}return i};n.prototype.getContainerRenderedDomRef=function(e){return null};n.prototype.getElementRenderedDomRef=function(e){if(this.getDomRef()){var t=this.getSingleColumn();var r=e.getParent();var n=this.getLayoutDataForElement(r,"sap.ui.layout.form.GridContainerData");if((t||!n||!n.getHalfGrid())&&!this.getRenderer().checkFullSizeElement(this,e)){return e.getDomRef()}}return null};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/GridLayoutRenderer", ["sap/ui/core/Renderer","./FormLayoutRenderer","sap/base/Log"],function(e,t,r){"use strict";var a=e.extend(t);a.apiVersion=2;a.renderForm=function(e,t,r){var a=t.getSingleColumn();var n=16;var i=false;var l=0;var o=r.getFormContainers();var s=o.length;var d=0;var f;var p;var c=r.getToolbar();var g=r.getTitle();if(a){n=n/2;l=n}else{l=n/2;for(d=0;d<s;d++){p=this.getContainerData(t,o[d]);if(p&&p.getHalfGrid()){i=true;break}}}e.openStart("table",t).attr("role","presentation").attr("cellpadding","0").attr("cellspacing","0").style("border-collapse","collapse").style("table-layout","fixed").style("width","100%").class("sapUiGrid");this.addBackgroundClass(e,t);if(c){e.class("sapUiFormToolbar")}e.openEnd();e.openStart("colgroup").openEnd();e.voidStart("col").attr("span",l).voidEnd();if(i){e.voidStart("col").class("sapUiGridSpace").attr("span","1").voidEnd()}if(!a){e.voidStart("col").attr("span",l).voidEnd()}e.close("colgroup");e.openStart("tbody").openEnd();if(c||g){var u=n;if(i){u++}e.openStart("tr").class("sapUiGridTitle").openEnd();e.openStart("th").attr("colspan",u).openEnd();this.renderHeader(e,c,g,undefined,false,t._sFormTitleSize,r.getId());e.close("th");e.close("tr")}d=0;var v;var E;while(d<s){f=o[d];f._checkProperties();if(f.isVisible()){p=this.getContainerData(t,f);if(p&&p.getHalfGrid()&&!a){v=o[d+1];E=undefined;if(v&&v.isVisible()){E=this.getContainerData(t,v)}if(E&&E.getHalfGrid()){v._checkProperties();this.renderContainerHalfSize(e,t,f,v,n);d++}else{this.renderContainerHalfSize(e,t,f,undefined,n)}}else{this.renderContainerFullSize(e,t,f,n,i)}}d++}e.close("tbody");e.close("table")};a.renderContainerFullSize=function(e,t,r,a,n){var i=r.getExpandable();var l=r.getTooltip_AsString();var o=r.getToolbar();var s=r.getTitle();if(o||s){var d=a;if(n){d++}e.openStart("tr").class("sapUiGridConteinerFirstRow").class("sapUiGridConteinerHeaderRow").openEnd();e.openStart("td").attr("colspan",d);e.class("sapUiGridHeader");if(l){e.attr("title",l)}if(o){e.class("sapUiFormContainerToolbar")}else if(s){e.class("sapUiFormContainerTitle")}e.openEnd();this.renderHeader(e,o,r.getTitle(),r._oExpandButton,i,t._sFormSubTitleSize,r.getId());e.close("td");e.close("tr")}if(!i||r.getExpanded()){var f=r.getFormElements();var p;var c=[];var g;var u=false;for(var v=0,E=f.length;v<E;v++){p=f[v];if(p.isVisible()){g=c[0]&&c[0][0]==a;if(!this.checkFullSizeElement(t,p)&&c[0]!="full"&&!g){e.openStart("tr",p);e.class("sapUiFormElement")}else{e.openStart("tr")}if(!u){u=true;if(!o&&!s){e.class("sapUiGridConteinerFirstRow")}}e.openEnd();if(!g){c=this.renderElement(e,t,p,false,a,n,c)}else{c.splice(0,1)}e.close("tr");if(c[0]=="full"||g){v=v-1}}}if(c.length>0){for(var h=0;h<c.length;h++){e.openStart("tr").openEnd().close("tr")}}}};a.renderContainerHalfSize=function(e,t,r,a,n){var i=n/2;var l=r.getExpandable();var o=r.getTooltip_AsString();var s;var d=r.getTitle();var f;var p=r.getToolbar();var c;var g=[];if(!l||r.getExpanded()){g=r.getFormElements()}var u=g.length;var v=[];var E=0;var h=false;if(a){h=a.getExpandable();s=a.getTooltip_AsString();f=a.getTitle();c=a.getToolbar();if(!h||a.getExpanded()){v=a.getFormElements()}E=v.length}if(d||f||p||c){e.openStart("tr").class("sapUiGridConteinerFirstRow").class("sapUiGridConteinerHeaderRow").openEnd();e.openStart("td").attr("colspan",i);e.class("sapUiGridHeader");if(o){e.attr("title",o)}if(p){e.class("sapUiFormContainerToolbar")}else if(d){e.class("sapUiFormContainerTitle")}e.openEnd();if(r){this.renderHeader(e,p,d,r._oExpandButton,l,t._sFormSubTitleSize,r.getId())}e.close("td");e.openStart("td").openEnd().close("td");e.openStart("td").attr("colspan",i);e.class("sapUiGridHeader");if(s){e.attr("title",s)}if(c){e.class("sapUiFormContainerToolbar")}else if(f){e.class("sapUiFormContainerTitle")}e.openEnd();if(a){this.renderHeader(e,c,f,a._oExpandButton,h,t._sFormSubTitleSize,a.getId())}e.close("td");e.close("tr")}if(!l||r.getExpanded()||(!h||a.getExpanded())){var m=[],S=[];var C=0,F=0;var b;var T;var U;var G;var H=false;while(C<u||F<E){b=g[C];T=v[F];U=m[0]&&m[0][0]==i;G=S[0]&&S[0][0]==i;if(b&&b.isVisible()||T&&T.isVisible()||U||G){e.openStart("tr");if(!H){H=true;if(!p&&!d&&!c&&!f){e.class("sapUiGridConteinerFirstRow")}}e.openEnd();if(!U){if(b&&b.isVisible()&&(!l||r.getExpanded())){m=this.renderElement(e,t,b,true,i,false,m)}else{e.openStart("td").attr("colspan",i).openEnd().close("td")}if(m[0]!="full"){C++}}else{if(m[0][2]>0){e.openStart("td").attr("colspan",m[0][2]).openEnd().close("td")}m.splice(0,1)}e.openStart("td").openEnd().close("td");if(!G){if(T&&T.isVisible()&&(!h||a.getExpanded())){S=this.renderElement(e,t,T,true,i,false,S)}else{e.openStart("td").attr("colspan",i).openEnd().close("td")}if(S[0]!="full"){F++}}else{if(S[0][2]>0){e.openStart("td").attr("colspan",S[0][2]).openEnd().close("td")}S.splice(0,1)}e.close("tr")}else{C++;F++}}if(m.length>0||S.length>0){for(var x=0;x<m.length||x<S.length;x++){e.openStart("tr").openEnd().close("tr")}}}};a.renderElement=function(e,t,a,n,i,l,o){var s=a.getLabelControl();var d=0;var f=a.getFieldsForRendering();var p=0;var c=0;var g=false;var u=1;var v=1;var E=0;if(this.checkFullSizeElement(t,a)){if(o.length>0&&o[0]!="full"){r.error('Element "'+a.getId()+'" - Too much fields for one row!',"Renderer","GridLayout");return o}if(l){i=i+1}if(s&&o[0]!="full"){e.openStart("td").attr("colspan",i).class("sapUiFormElementLbl").class("sapUiGridLabelFull").openEnd();e.renderControl(s);e.close("td");return["full"]}else{o.splice(0,1);v=this.getElementData(t,f[0]).getVCells();e.openStart("td").attr("colspan",i);if(v>1&&n){e.attr("rowspan",v);for(E=0;E<v-1;E++){o.push([i,undefined,false])}}e.openEnd();e.renderControl(f[0]);e.close("td");return o}}if(o.length>0&&o[0][0]>0){i=i-o[0][0]+o[0][2];g=o[0][1];d=o[0][2];o.splice(0,1)}var h=d;var m;var S="";if(s||d>0){h=3;if(s&&d==0){m=this.getElementData(t,s);if(m){S=m.getHCells();if(S!="auto"&&S!="full"){h=parseInt(S)}}}e.openStart("td").attr("colspan",h).class("sapUiFormElementLbl").openEnd();if(s){e.renderControl(s)}i=i-h;e.close("td")}if(f&&f.length>0){var C=i;var F=f.length;var b;var T=0;var U=0;for(T=0,U=f.length;T<U;T++){b=f[T];m=this.getElementData(t,b);if(m&&m.getHCells()!="auto"){C=C-parseInt(m.getHCells());F=F-1}}var G=0;for(T=0,G=0,U=f.length;T<U;T++){b=f[T];m=this.getElementData(t,b);S="auto";u=1;v=1;if(m){S=m.getHCells();v=m.getVCells()}if(S=="auto"){if(C>0){u=Math.floor(C/F);if(u<1){u=1}G++;c=c+u;if(G==F&&C>c){u=u+(C-c)}}else{u=1}}else{u=parseInt(S)}p=p+u;if(p>i){r.error('Element "'+a.getId()+'" - Too much fields for one row!',"Renderer","GridLayout");p=p-u;break}if(v>1){for(E=0;E<v-1;E++){if(s){d=h}if(o.length>E){o[E][0]=o[E][0]+u;o[E][2]=d}else{o.push([h+u,undefined,d])}}}if(l&&p>=Math.floor(i/2)&&!g){u=u+1;g=true;if(v>1){for(E=0;E<v-1;E++){o[E][1]=true}}}e.openStart("td");if(u>1){e.attr("colspan",u)}if(v>1){e.attr("rowspan",v)}e.openEnd();e.renderControl(b);e.close("td")}}if(p<i){var H=i-p;if(!n&&l&&!g){H++}e.openStart("td").attr("colspan",H).openEnd().close("td")}return o};a.checkFullSizeElement=function(e,t){var r=t.getFieldsForRendering();if(r.length==1&&this.getElementData(e,r[0])&&this.getElementData(e,r[0]).getHCells()=="full"){return true}else{return false}};a.getContainerData=function(e,t){return e.getLayoutDataForElement(t,"sap.ui.layout.form.GridContainerData")};a.getElementData=function(e,t){return e.getLayoutDataForElement(t,"sap.ui.layout.form.GridElementData")};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/ResponsiveGridLayout", ["sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/layout/library","sap/ui/layout/Grid","sap/ui/layout/GridData","./Form","./FormContainer","./FormElement","./FormLayout","./ResponsiveGridLayoutRenderer","sap/ui/thirdparty/jquery"],function(e,t,a,i,n,r,s,o,l,u,jQuery){"use strict";var f=l.extend("sap.ui.layout.form.ResponsiveGridLayout",{metadata:{library:"sap.ui.layout",properties:{labelSpanXL:{type:"int",group:"Misc",defaultValue:-1},labelSpanL:{type:"int",group:"Misc",defaultValue:4},labelSpanM:{type:"int",group:"Misc",defaultValue:2},labelSpanS:{type:"int",group:"Misc",defaultValue:12},adjustLabelSpan:{type:"boolean",group:"Misc",defaultValue:true},emptySpanXL:{type:"int",group:"Misc",defaultValue:-1},emptySpanL:{type:"int",group:"Misc",defaultValue:0},emptySpanM:{type:"int",group:"Misc",defaultValue:0},emptySpanS:{type:"int",group:"Misc",defaultValue:0},columnsXL:{type:"int",group:"Misc",defaultValue:-1},columnsL:{type:"int",group:"Misc",defaultValue:2},columnsM:{type:"int",group:"Misc",defaultValue:1},singleContainerFullSize:{type:"boolean",group:"Misc",defaultValue:true},breakpointXL:{type:"int",group:"Misc",defaultValue:1440},breakpointL:{type:"int",group:"Misc",defaultValue:1024},breakpointM:{type:"int",group:"Misc",defaultValue:600}}},renderer:u});var p=e.extend("sap.ui.layout.form.ResponsiveGridLayoutPanel",{metadata:{library:"sap.ui.layout",aggregations:{content:{type:"sap.ui.layout.Grid",multiple:false}},associations:{container:{type:"sap.ui.layout.form.FormContainer",multiple:false},layout:{type:"sap.ui.layout.form.ResponsiveGridLayout",multiple:false}}},getLayoutData:function(){var e=sap.ui.getCore().byId(this.getContainer());var t=sap.ui.getCore().byId(this.getLayout());var a;if(t&&e){a=t.getLayoutDataForElement(e,"sap.ui.layout.GridData")}if(a){return a}else{return this.getAggregation("layoutData")}},getCustomData:function(){var e=sap.ui.getCore().byId(this.getContainer());if(e){return e.getCustomData()}},refreshExpanded:function(){var e=sap.ui.getCore().byId(this.getContainer());if(e){if(e.getExpanded()){this.$().removeClass("sapUiRGLContainerColl")}else{this.$().addClass("sapUiRGLContainerColl")}}},renderer:{apiVersion:2,render:function(e,t){var a=sap.ui.getCore().byId(t.getContainer());var i=sap.ui.getCore().byId(t.getLayout());var n=t.getContent();var r=a.getExpandable();var s=a.getTooltip_AsString();var o=a.getToolbar();var l=a.getTitle();e.openStart("div",t);e.class("sapUiRGLContainer");if(r&&!a.getExpanded()){e.class("sapUiRGLContainerColl")}if(o){e.class("sapUiFormContainerToolbar")}else if(l){e.class("sapUiFormContainerTitle")}if(s){e.attr("title",s)}i.getRenderer().writeAccessibilityStateContainer(e,a);e.openEnd();i.getRenderer().renderHeader(e,o,l,a._oExpandButton,r,i._sFormSubTitleSize,a.getId());if(n){e.openStart("div");e.class("sapUiRGLContainerCont");e.openEnd();e.renderControl(n);e.close("div")}e.close("div")}}});f.prototype.init=function(){l.prototype.init.apply(this,arguments);this.mContainers={};this.oDummyLayoutData=new n(this.getId()+"--Dummy")};f.prototype.exit=function(){for(var e in this.mContainers){C.call(this,e,true)}if(this._mainGrid){this._mainGrid.destroy();delete this._mainGrid}this.oDummyLayoutData.destroy();this.oDummyLayoutData=undefined};f.prototype.onBeforeRendering=function(e){l.prototype.onBeforeRendering.apply(this,arguments);var t=this.getParent();if(!t||!(t instanceof r)){return}t._bNoInvalidate=true;d.call(this,t);_.call(this,t);t._bNoInvalidate=false};f.prototype.onAfterRendering=function(e){if(this._mainGrid&&this._mainGrid.__bIsUsed){for(var a in this.mContainers){if(this.mContainers[a][1]._sContainerResizeListener){t.deregister(this.mContainers[a][1]._sContainerResizeListener);this.mContainers[a][1]._sContainerResizeListener=null}}}};f.prototype.toggleContainerExpanded=function(e){var t=e.getId();if(this.mContainers[t]&&this.mContainers[t][0]){var a=this.mContainers[t][0];a.refreshExpanded()}};f.prototype.onLayoutDataChange=function(e){var t=e.srcControl;if(t instanceof s){if(this._mainGrid){this._mainGrid.onLayoutDataChange(e);this.invalidate()}}else if(!(t instanceof o)){var a=t.getParent();if(a instanceof o){var i=a.getParent();var n=i.getId();if(this.mContainers[n]&&this.mContainers[n][1]){this.mContainers[n][1].onLayoutDataChange(e)}}}};f.prototype.onsapup=function(e){this.onsapleft(e)};f.prototype.onsapdown=function(e){this.onsapright(e)};f.prototype.getContainerRenderedDomRef=function(e){if(this.getDomRef()){var t=e.getId();if(this.mContainers[t]){if(this.mContainers[t][0]){var a=this.mContainers[t][0];return a.getDomRef()}else if(this.mContainers[t][1]){var i=this.mContainers[t][1];return i.getDomRef()}}}return null};f.prototype.getElementRenderedDomRef=function(e){return null};function d(e){var t=e.getVisibleFormContainers();var a=t.length;var i=0;var n;var r;var s;var o;var l=0;for(l=0;l<a;l++){s=t[l];s._checkProperties();if(s.isVisible()){i++;o=s.getId();n=undefined;r=undefined;var u=t[l+1];if(this.mContainers[o]&&this.mContainers[o][1]){r=this.mContainers[o][1]}else{r=y.call(this,s)}var f=s.getTitle();var p=s.getToolbar();if(p||f||s.getExpandable()){if(this.mContainers[o]&&this.mContainers[o][0]){n=this.mContainers[o][0]}else{n=g.call(this,s,r);L(r,true)}v(n,s,i,u,a)}else{if(this.mContainers[o]&&this.mContainers[o][0]){m(this.mContainers[o][0])}L(r,false);v(r,s,i,u,a)}this.mContainers[o]=[n,r]}}var d=Object.keys(this.mContainers).length;if(a<d){for(o in this.mContainers){var h=false;for(l=0;l<a;l++){s=t[l];if(o==s.getId()){h=true;break}}if(!h){C.call(this,o)}}}}function g(e,t){var a=e.getId();var i=new p(a+"---Panel",{container:e,layout:this,content:t});return i}function m(e,t){e.setLayout(null);e.setContainer(null);if(!t||!e.getParent()){e.setContent(null);e.destroy()}}function y(e){var t=e.getId()+"--Grid";var a=new i(t,{vSpacing:0,hSpacing:0,containerQuery:true});a.__myParentLayout=this;a.__myParentContainerId=e.getId();a.addStyleClass("sapUiFormResGridCont").addStyleClass("sapUiRespGridOverflowHidden");a.getContent=function(){var e=sap.ui.getCore().byId(this.__myParentContainerId);if(e){var t=[];var a=e.getVisibleFormElements();var i;var n;for(var r=0;r<a.length;r++){var s=a[r];n=s.getLabelControl();if(n){t.push(n)}i=s.getFieldsForRendering();for(var o=0;o<i.length;o++){t.push(i[o])}}return t}else{return false}};a.getAriaLabelledBy=function(){var e=sap.ui.getCore().byId(this.__myParentContainerId);if(e&&!e.getToolbar()&&!e.getTitle()&&!e.getExpandable()){return e.getAriaLabelledBy()}return[]};var n={labelSpan:0,span:0,firstField:false,defaultFields:0,row:0,myRow:false,freeFields:0,finished:false};var r={id:"XL",getEffectiveSpan:function(e){var t=e._getEffectiveSpanXLarge();if(!t){t=e._getEffectiveSpanLarge()}return t},getEmptySpan:function(e){var t=e.getEmptySpanXL();if(t<0){t=e.getEmptySpanL()}return t},getLabelSpan:function(e){return e.getLabelSpanXL()},setIndent:function(e,t){e.setIndentXL(t)},setLinebreak:function(e,t){e.setLinebreakXL(t)}};jQuery.extend(r,n);var s={id:"L",getEffectiveSpan:function(e){return e._getEffectiveSpanLarge()},getEmptySpan:function(e){return e.getEmptySpanL()},getLabelSpan:function(e){return e.getLabelSpanL()},setIndent:function(e,t){e.setIndentL(t)},setLinebreak:function(e,t){e.setLinebreakL(t)}};jQuery.extend(s,n);var o={id:"M",getEffectiveSpan:function(e){return e._getEffectiveSpanMedium()},getEmptySpan:function(e){return e.getEmptySpanM()},getLabelSpan:function(e){return e.getLabelSpanM()},setIndent:function(e,t){e.setIndentM(t)},setLinebreak:function(e,t){e.setLinebreakM(t)}};jQuery.extend(o,n);var l={id:"S",getEffectiveSpan:function(e){return e._getEffectiveSpanSmall()},getEmptySpan:function(e){return e.getEmptySpanS()},getLabelSpan:function(e){return e.getLabelSpanS()},setIndent:function(e,t){e.setIndentS(t)},setLinebreak:function(e,t){e.setLinebreakS(t)}};jQuery.extend(l,n);var u=[r,s,o,l];a._getLayoutDataForControl=function(e){var t=this.__myParentLayout;var a=t.getLayoutDataForElement(e,"sap.ui.layout.GridData");var i=e.getParent();var f=i.getLabelControl();if(a){if(f==e){a._setStylesInternal("sapUiFormElementLbl")}return a}else{var p=sap.ui.getCore().byId(this.__myParentContainerId);var d=t.getLayoutDataForElement(p,"sap.ui.layout.GridData");var g=p.getParent();var m;var y=0;for(y=0;y<u.length;y++){m=u[y];jQuery.extend(m,n);m.labelSpan=m.getLabelSpan(t)}if(t.getAdjustLabelSpan()){if(g.getVisibleFormContainers().length>=1&&t.getColumnsM()>1){o.labelSpan=t.getLabelSpanL()}if(d){if(d._getEffectiveSpanLarge()==12){s.labelSpan=t.getLabelSpanM();o.labelSpan=t.getLabelSpanM()}}if(g.getVisibleFormContainers().length==1||t.getColumnsL()==1){s.labelSpan=t.getLabelSpanM();o.labelSpan=t.getLabelSpanM()}}if(r.labelSpan<0){r.labelSpan=s.labelSpan}if(f==e){t.oDummyLayoutData.setSpan("XL"+r.labelSpan+" L"+s.labelSpan+" M"+o.labelSpan+" S"+l.labelSpan);t.oDummyLayoutData.setLinebreak(true);t.oDummyLayoutData.setIndentXL(0).setIndentL(0).setIndentM(0).setIndentS(0);t.oDummyLayoutData._setStylesInternal("sapUiFormElementLbl");return t.oDummyLayoutData}else{var h;if(f){h=t.getLayoutDataForElement(f,"sap.ui.layout.GridData")}var L=i.getFieldsForRendering();var v=L.length;var C;var _;var c=1;var b=false;var S;var D=0;for(y=0;y<u.length;y++){m=u[y];m.span=12-m.getEmptySpan(t);if(f){if(h){S=m.getEffectiveSpan(h);if(S){m.labelSpan=S}}if(m.labelSpan<12){m.span=m.span-m.labelSpan}}m.spanFields=m.span}for(D=0;D<v;D++){C=L[D];if(C!=e){_=t.getLayoutDataForElement(C,"sap.ui.layout.GridData");if(_){for(y=0;y<u.length;y++){m=u[y];S=m.getEffectiveSpan(_);if(S&&S<m.span){m.span=m.span-S}}}else{c++}}else{if(c==1){b=true}}}var F=[];for(y=0;y<u.length;y++){m=u[y];m.firstField=b;m.defaultFields=c;if(m.span<c){m.defaultFields=0;m.row=0;m.myRow=false;m.freeFields=m.spanFields;m.span=m.spanFields;m.finished=false;F.push(m)}}if(F.length>0){for(D=0;D<v;D++){C=L[D];_=undefined;if(C!=e){_=t.getLayoutDataForElement(C,"sap.ui.layout.GridData")}for(y=0;y<F.length;y++){m=F[y];if(m.finished){continue}if(_){S=m.getEffectiveSpan(_);m.span=m.span-S}else{S=1}if(m.freeFields>=S){m.freeFields=m.freeFields-S;if(!_){m.defaultFields++}}else{if(m.myRow){m.finished=true}else{m.freeFields=m.spanFields-S;m.row++;if(_){m.defaultFields=0;m.span=m.spanFields-S}else{m.defaultFields=1;m.span=m.spanFields}if(C==e){m.firstField=true}}}if(C==e){m.myRow=true}}}}var G=0;var I="";var R;for(y=0;y<u.length;y++){m=u[y];if(m.id!="S"||m.labelSpan<12){if(m.firstField){G=m.span-Math.floor(m.span/m.defaultFields)*m.defaultFields;R=Math.floor(m.span/m.defaultFields)+G}else{R=Math.floor(m.span/m.defaultFields)}}else{R=12}if(I){I=I+" "}I=I+m.id+R;m.setLinebreak(t.oDummyLayoutData,m.firstField&&m.row>0);m.setIndent(t.oDummyLayoutData,m.firstField&&m.row>0?m.labelSpan:0)}t.oDummyLayoutData.setSpan(I);t.oDummyLayoutData.setLinebreak(b&&!f);t.oDummyLayoutData._setStylesInternal(undefined);return t.oDummyLayoutData}}};a._onParentResizeOrig=a._onParentResize;a._onParentResize=function(){if(!this.getDomRef()){this._cleanup();return}if(!jQuery(this.getDomRef()).is(":visible")){return}var e=this.__myParentLayout;if(!e._mainGrid||!e._mainGrid.__bIsUsed){var t=e.getParent().getVisibleFormContainers()[0];if(!t||!e.mContainers[t.getId()]||t.getId()!=this.__myParentContainerId){return}if(e.mContainers[this.__myParentContainerId][0]){var a=e.mContainers[this.__myParentContainerId][0].getDomRef();var i=a.clientWidth;if(i<=e.getBreakpointM()){this._toggleClass("Phone")}else if(i>e.getBreakpointM()&&i<=e.getBreakpointL()){this._toggleClass("Tablet")}else if(i>e.getBreakpointL()&&i<=e.getBreakpointXL()){this._toggleClass("Desktop")}else{this._toggleClass("LargeDesktop")}}else{this._setBreakPointTablet(e.getBreakpointM());this._setBreakPointDesktop(e.getBreakpointL());this._setBreakPointLargeDesktop(e.getBreakpointXL());this._onParentResizeOrig()}}else{var n=e._mainGrid.$();if(n.hasClass("sapUiRespGridMedia-Std-Phone")){this._toggleClass("Phone")}else if(n.hasClass("sapUiRespGridMedia-Std-Tablet")){this._toggleClass("Tablet")}else if(n.hasClass("sapUiRespGridMedia-Std-Desktop")){this._toggleClass("Desktop")}else{this._toggleClass("LargeDesktop")}}};a._getAccessibleRole=function(){var e=sap.ui.getCore().byId(this.__myParentContainerId);var t=this.__myParentLayout;if(t._mainGrid&&t._mainGrid.__bIsUsed&&!e.getToolbar()&&!e.getTitle()&&!e.getExpandable()&&e.getAriaLabelledBy().length>0){return"form"}};a.getUIArea=function(){var e=this.__myParentLayout;if(e){return e.getUIArea()}else{return null}};return a}function h(e,t){if(e.__myParentContainerId){e.__myParentContainerId=undefined}e.__myParentLayout=undefined;if(!t||!e.getParent()){e.destroy()}}function L(e,t){if(t){if(e.__originalGetLayoutData){e.getLayoutData=e.__originalGetLayoutData;delete e.__originalGetLayoutData}}else if(!e.__originalGetLayoutData){e.__originalGetLayoutData=e.getLayoutData;e.getLayoutData=function(){var e=this.__myParentLayout;var t=sap.ui.getCore().byId(this.__myParentContainerId);var a;if(t){a=e.getLayoutDataForElement(t,"sap.ui.layout.GridData")}if(a){return a}else{return this.getAggregation("layoutData")}}}}function v(e,t,a,i,r){var s;if(e instanceof p){s=sap.ui.getCore().byId(e.getLayout())}else{s=e.__myParentLayout}var o=s.getLayoutDataForElement(t,"sap.ui.layout.GridData");if(!o){var l=s.getColumnsM();var u=s.getColumnsL();var f=s.getColumnsXL();var d=a%u==1;var g=a%u==0;var m=a>u*(Math.ceil(r/u)-1);var y=a<=u;var h=a%l==1;var L=a%l==0;var v=a>l*(Math.ceil(r/l)-1);var C=a<=l;var _=false;var c=g;var b=m;var S=y;if(f>0){_=a%f==1;c=a%f==0;b=a>f*(Math.ceil(r/f)-1);S=a<=f}if(i){var D=s.getLayoutDataForElement(i,"sap.ui.layout.GridData");if(D&&(D.getLinebreak()||D.getLinebreakXL())){c=true;b=false}if(D&&(D.getLinebreak()||D.getLinebreakL())){g=true;m=false}if(D&&(D.getLinebreak()||D.getLinebreakM())){L=true;v=false}}var F="";if(c){F="sapUiFormResGridLastContXL"}if(g){if(F){F=F+" "}F=F+"sapUiFormResGridLastContL"}if(L){if(F){F=F+" "}F=F+"sapUiFormResGridLastContM"}if(b){if(F){F=F+" "}F=F+"sapUiFormResGridLastRowXL"}if(m){if(F){F=F+" "}F=F+"sapUiFormResGridLastRowL"}if(v){if(F){F=F+" "}F=F+"sapUiFormResGridLastRowM"}if(S){if(F){F=F+" "}F=F+"sapUiFormResGridFirstRowXL"}if(y){if(F){F=F+" "}F=F+"sapUiFormResGridFirstRowL"}if(C){if(F){F=F+" "}F=F+"sapUiFormResGridFirstRowM"}o=e.getLayoutData();if(!o){o=new n(e.getId()+"--LD",{linebreakL:d,linebreakM:h});e.setLayoutData(o)}else{o.setLinebreakL(d);o.setLinebreakM(h)}if(f>0){o.setLinebreakXL(_)}o._setStylesInternal(F)}}function C(e,t){var a=this.mContainers[e];var i=a[1];if(i){h(i,t)}var n=a[0];if(n){m(n,t)}delete this.mContainers[e]}function _(e){var t=e.getVisibleFormContainers();var a;var n;var r=t.length;var s=0;var o=0;var l=0;if(r>1||!this.getSingleContainerFullSize()){var u=Math.floor(12/this.getColumnsM());var f=Math.floor(12/this.getColumnsL());var p;var d="";var g=this.getColumnsXL();if(g>=0){p=Math.floor(12/g);d=d+"XL"+p+" "}d=d+"L"+f+" M"+u+" S12";if(!this._mainGrid){this._mainGrid=new i(e.getId()+"--Grid",{defaultSpan:d,hSpacing:0,vSpacing:0,containerQuery:true}).setParent(this);this._mainGrid.addStyleClass("sapUiFormResGridMain").addStyleClass("sapUiRespGridOverflowHidden");this._mainGrid._onParentResizeOrig=this._mainGrid._onParentResize;this._mainGrid._onParentResize=function(){this._onParentResizeOrig();var e=this.getParent();for(var t in e.mContainers){e.mContainers[t][1]._onParentResize()}}}else{this._mainGrid.setDefaultSpan(d);var m=this._mainGrid.getContent();s=m.length;var y=false;for(o=0;o<s;o++){var h=m[o];a=undefined;if(h.getContainer){a=sap.ui.getCore().byId(h.getContainer())}else{a=sap.ui.getCore().byId(h.__myParentContainerId)}if(a&&a.isVisible()){var L=t[l];if(a!=L){y=true;break}var v=this.mContainers[a.getId()];if(v[0]&&v[0]!=h){y=true;break}if(!v[0]&&v[1]&&v[1]!=h){y=true;break}l++}else{this._mainGrid.removeContent(h)}}if(y){this._mainGrid.removeAllContent();s=0}}this._mainGrid._setBreakPointTablet(this.getBreakpointM());this._mainGrid._setBreakPointDesktop(this.getBreakpointL());this._mainGrid._setBreakPointLargeDesktop(this.getBreakpointXL());this._mainGrid.__bIsUsed=true;if(s<r){var C=0;if(s>0){C=s--}for(o=C;o<r;o++){a=t[o];n=a.getId();if(this.mContainers[n]){if(this.mContainers[n][0]){this._mainGrid.addContent(this.mContainers[n][0])}else if(this.mContainers[n][1]){this._mainGrid.addContent(this.mContainers[n][1])}}}}}else{if(this._mainGrid){this._mainGrid.__bIsUsed=false}for(o=0;o<r;o++){a=t[o];n=a.getId();if(this.mContainers[n]){if(this.mContainers[n][0]){if(this.mContainers[n][0].getParent()!==this){this.addDependent(this.mContainers[n][0])}}else if(this.mContainers[n][1]){if(this.mContainers[n][1].getParent()!==this){this.addDependent(this.mContainers[n][1])}}}}}}f.prototype.getLayoutDataForDelimiter=function(){return new n({spanS:1,spanM:1,spanL:1,spanXL:1})};f.prototype.getLayoutDataForSemanticField=function(e,t,a){var i=8-(e-1);i=Math.floor(i/e);if(e===t){i=i+8-(e-1+e*i)}if(a){if(a.isA("sap.ui.layout.GridData")){a.setSpanS(11).setSpanM(i).setSpanL(i).setSpanXL(i);return a}else{a.destroy()}}return new n({spanS:11,spanM:i,spanL:i,spanXL:i})};return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/ResponsiveGridLayoutRenderer", ["sap/ui/core/Renderer","./FormLayoutRenderer"],function(e,r){"use strict";var n=e.extend(r);n.apiVersion=2;n.getMainClass=function(){return"sapUiFormResGrid"};n.renderContainers=function(e,r,n){var i=n.getVisibleFormContainers();var t=i.length;if(t>0){if(t>1||!r.getSingleContainerFullSize()){e.renderControl(r._mainGrid)}else if(r.mContainers[i[0].getId()][0]){e.renderControl(r.mContainers[i[0].getId()][0])}else{e.renderControl(r.mContainers[i[0].getId()][1])}}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/ResponsiveLayout", ["sap/ui/core/Control","sap/ui/layout/library","sap/ui/layout/ResponsiveFlowLayout","sap/ui/layout/ResponsiveFlowLayoutData","./Form","./FormContainer","./FormElement","./FormLayout","./ResponsiveLayoutRenderer"],function(t,e,a,n,i,r,o,s,l){"use strict";var u=s.extend("sap.ui.layout.form.ResponsiveLayout",{metadata:{library:"sap.ui.layout"},renderer:l});var f=t.extend("sap.ui.layout.form.ResponsiveLayoutPanel",{metadata:{library:"sap.ui.layout",aggregations:{content:{type:"sap.ui.layout.ResponsiveFlowLayout",multiple:false}},associations:{container:{type:"sap.ui.layout.form.FormContainer",multiple:false},layout:{type:"sap.ui.layout.form.ResponsiveLayout",multiple:false}}},getLayoutData:function(){var t=sap.ui.getCore().byId(this.getContainer());var e=sap.ui.getCore().byId(this.getLayout());var a;if(e&&t){a=e.getLayoutDataForElement(t,"sap.ui.layout.ResponsiveFlowLayoutData")}return a},getCustomData:function(){var t=sap.ui.getCore().byId(this.getContainer());if(t){return t.getCustomData()}},refreshExpanded:function(){var t=sap.ui.getCore().byId(this.getContainer());if(t){if(t.getExpanded()){this.$().removeClass("sapUiRLContainerColl")}else{this.$().addClass("sapUiRLContainerColl")}}},renderer:{apiVersion:2,render:function(t,e){var a=sap.ui.getCore().byId(e.getContainer());var n=sap.ui.getCore().byId(e.getLayout());var i=e.getContent();if(!a||!n){return}var r=a.getExpandable();var o=a.getTooltip_AsString();var s=a.getToolbar();var l=a.getTitle();t.openStart("div",e);t.class("sapUiRLContainer");if(r&&!a.getExpanded()){t.class("sapUiRLContainerColl")}if(s){t.class("sapUiFormContainerToolbar")}else if(l){t.class("sapUiFormContainerTitle")}if(o){t.attr("title",o)}n.getRenderer().writeAccessibilityStateContainer(t,a);t.openEnd();n.getRenderer().renderHeader(t,s,l,a._oExpandButton,r,n._sFormSubTitleSize,a.getId());if(i){t.openStart("div");t.class("sapUiRLContainerCont");t.openEnd();t.renderControl(i);t.close("div")}t.close("div")}}});u.prototype.init=function(){s.prototype.init.apply(this,arguments);this.mContainers={};this._defaultLayoutData=new n({margin:false})};u.prototype.exit=function(){for(var t in this.mContainers){L.call(this,t)}if(this._mainRFLayout){this._mainRFLayout.destroy();delete this._mainRFLayout}this._defaultLayoutData.destroy();delete this._defaultLayoutData};u.prototype.onBeforeRendering=function(t){s.prototype.onBeforeRendering.apply(this,arguments);var e=this.getParent();if(!e||!(e instanceof i)){return}e._bNoInvalidate=true;d.call(this,e);c.call(this,e);e._bNoInvalidate=false};u.prototype.toggleContainerExpanded=function(t){var e=t.getId();if(this.mContainers[e]&&this.mContainers[e][0]){var a=this.mContainers[e][0];a.refreshExpanded()}};u.prototype.onLayoutDataChange=function(t){var e=t.srcControl;var a;var n;var i;if(e instanceof r){if(this._mainRFLayout){this._mainRFLayout.onLayoutDataChange(t)}}else if(e instanceof o){n=e.getParent().getId();if(this.mContainers[n]&&this.mContainers[n][1]){this.mContainers[n][1].onLayoutDataChange(t)}}else{var s=e.getParent();if(s instanceof o){a=s.getParent();n=a.getId();i=s.getId();if(this.mContainers[n]&&this.mContainers[n][2]&&this.mContainers[n][2][i]){if(this.mContainers[n][2][i][1]){var l=s.getFieldsForRendering();h.call(this,this.mContainers[n][2][i][1],l)}this.mContainers[n][2][i][0].onLayoutDataChange(t)}}}};u.prototype.onsapup=function(t){this.onsapleft(t)};u.prototype.onsapdown=function(t){this.onsapright(t)};u.prototype.getContainerRenderedDomRef=function(t){if(this.getDomRef()){var e=t.getId();if(this.mContainers[e]){if(this.mContainers[e][0]){var a=this.mContainers[e][0];return a.getDomRef()}else if(this.mContainers[e][1]){var n=this.mContainers[e][1];return n.getDomRef()}}}return null};u.prototype.getElementRenderedDomRef=function(t){if(this.getDomRef()){var e=t.getParent();var a=t.getId();var n=e.getId();if(this.mContainers[n]){if(this.mContainers[n][2]){var i=this.mContainers[n][2];if(i[a]){var r=i[a][0];return r.getDomRef()}}}}return null};function d(t){var e=t.getVisibleFormContainers();var a=e.length;var n;var i;var r;var o;var s=0;for(s=0;s<a;s++){n=e[s];n._checkProperties();i=n.getId();r=undefined;o=undefined;if(this.mContainers[i]&&this.mContainers[i][1]){o=this.mContainers[i][1]}else{o=C.call(this,n,undefined)}var l=n.getTitle();var u=n.getToolbar();if(u||l||n.getExpandable()){if(this.mContainers[i]&&this.mContainers[i][0]){r=this.mContainers[i][0]}else{r=y.call(this,n,o);v(o,true)}o.removeStyleClass("sapUiRLContainer")}else{if(this.mContainers[i]&&this.mContainers[i][0]){g(this.mContainers[i][0]);v(o,false)}o.addStyleClass("sapUiRLContainer")}var f=m.call(this,n,o);this.mContainers[i]=[r,o,f]}var d=Object.keys(this.mContainers).length;if(a<d){for(i in this.mContainers){var h=false;for(s=0;s<a;s++){n=e[s];if(i==n.getId()){h=true;break}}if(!h){L.call(this,i)}}}}function y(t,e){var a=t.getId();var n=new f(a+"--Panel",{container:t,layout:this,content:e});return n}function g(t){t.setContent(null);t.setLayout(null);t.setContainer(null);t.destroy()}function m(t,e){var a=t.getId();var n=t.getVisibleFormElements();var i=n.length;var r={};if(this.mContainers[a]&&this.mContainers[a][2]){r=this.mContainers[a][2]}var o;var s;var l=-1;var u;var f;var d=0;for(d=0;d<i;d++){u=n[d];f=u.getId();_.call(this,t,u,r,e,d);if(r[f]){o=r[f][0];l=e.indexOfContent(o);if(l!=i){e.removeContent(o);e.insertContent(o,i);l=i}}else{o=C.call(this,t,u);o.addStyleClass("sapUiRLElement");if(u.getLabel()){o.addStyleClass("sapUiRLElementWithLabel")}r[f]=[o,undefined];l++;e.insertContent(o,l)}var y=u.getFieldsForRendering();if(u.getLabel()&&y.length>1){if(r[f][1]){s=r[f][1]}else{s=C.call(this,t,u,true);s.addStyleClass("sapUiRLElementFields");r[f][1]=s}h.call(this,s,y)}else{if(r[f][1]){s=r[f][1];p(s);r[f][1]=undefined}}}var g=Object.keys(r).length;if(i<g){for(f in r){var m=false;for(d=0;d<i;d++){u=n[d];if(f==u.getId()){m=true;break}}if(!m){if(r[f][1]){s=r[f][1];p(s)}o=r[f][0];e.removeContent(o);p(o);delete r[f]}}}return r}function C(t,e,i){var r;if(e&&!i){r=e.getId()+"--RFLayout"}else if(e&&i){r=e.getId()+"--content--RFLayout"}else if(t){r=t.getId()+"--RFLayout"}else{return false}var o=new a(r);o.__myParentLayout=this;o.__myParentContainerId=t.getId();if(e){o.__myParentElementId=e.getId();if(!i){o.getContent=function(){var t=sap.ui.getCore().byId(this.__myParentElementId);if(t){var e=[];var a=t.getLabelControl();var n=t.getFieldsForRendering();if(!a||n.length<=1){e=n;if(a){e.unshift(a)}}else{var i=this.__myParentLayout;var r=this.__myParentContainerId;var o=t.getId();if(a){e.push(a)}if(i.mContainers[r]&&i.mContainers[r][2]&&i.mContainers[r][2][o]&&i.mContainers[r][2][o][1]){e.push(i.mContainers[r][2][o][1])}}return e}else{return false}};o._addContentClass=function(t,e){if(e==0){var a=sap.ui.getCore().byId(this.__myParentElementId);if(a){var n=a.getLabelControl();if(t==n){return"sapUiFormElementLbl"}}}return null}}else{o.getContent=function(){var t=sap.ui.getCore().byId(this.__myParentElementId);if(t){return t.getFieldsForRendering()}else{return false}}}}else if(t){o._getAccessibleRole=function(){var t=sap.ui.getCore().byId(this.__myParentContainerId);var e=this.__myParentLayout;if(e._mainRFLayout&&!t.getToolbar()&&!t.getTitle()&&!t.getExpandable()&&t.getAriaLabelledBy().length>0){return"form"}};o.getAriaLabelledBy=function(){var t=sap.ui.getCore().byId(this.__myParentContainerId);if(t&&!t.getToolbar()&&!t.getTitle()&&!t.getExpandable()){return t.getAriaLabelledBy()}return[]}}if(e&&!i||!e&&!t.getToolbar()&&!t.getTitle()&&!t.getExpandable()){v(o,false)}else{o.setLayoutData(new n({margin:false}))}return o}function v(t,e){if(e){if(t.__originalGetLayoutData){t.getLayoutData=t.__originalGetLayoutData;delete t.__originalGetLayoutData}}else if(!t.__originalGetLayoutData){t.__originalGetLayoutData=t.getLayoutData;t.getLayoutData=function(){var t=this.__myParentLayout;var e=sap.ui.getCore().byId(this.__myParentContainerId);var a=sap.ui.getCore().byId(this.__myParentElementId);var n;if(a){n=t.getLayoutDataForElement(a,"sap.ui.layout.ResponsiveFlowLayoutData")}else if(e){n=t.getLayoutDataForElement(e,"sap.ui.layout.ResponsiveFlowLayoutData")}if(n){return n}else if(a){return t._defaultLayoutData}}}}function h(t,e){var a;var i=0;for(var r=0;r<e.length;r++){var o=e[r];a=this.getLayoutDataForElement(o,"sap.ui.layout.ResponsiveFlowLayoutData");if(a){i=i+a.getWeight()}else{i++}}a=t.getLayoutData();if(a){a.setWeight(i)}else{t.setLayoutData(new n({weight:i}))}}function p(t){if(t.__myParentContainerId){t.__myParentContainerId=undefined}if(t.__myParentElementId){t.__myParentElementId=undefined}t.__myParentLayout=undefined;t.destroy()}function L(t){var e=this.mContainers[t];var a;var n=e[2];if(n){for(var i in n){if(n[i][1]){p(n[i][1])}a=n[i][0];p(a);delete n[i]}}a=e[1];if(a){a.removeAllContent();p(a)}var r=e[0];if(r){g(r)}delete this.mContainers[t]}function _(t,e,a,n,i){var r=e.getId();var o=r+"--RFLayout";var s=sap.ui.getCore().byId(o);if(!a[r]&&s){var l=s.__myParentContainerId;a[r]=this.mContainers[l][2][r];n.insertContent(s,i);s.__myParentContainerId=t.getId();if(a[r][1]){a[r][1].__myParentContainerId=t.getId()}delete this.mContainers[l][2][r]}}function c(t){var e=t.getVisibleFormContainers();var n;var i=e.length;var r=0;var o=0;var s=0;if(i>1){if(!this._mainRFLayout){this._mainRFLayout=new a(t.getId()+"--RFLayout").setParent(this)}else{var l=this._mainRFLayout.getContent();r=l.length;var u=false;for(o=0;o<r;o++){var f=l[o];n=undefined;if(f.getContainer){n=sap.ui.getCore().byId(f.getContainer())}else{n=sap.ui.getCore().byId(f.__myParentContainerId)}if(n&&n.isVisible()){var d=e[s];if(n!=d){u=true;break}var y=this.mContainers[n.getId()];if(y[0]&&y[0]!=f){u=true;break}if(!y[0]&&y[1]&&y[1]!=f){u=true;break}s++}else{this._mainRFLayout.removeContent(f)}}if(u){this._mainRFLayout.removeAllContent();r=0}}if(r<i){var g=0;if(r>0){g=r--}for(o=g;o<i;o++){n=e[o];var m=n.getId();if(this.mContainers[m]){if(this.mContainers[m][0]){this._mainRFLayout.addContent(this.mContainers[m][0])}else if(this.mContainers[m][1]){this._mainRFLayout.addContent(this.mContainers[m][1])}}}}}}return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/ResponsiveLayoutRenderer", ["sap/ui/core/Renderer","./FormLayoutRenderer"],function(e,r){"use strict";var n=e.extend(r);n.apiVersion=2;n.getMainClass=function(){return"sapUiFormResLayout"};n.renderContainers=function(e,r,n){var t=n.getVisibleFormContainers();var i=t.length;if(i>0){if(i>1){e.renderControl(r._mainRFLayout)}else if(r.mContainers[t[0].getId()][0]){e.renderControl(r.mContainers[t[0].getId()][0])}else{e.renderControl(r.mContainers[t[0].getId()][1])}}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/SemanticFormElement", ["./FormElement","./FormHelper"],function(e,t){"use strict";var i=e.extend("sap.ui.layout.form.SemanticFormElement",{metadata:{library:"sap.ui.layout",properties:{delimiter:{type:"string",group:"Data",defaultValue:"/"}},aggregations:{fieldLabels:{type:"sap.ui.core.Label",multiple:true},_delimiters:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},_displayField:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});i.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver.observe(this,{properties:["_editable","delimiter"],aggregations:["fieldLabels"],parent:true})};i.prototype.exit=function(){e.prototype.exit.apply(this,arguments)};i.prototype.enhanceAccessibilityState=function(t,i){var a=this.getAggregation("delimiters",[]);if(a.indexOf(t)<0){if(!m.call(this)){var r=this.indexOfField(t);if(r>=0){var l=this.getFieldLabels();var s=l[r];if(s){var o;if(typeof s==="string"){o=s}else{o=s.getText()}var n=i["label"];if(!n){n=o}else{n=n+" "+o}i["label"]=n;var g=i["labelledby"];if(g){s=this.getLabelControl();var h=g.split(" ");r=h.indexOf(s.getId());if(r>=0){h.splice(r,1);g=h.join(" ")}i["labelledby"]=g}return i}}}}e.prototype.enhanceAccessibilityState.apply(this,arguments)};i.prototype.onLayoutDataChange=function(t){var i=t.srcControl;var a=i.getLayoutData();if(!a||!a._bSetBySemanticFormElement){d.call(this)}e.prototype.onLayoutDataChange.apply(this,arguments)};i.prototype.getFieldsForRendering=function(){var e=[];if(!this._bLayoutDataCreated){d.call(this)}if(!m.call(this)){if(this.getAggregation("_displayField")){this.destroyAggregation("_displayField");g.call(this)}var t=this.getFields();var i=this.getAggregation("_delimiters",[]);for(var a=0;a<t.length;a++){var r=t[a];if(r.getVisible()){if(e.length>0&&i[a-1]){e.push(i[a-1])}e.push(r)}}}else{if(!this.getAggregation("_displayField")){this.destroyAggregation("_delimiters");this._bLayoutDataCreated=false;f.call(this)}var l=this.getAggregation("_displayField");if(l){e.push(l)}}return e};i.prototype._observeChanges=function(t){e.prototype._observeChanges.apply(this,arguments);if(t.object===this){if(t.type==="parent"){y.call(this,t.mutation,t.parent)}else if(t.name==="fields"){r.call(this,t.child,t.mutation)}else if(t.name==="_editable"){a.call(this,t.current)}else if(t.name==="delimiter"){l.call(this,t.current)}else if(t.name==="fieldLabels"){s.call(this,t.mutation,t.child)}}else{if(t.type==="parent"){y.call(this,t.mutation,t.parent)}else if(t.name==="layout"){v.call(this,t.child,t.mutation)}else if(t.object.isA("sap.ui.core.Label")){n.call(this,t)}else{o.call(this,t)}}};function a(e){if(e){this.destroyAggregation("_displayField");g.call(this)}else if(m.call(this)){this.destroyAggregation("_delimiters");this._bLayoutDataCreated=false;f.call(this)}else{g.call(this)}}function r(e,t){if(t==="insert"){if(!e.isA("sap.ui.core.IFormContent")||!e.isA("sap.ui.core.ISemanticFormContent")){throw new Error(e+" is not valid Form content. "+this)}var i=["visible"];if(e.getFormObservingProperties){i=i.concat(e.getFormObservingProperties())}if(e.getFormValueProperty){if(i.indexOf(e.getFormValueProperty())===-1){i.push(e.getFormValueProperty())}}else if(e.getMetadata().getProperty("value")){i.push("value")}else if(e.getMetadata().getProperty("text")){i.push("text")}this._oObserver.observe(e,{properties:i})}else{var a=e.getLayoutData();if(a&&a._bSetBySemanticFormElement){a.destroy()}}if(!m.call(this)){g.call(this)}else{f.call(this,true)}p.call(this)}function l(e){if(!m.call(this)){g.call(this)}else{u.call(this,false)}p.call(this)}function s(e,t){if(typeof t!=="string"){if(e==="insert"){this._oObserver.observe(t,{properties:["text"]})}else{this._oObserver.unobserve(t)}}p.call(this)}function o(e){var t=e.object.getFormValueProperty?e.object.getFormValueProperty():null;var i=e.object.getFormObservingProperties?e.object.getFormObservingProperties():[];if(e.name===t||e.name==="value"||e.name==="text"){if(m.call(this)){u.call(this,false)}}else if(e.name==="visible"||i.indexOf(e.name)>=0){if(!m.call(this)){g.call(this)}else{f.call(this,true)}p.call(this);this.invalidate()}}function n(e){p.call(this)}function g(){if(this._oInitPromise){this._oInitPromise.then(function(){delete this._oInitPromise;if(!m.call(this)){g.call(this)}}.bind(this));return}var e=this.getFields();var i=this.getAggregation("_delimiters",[]);var a=this.getDelimiter();var r=this.getId()+"-delimiter-";var l=0;if(!this._getEditable()){a=" "+a+" "}for(l=0;l<e.length;l++){if(l<e.length-1){if(i.length>l){t.updateDelimiter(i[l],a)}else{var s=t.createDelimiter(a,r+l);s.addStyleClass("sapUiFormDelimiter");this.addAggregation("_delimiters",s)}}}if(i.length>0&&i.length>e.length-1){for(l=e.length-1;l<i.length;l++){i[l].destroy()}}d.call(this)}var h={onBeforeRendering:function(){u.call(this,true)}};function f(e){if(this._oInitPromise){this._oInitPromise.then(function(){delete this._oInitPromise;if(m.call(this)){f.call(this)}}.bind(this));return}var i=this.getAggregation("_displayField");if(i){u.call(this,false)}else{var a=this.getId()+"-display";i=t.createSemanticDisplayControl("",a);i.addDelegate(h,true,this);this.setAggregation("_displayField",i)}}function u(e){var i=this.getAggregation("_displayField");if(i&&(i.getDomRef()||e)){if(e&&i._bNoForceUpdate){i._bNoForceUpdate=false;return}var a=this.getFields();var r=[];var l=false;for(var s=0;s<a.length;s++){var o=a[s];if(o.getVisible()){var n=o.getFormValueProperty?o.getFormValueProperty():null;var g;if(o.getFormFormattedValue){g=o.getFormFormattedValue();if(g instanceof Promise){l=true}}else if(n){g=o.getProperty(n)}else if(o.getMetadata().getProperty("value")){g=o.getValue()}else if(o.getMetadata().getProperty("text")){g=o.getText()}r.push(g)}}i._bNoForceUpdate=true;if(l){Promise.all(r).then(function(e){var i=this.getAggregation("_displayField");var a=c.call(this,e);i._bNoForceUpdate=true;t.updateSemanticDisplayControl(i,a)}.bind(this))}else{var h=c.call(this,r);t.updateSemanticDisplayControl(i,h)}}else if(i&&i._bNoForceUpdate){i._bNoForceUpdate=false}}function c(e){var t=this.getDelimiter();var i="";for(var a=0;a<e.length;a++){i=i+e[a];if(a<e.length-1){i=i+" "+t+" "}}return i}function p(){if(!this.getLabel()){if(this._oInitPromise){this._oInitPromise.then(function(){delete this._oInitPromise;p.call(this)}.bind(this));return}var e=this.getFieldLabels();var t=this.getFields();var i=[];for(var a=0;a<e.length;a++){if(t[a]&&t[a].getVisible()){var r=e[a];if(typeof r==="string"){i.push(r)}else{i.push(r.getText())}}}var l=c.call(this,i);this._setInternalLabel(l)}}function d(){var e=this.getFields().filter(function(e){return e.getVisible()});var t=this.getAggregation("_delimiters",[]);var i=this.getParent();var a=i&&i.getParent();var r=a&&a.getLayout();var l;var s=0;if(!r||!r.getLayoutDataForDelimiter){return}if(this._getEditable()){for(s=0;s<t.length;s++){var o=t[s];if(!o.getLayoutData()){l=r.getLayoutDataForDelimiter();if(l){if(l instanceof Promise){l.then(function(e){e._bSetBySemanticFormElement=true;this.setLayoutData(e)}.bind(o))}else if(l.isA("sap.ui.core.LayoutData")){l._bSetBySemanticFormElement=true;o.setLayoutData(l)}}}}if(e.length>1){for(s=0;s<e.length;s++){var n=e[s];l=n.getLayoutData();if(!l||l._bSetBySemanticFormElement){l=r.getLayoutDataForSemanticField(e.length,s+1,l);if(l){if(l instanceof Promise){l.then(function(e){e._bSetBySemanticFormElement=true;this.setLayoutData(e)}.bind(n))}else if(l.isA("sap.ui.core.LayoutData")&&!l._bSetBySemanticFormElement){l._bSetBySemanticFormElement=true;n.setLayoutData(l)}}}}}this._bLayoutDataCreated=true}}function m(){if(this._getEditable()){return false}else{var e=this.getFields();var t=true;for(var i=0;i<e.length;i++){if(!e[i].getFormRenderAsControl||!e[i].getFormRenderAsControl()){t=false;break}}var a=this.getParent();var r=a&&a.getParent();var l=r&&r.getLayout();var s=l?l.renderControlsForSemanticElement():true;return!(t&&s)}}function y(e,t){var i;if(e==="set"){var a;if(t.isA("sap.ui.layout.form.FormContainer")){this._oObserver.observe(t,{parent:true});a=t.getParent()}else if(t.isA("sap.ui.layout.form.Form")){this._oObserver.observe(t,{aggregations:["layout"]});a=t}i=a&&a.getLayout()}else if(t.isA("sap.ui.layout.form.FormContainer")||t.isA("sap.ui.layout.form.Form")){this._oObserver.unobserve(t)}if(i){v.call(this,i)}}function v(e,t){a.call(this,this._getEditable());d.call(this)}return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/SimpleForm", ["sap/ui/core/Control","sap/ui/base/ManagedObjectObserver","sap/ui/layout/library","./Form","./FormContainer","./FormElement","./FormLayout","./SimpleFormRenderer","sap/base/Log","sap/ui/thirdparty/jquery"],function(e,t,a,i,s,r,n,o,l,jQuery){"use strict";var u=a.BackgroundDesign;var h=a.form.SimpleFormLayout;var g;var f;var d;var y;var p;var m;var v;var c;var L=e.extend("sap.ui.layout.form.SimpleForm",{metadata:{library:"sap.ui.layout",properties:{maxContainerCols:{type:"int",group:"Appearance",defaultValue:2},minWidth:{type:"int",group:"Appearance",defaultValue:-1},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},editable:{type:"boolean",group:"Misc",defaultValue:null},labelMinWidth:{type:"int",group:"Misc",defaultValue:192},layout:{type:"sap.ui.layout.form.SimpleFormLayout",group:"Misc",defaultValue:h.ResponsiveGridLayout},labelSpanXL:{type:"int",group:"Misc",defaultValue:-1},labelSpanL:{type:"int",group:"Misc",defaultValue:4},labelSpanM:{type:"int",group:"Misc",defaultValue:2},labelSpanS:{type:"int",group:"Misc",defaultValue:12},adjustLabelSpan:{type:"boolean",group:"Misc",defaultValue:true},emptySpanXL:{type:"int",group:"Misc",defaultValue:-1},emptySpanL:{type:"int",group:"Misc",defaultValue:0},emptySpanM:{type:"int",group:"Misc",defaultValue:0},emptySpanS:{type:"int",group:"Misc",defaultValue:0},columnsXL:{type:"int",group:"Misc",defaultValue:-1},columnsL:{type:"int",group:"Misc",defaultValue:2},columnsM:{type:"int",group:"Misc",defaultValue:1},singleContainerFullSize:{type:"boolean",group:"Misc",defaultValue:true},breakpointXL:{type:"int",group:"Misc",defaultValue:1440},breakpointL:{type:"int",group:"Misc",defaultValue:1024},breakpointM:{type:"int",group:"Misc",defaultValue:600},backgroundDesign:{type:"sap.ui.layout.BackgroundDesign",group:"Appearance",defaultValue:u.Translucent}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Element",multiple:true,singularName:"content"},form:{type:"sap.ui.layout.form.Form",multiple:false,visibility:"hidden"},title:{type:"sap.ui.core.Title",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/ui/layout/designtime/form/SimpleForm.designtime"},renderer:o});L.prototype.init=function(){this._iMaxWeight=8;this._iLabelWeight=3;this._iCurrentWidth=0;var e=new i(this.getId()+"--Form");e.getTitle=function(){return this.getParent().getTitle()};e._origInvalidate=e.invalidate;e.invalidate=function(e){if(this.bOutput){this._origInvalidate(e)}if(this._bIsBeingDestroyed){return}var t=this.getParent();if(t){t._formInvalidated(e)}};e.getAriaLabelledBy=function(){var e=this.getParent();if(e){return e.getAriaLabelledBy()}else{return null}};e._origOnLayoutDataChange=e.onLayoutDataChange;e.onLayoutDataChange=function(e){this._origOnLayoutDataChange(e);var t=this.getParent();if(t){t._onLayoutDataChange(e)}};this.setAggregation("form",e);this._aElements=null;this._aLayouts=[];this._changedFormContainers=[];this._changedFormElements=[];this._oObserver=new t(H.bind(this))};L.prototype.exit=function(){var e=this.getAggregation("form");e.invalidate=e._origInvalidate;X.call(this);for(var t=0;t<this._aLayouts.length;t++){var a=sap.ui.getCore().byId(this._aLayouts[t]);if(a&&a.destroy){a.destroy()}}this._aLayouts=[];this._aElements=null;this._changedFormContainers=[];this._changedFormElements=[];this._oObserver.disconnect();this._oObserver=undefined};L.prototype.onBeforeRendering=function(){X.call(this);var e=this.getAggregation("form");var t=this.getLayout();if(!this._bResponsiveLayoutRequested&&t===h.ResponsiveLayout||!this._bGridLayoutRequested&&t===h.GridLayout||!this._bResponsiveGridLayoutRequested&&t===h.ResponsiveGridLayout||!this._bColumnLayoutRequested&&t===h.ColumnLayout){var a=true;if(!e.getLayout()){a=b.call(this)}if(a){B.call(this)}}};L.prototype.onAfterRendering=function(){if(this.getLayout()==h.ResponsiveLayout){this._bChangedByMe=true;this.$().css("visibility","hidden");this._applyLinebreaks();if(!this._bResponsiveLayoutRequested&&c){this._sResizeListenerId=c.register(this.getDomRef(),jQuery.proxy(this._resize,this))}this._bChangedByMe=false}};L.prototype.setEditable=function(e){this._bChangedByMe=true;this.setProperty("editable",e,true);var t=this.getAggregation("form");t.setEditable(e);this._bChangedByMe=false;return this};L.prototype.setToolbar=function(e){this._bChangedByMe=true;var t=this.getAggregation("form");t.setToolbar(e);this._bChangedByMe=false;return this};L.prototype.getToolbar=function(){var e=this.getAggregation("form");return e.getToolbar()};L.prototype.destroyToolbar=function(){this._bChangedByMe=true;var e=this.getAggregation("form");e.destroyToolbar();this._bChangedByMe=false;return this};L.prototype.setLabelMinWidth=function(e){this.setProperty("labelMinWidth",e,true);if(this.getLayout()==h.ResponsiveLayout){this._bLayoutDataChangedByMe=true;var t=this.getContent();for(var a=0;a<t.length;a++){var i=t[a];if(i.isA("sap.ui.core.Label")){var s=k.call(this,i);if(s&&s.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&A.call(this,s)){s.setMinWidth(e)}}}this._bLayoutDataChangedByMe=false}return this};L.prototype.indexOfContent=function(e){var t=this._aElements;if(t){for(var a=0;a<t.length;a++){if(t[a]==e){return a}}}return-1};L.prototype.addContent=function(e){e=this.validateAggregation("content",e,true);if(this.indexOfContent(e)>=0){l.warning("SimpleForm.addContent: Content element '"+e+"' already assigned. Please remove before adding!",this);this.removeContent(e)}if(!this._aElements){this._aElements=[]}this._bChangedByMe=true;var t=this._aElements.length;var a;var i=this.getAggregation("form");var n;var o;var u;var g;var f=this.getLayout();if(e.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){n=V.call(this,e);i.addFormContainer(n);this._changedFormContainers.push(n)}else if(e.isA("sap.ui.core.Label")){if(t>0){a=this._aElements[t-1];u=a.getParent();if(u instanceof r){n=u.getParent()}else if(u instanceof s){n=u}}if(!n){n=V.call(this);i.addFormContainer(n);this._changedFormContainers.push(n)}o=q.call(this,n,e)}else{if(t>0){a=this._aElements[t-1];u=a.getParent();if(u instanceof r){n=u.getParent();o=u;g=k.call(this,e);if(g&&g.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&f===h.ResponsiveLayout&&!A.call(this,g)&&g.getLinebreak()){o=q.call(this,n)}}else if(u instanceof s){n=u;o=q.call(this,n)}}else{n=V.call(this);i.addFormContainer(n);this._changedFormContainers.push(n);o=q.call(this,n)}G.call(this,e,5,false,true);o.addField(e);j(this._changedFormElements,o)}this._aElements.push(e);this._oObserver.observe(e,{properties:["visible"]});this.invalidate();this._bChangedByMe=false;return this};L.prototype.insertContent=function(e,t){e=this.validateAggregation("content",e,true);if(this.indexOfContent(e)>=0){l.warning("SimpleForm.insertContent: Content element '"+e+"' already assigned. Please remove before insert!",this);this.removeContent(e)}if(!this._aElements){this._aElements=[]}var a=this._aElements.length;var i;if(t<0){i=0}else if(t>a){i=a}else{i=t}if(i!==t){l.warning("SimpleForm.insertContent: index '"+t+"' out of range [0,"+a+"], forced to "+i)}if(i==a){this.addContent(e);return this}this._bChangedByMe=true;var s=this._aElements[i];var r=this.getAggregation("form");var n;var o;var u;var g;var f;var d=0;var y;var p;var m;var v;var c=0;var L;var b;var _=this.getLayout();if(e.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){n=V.call(this,e);if(t==0&&!s.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){u=s.getParent().getParent();m=u.getFormElements();for(c=0;c<m.length;c++){n.addFormElement(m[c])}u.destroy();f=0}else if(s.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){u=s.getParent();f=r.indexOfFormContainer(u)}else{g=s.getParent();u=g.getParent();f=r.indexOfFormContainer(u)+1;d=u.indexOfFormElement(g);if(!s.isA("sap.ui.core.Label")){y=g.indexOfField(s);if(y>0||g.getLabel()){o=q.call(this,n);this._changedFormElements.push(o);j(this._changedFormElements,g);p=g.getFields();for(c=y;c<p.length;c++){L=p[c];o.addField(L)}d++}}m=u.getFormElements();for(c=d;c<m.length;c++){n.addFormElement(m[c])}}r.insertFormContainer(n,f);this._changedFormContainers.push(n)}else if(e.isA("sap.ui.core.Label")){if(s.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){u=s.getParent();f=r.indexOfFormContainer(u);v=r.getFormContainers();if(f==0){n=V.call(this);r.insertFormContainer(n,f);this._changedFormContainers.push(n)}else{n=v[f-1]}o=q.call(this,n,e)}else if(s.isA("sap.ui.core.Label")){u=s.getParent().getParent();d=u.indexOfFormElement(s.getParent());o=O.call(this,u,e,d)}else{g=s.getParent();u=g.getParent();d=u.indexOfFormElement(g)+1;y=g.indexOfField(s);p=g.getFields();o=O.call(this,u,e,d);for(c=y;c<p.length;c++){L=p[c];o.addField(L)}if(y==0&&!g.getLabel()){g.destroy()}else{j(this._changedFormElements,g)}}this._changedFormElements.push(o)}else{b=k.call(this,e);if(s.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){u=s.getParent();f=r.indexOfFormContainer(u);if(f==0){n=V.call(this);r.insertFormContainer(n,f);this._changedFormContainers.push(n)}else{v=r.getFormContainers();n=v[f-1]}m=n.getFormElements();if(m.length==0){o=q.call(this,n)}else if(b&&b.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&_===h.ResponsiveLayout&&!A.call(this,b)&&b.getLinebreak()){o=q.call(this,n)}else{o=m[m.length-1]}o.addField(e)}else if(s.isA("sap.ui.core.Label")){g=s.getParent();n=g.getParent();d=n.indexOfFormElement(g);if(d==0){o=O.call(this,n,null,0)}else if(b&&b.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&_===h.ResponsiveLayout&&!A.call(this,b)&&b.getLinebreak()){o=O.call(this,n,null,d)}else{m=n.getFormElements();o=m[d-1]}o.addField(e)}else{o=s.getParent();y=o.indexOfField(s);if(b&&b.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&_===h.ResponsiveLayout&&!A.call(this,b)&&b.getLinebreak()&&y>0){n=o.getParent();d=n.indexOfFormElement(o);j(this._changedFormElements,o);p=o.getFields();o=O.call(this,n,undefined,d+1);o.addField(e);for(c=y;c<p.length;c++){L=p[c];o.addField(L)}}else{o.insertField(e,y)}}j(this._changedFormElements,o);G.call(this,e,5,false,true)}this._aElements.splice(i,0,e);this._oObserver.observe(e,{properties:["visible"]});this.invalidate();this._bChangedByMe=false;return this};L.prototype.removeContent=function(e){var t=null;var a=-1;var i=0;if(this._aElements){if(typeof e=="string"){e=sap.ui.getCore().byId(e)}if(typeof e=="object"){for(i=0;i<this._aElements.length;i++){if(this._aElements[i]==e){e=i;break}}}if(typeof e=="number"){if(e<0||e>=this._aElements.length){l.warning("Element.removeAggregation called with invalid index: Items, "+e)}else{a=e;t=this._aElements[a]}}}if(t){this._bChangedByMe=true;var s=this.getAggregation("form");var r;var n;var o;var u;if(t.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){r=t.getParent();r.setTitle(null);r.setToolbar(null);o=r.getFormElements();if(a>0||o.length>0){var h=s.indexOfFormContainer(r);var g;if(a===0){g=V.call(this);s.insertFormContainer(g,h)}else{g=s.getFormContainers()[h-1];if(o.length>0&&!o[0].getLabel()){var f=g.getFormElements();var d=f[f.length-1];u=o[0].getFields();for(i=0;i<u.length;i++){d.addField(u[i])}j(this._changedFormElements,d);r.removeFormElement(o[0]);o[0].destroy();o.splice(0,1)}}for(i=0;i<o.length;i++){g.addFormElement(o[i])}j(this._changedFormContainers,g);s.removeFormContainer(r);r.destroy()}else{s.removeFormContainer(r);r.destroy()}}else if(t.isA("sap.ui.core.Label")){n=t.getParent();r=n.getParent();n.setLabel(null);u=n.getFields();var y=r.indexOfFormElement(n);var p;if(y===0){if(u.length===0){r.removeFormElement(n);n.destroy();if(r.getFormElements().length==0&&!r.getTitle()&&!r.getToolbar()){s.removeFormContainer(r);r.destroy()}}else{p=O.call(this,r,null,0)}}else{o=r.getFormElements();p=o[y-1];j(this._changedFormElements,p)}for(i=0;i<u.length;i++){p.addField(u[i])}r.removeFormElement(n);n.destroy()}else{n=t.getParent();n.removeField(t);if(n.getFields().length==0&&!n.getLabel()){r=n.getParent();r.removeFormElement(n);n.destroy();if(r.getFormElements().length==0&&!r.getTitle()&&!r.getToolbar()){s.removeFormContainer(r);r.destroy()}}else{j(this._changedFormElements,n)}}this._aElements.splice(a,1);t.setParent(null);this._oObserver.unobserve(t);P.call(this,t);this.invalidate();this._bChangedByMe=false;return t}return null};L.prototype.removeAllContent=function(){var e=0;if(this._aElements){this._bChangedByMe=true;var t=this.getAggregation("form");var a=t.getFormContainers();for(e=0;e<a.length;e++){var i=a[e];i.setTitle(null);i.setToolbar(null);var s=i.getFormElements();for(var r=0;r<s.length;r++){var n=s[r];n.setLabel(null);n.removeAllFields()}i.destroyFormElements()}t.destroyFormContainers();for(e=0;e<this._aElements.length;e++){var o=this._aElements[e];P.call(this,o);this._oObserver.unobserve(o)}var l=this._aElements;this._aElements=null;this.invalidate();this._bChangedByMe=false;return l}else{return[]}};L.prototype.destroyContent=function(){var e=this.removeAllContent();if(e){this._bChangedByMe=true;for(var t=0;t<e.length;t++){e[t].destroy()}this.invalidate();this._bChangedByMe=false}return this};L.prototype.getContent=function(){if(!this._aElements){this._aElements=this.getAggregation("content",[])}return this._aElements.slice()};L.prototype.setLayout=function(e){var t=this.getLayout();var a=this.isPropertyInitial("layout");if(e!=t){R.call(this)}this.setProperty("layout",e);if(e!=t||a){var i=b.call(this);if(i){D.call(this)}}return this};L.prototype.clone=function(t){this._bChangedByMe=true;var a=e.prototype.clone.apply(this,arguments);var i=this.getContent();for(var s=0;s<i.length;s++){var r=i[s];var n=r.getLayoutData();this._oObserver.unobserve(r);var o=r.clone(t);this._oObserver.observe(r,{properties:["visible"]});if(n){if(n.isA("sap.ui.core.VariantLayoutData")){var l=n.getMultipleLayoutData();for(var u=0;u<l.length;u++){if(A.call(this,l[u])){a._aLayouts.push(o.getLayoutData().getMultipleLayoutData()[u].getId())}}}else if(A.call(this,n)){a._aLayouts.push(o.getLayoutData().getId())}}a.addContent(o)}this._bChangedByMe=false;return a};function b(){var e=this.getAggregation("form");if(e.getLayout()){this._bChangedByMe=true;e.destroyLayout();X.call(this);this._bChangedByMe=false}var t;switch(this.getLayout()){case h.ResponsiveLayout:if((!g||!f||!c)&&!this._bResponsiveLayoutRequested){g=sap.ui.require("sap/ui/layout/form/ResponsiveLayout");f=sap.ui.require("sap/ui/layout/ResponsiveFlowLayoutData");c=sap.ui.require("sap/ui/core/ResizeHandler");if(!g||!f||!c){sap.ui.require(["sap/ui/layout/form/ResponsiveLayout","sap/ui/layout/ResponsiveFlowLayoutData","sap/ui/core/ResizeHandler"],_.bind(this));this._bResponsiveLayoutRequested=true}}if(g&&f){t=new g(this.getId()+"--Layout")}break;case h.GridLayout:if((!y||!p||!m)&&!this._bGridLayoutRequested){y=sap.ui.require("sap/ui/layout/form/GridLayout");p=sap.ui.require("sap/ui/layout/form/GridContainerData");m=sap.ui.require("sap/ui/layout/form/GridElementData");if(!y||!p||!m){sap.ui.require(["sap/ui/layout/form/GridLayout","sap/ui/layout/form/GridContainerData","sap/ui/layout/form/GridElementData"],C.bind(this));this._bGridLayoutRequested=true}}if(y&&p&&m){t=new y(this.getId()+"--Layout")}break;case h.ResponsiveGridLayout:if(!d&&!this._bResponsiveGridLayoutRequested){d=sap.ui.require("sap/ui/layout/form/ResponsiveGridLayout");if(!d){sap.ui.require(["sap/ui/layout/form/ResponsiveGridLayout"],F.bind(this));this._bResponsiveGridLayoutRequested=true}}if(d){t=new d(this.getId()+"--Layout")}break;case h.ColumnLayout:if(!v&&!this._bColumnLayoutRequested){v=sap.ui.require("sap/ui/layout/form/ColumnLayout");if(!v){sap.ui.require(["sap/ui/layout/form/ColumnLayout"],E.bind(this));this._bColumnLayoutRequested=true}}if(v){t=new v(this.getId()+"--Layout")}break}if(t){this._bChangedByMe=true;e.setLayout(t);this._bChangedByMe=false;return true}return false}function _(e,t,a){g=e;f=t;c=a;this._bResponsiveLayoutRequested=false;if(this.getLayout()==h.ResponsiveLayout){M.call(this);if(this.getDomRef()&&!this._sResizeListenerId){this._sResizeListenerId=c.register(this.getDomRef(),jQuery.proxy(this._resize,this))}}}function C(e,t,a){y=e;p=t;m=a;this._bGridLayoutRequested=false;if(this.getLayout()==h.GridLayout){M.call(this)}}function F(e){d=e;this._bResponsiveGridLayoutRequested=false;if(this.getLayout()==h.ResponsiveGridLayout){M.call(this)}}function E(e){v=e;this._bColumnLayoutRequested=false;if(this.getLayout()==h.ColumnLayout){M.call(this)}}function M(){if(!this._bIsBeingDestroyed){b.call(this);D.call(this);if(this.getDomRef()){B.call(this)}}}function R(){this._bChangedByMe=true;var e=this.getAggregation("form");var t=e.getFormContainers();for(var a=0;a<t.length;a++){var i=t[a];j(this._changedFormContainers,i);if(i.getLayoutData()){i.destroyLayoutData()}var s=i.getFormElements();for(var r=0;r<s.length;r++){var n=s[r];j(this._changedFormElements,n);if(n.getLayoutData()){n.destroyLayoutData()}var o=n.getLabel();if(o){P.call(this,o)}var l=n.getFields();for(var u=0;u<l.length;u++){var h=l[u];P.call(this,h)}}}this._bChangedByMe=false}function D(){this._bChangedByMe=true;var e=this.getAggregation("form");var t=e.getFormContainers();for(var a=0;a<t.length;a++){var i=t[a];j(this._changedFormContainers,i);I.call(this,i);var s=i.getFormElements();for(var r=0;r<s.length;r++){var n=s[r];j(this._changedFormElements,n);w.call(this,n);var o=n.getLabel();if(o){G.call(this,o,this._iLabelWeight,false,true,this.getLabelMinWidth())}var l=n.getFields();for(var u=0;u<l.length;u++){var h=l[u];G.call(this,h,5,false,true)}}}this._bChangedByMe=false}function B(){this._bChangedByMe=true;this._changedFormContainers=[];var e=this.getLayout();var t=this.getAggregation("form").getLayout();t.setBackgroundDesign(this.getBackgroundDesign());switch(e){case h.ResponsiveLayout:this._applyLinebreaks();for(var a=0;a<this._changedFormElements.length;a++){var i=this._changedFormElements[a];W.call(this,i)}break;case h.GridLayout:z.call(this);break;case h.ResponsiveGridLayout:t.setLabelSpanXL(this.getLabelSpanXL());t.setLabelSpanL(this.getLabelSpanL());t.setLabelSpanM(this.getLabelSpanM());t.setLabelSpanS(this.getLabelSpanS());t.setAdjustLabelSpan(this.getAdjustLabelSpan());t.setEmptySpanXL(this.getEmptySpanXL());t.setEmptySpanL(this.getEmptySpanL());t.setEmptySpanM(this.getEmptySpanM());t.setEmptySpanS(this.getEmptySpanS());t.setColumnsXL(this.getColumnsXL());t.setColumnsL(this.getColumnsL());t.setColumnsM(this.getColumnsM());t.setSingleContainerFullSize(this.getSingleContainerFullSize());t.setBreakpointXL(this.getBreakpointXL());t.setBreakpointL(this.getBreakpointL());t.setBreakpointM(this.getBreakpointM());break;case h.ColumnLayout:t.setColumnsXL(this.getColumnsXL()>0?this.getColumnsXL():this.getColumnsL());t.setColumnsL(this.getColumnsL());t.setColumnsM(this.getColumnsM());t.setLabelCellsLarge(this.getLabelSpanL());t.setEmptyCellsLarge(this.getEmptySpanL());break}this._changedFormElements=[];this._bChangedByMe=false}function A(e){var t=e.getId(),a=" "+this._aLayouts.join(" ")+" ";return a.indexOf(" "+t+" ")>-1}function S(e,t,a,i){var s=new f({weight:e,linebreak:t===true,linebreakable:a===true});if(i){s.setMinWidth(i)}this._aLayouts.push(s.getId());return s}function k(e){var t;switch(this.getLayout()){case h.ResponsiveLayout:t=n.prototype.getLayoutDataForElement(e,"sap.ui.layout.ResponsiveFlowLayoutData");break;case h.GridLayout:t=n.prototype.getLayoutDataForElement(e,"sap.ui.layout.form.GridElementData");break;case h.ResponsiveGridLayout:t=n.prototype.getLayoutDataForElement(e,"sap.ui.layout.GridData");break;case h.ColumnLayout:t=n.prototype.getLayoutDataForElement(e,"sap.ui.layout.form.ColumnElementData");break}return t}function T(){var e=this.getLayout();if(e===h.ResponsiveLayout&&this._bResponsiveLayoutRequested||e===h.GridLayout&&this._bGridLayoutRequested||e===h.ResponsiveGridLayout&&this._bResponsiveGridLayoutRequested||e===h.ColumnLayout&&this._bColumnLayoutRequested){return false}if(!this.getAggregation("form").getLayout()){var t=this._bChangedByMe;var a=b.call(this);this._bChangedByMe=t;if(!a){return false}}return true}function G(e,t,a,i,s){if(this.getLayout()!=h.ResponsiveLayout){return}if(!T.call(this)){return}this._bLayoutDataChangedByMe=true;var r=k.call(this,e);if(!r||!A.call(this,r)){r=e.getLayoutData();if(r&&r.isA("sap.ui.core.VariantLayoutData")){r.addMultipleLayoutData(S.call(this,t,a,i,s))}else if(!r){e.setLayoutData(S.call(this,t,a,i,s))}else{l.warning("ResponsiveFlowLayoutData can not be set on Field "+e.getId(),"_createFieldLayoutData","SimpleForm")}}this._bLayoutDataChangedByMe=false}function w(e){if(this.getLayout()!=h.ResponsiveLayout){return}if(!T.call(this)){return}this._bLayoutDataChangedByMe=true;e.setLayoutData(new f({linebreak:true,margin:false}));this._bLayoutDataChangedByMe=false}function I(e){var t=this.getLayout();if(t!=h.ResponsiveLayout&&t!=h.GridLayout){return}if(!T.call(this)){return}this._bLayoutDataChangedByMe=true;switch(t){case h.ResponsiveLayout:e.setLayoutData(new f({minWidth:280}));break;case h.GridLayout:if(this.getMaxContainerCols()>1){e.setLayoutData(new p({halfGrid:true}))}else{e.setLayoutData(new p({halfGrid:false}))}break}this._bLayoutDataChangedByMe=false}function P(e){this._bLayoutDataChangedByMe=true;var t=k.call(this,e);if(t){var a=t.getId();for(var i=0;i<this._aLayouts.length;i++){var s=this._aLayouts[i];if(a==s){t.destroy();this._aLayouts.splice(i,1);break}}}this._bLayoutDataChangedByMe=false}function q(e,t){var a=x.call(this,t,e);e.addFormElement(a);return a}function O(e,t,a){var i=x.call(this,t,e);e.insertFormElement(i,a);return i}function x(e,t){var a;var i={};if(e){a=this.getId()+"--"+e.getId()+"--FE";e.addStyleClass("sapUiFormLabel-CTX");if(!k.call(this,e)){G.call(this,e,this._iLabelWeight,false,true,this.getLabelMinWidth())}i["label"]=e}else{a=t.getId()+"--FE-NoLabel";if(sap.ui.getCore().byId(a)){a=undefined}}var s=new r(a,i);w.call(this,s);s.isVisible=function(){var e=this.getFields();var t=false;for(var a=0;a<e.length;a++){var i=e[a];if(i.getVisible()){t=true;break}}return t};return s}function V(e){var t;var a={};if(e){t=this.getId()+"--"+e.getId()+"--FC";if(e.isA("sap.ui.core.Title")){a["title"]=e}else if(e.isA("sap.ui.core.Toolbar")){a["toolbar"]=e}}else{t=this.getId()+"--FC-NoHead"}var i=new s(t,a);I.call(this,i);i.getAriaLabelledBy=function(){var e=this.getToolbar();if(e){return e.getAriaLabelledBy()}else{return[]}};return i}function W(e){var t=this._iMaxWeight;var a=e.getFields();var i;var s=a.length;var r=e.getLabel();var n;var o=0;this._bLayoutDataChangedByMe=true;if(r&&k.call(this,r)){t=t-k.call(this,r).getWeight()}for(o=0;o<a.length;o++){i=a[o];n=k.call(this,i);if(n&&n.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&!A.call(this,n)){t=t-n.getWeight();s--}}var l=Math.floor(t/s);var u=t%s;for(o=0;o<a.length;o++){i=a[o];n=k.call(this,i);var h=l;if(!n){G.call(this,i,h,false,o==0)}else if(A.call(this,n)&&n.isA("sap.ui.layout.ResponsiveFlowLayoutData")){if(u>0){h++;u--}n.setWeight(h)}}this._bLayoutDataChangedByMe=false}L.prototype._applyLinebreaks=function(){if(!g||this._bResponsiveLayoutRequested){return}this._bLayoutDataChangedByMe=true;var e=this.getAggregation("form"),t=e.getFormContainers();var a=this.getDomRef();var i=this.$();for(var s=1;s<t.length;s++){var r=t[s],n=r.getLayoutData();if(!a||i.outerWidth(true)>this.getMinWidth()){if(s%this.getMaxContainerCols()==0){n.setLinebreak(true)}else{n.setLinebreak(false)}}else{n.setLinebreak(true)}}if(a&&i.css("visibility")=="hidden"){var o=this;setTimeout(function(){if(o.getDomRef()){o.$().css("visibility","")}},10)}this._bLayoutDataChangedByMe=false};function z(){this._bLayoutDataChangedByMe=true;var e=this.getAggregation("form");var t=e.getFormContainers();var a=t.length;for(var i=0;i<a;i++){var s=t[i];if(this.getMaxContainerCols()<=1||i==a-1&&a%2>0){s.getLayoutData().setHalfGrid(false)}else if(!s.getLayoutData().getHalfGrid()){s.getLayoutData().setHalfGrid(true)}}this._bLayoutDataChangedByMe=false}L.prototype._resize=function(e){this._bChangedByMe=true;if(this._iCurrentWidth==e.size.width){return}this._iCurrentWidth=e.size.width;this._applyLinebreaks();this._bChangedByMe=false};function X(){if(this._sResizeListenerId){c.deregister(this._sResizeListenerId);this._sResizeListenerId=null}}function j(e,t){var a=false;for(var i=0;i<e.length;i++){var s=e[i];if(s==t){a=true;break}}if(!a){e.push(t)}}function H(e){if(e.name=="visible"){var t=e.object.getParent();t.invalidate()}}function N(e){var t=[];var a=e.getFormContainers();for(var i=0;i<a.length;i++){var s=a[i];var r=s.getTitle();if(r){t.push(r)}else{var n=s.getToolbar();if(n){t.push(n)}}var o=s.getFormElements();for(var l=0;l<o.length;l++){var u=o[l];var h=u.getLabel();if(h){t.push(h)}var g=u.getFields();for(var f=0;f<g.length;f++){var d=g[f];t.push(d)}}}return t}L.prototype._formInvalidated=function(e){if(!this._bChangedByMe){var t=N(this.getAggregation("form"));var a=0;var i=0;var s=false;if(!this._aElements||t.length<this._aElements.length){s=true}else{for(a=0;a<t.length;a++){var r=t[a];var n=this._aElements[i];if(r===n){i++}else{var o=t[a+1];if(o===n){this.insertContent(r,a);break}o=this._aElements[i+1];if(o===r){s=true;break}break}}}if(s){this.removeAllContent();for(a=0;a<t.length;a++){var l=t[a];this.addContent(l)}}}};L.prototype._onLayoutDataChange=function(e){if(!this._bLayoutDataChangedByMe&&!this._bIsBeingDestroyed){switch(this.getLayout()){case h.ResponsiveLayout:var t=e.srcControl;var a=t.getParent();if(a instanceof r){var i=this.indexOfContent(t);this.removeContent(t);this.insertContent(t,i)}break}}};L.prototype._suggestTitleId=function(e){var t=this.getAggregation("form");t._suggestTitleId(e);return this};return L});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/form/SimpleFormRenderer", [],function(){"use strict";var e={apiVersion:2};e.render=function(e,r){r._bChangedByMe=true;e.openStart("div",r).class("sapUiSimpleForm").style("width",r.getWidth()).openEnd();var n=r.getAggregation("form");e.renderControl(n);e.close("div");r._bChangedByMe=false};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/layout/library", ["sap/ui/base/DataType","sap/ui/core/library"],function(o,e){"use strict";var t=sap.ui.getCore().initLibrary({name:"sap.ui.layout",version:"1.120.22",dependencies:["sap.ui.core"],designtime:"sap/ui/layout/designtime/library.designtime",types:["sap.ui.layout.BackgroundDesign","sap.ui.layout.BlockBackgroundType","sap.ui.layout.BlockLayoutCellColorSet","sap.ui.layout.BlockLayoutCellColorShade","sap.ui.layout.BlockRowColorSets","sap.ui.layout.BoxesPerRowConfig","sap.ui.layout.GridIndent","sap.ui.layout.GridPosition","sap.ui.layout.GridSpan","sap.ui.layout.SideContentFallDown","sap.ui.layout.SideContentPosition","sap.ui.layout.SideContentVisibility","sap.ui.layout.form.ColumnsXL","sap.ui.layout.form.ColumnsL","sap.ui.layout.form.ColumnsM","sap.ui.layout.form.ColumnCells","sap.ui.layout.form.EmptyCells","sap.ui.layout.form.GridElementCells","sap.ui.layout.form.SimpleFormLayout","sap.ui.layout.cssgrid.CSSGridAutoFlow","sap.ui.layout.cssgrid.CSSGridTrack","sap.ui.layout.cssgrid.CSSGridLine","sap.ui.layout.cssgrid.CSSGridGapShortHand"],interfaces:["sap.ui.layout.cssgrid.IGridConfigurable","sap.ui.layout.cssgrid.IGridItemLayoutData"],controls:["sap.ui.layout.AlignedFlowLayout","sap.ui.layout.DynamicSideContent","sap.ui.layout.FixFlex","sap.ui.layout.Grid","sap.ui.layout.HorizontalLayout","sap.ui.layout.ResponsiveFlowLayout","sap.ui.layout.ResponsiveSplitter","sap.ui.layout.ResponsiveSplitterPage","sap.ui.layout.Splitter","sap.ui.layout.VerticalLayout","sap.ui.layout.BlockLayoutCell","sap.ui.layout.BlockLayoutRow","sap.ui.layout.BlockLayout","sap.ui.layout.form.Form","sap.ui.layout.form.FormLayout","sap.ui.layout.form.GridLayout","sap.ui.layout.form.ColumnLayout","sap.ui.layout.form.ResponsiveGridLayout","sap.ui.layout.form.ResponsiveLayout","sap.ui.layout.form.SimpleForm","sap.ui.layout.cssgrid.CSSGrid"],elements:["sap.ui.layout.BlockLayoutCellData","sap.ui.layout.GridData","sap.ui.layout.ResponsiveFlowLayoutData","sap.ui.layout.SplitterLayoutData","sap.ui.layout.form.FormContainer","sap.ui.layout.form.FormElement","sap.ui.layout.form.GridContainerData","sap.ui.layout.PaneContainer","sap.ui.layout.SplitPane","sap.ui.layout.form.GridElementData","sap.ui.layout.form.ColumnElementData","sap.ui.layout.form.ColumnContainerData","sap.ui.layout.cssgrid.GridItemLayoutData"],extensions:{flChangeHandlers:{"sap.ui.layout.BlockLayout":{moveControls:"default"},"sap.ui.layout.BlockLayoutRow":{moveControls:"default",hideControl:"default",unhideControl:"default"},"sap.ui.layout.BlockLayoutCell":"sap/ui/layout/flexibility/BlockLayoutCell","sap.ui.layout.DynamicSideContent":{moveControls:"default",hideControl:"default",unhideControl:"default"},"sap.ui.layout.form.SimpleForm":"sap/ui/layout/flexibility/SimpleForm","sap.ui.layout.Grid":{moveControls:"default",hideControl:"default",unhideControl:"default"},"sap.ui.layout.FixFlex":{moveControls:"default",hideControl:"default",unhideControl:"default"},"sap.ui.layout.form.Form":"sap/ui/layout/flexibility/Form","sap.ui.layout.form.FormContainer":"sap/ui/layout/flexibility/FormContainer","sap.ui.layout.form.FormElement":"sap/ui/layout/flexibility/FormElement","sap.ui.layout.HorizontalLayout":{moveControls:"default",hideControl:"default",unhideControl:"default"},"sap.ui.layout.Splitter":{moveControls:"default",hideControl:"default",unhideControl:"default"},"sap.ui.layout.VerticalLayout":{moveControls:"default",hideControl:"default",unhideControl:"default"}},"sap.ui.support":{publicRules:true,internalRules:true}}});t.BackgroundDesign={Solid:"Solid",Transparent:"Transparent",Translucent:"Translucent"};t.GridIndent=o.createType("sap.ui.layout.GridIndent",{isValid:function(o){return/^(([Xx][Ll](?:[0-9]|1[0-1]))? ?([Ll](?:[0-9]|1[0-1]))? ?([Mm](?:[0-9]|1[0-1]))? ?([Ss](?:[0-9]|1[0-1]))?)$/.test(o)}},o.getType("string"));t.GridPosition={Left:"Left",Right:"Right",Center:"Center"};t.GridSpan=o.createType("sap.ui.layout.GridSpan",{isValid:function(o){return/^(([Xx][Ll](?:[1-9]|1[0-2]))? ?([Ll](?:[1-9]|1[0-2]))? ?([Mm](?:[1-9]|1[0-2]))? ?([Ss](?:[1-9]|1[0-2]))?)$/.test(o)}},o.getType("string"));t.BlockBackgroundType={Default:"Default",Light:"Light",Mixed:"Mixed",Accent:"Accent",Dashboard:"Dashboard"};t.BlockRowColorSets={ColorSet1:"ColorSet1",ColorSet2:"ColorSet2",ColorSet3:"ColorSet3",ColorSet4:"ColorSet4"};t.BlockLayoutCellColorSet={ColorSet1:"ColorSet1",ColorSet2:"ColorSet2",ColorSet3:"ColorSet3",ColorSet4:"ColorSet4",ColorSet5:"ColorSet5",ColorSet6:"ColorSet6",ColorSet7:"ColorSet7",ColorSet8:"ColorSet8",ColorSet9:"ColorSet9",ColorSet10:"ColorSet10",ColorSet11:"ColorSet11"};t.BlockLayoutCellColorShade={ShadeA:"ShadeA",ShadeB:"ShadeB",ShadeC:"ShadeC",ShadeD:"ShadeD",ShadeE:"ShadeE",ShadeF:"ShadeF"};t.form=t.form||{};t.form.GridElementCells=o.createType("sap.ui.layout.form.GridElementCells",{isValid:function(o){return/^(auto|full|([1-9]|1[0-6]))$/.test(o)}},o.getType("string"));t.form.SimpleFormLayout={ResponsiveLayout:"ResponsiveLayout",GridLayout:"GridLayout",ResponsiveGridLayout:"ResponsiveGridLayout",ColumnLayout:"ColumnLayout"};t.SideContentVisibility={AlwaysShow:"AlwaysShow",ShowAboveL:"ShowAboveL",ShowAboveM:"ShowAboveM",ShowAboveS:"ShowAboveS",NeverShow:"NeverShow"};t.SideContentFallDown={BelowXL:"BelowXL",BelowL:"BelowL",BelowM:"BelowM",OnMinimumWidth:"OnMinimumWidth"};t.SideContentPosition={End:"End",Begin:"Begin"};t.form.ColumnsXL=o.createType("sap.ui.layout.form.ColumnsXL",{isValid:function(o){if(o>0&&o<=6){return true}else{return false}}},o.getType("int"));t.form.ColumnsL=o.createType("sap.ui.layout.form.ColumnsL",{isValid:function(o){if(o>0&&o<=3){return true}else{return false}}},o.getType("int"));t.form.ColumnsM=o.createType("sap.ui.layout.form.ColumnsM",{isValid:function(o){if(o>0&&o<=2){return true}else{return false}}},o.getType("int"));t.form.ColumnCells=o.createType("sap.ui.layout.form.ColumnCells",{isValid:function(o){if(o===-1){return true}else if(o>0&&o<=12){return true}else{return false}}},o.getType("int"));t.form.EmptyCells=o.createType("sap.ui.layout.form.EmptyCells",{isValid:function(o){if(o>=0&&o<12){return true}else{return false}}},o.getType("int"));if(!t.GridHelper){t.GridHelper={getLibrarySpecificClass:function(){return""},bFinal:false}}t.cssgrid=t.cssgrid||{};t.cssgrid.CSSGridTrack=o.createType("sap.ui.layout.cssgrid.CSSGridTrack",{isValid:function(o){var e=/(auto|inherit|(([0-9]+|[0-9]*\.[0-9]+)([rR][eE][mM]|[eE][mM]|[eE][xX]|[pP][xX]|[cC][mM]|[mM][mM]|[iI][nN]|[pP][tT]|[pP][cC]|[vV][wW]|[vV][hH]|[vV][mM][iI][nN]|[vV][mM][aA][xX]|%))|calc\(\s*(\(\s*)*[-+]?(([0-9]+|[0-9]*\.[0-9]+)([rR][eE][mM]|[eE][mM]|[eE][xX]|[pP][xX]|[cC][mM]|[mM][mM]|[iI][nN]|[pP][tT]|[pP][cC]|[vV][wW]|[vV][hH]|[vV][mM][iI][nN]|[vV][mM][aA][xX]|%)?)(\s*(\)\s*)*(\s[-+]\s|[*\/])\s*(\(\s*)*([-+]?(([0-9]+|[0-9]*\.[0-9]+)([rR][eE][mM]|[eE][mM]|[eE][xX]|[pP][xX]|[cC][mM]|[mM][mM]|[iI][nN]|[pP][tT]|[pP][cC]|[vV][wW]|[vV][hH]|[vV][mM][iI][nN]|[vV][mM][aA][xX]|%)?)))*\s*(\)\s*)*\))/g;o=o.replace(/(minmax|repeat|fit-content|max-content|min-content|auto-fill|auto-fit|fr|min|max)/g,"");o=o.replace(e,"");o=o.replace(/\(|\)|\+|\-|\*|\/|calc|\%|\,/g,"");o=o.replace(/[0-9]/g,"");o=o.replace(/\s/g,"");return o.length===0},parseValue:function(o){return o.trim().split(/\s+/).join(" ")}},o.getType("string"));t.cssgrid.CSSGridGapShortHand=o.createType("sap.ui.layout.cssgrid.CSSGridGapShortHand",{isValid:function(o){var t=true,a=o.split(/\s+/);a.forEach(function(o){if(!e.CSSSize.isValid(o)){t=false}});return t},parseValue:function(o){return o.trim().split(/\s+/).join(" ")}},o.getType("string"));t.cssgrid.CSSGridLine=o.createType("sap.ui.layout.cssgrid.CSSGridLine",{isValid:function(o){return/^(auto|inherit|((span)?(\s)?-?[0-9]+(\s\/\s(span)?(\s)?-?[0-9]*)?)?)$/.test(o)}},o.getType("string"));t.cssgrid.CSSGridAutoFlow={Row:"Row",Column:"Column",RowDense:"RowDense",ColumnDense:"ColumnDense"};t.BoxesPerRowConfig=o.createType("sap.ui.layout.BoxesPerRowConfig",{isValid:function(o){return/^(([Xx][Ll](?:[1-9]|1[0-2]))? ?([Ll](?:[1-9]|1[0-2]))? ?([Mm](?:[1-9]|1[0-2]))? ?([Ss](?:[1-9]|1[0-2]))?)$/.test(o)}},o.getType("string"));return t});
sap.ui.require.preload({
	"sap/ui/layout/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.layout","type":"library","embeds":[],"applicationVersion":{"version":"1.120.22"},"title":"SAPUI5 library with layout controls.","description":"SAPUI5 library with layout controls.","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.120","libs":{"sap.ui.core":{"minVersion":"1.120.22"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.layout.AlignedFlowLayout","sap.ui.layout.DynamicSideContent","sap.ui.layout.FixFlex","sap.ui.layout.Grid","sap.ui.layout.HorizontalLayout","sap.ui.layout.ResponsiveFlowLayout","sap.ui.layout.ResponsiveSplitter","sap.ui.layout.ResponsiveSplitterPage","sap.ui.layout.Splitter","sap.ui.layout.VerticalLayout","sap.ui.layout.BlockLayoutCell","sap.ui.layout.BlockLayoutRow","sap.ui.layout.BlockLayout","sap.ui.layout.form.Form","sap.ui.layout.form.FormLayout","sap.ui.layout.form.GridLayout","sap.ui.layout.form.ColumnLayout","sap.ui.layout.form.ResponsiveGridLayout","sap.ui.layout.form.ResponsiveLayout","sap.ui.layout.form.SimpleForm","sap.ui.layout.cssgrid.CSSGrid"],"elements":["sap.ui.layout.BlockLayoutCellData","sap.ui.layout.GridData","sap.ui.layout.ResponsiveFlowLayoutData","sap.ui.layout.SplitterLayoutData","sap.ui.layout.form.FormContainer","sap.ui.layout.form.FormElement","sap.ui.layout.form.GridContainerData","sap.ui.layout.PaneContainer","sap.ui.layout.SplitPane","sap.ui.layout.form.GridElementData","sap.ui.layout.form.ColumnElementData","sap.ui.layout.form.ColumnContainerData","sap.ui.layout.cssgrid.GridItemLayoutData"],"types":["sap.ui.layout.BackgroundDesign","sap.ui.layout.BlockBackgroundType","sap.ui.layout.BlockLayoutCellColorSet","sap.ui.layout.BlockLayoutCellColorShade","sap.ui.layout.BlockRowColorSets","sap.ui.layout.BoxesPerRowConfig","sap.ui.layout.GridIndent","sap.ui.layout.GridPosition","sap.ui.layout.GridSpan","sap.ui.layout.SideContentFallDown","sap.ui.layout.SideContentPosition","sap.ui.layout.SideContentVisibility","sap.ui.layout.form.ColumnsXL","sap.ui.layout.form.ColumnsL","sap.ui.layout.form.ColumnsM","sap.ui.layout.form.ColumnCells","sap.ui.layout.form.EmptyCells","sap.ui.layout.form.GridElementCells","sap.ui.layout.form.SimpleFormLayout","sap.ui.layout.cssgrid.CSSGridAutoFlow","sap.ui.layout.cssgrid.CSSGridTrack","sap.ui.layout.cssgrid.CSSGridLine","sap.ui.layout.cssgrid.CSSGridGapShortHand"],"interfaces":["sap.ui.layout.cssgrid.IGridConfigurable","sap.ui.layout.cssgrid.IGridItemLayoutData"]}}}}'
});
//# sourceMappingURL=library-preload.js.map
