/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/odata/v4/ChartDelegate","sap/ui/core/Core","sap/m/Text","sap/base/Log","sap/ui/mdc/util/FilterUtil","sap/ui/mdc/odata/v4/util/DelegateUtil","sap/ui/mdc/chart/ChartTypeButton","sap/ui/mdc/chart/Item","sap/ui/model/Sorter","sap/ui/mdc/chart/ChartImplementationContainer","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/p13n/panels/ChartItemPanel","sap/m/MessageStrip","sap/ui/mdc/FilterBarDelegate","sap/ui/model/Filter","sap/ui/mdc/chart/PropertyHelper","sap/ui/thirdparty/jquery","sap/ui/mdc/enums/ChartItemRoleType"],function(t,e,n,i,r,a,o,s,l,u,g,h,c,d,p,f,jQuery,y){"use strict";const m=Object.assign({},t);const _=new window.WeakMap;let C;let b;let I;let S;m._getState=function(t){if(_.has(t)){return _.get(t)}if(t){i.info("Couldn't get state for "+t.getId())}};m._setState=function(t,e){_.set(t,e)};m.getFilterDelegate=function(){return d};m.addCondition=function(t,e,n){return Promise.resolve()};m.removeCondition=function(t,e,n){return Promise.resolve()};m._deleteState=function(t){if(this._getState(t)){if(this._getState(t).vizTooltip){this._getState(t).vizTooltip.destroy()}if(this._getState(t).observer){this._getState(t).observer.disconnect();this._getState(t).observer=null}}return _.delete(t)};m._getChart=function(t){if(_.has(t)){return _.get(t).innerChart}if(t){i.info("Couldn't get state for "+t.getId())}return undefined};m._setChart=function(t,e){if(_.has(t)){_.get(t).innerChart=e}else{_.set(t,{innerChart:e})}};m._getInnerStructure=function(t){if(_.has(t)){return _.get(t).innerStructure}if(t){i.info("Couldn't get state for "+t.getId())}return undefined};m._setInnerStructure=function(t,e){if(_.has(t)){_.get(t).innerStructure=e}else{_.set(t,{innerStructure:e})}};m._getBindingInfoFromState=function(t){if(_.has(t)){return _.get(t).bindingInfo}if(t){i.info("Couldn't get state for "+t.getId())}return undefined};m._setBindingInfoForState=function(t,e){if(_.has(t)){_.get(t).bindingInfo=e}else{_.set(t,{bindingInfo:e})}};m._setUpChartObserver=function(t){const e=this._getState(t);if(!e.observer){e.observer=new g(function(t){if(t.type==="destroy"){this.exit(t.object)}}.bind(this))}e.observer.observe(t,{destroy:true})};m.exit=function(t){if(this._getInnerStructure(t)){this._getInnerStructure(t).destroy()}this._deleteState(t)};m.zoomIn=function(t){const e=this._getChart(t);if(e){e.zoom({direction:"in"})}};m.zoomOut=function(t){const e=this._getChart(t);if(e){e.zoom({direction:"out"})}};m.getZoomState=function(t){if(this._getChart(t)){return this._getChart(t).getZoomInfo(this)}};m.getInnerChartSelectionHandler=function(t){return{eventId:"_selectionDetails",listener:this._getChart(t)}};m.getChartTypeLayoutConfig=function(){if(this._aChartTypeLayout){return this._aChartTypeLayout}const t=[y.axis1,y.category,y.series];const e=[y.axis1,y.axis2,y.category,y.series];const n=[y.axis1,y.category,y.category2];const i=[y.axis1,y.axis2,y.axis3,y.category,y.series];this._aChartTypeLayout=[{key:"column",allowedLayoutOptions:t},{key:"bar",allowedLayoutOptions:t},{key:"line",allowedLayoutOptions:t},{key:"combination",allowedLayoutOptions:t},{key:"pie",allowedLayoutOptions:t},{key:"donut",allowedLayoutOptions:t},{key:"dual_column",allowedLayoutOptions:e},{key:"dual_bar",allowedLayoutOptions:e},{key:"dual_line",allowedLayoutOptions:e},{key:"stacked_bar",allowedLayoutOptions:t},{key:"scatter",allowedLayoutOptions:e},{key:"bubble",allowedLayoutOptions:i},{key:"heatmap",allowedLayoutOptions:n},{key:"bullet",allowedLayoutOptions:t},{key:"vertical_bullet",allowedLayoutOptions:t},{key:"dual_stacked_bar",allowedLayoutOptions:e},{key:"100_stacked_bar",allowedLayoutOptions:t},{key:"stacked_column",allowedLayoutOptions:t},{key:"dual_stacked_column",allowedLayoutOptions:e},{key:"100_stacked_column",allowedLayoutOptions:t},{key:"dual_combination",allowedLayoutOptions:e},{key:"dual_horizontal_combination",allowedLayoutOptions:e},{key:"dual_horizontal_combination",allowedLayoutOptions:e},{key:"dual_stacked_combination",allowedLayoutOptions:e},{key:"dual_horizontal_stacked_combination",allowedLayoutOptions:e},{key:"stacked_combination",allowedLayoutOptions:t},{key:"100_dual_stacked_bar",allowedLayoutOptions:t},{key:"100_dual_stacked_column",allowedLayoutOptions:t},{key:"horizontal_stacked_combination",allowedLayoutOptions:t},{key:"waterfall",allowedLayoutOptions:n},{key:"horizontal_waterfall",allowedLayoutOptions:n}];return this._aChartTypeLayout};m.getAdaptionUI=function(t){return Promise.resolve(this._setupAdaptionUI(t))};m._setupAdaptionUI=function(t){let e=this.getChartTypeLayoutConfig().find(function(e){return e.key===t.getChartType()});if(!e){const n=[y.axis1,y.axis2,y.axis3,y.category,y.category2,y.series];e={key:t.getChartType(),allowedLayoutOptions:n}}const n=[{kind:"Groupable"},{kind:"Aggregatable"}];e.templateConfig=n;const i={panelConfig:e};const r=new h(i);if(t.getChartType()==="heatmap"){const t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");r.setMessageStrip(new c({text:t.getText("chart.PERSONALIZATION_DIALOG_MEASURE_WARNING"),type:"Warning"}))}return r};m.setLegendVisible=function(t,e){if(this._getChart(t)){this._getChart(t).setVizProperties({legend:{visible:e},sizeLegend:{visible:e}})}else{i.error("Could not set legend visibility since inner chart is not yet initialized!")}};m._getSorterForItem=function(t,e){if(t.getType()==="aggregatable"){return new l(this._getAggregatedMeasureNameForMDCItem(t),e.descending)}else if(t.getType()==="groupable"){return new l(this.getInternalChartNameFromPropertyNameAndKind(e.name,"groupable",t.getParent()),e.descending)}};m.insertItemToInnerChart=function(t,e,n){if(e.getType()==="groupable"){const i=this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t);const r=this._getChart(t).getDimensionByName(i);if(!r){this.createInnerDimension(t,e)}else{r.setLabel(e.getLabel());r.setRole(e.getRole()?e.getRole():"category")}const a=this._getChart(t).getVisibleDimensions();a.splice(n,0,i);this._getChart(t).setVisibleDimensions(a)}else if(e.getType()==="aggregatable"){this.createInnerMeasure(t,e);const i=this._getChart(t).getVisibleMeasures();i.splice(n,0,this._getAggregatedMeasureNameForMDCItem(e));this._getChart(t).setVisibleMeasures(i)}this._prepareColoringForItem(e).then(function(){this._updateColoring(t,this._getChart(t).getVisibleDimensions(),this._getChart(t).getVisibleMeasures())}.bind(this));this._updateSemanticalPattern(t)};m.removeItemFromInnerChart=function(t,e){if(e.getType()==="groupable"&&this._getChart(t).getVisibleDimensions().includes(this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t))){const n=this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t);const i=this._getChart(t).getVisibleDimensions().filter(function(t){return t!==n});if(this._getState(t).inResultDimensions.length>0){this._getChart(t).setInResultDimensions(this._getState(t).inResultDimensions)}this._getChart(t).setVisibleDimensions(i)}else if(e.getType()==="aggregatable"&&this._getChart(t).getVisibleMeasures().includes(this._getAggregatedMeasureNameForMDCItem(e))){const n=[];t.getItems().filter(function(t){return t.getType()==="aggregatable"}).filter(function(t){return t!==e}).forEach(function(t){n.push(this._getAggregatedMeasureNameForMDCItem(t))}.bind(this));this._getChart(t).setVisibleMeasures(n);this._getChart(t).removeMeasure(this._getChart(t).getMeasureByName(this._getAggregatedMeasureNameForMDCItem(e)))}this._updateColoring(t,this._getChart(t).getVisibleDimensions(),this._getChart(t).getVisibleMeasures());this._updateSemanticalPattern(t)};m.addItem=function(t,e,n,i){if(t.getModel){return Promise.resolve(this._createMDCChartItem(e,t,i))}};m.removeItem=function(t,e){return Promise.resolve(true)};m.checkAndUpdateMDCItems=function(t){return new Promise(function(e,n){const i=[];t.getItems().forEach(function(e){const n=e.getPropertyKey()&&e.getLabel()&&e.getType()&&e.getRole();if(!n){i.push(this._getPropertyInfosByName(e.getPropertyKey(),t).then(function(t){e.setLabel(t.label);if(t.groupable){e.setType("groupable");e.setRole(e.getRole()?e.getRole():"category")}else if(t.aggregatable){e.setType("aggregatable");e.setRole(e.getRole()?e.getRole():"axis1")}}))}}.bind(this));Promise.all(i).then(function(){e()})}.bind(this))};m._createMDCChartItem=function(t,e,n){return this._getPropertyInfosByName(t,e).then(function(t){if(!t){return null}return this._createMDCItemFromProperty(t,e.getId(),n)}.bind(this))};m._createMDCItemFromProperty=function(t,e,n){if(t.groupable){return new s(e+"--GroupableItem--"+t.name,{propertyKey:t.name,label:t.label,type:"groupable",role:n?n:"category"})}if(t.aggregatable){return new s(e+"--AggregatableItem--"+t.name,{propertyKey:t.name,label:t.label,type:"aggregatable",role:n?n:"axis1"})}return null};m.initializeInnerChart=function(t){return new Promise(function(e,i){this._loadChart().then(function(i){let r;this._setInnerStructure(t,new u(t.getId()+"--implementationContainer",{}));t.addStyleClass("sapUiMDCChartTempTextOuter");if(t.getNoData()){this._getInnerStructure(t).setChartNoDataContent(t.getNoData())}else{r=new n({text:t.getNoDataText()});this._getInnerStructure(t).addStyleClass("sapUiMDCChartTempText");this._getInnerStructure(t).setNoDataContent(r)}this._setUpChartObserver(t);e(this._getInnerStructure(t))}.bind(this))}.bind(this))};m.changedNoDataStruct=function(t){if(this._getInnerStructure(t)){this._getInnerStructure(t).setChartNoDataContent(t.getNoData());this._getInnerStructure(t).invalidate()}};m._createContentFromItems=function(t){return new Promise(function(e,n){const r=[];const a=[];const o=[];const s=[];t.getItems().forEach(function(e,n){a.push(this._getPropertyInfosByName(e.getPropertyKey(),t).then(function(n){if(!n){i.error("sap.ui.mdc.Chart: Item "+e.getPropertyKey()+" has no property info representing it in the metadata. Make sure the name is correct and the metadata is defined correctly. Skipping the item!");return}switch(e.getType()){case"groupable":o.push(this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t));this._addInnerDimension(t,e,n);break;case"aggregatable":s.push(this._getAggregatedMeasureNameForMDCItem(e));this._addInnerMeasure(t,e,n);break;default:i.error("MDC Chart Item "+e.getId()+" with label "+e.getLabel()+' has no known type. Supported typed are: "groupable" & "aggregatable"')}r.push(this._prepareColoringForItem(e))}.bind(this)))}.bind(this));Promise.all(a).then(function(){this._getState(t).aColMeasures.forEach(function(e){if(this._getState(t).aInSettings.indexOf(e)==-1){r.push(new Promise(function(n,i){t._getPropertyByNameAsync(e).then(function(i){const r=i.aggregationMethod;const a=i.propertyPath;const o=this.getInternalChartNameFromPropertyNameAndKind(e,"aggregatable",t);const l={name:o,label:i.label,role:"axis1"};if(r&&a){l.analyticalInfo={propertyPath:a,with:r}}const u=new I(l);s.push(u);this._getChart(t).addMeasure(u);n()})}))}}.bind(this));Promise.all(r).then(function(){this._getChart(t).setVisibleDimensions(o);this._getChart(t).setVisibleMeasures(s);const n=t.getDelegate().inResultDimensions;if(n&&n instanceof Array&&n.length!=0){const e=[];n.forEach(function(n){e.push(this._getPropertyInfosByName(n,t).then(function(e){const n=this.getInternalChartNameFromPropertyNameAndKind(e.name,"groupable",t);const i=new b({name:n,label:e.label});this._getState(t).inResultDimensions.push(n);this._getChart(t).addDimension(i)}.bind(this)))}.bind(this));Promise.all(e).then(function(){this._getChart(t).setInResultDimensions(this._getState(t).inResultDimensions)}.bind(this))}this._updateColoring(t,o,s);this._updateSemanticalPattern(t);e()}.bind(this))}.bind(this))}.bind(this))};m.getInnerChart=function(t){return this._getChart(t)};m._prepareColoringForItem=function(t){return this._addCriticality(t).then(function(){this._getState(t.getParent()).aInSettings.push(t.getPropertyKey());if(t.getType()==="aggregatable"){this._getPropertyInfosByName(t.getPropertyKey(),t.getParent()).then(function(e){this._getAdditionalColoringMeasuresForItem(e).forEach(function(e){if(this._getState(t.getParent()).aColMeasures&&this._getState(t.getParent()).aColMeasures.indexOf(e)==-1){this._getState(t.getParent()).aColMeasures.push(e)}}.bind(this))}.bind(this))}}.bind(this))};m._getAdditionalColoringMeasuresForItem=function(t){let e=[];const n=t.datapoint?t.datapoint.criticality:null;if(n&&n.DynamicThresholds){e=n.DynamicThresholds.usedMeasures}return e};m._addCriticality=function(t){return this._getPropertyInfosByName(t.getPropertyKey(),t.getParent()).then(function(e){if(e.criticality||e.datapoint&&e.datapoint.criticality){const n=this._getState(t.getParent()).oColorings||{Criticality:{DimensionValues:{},MeasureValues:{}}};const i={};if(t.getType()=="groupable"){const r=e.criticality?e.criticality:[];for(const t in r){i[t]={Values:r[t]}}const a=this.getInternalChartNameFromPropertyNameAndKind(t.getPropertyKey(),"groupable",t.getParent());n.Criticality.DimensionValues[a]=i}else{const r=e.datapoint&&e.datapoint.criticality?e.datapoint.criticality:[];for(const t in r){i[t]=r[t]}const a=this.getInternalChartNameFromPropertyNameAndKind(t.getPropertyKey(),"aggregatable",t.getParent());n.Criticality.MeasureValues[a]=i}const r=this._getState(t.getParent());r.oColorings=n;this._setState(t.getParent(),r)}}.bind(this))};m._updateColoring=function(t,e,n){const i=jQuery.extend(true,{},this._getState(t).oColorings);let r;if(i&&i.Criticality){let a;for(r=0;r<e.length;r++){if(this._getState(t).oColorings.Criticality.DimensionValues[e[r]]){a={coloring:"Criticality",parameters:{dimension:e[r]}};delete i.Criticality.MeasureValues;break}}if(!a){delete i.Criticality.DimensionValues;for(const t in i.Criticality.MeasureValues){if(n.indexOf(t)==-1){delete i.Criticality.MeasureValues[t]}}a={coloring:"Criticality",parameters:{measure:n}}}if(a){this._getChart(t).setColorings(i);this._getChart(t).setActiveColoring(a)}}};m._updateSemanticalPattern=function(t){const e=this._getChart(t).getVisibleMeasures();e.forEach(function(e){const n=this.getPropertyFromNameAndKind(e,"aggregatable",t);if(!n){return}const r=n.datapoint;if(r){if(r.targetValue||r.foreCastValue){const n=this._getChart(t).getMeasureByName(e);n.setSemantics("actual");if(r.targetValue!=null){const e=this._getChart(t).getMeasureByName(r.targetValue);if(e){e.setSemantics("reference")}else{i.error("sap.ui.mdc.Chart: "+r.targetValue+" is not a valid measure")}}if(r.foreCastValue){const e=this._getChart(t).getMeasureByName(r.foreCastValue);if(e){e.setSemantics("projected")}else{i.error("sap.ui.comp.SmartChart: "+r.ForecastValue.Path+" is not a valid measure")}}n.setSemanticallyRelatedMeasures({referenceValueMeasure:r.targetValue,projectedValueMeasure:r.foreCastValue})}}}.bind(this))};m.getChartTypeInfo=function(t){const n=t.getChartType(),i=e.getLibraryResourceBundle("sap.ui.mdc"),r=e.getLibraryResourceBundle("sap.chart.messages");const a={icon:o.mMatchingIcon[n],text:i.getText("chart.CHART_TYPE_TOOLTIP",[r.getText("info/"+n)])};return a};m.getAvailableChartTypes=function(t){const n=[];if(this._getChart(t)){const i=this._getChart(t).getAvailableChartTypes().available;const r=e.getLibraryResourceBundle("sap.chart.messages");for(let e=0;e<i.length;e++){const a=i[e].chart;n.push({key:a,icon:o.mMatchingIcon[a],text:r.getText("info/"+a),selected:a==t.getChartType()})}}return n};m.getDrillStack=function(t){const e=Object.assign([],this._getChart(t).getDrillStack());e.forEach(function(e){e.dimension=e.dimension.map(function(e){const n=this.getPropertyFromNameAndKind(e,"groupable",t);if(n){return n.name}else{i.error("MDC Chart Delegate: Couldn't map chart dimension to groupable property: "+e);return e}}.bind(this))}.bind(this));return e};m.getSortedDimensions=function(t){return new Promise(function(e,n){if(t.isPropertyHelperFinal()){e(this._sortPropertyDimensions(t.getPropertyHelper().getProperties()))}else{t.finalizePropertyHelper().then(function(){e(this._sortPropertyDimensions(t.getPropertyHelper().getProperties()))}.bind(this))}}.bind(this))};m._sortPropertyDimensions=function(t){const e=t.filter(function(t){return t.groupable});if(e){e.sort(function(t,e){if(t.label&&e.label){return t.label.localeCompare(e.label)}})}return e};m.getDrillableItems=function(t){const e=t.getItems().filter(function(t){return t.getType()==="groupable"});return e};m.setChartType=function(t,e){this._getChart(t).setChartType(e)};m.createInnerChartContent=function(t,e){return new Promise(function(n,r){this._setChart(t,new C({id:t.getId()+"--innerChart",chartType:"column",height:"100%",width:"100%",isAnalytical:true}));this._getChart(t).setCustomMessages({NO_DATA:t.getNoDataText()});this._getState(t).inResultDimensions=[];this._getInnerStructure(t).removeStyleClass("sapUiMDCChartTempText");t.removeStyleClass("sapUiMDCChartTempTextOuter");t.addStyleClass("sapUiMDCChartGrid");const a=this._getState(t);a.aColMeasures=[];a.aInSettings=[];this._setState(t,a);this._createContentFromItems(t).then(function(){this._getChart(t).attachRenderComplete(function(){if(this._getState(t).toolbarUpdateRequested){t._updateToolbar();this._getState(t).toolbarUpdateRequested=false}}.bind(this));this._getInnerStructure(t).setContent(this._getChart(t));this._getInnerStructure(t).setShowNoDataStruct(false);a.dataLoadedCallback=e;this._setState(t,a);let r;if(this._getBindingInfo){r=this._getBindingInfo(t);i.warning("mdc ChartDelegate","calling the private delegate._getBindingInfo. Please make the function public!")}else{r=this.getBindingInfo(t)}this.updateBindingInfo(t,r);this._performInitialBind(t,r);n()}.bind(this))}.bind(this))};m._performInitialBind=function(t,e){if(t&&e&&this._getChart(t)){this._addBindingListener(e,"dataReceived",this._onDataLoadComplete.bind(t));this._getChart(t).bindData(e);this._setBindingInfoForState(t,e);const n=this._getState(t);n.innerChartBound=true;this._checkForMeasureWarning(t)}};m.requestToolbarUpdate=function(t){if(t.getItems().length===0){t._updateToolbar();return}this._getState(t).toolbarUpdateRequested=true};m.createInnerDimension=function(t,e){this._getPropertyInfosByName(e.getPropertyKey(),t).then(function(n){this._addInnerDimension(t,e,n)}.bind(this))};m.createInnerMeasure=function(t,e){this._getPropertyInfosByName(e.getPropertyKey(),t).then(function(n){this._addInnerMeasure(t,e,n)}.bind(this))};m._addInnerDimension=function(t,e,n){const i=this.innerDimensionFactory(t,e,n);this._getChart(t).addDimension(i)};m.innerDimensionFactory=function(t,e,n){const i=new b({name:this.getInternalChartNameFromPropertyNameAndKind(e.getPropertyKey(),"groupable",t),role:e.getRole()?e.getRole():"category",label:e.getLabel()});if(n.textProperty){i.setTextProperty(n.textProperty);i.setDisplayText(true)}if(n.textFormatter){i.setTextFormatter(this.formatText.bind(n))}return i};m._addInnerMeasure=function(t,e,n){const i=this.innerMeasureFactory(t,e,n);this._getChart(t).addMeasure(i)};m.innerMeasureFactory=function(t,e,n){const i=n.aggregationMethod;const r=n.propertyPath;const a={name:this._getAggregatedMeasureNameForMDCItem(e),label:e.getLabel(),role:e.getRole()?e.getRole():"axis1"};if(i&&r){a.analyticalInfo={propertyPath:r,with:i}}return new I(a)};m._getAggregatedMeasureNameForProperty=function(t){return t.aggregationMethod+t.name};m.rebind=function(t,e){if(t&&e&&this._getChart(t)){this._addBindingListener(e,"dataReceived",this._onDataLoadComplete.bind(t));this._getInnerStructure(t).setShowNoDataStruct(false);if(e.binding){e.binding.bHasAnalyticalInfo=true}this._getChart(t).bindData(e);this._setBindingInfoForState(t,e);const n=this._getState(t);n.innerChartBound=true}};m._checkForMeasureWarning=function(t){if(!t.getNoData()){return}const e=t.getItems().filter(function(t){return t.getType()==="aggregatable"});if(e.length===0){this._getInnerStructure(t).setShowNoDataStruct(true);t.setBusy(false)}else{this._getInnerStructure(t).setShowNoDataStruct(false)}};m.getBindingInfo=function(t){if(this._getBindingInfoFromState(t)){return this._getBindingInfoFromState(t)}const e=t.getDelegate().payload;const n="/"+e.collectionName;const i={path:n};return i};m.getInnerChartBound=function(t){const e=this._getState(t);if(!e){return false}return e.innerChartBound?true:false};m.updateBindingInfo=function(t,e){const n=P.call(this,t).concat(D.call(this,t));M(t,e);e.filters=new p(n,true);e.sorter=this.getSorters(t)};function P(t){const e=t.getP13nMode().indexOf("Filter")>-1;const n=[];if(e){const e=t.getPropertyHelper().getProperties();const i=r.getFilterInfo(this.getTypeMap(),t.getConditions(),e);if(i.filters){n.push(i.filters)}}return n}function D(t){const n=e.byId(t.getFilter());const i=[];if(!n){return i}const o=n.getConditions();if(o){const t=n.getPropertyInfoSet?n.getPropertyInfoSet():null;const e=a.getParameterNames(n);const s=r.getFilterInfo(this.getTypeMap(),o,t,e);if(s.filters){i.push(s.filters)}}return i}function M(t,n){const i=e.byId(t.getFilter());if(!i){return}const r=i.getConditions();const o=i.getSearch instanceof Function?i.getSearch():"";if(r){const t=a.getParametersInfo(i,r);if(t){n.path=t}}if(!n.parameters){n.parameters={}}n.parameters["$search"]=o||undefined}m.getSorters=function(t){let e;const n=t.getSortConditions()?t.getSortConditions().sorters:[];n.forEach(function(n){const i=t.getItems().find(function(t){return t.getPropertyKey()===n.name});if(!i){return}const r=this._getSorterForItem(i,n);if(e){e.push(r)}else{e=[r]}}.bind(this));return e};m._getAggregatedMeasureNameForMDCItem=function(t){return this.getInternalChartNameFromPropertyNameAndKind(t.getPropertyKey(),"aggregatable",t.getParent())};m.getInternalChartNameFromPropertyNameAndKind=function(t,e,n){return t};m.getPropertyFromNameAndKind=function(t,e,n){return n.getPropertyHelper().getProperty(t)};m.setChartTooltipVisibility=function(t,e){if(this._getChart(t)){if(e){if(!this._getState(t).vizTooltip){const e=this._getState(t);e.vizTooltip=new S;this._setState(t,e)}this._getState(t).vizTooltip.connect(this._getChart(t).getVizUid())}else if(this._getState(t).vizTooltip){this._getState(t).vizTooltip.destroy()}}else{i.error("Trying to set chart tooltip while inner chart was not yet initialized")}};m._loadChart=function(){return new Promise(function(t){const n=["sap/chart/Chart","sap/chart/data/Dimension","sap/chart/data/Measure","sap/viz/ui5/controls/VizTooltip"];function i(e,n,i,r){C=e;b=n;I=i;S=r;t()}e.loadLibrary("sap.viz",{async:true}).then(function(){sap.ui.require(n,i)})})};m.getPropertyHelperClass=function(){return f};m.formatText=function(t,e){return t};m.setNoDataText=function(t,e){this._getChart(t).setCustomMessages({NO_DATA:e})};m.showOverlay=function(t,e){if(this._getInnerStructure(t)){this._getInnerStructure(t).showOverlay(e)}};m._getPropertyInfosByName=function(t,e){return e._getPropertyByNameAsync(t)};m._getModel=function(t){const e=t.getDelegate().payload;return t.getModel(e.model)};m._addBindingListener=function(t,e,n){if(!t.events){t.events={}}if(!t.events[e]){t.events[e]=n}else{const i=t.events[e];t.events[e]=function(){n.apply(this,arguments);i.apply(this,arguments)}}};m._onDataLoadComplete=function(t){const e=this.getControlDelegate()._getInnerStructure(this);if(this.getNoData()){if(t.getSource()&&t.getSource().getCurrentContexts().length===0){e.setShowNoDataStruct(true)}else{e.setShowNoDataStruct(false)}}this._innerChartDataLoadComplete(t)};return m});
//# sourceMappingURL=ChartDelegate.js.map