/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./PropertyHelper","sap/m/Button","sap/m/Bar","sap/m/Title","sap/base/util/merge","sap/m/MessageBox","sap/ui/Device","sap/ui/fl/write/api/FieldExtensibility","sap/ui/core/Configuration","sap/ui/core/library"],function(e,t,n,o,i,r,s,a,c,u){"use strict";const l=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");const p=u.TitleLevel;const g={createP13nPopover:function(e,t){return new Promise(function(n,o){sap.ui.require(["sap/m/ResponsivePopover"],function(i){g["_checkSettings"](e,t,o);const r=new i({title:t.title,horizontalScrolling:t.hasOwnProperty("horizontalScrolling")?t.horizontalScrolling:false,verticalScrolling:t.hasOwnProperty("verticalScrolling")?t.verticalScrolling:false,contentWidth:t.contentWidth?t.contentWidth:"24rem",resizable:t.hasOwnProperty("resizable")?t.resizable:true,contentHeight:t.contentHeight?t.contentHeight:"35rem",placement:t.placement?t.placement:"Bottom",content:e,afterClose:t.afterClose?t.afterClose:function(){}});if(t.reset){const e=g._createResetHeader({title:t.title,reset:t.reset.onExecute,idResetButton:t.reset.idButton,warningText:t.reset.warningText});r.setCustomHeader(e)}n(r)},o)})},createP13nDialog:function(e,t){return new Promise(function(n,o){g["_checkSettings"](e,t,o);const i=t.id;sap.ui.require(["sap/m/Dialog","sap/m/Button"],function(r,a){const c=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");const u=new r(i,{title:t.title,horizontalScrolling:t.hasOwnProperty("horizontalScrolling")?t.horizontalScrolling:false,verticalScrolling:t.hasOwnProperty("verticalScrolling")?t.verticalScrolling:true,contentWidth:t.contentWidth?t.contentWidth:"40rem",contentHeight:t.contentHeight?t.contentHeight:"55rem",draggable:true,resizable:true,stretch:s.system.phone,content:e,afterClose:t.afterClose?t.afterClose:function(){},buttons:[new a(i?i+"-confirmBtn":undefined,{text:t.confirm&&t.confirm.text?t.confirm.text:c.getText("p13nDialog.OK"),type:"Emphasized",press:function(){if(t.confirm&&t.confirm.handler){t.confirm.handler.apply(u,arguments)}}}),new a(i?i+"-cancelBtn":undefined,{text:c.getText("p13nDialog.CANCEL"),press:function(){t.cancel.apply(u,arguments)}})]});if(t.reset){const e=g._createResetHeader({title:t.title,idResetButton:t.reset.idButton,reset:t.reset.onExecute,warningText:t.reset.warningText});u.setCustomHeader(e)}const l=t.additionalButtons;if(l instanceof Array){l.forEach(function(e){if(!e.isA("sap.m.Button")){o("Please only provide sap.m.Button instances as 'additionalButtons'")}u.addButton(e)})}n(u)},o)})},_createResetHeader:function(e){const i=new n({contentLeft:[new o({text:e.title,level:p.H1})]});if(e.reset){const n=e.idResetButton;i.addContentRight(new t(n,{text:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("p13nDialog.RESET"),press:function(t){const n=t.getSource().getParent().getParent();const o=n.getParent();const i=e.warningText?e.warningText:sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc").getText("filterbar.ADAPT_RESET_WARNING");r.warning(i,{actions:[r.Action.OK,r.Action.CANCEL],emphasizedAction:r.Action.OK,onClose:function(t){if(t===r.Action.OK){n.getButtons()[0].focus();e.reset(o)}}})}}))}return i},prepareAdaptationData:function(t,n,o){const i=t&&t.getProperties instanceof Function?t:new e(t);const r=[];const s=o?{}:null;const a=n instanceof Function;i.getProperties().forEach(function(e){const t={};t.name=e.name;if(a){const o=n(t,e);if(!o){return}}t.label=e.label||e.name;t.tooltip=e.tooltip;if(s){t.group=e.group?e.group:"BASIC";t.groupLabel=e.groupLabel;s[t.group]=s[t.group]?s[t.group]:[];s[t.group].push(t)}r.push(t)});const c={items:r};if(s){c.itemsGrouped=this._buildGroupStructure(s)}return c},sortP13nData:function(e,t){const n=e;const o=n.position;const i=n.visible;const r=c.getLocale().toString();const s=window.Intl.Collator(r,{});t.sort(function(e,t){if(e[i]&&t[i]){return(e[o]||0)-(t[o]||0)}else if(e[i]){return-1}else if(t[i]){return 1}else if(!e[i]&&!t[i]){return s.compare(e.label,t.label)}})},_buildGroupStructure:function(e){const t=[];Object.keys(e).forEach(function(n){this.sortP13nData("generic",e[n]);t.push({group:n,groupLabel:e[n][0].groupLabel||l.getText("p13nDialog.FILTER_DEFAULT_GROUP"),groupVisible:true,items:e[n]})}.bind(this));return t},_isExcludeProperty:function(e,t){return t.some(function(t){const n=t.ignoreKey;const o=t.ignoreValue;return e[n]===o})},_checkSettings:function(e,t,n){if(!t){n("Please provide a settings object for p13n creation")}if(!t.title&&!t.customHeader){n("Please provide a title or customHeader in the settings object for p13n creation")}},arrayToMap:function(e){return e.reduce(function(e,t,n){e[t.name]=t;e[t.name].position=n;return e},{})},addRTACustomFieldButton:function(e,i){let r=false,s=e.getParent();if(i&&i.isA("sap.ui.comp.smarttable.SmartTable")){s=i}return sap.ui.getCore().loadLibrary("sap.ui.rta",{async:true}).then(function(){return new Promise(function(i){sap.ui.require(["sap/ui/rta/Utils"],function(c){const u=Promise.all([a.onControlSelected(s),c.isServiceUpToDate(s),a.isExtensibilityEnabled(s)]);return u.then(function(e){r=!!e[2]}).then(function(){let u=e.getCustomHeader();const l=s&&s.getId?s.getId():undefined,g=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");if(!u){const t=new n({contentLeft:[new o({text:e.getTitle(),level:p.H1})]});e.setCustomHeader(t);u=e.getCustomHeader()}if(r){u.addContentRight(new t(l+"-addCustomField",{icon:"sap-icon://add",enabled:r,tooltip:g.getText("p13nDialog.rtaAddTooltip"),press:function(e){const t=c.getRtaStyleClassName(),n=e.getSource().getParent().getParent();a.getExtensionData().then(function(e){a.onTriggerCreateExtensionData(e,t);n.close()})}}));e.setCustomHeader(u);i(e)}})})})})}};return g});
//# sourceMappingURL=P13nBuilder.js.map