/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/base/ManagedObjectObserver","sap/base/util/merge","sap/base/util/deepEqual","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/field/ConditionsType","sap/ui/mdc/field/splitValue","sap/ui/mdc/enums/FieldEditMode","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/Field","sap/ui/mdc/ValueHelp","sap/ui/mdc/valuehelp/Popover","sap/ui/mdc/valuehelp/content/FixedList","sap/ui/mdc/valuehelp/content/FixedListItem","sap/ui/model/base/ManagedObjectModel","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/model/type/String","sap/ui/model/ParseException","sap/ui/core/library","sap/ui/core/InvisibleText","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/m/library","sap/m/Button","sap/m/Panel","sap/m/OverflowToolbar","sap/m/OverflowToolbarLayoutData","sap/m/ToolbarSpacer","sap/m/Text","sap/m/Title","sap/ui/core/IconPool","sap/ui/core/InvisibleMessage","sap/ui/thirdparty/jquery"],function(t,e,i,n,s,o,a,l,r,d,c,u,h,p,g,f,C,y,v,I,m,b,O,_,T,x,S,w,D,P,V,N,M,E,$,L,B,jQuery){"use strict";let A=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");let F=sap.ui.getCore().getLibraryResourceBundle("sap.m");sap.ui.getCore().attachLocalizationChanged(function(){A=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");F=sap.ui.getCore().getLibraryResourceBundle("sap.m")});const R=w.ButtonType;const H=_.ValueState;const U=_.InvisibleMessageMode;const j=_.TextAlign;const k=w.BackgroundDesign;const G=w.ToolbarDesign;const X=w.OverflowToolbarPriority;const K=t.extend("sap.ui.mdc.valuehelp.base.DefineConditionPanel",{metadata:{library:"sap.ui.mdc",properties:{conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true},config:{type:"object",defaultValue:{}},label:{type:"string",defaultValue:""},inputOK:{type:"boolean",defaultValue:true},_pagination:{type:"boolean",defaultValue:false,visibility:"hidden"}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{fieldHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false},valueHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false}},events:{conditionProcessed:{}}},_oManagedObjectModel:null,renderer:{apiVersion:2,render:function(t,e){t.openStart("section",e);t.class("sapUiMdcDefineConditionPanel");t.openEnd();t.renderControl(e.getAggregation("_content"));t.close("section")}},init:function(){sap.ui.getCore().getMessageManager().registerObject(this,true);t.prototype.init.apply(this,arguments);this.oInvisibleMessage=B.getInstance();this._oManagedObjectModel=new v(this);this._oObserver=new e(W.bind(this));this._oObserver.observe(this,{properties:["conditions","config"]});this._iStartIndex=0;this._iShownConditions=10;this._iShownAdditionalConditions=0;this._sOperatorHelpId=this.getId()+"--rowSelect-help";this._oContentEventDelegate={onpaste:this.onPaste};rt.call(this);this.setModel(this._oManagedObjectModel,"$this");this.setModel(this._oManagedObjectModel,"$condition")},exit:function(){sap.ui.getCore().getMessageManager().unregisterObject(this,true);this._oObserver.disconnect();this._oObserver=undefined;if(this._sConditionsTimer){clearTimeout(this._sConditionsTimer);this._sConditionsTimer=null}if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType}this._oManagedObjectModel.destroy();delete this._oManagedObjectModel},byId:function(t){return sap.ui.getCore().byId(this.getId()+"--"+t)},onBeforeRendering:function(){if(!this.getModel("$i18n")){this.setModel(new m({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n")}if(this.getConditions().length===0&&!this._sConditionsTimer){this.updateDefineConditions()}},removeCondition:function(t){const e=t.oSource;const i=e.getBindingContext("$this");let n=this.getConditions();const s=i.getPath();const o=s.match(/^.*\/(\d+)\/$/);let a;if(o){a=parseInt(o[1])}if(a>0&&n.length-1===a){this._bFocusLastRemoveBtn=true}this.oInvisibleMessage.announce(A.getText("valuehelp.DEFINECONDITIONS_REMOVECONDITION_ANNOUNCE"),U.Assertive);const l=this.byId("conditions");const r=l.getContent();let d=-1;for(let t=0;t<r.length;t++){const e=r[t];if(e instanceof p&&e.getValueHelp()===this._sOperatorHelpId){d++}if(e instanceof p&&e.hasOwnProperty("_iValueIndex")&&e.getBindingContext("$this").getPath().startsWith(s)){if(e.isInvalidInput()){e.setValue(null)}}}if(n.length===1&&a===0){this.addDummyCondition(1);n=this.getConditions()}if(d===0&&this._iStartIndex>0){this._iStartIndex=this._iStartIndex-this._iShownConditions}n.splice(a,1);this.setProperty("conditions",n,true);Tt.call(this,undefined);this.fireConditionProcessed()},addCondition:function(t){const e=this.getConditions();const i=this.getConfig();const n=i.maxConditions;const s=this.byId("conditions");const o=s.getContent();let a=0;let l=-1;for(let t=0;t<o.length;t++){const e=o[t];if(e instanceof p&&e.getValueHelp()===this._sOperatorHelpId){a++;const t=e.getBindingContext("$this");const i=t.getPath();const n=i.match(/^.*\/(\d+)\/$/);if(n){l=parseInt(n[1])}}}if(n===-1||e.length<n){this.addDummyCondition(l+1);this._bFocusLastCondition=true;if(a>=this._iShownConditions){this._iShownAdditionalConditions++}}this.oInvisibleMessage.announce(A.getText("valuehelp.DEFINECONDITIONS_ADDCONDITION_ANNOUNCE"),U.Assertive)},addDummyCondition:function(t){const e=tt.call(this);const i=Z.call(this);const n=i.name;const a=s.createCondition(n,i.valueDefaults?i.valueDefaults:[],undefined,undefined,u.NotValidated);if(i.valueTypes[0]&&i.valueTypes[0]!==h.Static){a.isInitial=true}o.updateConditionValues(a);o.checkConditionsEmpty(a,e);const l=this.getConditions();if(t!==undefined){l.splice(t,0,a)}else{l.push(a)}this.setProperty("conditions",l,true);if(!a.isInitial){this.fireConditionProcessed()}},updateDefineConditions:function(){const t=xt.call(this);lt.call(this,t,true,false);if(t.length===0){this.addDummyCondition()}if(t.length<this._iStartIndex){this._iStartIndex=0}},onChange:function(t){const e=t&&t.getParameter("promise");const i=t&&t.getSource();const n=function(t){const e=tt.call(this);const i=this.getConditions();o.checkConditionsEmpty(i,e);o.updateConditionsValues(i,e);lt.call(this,i,false,false);if(t){i.forEach(function(t){if(!t.isEmpty){delete t.isInitial}})}this.setProperty("conditions",i,true)}.bind(this);if(e){e.then(function(t){this._bPendingChange=false;n({mParameters:{value:t}});if(this._bPendingValidateCondition){_t.call(this,i);delete this._bPendingValidateCondition}}.bind(this)).catch(function(t){this._bPendingChange=false;if(this._bPendingValidateCondition){_t.call(this,i);delete this._bPendingValidateCondition}}.bind(this));this._bPendingChange=true;return}else{n()}},onSelectChange:function(t){const e=t.getSource();const i=t.getParameter("promise");i.then(function(t){const i=e._sOldKey;const s=o.getOperator(t);const a=i&&o.getOperator(i);const l=e.getBindingContext("$this");let r=l.getObject();const d=l.getPath();const c=parseInt(d.split("/")[2]);const u=this.getConditions();if(c>=0){r=u[c]}if(s&&a){let t=false;if(!n(s.valueTypes[0],a.valueTypes[0])&&s.valueTypes[0]!==h.Static){if(c>=0){r.values.forEach(function(e,i){if(e!==null){if(s.valueTypes[i]===h.Self&&a.valueTypes[i]===h.SelfNoParse||s.valueTypes[i]===h.SelfNoParse&&a.valueTypes[i]===h.Self){const e=Q.call(this,s.name,i);const n=Q.call(this,a.name,i);const o=n.formatValue(r.values[i],"string");const l=e.parseValue(o,"string");if(l!==r.values[i]){r.values[i]=e.parseValue(o,"string");t=true}}else{r.values[i]=null;t=true}}}.bind(this))}}if(c>=0&&s.valueDefaults){r.values.forEach(function(e,i){if(r.isInitial&&e!==s.valueDefaults[i]||e===null){r.values[i]=s.valueDefaults[i];r.isInitial=true;t=true}})}if(!s.valueTypes[1]&&a.valueTypes[1]){if(c>=0){if(r.values.length>1&&r.values[1]){r.values=r.values.slice(0,1);t=true}}}if(r.invalid){delete r.invalid;t=true}if(t){o.checkConditionsEmpty(r,tt.call(this));this.setProperty("conditions",u,true);Tt.call(this,false)}}delete e._sOldKey}.bind(this)).catch(function(t){const i=e.getBindingContext("$this");let n=i.getObject();const s=i.getPath();const o=parseInt(s.split("/")[2]);const a=this.getConditions();if(o>=0){n=a[o]}n.invalid=true;this.setProperty("conditions",a,true);e._sOldKey=e.getValue();Tt.call(this,true)}.bind(this))},onPaste:function(t){const e=t.originalEvent.clipboardData.getData("text/plain");const n=l(e,true);if(n.length>1){const n=t.srcControl;const s=n.getBindingContext("$condition").getPath();const l=parseInt(s.split("/")[2]);const r=this.getConditions();const c=i({},this.getConfig());c.display=d.Value;c.getConditions=function(){return r};c.defaultOperatorName=r[l].operator;c.valueType=c.dataType;delete c.dataType;const u=new a(c);try{r.splice(l,1);const t=u._parseValueToIndex(e,"string",l);u.validateValue(r);o.checkConditionsEmpty(t);this.setProperty("conditions",t,true);this.fireConditionProcessed()}catch(t){const i=new O(A.getText("field.PASTE_ERROR"));const s={element:n,property:"value",type:u,newValue:e,oldValue:"",exception:i,message:i.message};n.fireParseError(s,false,true)}u.destroy();t.stopImmediatePropagation(true);t.preventDefault()}},cleanUp:function(){const t=this.byId("conditions");const e=t.getContent();for(let t=0;t<e.length;t++){const i=e[t];if(i instanceof p&&i.hasOwnProperty("_iValueIndex")){if(i.isInvalidInput()){i.setValue()}}}this.setProperty("inputOK",true,true);if(this._iStartIndex>0||this._iShownAdditionalConditions>0){this._iStartIndex=0;this._iShownAdditionalConditions=0;ut.call(this)}},getInitialFocusedControl:function(){const t=this.getAggregation("_content").getContent()[1];const e=t.getContent()[0];return e},_getValueHelp:function(){return this.getValueHelp()||this.getFieldHelp&&this.getFieldHelp()}});function W(t){if(t.name==="value"){z.call(this,t.object,t.current,t.old)}if(t.name==="config"){const e=this.getConditions();const i=t.current&&t.current.operators;const s=t.old&&t.old.operators;let o=false;if(!n(i,s)){o=true;it.call(this)}const a=t.current&&t.current.dataType;const l=t.old&&t.old.valueType;const r=a&&a.getMetadata().getName();const d=l&&l.getMetadata().getName();const c=a&&a.getFormatOptions();const u=l&&l.getFormatOptions();const h=a&&a.getConstraints();const p=l&&l.getConstraints();if(r!==d||!n(c,u)||!n(h,p)){if(!o){it.call(this)}if(this._sConditionsTimer){this._bUpdateType=true}else if(e.length>0){this._bUpdateType=true;ut.call(this);this._bUpdateType=false;lt.call(this,e,true,true)}}}if(t.name==="conditions"&&!this._bConditionUpdateRunning){if(this._sConditionsTimer){clearTimeout(this._sConditionsTimer);this._sConditionsTimer=null}this._sConditionsTimer=setTimeout(function(){this._sConditionsTimer=null;this._bConditionUpdateRunning=true;this.updateDefineConditions();ut.call(this);this._bUpdateType=false;this._bConditionUpdateRunning=false}.bind(this),0)}}function q(t){return true}function z(t,e,i){t._sOldKey=i;let n=0;if(e&&i){const s=o.getOperator(e);const a=o.getOperator(i);const l=t.getParent();let r;let d;n=l.indexOfContent(t);r=l.getContent()[n+2];if(r&&r.hasOwnProperty("_iValueIndex")&&r._iValueIndex===0){if(r instanceof p&&!r.isInvalidInput()){r.setValueState(H.None);r.setValueStateText()}d=l.getContent()[n+3];if(d&&d.hasOwnProperty("_iValueIndex")&&d._iValueIndex===1){if(d instanceof p&&!d.isInvalidInput()){d.setValueState(H.None);d.setValueStateText()}}else{d=undefined}}else{r=undefined}if(q(e)){const t=this._getValueHelp();r&&r.setValueHelp&&r.setValueHelp(t);d&&d.setValueHelp&&d.setValueHelp(t)}else{r&&r.setValueHelp&&r.setValueHelp();d&&d.setValueHelp&&d.setValueHelp()}if(s.createControl||a.createControl){if(r){r.destroy()}if(d){d.destroy()}}else{if(r&&s.valueTypes[0]!==a.valueTypes[0]){r.unbindProperty("value")}if(d&&s.valueTypes[1]!==a.valueTypes[1]&&a.valueTypes[1]){d.unbindProperty("value")}}}if(!e){let e=t.getBindingContext("$this").getObject();if(e){const t=this.getConditions();n=o.indexOfCondition(e,t);if(n>=0){e=t[n];e.operator=i;this.setProperty("conditions",t,true)}}}const s=this.oOperatorModel.getData();let a;for(let t=0;t<s.length;t++){const i=s[t];if(i.key===e){a=i.text;break}}t.setAdditionalValue(a);this.onChange()}function J(t,e,i,n){const s=o.getOperator(t.operator);if(!s||!s.valueTypes[e]){return null}const a=Q.call(this,s.name,e);const l=this._oManagedObjectModel.getContext(n.getPath()+"values/"+e+"/");let r;if(s.createControl){r=s.createControl(a,"$this>",e,i)}if(!r){r=new p(i,{delegate:at.call(this),value:{path:"$this>",type:a,mode:"TwoWay",targetType:"raw"},editMode:{parts:[{path:"$condition>operator"},{path:"$condition>invalid"}],formatter:ft},multipleLines:false,width:"100%",valueHelp:q(t.operator)?this._getValueHelp():null})}if(r.getMetadata().hasProperty("placeholder")){if(e===0){r.bindProperty("placeholder",{path:"$condition>operator",formatter:It})}else{r.bindProperty("placeholder",{path:"$condition>operator",formatter:mt})}}r._iValueIndex=e;if(r.attachChange){r.attachChange(this.onChange.bind(this))}r.addDelegate(this._oContentEventDelegate,true,this);r.setLayoutData(new S({span:{parts:[{path:"$condition>"},{path:"$this>/config"}],formatter:vt.bind(this)}}));r.setBindingContext(l,"$this");r.setBindingContext(n,"$condition");r.setFieldGroupIds([n.getPath()]);return r}function Q(t,e){let i=nt.call(this);const n=o.getOperator(t);if(n.valueTypes[e]&&[h.Self,h.Static].indexOf(n.valueTypes[e])===-1){i=n._createLocalType(n.valueTypes[e],i)}let s=false;if(n.valueTypes[e]===h.Static){s=true;i=st.call(this)}const a=s?c.String:ot.call(this,i);let l;const r=i.getFormatOptions();switch(a){case c.Numeric:if(r&&r.hasOwnProperty("emptyString")&&r.emptyString===null){l=i}else{l=Y(i,{emptyString:null})}break;case c.Date:case c.Time:case c.DateTime:l=i;break;default:if(i.getConstraints()&&i.getConstraints().hasOwnProperty("nullable")&&i.getConstraints().nullable===false){l=Y(i);if(i._bCreatedByOperator){l=n._createLocalType(n.valueTypes[e],i)}}else{l=i}break}return l}function Y(t,e,n){const s=sap.ui.require(t.getMetadata().getName().replace(/\./g,"/"));const o=i(t.getFormatOptions(),e||{});const a=i(t.getConstraints(),n||{});if(a.hasOwnProperty("nullable")&&a.nullable===false){a.nullable=true}return new s(o,a)}function Z(){const t=tt.call(this);let e;const i=this.getConfig().defaultOperatorName;if(i){e=o.getOperator(i)}else{const t=nt.call(this);const i=ot.call(this,t);e=o.getDefaultOperator(i)}if(e&&t.indexOf(e.name)<0){for(let i=0;i<t.length;i++){e=o.getOperator(t[i]);if(!e||e.exclude||!e.hasRequiredValues()){e=undefined}else{break}}}if(!e){e=o.getOperator(t[0])}return e}function tt(){const t=this.getConfig();let e=t&&t.operators;if(!e||e.length===0){e=o.getOperatorsForType(c.String)}return e}function et(){let t;const e=tt.call(this);for(let i=0;i<e.length;i++){const n=e[i];const s=o.getOperator(n);if(!t){t=s.group.id}else if(t!==s.group.id){return true}}return false}function it(){if(!this.oOperatorModel){return}const t=nt.call(this);const e=tt.call(this);const i=[];const n=et.call(this);const s=this._sOperatorHelpId+"-pop-fl";const a=sap.ui.getCore().byId(s);let l;if(n){l=new y({key:"{om>key}",text:"{om>text}",additionalText:"{om>additionalText}",groupKey:"{om>groupId}",groupText:"{om>groupText}"})}else{l=new y({key:"{om>key}",text:"{om>text}",additionalText:"{om>additionalText}"})}a.bindAggregation("items",{path:"om>/",templateShareable:false,template:l});a.setGroupable(n);for(let s=0;s<e.length;s++){const a=e[s];const l=o.getOperator(a);if(!l||l.showInSuggest!==undefined&&l.showInSuggest==false){continue}const r=l.getLongText(ot.call(this,t));let d=l.additionalInfo;if(d===undefined){if(d!==""&&l.formatRange){d=l.formatRange(l._getRange(undefined,t),t)}else if(!n){d=l.group.text}}i.push({key:l.name,text:r,additionalText:d,groupId:l.group.id,groupText:l.group.text})}this.oOperatorModel.setData(i)}function nt(){const t=this.getConfig();let e=t&&t.dataType;if(!e){e=st.call(this)}return e}function st(){if(!this._oDefaultType){this._oDefaultType=new b}return this._oDefaultType}function ot(t){const e=t.getMetadata().getName();const i=t.getFormatOptions();const n=t.getConstraints();const s=this.getConfig().delegate;const o=this.getConfig().control;let a=s?s.getTypeMap(o).getBaseType(e,i,n):c.String;if(a===c.Unit){a=c.Numeric}return a}function at(){const t=this.getConfig();const e=t.delegateName||"sap/ui/mdc/field/FieldBaseDelegate";const i=t.payload;return{name:e,payload:i}}function lt(t,e,i){const n=nt.call(this);const s=[];let a=0;for(a=0;a<t.length;a++){const e=t[a];const l=o.getOperator(e.operator);if(l&&l.valueTypes[0]===h.Static&&(e.values.length===0||i)){if(l.getStaticText){const t=l.getStaticText(n,ot.call(this,n));if(e.values.length>0){e.values[0]=t}else{e.values.push(t)}s.push(a)}}}if(e&&s.length>0){this.setProperty("conditions",t,true)}}function rt(){const t=new T(this.getId()+"--ivtOperator",{text:"{$i18n>valuehelp.DEFINECONDITIONS_OPERATORLABEL}"});const e=new $(this.getId()+"-title",{text:{path:"$this>/label"}});const i=new D(this.getId()+"--prev",{icon:L.getIconURI("navigation-left-arrow"),tooltip:F.getText("PAGINGBUTTON_PREVIOUS"),visible:{path:"$this>/_pagination"},layoutData:new N({priority:X.NeverOverflow}),press:wt.bind(this)});const n=new D(this.getId()+"--next",{icon:L.getIconURI("navigation-right-arrow"),tooltip:F.getText("PAGINGBUTTON_NEXT"),visible:{path:"$this>/_pagination"},layoutData:new N({priority:X.NeverOverflow}),press:St.bind(this)});const s=new D(this.getId()+"--removeAll",{text:F.getText("CONDITIONPANEL_REMOVE_ALL"),visible:{path:"$this>/_pagination"},layoutData:new N({priority:X.Low}),press:Dt.bind(this)});const o=new D(this.getId()+"--insert",{icon:L.getIconURI("add"),visible:{path:"$this>/_pagination"},layoutData:new N({priority:X.Low}),press:Pt.bind(this)});const a=new E(this.getId()+"--pageCount",{text:Vt.call(this),wrapping:false,textAlign:j.Center,visible:{path:"$this>/_pagination"},layoutData:new N({priority:X.NeverOverflow})});const l=new V(this.getId()+"--toolbar",{width:"100%",design:G.Transparent,content:[e,new M,i,a,n,s,o]});const r=new P(this.getId()+"--panel",{headerToolbar:l,expanded:true,height:"100%",backgroundDesign:k.Transparent}).addStyleClass("sapMdcDefineconditionPanel");r.addDependent(new g(this._sOperatorHelpId,{typeahead:new f(this._sOperatorHelpId+"-pop",{content:[new C(this._sOperatorHelpId+"-pop-fl",{filterList:false,useFirstMatch:true})]})}));const d=new x(this.getId()+"--conditions",{width:"100%",hSpacing:0,vSpacing:0,containerQuery:true}).addStyleClass("sapUiMdcDefineConditionGrid");gt.call(this,undefined,d,0,null,0);r.addContent(t);r.addContent(d);this._oInvisibleAddOperatorButtonText=new T({text:A.getText("valuehelp.DEFINECONDITIONS_ADDCONDITION_DESCRIPTION")});r.addContent(this._oInvisibleAddOperatorButtonText);const c=new D(this.getId()+"--addBtn",{press:this.addCondition.bind(this),type:R.Default,text:"{$i18n>valuehelp.DEFINECONDITIONS_ADDCONDITION}",layoutData:new S({span:"XL2 L3 M3 S3",indent:"XL9 L8 M8 S7",linebreak:true,visibleS:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:dt.bind(this)},visibleM:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:dt.bind(this)},visibleL:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:dt.bind(this)},visibleXL:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:dt.bind(this)}}),ariaDescribedBy:this._oInvisibleAddOperatorButtonText});d.addContent(c);d.attachValidateFieldGroup(Ot,this);this.setAggregation("_content",r)}function dt(t,e){const i=e.hasOwnProperty("maxConditions")?e.maxConditions:-1;return i===-1||t.length<i}function ct(t,e){const i=e.hasOwnProperty("maxConditions")?e.maxConditions:-1;return i!==1}function ut(){const t=this.getConditions();const e=this.byId("conditions");const i=this.byId("prev");const n=this.byId("next");const s=this.byId("pageCount");let a;let l=-1;let r=0;let d=-1;const c=this._iShownConditions+this._iShownAdditionalConditions;for(let i=0;i<t.length&&l<c;i++){const n=t[i];const s=o.getOperator(n.operator);if(n.validated!==u.Validated||s.exclude){d++;if(d>=this._iStartIndex){l++;if(l<c){const t=this._oManagedObjectModel.getContext("/conditions/"+i+"/");if(!this.oOperatorModel){this.oOperatorModel=new I;this.setModel(this.oOperatorModel,"om");it.call(this)}a=e.getContent();if(a[r]&&a[r].isA("sap.ui.mdc.Field")){r=bt.call(this,n,e,r,t,l)}else{r=gt.call(this,n,e,r,t,l)}}}}}a=e.getContent();while(a[r]&&a[r]!==this.byId("addBtn")){a[r].destroy();r++}if(this._bFocusLastCondition){r=pt.call(this,"-operator");setTimeout(function(){a[r].focus()},0);this._bFocusLastCondition=false}if(this._bFocusLastRemoveBtn){r=ht.call(this,["-removeBtnLarge","-removeBtnSmall"]);a[r].focus();this._bFocusLastRemoveBtn=false}s.setText(Vt.call(this));i.setEnabled(this._iStartIndex>0);n.setEnabled(l>=c);this.setProperty("_pagination",d>=c)}function ht(t){const e=this.byId("conditions");const i=e.getContent();let n=i.length-1;if(!Array.isArray(t)){t=[t]}let s=0;let o=t[s];while(n>=0&&o!==undefined){const e=i[n];if(e.getId().endsWith(o)){const i=jQuery(e.getDomRef());if(i.is(":visible")){return n}else{s++;o=t[s]}}n--}return 0}function pt(t){const e=this.byId("conditions");const i=e.getContent();let n=i.length-1;const s=t;while(n>=0){const t=i[n];if(t.getId().endsWith(s)){return n}n--}return 0}function gt(t,e,i,n,s){const o=this.getId()+"--"+s;if(!this._oOperatorFieldType){this._oOperatorFieldType=new b({},{minLength:1})}const a=new p(o+"-operator",{value:{path:"$this>operator",type:this._oOperatorFieldType},width:"100%",display:d.Description,editMode:r.Editable,multipleLines:false,valueHelp:this._sOperatorHelpId,change:this.onSelectChange.bind(this),ariaLabelledBy:this.getId()+"--ivtOperator"}).setLayoutData(new S({span:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:yt.bind(this)},linebreak:true})).setBindingContext(n,"$this");if(n){a.setFieldGroupIds([n.getPath()])}this._oObserver.observe(a,{properties:["value"]});e.insertContent(a,i);i++;const l=new D(o+"--removeBtnSmall",{press:this.removeCondition.bind(this),type:R.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.DEFINECONDITIONS_REMOVECONDITION}"}).setLayoutData(new S({span:"XL1 L1 M1 S2",indent:{path:"$this>operator",formatter:Ct},visibleS:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:ct.bind(this)},visibleM:false,visibleL:false,visibleXL:false})).setBindingContext(n,"$this");if(n){l.setFieldGroupIds([n.getPath()])}e.insertContent(l,i);i++;if(t){for(let s=0;s<t.values.length;s++){const a=J.call(this,t,s,o+"-values"+s,n);if(a){e.insertContent(a,i);i++}}}const c=new D(o+"--removeBtnLarge",{press:this.removeCondition.bind(this),type:R.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.DEFINECONDITIONS_REMOVECONDITION}"}).setLayoutData(new S({span:"XL1 L1 M1 S1",indent:{path:"$this>operator",formatter:Ct},visibleS:false,visibleM:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:ct.bind(this)},visibleL:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:ct.bind(this)},visibleXL:{parts:[{path:"$this>/conditions"},{path:"$this>/config"}],formatter:ct.bind(this)}})).setBindingContext(n,"$this");e.insertContent(c,i);i++;return i}function ft(t,e){if(!t){return this.getEditMode()}else if(e){return r.ReadOnly}const i=o.getOperator(t);let n=false;if(i&&i.valueTypes[0]===h.Static){n=true}return n?r.Display:r.Editable}function Ct(t){const e=t&&o.getOperator(t);if(!e||!e.valueTypes[0]||e.valueTypes[0]===h.Static&&!e.getStaticText){return"XL8 L8 M8 S0"}else{return""}}function yt(t,e){const i=e.hasOwnProperty("maxConditions")?e.maxConditions:-1;let n="XL3 L3 M3 ";if(i===1){n+="S12"}else{n+="S10"}return n}function vt(t,e){const i=e.hasOwnProperty("maxConditions")?e.maxConditions:-1;const n=t&&o.getOperator(t.operator);let s="";if(n&&n.valueTypes[1]){s="XL4 L4 M4 "}else{s="XL8 L8 M8 "}if(i===1){s+="S12"}else{s+="S10"}return s}function It(t){const e=t&&o.getOperator(t);if(e&&e.aLabels){return e.aLabels[0]}else if(e&&e.valueTypes[1]){return A.getText("valuehelp.DEFINECONDITIONS_FROM")}else{return A.getText("valuehelp.DEFINECONDITIONS_VALUE")}}function mt(t){const e=t&&o.getOperator(t);if(e&&e.aLabels){return e.aLabels[1]}else if(e&&e.valueTypes[1]){return A.getText("valuehelp.DEFINECONDITIONS_TO")}}function bt(t,e,i,n,s){const o=this.getId()+"--"+s;let a=e.getContent();let l;const r=a[i];r.setBindingContext(n,"$this");if(n){r.setFieldGroupIds([n.getPath()])}if(r.getValueState()===H.Error&&!t.invalid){r.setValue(r.getValue())}i++;const d=a[i];d.setBindingContext(n,"$this");if(n){d.setFieldGroupIds([n.getPath()])}i++;let c;let u=a[i];let h;if(u.hasOwnProperty("_iValueIndex")&&u._iValueIndex===0){if(t.values.length>0){c=this._oManagedObjectModel.getContext(n.getPath()+"values/0/");u.setBindingContext(c,"$this");u.setBindingContext(n,"$condition");if(u.getMetadata().hasProperty("value")&&(this._bUpdateType||!u.getBindingInfo("value"))){l=Q.call(this,t.operator,0);u.bindProperty("value",{path:"$this>",type:l})}i++;h=a[i];if(h.hasOwnProperty("_iValueIndex")&&h._iValueIndex===1){if(t.values.length>1){c=this._oManagedObjectModel.getContext(n.getPath()+"values/1/");h.setBindingContext(c,"$this");if(h.getMetadata().hasProperty("value")&&(this._bUpdateType||!h.getBindingInfo("value"))){l=Q.call(this,t.operator,1);h.bindProperty("value",{path:"$this>",type:l})}i++}else{h.destroy()}}else if(t.values.length>1){h=J.call(this,t,1,o+"-values1",n);if(h){e.insertContent(h,i);i++}}}else{u.destroy();u=undefined;h=a[i+1];if(h&&h.hasOwnProperty("_iValueIndex")&&h._iValueIndex===1){h.destroy()}}}else if(t.values.length>0){for(let s=0;s<t.values.length;s++){const a=J.call(this,t,s,o+"-values"+s,n);if(a){e.insertContent(a,i);i++}}}a=e.getContent();const p=a[i];p.setBindingContext(n,"$this");i++;return i}function Ot(t){if(this._bPendingChange){this._bPendingValidateCondition=true;return}let e=t.getSource();while(!(e.getParent()instanceof x)){e=e.getParent()}_t.call(this,e)}function _t(t){const e=t.getParent();let i=e.indexOfContent(t);let n;if(t.getId().endsWith("-operator")){n=t.getBindingContext("$this");i=i+2;t=e.getContent()[i]}else if(t.getId().endsWith("-removeBtnSmall")){n=t.getBindingContext("$this");i=i+1;t=e.getContent()[i]}else{n=t.getBindingContext("$condition")}let s;const a=n.getObject();const l=o.getOperator(a.operator);let r=!!a.invalid;if(!r&&l.valueTypes.length>0&&l.valueTypes[0]!==h.Static){if(l.valueTypes.length>1&&l.valueTypes[1]){if(t.hasOwnProperty("_iValueIndex")&&t._iValueIndex===0){s=e.getContent()[i+1]}else if(t.hasOwnProperty("_iValueIndex")&&t._iValueIndex===1){s=e.getContent()[i-1]}}if(t.getMetadata().getAllProperties().valueState&&!t.isInvalidInput()&&(!s||!s.isInvalidInput())){const e=t.getBinding("value").getType();try{l.validate(a.values,e);t.setValueState(H.None);t.setValueStateText();if(s&&s.getMetadata().getAllProperties().valueState){s.setValueState(H.None);s.setValueStateText()}}catch(e){r=true;t.setValueState(H.Error);t.setValueStateText(e.message);if(s&&s.getMetadata().getAllProperties().valueState){s.setValueState(H.Error);s.setValueStateText(e.message)}}}}Tt.call(this,r);this.fireConditionProcessed()}function Tt(t){let e=0;if(t!==true){const i=this.getConditions();for(e=0;e<i.length;e++){if(i[e].invalid){t=true;break}}}if(t!==true){const i=this.byId("conditions");const n=i.getContent();t=false;for(e=0;e<n.length;e++){const i=n[e];if(i.hasOwnProperty("_iValueIndex")&&i.getValueState&&i.getValueState()===H.Error){t=true;break}}}this.setProperty("inputOK",!t,true)}function xt(){return this.getConditions().filter(function(t){const e=o.getOperator(t.operator);return t.validated!==u.Validated||e.exclude})}function St(t){this._iStartIndex=this._iStartIndex+this._iShownConditions;this._iShownAdditionalConditions=0;ut.call(this)}function wt(t){this._iStartIndex=this._iStartIndex-this._iShownConditions;if(this._iStartIndex<0){this._iStartIndex=0}this._iShownAdditionalConditions=0;ut.call(this)}function Dt(t){const e=this.getConditions().filter(function(t){const e=o.getOperator(t.operator);return t.validated===u.Validated&&!e.exclude});this.addDummyCondition(e.length+1);this._iStartIndex=0;this._iShownAdditionalConditions=0;this.setProperty("conditions",e,true);this.oInvisibleMessage.announce(A.getText("valuehelp.DEFINECONDITIONS_REMOVECONDITION_ANNOUNCE"),U.Assertive);this.fireConditionProcessed()}function Pt(t){const e=this.getConditions();const i=this.getFormatOptions();const n=i.maxConditions;const s=this.byId("conditions");const o=s.getContent();let a=0;let l=-1;for(let t=0;t<o.length;t++){const e=o[t];if(e instanceof p&&e.getValueHelp()===this._sOperatorHelpId){a++;if(a===1){const t=e.getBindingContext("$this");const i=t.getPath();const n=i.match(/^.*\/(\d+)\/$/);if(n){l=parseInt(n[1])}}}}if(n===-1||e.length<n){this.addDummyCondition(l);if(a>=this._iShownConditions){this._iShownAdditionalConditions++}}this.oInvisibleMessage.announce(A.getText("valuehelp.DEFINECONDITIONS_ADDCONDITION_ANNOUNCE"),U.Assertive)}function Vt(){const t=xt.call(this);const e=Math.ceil((t.length-this._iShownAdditionalConditions)/this._iShownConditions);const i=Math.floor(this._iStartIndex/this._iShownConditions)+1;const n=A.getText("valuehelp.PAGE_COUNT",[i,e]);return n}return K});
//# sourceMappingURL=DefineConditionPanel.js.map