/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BatchResponseCollector","./odata4analytics","sap/base/Log","sap/base/util/deepExtend","sap/base/util/each","sap/base/util/extend","sap/base/util/isEmptyObject","sap/base/util/uid","sap/ui/model/ChangeReason","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/FilterProcessor","sap/ui/model/FilterType","sap/ui/model/Sorter","sap/ui/model/TreeAutoExpandMode","sap/ui/model/TreeBinding","sap/ui/model/odata/CountMode","sap/ui/model/odata/ODataUtils"],function(e,t,i,r,s,n,a,o,u,l,d,h,p,f,g,y,c,v){"use strict";var m="sap.ui.model.analytics.AnalyticalBinding",_=0,I=i.getLogger(m);function R(e){var i,r,s,n,a,o,u,l,d,h=new t.QueryResultRequest(e.oAnalyticalQueryResult),p=e.mParameters.select.split(","),f=q(p,e.sPath);h.setAggregationLevel(e.aMaxAggregationLevel);h.setMeasures(e.aMeasureName);Object.keys(e.oDimensionDetailsSet).forEach(function(t){n=e.oDimensionDetailsSet[t];h.includeDimensionKeyTextAttributes(t,true,n.textPropertyName!==undefined,n.aAttributeName)});Object.keys(e.oMeasureDetailsSet).forEach(function(t){u=e.oMeasureDetailsSet[t];h.includeMeasureRawFormattedValueUnit(t,u.rawValuePropertyName!==undefined,u.formattedValuePropertyName!==undefined,u.unitPropertyName!==undefined)});s=h.getURIQueryOptionValue("$select");if(s){r=s.split(",");for(a=0,l=r.length;a<l;a++){d=r[a];o=p.indexOf(d);if(o<0){i=e.mAnalyticalInfoByProperty[d];if(!i||!i.visible&&!i.inResult){continue}I.warning("Ignored the 'select' binding parameter, because"+" it does not contain the property '"+d+"'",e.sPath);f=true}else{p.splice(o,1)}}}const g=[];for(a=0;a<p.length;a+=1){d=p[a];n=e.oAnalyticalQueryResult.findDimensionByPropertyName(d);if(n){const t=e.oDimensionDetailsSet[n.getName()];if(t===undefined){M(e.sPath,d,n);f=true}else{b._updateDimensionDetailsTextProperty(n,d,t);continue}}u=e.oAnalyticalQueryResult.findMeasureByPropertyName(d);if(u&&e.oMeasureDetailsSet[u.getName()]===undefined){M(e.sPath,d,u);f=true}g.push(d)}return f?[]:g}function M(e,i,r){var s=r instanceof t.Dimension?"dimension":"measure";if(r.getName()===i){I.warning("Ignored the 'select' binding parameter, because it contains"+" the "+s+" property '"+i+"' which is not contained in the analytical info (see updateAnalyticalInfo)",e)}else{I.warning("Ignored the 'select' binding parameter, because the property '"+i+"' is associated with the "+s+" property '"+r.getName()+"' which is not contained in the analytical"+" info (see updateAnalyticalInfo)",e)}}function q(e,t){var i,r=false,s,n;for(s=0,n=e.length;s<n;s++){e[s]=e[s].trim()}for(s=e.length-1;s>=0;s--){i=e[s];if(e.indexOf(i)!==s){I.warning("Ignored the 'select' binding parameter, because it"+" contains the property '"+i+"' multiple times",t);e.splice(s,1);r=true}}return r}var b=y.extend("sap.ui.model.analytics.AnalyticalBinding",{constructor:function(e,t,i,r,s,n){y.call(this,e,t,i,s,n);this.aAdditionalSelects=[];this.sEntitySetName=n.entitySet?n.entitySet:undefined;this.bArtificalRootContext=false;this.aApplicationFilter=this._convertDeprecatedFilterObjects(s);this.aControlFilter=undefined;this.aSorter=r?r:[];if(!Array.isArray(this.aSorter)){this.aSorter=[this.aSorter]}this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.oPendingRequests={};this.oPendingRequestHandle=[];this.oGroupedRequests={};this.bUseBatchRequests=n.useBatchRequests===true;this.bProvideTotalSize=n.provideTotalResultSize!==false;this.bProvideGrandTotals=n.provideGrandTotals!==false;this.bReloadSingleUnitMeasures=n.reloadSingleUnitMeasures!==false;this.bUseAcceleratedAutoExpand=n.useAcceleratedAutoExpand!==false;this.bNoPaging=n.noPaging===true;_+=1;this._iId=_;this.iTotalSize=-1;this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mKeyIndex={};this.mFinalLength=this.mServiceFinalLength;this.mLength={};this.mMultiUnitKey={};this.aMultiUnitLoadFactor={};this.bNeedsUpdate=false;this.bApplySortersToGroups=true;this.sLastAutoExpandMode=undefined;this.mEntityKey={};this.sCustomParams=this.oModel.createCustomParams({custom:this.mParameters.custom});this.oAnalyticalQueryResult=null;this.aAnalyticalInfo=[];this.mAnalyticalInfoByProperty={};this.aBatchRequestQueue=[];if(n.countMode==c.None){I.fatal("requested count mode is ignored; OData requests will include"+" $inlinecount options")}else if(n.countMode==c.Request||n.countMode==c.Both){I.warning("default count mode is ignored; OData requests will include"+" $inlinecount options")}else if(this.oModel.sDefaultCountMode==c.Request){I.warning("default count mode is ignored; OData requests will include"+" $inlinecount options")}this.iModelVersion=b._getModelVersion(this.oModel);if(this.iModelVersion===null){I.error("The AnalyticalBinding does not support the given model");return}this.aAllDimensionSortedByName=null;this.aInitialAnalyticalInfo=n.analyticalInfo;this.bInitial=true}});function x(e,t){return function(){if(!e.__supportUID){e.__supportUID=o()}return{type:m,analyticalError:t,analyticalBindingId:e.__supportUID}}}b.prototype.setContext=function(e){var t;if(this.oContext!==e){this.oContext=e;if(!this.isRelative()){return}this.oDataState=null;this.bApplySortersToGroups=true;this.iTotalSize=-1;this._abortAllPendingRequests();t=this.getResolvedPath();if(t){this.resetData();this._initialize();this._fireChange({reason:u.Context})}else{this.bInitial=true}}};b.prototype.initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.isInitial()){var e=this.isRelative();if(!e||e&&this.oContext){this._initialize()}this._fireRefresh({reason:u.Refresh})}return this};b.prototype._initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()){this.bInitial=false;this.oAnalyticalQueryResult=this.oModel.getAnalyticalExtensions().findQueryResultByName(this._getEntitySet());if(!this.oAnalyticalQueryResult){throw"Error in AnalyticalBinding - The QueryResult '"+this._getEntitySet()+"' could not be retrieved. Please check your service definition."}this.updateAnalyticalInfo(this.aInitialAnalyticalInfo);this.aAllDimensionSortedByName=this.oAnalyticalQueryResult.getAllDimensionNames().concat([]).sort();this._fireRefresh({reason:u.Refresh})}};b.prototype.getRootContexts=function(e,t,i,r){if(typeof e!=="object"){e={length:t,numberOfExpandedLevels:i,startIndex:e,threshold:r}}if(this.isInitial()){return[]}var s=e&&e.numberOfExpandedLevels?e.numberOfExpandedLevels+1:1;var n=null;var a=this._getRequestId(b._requestType.groupMembersQuery,{groupId:null});if(this.bArtificalRootContext&&!this._cleanupGroupingForCompletedRequest(a)){return n}n=this._getContextsForParentContext(null);if(n.length==1){return n}if(s<=1){if(s==1){this._considerRequestGrouping([a,this._getRequestId(b._requestType.groupMembersQuery,{groupId:"/"})]);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:e.startIndex,length:e.length,threshold:e.threshold,level:0,numberOfExpandedLevels:0})}}else{var o=this._prepareGroupMembersAutoExpansionRequestIds("/",e.numberOfExpandedLevels);o.push(a);this._considerRequestGrouping(o);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:e.startIndex,length:e.length,threshold:e.threshold,level:0,numberOfExpandedLevels:e.numberOfExpandedLevels})}if(n.length>1){I.fatal("assertion failed: grand total represented by a single entry")}return n};b.prototype.getNodeContexts=function(e,t){if(this.isInitial()){return[]}var i,r,s,n,a,o;if(typeof t=="object"){i=t.startIndex;r=t.length;s=t.threshold;n=t.level;a=t.numberOfExpandedLevels;o=t.supressRequest}else{i=arguments[1];r=arguments[2];s=arguments[3];n=arguments[4];a=arguments[5];o=arguments[6]}var u=this._getContextsForParentContext(e,i,r,s,n,a,o);return u};b.prototype.ContextsAvailabilityStatus={ALL:2,SOME:1,NONE:0};b.prototype.hasAvailableNodeContexts=function(e,t){var i=this._getGroupIdFromContext(e,t);if(this._getKeys(i)!=undefined){if(this.mFinalLength[i]==true){return b.prototype.ContextsAvailabilityStatus.ALL}else{return b.prototype.ContextsAvailabilityStatus.SOME}}else{return b.prototype.ContextsAvailabilityStatus.NONE}};b.prototype.getGroupSize=function(e,t){if(e===undefined){return 0}var i=this._getGroupIdFromContext(e,t);return this.mFinalLength[i]?this.mLength[i]:-1};b.prototype.getCount=function(){return this.iTotalSize>=0?this.iTotalSize:undefined};b.prototype.getTotalSize=function(){if(!this.bProvideTotalSize){I.fatal("total size of result explicitly turned off, but getter invoked")}return this.iTotalSize};b.prototype.hasChildren=function(e,t){t=t||{level:1};if(e===undefined){return false}if(e==null){return true}var i=t.level;if(i==0){return true}if(this.aAggregationLevel.length<i){return false}return this.aMaxAggregationLevel.indexOf(this.aAggregationLevel[i-1])<this.aMaxAggregationLevel.length-1};b.prototype.hasMeasures=function(){var e=false;for(var t in this.oMeasureDetailsSet){if(this.oMeasureDetailsSet.hasOwnProperty(t)){e=true;break}}return e};b.prototype.getDimensionDetails=function(){return this.oDimensionDetailsSet};b.prototype.getMeasureDetails=function(){return this.oMeasureDetailsSet};b.prototype.providesGrandTotal=function(){return this.bProvideGrandTotals};b.prototype.getProperty=function(e){if(this.isInitial()){return{}}return this.oAnalyticalQueryResult.getEntityType().findPropertyByName(e)};b.prototype.getFilterablePropertyNames=function(){if(this.isInitial()){return[]}return this.oAnalyticalQueryResult.getEntityType().getFilterablePropertyNames()};b.prototype.getSortablePropertyNames=function(){if(this.isInitial()){return[]}return this.oAnalyticalQueryResult.getEntityType().getSortablePropertyNames()};b.prototype.getPropertyLabel=function(e){if(this.isInitial()){return""}return this.oAnalyticalQueryResult.getEntityType().getLabelOfProperty(e)};b.prototype.getPropertyHeading=function(e){if(this.isInitial()){return""}return this.oAnalyticalQueryResult.getEntityType().getHeadingOfProperty(e)};b.prototype.getPropertyQuickInfo=function(e){if(this.isInitial()){return""}return this.oAnalyticalQueryResult.getEntityType().getQuickInfoOfProperty(e)};b.prototype.isMeasure=function(e){return this.aMeasureName&&this.aMeasureName.indexOf(e)!==-1};b.prototype.filter=function(e,t){if(!e){e=[]}if(e instanceof l){e=[e]}e=this._convertDeprecatedFilterObjects(e);if(t==p.Application){this.aApplicationFilter=e}else{this.aControlFilter=e}this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this.bApplySortersToGroups=true;this._fireRefresh({reason:u.Filter});return this};b.prototype.getFilterInfo=function(e){var t=h.combineFilters(this.aControlFilter,this.aApplicationFilter);if(t){return t.getAST(e)}return null};b.prototype.sort=function(e){if(e instanceof f){e=[e]}this.aSorter=e?e:[];this._abortAllPendingRequests();this.resetData(undefined,{reason:u.Sort});this._fireRefresh({reason:u.Sort});return this};b.prototype.getGroupName=function(e,t){if(e===undefined){return""}var i=this.aAggregationLevel[t-1],r=this.oAnalyticalQueryResult.findDimensionByPropertyName(i),s=this.mAnalyticalInfoByProperty[i]&&this.mAnalyticalInfoByProperty[i].formatter,n=e.getProperty(i),a,o,u,l,d,h,p,f;if(r&&this.oDimensionDetailsSet[i].textPropertyName){d=r.getTextProperty()}if(d){h=d.name;f=this.mAnalyticalInfoByProperty[h]&&this.mAnalyticalInfoByProperty[h].formatter;p=e.getProperty(h);a=s?s(n,p):n;o=f?f(p,n):p}else{a=s?s(n):n}l=r.getLabelText&&r.getLabelText();u=(l?l+": ":"")+a;if(o){u+=" - "+o}return u};b.prototype.updateAnalyticalInfo=function(e,r){var s,a,o,l,d=this;function h(e){var t=e.level,i=e.name;l=l||o.getAllHierarchyPropertyNames();l.forEach(function(r){var s=d.oAnalyticalQueryResult.findDimensionByPropertyName(r).getHierarchy(),n=null,a=s.getNodeIDProperty().name,u;if(a===i){n=p(s)}else{u=s.getNodeExternalKeyProperty();if(u&&u.name===i){n=p(s);n.nodeExternalKeyName=i}else{u=o.getTextPropertyOfProperty(a);if(u&&u.name===i){n=p(s);n.nodeTextName=i}}}if(n&&"level"in e){if(typeof t==="number"){if("level"in n&&n.level!==t){throw new Error("Multiple different level filter for hierarchy '"+a+"' defined")}n.level=t;n.grouped=!!e.grouped}else{throw new Error("The level of '"+a+"' has to be an integer value")}}})}function p(e){var t=e.getNodeIDProperty().name,i,r=d.mHierarchyDetailsByName[t];if(!r){i=e.getNodeLevelProperty();r={dimensionName:e.getNodeValueProperty().name,nodeIDName:t,nodeLevelName:i&&i.name};d.mHierarchyDetailsByName[t]=r}return r}if(!this.oModel.oMetadata||!this.oModel.oMetadata.isLoaded()||this.isInitial()){this.aInitialAnalyticalInfo=e;return}s=t.helper.deepEqual(this._aLastChangedAnalyticalInfo,e,function(e){d.mAnalyticalInfoByProperty[e.name].formatter=e.formatter});if(s){this._aLastChangedAnalyticalInfo=[];for(var f=0;f<e.length;f++){this._aLastChangedAnalyticalInfo[f]=n({},e[f])}}if(s<2){if(r||s){setTimeout(function(){this._fireChange({reason:u.Change})}.bind(this),0)}return}var g=this.oDimensionDetailsSet||{},y=this.oMeasureDetailsSet||{};this.mAnalyticalInfoByProperty={};this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.aMeasureName=[];if(this.iAnalyticalInfoVersionNumber==undefined){this.iAnalyticalInfoVersionNumber=1}else if(this.iAnalyticalInfoVersionNumber>999){this.iAnalyticalInfoVersionNumber=1}else{this.iAnalyticalInfoVersionNumber=this.iAnalyticalInfoVersionNumber+1}this.oMeasureDetailsSet={};this.oDimensionDetailsSet={};this.aAdditionalSelects=[];this.mHierarchyDetailsByName={};o=this.oAnalyticalQueryResult.getEntityType();for(var c=0;c<e.length;c++){var v=this.oAnalyticalQueryResult.findDimensionByPropertyName(e[c].name);if(v&&(e[c].inResult==true||e[c].visible==true)){e[c].dimensionPropertyName=v.getName();a=this.oDimensionDetailsSet[v.getName()];if(!a){a={};a.name=v.getName();a.aAttributeName=[];a.grouped=false;this.oDimensionDetailsSet[v.getName()]=a;this.aMaxAggregationLevel.push(a.name);if(e[c].grouped==true){this.aAggregationLevel.push(a.name)}}if(e[c].grouped==true){if(!this.getSortablePropertyNames()||this.getSortablePropertyNames().indexOf(v.getName())==-1){I.fatal("property "+v.getName()+" must be sortable in order to be used as grouped dimension")}a.grouped=true}if(v.getName()==e[c].name){a.keyPropertyName=e[c].name}b._updateDimensionDetailsTextProperty(v,e[c].name,a);if(v.findAttributeByName(e[c].name)){a.aAttributeName.push(e[c].name)}a.analyticalInfo=e[c]}var m=this.oAnalyticalQueryResult.findMeasureByPropertyName(e[c].name);if(m&&(e[c].inResult==true||e[c].visible==true)){e[c].measurePropertyName=m.getName();var _=this.oMeasureDetailsSet[m.getName()];if(!_){_={};_.name=m.getName();this.oMeasureDetailsSet[m.getName()]=_;this.aMeasureName.push(_.name)}if(m.getRawValueProperty().name==e[c].name){_.rawValuePropertyName=e[c].name}var M=m.getFormattedValueProperty();if(M&&M.name==e[c].name){_.formattedValuePropertyName=e[c].name}_.analyticalInfo=e[c]}if(!v&&!m){h(e[c])}this.mAnalyticalInfoByProperty[e[c].name]=e[c]}Object.keys(this.mHierarchyDetailsByName).forEach(function(e){var t=d.mHierarchyDetailsByName[e];if(!("level"in t)){delete d.mHierarchyDetailsByName[e];if(I.isLoggable(i.Level.INFO)){I.info("No level specified for hierarchy node '"+e+"'; ignoring hierarchy","")}}else if(!d.oDimensionDetailsSet[e]){d.oDimensionDetailsSet[e]={aAttributeName:[],grouped:t.grouped,isHierarchyDimension:true,name:e};d.aMaxAggregationLevel.push(e);if(t.grouped){d.aAggregationLevel.push(e)}}});for(var q in this.oMeasureDetailsSet){var x=this.oAnalyticalQueryResult.findMeasureByName(q).getUnitProperty();if(x){this.oMeasureDetailsSet[q].unitPropertyName=x.name}}var S=Object.keys(g).sort().join(";")!==Object.keys(this.oDimensionDetailsSet).sort().join(";");if(S){this.iTotalSize=-1}if(S||Object.keys(y).sort().join(";")!==Object.keys(this.oMeasureDetailsSet).sort().join(";")){this.bApplySortersToGroups=true}this.aAnalyticalInfo=e;this.resetData();this.bNeedsUpdate=false;if(this.mParameters.select){this.aAdditionalSelects=R(this)}if(r){this._fireChange({reason:u.Change})}};b.prototype.getAnalyticalInfoForColumn=function(e){return this.mAnalyticalInfoByProperty[e]};b.prototype.loadGroups=function(e){var t=[];for(var i in e){t.push(i);this._resetData(i);var r=e[i];for(var s=0;s<r.length;s++){var n=r[s];this._getContextsForParentGroupId(i,n.startIndex,n.length,n.threshold)}var a=[];for(var o=-1,u;(u=t[++o])!==undefined;){a.push(this._getRequestId(b._requestType.groupMembersQuery,{groupId:u}))}this._considerRequestGrouping(a)}};b.prototype.getAnalyticalQueryResult=function(){return this.oAnalyticalQueryResult};b._requestType={groupMembersQuery:1,totalSizeQuery:2,groupMembersAutoExpansionQuery:3,levelMembersQuery:4,reloadMeasuresQuery:5};b._artificialRootContextGroupId="artificialRootContext";b._addHierarchyLevelFilters=function(e,t){e.forEach(function(e){t.removeConditions(e.propertyName);t.addCondition(e.propertyName,d.EQ,e.level)})};b._getModelVersion=function(e){const t=e.getMetadata().getName();let i=t==="sap.ui.model.odata.v2.ODataModel"?2:null;if(t==="sap.ui.model.odata.ODataModel"){i=1}return i};b.prototype._getContextsForParentContext=function(e,t,i,r,s,n,a){if(e===undefined){return[]}if(e&&e.getPath()=="/"+b._artificialRootContextGroupId){e=this.getModel().getContext("/")}var o=this._getGroupIdFromContext(e,s);return this._getContextsForParentGroupId(o,t,i,r,n,a)};b.prototype._getContextsForParentGroupId=function(e,t,i,r,s,n){if(e===undefined){return[]}if(!t){t=0}if(!i){i=this.oModel.iSizeLimit}if(this.mFinalLength[e]&&this.mLength[e]<t+i){i=this.mLength[e]-t;if(i<0){I.fatal("invalid start index greater than total group length passed")}}if(!r){r=0}if(!s){s=0}if(e==null){if(s>0){I.fatal("invalid request to determine nodes of root context");return null}}else{if(this._getGroupIdLevel(e)>=this.aAggregationLevel.length&&s>0){I.fatal("invalid request to determine nodes of context with group ID "+e);return null}if(this._getGroupIdLevel(e)+s>this.aAggregationLevel.length){s=this.aAggregationLevel.length-this._getGroupIdLevel(e)-1}}var a=[],o,u,l,d;var h=e==null?0:this._getGroupIdLevel(e)+1;if(!this.aMultiUnitLoadFactor[h]){this.aMultiUnitLoadFactor[h]=1}var p=s>0&&e!=null;if(p){var f=this._getGroupIdLevel(e);var g=f+s;var y=true;if(!n){l=this._calculateRequiredGroupExpansion(e,g,t,i+r);y=l.groupId_Missing==null;y=y||l.groupId_Missing.length<e.length||l.groupId_Missing.substring(0,e.length)!=e}if(y){a=this._getLoadedContextsForGroup(e,t,i)}else{d=i+r}o=!y;d=Math.ceil(d*this.aMultiUnitLoadFactor[h])}else{a=this._getLoadedContextsForGroup(e,t,i,n);o=false;if(!n){if(this._oWatermark&&e===this._oWatermark.groupID){r=1e4}u=this._calculateRequiredGroupSection(e,t,i,r);var c=u.length>0&&i<u.length;o=a.length!=i&&!(this.mFinalLength[e]&&a.length>=this.mLength[e]-t)||c;u.length=Math.ceil(u.length*this.aMultiUnitLoadFactor[h])}}if(!o){this._cleanupGroupingForCompletedRequest(this._getRequestId(b._requestType.groupMembersQuery,{groupId:e}))}var v=false;if(this.oModel.getServiceMetadata()){if(o){var m=this.bProvideTotalSize&&this.iTotalSize==-1&&!this._isRequestPending(this._getRequestId(b._requestType.totalSizeQuery));v=true;var _;if(this.bUseBatchRequests){if(p){_=this._prepareGroupMembersAutoExpansionRequestIds(e,s);for(var R=-1,M;(M=_[++R])!==undefined;){if(this._isRequestPending(M)){v=false;break}}if(v){this.aBatchRequestQueue.push([b._requestType.groupMembersAutoExpansionQuery,e,l,d,s])}}else{v=u.length&&!this._isRequestPending(this._getRequestId(b._requestType.groupMembersQuery,{groupId:e}));if(v){this.aBatchRequestQueue.push([b._requestType.groupMembersQuery,e,u.startIndex,u.length]);_=[this._getRequestId(b._requestType.groupMembersQuery,{groupId:e})]}}if(v&&m){_.push(this._getRequestId(b._requestType.totalSizeQuery));this._considerRequestGrouping(_);this.aBatchRequestQueue.push([b._requestType.totalSizeQuery])}if(v){if(e==null){this._abortAllPendingRequests()}Promise.resolve().then(b.prototype._processRequestQueue.bind(this))}}else{var q;if(p){_=this._prepareGroupMembersAutoExpansionRequestIds(e,s);for(var x=-1,S;(S=_[++x])!==undefined;){if(this._isRequestPending(S)){v=false;break}}if(v){q=this._prepareGroupMembersAutoExpansionQueryRequest(b._requestType.groupMembersAutoExpansionQuery,e,l,d,s)}}else{v=u.length&&!this._isRequestPending(this._getRequestId(b._requestType.groupMembersQuery,{groupId:e}));if(v){q=this._prepareGroupMembersQueryRequest(b._requestType.groupMembersQuery,e,u.startIndex,u.length);_=[q.sRequestId]}}if(v){if(e==null){this._abortAllPendingRequests()}this._executeQueryRequest(q);if(m&&!q.bIsFlatListRequest){_.push(this._getRequestId(b._requestType.totalSizeQuery));this._considerRequestGrouping(_);this._executeQueryRequest(this._prepareTotalSizeQueryRequest(b._requestType.totalSizeQuery))}}}}}return a};b.prototype._getHierarchyLevelFiltersAndAddRecursiveHierarchy=function(e,t){var i,r=[],s=this;if(t===null){return r}i=Object.keys(this.mHierarchyDetailsByName);if(i.length>0&&t!=="/"){I.error("Hierarchy cannot be requested for members of a group",t);return r}i.forEach(function(t){var i=s.mHierarchyDetailsByName[t];e.addRecursiveHierarchy(i.dimensionName,!!i.nodeExternalKeyName,!!i.nodeTextName);r.push({propertyName:i.nodeLevelName,level:i.level})});return r};b.prototype._getNonHierarchyDimensions=function(e){var t=this;return e.filter(function(e){return!t.oDimensionDetailsSet[e].isHierarchyDimension})};b.prototype._processRequestQueue=function(e){if(e===undefined||e===null){e=this.aBatchRequestQueue||[]}if(e.length==0){return}var t=[];var i=false;var r,s,n;for(r=-1;(n=e[++r])!==undefined;){if(n[0]==b._requestType.groupMembersQuery){s=b.prototype._prepareGroupMembersQueryRequest.apply(this,n);i=i||s.bIsFlatListRequest;t.push(s)}}for(r=-1;(n=e[++r])!==undefined;){s=null;switch(n[0]){case b._requestType.groupMembersQuery:continue;case b._requestType.totalSizeQuery:if(!i){s=b.prototype._prepareTotalSizeQueryRequest.apply(this,n);t.push(s)}break;case b._requestType.groupMembersAutoExpansionQuery:s=b.prototype._prepareGroupMembersAutoExpansionQueryRequest.apply(this,n);for(var a=-1,o;(o=s.aGroupMembersAutoExpansionRequestDetails[++a])!==undefined;){t.push(o)}break;case b._requestType.reloadMeasuresQuery:{var u=n[1];for(var l=-1,d;(d=u[++l])!==undefined;){t.push(d)}break}default:I.fatal("unhandled request type "+e[r][0]);continue}}if(t.length>1){this._executeBatchRequest(t)}else{this._executeQueryRequest(t[0])}if(e===this.aBatchRequestQueue){this.aBatchRequestQueue=[]}};b.prototype._prepareGroupMembersQueryRequest=function(e,i,r,s){var n=[],a=[],o;var u=new t.QueryResultRequest(this.oAnalyticalQueryResult);u.setResourcePath(this._getResourcePath());u.getSortExpression().clear();var l=0,h=-1;if(i){n=this._getGroupIdComponents(i);l=h=n.length;var p=0;for(var f=0,g=0;f<l;g++){if(this.oDimensionDetailsSet[this.aMaxAggregationLevel[g]].grouped==false){++p}else{++f}}l=h=l+p;if(this.aMaxAggregationLevel.length>0){while(this.oDimensionDetailsSet[this.aMaxAggregationLevel[h]].grouped==false){if(++h==this.aMaxAggregationLevel.length){break}}}}var y=h>=this.aMaxAggregationLevel.length-1;o=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(u,i);var c=this.aMaxAggregationLevel.slice(0,h+1);var v=this._getNonHierarchyDimensions(c);u.setAggregationLevel(v);for(var m=0;m<v.length;m++){var _=this.oDimensionDetailsSet[v[m]];var R=_.textPropertyName!=undefined;u.includeDimensionKeyTextAttributes(_.name,true,R,_.aAttributeName);if(_.grouped){a.push({sPath:v[m],bDescending:false})}}var M=u.getFilterExpression();M.clear();if(this.aApplicationFilter){M.addUI5FilterConditions(this.aApplicationFilter)}if(this.aControlFilter){M.addUI5FilterConditions(this.aControlFilter)}if(l>=1){for(var q=0,x=n.length;q<x;q++){M.removeConditions(this.aAggregationLevel[q]);M.addCondition(this.aAggregationLevel[q],d.EQ,n[q])}}b._addHierarchyLevelFilters(o,M);var S;var A;var P;var L;var N=[];if(i!=null||this.bProvideGrandTotals||this._canApplySortersToGroups()&&this.aSorter.length>0){u.setMeasures(this.aMeasureName);for(var D in this.oMeasureDetailsSet){L=this.oMeasureDetailsSet[D];if(!y&&this._isSkippingTotalForMeasure(D)){S=false;A=false;P=false}else{S=L.rawValuePropertyName!=undefined;A=L.formattedValuePropertyName!=undefined;P=L.unitPropertyName!=undefined;if(P){if(N.indexOf(L.unitPropertyName)==-1){N.push(L.unitPropertyName)}}}u.includeMeasureRawFormattedValueUnit(L.name,S,A,P)}for(var G in v){var Q;if((Q=N.indexOf(v[G]))!=-1){N.splice(Q,1)}}}if(i){this._addSorters(u.getSortExpression(),a)}if(s==0){I.fatal("unhandled case: load 0 entities of sub group")}var F=this._getKeyIndexMapping(i,r);if(!this.bNoPaging){u.setResultPageBoundaries(F.iServiceKeyIndex+1,F.iServiceKeyIndex+s)}u.setRequestOptions(null,!this.mFinalLength[i]);return{iRequestType:e,sRequestId:this._getRequestId(b._requestType.groupMembersQuery,{groupId:i}),oAnalyticalQueryRequest:u,sGroupId:i,aSelectedUnitPropertyName:N,aAggregationLevel:c,bIsFlatListRequest:y&&l==0,bIsLeafGroupsRequest:y,iStartIndex:r,iLength:s,oKeyIndexMapping:F}};b.prototype._prepareTotalSizeQueryRequest=function(e){var i;var r=new t.QueryResultRequest(this.oAnalyticalQueryResult);r.setResourcePath(this._getResourcePath());i=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(r,"/");r.setAggregationLevel(this._getNonHierarchyDimensions(this.aMaxAggregationLevel));r.setMeasures([]);var s=r.getFilterExpression();s.clear();if(this.aApplicationFilter){s.addUI5FilterConditions(this.aApplicationFilter)}if(this.aControlFilter){s.addUI5FilterConditions(this.aControlFilter)}b._addHierarchyLevelFilters(i,s);r.setRequestOptions(null,null,true);r.setRequestOptions(null,true);return{iRequestType:e,sRequestId:this._getRequestId(b._requestType.totalSizeQuery),oAnalyticalQueryRequest:r}};b.prototype._prepareGroupMembersAutoExpansionQueryRequest=function(e,i,s,n,a){var o=this;var u=function(e,t){var i=[];if(e.groupId_Missing==null){I.fatal("missing group Id not present");return i}var s=o._getGroupIdComponents(e.groupId_Missing);var n=s.length;if(n>t){I.fatal("the given group ID is too deep for requested level for auto expansion");return i}var a=[];for(var u=0;u<n;u++){var h=o.aAggregationLevel[u];var p=s[u];var f=o._getFilterOperatorMatchingPropertySortOrder(h);a[u]=new l(h,f,p)}var g=null;if(e.startIndex_Missing>0){var y=o._getKey(e.groupId_Missing,e.startIndex_Missing-1);var c=o.oModel.getObject("/"+y);var v=o.aAggregationLevel[n];var m=c[v];g=new l(v,o._getFilterOperatorMatchingPropertySortOrder(v,false),m)}for(var _=0;_<t;_++){var R=[];var M=Math.min(n,_+1);for(var q=0;q<M;q++){var b=[];var x=Math.min(n,q+1);var S=e.startIndex_Missing>0;for(var A=0;A<x;A++){var P=new l("x",d.EQ,"x");P=r(P,a[A]);if(x>1&&A<x-1){P.sOperator=d.EQ}if(A==n-1&&_>n-1&&!S){if(P.sOperator==d.GT){P.sOperator=d.GE}else{P.sOperator=d.LE}}b.push(P)}if(b.length>0){R.push(new l(b,true));if(_>n-1&&q==n-1&&S){var L=[];for(var N=0;N<b.length;N++){var D=new l("x",d.EQ,"x");D=r(D,b[N]);L.push(D)}L[n-1].sOperator=d.EQ;L.push(g);R.push(new l(L,true));break}}}if(R.length>0){i[_]=new l(R,false)}else{i[_]=null}}return i};var h=function(e,i,r,s,n,a,u,l){var d;var h=new t.QueryResultRequest(o.oAnalyticalQueryResult);h.setResourcePath(o._getResourcePath());h.getSortExpression().clear();var p=0,g=-1;p=g=r-1;var y=0;for(var c=0,v=0;c<p;v++){if(o.oDimensionDetailsSet[o.aMaxAggregationLevel[v]].grouped==false){++y}else{++c}}p=g=p+y;if(o.aMaxAggregationLevel.length>0){while(o.aMaxAggregationLevel[g]&&o.oDimensionDetailsSet[o.aMaxAggregationLevel[g]].grouped==false){if(++g==o.aMaxAggregationLevel.length){break}}}var m=g>=o.aMaxAggregationLevel.length-1;d=o._getHierarchyLevelFiltersAndAddRecursiveHierarchy(h,i);var _=o.aMaxAggregationLevel.slice(0,g+1);h.setAggregationLevel(_);const R=[];for(var M=0;M<_.length;M++){var q=o.oDimensionDetailsSet[_[M]];var x=q.textPropertyName!=undefined;h.includeDimensionKeyTextAttributes(q.name,true,x,q.aAttributeName);if(q.grouped){R.push(new f(_[M]))}}var S=h.getFilterExpression();S.clear();if(o.aApplicationFilter){S.addUI5FilterConditions(o.aApplicationFilter)}if(o.aControlFilter){S.addUI5FilterConditions(o.aControlFilter)}if(s){S.addUI5FilterConditions([s])}b._addHierarchyLevelFilters(d,S);var A;var P;var L;var N;var D=[];h.setMeasures(o.aMeasureName);for(var G in o.oMeasureDetailsSet){N=o.oMeasureDetailsSet[G];if(!m&&o._isSkippingTotalForMeasure(G)){A=false;P=false;L=false}else{A=N.rawValuePropertyName!=undefined;P=N.formattedValuePropertyName!=undefined;L=N.unitPropertyName!=undefined;if(L){if(D.indexOf(N.unitPropertyName)==-1){D.push(N.unitPropertyName)}}}h.includeMeasureRawFormattedValueUnit(N.name,A,P,L)}for(var Q in _){var F;if((F=D.indexOf(_[Q]))!=-1){D.splice(F,1)}}o._mergeAndAddSorters(R,h.getSortExpression());if(a==0){I.fatal("unhandled case: load 0 entities of sub group")}var T=n;if(!l){T=0}else{var C=0;for(var E in o.mServiceKey){if(E.split("/").length===r+1){C+=o.mServiceKey[E].length}}T=Math.max(T,C)}if(!o.bNoPaging){h.setResultPageBoundaries(T+1,T+a)}return{iRequestType:e,sRequestId:null,oAnalyticalQueryRequest:h,iLevel:r,aSelectedUnitPropertyName:D,aAggregationLevel:_,bIsFlatListRequest:m,bIsLeafGroupsRequest:m,iStartIndex:n,iLength:a,bAvoidLengthUpdate:u}};var p=[];var g=[];if(!s){I.fatal("no first missing group member specified")}var y=this._getGroupIdLevel(i)+a+1;var c=o._getGroupIdComponents(s.groupId_Missing);var v=c.length;var m=u(s,y);var _;for(var R=1;R<=y;R++){var M;if(R>=v+2){M=0;_=undefined}else if(R==v+1){M=s.startIndex_Missing;_=s.groupId_Missing}else if(v>0){if(R==v){_=s.groupId_Missing}else{_=this._getGroupIdAncestors(s.groupId_Missing,-(v-R))[0]}var q=this._getGroupIdAncestors(s.groupId_Missing,-(v-R+1))[0];if(!q){I.fatal("failed to determine group id at parent level; group ID = "+i+", level = "+R)}M=this._findKeyIndex(q,this.mEntityKey[_]);if(M==-1){I.fatal("failed to determine position of value "+_+" in group "+q)}_=q;M++}var x=n>R?Math.ceil((n-R)/(y-R+1)):n;var S=m[R-1];if(this.bUseAcceleratedAutoExpand){var A=h(b._requestType.levelMembersQuery,i,R,S,M,x,false,S==null?true:false);A.sGroupId_Missing_AtLevel=_;A.sRequestId=this._getRequestId(b._requestType.levelMembersQuery,{groupId:i,level:R});p.push(A);g.push(A.sRequestId)}else if(S&&S.aFilters.length>0){if(!S._bMultiFilter||S.bAnd){I.fatal("level filter in wrong shape; cannot break it up")}for(var P=0;P<S.aFilters.length;P++){var L=S.aFilters[P];var N=h(b._requestType.levelMembersQuery,i,R,L,M,x,false,S==null?true:false);N.sGroupId_Missing_AtLevel=_;N.sRequestId=this._getRequestId(b._requestType.levelMembersQuery,{groupId:i,level:R,tupleIndex:P});p.push(N);g.push(N.sRequestId)}}else{var D=h(b._requestType.levelMembersQuery,i,R,null,M,x,false,S==null?true:false);D.sGroupId_Missing_AtLevel=_;D.sRequestId=this._getRequestId(b._requestType.levelMembersQuery,{groupId:i,level:R});p.push(D);g.push(D.sRequestId)}}return{iRequestType:e,aRequestId:g,aGroupMembersAutoExpansionRequestDetails:p,sGroupId:i,iLength:n}};b.prototype._prepareReloadMeasurePropertiesQueryRequest=function(e,i,r){var s=new t.QueryResultRequest(this.oAnalyticalQueryResult);s.setResourcePath(this._getResourcePath());s.getSortExpression().clear();var n=i.aAggregationLevel;s.setAggregationLevel(n);var a=i.bIsLeafGroupsRequest;var o=s.getFilterExpression();o.clear();if(this.aApplicationFilter){o.addUI5FilterConditions(this.aApplicationFilter)}if(this.aControlFilter){o.addUI5FilterConditions(this.aControlFilter)}var u=[];for(var h=0;h<n.length;h++){var p=new l(n[h],d.EQ,r.oEntry[n[h]]);u.push(p)}o.addUI5FilterConditions(u);var f;var g;var y;var c;var v=[];s.setMeasures(r.aReloadMeasurePropertyName);for(var m in this.oMeasureDetailsSet){c=this.oMeasureDetailsSet[m];if(!r.aReloadMeasurePropertyName||r.aReloadMeasurePropertyName.indexOf(c.name)==-1){continue}if(!a&&this._isSkippingTotalForMeasure(m)){f=false;g=false;y=false}else{f=c.rawValuePropertyName!=undefined;g=c.formattedValuePropertyName!=undefined;y=c.unitPropertyName!=undefined;if(y){if(v.indexOf(c.unitPropertyName)==-1){v.push(c.unitPropertyName)}}}s.includeMeasureRawFormattedValueUnit(c.name,f,g,y)}for(var _ in n){var I;if((I=v.indexOf(n[_]))!=-1){v.splice(I,1)}}return{iRequestType:e,sRequestId:this._getRequestId(b._requestType.reloadMeasuresQuery,{multiUnitEntryKey:this.oModel.getKey(r.oEntry)}),oAnalyticalQueryRequest:s,aSelectedUnitPropertyName:v,aAggregationLevel:n,oMultiUnitRepresentative:r}};b.prototype._prepareGroupMembersAutoExpansionRequestIds=function(e,t){var i=this._getGroupIdLevel(e)+1;var r=i+t;var s=[];for(var n=i;n<=r;n++){s.push(this._getRequestId(b._requestType.levelMembersQuery,{groupId:e,level:n}))}return s};b.prototype._getQueryODataRequestOptions=function(e,t,i){var r;i=i||{};try{e.getFilterExpression().checkValidity()}catch(e){I.fatal("filter expression is not valid",e.toString());return undefined}var s=e.getURIQueryOptionValue("$select");var n=e.getURIQueryOptionValue("$filter");var a=e.getURIQueryOptionValue("$orderby");var o=e.getURIQueryOptionValue("$skip");var u=e.getURIQueryOptionValue("$top");var l=e.getURIQueryOptionValue("$inlinecount");if(t&&this.aAdditionalSelects.length>0){s=(s?s.split(","):[]).concat(this.aAdditionalSelects).join(",")}if(this.mParameters&&this.mParameters["filter"]){if(n===null){n=this.mParameters["filter"]}else{n+="and ("+this.mParameters["filter"]+")"}}var d=[];if(s!==null){d.push("$select="+s)}if(n!==null){d.push("$filter="+n)}if(a!==null){d.push("$orderby="+a)}if(o!==null){d.push("$skip="+o)}if(u!==null){d.push("$top="+u)}if(l!==null){d.push("$inlinecount="+l)}if(i.encode===true){for(r=0;r<d.length;r++){d[r]=d[r].replace(/\ /g,"%20")}}return d};b.prototype._executeBatchRequest=function(t){var i=this.iAnalyticalInfoVersionNumber,r,s=this;var n=[],a=[];function o(){s.fireDataReceived({__simulateAsyncAnalyticalBinding:true})}var u=new e;function l(e,t){u.success(t)}function d(e,t){u.error(t||e)}this.bNeedsUpdate=true;for(var h=0;h<t.length;h++){var p=t[h];if(p.aAggregationLevel&&p.aAggregationLevel.length>0){this.bNeedsUpdate=false}}for(var f=-1,g;(g=t[++f])!==undefined;){var y=g.oAnalyticalQueryRequest,c=g.sGroupId;if(y.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});c=null;this.mServiceLength[c]=this.mLength[c]=1;this.mServiceFinalLength[c]=true;this._setServiceKey(this._getKeyIndexMapping(c,0),b._artificialRootContextGroupId);setTimeout(o);this.bArtificalRootContext=true;continue}var v=y.getURIToQueryResultEntries();if(!this.oContext&&v[0]!=="/"){v="/"+v}if(!this._isRequestPending(g.sRequestId)){this._registerNewRequest(g.sRequestId);if(this.iModelVersion===1){n.push(this.oModel.createBatchOperation(v.replace(/\ /g,"%20"),"GET"))}if(this.iModelVersion===2){var m=this._getQueryODataRequestOptions(y,g.bIsLeafGroupsRequest,{encode:true});if(this.sCustomParams){m.push(this.sCustomParams)}var _=this.oModel.read(v.replace(/\ /g,"%20"),{success:l,error:d,context:this.oContext,urlParameters:m});n.push(_)}a.push(g)}}if(n.length>0){I.debug("AnalyticalBinding: executing batch request with "+a.length+" operations");var R;r=this._getIdForNewRequestHandle();this.fireDataRequested();if(this.iModelVersion===1){this.oModel.addBatchReadOperations(n);R=this.oModel.submitBatch(M,q,true,true);this.oModel.fireRequestSent({url:this.oModel.sServiceUrl+"/$batch",type:"POST",async:true,info:"",infoObject:{}})}if(this.iModelVersion===2){R={abort:function(){for(var e=0;e<n.length;e++){n[e].abort()}}};u.setup({executedRequests:a,binding:this,success:M,error:q})}this._registerNewRequestHandle(r,R)}function M(e,t){s._deregisterHandleOfCompletedRequest(r);if(a.length!=e.__batchResponses.length){I.fatal("assertion failed: received "+e.__batchResponses.length+" responses for "+a.length+" read operations in the batch request")}if(i!=s.iAnalyticalInfoVersionNumber){for(var n=0;n<a.length;n++){var o=a[n].sRequestId;if(o!==undefined){s._deregisterCompletedRequest(o);s._cleanupGroupingForCompletedRequest(o)}}s.fireDataReceived({data:[]});return}var u=0;for(var l=0;l<e.__batchResponses.length;l++){if(e.__batchResponses[l].data!=undefined){if(e.__batchResponses[l].data.results.length==0){u++}switch(a[l].iRequestType){case b._requestType.groupMembersQuery:s._processGroupMembersQueryResponse(a[l],e.__batchResponses[l].data);break;case b._requestType.totalSizeQuery:s._processTotalSizeQueryResponse(a[l],e.__batchResponses[l].data);break;case b._requestType.levelMembersQuery:s._processLevelMembersQueryResponse(a[l],e.__batchResponses[l].data);break;case b._requestType.reloadMeasuresQuery:s._processReloadMeasurePropertiesQueryResponse(a[l],e.__batchResponses[l].data);break;default:I.fatal("invalid request type "+a[l].iRequestType);continue}}s._deregisterCompletedRequest(a[l].sRequestId);s._cleanupGroupingForCompletedRequest(a[l].sRequestId)}if(s.mParameters&&s.mParameters.numberOfExpandedLevels>0){if(u==e.__batchResponses.length){s.mLength["/"]=0;s.mFinalLength["/"]=true}}s.fireDataReceived({data:e});if(s.iModelVersion===1){let i=true;let r={};const n=s.oModel._getBatchErrors(e);if(n.length>0){i=false;r=s.oModel._handleError(n[0])}s.oModel.fireRequestCompleted({url:t.requestUri,type:"POST",async:true,info:"",infoObject:{},success:i,errorobject:i?{}:r});if(i){s.oModel.checkUpdate()}}}function q(e){if(e&&e.statusText!="abort"){s._deregisterHandleOfCompletedRequest(r);for(var t=-1,n;(n=a[++t])!==undefined;){s._deregisterCompletedRequest(n.sRequestId);s._cleanupGroupingForCompletedRequest(n.sRequestId)}}if(i!=s.iAnalyticalInfoVersionNumber){s.fireDataReceived();return}if(s.iModelVersion===1){e=s.oModel._handleError(e)}s.oModel.fireRequestCompleted({url:"",type:"POST",async:true,info:"",infoObject:{},success:false,errorobject:e});if(s.iModelVersion===1){s.oModel.fireRequestFailed(e)}s.fireDataReceived()}};b.prototype._executeQueryRequest=function(e){if(e.iRequestType==b._requestType.groupMembersAutoExpansionQuery){for(var t=-1,i;(i=e.aGroupMembersAutoExpansionRequestDetails[++t])!==undefined;){this._executeQueryRequest(i)}return}var r=this.iAnalyticalInfoVersionNumber;var s=e.oAnalyticalQueryRequest,n=e.sGroupId;var a=s.getURIToQueryResultEntitySet();var o=this._getQueryODataRequestOptions(s,e.bIsLeafGroupsRequest);if(!o){return}var u=this;if(s.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});n=null;this.mServiceLength[n]=this.mLength[n]=1;this.mServiceFinalLength[n]=true;this._setServiceKey(this._getKeyIndexMapping(n,0),b._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(function(){if(u._cleanupGroupingForCompletedRequest(e.sRequestId)){u.fireDataReceived({__simulateAsyncAnalyticalBinding:true})}});this.bArtificalRootContext=true;return}this._registerNewRequest(e.sRequestId);this.fireDataRequested();for(var l=0;l<o.length;l++){o[l]=o[l].replace(/\ /g,"%20")}I.debug("AnalyticalBinding: executing query request");var d=this._getIdForNewRequestHandle();if(this.iModelVersion===1){this.oModel._loadData(a,o,p,g,false,y,f)}if(this.iModelVersion===2){if(this.sCustomParams){o.push(this.sCustomParams)}var h=this.oModel.read(a.replace(/ /g,"%20"),{success:p,error:g,context:this.oContext,urlParameters:o});u._registerNewRequestHandle(d,h)}function p(t){u._deregisterHandleOfCompletedRequest(d);if(r!=u.iAnalyticalInfoVersionNumber){u._deregisterCompletedRequest(e.sRequestId);return}switch(e.iRequestType){case b._requestType.groupMembersQuery:u._processGroupMembersQueryResponse(e,t);break;case b._requestType.totalSizeQuery:u._processTotalSizeQueryResponse(e,t);break;case b._requestType.levelMembersQuery:u._processLevelMembersQueryResponse(e,t);break;case b._requestType.reloadMeasuresQuery:u._processReloadMeasurePropertiesQueryResponse(e,t);break;default:I.fatal("invalid request type "+e.iRequestType);break}u._deregisterCompletedRequest(e.sRequestId);if(u.iModelVersion===2){f(t)}}function f(t){if(r!=u.iAnalyticalInfoVersionNumber){return}if(u._cleanupGroupingForCompletedRequest(e.sRequestId)){u.fireDataReceived({data:t})}}function g(t){if(t&&t.statusText=="abort"){u.fireDataReceived();return}u._deregisterHandleOfCompletedRequest(d);u._deregisterCompletedRequest(e.sRequestId);u._cleanupGroupingForCompletedRequest(e.sRequestId);if(r!=u.iAnalyticalInfoVersionNumber){return}u.fireDataReceived()}function y(e){u._registerNewRequestHandle(d,e)}};b.prototype._abortAllPendingRequests=function(){this._abortAllPendingRequestsByHandle();this._clearAllPendingRequests()};b.prototype._processGroupMembersQueryResponse=function(e,t){var i,r=e.sGroupId,s=this.aSorter.length>0,n=e.aSelectedUnitPropertyName,a=e.aAggregationLevel,o=e.oKeyIndexMapping.iIndex,u=e.oKeyIndexMapping.iServiceKeyIndex,l=e.iLength,d=e.oKeyIndexMapping,h=r==null?0:this._getGroupIdLevel(r)+1,p=n.length>0,f,g,y,c=0,v,m,_=[];var R=t.results.length;if(r===null&&R>1&&this._canApplySortersToGroups()){this._warnNoSortingOfGroups(s?"binding is refreshed":undefined);if(s){setTimeout(this.refresh.bind(this),0);return}}var M=this._getServiceKeys(r,d.iIndex-1);f=undefined;if(M&&M.length>0){for(var q=0,S=M.length;q<S;q++){t.results[q-S]=this.oModel.getObject("/"+M[q])}var A=t.results[-M.length];f="";for(var P=0;P<a.length;P++){f+=b._getDimensionValue(A[a[P]])+"|"}}v=M&&M.length==1;for(var L=0;L<R;L++){var N=t.results[L];if(p){g="";for(var D=0;D<a.length;D++){g+=b._getDimensionValue(N[a[D]])+"|"}if(f==g){this._warnNoSortingOfGroups();if(y===undefined){if(L==0){y=-M.length;d.iServiceKeyIndex-=M.length-1}else{y=L-1}}var G=-1,Q=t.results[L-1];for(var F=0;F<n.length;F++){if(Q[n[F]]!=N[n[F]]){G=F;break}}if(G==-1){I.fatal("assertion failed: no deviating units found for result entries "+(L-1)+" and "+L,null,null,x(this,"NO_DEVIATING_UNITS"))}}if((f!=g||L==R-1)&&y!==undefined){var T=[];for(var C=y;C<L;C++){T.push(t.results[C])}if(f==g){T.push(t.results[L])}var E=b._getDeviatingUnitPropertyNames(n,T);var K=this._createMultiUnitRepresentativeEntry(r,t.results[y],n,E,e.bIsFlatListRequest);if(K.aReloadMeasurePropertyName.length>0){m=this._prepareReloadMeasurePropertiesQueryRequest(b._requestType.reloadMeasuresQuery,e,K);if(m.oAnalyticalQueryRequest&&m.oAnalyticalQueryRequest.getURIQueryOptionValue("$select")!=null){_.push(m)}}var O=this._setAdjacentMultiUnitKeys(d,K,T);var U;if(K.bIsNewEntry){U=T.length-1}else{U=O}if(v){v=false}if(U<0){I.fatal("assertion failed: iDiscardedEntriesCount must be non-negative")}c+=U;var w=this.oModel._getKey(K.oEntry);var V=this.oModel.getContext("/"+w);this._getGroupIdFromContext(V,h);this.mEntityKey[i]=w;y=undefined;if(f!=g){v=this._setServiceKey(d,this.oModel._getKey(N))}}else if(f!=g){v=this._setServiceKey(d,this.oModel._getKey(N))}f=g}else{this._setServiceKey(d,this.oModel._getKey(N))}if(!e.bIsLeafGroupsRequest){var B=this._getKey(r,d.iIndex-1);i=this._getGroupIdFromContext(this.oModel.getContext("/"+B),h);this.mEntityKey[i]=B}}var k=[];if(this.bReloadSingleUnitMeasures&&_.length>0){if(this.bUseBatchRequests){this.aBatchRequestQueue.push([b._requestType.reloadMeasuresQuery,_]);Promise.resolve().then(b.prototype._processRequestQueue.bind(this))}else{for(var H=0;H<_.length;H++){var z=_[H];this._executeQueryRequest(z)}}for(var j=0;j<_.length;j++){var $=_[j];k.push($.sRequestId)}this._considerRequestGrouping(k)}if(M&&M.length>0){for(var Z=0,W=M.length;Z<W;Z++){delete t.results[Z-W]}}if(p){c+=this._mergeLoadedKeyIndexWithSubsequentIndexes(d,a,n,e.bIsFlatListRequest)}if(!e.bAvoidLengthUpdate){var J=false;if(t.__count){this.mServiceLength[r]=parseInt(t.__count);this.mLength[r]=this.mServiceLength[r]-c;this.mFinalLength[r]=true;if(e.bIsFlatListRequest){this.iTotalSize=this.mServiceLength[r]}J=true}if(!(r in this.mServiceLength)||this.mServiceLength[r]<u+R){this.mServiceLength[r]=u+R;this.mLength[r]=o+R-c;this.mFinalLength[r]=false}if(R<l||l===undefined){this.mServiceLength[r]=u+R;this.mLength[r]=o+d.iIndex-o;this.mFinalLength[r]=true;J=true}if(R==0){this.mLength[r]=this.mServiceLength[r]=0;this.mFinalLength[r]=true;J=true}if(!J&&this.mLength[r]!==undefined&&c>0){this.mLength[r]-=c}}this.bNeedsUpdate=true;if(c>0){if(t.results.length-c>0){this.aMultiUnitLoadFactor[a.length]=t.results.length/(t.results.length-c)}if(this.aMultiUnitLoadFactor[a.length]<1.5){this.aMultiUnitLoadFactor[a.length]=2}}I.info("MultiUnit Situation in Group ("+r+"), discarded: "+c+", load-factor is now: "+this.aMultiUnitLoadFactor[a.length])};b.prototype._processTotalSizeQueryResponse=function(e,t){if(t.__count==undefined){I.fatal("missing entity count in query result");return}this.iTotalSize=parseInt(t.__count)};b.prototype._processLevelMembersQueryResponse=function(e,t){var i=this;var s,n;var a=function(a,o){var u={iRequestType:b._requestType.groupMembersQuery,sRequestId:i._getRequestId(b._requestType.groupMembersQuery,{groupId:s}),oAnalyticalQueryRequest:e.oAnalyticalQueryRequest,sGroupId:s,aSelectedUnitPropertyName:e.aSelectedUnitPropertyName,aAggregationLevel:e.aAggregationLevel,bIsFlatListRequest:e.bIsFlatListRequest,bIsLeafGroupsRequest:e.bIsLeafGroupsRequest,iStartIndex:a?e.iStartIndex:0,iLength:e.iLength,bAvoidLengthUpdate:e.bAvoidLengthUpdate};if(a&&e.iStartIndex>0&&(e.sGroupId_Missing_AtLevel!=u.sGroupId||i._getKeys(u.sGroupId)===undefined)){var l=i._getParentGroupId(u.sGroupId);var d=i._findKeyIndex(l,i.mEntityKey[u.sGroupId]);if(d<0){I.fatal("assertion failed: failed to determine position of "+u.sGroupId+" in group "+l)}else if(!d){i.mFinalLength[e.sGroupId_Missing_AtLevel]=true;u.iStartIndex=0}else if(i._getKey(l,d-1)!==undefined){var h=i._getKey(l,d-1);var p=i._getGroupIdFromContext(i.oModel.getContext("/"+h),i._getGroupIdLevel(u.sGroupId));i.mFinalLength[p]=true;u.iStartIndex=0}}if(o){u.iLength=n.length}u.oKeyIndexMapping=i._getKeyIndexMapping(u.sGroupId,u.iStartIndex);var f=r({},t);f.results=n;i._processGroupMembersQueryResponse(u,f)};if(t.results.length==0){this.bNeedsUpdate=true;return}s=this._getGroupIdFromContext(this.oModel.getContext("/"+this.oModel._getKey(t.results[0])),e.iLevel-1);n=[];var o=true;for(var u=0;u<t.results.length;u++){var l=t.results[u];var d=this.oModel.getContext("/"+this.oModel._getKey(t.results[u]));var h=this._getGroupIdFromContext(d,e.iLevel-1);if(s==h){n.push(l);if(u<t.results.length-1){continue}}a(o,t.results.length==e.iLength&&u==t.results.length-1);o=false;if(s!=h){n=[l]}s=h}if(t.results.length>1&&n.length==1){a(o,t.results.length==e.iLength)}};b.prototype._processReloadMeasurePropertiesQueryResponse=function(e,t){var i=e.oMultiUnitRepresentative;var r=this.oModel.getKey(i.oEntry);if(t.results.length!=1){I.fatal("assertion failed: more than one entity for reloaded measure properties of entity with key "+r);return}var s=t.results[0];var n=this.oModel.getObject("/"+r);if(!n){I.fatal("assertion failed: no entity found with key "+r);return}var a=i.aReloadMeasurePropertyName;for(var o=0;o<a.length;o++){n[a[o]]=s[a[o]]}};b.prototype._getLoadedContextsForGroup=function(e,t,i,r){var s=[],n,a,o=this._getKeys(e),u;if(!o){return s}if(!t){t=0}if(!i){i=this.oModel.iSizeLimit;if(this.mFinalLength[e]){i=this.mLength[e]}}if(r){a=t||0;u=o(a);while(u){n=this.oModel.getContext("/"+u);s.push(n);a++;u=o(a)}return s}for(a=t;a<t+i;a++){u=o(a);if(!u){break}n=this.oModel.getContext("/"+u);s.push(n)}return s};b.prototype._calculateRequiredGroupSection=function(e,t,i,r){var s=this.mKeyIndex[e]||[],n=this.mFinalLength[e]?this.mLength[e]:undefined,a=v._getReadIntervals(s,t,i,r,n),o=v._mergeIntervals(a);if(o){return{startIndex:o.start,length:o.end-o.start}}return{startIndex:0,length:Math.min(0,i)}};b.prototype._calculateRequiredGroupExpansion=function(e,t,i,r){var s={groupId_Missing:null,length_Missing:0};var n=this;var a=function(e,t,i,r){var o=n._getGroupIdLevel(e);if(o==t){var u=n._getLoadedContextsForGroup(e,i,r);var l=i+u.length-1;if(u.length>=r){return s}else if(n.mFinalLength[e]){if(u.length>=n.mLength[e]){return{groupId_Missing:null,length_Missing:r-u.length}}else{return{groupId_Missing:e,startIndex_Missing:l+1,length_Missing:r-u.length}}}else{return{groupId_Missing:e,startIndex_Missing:l+1,length_Missing:r-u.length}}}var d=n._getLoadedContextsForGroup(e,i,r);var h=r,p=i+d.length-1;for(var f=-1,g;(g=d[++f])!==undefined;){h--;var y=a(n._getGroupIdFromContext(g,o+1),t,0,h);if(y.groupId_Missing==null){if(y.length_Missing==0){return y}else{h=y.length_Missing}}else{return y}if(h==0){break}}if(n.mFinalLength[e]||h==0){return{groupId_Missing:null,length_Missing:h}}else{return{groupId_Missing:e,startIndex_Missing:p+1,length_Missing:h}}};var o=this._getGroupIdLevel(e);if(o==t+1){e=this._getParentGroupId(e);--o}if(e==null||o>t){return s}var u=r,l=i;while(e!=null){var d=a(e,t,l,u);if(d.groupId_Missing!=null){return d}else if(d.length_Missing==0){return d}else{var h=false;while(!h){var p=this._getParentGroupId(e);if(p==null){e=p;--o;break}var f=this.mEntityKey[e];if(!f){return s}var g=this._findKeyIndex(p,f);if(g==-1){return s}if(g==this._getKeyCount(p)-1){if(this.mFinalLength[p]){e=p;--o;continue}else{return{groupId_Missing:p,startIndex_Missing:g+1,length_Missing:u}}}else{f=this._getKey(p,g+1);e=this._getGroupIdFromContext(this.oModel.getContext("/"+f),o);h=true}}l=0;u=d.length_Missing}}return{groupId_Missing:null,length_Missing:u}};b.prototype._getResourcePath=function(){return this.isRelative()?this.getResolvedPath():this.sPath};b.prototype._getEntitySet=function(){var e=this.sEntitySetName;if(!e){e=this.sPath.split("/")[1];if(e.indexOf("(")!=-1){e=e.split("(")[0]+"Results"}}return e};b.prototype._getEffectiveSortOrder=function(e){for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]&&this.aSorter[i].sPath==e){return this.aSorter[i].bDescending?t.SortOrder.Descending:t.SortOrder.Ascending}}return null};b.prototype._getFilterOperatorMatchingPropertySortOrder=function(e,i){var r;switch(this._getEffectiveSortOrder(e)){case t.SortOrder.Ascending:if(i){r=d.GE}else{r=d.GT}break;case t.SortOrder.Descending:if(i){r=d.LE}else{r=d.LT}break;default:r=d.GT}return r};b.prototype._convertDeprecatedFilterObjects=function(e){if(!e){return e}var t=sap.ui.require("sap/ui/model/odata/Filter");if(typeof t==="function"){for(var i=0,r=e.length;i<r;i++){if(e[i]instanceof t){e[i]=e[i].convert()}}}return e};b.prototype._getGroupIdFromContext=function(e,t){if(!e){return null}var i="/";var r=null;if(t>this.aAggregationLevel.length){I.fatal("assertion failed: aggregation level deeper than number of current aggregation levels")}for(var s=0;s<t;s++){r=e.getProperty(this.aAggregationLevel[s]);if(r!=null){if(r.__edmType==="Edm.Time"){r=r.ms}i+=encodeURIComponent(r)+"/"}else{i+="@/"}}return i};b.prototype._getGroupIdLevel=function(e){if(e==null){I.fatal("assertion failed: no need to determine level of group ID = null");return-1}return e.split("/").length-2};b.prototype._getGroupIdComponents=function(e){if(e==null){return null}var t=e.split("/");var i=[];for(var r=1;r<t.length-1;r++){if(t[r]=="@"){i[r-1]=null}else{i[r-1]=decodeURIComponent(t[r])}}return i};b.prototype._getGroupIdAncestors=function(e,t){if(!t){return[]}if(e==null){I.fatal("group ID null does not have ancestors");return[]}if(e=="/"){if(Math.abs(t)==1){return[null]}else{I.fatal("invalid level count "+t+" for ancestors of groupId "+e);return[]}}var i=e.split("/");var r=[],s="";var n=0,a=i.length-3;if(t>0){if(t-1>a){I.fatal("invalid level count "+t+" for ancestors of groupId "+e)}else{a=t-1}}else if(-(t+1)>a){I.fatal("invalid level count "+t+" for ancestors of groupId "+e)}else{n=a+1+t;for(var o=0;o<n;o++){s+=i[o]+"/"}}for(var u=n;u<=a;u++){s+=i[u]+"/";r.push(s)}return r};b.prototype._getParentGroupId=function(e){return this._getGroupIdAncestors(e,-1)[0]};b.prototype._removeDuplicatesFromStringArray=function(e){var t={};for(var i=0;i<e.length;i++){t[e[i]]=true}var r=[];for(var s in t){r.push(s)}return r};b.prototype._getIdForNewRequestHandle=function(){if(this.oPendingRequestHandle===undefined){this.oPendingRequestHandle=[]}for(var e=0;e<this.oPendingRequestHandle.length;e++){if(this.oPendingRequestHandle[e]===undefined){return e}}this.oPendingRequestHandle[this.oPendingRequestHandle.length]=undefined;return this.oPendingRequestHandle.length-1};b.prototype._registerNewRequestHandle=function(e,t){if(this.oPendingRequestHandle[e]!==undefined){I.fatal("request handle ID already in use")}this.oPendingRequestHandle[e]=t};b.prototype._deregisterHandleOfCompletedRequest=function(e){if(a(this.oPendingRequestHandle)){I.warning("No request handles to be cleared. Previous abort/resetData?");return}if(this.oPendingRequestHandle[e]===undefined){I.fatal("no handle found for this request ID")}this.oPendingRequestHandle[e]=undefined};b.prototype._abortAllPendingRequestsByHandle=function(){for(var e=0;e<this.oPendingRequestHandle.length;e++){if(this.oPendingRequestHandle[e]){if(this.oPendingRequestHandle[e]!==undefined){this.oPendingRequestHandle[e].abort()}}}this.oPendingRequestHandle=[]};b.prototype._getRequestId=function(e,t){switch(e){case b._requestType.groupMembersQuery:if(t.groupId===undefined){I.fatal("missing group ID")}return b._requestType.groupMembersQuery+(t.groupId==null?"":t.groupId);case b._requestType.levelMembersQuery:if(t.level===undefined){I.fatal("missing level")}if(t.groupId===undefined){I.fatal("missing groupId")}return""+b._requestType.levelMembersQuery+t.level+(t.tupleIndex?"-"+t.tupleIndex:"");case b._requestType.totalSizeQuery:return b._requestType.totalSizeQuery;case b._requestType.reloadMeasuresQuery:if(!t.multiUnitEntryKey){I.fatal("missing multi unit entry key")}return b._requestType.reloadMeasuresQuery+t.multiUnitEntryKey;default:I.fatal("invalid request type "+e);return-1}};b.prototype._registerNewRequest=function(e){if(e==undefined||e==""){I.fatal("missing request ID");return}if(!this.oPendingRequests[e]){this.oPendingRequests[e]=1}else{++this.oPendingRequests[e]}};b.prototype._considerRequestGrouping=function(e){for(var t=-1,i;(i=e[++t])!==undefined;){if(this.oGroupedRequests[i]===undefined){this.oGroupedRequests[i]={}}var r=this.oGroupedRequests[i];for(var s=0;s<e.length;s++){r[e[s]]=true}}};b.prototype._isRequestPending=function(e){return this.oPendingRequests[e]!=undefined&&this.oPendingRequests[e]>0};b.prototype._deregisterCompletedRequest=function(e){if(a(this.oPendingRequests)){I.warning("There are no pending requests which could be set to 'completed'.");return}if(!this.oPendingRequests[e]){I.fatal("assertion failed: there is no pending request ID "+e)}if(this.oPendingRequests[e]==1){delete this.oPendingRequests[e]}else{--this.oPendingRequests[e]}};b.prototype._cleanupGroupingForCompletedRequest=function(e){if(this._isRequestPending(e)){return false}var t=true;if(this.oGroupedRequests[e]!=undefined){for(var i in this.oGroupedRequests[e]){if(this.oPendingRequests[i]){t=false;break}}}if(t){var r=this.oGroupedRequests[e];delete this.oGroupedRequests[e];for(var s in r){if(s!=e){this._cleanupGroupingForCompletedRequest(s)}}}return t};b.prototype._getKeyIndexMapping=function(e,t){var i,r,s,n=this.mKeyIndex[e],a={sGroupId:e,iIndex:t,iServiceKeyIndex:t},o=this.mServiceKey[e];if(n!==undefined){if(n[t]!==undefined){a.iServiceKeyIndex=n[t]==="ZERO"?0:Math.abs(n[t]);return a}r=t;if(r>0){while(--r>0){if(n[r]!==undefined){break}}}if(r==0){s=0}else{if(n[r]>=0){s=n[r]}else if(n[r+1]===undefined){s=-n[r];while(o[s+1]!==undefined){++s}}else{s=Math.abs(n[r+1])-1}if(o[s]===undefined){I.fatal("assertion failed: no service key at iLastOccupiedServiceKeyIndex = "+s)}}i=t-r;a.iServiceKeyIndex=s+i}return a};b.prototype._moveKeyIndexMapping=function(e,t){return this._getKeyIndexMapping(e.sGroupId,e.iIndex+t)};b.prototype._getKey=function(e,t){var i=this.mKeyIndex[e][t];if(i===undefined){return undefined}if(i>=0){return this.mServiceKey[e][i]}if(this.mMultiUnitKey[e]===undefined){I.fatal("assertion failed: missing expected multi currency key for group with ID "+e);return null}var r=this.mMultiUnitKey[e][t];if(r===undefined){I.fatal("assertion failed: missing expected multi currency key for group with ID "+e+" at pos "+t);return null}return r};b.prototype._getKeys=function(e){if(this.mKeyIndex[e]===undefined){return undefined}var t=this;return function(i){return t._getKey(e,i)}};b.prototype._getServiceKeys=function(e,t){var i=this.mKeyIndex[e];if(i===undefined){return undefined}var r=this.mServiceKey[e],s=i[t];if(s===undefined){return undefined}if(s>=0){return[r[s]]}var n=[];if(i[t+1]===undefined){s=i[t]=="ZERO"?0:-i[t];while(r[s]!==undefined){n.push(r[s++])}}else{s=i[t]=="ZERO"?0:-i[t];for(var a=s,o=Math.abs(i[t+1]);a<o;a++){n.push(r[a])}}return n};b.prototype._getKeyCount=function(e){if(this.mKeyIndex[e]===undefined){return undefined}return this.mKeyIndex[e].length};b.prototype._findKeyIndex=function(e,t){var i=this.mKeyIndex[e];var r=this.mServiceKey[e];var s=this.mMultiUnitKey[e];for(var n=0;n<this.mLength[e];n++){if(i[n]<0||i[n]==="ZERO"){if(s[n]==t){return n}}else if(r[i[n]]==t){return n}}return-1};b.prototype._setServiceKey=function(e,t){if(!this.mServiceKey[e.sGroupId]){this.mServiceKey[e.sGroupId]=[]}if(!this.mKeyIndex[e.sGroupId]){this.mKeyIndex[e.sGroupId]=[]}var i=this.mServiceKey[e.sGroupId][e.iServiceKeyIndex]===undefined;this.mServiceKey[e.sGroupId][e.iServiceKeyIndex++]=t;this.mKeyIndex[e.sGroupId][e.iIndex++]=e.iServiceKeyIndex-1;return i};b.prototype._setAdjacentMultiUnitKeys=function(e,t,i){if(!this.mServiceKey[e.sGroupId]){this.mServiceKey[e.sGroupId]=[]}if(!this.mKeyIndex[e.sGroupId]){this.mKeyIndex[e.sGroupId]=[]}if(!this.mMultiUnitKey[e.sGroupId]){this.mMultiUnitKey[e.sGroupId]=[]}--e.iIndex;--e.iServiceKeyIndex;this.mMultiUnitKey[e.sGroupId][e.iIndex]=this.oModel._getKey(t.oEntry);this.mKeyIndex[e.sGroupId][e.iIndex++]=e.iServiceKeyIndex>0?-e.iServiceKeyIndex:"ZERO";var r=0;for(var s=0;s<i.length;s++){if(!this.mServiceKey[e.sGroupId][e.iServiceKeyIndex]){++r}this.mServiceKey[e.sGroupId][e.iServiceKeyIndex++]=this.oModel._getKey(i[s])}return r};b.prototype._mergeLoadedKeyIndexWithSubsequentIndexes=function(e,t,i,r){var s,n=this.mKeyIndex[e.sGroupId],a=this.mServiceKey[e.sGroupId],o=this.mMultiUnitKey[e.sGroupId],u=0,l=e.iServiceKeyIndex,d=e.iIndex;var h,p;if(n===undefined){return u}var f=false;var g=a[l-1],y=a[l];if(y===undefined){return u}if(g===undefined){I.fatal("assertion failed: missing expected entry before given key index");return u}var c=this.oModel.getObject("/"+g);var v=this.oModel.getObject("/"+y);var m="",_="";for(var R=0;R<t.length;R++){m+=b._getDimensionValue(c[t[R]])+"|";_+=b._getDimensionValue(v[t[R]])+"|"}f=m==_;var M=d;if(M>=this.mLength[e.sGroupId]){I.fatal("assertion failed: service key exists,but no corresponding key index found");return u}while(n[M]===undefined||Math.abs(n[M])<l){++M}if(f){if(Math.abs(n[M])==l&&n[M]<0){if(M>d){if(n[d-1]<0){o[M]=undefined;n.splice(d,M-d+1);o.splice(d,M-d+1)}else{n[d-1]=-n[d-1];o[d-1]=o[M];o[M]=undefined;n.splice(d,M-d+1);o.splice(d,M-d+1);u=1}}}else if(Math.abs(n[M])>l){var q=M-1;if(n[q]>0){s=b._getDeviatingUnitPropertyNames(i,[c,v]);h=this._createMultiUnitRepresentativeEntry(e.sGroupId,c,i,s,r);p=this.oModel._getKey(h.oEntry);n[q]=-n[q];o[q]=p;if(q>d){n.splice(d,q-d);o.splice(d,q-d)}if(h.bIsNewEntry){u=1}else{u=0}}else if(n[d-1]<0){if(M>d){o[q]=undefined;n.splice(d,q-d+1);o.splice(d,q-d+1)}}else{n[d-1]=-n[d-1];o[d-1]=o[q];o[q]=undefined;n.splice(d,q-d+1);o.splice(d,q-d+1)}}else if(n[M]==l){if(M>d){if(n[d-1]<0){n.splice(d,M-d+1);o.splice(d,M-d+1);u=1}else{s=b._getDeviatingUnitPropertyNames(i,[c,v]);h=this._createMultiUnitRepresentativeEntry(e.sGroupId,c,i,s,r);p=this.oModel._getKey(h.oEntry);if(!h.bIsNewEntry){I.fatal("assertion failed: multi-unit entry already existed before")}n[d-1]=-n[d-1];o[d-1]=p;n.splice(d,M-d+1);o.splice(d,M-d+1);u=1}}}else{I.fatal("assertion failed: uncovered case detected");return u}}else if(n[M]>l){I.fatal("unstable query result for group ID "+e.sGroupId+": entries have been removed or added. Complete reload required")}else if(M-d>0){n.splice(d,M-d);o.splice(d,M-d)}return u};b.prototype._createMultiUnitRepresentativeEntry=function(e,t,i,s,n){var a=r({},t);var o=[];for(var u in this.oMeasureDetailsSet){var l=this.oMeasureDetailsSet[u];if(!n&&this._isSkippingTotalForMeasure(u)){if(l.rawValuePropertyName!=undefined){a[l.rawValuePropertyName]=undefined}if(l.formattedValuePropertyName!=undefined){a[l.formattedValuePropertyName]=undefined}}else{if(l.rawValuePropertyName!=undefined){a[l.rawValuePropertyName]=null}if(l.formattedValuePropertyName!=undefined){a[l.formattedValuePropertyName]="*"}}if(s){if(!l.unitPropertyName||s.indexOf(l.unitPropertyName)==-1){o.push(l.rawValuePropertyName||l.name)}}}for(var d=0;d<i.length;d++){if(s.indexOf(i[d])!=-1){a[i[d]]="*"}}var h="";for(var p=0;p<this.aAllDimensionSortedByName.length;p++){var f=b._getDimensionValue(a[this.aAllDimensionSortedByName[p]]);var g=f===""?'""':f;g=g===undefined?"":g;h+=encodeURIComponent(g)+","}h+="-multiple-units-not-dereferencable|"+this._iId;var y;if(this.mMultiUnitKey[e]&&(y=this.mMultiUnitKey[e].indexOf(h))!=-1){return{oEntry:this.oModel.getObject("/"+h),bIsNewEntry:false,iIndex:y,aReloadMeasurePropertyName:o}}a.__metadata.uri=h;delete a.__metadata["self"];delete a.__metadata["self_link_extensions"];a["^~volatile"]=true;this.oModel._importData(a,{},{});var c=this.oModel._getKey(a);this.oModel.getContext("/"+c)["_volatile"]=true;return{oEntry:a,bIsNewEntry:true,aReloadMeasurePropertyName:o}};b.prototype._clearAllPendingRequests=function(){this.oPendingRequests={};this.oGroupedRequests={}};b.prototype.resetData=function(e){var t=e?e.getPath():undefined;this._resetData(t)};b.prototype._resetData=function(e){if(e){delete this.mServiceKey[e];delete this.mServiceLength[e];delete this.mServiceFinalLength[e];delete this.mKeyIndex[e];delete this.mLength[e];delete this.mMultiUnitKey[e];delete this.mEntityKey[e]}else{this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mFinalLength=this.mServiceFinalLength;this.mKeyIndex={};this.mLength={};this.mMultiUnitKey={};this.mEntityKey={};this.aBatchRequestQueue=[]}};b.prototype.refresh=function(e){b.prototype._refresh.apply(this,arguments)};b.prototype._refresh=function(e,t,i){var r=false;if(!e){if(i){var n=this.getResolvedPath();var a=this.oModel.oMetadata._getEntityTypeByPath(n);if(a&&a.entityType in i){r=true}}if(t&&!r){s(this.mServiceKey,function(e,i){s(i,function(e,i){if(i in t){r=true;return false}return true});if(r){return false}return true})}if(!t&&!i){r=true}}if(e||r){this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this.bNeedsUpdate=false;this._fireRefresh({reason:u.Refresh})}};b.prototype.checkUpdate=function(e,t){var i=false;if(!e){if(this.bNeedsUpdate||!t){i=true}else{s(this.mServiceKey,function(e,r){s(r,function(e,r){if(r in t){i=true;return false}return true});if(i){return false}return true})}}if(e||i){this.bNeedsUpdate=false;this._fireChange({reason:u.Change})}};b.prototype.getDownloadUrl=function(e){var i,r,s;var n=new t.QueryResultRequest(this.oAnalyticalQueryResult);n.setResourcePath(this._getResourcePath());var a=[];var o=[];for(var u in this.oDimensionDetailsSet){a.push(u)}n.setAggregationLevel(a);for(var l in this.oDimensionDetailsSet){var d=this.oDimensionDetailsSet[l];var h=d.textPropertyName!=undefined;n.includeDimensionKeyTextAttributes(d.name,true,h,d.aAttributeName)}for(var p in this.oMeasureDetailsSet){o.push(p)}n.setMeasures(o);for(var f in this.oMeasureDetailsSet){var g=this.oMeasureDetailsSet[f];var y=g.rawValuePropertyName!=undefined;var c=g.formattedValuePropertyName!=undefined;var v=g.unitPropertyName!=undefined;n.includeMeasureRawFormattedValueUnit(g.name,y,c,v)}var m=n.getSortExpression();m.clear();for(var _=0;_<this.aSorter.length;_++){if(this.aSorter[_]){m.addSorter(this.aSorter[_].sPath,this.aSorter[_].bDescending?t.SortOrder.Descending:t.SortOrder.Ascending)}}var I=n.getFilterExpression();I.clear();if(this.aApplicationFilter){I.addUI5FilterConditions(this.aApplicationFilter)}if(this.aControlFilter){I.addUI5FilterConditions(this.aControlFilter)}var R=n.getURIToQueryResultEntitySet();var M=this._getQueryODataRequestOptions(n,true);if(!M){return undefined}var q=[];for(var b=0,x=this.aAnalyticalInfo.length;b<x;b++){var S=this.aAnalyticalInfo[b];if((S.visible||S.inResult)&&S.name!==""&&S.name!==q[q.length-1]){q.push(S.name);if(this.oMeasureDetailsSet[S.name]!=undefined&&this.oMeasureDetailsSet[S.name].unitPropertyName!=undefined){q.push(this.oMeasureDetailsSet[S.name].unitPropertyName)}}}for(var A=0,P=M.length;A<P;A++){if(/^\$select/i.test(M[A])){if(this.mParameters.select){i=M[A].slice(8).split(",");for(s=0;s<i.length;s++){r=i[s];if(q.indexOf(r)===-1){q.push(r)}}}M[A]="$select="+q.join(",");break}}if(e){M.splice(0,0,"$format="+encodeURIComponent(e))}if(this.sCustomParams){M.push(this.sCustomParams)}if(R){return this.oModel._createRequestUrl(R,null,M).replace(/ /g,"%20")}return undefined};b.prototype._addSorters=function(e,t){if(this._canApplySortersToGroups()){this.aSorter.forEach(t=>{b._addSorter(t,e)});t.forEach(t=>{b._addSorter(t,e,true)});return}this._mergeAndAddSorters(t,e)};b._addSorter=function(e,i,r){i.addSorter(e.sPath,e.bDescending?t.SortOrder.Descending:t.SortOrder.Ascending,r)};b.prototype._mergeAndAddSorters=function(e,t){const i=this.aSorter.slice();e.forEach(e=>{const r=e.sPath;for(let e=0;e<i.length;e+=1){const s=i[e];const n=s.sPath;if(n===r||this.oDimensionDetailsSet[r].textPropertyName===n){b._addSorter(s,t);i.splice(e,1);break}}b._addSorter(e,t,true)});i.forEach(e=>{b._addSorter(e,t,true)})};b.prototype._canApplySortersToGroups=function(){var e=this._autoExpandMode;if(this.bApplySortersToGroups){if(this.aSorter.length>0){if(e!==this.sLastAutoExpandMode&&e!==g.Sequential){I.warning("Applying sorters to groups is only possible with auto"+" expand mode 'Sequential'; current mode is: "+e,this.sPath)}this.sLastAutoExpandMode=e}return e===g.Sequential}return false};b.prototype._warnNoSortingOfGroups=function(e){var t;if(this.bApplySortersToGroups){t="Detected a multi-unit case, so sorting is only possible on leaves";if(e){t+="; "+e}I.warning(t,this.sPath)}this.bApplySortersToGroups=false};b.prototype._isSkippingTotalForMeasure=function(e){var t=this.mAnalyticalInfoByProperty[e];return!!t&&t.total==false};b._updateDimensionDetailsTextProperty=function(e,t,i){const r=e.getTextProperty();if(r&&r.name===t){i.textPropertyName=t}};b._getDimensionValue=function(e){if(e&&e.__edmType==="Edm.Time"){e=e.ms}return e};b._getDeviatingUnitPropertyNames=function(e,t){var i=[];e.forEach(function(e){for(var r=1;r<t.length;r+=1){if(t[r-1][e]!=t[r][e]){i.push(e);break}}});return i};b.Logger=I;return b});
//# sourceMappingURL=AnalyticalBinding.js.map