/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/core/format/NumberFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/odata/type/ODataType"],function(e,t,a,o,r,n){"use strict";function i(){return sap.ui.getCore().getLibraryResourceBundle().getText("EnterNumber")}function s(e){return!e.oConstraints||e.oConstraints.nullable!==false}function l(t,a){var o;t.oConstraints=undefined;if(a){o=a.nullable;if(o===false||o==="false"){t.oConstraints={nullable:false}}else if(o!==undefined&&o!==true&&o!=="true"){e.warning("Illegal nullable: "+o,null,t.getName())}}t._handleLocalizationChange()}var u=n.extend("sap.ui.model.odata.type.Double",{constructor:function(e,t){n.apply(this,arguments);this.oFormatOptions=e;l(this,t);this.checkParseEmptyValueToZero()}});u.prototype.formatValue=function(e,t){var o,r;if(e===null||e===undefined){return null}if(typeof e==="number"){r=e}else if(typeof e==="string"){r=parseFloat(e)}else if(t!=="any"){throw new a("Illegal "+this.getName()+" value: "+e)}switch(this.getPrimitiveType(t)){case"any":return e;case"float":return r;case"int":return Math.floor(r);case"string":if(r&&(Math.abs(r)>=1e15||Math.abs(r)<1e-4)){o=this.getFormat().oFormatOptions;return r.toExponential().replace("e"," E").replace(".",o.decimalSeparator).replace("+",o.plusSign).replace("-",o.minusSign)}return this.getFormat().format(r);default:throw new a("Don't know how to format "+this.getName()+" to "+t)}};u.prototype.getFormat=function(){if(!this.oFormat){var e={groupingEnabled:true},a=this.oFormatOptions||{};if(a.style!=="short"&&a.style!=="long"){e.preserveDecimals=true}Object.assign(e,this.oFormatOptions);delete e.parseEmptyValueToZero;this.oFormat=t.getFloatInstance(e)}return this.oFormat};u.prototype.parseValue=function(e,t){var a=this.getEmptyValue(e,true);if(a!==undefined){return a}var r;switch(this.getPrimitiveType(t)){case"string":r=this.getFormat().parse(e);if(isNaN(r)){throw new o(i())}break;case"int":case"float":r=e;break;default:throw new o("Don't know how to parse "+this.getName()+" from "+t)}return r};u.prototype._handleLocalizationChange=function(){this.oFormat=null};u.prototype.validateValue=function(e){if(e===null&&s(this)){return}if(typeof e==="number"){return}throw new r(i())};u.prototype.getName=function(){return"sap.ui.model.odata.type.Double"};return u});
//# sourceMappingURL=Double.js.map