/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/core/format/NumberFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/odata/type/ODataType"],function(t,e,o,a,n,r){"use strict";function i(){return sap.ui.getCore().getLibraryResourceBundle().getText("EnterNumber")}function s(t){return!t.oConstraints||t.oConstraints.nullable!==false}function u(e,o){var a;e.oConstraints=undefined;if(o){a=o.nullable;if(a===false||a==="false"){e.oConstraints={nullable:false}}else if(a!==undefined&&a!==true&&a!=="true"){t.warning("Illegal nullable: "+a,null,e.getName())}}e._handleLocalizationChange()}var l=r.extend("sap.ui.model.odata.type.Single",{constructor:function(t,e){r.apply(this,arguments);this.oFormatOptions=t;u(this,e);this.checkParseEmptyValueToZero()}});l.prototype.formatValue=function(t,e){var a;if(t===null||t===undefined){return null}if(typeof t==="number"){a=t}else if(typeof t==="string"){a=parseFloat(t)}else if(e!=="any"){throw new o("Illegal "+this.getName()+" value: "+t)}switch(this.getPrimitiveType(e)){case"any":return t;case"float":return a;case"int":return Math.floor(a);case"string":return this.getFormat().format(parseFloat(a.toPrecision(7)));default:throw new o("Don't know how to format "+this.getName()+" to "+e)}};l.prototype.getFormat=function(){if(!this.oFormat){var t={groupingEnabled:true},o=this.oFormatOptions||{};if(o.style!=="short"&&o.style!=="long"){t.preserveDecimals=true}Object.assign(t,this.oFormatOptions);delete t.parseEmptyValueToZero;this.oFormat=e.getFloatInstance(t)}return this.oFormat};l.prototype.parseValue=function(t,e){var o=this.getEmptyValue(t,true);if(o!==undefined){return o}switch(this.getPrimitiveType(e)){case"string":var n=this.getFormat().parse(t);if(isNaN(n)){throw new a(i())}return Math.fround(n);case"int":case"float":return Math.fround(t);default:throw new a("Don't know how to parse "+this.getName()+" from "+e)}};l.prototype._handleLocalizationChange=function(){this.oFormat=null};l.prototype.validateValue=function(t){if(t===null&&s(this)){return}if(typeof t==="number"){return}throw new n(i())};l.prototype.getName=function(){return"sap.ui.model.odata.type.Single"};return l});
//# sourceMappingURL=Single.js.map