/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/rta/appVariant/AppVariantDialog","sap/ui/rta/appVariant/AppVariantUtils","sap/ui/rta/appVariant/Feature","sap/ui/rta/appVariant/S4HanaCloudBackend"],function(e,t,a,n,r){"use strict";var i=e.extend("sap.ui.rta.appVariant.AppVariantManager",{metadata:{library:"sap.ui.rta",properties:{commandSerializer:{type:"object"},layer:{type:"string"}}}});i.prototype._openDialog=function(e,a){var n=new t("appVariantDialog");n.attachCreate(e);n.attachCancel(a);n.attachAfterClose(function(){this.destroy()});n.open();return n};i.prototype._prepareAppVariantData=function(e,t){return{referenceAppId:e["sap.app"].id,title:t.title,subTitle:t.subTitle,description:t.description,icon:t.icon,inbounds:e["sap.app"].crossNavigation&&e["sap.app"].crossNavigation.inbounds?e["sap.app"].crossNavigation.inbounds:null}};i.prototype.createAllInlineChanges=function(e,t){var n=a.getId(e.referenceAppId);var r=[];var i={};i.content=a.prepareTextsChange("title",e.title);r.push(a.createInlineChange(i,"appdescr_app_setTitle",t));i.content=a.prepareTextsChange("subtitle",e.subTitle);r.push(a.createInlineChange(i,"appdescr_app_setSubTitle",t));i.content=a.prepareTextsChange("description",e.description);r.push(a.createInlineChange(i,"appdescr_app_setDescription",t));i=a.getInlineChangeInputIcon(e.icon);r.push(a.createInlineChange(i,"appdescr_ui_setIcon",t));return a.getInboundInfo(e.inbounds).then(function(p){var o=p.currentRunningInbound;if(p.addNewInboundRequired){var s=a.prepareAddNewInboundChange(o,n,e).then(function(e){return a.createInlineChange(e,"appdescr_app_addNewInbound",t)});r.push(s)}else{i=a.prepareChangeInboundChange(o,n,e);r.push(a.createInlineChange(i,"appdescr_app_changeInbound",t))}i=a.prepareRemoveAllInboundsExceptOneChange(o);r.push(a.createInlineChange(i,"appdescr_app_removeAllInboundsExceptOne",t));return Promise.all(r)})};i.prototype.createAppVariant=function(e,t){var n={id:e,layer:this.getLayer()};return a.createAppVariant(t,n)};i.prototype.deleteAppVariant=function(e){return a.deleteAppVariant({appId:e},this.getLayer())};i.prototype.processSaveAsDialog=function(e,t){return new Promise(function(a,r){var i=function(t){var n=t.getParameters();var r=this._prepareAppVariantData(e,n);a(r)}.bind(this);var p=function(){if(!t){return n.onGetOverview(true,this.getLayer())}r()}.bind(this);return this._openDialog(i,p)}.bind(this))};i.prototype._clearRTACommandStack=function(){return this.getCommandSerializer().clearCommandStack()};i.prototype.clearRTACommandStack=function(e){var t=this.getCommandSerializer().getCommandStack();if(e&&t.getAllExecutedCommands().length){return this._clearRTACommandStack()}return Promise.resolve()};i.prototype.triggerCatalogPublishing=function(e,t,n){var r=n?a.triggerCatalogAssignment:a.triggerCatalogUnAssignment;return r(e,this.getLayer(),t).catch(function(t){var r=n?"MSG_CATALOG_ASSIGNMENT_FAILED":"MSG_DELETE_APP_VARIANT_FAILED";return a.catchErrorDialog(t,r,e)})};i.prototype.notifyKeyUserWhenPublishingIsReady=function(e,t,n){var i=new r;return i.notifyFlpCustomizingIsReady(e,n).catch(function(e){var r=n?"MSG_TILE_CREATION_FAILED":"MSG_DELETE_APP_VARIANT_FAILED";if(!n&&e.error==="locked"){r="MSG_CATALOGS_LOCKED"}return a.catchErrorDialog(e,r,t)})};i.prototype.showSuccessMessage=function(e){return a.showRelevantDialog(e,true)};return i},true);
//# sourceMappingURL=AppVariantManager.js.map