/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/core/Element","sap/ui/core/EventBus","sap/ui/rta/plugin/Plugin","sap/ui/rta/util/validateText","sap/ui/dt/Overlay","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/rta/Utils","sap/ui/dt/DOMUtil","sap/ui/events/KeyCodes","sap/ui/dt/OverlayUtil"],function(jQuery,e,t,i,a,l,o,s,r,d,n,h,_){"use strict";var E=" ";var v={errorStyleClass:"sapUiRtaErrorBg",_manageClickEvent(e){var t=e.getSource?e.getSource():e;if(t.isSelected()&&this.isRenameAvailable(t)&&this.isRenameEnabled([t])){t.attachBrowserEvent("click",v._onClick,this)}else{t.detachBrowserEvent("click",v._onClick,this)}},_setEditableFieldPosition(){if(this._oEditableField){jQuery(this._oEditableField).offset({left:n.getOffset(this._oEditableControlDomRef).left});jQuery(this._oEditableField).offset({top:n.getOffset(this._oEditableControlDomRef).top});this._oEditedOverlay.setSelected(true);this._oEditableField.focus()}},startEdit(t){this.setBusy(true);this._oEditedOverlay=t.overlay;this._bPreviouslyMovable=this._oEditedOverlay.getMovable();this._oEditedOverlay.setMovable(false);_.setFirstParentMovable(this._oEditedOverlay,false);var a=t.overlay.getElement();var l=this._oEditedOverlay.getDesignTimeMetadata();var h=l.getAssociatedDomRef(a,t.domRef);if(!d.isElementInViewport(h)){h.get(0).scrollIntoView()}this._oEditableControlDomRef=h.get(0);var E=typeof t.getTextMutators==="function"?t.getTextMutators(a):{getText:function(){return this._oEditableControlDomRef.textContent}.bind(this),setText:function(e){this._oEditableControlDomRef.textContent=e}.bind(this)};this._fnGetControlText=E.getText;this._fnSetControlText=E.setText;var b=0;var c=r.getOverlay(h.jquery?h.get(0).id:h.id);if(!c){c=this._oEditedOverlay;var f=s.getDomRef(a);var u=this._oEditableControlDomRef.parentNode;var y=f?parseInt(f.offsetWidth):"NaN";if(!isNaN(y)){var g=parseInt(this._oEditableControlDomRef.offsetWidth);var p=parseInt(u.offsetWidth);b=y-g;var m=Array.from(u.children);var F=m.filter(function(e){return n.isVisible(e)});if(b<0&&p){if(u.id!==f.id&&F.length===1&&F[0].id===this._oEditableControlDomRef.id&&y>p){b=y-p}else{b=0}}}}var C=document.createElement("div");C.classList.add("sapUiRtaEditableField");C.style.whiteSpace="nowrap";C.style.overflow="hidden";C.style.width=`calc(100% - (${b}px))`;c.getDomRef().append(C);var S=document.createElement("div");S.setAttribute("contentEditable","true");C.append(S);this._oEditableField=S;var O=this._fnGetControlText();if(O===""){this._fnSetControlText("_?_");this._oEditableField.textContent=""}else{this._oEditableField.textContent=O}this.setOldValue(v._getCurrentEditableFieldText.call(this));n.copyComputedStyle(this._oEditableControlDomRef,this._oEditableField);while(this._oEditableField.lastElementChild){this._oEditableField.removeChild(this._oEditableField.lastElementChild)}this._oEditableField.style.visibility="hidden";this._oEditableField.style["-moz-user-modify"]="read-write";this._oEditableField.style["-webkit-user-modify"]="read-write";this._oEditableField.style["-ms-user-modify"]="read-write";this._oEditableField.style["user-modify"]="read-write";this._oEditableField.style.userSelect="text";this._oEditableField.style["-webkit-user-select"]="text";this._oEditableField.style.textOverflow="clip";this._oEditableField.style.whiteSpace="nowrap";if(e.browser.name==="ed"&&a.getMetadata().getName()==="sap.ui.fl.variants.VariantManagement"){this._oEditableField.style.lineHeight="normal"}o.getMutationObserver().ignoreOnce({target:this._oEditableControlDomRef});this._FocusHandler=v._onEditableFieldFocus.bind(this);this._oBlurHandler=v._onEditableFieldBlur.bind(this);this._oKeyDownHandler=v._onEditableFieldKeydown.bind(this);this._oStopPropagationHandler=v._stopPropagation.bind(this);this._oEditableField.addEventListener("focus",this._FocusHandler,{once:true});this._oEditableField.addEventListener("blur",this._oBlurHandler);this._oEditableField.addEventListener("keydown",this._oKeyDownHandler);this._oEditableField.addEventListener("dragstart",this._oStopPropagationHandler);this._oEditableField.addEventListener("drag",this._oStopPropagationHandler);this._oEditableField.addEventListener("dragend",this._oStopPropagationHandler);this._oEditableField.addEventListener("click",this._oStopPropagationHandler);this._oEditableField.addEventListener("mousedown",this._oStopPropagationHandler);this._oEditableControlDomRef.style.visibility="hidden";jQuery(C).offset({left:n.getOffset(this._oEditableControlDomRef).left});v._setEditableFieldPosition.apply(this);this._oEditableField.style.visibility="";this._oEditableField.focus();this._aOverlaysWithScrollbar=_.findParentOverlaysWithScrollbar(c);this._aOverlaysWithScrollbar.forEach(function(e){e.attachScrollSynced(v._setEditableFieldPosition,this)}.bind(this));t.overlay.setSelected(true);i.getInstance().publish("sap.ui.rta",t.pluginMethodName,{overlay:t.overlay,editableField:this._oEditableField})},_setDesignTime(...e){const[t]=e;this._aSelection=[];var i=this.getDesignTime();if(i){i.getSelectionManager().detachChange(v._onDesignTimeSelectionChange,this)}a.prototype.setDesignTime.apply(this,e);if(t){t.getSelectionManager().attachChange(v._onDesignTimeSelectionChange,this);this._aSelection=this.getSelectedOverlays()}},_onDesignTimeSelectionChange(e){var t=e.getParameter("selection");this._aSelection.forEach(v._manageClickEvent,this);t.forEach(v._manageClickEvent,this);this._aSelection=t},_stopPropagation(e){e.stopPropagation()},_preventDefault(e){e.preventDefault()},_onEditableFieldFocus(e){var t=e.target;var i=document.createRange();i.selectNodeContents(t);var a=window.getSelection();a.removeAllRanges();a.addRange(i)},_stopEdit(e,t){var a;this.setBusy(false);this._oEditableField.removeEventListener("blur",this._oBlurHandler);this._oEditableField.removeEventListener("focus",this._FocusHandler);this._oEditableField.removeEventListener("keydown",this._oKeyDownHandler);this._oEditableField.removeEventListener("dragstart",this._oStopPropagationHandler);this._oEditableField.removeEventListener("drag",this._oStopPropagationHandler);this._oEditableField.removeEventListener("dragend",this._oStopPropagationHandler);this._oEditableField.removeEventListener("click",this._oStopPropagationHandler);this._oEditableField.removeEventListener("mousedown",this._oStopPropagationHandler);if(this._fnGetControlText()==="_?_"){this._fnSetControlText("")}o.getMutationObserver().ignoreOnce({target:this._oEditableControlDomRef});this._oEditableControlDomRef.style.visibility="visible";if(e){a=this._oEditedOverlay;a.setSelected(true);a.focus()}this._aOverlaysWithScrollbar.forEach(function(e){e.detachScrollSynced(v._setEditableFieldPosition,this)}.bind(this));delete this._oEditableField;var l=this._oEditedOverlay.getDomRef()&&this._oEditedOverlay.getDomRef().querySelector(".sapUiRtaEditableField");if(l){l.remove()}this._oEditedOverlay.setMovable(this._bPreviouslyMovable);_.setFirstParentMovable(this._oEditedOverlay,true);delete this._oEditableControlDomRef;delete this._oEditedOverlay;delete this._bBlurOrKeyDownStarted;delete this._fnGetControlText;delete this._fnSetControlText;i.getInstance().publish("sap.ui.rta",t,{overlay:a})},_onEditableFieldBlur(e){return v._handlePostRename.call(this,false,e)},_handlePostRename(e,t){if(!this._bBlurOrKeyDownStarted){this._oEditedOverlay.removeStyleClass(v.errorStyleClass);this._bBlurOrKeyDownStarted=true;if(t){v._preventDefault.call(this,t);v._stopPropagation.call(this,t)}return Promise.resolve().then(v._validateNewText.bind(this)).then(this._emitLabelChangeEvent.bind(this)).catch(function(e){if(e.message==="sameTextError"){return}throw e}).then(function(t){this.stopEdit(e);if(typeof t==="function"){t()}}.bind(this)).catch(function(t){return v._handleInvalidRename.call(this,t.message,e)}.bind(this))}return Promise.resolve()},_handleInvalidRename(e,t){return d.showMessageBox("error",e,{titleKey:"RENAME_ERROR_TITLE"}).then(function(){var e=this._oEditedOverlay;e.setIgnoreEnterKeyUpOnce(false);e.addStyleClass(v.errorStyleClass);this.stopEdit(t);this.startEdit(e)}.bind(this))},_validateNewText(){var e=this.getResponsibleElementOverlay(this._oEditedOverlay);var t=this.getAction(e);var i=v._getCurrentEditableFieldText.call(this);l(i,this.getOldValue(),t)},_onEditableFieldKeydown(e){switch(e.keyCode){case h.ENTER:this._oEditedOverlay.setIgnoreEnterKeyUpOnce(true);return v._handlePostRename.call(this,true,e);case h.ESCAPE:this._oEditedOverlay.removeStyleClass(v.errorStyleClass);this.stopEdit(true);v._preventDefault.call(this,e);break;case h.DELETE:case h.BACKSPACE:v._stopPropagation.call(this,e);break;default:}return Promise.resolve()},_getCurrentEditableFieldText(){var e=this._oEditableField?this._oEditableField.textContent.trim():"";return e===""?E:e},_onClick(e){var i=t.getElementById(e.currentTarget.id);if(this.isRenameEnabled([i])&&!e.metaKey&&!e.ctrlKey&&!e.shiftKey){this.startEdit(i);v._preventDefault.call(this,e)}},_exit(){if(this._oEditableControlDomRef){this.stopEdit(false)}}};return v},true);
//# sourceMappingURL=RenameHandler.js.map