/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/m/Popover","sap/m/Text","sap/m/Token","sap/ui/core/mvc/Controller","sap/ui/core/Element","sap/ui/core/library","sap/ui/rta/util/validateText","sap/ui/rta/Utils","sap/ui/fl/util/IFrame","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/rta/plugin/iframe/urlCleaner"],function(e,t,r,a,i,o,s,n,l,d,u,v,g){"use strict";var{ValueState:p}=s;var h=["frameUrl","title"];var m=["frameWidth","frameHeight"];var c=["frameWidthUnit","frameHeightUnit","useLegacyNavigation","advancedSettings"];function _(e){return d.isValidUrl(encodeURI(e))}function S(e){const t=e.text;return new a({key:t,text:t})}return i.extend("sap.ui.rta.plugin.iframe.AddIFrameDialogController",{constructor:function(e,t){this._oJSONModel=e;this._importSettings(t);this._mParameterHashMap=this._buildParameterHashMap(t)},configureMultiInput(){const e=o.getElementById("sapUiRtaAddIFrameDialog_AddAdditionalParametersInput");e.addValidator(S)},onSwitchChange(){this._oJSONModel.setProperty("/settingsUpdate/value",true)},onTokenUpdate(e){let t=this._oJSONModel.getProperty("/advancedSettings/value/additionalSandboxParameters");if(e.getParameter("type")==="added"){e.getParameter("addedTokens").forEach(function(e){t=[...t,e.getText()]})}else if(e.getParameter("type")==="removed"){e.getParameter("removedTokens").forEach(function(e){t=t.filter(function(t){return t!==e.getText()})})}this._oJSONModel.setProperty("/advancedSettings/value/additionalSandboxParameters",t);this._oJSONModel.setProperty("/settingsUpdate/value",true)},onValidationSuccess(e){e.getSource().setValueState(p.None);this._oJSONModel.setProperty("/areAllFieldsValid",this._areAllTextFieldsValid()&&this._areAllValueStateNones())},onValidationError(e){e.getSource().setValueState(p.Error);this._oJSONModel.setProperty("/areAllFieldsValid",false);this._setFocusOnInvalidInput()},onSavePress(){var e=this._buildPreviewURL(this._buildReturnedURL());if(_(e)&&this._areAllTextFieldsValid()&&this._areAllValueStateNones()){this._close(this._buildReturnedSettings())}else{this._setFocusOnInvalidInput()}},onShowPreview(){var t=this._buildPreviewURL(this._buildReturnedURL());if(!_(t)){return}var r=o.getElementById("sapUiRtaAddIFrameDialog_PreviewFrame");var a=o.getElementById("sapUiRtaAddIFrameDialog_PreviewLinkPanel");var i=a.getDependents()[0];if(t){i.setEnabled(true)}else{a.setExpanded(false);i.setEnabled(false)}try{this._oJSONModel.setProperty("/previewUrl/value",t);this._oJSONModel.setProperty("/previewUseLegacyNavigation/value",this._oJSONModel.getProperty("/useLegacyNavigation/value"));r.setUrl(t);this._oJSONModel.setProperty("/settingsUpdate/value",false);r.applySettings({url:t,advancedSettings:{...this._oJSONModel.getProperty("/advancedSettings/value")}})}catch(t){e.error("Error previewing the URL: ",t)}},onParameterPress(e){var t=e.getSource().getBindingContext().getObject().key;this._oJSONModel.setProperty("/frameUrl/value",this._addURLParameter(t));this.onUrlChange()},onLiveChange(e){var t=new u("label",v.Contains,e.getParameter("newValue"));var r=o.getElementById("sapUiRtaAddIFrameDialog_ParameterTable").getBinding("items");r.filter([t])},onLegacyNavigationInfoPress(e){const a=e.getSource();if(!this._oPopover){this._oPopover=new t(`${a.getId()}-popover`,{showHeader:false,contentWidth:"400px",content:[new r({text:"{/text/useLegacyNavigationInfo}"}).addStyleClass("sapUiSmallMargin")]});a.addDependent(this._oPopover)}this._oPopover.openBy(a)},_buildPreviewURL(e){return e.replace(/{(.*?)}/g,function(e){return this._mParameterHashMap[e]}.bind(this))},_addURLParameter(e){return this._buildReturnedURL()+e},_buildReturnedURL(){return g(this._oJSONModel.getProperty("/frameUrl/value"))},onUrlChange(){var e=this._buildPreviewURL(this._buildReturnedURL());var t=o.getElementById("sapUiRtaAddIFrameDialog_EditUrlTA");if(_(e)){t.setValueState("None")}else{t.setValueState("Error")}},_buildParameterHashMap(e){if(e&&e.parameters){return l.buildHashMapFromArray(e.parameters,"key","value")}return{}},onCancelPress(){this._close()},onContainerTitleChange(e){var t=e.getSource();var r="None";var a=false;var i=t.getValue();if(i.trim()===""){r="Error";t.setValueState(r);a=true;return a}try{n(i)}catch(e){r="Error";a=true}t.setValueState(r);return a},_close(e){var t=o.getElementById("sapUiRtaAddIFrameDialog");this._mSettings=e;t.close()},getSettings(){return this._mSettings},_areAllValueStateNones(){var e=this._oJSONModel.getData();return h.concat(m).every(function(t){return e[t].valueState===p.None},this)},_areAllTextFieldsValid(){var e=this._oJSONModel;var t=this._oJSONModel.getProperty("asContainer/value");return h.reduce(function(r,a){if(a==="title"&&!t){return true}var i=`/${a}/value`;var o;if(e.getProperty(i).trim()===""){o=p.Error}else{o=p.None}e.setProperty(`${i}State`,o);return r&&o===p.None},true)},_buildReturnedSettings(){var e={};var t=this._oJSONModel.getData();h.concat(m,c).forEach(function(r){var a=t[r].value;if(r==="frameUrl"){a=g(a)}e[r]=a});return e},_importSettings(e){if(e){Object.keys(e).forEach(function(t){if(t==="frameWidth"||t==="frameHeight"){this._importIFrameSize(t,e[t])}else if(t==="advancedSettings"&&!e[t]){return}else{this._oJSONModel.setProperty(`/${t}/value`,e[t])}},this)}},_importIFrameSize(e,t){var r=t.split(/(px|rem|%|vh)/);if(r.length>=2){this._oJSONModel.setProperty(`/${e}/value`,parseFloat(r[0]));this._oJSONModel.setProperty(`/${e}Unit/value`,r[1])}},_setFocusOnInvalidInput(){var e=this._oJSONModel.getData();m.some(function(t){if(e[t].valueState===p.Error){var r=o.getElementById(e[t].id);r.focus();return true}},this)}})});
//# sourceMappingURL=AddIFrameDialogController.js.map