/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./AdaptationRenderer","sap/base/Log","sap/m/MessageBox","sap/ui/core/BusyIndicator","sap/ui/core/Element","sap/ui/core/Fragment","sap/ui/core/Popup","sap/ui/fl/apply/api/FlexRuntimeInfoAPI","sap/ui/fl/initial/api/Version","sap/ui/fl/write/api/ContextBasedAdaptationsAPI","sap/ui/model/json/JSONModel","sap/ui/performance/Measurement","sap/ui/rta/appVariant/Feature","sap/ui/rta/toolbar/Base","sap/ui/rta/toolbar/contextBased/ManageAdaptations","sap/ui/rta/toolbar/contextBased/SaveAsAdaptation","sap/ui/rta/toolbar/translation/Translation","sap/ui/rta/toolbar/versioning/Versioning","sap/ui/rta/Utils","sap/ui/VersionInfo"],function(t,e,i,o,n,s,r,a,h,c,d,l,u,p,f,g,b,_,m,A){"use strict";var T=p.extend("sap.ui.rta.toolbar.Adaptation",{renderer:t,animation:true,metadata:{library:"sap.ui.rta",events:{undo:{},redo:{},exit:{},save:{},restore:{},publishVersion:{},modeChange:{},activate:{},discardDraft:{},switchVersion:{},switchAdaptation:{},deleteAdaptation:{},openChangeCategorySelectionPopover:{}}}});T.LEFT_SECTION="toolbarIconAndDraftSection";T.MIDDLE_SECTION="toolbarSwitcherSection";T.RIGHT_SECTION="toolbarActionsSection";var I=124;T.prototype.init=function(...t){this._mSizeLimits={switchToIcons:undefined};p.prototype.init.apply(this,t);this._pFragmentLoaded=this._pFragmentLoaded.then(function(){this._onResize=this._onResize.bind(this);window.addEventListener("resize",this._onResize);this._aIntersectionObservers=[]}.bind(this))};T.prototype._calculateWindowWidth=function(t){var e=t[0].intersectionRect.width;return e*2+this._iSwitcherToolbarWidth+80};T.prototype.exit=function(...t){window.removeEventListener("resize",this._onResize);this._aIntersectionObservers.forEach(function(t){t.disconnect()});p.prototype.exit.apply(this,t)};T.prototype._restoreHiddenElements=function(){delete this._iOnResizeAnimationFrame;if(window.innerWidth>this._mSizeLimits.switchToIcons){this._switchToTexts();delete this._mSizeLimits.switchToIcons}};T.prototype._onResize=function(){if(this._iOnResizeAnimationFrame){window.cancelAnimationFrame(this._iOnResizeAnimationFrame)}this._iOnResizeAnimationFrame=window.requestAnimationFrame(this._restoreHiddenElements.bind(this))};T.prototype.initialAdjustToolbarSectionWidths=function(){var t=this.getControl("modeSwitcher").getDomRef().getBoundingClientRect().width;this._iSwitcherToolbarWidthWithTexts=t+16;this._iSwitcherToolbarWidth=this._iSwitcherToolbarWidthWithTexts;this.adjustToolbarSectionWidths()};T.prototype.adjustToolbarSectionWidths=function(){this.getControl(T.MIDDLE_SECTION).setWidth(`${this._iSwitcherToolbarWidth}px`);[T.LEFT_SECTION,T.RIGHT_SECTION].forEach(function(t){this.getControl(t).getDomRef().style.setProperty("width",`calc(50% - ${Math.ceil(this._iSwitcherToolbarWidth/2)}px)`,"important")}.bind(this))};T.prototype._observeIntersections=function(){this._aIntersectionObservers.forEach(function(t){t.disconnect()});[T.LEFT_SECTION,T.RIGHT_SECTION].forEach(function(t){var e=this._createIntersectionObserver(t);this._observeToolbarIntersection(t,e);this._aIntersectionObservers.push(e)}.bind(this))};T.prototype._hideElementsOnIntersection=function(t,e){if(e[0].intersectionRatio===0){this.adjustToolbarSectionWidths();this._observeIntersections();return}if(e[0].intersectionRatio<1){if(!this._mSizeLimits.switchToIcons){this._mSizeLimits.switchToIcons=this._calculateWindowWidth(e);this._switchToIcons()}}};T.prototype._createIntersectionObserver=function(t){return new IntersectionObserver(this._hideElementsOnIntersection.bind(this,t),{threshold:1,root:this.getControl(t).getDomRef()})};T.prototype._observeToolbarIntersection=function(t,e){var i=this.getControl(t);i.getItems().map(function(t){var i=t.getDomRef();e.observe(i)})};T.prototype.show=function(){return p.prototype.show.call(this,this.initialAdjustToolbarSectionWidths.bind(this)).then(function(){this._observeIntersections()}.bind(this))};function v(t,e,i,o){var n=this.getControl(t);var s=i?this.getTextResources().getText(i):"";var r=o?this.getTextResources().getText(o):"";n.setText(s||"");n.setTooltip(r||"");n.setIcon(e||"")}T.prototype.formatPublishVersionVisibility=function(t,e,i,o){return this.getExtension("versioning",_).formatPublishVersionVisibility(t,e,i,o)};T.prototype.formatDiscardDraftVisible=function(t,e,i){return this.getExtension("versioning",_).formatDiscardDraftVisible(t,e,i)};T.prototype.formatVersionButtonText=function(t,e){return this.getExtension("versioning",_).formatVersionButtonText(t,e)};T.prototype.showVersionHistory=function(t){return this.getExtension("versioning",_).showVersionHistory(t)};T.prototype._openVersionTitleDialog=function(t){return this.getExtension("versioning",_).openActivateVersionDialog(t)};T.prototype.showActionsMenu=function(t){var e=t.getSource();if(!this._oActionsMenuFragment){return s.load({id:`${this.getId()}_actionsMenu_fragment`,name:"sap.ui.rta.toolbar.ActionsMenu",controller:{openDownloadTranslationDialog:w.bind(this),openUploadTranslationDialog:D.bind(this),manageApps:P.bind(this),overviewForKeyUser:V.bind(this),overviewForDeveloper:L.bind(this),restore:this.eventHandler.bind(this,"Restore"),formatSaveAsEnabled:S,saveAs:y.bind(this)}}).then(function(t){t.addStyleClass(m.getRtaStyleClassName());this.addDependent(t);t.openBy(e,true,r.Dock.CenterTop,r.Dock.CenterBottom);this._oActionsMenuFragment=t}.bind(this))}this._oActionsMenuFragment.openBy(e,true,r.Dock.CenterTop,r.Dock.CenterBottom);return Promise.resolve()};T.prototype._showButtonIcon=function(t,e,i){v.call(this,t,e,"",i)};T.prototype._showButtonText=function(t,e){v.call(this,t,"",e,"")};T.prototype._switchToIcons=function(){this._showButtonIcon("adaptationSwitcherButton","sap-icon://wrench","BTN_ADAPTATION");this._showButtonIcon("navigationSwitcherButton","sap-icon://explorer","BTN_NAVIGATION");this._showButtonIcon("visualizationSwitcherButton","sap-icon://show","BTN_VISUALIZATION");this._iSwitcherToolbarWidth=I;this.adjustToolbarSectionWidths()};T.prototype._switchToTexts=function(){this._showButtonText("adaptationSwitcherButton","BTN_ADAPTATION");this._showButtonText("navigationSwitcherButton","BTN_NAVIGATION");this._showButtonText("visualizationSwitcherButton","BTN_VISUALIZATION");this._iSwitcherToolbarWidth=this._iSwitcherToolbarWidthWithTexts;this.adjustToolbarSectionWidths()};T.prototype.buildControls=function(){return s.load({name:"sap.ui.rta.toolbar.Adaptation",id:`${this.getId()}_fragment`,controller:{activate:this._openVersionTitleDialog.bind(this),discardDraft:this.eventHandler.bind(this,"DiscardDraft"),formatDiscardDraftVisible:this.formatDiscardDraftVisible.bind(this),formatPublishVersionVisibility:this.formatPublishVersionVisibility.bind(this),modeChange:this.eventHandler.bind(this,"ModeChange"),undo:this.eventHandler.bind(this,"Undo"),redo:this.eventHandler.bind(this,"Redo"),openChangeCategorySelectionPopover:this.eventHandler.bind(this,"OpenChangeCategorySelectionPopover"),saveAsAdaptation:x.bind(this),editAdaptation:E.bind(this),deleteAdaptation:B.bind(this),manageAdaptations:M.bind(this),switchAdaptation:F.bind(this),formatAdaptationsMenuText:N.bind(this),publishVersion:this.eventHandler.bind(this,"PublishVersion"),save:this.eventHandler.bind(this,"Save"),exit:this.eventHandler.bind(this,"Exit"),formatVersionButtonText:this.formatVersionButtonText.bind(this),showVersionHistory:this.showVersionHistory.bind(this),showActionsMenu:this.showActionsMenu.bind(this),showFeedbackForm:this.showFeedbackForm.bind(this)}})};function w(){var t={layer:this.getRtaInformation().flexSettings.layer,selector:this.getRtaInformation().rootControl};this.getExtension("translation",b).openDownloadTranslationDialog(t)}function D(){this.getExtension("translation",b).openUploadTranslationDialog()}function S(t,e){return t&&e!==h.Number.Draft}function y(){u.onSaveAs(true,true,this.getRtaInformation().flexSettings.layer,null)}function R(t){var e=t.commandStack.canSave();return m.showMessageBox("confirm",e?"DAC_DIALOG_MIGRATION_DIRTY_DESCRIPTION":"DAC_DIALOG_MIGRATION_DESCRIPTION",{titleKey:"DAC_DIALOG_MIGRATION_HEADER",actionKeys:["DAC_DIALOG_MIGRATION_HEADER"],showCancel:true}).then(function(o){if(o!==i.Action.CANCEL){if(e){return new Promise(function(t){this.fireEvent("save",{callback:t})}.bind(this)).then(function(){return C.call(this,t)}.bind(this))}return C.call(this,t)}}.bind(this))}function C(t){o.show();l.start("onCBAMigration","Measurement of migration to context-based adaptation");return c.migrate({control:t.rootControl,layer:t.flexSettings.layer}).finally(function(){l.end("onCBAMigration");l.getActive()&&e.info(`onCBAMigration: ${l.getMeasurement("onCBAMigration").time} ms`);o.hide()}).then(m.showMessageBox.bind(undefined,"information","DAC_DIALOG_MIGRATION_SUCCESSFULL_DESCRIPTION",{titleKey:"DAC_DIALOG_MIGRATION_HEADER"})).then(function(){return new Promise(function(t){this.fireEvent("switchAdaptation",{adaptationId:"DEFAULT",callback:t})}.bind(this))}.bind(this)).catch(function(t){e.error(t.stack||t);var i="DAC_DIALOG_MIGRATION_ERROR_DESCRIPTION";var o={titleKey:"DAC_DIALOG_MIGRATION_HEADER",details:t.userMessage||t};m.showMessageBox("error",i,o)})}function x(){var t=this.getRtaInformation();m.checkDraftOverwrite(this.getModel("versions")).then(function(){l.start("onCBACanMigrate","Measurement if its possible to migrate to context-based adaptation");return c.canMigrate({control:t.rootControl,layer:t.flexSettings.layer})}).then(function(i){l.end("onCBACanMigrate");l.getActive()&&e.info(`onCBACanMigrate: ${l.getMeasurement("onCBACanMigrate").time} ms`);if(i){R.call(this,t)}else{this.getExtension("contextBasedSaveAs",g).openAddAdaptationDialog(t.flexSettings.layer)}}.bind(this)).catch(O)}function E(){m.checkDraftOverwrite(this.getModel("versions")).then(function(){this.getExtension("contextBasedSaveAs",g).openAddAdaptationDialog(this.getRtaInformation().flexSettings.layer,true)}.bind(this)).catch(O)}function O(t){if(t!=="cancel"){m.showMessageBox("error","MSG_LREP_TRANSFER_ERROR",{error:t});e.error(`sap.ui.rta: ${t.stack||t.message||t}`)}}function B(){m.checkDraftOverwrite(this.getModel("versions")).then(function(){this.fireEvent("deleteAdaptation")}.bind(this)).catch(O)}function M(){this.getExtension("contextBasedManage",f).openManageAdaptationDialog()}function F(t){this.fireEvent("switchAdaptation",{adaptationId:t})}function N(t,e){if(t>0){if(e===""){return this.getTextResources().getText("TXT_DEFAULT_APP")}return this.getTextResources().getText("BTN_ADAPTING_FOR",[e])}return this.getTextResources().getText("BTN_ADAPTING_FOR_ALL_USERS")}function V(){return u.onGetOverview(true,this.getRtaInformation().flexSettings.layer)}function L(){return u.onGetOverview(false,this.getRtaInformation().flexSettings.layer)}function P(){u.onGetOverview(true,this.getRtaInformation().flexSettings.layer)}T.prototype.getControl=function(t){var e=n.getElementById(`${this.getId()}_fragment--sapUiRta_${t}`);if(!e&&this._oActionsMenuFragment){e=n.getElementById(this._oActionsMenuFragment.getId().replace("sapUiRta_actions","sapUiRta_")+t)}return e};T.prototype.hide=function(...t){this._aIntersectionObservers.forEach(function(t){t.disconnect()});return p.prototype.hide.apply(this,t)};T.prototype.showFeedbackForm=async function(){var t=a.getConfiguredFlexServices()[0].connector;var i="https://sapinsights.eu.qualtrics.com/jfe/form/";var o="SV_4MANxRymEIl9K06";var n=i+o;var r=new URLSearchParams;const h=await A.load();r.set("version",h.version);r.set("feature",t==="KeyUserConnector"?"BTP":"ABAP");var c=new d({url:`${n}?${r.toString()}`});return s.load({name:"sap.ui.rta.toolbar.FeedbackDialog",controller:this}).then(function(t){this._oFeedbackDialog=t;this._oFeedbackDialog.addStyleClass(m.getRtaStyleClassName());this._oFeedbackDialog.setModel(c,"feedbackModel");this._oFeedbackDialog.setModel(this.getModel("i18n"),"i18n");this._oFeedbackDialog.attachEventOnce("afterClose",function(){this._oFeedbackDialog.destroy()}.bind(this));this._oFeedbackDialog.open()}.bind(this)).catch(function(t){e.error("Error loading fragment sap.ui.rta.toolbar.FeedbackDialog: ",t)})};T.prototype.closeFeedbackForm=function(){if(this._oFeedbackDialog){this._oFeedbackDialog.close()}};return T});
//# sourceMappingURL=Adaptation.js.map