/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/Constants","sap/ui/core/date/UI5Date"],function(e,t,i,s){"use strict";var n=function(){this.dStartedAt=null;this.dFinishedAt=null;this.iElapsedTime=0;this._iAllowedTimeout=1e4;this.reset()};n.prototype.reset=function(){this._iTotalProgress=0;this._iCompletedRules=0;this._iTotalRules=0;this._bRunning=false;this._aRulePromices=[]};n.prototype.running=function(){return this._bRunning};n.prototype.start=function(e,i,n){var o,r=this;this.dStartedAt=s.getInstance();this._iTotalRules=e.length;this._bRunning=true;e.forEach(function(e){r._aRulePromices.push(new Promise(function(s){try{o=t.createIssueManagerFacade(e);if(e.async){r._runAsyncRule(o,i,n,e,s)}else{e.check(o,i,n);s();r._updateProgress()}}catch(t){r._handleException(t,e.id,s)}}))});return Promise.all(this._aRulePromices).then(function(){r.reset();r.dFinishedAt=s.getInstance();r.iElapsedTime=r.dFinishedAt.getTime()-r.dStartedAt.getTime()})};n.prototype._handleException=function(t,s,n){var o=t.message||t;var r="["+i.SUPPORT_ASSISTANT_NAME+'] Error while execution rule "'+s+'": '+o;e.error(r);n();this._updateProgress()};n.prototype._updateProgress=function(){this._iCompletedRules++;this._iTotalProgress=Math.ceil(this._iCompletedRules/this._iTotalRules*100);if(this.onNotifyProgress){this.onNotifyProgress(this._iTotalProgress)}};n.prototype._runAsyncRule=function(e,t,i,s,n){var o=this,r=false;var u=setTimeout(function(){r=true;o._handleException("Check function timed out",s.id,n)},this._iAllowedTimeout);new Promise(function(n){s.check(e,t,i,n)}).then(function(){if(!r){clearTimeout(u);n();o._updateProgress()}}).catch(function(e){if(!r){clearTimeout(u);o._handleException(e,s.id,n)}})};n.prototype.getElapsedTimeString=function(){if(!this.iElapsedTime){return""}var e=s.getInstance(null);e.setHours(0,0,0,0);e.setMilliseconds(this.iElapsedTime);var t=[(e.getHours()<10?"0":"")+e.getHours(),(e.getMinutes()<10?"0":"")+e.getMinutes(),(e.getSeconds()<10?"0":"")+e.getSeconds(),e.getMilliseconds()];return t.join(":")};return n});
//# sourceMappingURL=Analyzer.js.map