/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/Device","sap/ui/core/Control","sap/ui/core/util/PasteHelper","sap/ui/model/ChangeReason","sap/ui/model/Filter","sap/ui/model/Sorter","sap/ui/model/BindingMode","./Column","./Row","./library","./utils/TableUtils","./extensions/ExtensionBase","./extensions/Accessibility","./extensions/Keyboard","./extensions/Pointer","./extensions/Scrolling","./extensions/DragAndDrop","./TableRenderer","./rowmodes/Type","./rowmodes/Fixed","./rowmodes/Interactive","./rowmodes/Auto","./plugins/SelectionModelSelection","sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/core/Configuration","sap/ui/core/library"],function(e,t,i,o,n,r,s,a,l,u,d,p,h,g,c,f,y,m,w,b,C,v,R,jQuery,_,S,x){"use strict";var T=u.GroupEventType;var A=u.SelectionMode;var I=u.SelectionBehavior;var B=x.SortOrder;var M=d.Hook.Keys.Table;var F=d.createWeakMapFacade();var D=t.extend("sap.ui.table.Table",{metadata:{library:"sap.ui.table",dnd:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},rowHeight:{type:"int",group:"Appearance",defaultValue:null,deprecated:true},columnHeaderHeight:{type:"int",group:"Appearance",defaultValue:null},columnHeaderVisible:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCount:{type:"int",group:"Appearance",defaultValue:10,deprecated:true},firstVisibleRow:{type:"int",group:"Appearance",defaultValue:0},selectionMode:{type:"sap.ui.table.SelectionMode",group:"Behavior",defaultValue:A.MultiToggle},selectionBehavior:{type:"sap.ui.table.SelectionBehavior",group:"Behavior",defaultValue:I.RowSelector},selectedIndex:{type:"int",group:"Appearance",defaultValue:-1,deprecated:true},editable:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},navigationMode:{type:"sap.ui.table.NavigationMode",group:"Behavior",defaultValue:"Scrollbar",deprecated:true},threshold:{type:"int",group:"Appearance",defaultValue:100},enableColumnReordering:{type:"boolean",group:"Behavior",defaultValue:true},enableGrouping:{type:"boolean",group:"Behavior",defaultValue:false,deprecated:true},showColumnVisibilityMenu:{type:"boolean",group:"Appearance",defaultValue:false},showNoData:{type:"boolean",group:"Appearance",defaultValue:true},visibleRowCountMode:{type:"sap.ui.table.VisibleRowCountMode",group:"Appearance",defaultValue:"Fixed",deprecated:true},minAutoRowCount:{type:"int",group:"Appearance",defaultValue:5,deprecated:true},fixedColumnCount:{type:"int",group:"Appearance",defaultValue:0},fixedRowCount:{type:"int",group:"Appearance",defaultValue:0,deprecated:true},fixedBottomRowCount:{type:"int",group:"Appearance",defaultValue:0,deprecated:true},enableColumnFreeze:{type:"boolean",group:"Behavior",defaultValue:false},enableCellFilter:{type:"boolean",group:"Behavior",defaultValue:false},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},enableSelectAll:{type:"boolean",group:"Behavior",defaultValue:true},enableCustomFilter:{type:"boolean",group:"Behavior",defaultValue:false},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:false},rowActionCount:{type:"int",group:"Appearance",defaultValue:0},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false},rowCountConstraints:{type:"object",visibility:"hidden"}},defaultAggregation:"columns",aggregations:{title:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false,deprecated:true},footer:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false,deprecated:true},extension:{type:"sap.ui.core.Control",multiple:true,singularName:"extension"},columns:{type:"sap.ui.table.Column",multiple:true,singularName:"column",bindable:"bindable",dnd:{layout:"Horizontal"}},rows:{type:"sap.ui.table.Row",multiple:true,singularName:"row",bindable:"bindable",selector:"#{id}-tableCCnt",dnd:true},rowMode:{type:"sap.ui.table.rowmodes.RowMode",multiple:false,altTypes:["sap.ui.table.rowmodes.Type"]},creationRow:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},noData:{type:"sap.ui.core.Control",altTypes:["string"],multiple:false},_noColumnsMessage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},rowActionTemplate:{type:"sap.ui.table.RowAction",multiple:false},rowSettingsTemplate:{type:"sap.ui.table.RowSettings",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false},plugins:{type:"sap.ui.table.plugins.SelectionPlugin",multiple:true,singularName:"plugin",deprecated:true},_messageStrip:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_hiddenDependents:{type:"sap.ui.core.Element",multiple:true,visibility:"hidden"}},associations:{groupBy:{type:"sap.ui.table.Column",multiple:false,deprecated:true},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{rowSelectionChange:{parameters:{rowIndex:{type:"int"},rowContext:{type:"sap.ui.model.Context"},rowIndices:{type:"int[]"},selectAll:{type:"boolean"},userInteraction:{type:"boolean"}}},columnSelect:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},columnResize:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},width:{type:"sap.ui.core.CSSSize"}}},columnMove:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newPos:{type:"int"}}},sort:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},sortOrder:{type:"sap.ui.core.SortOrder"},columnAdded:{type:"boolean"}}},filter:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},group:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}},deprecated:true},columnVisibility:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"},newVisible:{type:"boolean"}}},cellClick:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}}},cellContextmenu:{allowPreventDefault:true,parameters:{cellControl:{type:"sap.ui.core.Control"},cellDomRef:{type:"Object"},rowIndex:{type:"int"},columnIndex:{type:"int"},columnId:{type:"string"},rowBindingContext:{type:"sap.ui.model.Context"}},deprecated:true},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{rowIndex:{type:"int"},columnIndex:{type:"int"},contextMenu:{type:"sap.ui.core.IContextMenu"}}},columnFreeze:{allowPreventDefault:true,parameters:{column:{type:"sap.ui.table.Column"}}},customFilter:{parameters:{column:{type:"sap.ui.table.Column"},value:{type:"string"}}},firstVisibleRowChanged:{parameters:{firstVisibleRow:{type:"int"}}},busyStateChanged:{parameters:{busy:{type:"boolean"}}},paste:{allowPreventDefault:true,parameters:{data:{type:"string[][]"}}},rowsUpdated:{}},designtime:"sap/ui/table/designtime/Table.designtime"},renderer:m});D.prototype.init=function(){this.mSkipPropagation={rowActionTemplate:true,rowSettingsTemplate:true};F(this).iCachedBindingLength=0;F(this).iFirstRenderedRowIndex=0;F(this).iComputedFixedColumnCount=null;this._attachExtensions();this._bRtlMode=S.getRTL();this._bRowsBeingBound=false;this._bContextsAvailable=false;this._aRowClones=[];this._bRowAggregationInvalid=true;this._mTimeouts={};this._mAnimationFrames={};this._setHideStandardTooltips(false);this._aRowHeights=[];this._aSortedColumns=[];this._aTableHeaders=[];this._bAllowColumnHeaderTextSelection=false;F(this).iPendingRequests=0;this._iBindingLength=null;this._bFirstRendering=true;this._nDevicePixelRatio=window.devicePixelRatio;if(sap.ui.getCore().isThemeApplied()){d.readThemeParameters()}this._bInvalid=true};D.prototype.applySettings=function(e,i){if(e){var o=["threshold","firstVisibleRow","rowMode"];var n={};o.push("plugins");for(var r=0;r<o.length;r++){var s=o[r];if(s in e){n[s]=e[s];delete e[s]}}if(Object.keys(n).length>0){t.prototype.applySettings.call(this,n,i)}}this._initLegacySelectionPlugin();U(this);t.prototype.applySettings.call(this,e,i)};D.prototype._attachExtensions=function(){if(this._bExtensionsInitialized){return}p.enrich(this,c);p.enrich(this,f);p.enrich(this,g);p.enrich(this,h);p.enrich(this,y);if(e.os.ios){sap.ui.require(["sap/ui/table/extensions/ScrollingIOS"],function(e){if(!this.bIsDestroyed){p.enrich(this,e)}}.bind(this))}this._bExtensionsInitialized=true};D.prototype.exit=function(){this.invalidateRowsAggregation();this._detachExtensions();this._cleanUpTimers();this._detachEvents();d.Menu.cleanupDefaultContentCellContextMenu(this);K(this);delete this._aTableHeaders};D.prototype._detachExtensions=function(){p.cleanup(this)};D.prototype.onpaste=function(e){if(e.isMarked()||/^(input|textarea)$/i.test(e.target.tagName)||!this.getDomRef("sapUiTableCnt").contains(e.target)){return}var t=i.getPastedDataAs2DArray(e.originalEvent);if(t.length===0||t[0].length===0){return}this.firePaste({data:t})};D.prototype.onThemeChanged=function(){d.readThemeParameters();if(this.getDomRef()){this.invalidate()}};D.prototype.onLocalizationChanged=function(e){var t=e.changes||{};var i=t.hasOwnProperty("rtl");var o=t.hasOwnProperty("language");this._adaptLocalization(i,o).then(function(){this.invalidate()}.bind(this)).catch(function(){})};D.prototype.onlocalizationChanged=D.prototype.onLocalizationChanged;D.prototype._adaptLocalization=function(e,t){if(!e&&!t){return Promise.reject()}var i=Promise.resolve();if(e){this._bRtlMode=S.getRTL()}if(t){i=d.getResourceBundle({async:true,reload:true})}return i.then(function(){if(t){d.Menu.cleanupDefaultContentCellContextMenu(this);this._invalidateColumnMenus()}}.bind(this))};D.prototype._collectRowHeights=function(t){var i=this.getDomRef();if(!i){return[]}var o=this._getBaseRowHeight();var n=t?".sapUiTableColHdrTr":".sapUiTableTr";var r=i.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+n);var s=i.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+n);var a=t?d.getHeaderRowCount(this):this.getRows().length;var l=[];var u=e.browser.chrome&&window.devicePixelRatio!=1;if(t){if(this.getColumnHeaderHeight()>0){o=this.getColumnHeaderHeight()}else if(this.getRowMode()){o=this._getDefaultRowHeight()}}for(var p=0;p<a;p++){var h=r[p]?r[p].getBoundingClientRect().height:0;var g=s[p]?s[p].getBoundingClientRect().height:0;var c=Math.max(h,g);if(u){var f=o-c;if(f>0&&f<1){l.push(Math.max(c,o-1));continue}}l.push(Math.max(c,o))}if(l.length>0&&!t){d.dynamicCall(this._getSyncExtension,function(e){var t=e.syncRowHeights(l.slice());if(t&&t.length===l.length){l=t.slice()}})}return l};D.prototype._resetRowHeights=function(){var e=this._getBaseRowHeight();var t="";if(e){t=e+"px"}var i=this.getDomRef("tableCCnt");if(i){var o=i.querySelectorAll(".sapUiTableTr");for(var n=0;n<o.length;n++){o[n].style.height=t}}};D.prototype._resetColumnHeaderHeights=function(){var e=this.getDomRef();if(e){var t=e.querySelectorAll(".sapUiTableColHdrTr");for(var i=0;i<t.length;i++){t[i].style.height=null}}};D.prototype._collectTableSizes=function(){var e={tableCtrlScrollWidth:0,tableRowHdrScrWidth:0,tableCtrlScrWidth:0,tableCtrlFixedWidth:0,tableCntHeight:0,tableCntWidth:0};var t=this.getDomRef();if(!t){return e}var i=t.querySelector(".sapUiTableCnt");if(i){e.tableCntHeight=i.clientHeight;e.tableCntWidth=i.clientWidth}var o=t.querySelector(".sapUiTableCtrlScroll:not(.sapUiTableCHT)");if(o){e.tableCtrlScrollWidth=o.getBoundingClientRect().width}var n=t.querySelector(".sapUiTableRowHdrScr");if(n){e.tableRowHdrScrWidth=n.clientWidth}var r=t.querySelector(".sapUiTableCtrlScr:not(.sapUiTableCHA)");if(r){e.tableCtrlScrWidth=r.getBoundingClientRect().width}var s=t.querySelector(".sapUiTableCtrlScrFixed:not(.sapUiTableCHA) > .sapUiTableCtrlFixed");if(s){e.tableCtrlFixedWidth=s.clientWidth}var a=this._getSpanBasedComputedFixedColumnCount();var l=0;if(a){var u=this.getColumns();var p=t.querySelectorAll(".sapUiTableCtrlFirstCol:not(.sapUiTableCHTHR) > th");for(var h=0;h<p.length;h++){var g=parseInt(p[h].getAttribute("data-sap-ui-headcolindex"));if(!isNaN(g)&&g<a){var c=u[g];var f;if(c._iFixWidth!=null){f=c._iFixWidth}else{f=p[h].getBoundingClientRect().width}l+=f}}}if(l>0){var y=this._getScrollExtension();var m=e.tableRowHdrScrWidth;var w=y.getVerticalScrollbar();if(w&&!y.isVerticalScrollbarExternal()){m+=w.offsetWidth}if(d.hasRowActions(this)){var b=this.getDomRef("sapUiTableRowActionScr");if(b){m+=b.offsetWidth}}m+=d.Column.getMinColumnWidth();var C=e.tableCntWidth-m;var v=C>l;var R=!v;if(this._bIgnoreFixedColumnCount!==R){this._bIgnoreFixedColumnCount=R;if(this.getEnableColumnFreeze()){this._invalidateColumnMenus()}this.invalidate()}}return e};D.prototype._updateRowHeights=function(e,t){var i=this.getDomRef();if(!i){return}function o(t,i){var o=e[i];if(o){t.style.height=o+"px"}}var n=t?".sapUiTableColHdrTr":".sapUiTableTr";var r=t?[]:i.querySelectorAll(".sapUiTableRowSelectionCell");var s=t?[]:i.querySelectorAll(".sapUiTableRowActionCell");var a=i.querySelectorAll(".sapUiTableCtrlFixed > tbody > tr"+n);var l=i.querySelectorAll(".sapUiTableCtrlScroll > tbody > tr"+n);Array.prototype.forEach.call(r,o);Array.prototype.forEach.call(s,o);Array.prototype.forEach.call(a,o);Array.prototype.forEach.call(l,o)};D.prototype.onBeforeRendering=function(e){this._bInvalid=true;this._detachEvents();if(e&&e.isMarked("renderRows")){return}this._cleanUpTimers();this._aTableHeaders=[]};D.prototype.onAfterRendering=function(e){var t=e&&e.isMarked("renderRows");this._bInvalid=false;this._attachEvents();this._initRowDomRefs();if(!this._bAllowColumnHeaderTextSelection&&!t){this._disableTextSelection(this.$().find(".sapUiTableCHA"))}this.getDomRef().classList.remove("sapUiTableRActFlexible");if(!t){this._aTableHeaders=this.$().find(".sapUiTableColHdrCnt th")}this._updateTableSizes(d.RowsUpdateReason.Render,true);d.registerResizeHandler(this,"Table",this._onTableResize.bind(this));this._bFirstRendering=false};D.prototype.invalidate=function(){this._bInvalid=true;d.Column.invalidateColumnUtils(this);return t.prototype.invalidate.call(this)};D.prototype._initRowDomRefs=function(){var e=this.getRows();for(var t=0;t<e.length;t++){e[t].initDomRefs()}};D.prototype._updateTableSizes=function(e,t){t=t===true;var i=this.getDomRef();if(this._bInvalid||!i||!sap.ui.getCore().isThemeApplied()||i.offsetWidth===0){return}if(!t){this._resetRowHeights();this._resetColumnHeaderHeights()}this._aRowHeights=this._collectRowHeights(false);var o=this._collectRowHeights(true);function n(e){var t=e.getDomRef();var i=d.Column.getMinColumnWidth();var o=[];var n=e.getColumnHeaderVisible();function r(e,t){if(e<=t){return Math.max(e,t-5,i)+"px"}return-1}function s(s){var a=Math.max(s._minWidth||0,i,s.getMinWidth());var l=s.getWidth();var u;var p;var h;if(d.isVariableWidth(l)&&!d.isFixedColumn(e,s.getIndex())){u=t.querySelectorAll('th[data-sap-ui-colid="'+s.getId()+'"]');p=u[n?0:1];h=p?p.offsetWidth:null;if(h!==null){if(h<=a){return{headers:u,newWidth:r(h,a)}}else if(p&&p.style.width!=l){o.push({col:s,header:p,minWidth:a,headers:u});return{headers:u,newWidth:l}}o.push({col:s,header:p,minWidth:a,headers:u})}}return null}function a(e){if(e){Array.prototype.forEach.call(e.headers,function(t){t.style.width=e.newWidth})}}e._getVisibleColumns().map(s).forEach(a);if(o.length){var l;for(var u=0;u<o.length;u++){l=o[u].header&&o[u].header.offsetWidth;o[u].newWidth=r(l,o[u].minWidth);if(parseInt(o[u].newWidth)>=0){a(o[u])}}}}n(this);var r=this._collectTableSizes();this._updateRowHeights(this._aRowHeights,false);this._updateRowHeights(o,true);d.dynamicCall(this._getSyncExtension,function(e){e.syncLayout({top:this.getDomRef("sapUiTableCnt").offsetTop,headerHeight:this.getDomRef().querySelector(".sapUiTableColHdrCnt").getBoundingClientRect().height,contentHeight:this.getDomRef("tableCCnt").getBoundingClientRect().height})},this);var s=this.$();if(d.hasRowActions(this)||d.hasRowNavigationIndicators(this)){var a=s.hasClass("sapUiTableRActFlexible");var l=this.getDomRef("dummycolhdr");if(l){var u=l.clientWidth>2;if(!a&&u){var p=this.getColumns().reduce(function(e,t){var i=t.getDomRef();if(i&&t.getIndex()>=this.getComputedFixedColumnCount()){e+=i.offsetWidth}return e}.bind(this),0);var h=p+r.tableRowHdrScrWidth+r.tableCtrlFixedWidth;var g={};if(!d.hasRowActions(this)){h=h-d.ThemeParameters.navIndicatorWidth+d.BaseBorderWidth}g[this._bRtlMode?"right":"left"]=h;this.$("sapUiTableRowActionScr").css(g);this.$("rowacthdr").css(g);s.toggleClass("sapUiTableRActFlexible",true)}else if(a&&!u){this.$("sapUiTableRowActionScr").removeAttr("style");this.$("rowacthdr").removeAttr("style");s.toggleClass("sapUiTableRActFlexible",false)}}}s.find(".sapUiTableNoOpacity").addBack().removeClass("sapUiTableNoOpacity");d.Hook.call(this,M.UpdateSizes,e)};D.prototype.setShowOverlay=function(e){this.setProperty("showOverlay",e,true);if(this.getDomRef()){this.$().toggleClass("sapUiTableOverlay",this.getShowOverlay());this._getAccExtension().updateAriaStateForOverlayAndNoData();this._getKeyboardExtension().updateNoDataAndOverlayFocus()}return this};D.prototype._updateFixedBottomRows=function(){var e=this.getDomRef();if(!e||this._getRowCounts().fixedBottom===0){return}var t=d.getFirstFixedBottomRowIndex(this);var i=this.getRows();var o;jQuery(e).find(".sapUiTableRowLastScrollable").removeClass("sapUiTableRowLastScrollable");jQuery(e).find(".sapUiTableRowFirstFixedBottom").removeClass("sapUiTableRowFirstFixedBottom");if(t>=0&&t<i.length){o=i[t].getDomRefs(true);o.row.addClass("sapUiTableRowFirstFixedBottom",true)}if(t>=1&&t<i.length){o=i[t-1].getDomRefs(true);o.row.addClass("sapUiTableRowLastScrollable",true)}};D.prototype.focus=function(e){this._oFocusInfo=e;t.prototype.focus.apply(this,arguments);delete this._oFocusInfo};D.prototype.getFocusInfo=function(){var e=this.$().find(":focus").attr("id");if(e){return{customId:e}}else{return t.prototype.getFocusInfo.apply(this,arguments)}};D.prototype.applyFocusInfo=function(e){delete this._bApplyFocusInfoFailed;if(e&&e.customId){if(document.getElementById(e.customId)){jQuery(document.getElementById(e.customId)).trigger("focus")}else{this._bApplyFocusInfoFailed=true}}else{t.prototype.applyFocusInfo.apply(this,arguments)}return this};D.prototype.setTitle=function(e){var t=e;if(typeof e==="string"||e instanceof String){t=d._getTableTemplateHelper().createTextView({text:e});t.addStyleClass("sapUiTableHdrTitle")}this.setAggregation("title",t);return this};D.prototype.setFooter=function(e){var t=e;if(typeof e==="string"||e instanceof String){t=d._getTableTemplateHelper().createTextView({text:e})}this.setAggregation("footer",t);return this};D.prototype.setSelectionMode=function(e){if(e===A.Multi){e=A.MultiToggle;_.warning("The selection mode 'Multi' is deprecated and must not be used anymore."+" Your setting was defaulted to selection mode 'MultiToggle'",this)}if(this._hasSelectionPlugin()){_.error("If a selection plugin is applied to the table, the selection mode is controlled by the plugin.",this)}else{this.setProperty("selectionMode",e);this._getSelectionPlugin().setSelectionMode(e)}return this};D.prototype.setFirstVisibleRow=function(e){if(e==null){e=0}else if(e<0){_.error("The index of the first visible row must be greater than or equal to 0. The value has been set to 0.",this);e=0}else if(this._bContextsAvailable){var t=this._getMaxFirstVisibleRowIndex();if(t<e){_.warning("The index of the first visible row is too high. The value has been set to "+t+".",this);e=t}}this._setFirstVisibleRowIndex(e);return this};D.prototype._setFirstVisibleRowIndex=function(e,t){t=Object.assign({onScroll:false,suppressScrolling:false,suppressEvent:false,forceEvent:false,suppressRendering:false,onlySetProperty:false},t);if(this._bContextsAvailable){e=Math.min(e,this._getMaxFirstVisibleRowIndex())}e=Math.max(0,e);var i=this.getFirstVisibleRow()!==e;var o=this._getFirstRenderedRowIndex();var n=this._bContextsAvailable?Math.min(e,this._getMaxFirstRenderedRowIndex()):e;var r=this._getScrollExtension();this.setProperty("firstVisibleRow",e,true);if(!t.suppressRendering){F(this).iFirstRenderedRowIndex=n}if(t.onlySetProperty){return false}if((i||t.forceEvent)&&!t.suppressEvent){this.fireFirstVisibleRowChanged({firstVisibleRow:e})}if(!this.getBinding()){r.updateVerticalScrollPosition();return false}var s=false;var a=this.getBinding()!=null&&n!==o;if(a){if(!t.suppressRendering){N(this,t.onScroll?d.RowsUpdateReason.VerticalScroll:d.RowsUpdateReason.FirstVisibleRowChange);s=true}if(!t.onScroll&&!t.suppressScrolling){r.updateVerticalScrollPosition(s)}}else if(!t.onScroll&&!t.suppressScrolling){r.updateVerticalScrollPosition(!this._bContextsAvailable)}return s};D.prototype._setFocus=function(e,t){return new Promise(function(i){if(e===-1){e=this._getTotalRowCount()-1}if(typeof e!=="number"||e<-1){e=0}var o=this.getFirstVisibleRow();var n=this._getRowCounts().count;if(e>o&&e<o+n){this.getRows()[e-o]._setFocus(t);return i()}if(this._setFirstVisibleRowIndex(e)){this.attachEventOnce("rowsUpdated",function(){P(this,e,t);return i()})}else{P(this,e,t);return i()}}.bind(this))};function P(e,t,i){var o=e._getTotalRowCount();var n=e._getFirstRenderedRowIndex();e.getRows()[Math.min(t,o-1)-n]._setFocus(i)}D.getMetadata().getAggregation("rows")._doesNotRequireFactory=true;D.prototype.bindAggregation=function(e,i){if(e==="rows"){this._bindRows(V(Array.prototype.slice.call(arguments,1)));return this}return t.prototype.bindAggregation.apply(this,arguments)};D.prototype.bindRows=function(e){this._bindRows(V(arguments));return this};D.prototype._bindRows=function(e){E(this);this._bRowsBeingBound=true;O(this);$(this);D._addBindingListener(e,"change",function(){this._onBindingChange.apply(this,arguments)}.bind(this));D._addBindingListener(e,"dataRequested",function(){this._onBindingDataRequested.apply(this,arguments)}.bind(this));D._addBindingListener(e,"dataReceived",function(){this._onBindingDataReceived.apply(this,arguments)}.bind(this));d.Hook.call(this,M.BindRows,e);t.prototype.bindAggregation.call(this,"rows",e);this._bRowsBeingBound=false};D.prototype._bindAggregation=function(e,i){if(e==="rows"){E(this);this._bRowsBeingBound=true}t.prototype._bindAggregation.call(this,e,i);if(e==="rows"){d.Grouping.setupExperimentalGrouping(this);var o=this.getBinding();var n=o?o.getModel():null;this._bRowsBeingBound=false;d.Hook.call(this,M.RowsBound,o);if(n&&n.getDefaultBindingMode()===s.OneTime){_.error('The binding mode of the model is set to "OneTime".'+' This binding mode is not supported for the "rows" aggregation!'+" Scrolling can not be performed.",this)}}};D.prototype.unbindAggregation=function(e,i){if(e==="rows"){this._unbindRows();return this}return t.prototype.unbindAggregation.apply(this,arguments)};D.prototype.unbindRows=function(){this._unbindRows();return this};D.prototype._unbindRows=function(){var e=this.getBindingInfo("rows");if(e){d.Hook.call(this,M.UnbindRows,e)}t.prototype.unbindAggregation.call(this,"rows",true);if(this._bRowsBeingBound||this.bIsDestroyed||this._bIsBeingDestroyed){return}this._adjustToTotalRowCount();if(e){d.Hook.call(this,M.RowsUnbound)}E(this);$(this)};function E(e){e._bRowsBeingBound=false;e._bContextsAvailable=false;F(e).iPendingRequests=0;e._iBindingLength=null}function V(e){var t;if(e==null||e[0]==null){t={}}else if(typeof e[0]==="string"){var i=e[0];var o=e[1];var s=e[2];var a=e[3];if(o instanceof r||Array.isArray(s)&&s[0]instanceof n){a=s;s=o;o=undefined}t={path:i,sorter:s,filters:a,template:o}}else{t=e[0]}return t}D._addBindingListener=function(e,t,i,o){if(!e.events){e.events={}}var n=e.events[t];e.events[t]=function(){i.apply(o,arguments);if(n){n.apply(this,arguments)}}};D.prototype._onBindingChange=function(e){};D.prototype.setRowMode=function(e){L(this);this.setAggregation("rowMode",e);U(this);return this};D.prototype.destroyRowMode=function(){this.destroyAggregation("rowMode");if(!F(this).oDefaultRowMode){U(this)}return this};function H(e){var t=e.getRowMode();if(!e.isDestroyStarted()&&!d.isA(t,"sap.ui.table.rowmodes.RowMode")&&!F(e).oDefaultRowMode){U(e)}return d.isA(t,"sap.ui.table.rowmodes.RowMode")?t:F(e).oDefaultRowMode}function U(e){const t=e.getRowMode();const i=d.isA(t,"sap.ui.table.rowmodes.RowMode")?undefined:t||w.Fixed;if(i===undefined||F(e).oDefaultRowMode){return}if(t===null){switch(e.getVisibleRowCountMode()){case w.Fixed:F(e).oDefaultRowMode=new b(true);break;case w.Interactive:F(e).oDefaultRowMode=new C(true);break;case w.Auto:F(e).oDefaultRowMode=new v(true);break;default:throw new Error("Default row mode could not be created")}e.addAggregation("_hiddenDependents",F(e).oDefaultRowMode);return}switch(i){case w.Fixed:F(e).oDefaultRowMode=new b;break;case w.Interactive:F(e).oDefaultRowMode=new C;break;case w.Auto:F(e).oDefaultRowMode=new v;break;default:throw new Error("Default row mode could not be created")}e.addAggregation("_hiddenDependents",F(e).oDefaultRowMode)}function L(e){if(F(e).oDefaultRowMode){F(e).oDefaultRowMode.destroy();delete F(e).oDefaultRowMode}}D.prototype._getRowCounts=function(){var e=H(this).getComputedRowCounts();var t=this._bVariableRowHeightEnabled&&!e.fixedTop&&!e.fixedBottom;e._fullsize=e.count;e._scrollSize=e.scrollable;if(e.count>0&&t){e.count++;e.scrollable++}return e};D.prototype._isNoDataDisabled=function(){return!this.getShowNoData()||(H(this)?.isNoDataDisabled()??false)};D.prototype.setVisibleRowCountMode=function(e){if(this.getRowMode()){_.warning('If the "rowMode" aggregation is set, setting the "visibleRowCountMode" has no effect');return this.setProperty("visibleRowCountMode",e,true)}var t=this.getVisibleRowCountMode();this.setProperty("visibleRowCountMode",e);var i=this.getVisibleRowCountMode();if(i!==t){L(this);U(this)}return this};D.prototype.setVisibleRowCount=function(e){var t=this.getVisibleRowCountMode();if(t=="Auto"){_.error("VisibleRowCount will be ignored since VisibleRowCountMode is set to Auto",this);return this}if(e!=null&&!isFinite(e)){return this}var i=this.getFixedRowCount()+this.getFixedBottomRowCount();if(e<=i&&i>0){_.error("Table: "+this.getId()+" visibleRowCount('"+e+"') must be bigger than number of"+" fixed rows('"+(this.getFixedRowCount()+this.getFixedBottomRowCount())+"')",this);return this}if(this.getRowMode()){_.warning('If the "rowMode" aggregation is set, setting the "visibleRowCount" has no effect');return this.setProperty("visibleRowCount",e,true)}e=this.validateProperty("visibleRowCount",e);this.setProperty("visibleRowCount",e);d.dynamicCall(this._getSyncExtension,function(t){t.syncRowCount(e)});return this};D.prototype.setMinAutoRowCount=function(e){if(parseInt(e)<1){_.error("The minAutoRowCount property must be greater than 0. The value has been set to 1.",this);e=1}if(this.getRowMode()){_.warning('If the "rowMode" aggregation is set, setting the "minAutoRowCount" has no effect');return this.setProperty("minAutoRowCount",e,true)}return this.setProperty("minAutoRowCount",e)};D.prototype.setTooltip=function(e){_.warning("The aggregation tooltip is not supported for sap.ui.table.Table",this);return this.setAggregation("tooltip",e,true)};D.prototype.setNavigationMode=function(){this.setProperty("navigationMode","Scrollbar",true);_.error("The navigationMode property is deprecated and must not be used anymore. Your setting was defaulted to 'Scrollbar'",this);return this};D.prototype._getRowContexts=function(e){var t=this.getBinding();var i=this._getRowCounts();var o=this.getThreshold();e=e==null?i.count:e;if(o!==0){o=Math.max(e-i.fixedTop-i.fixedBottom,o)}e=Math.max(e,H(this).getMinRequestLength(),0);if(!t||e===0){return[]}var n=this._getFirstRenderedRowIndex();var r=[];if(i.fixedTop>0&&n>0){W(r,this._getFixedTopRowContexts(),0);W(r,this._getContexts(n+i.fixedTop,e-i.fixedBottom-i.fixedTop,o),i.fixedTop)}else{W(r,this._getContexts(n,e-i.fixedBottom,o),0)}if(i.fixedBottom>0){W(r,this._getFixedBottomRowContexts(),Math.min(i.fixedTop+i.scrollable,Math.max(this._getTotalRowCount()-i.fixedBottom,0)))}return r};function W(e,t,i){for(var o=0;o<t.length;o++){e[i+o]=t[o]}}D.prototype._getFixedTopRowContexts=function(){var e=this._getRowCounts();return e.fixedTop>0?this._getContexts(0,e.fixedTop,0,true):[]};D.prototype._getFixedBottomRowContexts=function(){var e=this._getRowCounts();var t=G(this,true);if(e.fixedBottom>0&&e.count-e.fixedBottom<t){return this._getContexts(t-e.fixedBottom,e.fixedBottom,0,true)}else{return[]}};D.prototype._getContexts=function(e,t,i,o){var n=this.getBinding();return n?n.getContexts(e,t,i,o):[]};D.prototype._adjustToTotalRowCount=function(){var e=this._getTotalRowCount();if(this._iBindingLength!==e){this._iBindingLength=e;this._updateFixedBottomRows();this._adjustFirstVisibleRowToTotalRowCount();d.Hook.call(this,M.TotalRowCountChanged)}};D.prototype._adjustFirstVisibleRowToTotalRowCount=function(){var e=this.getFirstVisibleRow();var t=this._getMaxFirstVisibleRowIndex();if(t<e&&this._bContextsAvailable){this._setFirstVisibleRowIndex(t,{onlySetProperty:true})}};D.prototype.refreshRows=function(e){this._bContextsAvailable=false;if(e===o.Sort||e===o.Filter){this.setFirstVisibleRow(0)}d.Hook.call(this,M.RefreshRows,e||d.RowsUpdateReason.Unknown)};D.prototype.updateRows=function(e,t){if(this.bIsDestroyed||this._bIsBeingDestroyed){return}if(t.detailedReason==="AddVirtualContext"){z(this);return}else if(t.detailedReason==="RemoveVirtualContext"){O(this);return}this._bContextsAvailable=true;if(e===o.Sort||e===o.Filter){this.setFirstVisibleRow(0)}this._adjustToTotalRowCount();N(this,e)};function z(e){var t=e._getRowContexts()[0];O(e);e._oVirtualRow=e._getRowClone("virtual");e._oVirtualRow.setBindingContext(t,e.getBindingInfo("rows").model);e.addAggregation("_hiddenDependents",e._oVirtualRow)}function O(e){if(e._oVirtualRow){e._oVirtualRow.destroy();delete e._oVirtualRow}}function N(e,t){if(e._bContextsAvailable){d.Hook.call(e,M.UpdateRows,t||d.RowsUpdateReason.Unknown)}}D.prototype.insertRow=function(){_.error('The control manages the rows aggregation. The method "insertRow" cannot be used programmatically!',this);return this};D.prototype.addRow=function(){_.error('The control manages the rows aggregation. The method "addRow" cannot be used programmatically!',this);return this};D.prototype.removeRow=function(){_.error('The control manages the rows aggregation. The method "removeRow" cannot be used programmatically!',this);return null};D.prototype.removeAllRows=function(){_.error('The control manages the rows aggregation. The method "removeAllRows" cannot be used programmatically!',this);return[]};D.prototype.destroyRows=function(){_.error('The control manages the rows aggregation. The method "destroyRows" cannot be used programmatically!',this);return this};D.prototype.setCreationRow=function(e){if(!d.isA(e,"sap.ui.table.CreationRow")){e=null}return this.setAggregation("creationRow",e)};D.prototype.getCreationRow=function(){return this.getAggregation("creationRow")};D.prototype.autoResizeColumn=function(e){this._getPointerExtension().doAutoResizeColumn(e)};D.prototype._attachEvents=function(){var t=this.$();var i=this.getId();if(S.getAnimationMode()!==S.AnimationMode.none){jQuery(document.body).on("webkitTransitionEnd."+i+" transitionend."+i,function(e){if(jQuery(e.target).has(t).length>0){this._updateTableSizes(d.RowsUpdateReason.Animation)}}.bind(this))}e.resize.attachHandler(this._onWindowResize,this);p.attachEvents(this)};D.prototype._detachEvents=function(){var t=this.getId();jQuery(document.body).off("webkitTransitionEnd."+t+" transitionend."+t);d.deregisterResizeHandler(this,"Table");e.resize.detachHandler(this._onWindowResize,this);p.detachEvents(this)};D.prototype._cleanUpTimers=function(){var e;for(e in this._mTimeouts){if(this._mTimeouts[e]){window.clearTimeout(this._mTimeouts[e]);delete this._mTimeouts[e]}}for(e in this._mAnimationFrames){if(this._mAnimationFrames[e]){window.cancelAnimationFrame(this._mAnimationFrames[e]);delete this._mAnimationFrames[e]}}};function q(e){var t=e.getDomRef();if(t){e.getDomRef().classList.toggle("sapUiTableEmpty",d.isNoDataVisible(e));e._getAccExtension().updateAriaStateForOverlayAndNoData();e._getKeyboardExtension().updateNoDataAndOverlayFocus()}}D.prototype.removeColumn=function(e){e=this.removeAggregation("columns",e);if(e===null){return e}if(!this._bReorderInProcess){this._removeSortedColumn(e)}k(this);return e};D.prototype.removeAllColumns=function(){var e=this.removeAllAggregation("columns");this._aSortedColumns=[];k(this);return e};D.prototype.destroyColumns=function(){var e=this.destroyAggregation("columns");this._aSortedColumns=[];k(this);return e};D.prototype.addColumn=function(e){this.addAggregation("columns",e);k(this);return this};D.prototype.insertColumn=function(e,t){this.insertAggregation("columns",e,t);k(this);return this};function k(e){e.invalidateRowsAggregation();e._invalidateComputedFixedColumnCount();var t=e.getCreationRow();if(t){t._update()}}D.prototype._getTotalRowCount=function(){return G(this)};function G(e,t){var i=e.getBinding();var o=e.getBindingInfo("rows");if(!i){return 0}if(o.length!=null){return o.length}if(t===true){return i.getLength()}if(!e._bContextsAvailable){return F(e).iCachedBindingLength}F(e).iCachedBindingLength=i.getLength();return F(e).iCachedBindingLength}D.prototype._getMaxFirstVisibleRowIndex=function(){var e;if(d.isVariableRowHeightEnabled(this)){e=this._getTotalRowCount()-1}else{e=this._getTotalRowCount()-this._getRowCounts().count}return Math.max(0,e)};D.prototype._getMaxFirstRenderedRowIndex=function(){var e=this._getTotalRowCount()-this._getRowCounts().count;return Math.max(0,e)};D.prototype._getFirstRenderedRowIndex=function(){return F(this).iFirstRenderedRowIndex};D.prototype._getVisibleColumns=function(){var e=[];var t=this.getColumns();for(var i=0,o=t.length;i<o;i++){if(t[i].shouldRender()){e.push(t[i])}}return e};D.prototype._getColumnsWidth=function(e,t){var i=this.getColumns();var o=0;if(e!==0&&!e){e=0}if(t!==0&&!t){t=i.length}for(var n=e,r=t;n<r;n++){if(i[n]&&i[n].shouldRender()){var s=d.convertCSSSizeToPixel(i[n].getWidth());if(s==null){s=d.Column.getMinColumnWidth()}o+=s}}return o};D.prototype._onTableResize=function(e){var t=e.oldSize.width;var i=e.size.width;if(this._bInvalid||!this.getDomRef()||t===i){return}this._updateTableSizes(d.RowsUpdateReason.Resize)};D.prototype._onWindowResize=function(){if(this._bInvalid||!this.getDomRef()){return}if(e.browser.chrome&&window.devicePixelRatio!==this._nDevicePixelRatio){this._nDevicePixelRatio=window.devicePixelRatio;this._updateTableSizes(d.RowsUpdateReason.Zoom);this._adjustOutlineOffset()}};D.prototype._adjustOutlineOffset=function(){if(window.devicePixelRatio<1){this.addStyleClass("sapUiTableZoomout")}else{this.removeStyleClass("sapUiTableZoomout")}};D.prototype._disableTextSelection=function(e){jQuery(e||document.body).attr("unselectable","on").css({"-moz-user-select":"none","-webkit-user-select":"none","user-select":"none"}).on("selectstart",function(e){e.preventDefault();return false})};D.prototype._enableTextSelection=function(e){jQuery(e||document.body).attr("unselectable","off").css({"-moz-user-select":"","-webkit-user-select":"","user-select":""}).off("selectstart")};D.prototype._findAndfireCellEvent=function(e,t,i){var o=jQuery(t.target);var n=o.closest(".sapUiTableDataCell");var r=n.attr("id");var s=/.*-row(\d*)-col(\d*)/i.exec(r);var l=false;if(s){var u=s[1];var d=s[2];var p=this.getRows()[u];var h=p&&p.getCells()[d];var g=p&&p.getIndex();var c=a.ofCell(h).getId();var f=p.getRowBindingContext();var y={rowIndex:g,columnIndex:d,columnId:c,cellControl:h,rowBindingContext:f,cellDomRef:n.get(0)};l=!e.call(this,y);if(!l&&typeof i==="function"){y.cellDomRef=n[0];l=i.call(this,y)}}return l};D.prototype.getFocusDomRef=function(){this._getKeyboardExtension().initItemNavigation();if(this.getShowOverlay()){return this.getDomRef("overlay")}if(d.isNoDataVisible(this)){return this.getDomRef("noDataCnt")}var e=this._oFocusInfo&&this._oFocusInfo.targetInfo&&d.isA(this._oFocusInfo.targetInfo,"sap.ui.core.message.Message");if(e&&this.getColumnHeaderVisible()){var i=this._getVisibleColumns()[0];if(i){return i.getDomRef()}}var o=d.getFocusedItemInfo(this);if(o&&o.domRef){return o.domRef}return t.prototype.getFocusDomRef.apply(this,arguments)};D.prototype.pushSortedColumn=function(e,t){if(!t){this._aSortedColumns=[]}if(this._aSortedColumns.indexOf(e)===-1){this._aSortedColumns.push(e)}};D.prototype._removeSortedColumn=function(e){var t=this._aSortedColumns.indexOf(e);if(t>-1){this._aSortedColumns.splice(t,1)}};D.prototype.getSortedColumns=function(){return this._aSortedColumns.slice()};D.prototype.sort=function(e,t,i){if(!e){this._aSortedColumns.forEach(e=>{e.setSorted(false);e.setSortOrder(B.None)});this.getBinding()?.sort();this._aSortedColumns=[]}if(this.getColumns().indexOf(e)>=0){e._sort(t??B.Ascending,i)}};D.prototype.filter=function(e,t){if(this.getColumns().indexOf(e)>=0){if(t==null){t=""}else if(typeof t!=="string"){throw new Error("The filter value is not a string")}e.filter(t)}};D.prototype._updateSelection=function(){var e=this.getSelectionMode();if(e===A.None){return}var t=this._getSelectionPlugin().getRenderConfig();var i;var o;var n=this.$("selall");var r=this.getRows();for(var s=0;s<r.length;s++){var a=r[s];a._updateSelection()}if(!t.headerSelector.visible){return}if(t.headerSelector.type==="toggle"){var l=t.headerSelector.selected;n.toggleClass("sapUiTableSelAll",!l);this._getAccExtension().setSelectAllState(l);i=l?"TBL_DESELECT_ALL":"TBL_SELECT_ALL"}else if(t.headerSelector.type==="clear"){n.toggleClass("sapUiTableSelAllDisabled",!t.headerSelector.enabled);i="TBL_DESELECT_ALL";if(t.headerSelector.enabled){n.removeAttr("aria-disabled")}else{n.attr("aria-disabled","true")}}if(i){o=d.getResourceText(i);n.attr("title",o)}};D.prototype._getHideStandardTooltips=function(){return this._bHideStandardTooltips};D.prototype._setHideStandardTooltips=function(e){this._bHideStandardTooltips=e};D.prototype._onSelectionChanged=function(e){this._updateSelection();if(this._hasSelectionPlugin()){return}var t=this._getSelectionPlugin();var i=e.getParameter("rowIndices");var o=e.getParameter("selectAll");var n=this._iSourceRowIndex!==undefined?this._iSourceRowIndex:t.getSelectedIndex();if(this.getMetadata().hasProperty("selectedIndex")){this.setProperty("selectedIndex",t.getSelectedIndex(),true)}this.fireRowSelectionChange({rowIndex:n,rowContext:this.getContextByIndex(n),rowIndices:i,selectAll:o,userInteraction:this._iSourceRowIndex!==undefined})};D.prototype.getContextByIndex=function(e){var t=this.getBinding();var i=null;if(!t||e<0){return i}if(t.getContextByIndex){i=t.getContextByIndex(e)}else{i=t.getContexts(e,1,0,true)[0]}return i||null};D.prototype.getSelectedIndex=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndex must not be called if a selection plugin is applied.")}return this._getSelectionPlugin().getSelectedIndex()};D.prototype.setSelectedIndex=function(e){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectedIndex must not be called if a selection plugin is applied.")}this._getSelectionPlugin().setSelectedIndex(e);return this};D.prototype.clearSelection=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#clearSelection must not be called if a selection plugin is applied.")}this._getSelectionPlugin().clearSelection();return this};D.prototype.selectAll=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#selectAll must not be called if a selection plugin is applied.")}if(d.hasSelectAll(this)){this._getSelectionPlugin().selectAll()}return this};D.prototype.getSelectedIndices=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#getSelectedIndices must not be called if a selection plugin is applied.")}return this._getSelectionPlugin().getSelectedIndices()};D.prototype.addSelectionInterval=function(e,t){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#addSelectionInterval must not be called if a selection plugin is applied.")}this._getSelectionPlugin().addSelectionInterval(e,t);return this};D.prototype.setSelectionInterval=function(e,t){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#setSelectionInterval must not be called if a selection plugin is applied.")}this._getSelectionPlugin().setSelectionInterval(e,t);return this};D.prototype.removeSelectionInterval=function(e,t){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#removeSelectionInterval must not be called if a selection plugin is applied.")}this._getSelectionPlugin().removeSelectionInterval(e,t);return this};D.prototype.isIndexSelected=function(e){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#isIndexSelected must not be called if a selection plugin is applied.")}return this._getSelectionPlugin().isIndexSelected(e)};D.prototype.setGroupBy=function(e){var t=e;var i=sap.ui.getCore().byId(this.getGroupBy());if(typeof t==="string"){t=sap.ui.getCore().byId(t)}var o=false;if(t instanceof a&&t!==i){if(this.getColumns().indexOf(t)===-1){throw new Error("Column has to be part of the columns aggregation!")}var n=this.fireGroup({column:t,groupedColumns:[t.getId()],type:T.group});if(i){i.setGrouped(false);o=true}if(n&&this.getEnableGrouping()){t.setGrouped(true)}}if(!t||o){if(i){i.setGrouped(false)}d.Grouping.resetExperimentalGrouping(this)}this.setAssociation("groupBy",t);d.Grouping.setupExperimentalGrouping(this);return this};D.prototype.getBinding=function(e){return t.prototype.getBinding.call(this,e==null?"rows":e)};D.prototype.setEnableGrouping=function(e){var t=sap.ui.getCore().byId(this.getGroupBy());this.setProperty("enableGrouping",e);if(t){t.setGrouped(e)}if(e){d.Grouping.setupExperimentalGrouping(this)}else{d.Grouping.resetExperimentalGrouping(this)}return this};D.prototype.getComputedFixedColumnCount=function(){if(this._bIgnoreFixedColumnCount){return 0}return this._getSpanBasedComputedFixedColumnCount()};D.prototype._getSpanBasedComputedFixedColumnCount=function(){if(F(this).iComputedFixedColumnCount===null){var e=this.getColumns();var t;var i=this.getFixedColumnCount();for(var o=i-1;o>=0;o--){t=e[o];if(t){i=Math.max(i,t.getIndex()+d.Column.getHeaderSpan(t));break}}F(this).iComputedFixedColumnCount=Math.min(i,e.length)}return F(this).iComputedFixedColumnCount};D.prototype.setFixedColumnCount=function(e){this.setProperty("fixedColumnCount",e);this._invalidateComputedFixedColumnCount();var t=this.getColumns();var i;var o=this.$().find(".sapUiTableCtrlFirstCol > th");for(var n=this._getSpanBasedComputedFixedColumnCount()-1;n>=0;n--){i=t[n];if(i&&d.isVariableWidth(i.getWidth())){i._iFixWidth=o.filter("[data-sap-ui-headcolindex='"+i.getIndex()+"']").width()}}this._collectTableSizes();if(this.getEnableColumnFreeze()){this._invalidateColumnMenus()}return this};D.prototype.setFixedRowCount=function(e){if(!(parseInt(e)>=0)){_.error("Number of fixed rows must be greater or equal 0",this);return this}if(e+this.getFixedBottomRowCount()>=this.getVisibleRowCount()){_.error("Table '"+this.getId()+"' fixed rows('"+(e+this.getFixedBottomRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this}if(this.getRowMode()){_.warning('If the "rowMode" aggregation is set, setting the "fixedRowCount" has no effect');return this.setProperty("fixedRowCount",e,true)}return this.setProperty("fixedRowCount",e)};D.prototype.setFixedBottomRowCount=function(e){if(!(parseInt(e)>=0)){_.error("Number of fixed bottom rows must be greater or equal 0",this);return this}if(e+this.getFixedRowCount()>=this.getVisibleRowCount()){_.error("Table '"+this.getId()+"' fixed rows('"+(e+this.getFixedRowCount())+"') must be smaller than"+" numberOfVisibleRows('"+this.getVisibleRowCount()+"')",this);return this}if(this.getRowMode()){_.warning('If the "rowMode" aggregation is set, setting the "iFixedBottomRowCount" has no effect');return this.setProperty("fixedBottomRowCount",e,true)}return this.setProperty("fixedBottomRowCount",e)};D.prototype.setThreshold=function(e){this.setProperty("threshold",e,true);return this};D.prototype._invalidateColumnMenus=function(){d.Hook.call(this,d.Hook.Keys.Table.InvalidateColumnMenus,this)};D.prototype._isTouchEvent=function(e){return!!(e&&e.originalEvent&&e.originalEvent.touches)};D.prototype._getRowClone=function(e){var t=typeof e==="number";var i=t;var o=i?this._aRowClones[e]:null;if(o&&!o.bIsDestroyed){return o}o=new l(this.getId()+"-rows"+"-row"+(t?e:"-"+e));if(i){this._aRowClones[e]=o}var n=this.getColumns();for(var r=0,s=n.length;r<s;r++){if(n[r].getVisible()){var a=n[r].getTemplateClone(r);if(a){o.addCell(a)}}}if(d.hasRowActions(this)){var u=this.getRowActionTemplate().clone();o.setAggregation("_rowAction",u,true)}var p=this.getRowSettingsTemplate();if(p){var h=p.clone();o.setAggregation("_settings",h,true)}return o};D.prototype.invalidateRowsAggregation=function(){this._bRowAggregationInvalid=true};D.prototype._invalidateComputedFixedColumnCount=function(){F(this).iComputedFixedColumnCount=null};D.prototype._getBaseRowHeight=function(){var e=H(this).getBaseRowContentHeight();if(e>0){return e+d.RowHorizontalFrameSize}else{return this._getDefaultRowHeight()}};D.prototype._getDefaultRowHeight=function(){var e=d.getContentDensity(this);return d.DefaultRowHeight[e]};D.prototype._getDefaultRowContentHeight=function(){var e=d.getContentDensity(this);return d.BaseSize[e]};D.prototype.setNoData=function(e){var t=d.getNoContentMessage(this);this.setAggregation("noData",e,true);var i=d.getNoContentMessage(this);if(d.isA(e,"sap.m.IllustratedMessage")){j(this)}else{this.destroyAggregation("_noColumnsMessage",true)}if(typeof t==="string"&&typeof i==="string"){if(t!==i){this.$("noDataMsg").text(i)}}else{this.invalidate()}return this};function j(e){if(e.getAggregation("_noColumnsMessage")||F(e).bIsLoadingNoColumnsMessage){return}F(e).bIsLoadingNoColumnsMessage=true;sap.ui.require(["sap/m/table/Util"],function(t){if(!d.isA(e.getNoData(),"sap.m.IllustratedMessage")){return}var i=t.getNoColumnsIllustratedMessage();i.setEnableVerticalResponsiveness(true);e.setAggregation("_noColumnsMessage",i,d.getVisibleColumnCount(e)>0);delete F(e).bIsLoadingNoColumnsMessage})}D.prototype.exportData=function(e){var t=sap.ui.requireSync("sap/ui/core/util/Export");e=e||{};if(!e.rows){var i=this.getBinding(),o=this.getBindingInfo("rows");var n=i.aFilters.concat(i.aApplicationFilters);e.rows={path:o.path,model:o.model,sorter:i.aSorters,filters:n,parameters:o.parameters}}if(!e.exportType){var r=sap.ui.requireSync("sap/ui/core/util/ExportTypeCSV");e.exportType=new r}var s=e.rows.model;if(!s){var a=e.rows.path;var l=a.indexOf(">");if(l>0){s=a.substr(0,l)}}if(!e.columns){e.columns=[];var u=this.getColumns();for(var d=0,p=u.length;d<p;d++){var h=u[d];if(h.getSortProperty()){e.columns.push({name:h.getLabel().getText(),template:{content:{path:h.getSortProperty(),model:s}}})}}}var g=new t(e);this.addDependent(g);return g};D.prototype._onPersoApplied=function(){var e=this.getColumns();var t=[];for(var i=0,o=e.length;i<o;i++){var n=e[i];if(n.getSorted()&&n.getSortOrder()!==B.None){t.push(new r(n.getSortProperty(),n.getSortOrder()===B.Descending))}}var s=this.getBinding();if(s){if(t.length>0){s.sort(t)}}};D.prototype.setBusy=function(e){var i=this.getBusy();var o=t.prototype.setBusy.call(this,e,"sapUiTableGridCnt");var n=this.getBusy();if(i!==n){this.fireBusyStateChanged({busy:n})}return o};D.prototype.setEnableBusyIndicator=function(e){this.setProperty("enableBusyIndicator",e,true);if(this.getEnableBusyIndicator()){$(this)}else{this.setBusy(false);K(this)}return this};D.prototype._onBindingDataRequested=function(){F(this).iPendingRequests++;$(this)};D.prototype._onBindingDataReceived=function(){F(this).iPendingRequests--;$(this)};D.prototype._hasPendingRequests=function(){return F(this).iPendingRequests>0};function $(e){if(!e.getEnableBusyIndicator()){return}K(e);if(e._hasPendingRequests()){e.setBusy(true)}else{F(e).hideBusyIndicatorTimeoutId=setTimeout(function(){e.setBusy(false);K(e)},10)}}function K(e){clearTimeout(F(e).hideBusyIndicatorTimeoutId);delete F(e).hideBusyIndicatorTimeoutId}D.prototype._setLargeDataScrolling=function(e){this._bLargeDataScrolling=!!e};D.prototype.setRowActionTemplate=function(e){this.setAggregation("rowActionTemplate",e);this.invalidateRowsAggregation();return this};D.prototype.setRowActionCount=function(e){if(typeof e==="number"){e=Math.max(0,Math.min(e,2))}return this.setProperty("rowActionCount",e)};D.prototype.setRowSettingsTemplate=function(e){this.setAggregation("rowSettingsTemplate",e);this.invalidateRowsAggregation();return this};D.prototype._getSelectionPlugin=function(){var e=this._oSelectionPlugin||this._oLegacySelectionPlugin;if(typeof this._getSelectedIndicesCount==="function"&&e.getSelectedCount!==this._getSelectedIndicesCount){e.getSelectedCount=this._getSelectedIndicesCount;["isIndexSelected","setSelectedIndex","getSelectedIndex","getSelectedIndices","setSelectionInterval","addSelectionInterval","removeSelectionInterval","selectAll","clearSelection"].forEach(function(t){e[t]=this[t]}.bind(this))}return e};D.prototype._hasSelectionPlugin=function(){return this._oSelectionPlugin!=null};function Z(e){var t=e.getDependents().filter(e=>e.isA("sap.ui.table.plugins.SelectionPlugin"));t.unshift(...e.getPlugins());return t[0]}D.prototype._initSelectionPlugin=function(){var e=Z(this);if(this.isDestroyed()||this.isDestroyStarted()){return}if(e){this._destroyLegacySelectionPlugin();J(this,this._oSelectionPlugin);Y(this,e);this._oSelectionPlugin=e}else{this._initLegacySelectionPlugin();J(this,this._oSelectionPlugin);delete this._oSelectionPlugin}};D.prototype._initLegacySelectionPlugin=function(){if(this._oLegacySelectionPlugin||Z(this)){return}this._oLegacySelectionPlugin=this._createLegacySelectionPlugin();this.addAggregation("_hiddenDependents",this._oLegacySelectionPlugin);Y(this,this._oLegacySelectionPlugin)};D.prototype._destroyLegacySelectionPlugin=function(){if(this._oLegacySelectionPlugin&&!this._oLegacySelectionPlugin.isDestroyStarted()){this._oLegacySelectionPlugin.destroy();delete this._oLegacySelectionPlugin}};D.prototype._createLegacySelectionPlugin=function(){return new R};function Y(e,t){if(t&&t.getMetadata().hasEvent("selectionChange")){t.attachSelectionChange(e._onSelectionChanged,e)}}function J(e,t){if(t&&t.getMetadata().hasEvent("selectionChange")){t.detachSelectionChange(e._onSelectionChanged,e)}}D.prototype.insertAggregation=function(e,i,o,n){if(e==="_hiddenDependents"){return t.prototype.insertAggregation.call(this,e,i,o,true)}return t.prototype.insertAggregation.apply(this,arguments)};D.prototype.addAggregation=function(e,i,o){if(e==="_hiddenDependents"){return t.prototype.addAggregation.call(this,e,i,true)}return t.prototype.addAggregation.apply(this,arguments)};D.prototype.removeAggregation=function(e,i,o){if(e==="_hiddenDependents"){return t.prototype.removeAggregation.call(this,e,i,true)}return t.prototype.removeAggregation.apply(this,arguments)};D.prototype.removeAllAggregation=function(e,i){if(e==="_hiddenDependents"){return t.prototype.removeAllAggregation.call(this,e,true)}return t.prototype.removeAllAggregation.apply(this,arguments)};D.prototype.destroyAggregation=function(e,i){if(e==="_hiddenDependents"){return t.prototype.destroyAggregation.call(this,e,true)}t.prototype.destroyAggregation.apply(this,arguments);if(e==="rows"){this._aRowClones.forEach(function(e){e.destroy()});this._aRowClones=[]}return this};D.prototype.getCellControl=function(e,t,i){var o=d.getRowColCell(this,e,t,!i);return o.cell};D.prototype._fireRowsUpdated=function(e){var t={reason:e||d.RowsUpdateReason.Unknown};this.onRowsUpdated(t);clearTimeout(this._mTimeouts.fireRowsUpdated);this._mTimeouts.fireRowsUpdated=setTimeout(function(){this.onRowsContentUpdated(t);this.fireEvent("_rowsUpdated",t);this.fireRowsUpdated()}.bind(this),0)};D.prototype.onRowsUpdated=function(e){d.Grouping.updateGroups(this);d.Menu.closeContentCellContextMenu(this);this._getAccExtension()._updateAriaRowIndices();this._updateSelection();q(this);this.getRows().forEach(function(e){e.getCells().forEach(function(t){var i=a.ofCell(t);var o=i._getCellContentVisibilitySettings();var n=e.getDomRefs(true).row.find('td[data-sap-ui-colid="'+i.getId()+'"]');var r=true;if(!n){return}if(e.isGroupHeader()){if(!e.isExpandable()){r=o.groupHeader.nonExpandable}else if(e.isExpanded()){r=o.groupHeader.expanded}else{r=o.groupHeader.collapsed}}else if(e.isTotalSummary()){r=o.summary.total}else if(e.isGroupSummary()){r=o.summary.group}else{r=o.standard}n.toggleClass("sapUiTableCellHidden",!r)})})};D.prototype.onRowsContentUpdated=function(e){if(this.getRows().length>0){this._resetRowHeights();this._aRowHeights=this._collectRowHeights(false);this._updateRowHeights(this._aRowHeights,false);this._getAccExtension().updateAccForCurrentCell(e.reason)}};D.prototype._enableSynchronization=function(){var e=this;return new Promise(function(t,i){sap.ui.require(["sap/ui/table/extensions/Synchronization"],function(i){t(p.enrich(e,i).getInterface())},function(e){i(e)})})};D.prototype._enableLegacyMultiSelection=function(){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: sap.ui.table.Table#_enableLegacyMultiSelection must not be called"+" if a selection plugin is applied.")}this._legacyMultiSelection=function(e,t){if(this._hasSelectionPlugin()){throw new Error("Unsupported operation: The legacy multi selection is not supported if a selection plugin is applied")}var i=!!(t.metaKey||t.ctrlKey);if(!this.isIndexSelected(e)){if(i){this.addSelectionInterval(e,e)}else{this.setSelectedIndex(e)}}else if(i||this.getSelectedIndices().length===1){this.removeSelectionInterval(e,e)}else{this.setSelectedIndex(e)}}.bind(this)};D.prototype._setRowCountConstraints=function(e){this.setProperty("rowCountConstraints",e)};function Q(e,t){const i=e.getAggregation("_hiddenDependents")||[];return t.filter(e=>!i.includes(e))}D.prototype.findAggregatedObjects=function(){return Q(this,t.prototype.findAggregatedObjects.apply(this,arguments))};D.prototype.findElements=function(){return Q(this,t.prototype.findElements.apply(this,arguments))};D.prototype.getPlugin=function(e){if(!e||!e.startsWith("sap.ui.table.plugins.")){throw new Error("This method can only be used to get plugins of the sap.ui.table library")}var t=this.getDependents().find(t=>t.isA(e));if(!t){t=this.getPlugins().find(t=>t.isA(e))}return t};return D});
//# sourceMappingURL=Table.js.map