/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ExtensionBase","../utils/TableUtils"],function(t,e){"use strict";var r={onAfterRendering:function(){this.attachScrollbar()}};var o=t.extend("sap.ui.table.extensions.ScrollingIOS",{_init:function(t){e.addDelegate(t,r,this);this.attachScrollbar();return"ScrollIOSExtension"},destroy:function(){var o=this.getTable();e.removeDelegate(o,r);clearTimeout(this._iUpdateDefaultScrollbarPositionTimeoutId);t.prototype.destroy.apply(this,arguments)},_attachEvents:function(){var t=this.getTable();e.Hook.register(t,e.Hook.Keys.Table.TotalRowCountChanged,this.onTotalRowCountChanged,this);e.Hook.register(t,e.Hook.Keys.Table.UpdateSizes,this.onUpdateTableSizes,this)},_detachEvents:function(){var t=this.getTable();var r=t._getScrollExtension().getVerticalScrollbar();if(r){r.removeEventListener("scroll",this._onVerticalScrollEventHandler)}delete this._onVerticalScrollEventHandler;var o=this.getVerticalScrollbar();if(o){o.removeEventListener("pointerdown",this._onPointerDownEventHandler)}delete this._onPointerDownEventHandler;var a=this.getVerticalScrollbarThumb();if(a){a.removeEventListener("touchmove",this._onTouchMoveEventHandler)}delete this._onTouchMoveEventHandler;e.Hook.deregister(t,e.Hook.Keys.Table.TotalRowCountChanged,this.onTotalRowCountChanged,this);e.Hook.deregister(t,e.Hook.Keys.Table.UpdateSizes,this.onUpdateTableSizes,this)}});o.prototype.onUpdateTableSizes=function(){this.updateVerticalScrollbarThumbHeight();this.updateVerticalScrollbarThumbPosition()};o.prototype.onTotalRowCountChanged=function(){this.updateVerticalScrollbarThumbHeight()};o.prototype.attachScrollbar=function(){var t=this.getTable();var e=t._getScrollExtension().getVerticalScrollbar();var r=this.getVerticalScrollbar();var o=this.getVerticalScrollbarThumb();if(!e||!e.isConnected){return}if(!r){r=document.createElement("div");r.setAttribute("id",t.getId()+"-vsb-ios");r.classList.add("sapUiTableVSbIOS");o=document.createElement("div");o.classList.add("sapUiTableVSbIOSThumb");r.append(o);e.after(r)}if(!this._onPointerDownEventHandler){this._onPointerDownEventHandler=this.onPointerDown.bind(this);r.addEventListener("pointerdown",this._onPointerDownEventHandler);this._onTouchMoveEventHandler=this.onTouchMove.bind(this);o.addEventListener("touchmove",this._onTouchMoveEventHandler);this._onVerticalScrollEventHandler=this.updateVerticalScrollbarThumbPosition.bind(this);e.addEventListener("scroll",this._onVerticalScrollEventHandler)}this.updateVerticalScrollbar()};o.prototype.getVerticalScrollbar=function(){var t=this.getTable();return t?t.getDomRef("vsb-ios"):null};o.prototype.getVerticalScrollbarThumb=function(){var t=this.getVerticalScrollbar();return t?t.firstElementChild:null};o.prototype.updateVerticalScrollbar=function(){var t=this.getTable();var e=this.getVerticalScrollbar();e.style.height=t._getScrollExtension().getVerticalScrollbarHeight()+"px";e.style.top=Math.max(0,t._getRowCounts().fixedTop*t._getBaseRowHeight()-1)+"px";this.updateVerticalScrollbarThumbPosition();this.updateVerticalScrollbarThumbHeight()};o.prototype.updateVerticalScrollbarThumbPosition=function(){var t=this.getVerticalScrollbarThumb();if(t){t.style.top=this.getCalculateThumbOffset()+"px"}};o.prototype.updateVerticalScrollbarThumbHeight=function(){var t=this.getTable();var e=t._getScrollExtension();var r=this.getVerticalScrollbarThumb();if(r){if(e.isVerticalScrollbarRequired()){r.style.height=this.getCalculateThumbHeight()+"px"}else{r.style.height="0"}}};o.prototype.getCalculateThumbHeight=function(){var t=this.getTable();var e=t._getScrollExtension();var r=e.getVerticalScrollbarHeight();var o=e.getVerticalScrollHeight();return Math.round(Math.pow(r,2)/o)};o.prototype.getCalculateThumbOffset=function(){var t=this.getTable();var e=t._getScrollExtension();var r=e.getVerticalScrollbarHeight();var o=e.getVerticalScrollHeight();var a=e.getVerticalScrollbar();var i=a?e.getVerticalScrollbar().scrollTop:0;return Math.round(i*r/o)};o.prototype.onTouchMove=function(t){var e=this.getTable();var r=e._getScrollExtension();var o=this.getVerticalScrollbarThumb();var a=o.getBoundingClientRect().y;var i=this.getCalculateThumbHeight();var l=o.offsetTop+t.touches[0].pageY-a-i/2;var n=Math.min(r.getVerticalScrollbarHeight()-i,Math.max(0,l));t.preventDefault();t.stopPropagation();o.style.top=n+"px";clearTimeout(this._iUpdateDefaultScrollbarPositionTimeoutId);this._iUpdateDefaultScrollbarPositionTimeoutId=setTimeout(function(){this.updateDefaultScrollbarPosition(n,i);delete this._iUpdateDefaultScrollbarPositionTimeoutId}.bind(this),30)};o.prototype.onPointerDown=function(t){var e=this.getTable();var r=e._getScrollExtension();var o=this.getVerticalScrollbarThumb();var a=o.getBoundingClientRect().y;var i=this.getCalculateThumbHeight();var l=o.offsetTop+t.clientY-a-i/2;var n=Math.min(r.getVerticalScrollbarHeight()-i,Math.max(0,l));t.preventDefault();t.stopPropagation();o.style.top=n+"px";this.updateDefaultScrollbarPosition(n,i)};o.prototype.updateDefaultScrollbarPosition=function(t,e){var r=this.getTable();if(!r){return}var o=r._getScrollExtension();var a=o.getVerticalScrollbarHeight();if(t+e>=a){o.scrollVerticallyMax(true)}else{var i=t*o.getVerticalScrollHeight()/a;var l=o.getVerticalScrollbar();l.scrollTop=i}};return o});
//# sourceMappingURL=ScrollingIOS.js.map