/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./RowMode","../utils/TableUtils","sap/ui/thirdparty/jquery"],function(t,e,jQuery){"use strict";var o=t.extend("sap.ui.table.rowmodes.Interactive",{metadata:{library:"sap.ui.table",final:true,properties:{rowCount:{type:"int",defaultValue:10,group:"Appearance"},minRowCount:{type:"int",defaultValue:5,group:"Appearance"},fixedTopRowCount:{type:"int",defaultValue:0,group:"Appearance"},fixedBottomRowCount:{type:"int",defaultValue:0,group:"Appearance"},rowContentHeight:{type:"int",defaultValue:0,group:"Appearance"}}},constructor:function(e){Object.defineProperty(this,"bLegacy",{value:typeof e==="boolean"?e:false});t.apply(this,arguments)}});var i={};var n={};o.prototype.attachEvents=function(){t.prototype.attachEvents.apply(this,arguments);e.addDelegate(this.getTable(),i,this)};o.prototype.detachEvents=function(){t.prototype.detachEvents.apply(this,arguments);e.removeDelegate(this.getTable(),i)};o.prototype.registerHooks=function(){t.prototype.registerHooks.apply(this,arguments);e.Hook.register(this.getTable(),e.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this)};o.prototype.deregisterHooks=function(){t.prototype.deregisterHooks.apply(this,arguments);e.Hook.deregister(this.getTable(),e.Hook.Keys.Table.RefreshRows,this._onTableRefreshRows,this)};o.prototype.getRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getVisibleRowCount():0}return this.getProperty("rowCount")};o.prototype.getFixedTopRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedRowCount():0}return this.getProperty("fixedTopRowCount")};o.prototype.getFixedBottomRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getFixedBottomRowCount():0}return this.getProperty("fixedBottomRowCount")};o.prototype.getMinRowCount=function(){if(this.bLegacy){var t=this.getTable();return t?t.getMinAutoRowCount():0}return this.getProperty("minRowCount")};o.prototype.getRowContentHeight=function(){if(this.bLegacy){var t=this.getTable();return t?t.getRowHeight():0}return this.getProperty("rowContentHeight")};o.prototype.getMinRequestLength=function(){return this.getConfiguredRowCount()};o.prototype.getComputedRowCounts=function(){var t=this.getConfiguredRowCount();var e=this.getFixedTopRowCount();var o=this.getFixedBottomRowCount();return this.computeStandardizedRowCounts(t,e,o)};o.prototype.getTableStyles=function(){return{height:"auto"}};o.prototype.getRowContainerStyles=function(){var t=this.getComputedRowCounts().count*this.getBaseRowHeightOfTable()+"px";if(this.bLegacy&&!e.isVariableRowHeightEnabled(this.getTable())){return{minHeight:t}}return{height:t}};o.prototype.renderRowStyles=function(t){var e=this.getRowContentHeight();if(e>0){t.style("height",this.getBaseRowHeightOfTable()+"px")}};o.prototype.renderCellContentStyles=function(t){var e=this.getRowContentHeight();if(this.bLegacy){return}if(e<=0){e=this.getDefaultRowContentHeightOfTable()}if(e>0){t.style("max-height",e+"px")}};o.prototype.renderInTableBottomArea=function(t){t.openStart("div",this.getTable().getId()+"-sb");t.attr("tabindex","-1");t.class("sapUiTableHeightResizer");t.style("height","5px");t.openEnd();t.close("div")};o.prototype.getBaseRowContentHeight=function(){return Math.max(0,this.getRowContentHeight())};o.prototype._onTableRefreshRows=function(){var t=this.getConfiguredRowCount();if(t>0){this.initTableRowsAfterDataRequested(t);this.getRowContexts(t)}};o.prototype.getConfiguredRowCount=function(){return Math.max(0,this.getMinRowCount(),this.getRowCount())};i.onBeforeRendering=function(t){if(this.bLegacy){this.getTable().setVisibleRowCount(this.getComputedRowCounts().count)}};i.onAfterRendering=function(t){var o=this.getTable();var i=t&&t.isMarked("renderRows");if(!i&&o.getRows().length>0){this.fireRowsUpdated(e.RowsUpdateReason.Render)}};i.onmousedown=function(t){var e=this.getTable();if(t.button===0&&t.target===e.getDomRef("sb")){n.initInteractiveResizing(e,this,t)}};n.initInteractiveResizing=function(t,e,o){var i=jQuery(document.body);var r=t.$("sb");var a=jQuery(document);var s=r.offset();var u=r.height();var p=r.width();var g=t._isTouchEvent(o);var h=document.createElement("div");h.style.width=p+"px";h.style.height=u+"px";h.style.left=s.left+"px";h.style.top=s.top+"px";h.className="sapUiTableInteractiveResizerGhost";h.id=t.getId()+"-ghost";i.append(h);var l=document.createElement("div");l.style.top="0px";l.style.bottom="0px";l.style.left="0px";l.style.right="0px";l.style.position="absolute";l.id=t.getId()+"-rzoverlay";r.append(l);a.on((g?"touchend":"mouseup")+".sapUiTableInteractiveResize",n.exitInteractiveResizing.bind(t,e));a.on((g?"touchmove":"mousemove")+".sapUiTableInteractiveResize",n.onMouseMoveWhileInteractiveResizing.bind(t));t._disableTextSelection()};n.exitInteractiveResizing=function(t,e){var o=jQuery(document);var i=this.$();var r=this.$("ghost");var a=n.getEventPosition(this,e).y;var s=a-i.find(".sapUiTableCCnt").offset().top-r.height()-i.find(".sapUiTableFtr").height();var u=Math.floor(s/t.getBaseRowHeightOfTable());var p=Math.max(1,u,t.getMinRowCount());if(t.bLegacy){p=Math.max(p,t.getFixedTopRowCount()+t.getFixedBottomRowCount()+1);this.setVisibleRowCount(p)}t.setRowCount(p);r.remove();this.$("rzoverlay").remove();o.off("touchend.sapUiTableInteractiveResize");o.off("touchmove.sapUiTableInteractiveResize");o.off("mouseup.sapUiTableInteractiveResize");o.off("mousemove.sapUiTableInteractiveResize");this._enableTextSelection()};n.onMouseMoveWhileInteractiveResizing=function(t){var e=n.getEventPosition(this,t).y;var o=this.$().offset().top;if(e>o){this.$("ghost").css("top",e+"px")}};n.getEventPosition=function(t,e){var o;function i(o){if(!t._isTouchEvent(o)){return null}var i=["touches","targetTouches","changedTouches"];for(var n=0;n<i.length;n++){var r=i[n];if(e[r]&&e[r][0]){return e[r][0]}if(e.originalEvent[r]&&e.originalEvent[r][0]){return e.originalEvent[r][0]}}return null}o=i(e)||e;return{x:o.pageX,y:o.pageY}};return o});
//# sourceMappingURL=Interactive.js.map