//@ui5-bundle sap/ui/testrecorder/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/Bootstrap", [],function(){"use strict";return{init:function(e,t){sap.ui.require(["sap/ui/testrecorder/Recorder"],function(t){if(e[0].toLowerCase()==="true"||e[0].toLowerCase()==="silent"){t.start(e)}})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/CommunicationBus", ["sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/WCBConfig"],function(e,r){"use strict";var i;var t=e.extend("sap.ui.testrecorder.CommunicationBus",{constructor:function(){if(!i){var t=new r({modulePath:"sap/ui/test",receivingWindow:"testRecorder",uriParams:{origin:"sap-ui-testrecorder-origin",frameId:"sap-ui-testrecorder-frame-identifier"}});e.call(this,t)}else{return i}}});i=new t;return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/CommunicationChannels", [],function(){"use strict";return{REQUEST_ALL_CONTROLS_DATA:"REQUEST_ALL_CONTROLS_DATA",RECEIVE_ALL_CONTROLS_DATA:"RECEIVE_ALL_CONTROL_DATA",REQUEST_CONTROL_DATA:"REQUEST_CONTROL_DATA",RECEIVE_CONTROL_DATA:"RECEIVE_CONTROL_DATA",REQUEST_CODE_SNIPPET:"REQUEST_CODE_SNIPPET",RECEIVE_CODE_SNIPPET:"RECEIVE_CODE_SNIPPET",CLEAR_SNIPPETS:"CLEAR_SNIPPETS",SET_DIALECT:"SET_DIALECT",DIALECT_CHANGED:"DIALECT_CHANGED",UPDATE_SETTINGS:"UPDATE_SETTINGS",HIGHLIGHT_CONTROL:"HIGHLIGHT_CONTROL",SELECT_CONTROL_IN_TREE:"SELECT_CONTROL_IN_TREE",SHOW_CONTEXT:"SHOW_CONTEXT",CONTEXT_MENU_HIGHLIGHT:" CONTEXT_MENU_HIGHLIGHT",CONTEXT_MENU_PRESS:"CONTEXT_MENU_PRESS",CONTEXT_MENU_ENTER_TEXT:"CONTEXT_MENU_ENTER_TEXT",ASSERT_PROPERTY:"ASSERT_PROPERTY",MINIMIZE_IFRAME:"MINIMIZE_IFRAME",SHOW_IFRAME:"SHOW_IFRAME",OPEN_NEW_WINDOW:"OPEN_NEW_WINDOW",CLOSE_IFRAME:"CLOSE_IFRAME",DOCK_IFRAME_BOTTOM:"DOCK_IFRAME_BOTTOM",DOCK_IFRAME_RIGHT:"DOCK_IFRAME_RIGHT",DOCK_IFRAME_LEFT:"DOCK_IFRAME_LEFT"}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/Constants", [],function(){"use strict";var t="sap-ui-test-recorder-frame";var e=1001;var E=e+1;var I=E+1;var T="3px";var i={BOTTOM:"50%",SIDE:"100%"};var r={BOTTOM:"100%",SIDE:"40%"};var h={LEFT_SIDE:"40%",RIGHT_SIDE:"60%"};return{HIGHLIGHTER_ID:"ui5-test-recorder-highlighter",CONTEXTMENU_ID:"ui5-test-recorder-contextmenu",IFRAME_ID:t,RESIZE_OVERLAY_ID:t+"resize-overlay",DOCK:{BOTTOM:"BOTTOM",RIGHT:"RIGHT",LEFT:"LEFT"},RESIZE_HANDLE:{BOTTOM:{id:t+"resizehandle-bottom",width:r.BOTTOM,height:T,left:"0",top:i.BOTTOM},RIGHT:{id:t+"resizehandle-right",width:T,height:i.SIDE,left:h.RIGHT_SIDE,top:"0"},LEFT:{id:t+"resizehandle-left",width:T,height:i.SIDE,left:h.LEFT_SIDE,top:"0"}},FRAME:{BOTTOM:{width:r.BOTTOM,height:i.BOTTOM,left:"0",top:"unset",bottom:"0"},RIGHT:{width:r.SIDE,height:i.SIDE,left:h.RIGHT_SIDE,top:"0"},LEFT:{width:r.SIDE,height:i.SIDE,left:"0",top:"0"},MINIMIZED:{width:"180px",height:"32px"}},IFRAME_ZINDEX:e,RESIZE_OVERLAY_ZINDEX:E,RESIZE_HANDLE_ZINDEX:I}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/DialectRegistry", ["sap/ui/base/Object","sap/ui/testrecorder/Dialects"],function(t,e){"use strict";var i=e.OPA5;var r=null;var s=t.extend("sap.ui.testrecorder.DialectRegistry",{constructor:function(){if(!r){t.apply(this,arguments);this.setActiveDialect(i)}else{return r}}});s.prototype.getActiveDialect=function(){return this._sDialect};s.prototype.setActiveDialect=function(t){for(var i in e){if(t===e[i]){this._sDialect=t}}};r=new s;return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/Dialects", [],function(){"use strict";return{OPA5:"OPA5",RAW:"RAW",UIVERI5:"UIVERI5",WDI5:"WDI5"}});
/*!
* OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/testrecorder/Recorder", ["sap/base/Log","sap/ui/base/ManagedObject","sap/ui/testrecorder/CommunicationBus","sap/ui/core/Supportability"],function(t,e,r,i){"use strict";var n=null;var o=null;var s=null;var a=null;var u=e.extend("sap.ui.testrecorder.Recorder",{constructor:function(){if(!a){e.apply(this,arguments)}else{t.warning("Only one Recorder allowed");return a}}});u.prototype.start=function(t){if(this._hasStarted){return}this._hasStarted=true;this._testRecorderConfig=t||i.getTestRecorderSettings();if(this._testRecorderConfig&&!this._testRecorderConfig.indexOf("silent")>-1&&!this._isInIframe()){sap.ui.require(["sap/ui/testrecorder/UIContextInjector","sap/ui/testrecorder/inspector/ControlInspector","sap/ui/testrecorder/interaction/RecordListener"],function(t,e,i){n=t;o=e;s=i;n.injectFrame(this._testRecorderConfig,this._stop.bind(this));r.allowFrame(n.getCommunicationInfo());o.init();s.init()}.bind(this))}};u.prototype._stop=function(){this._hasStarted=false;o.stop();s.stop()};u.prototype._isInIframe=function(){try{if(window.self!==window.top){var t="#sap-ui-test-recorder-frame";if(window.top.$&&window.top.$(t).length&&window.top.$(t)[0].contentWindow===window.self){return true}else{return false}}}catch(t){return true}};a=new u;return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/UIContextInjector", ["sap/ui/thirdparty/jquery","sap/ui/thirdparty/URI","sap/ui/base/Object","sap/base/util/restricted/_debounce","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels","sap/ui/testrecorder/Constants"],function(jQuery,e,t,i,o,s,n){"use strict";var r=null;var a=false;var d=t.extend("sap.ui.testrecorder.UIContextInjector",{constructor:function(){if(!r){t.apply(this,arguments);this._sIdentifier=f()}else{return r}}});d.prototype.injectFrame=function(e,t){window.communicationWindows=window.communicationWindows||{};this._generateTestRecorderUrl();this.fnOnClose=t;this._isInIframe=e.indexOf("window")===-1;this._onResizeHandleMouseover=c.bind(this);this._onResizeHandleMousedown=u.bind(this);this._onResizeHandleMouseleave=l.bind(this);this._onDocumentMouseup=h.bind(this);this._onDocumentMousemove=m.bind(this);if(this._isInIframe){this.dockFrameBottom()}else{this._openWindow()}o.subscribe(s.MINIMIZE_IFRAME,this.minimizeFrame.bind(this));o.subscribe(s.SHOW_IFRAME,this.unminimizeFrame.bind(this));o.subscribe(s.CLOSE_IFRAME,this.close.bind(this));o.subscribe(s.OPEN_NEW_WINDOW,this.openNewWindow.bind(this));o.subscribe(s.DOCK_IFRAME_BOTTOM,this.dockFrameBottom.bind(this));o.subscribe(s.DOCK_IFRAME_RIGHT,this.dockFrameRight.bind(this));o.subscribe(s.DOCK_IFRAME_LEFT,this.dockFrameLeft.bind(this))};d.prototype.minimizeFrame=function(){this._iframe.style.width=n.FRAME.MINIMIZED.width;this._iframe.style.height=n.FRAME.MINIMIZED.height;Object.values(this._resizeHandles).forEach(function(e){e.style.display="none"})};d.prototype.unminimizeFrame=function(){switch(this._sRememberedDockSide){case n.DOCK.RIGHT:this.dockFrameRight();break;case n.DOCK.LEFT:this.dockFrameLeft();break;case n.DOCK.BOTTOM:default:this.dockFrameBottom();break}};d.prototype.dockFrameBottom=function(){this._dockFrame(n.DOCK.BOTTOM)};d.prototype.dockFrameRight=function(){this._dockFrame(n.DOCK.RIGHT)};d.prototype.dockFrameLeft=function(){this._dockFrame(n.DOCK.LEFT)};d.prototype._dockFrame=function(e){if(!this._iframe){this._dockStarted=true;this.close();this._openFrame()}this._sRememberedDockSide=e;for(var t in n.FRAME[e]){this._iframe.style[t]=n.FRAME[e][t]}Object.values(this._resizeHandles).forEach(function(e){e.style.display="none"});this._resizeHandles[e].style.display="block";for(var i in n.RESIZE_HANDLE[e]){this._resizeHandles[e].style[i]=n.RESIZE_HANDLE[e][i]}};d.prototype.openNewWindow=function(){this._dockStarted=true;this.close();this._openWindow()};d.prototype._openWindow=function(){window.communicationWindows.testRecorder=window.open(this._sUrl,"sapUiTestRecorder","width=1024,height=700,status=no,toolbar=no,menubar=no,resizable=yes,location=no,directories=no,scrollbars=yes");window.communicationWindows.testRecorder.document.title="Test Recorder";p();this._isInIframe=false;this._dockStarted=false;this._closeTriggered=false;setTimeout(function(){var e=function(){window.communicationWindows.testRecorder.removeEventListener("beforeunload",e);if(!this._dockStarted&&!this._closeTriggered){this.close()}}.bind(this);if(window.communicationWindows.testRecorder.closed){if(!this._dockStarted&&!this._closeTriggered){this.close()}}else{window.communicationWindows.testRecorder.addEventListener("beforeunload",e)}}.bind(this),1e3)};d.prototype._openFrame=function(){var e=document.createElement("IFRAME");var t=document.createElement("DIV");var i=this._createResizeHandle(jQuery.extend(n.RESIZE_HANDLE.BOTTOM,{cursor:"n-resize",resize:function(e,t){e.style.top=t.y+"px";this._iframe.style.height="calc(100% - "+t.y+"px)"}.bind(this)}));var o=this._createResizeHandle(jQuery.extend(n.RESIZE_HANDLE.RIGHT,{cursor:"e-resize",resize:function(e,t){e.style.left=t.x+"px";this._iframe.style.left=t.x+"px";this._iframe.style.width="calc(100% - "+t.x+"px)"}.bind(this)}));var s=this._createResizeHandle(jQuery.extend(n.RESIZE_HANDLE.LEFT,{cursor:"w-resize",resize:function(e,t){e.style.left=t.x+"px";this._iframe.style.width=t.x+"px"}.bind(this)}));t.id=n.RESIZE_OVERLAY_ID;t.style.position="absolute";t.style.width="100%";t.style.height="100%";t.style.top="0";t.style.left="0";t.style["z-index"]=n.RESIZE_OVERLAY_ZINDEX;t.style.display="none";e.id=n.IFRAME_ID;e.src=this._sUrl;e.style.position="absolute";e.style.border="none";e.style.borderRadius="1px";e.style["z-index"]=n.IFRAME_ZINDEX;e.style.boxShadow="1px -10px 42px -4px #888";document.body.appendChild(i);document.body.appendChild(o);document.body.appendChild(s);document.body.appendChild(t);document.body.appendChild(e);window.communicationWindows.testRecorder=e.contentWindow;p();this._iframe=e;this._resizeOverlay=t;this._resizeHandles={BOTTOM:i,RIGHT:o,LEFT:s};this._dockStarted=false;this._isInIframe=true;this._closeTriggered=false};d.prototype.close=function(){if(this._closeTriggered){return}this._closeTriggered=true;if(this._isInIframe){var e=this._iframe&&this._iframe.contentWindow;if(e){this._iframe.src="about:blank";e.close();if(typeof CollectGarbage=="function"){CollectGarbage()}this._iframe.remove();this._resizeOverlay.remove();Object.values(this._resizeHandles).forEach(function(e){e.remove()});this._iframe=null;this._resizeOverlay=null;this._resizeHandles={}}}else if(window.communicationWindows.testRecorder){window.communicationWindows.testRecorder.close()}if(!this._dockStarted){window.communicationWindows={};this.fnOnClose()}};d.prototype.getCommunicationInfo=function(){return{origin:this._sOrigin,identifier:this._sIdentifier,url:this._sUrl}};d.prototype._generateTestRecorderUrl=function(){var t=(new e).search(true);var i=["sap-language"];var o=["sap-ui-testRecorder"];var s=Object.keys(t).map(function(e){if(o.indexOf(e)===-1&&e.startsWith("sap-ui-")||i.indexOf(e)>-1){return"&"+e+"="+t[e]}}).join("");this._sUrl=sap.ui.require.toUrl("sap/ui/testrecorder/ui/overlay.html")+"?sap-ui-testrecorder-origin="+window.location.protocol+"//"+window.location.host+"&"+"sap-ui-testrecorder-frame-identifier="+this._sIdentifier+s;var n=new e(this._sUrl);this._sOrigin=(n.protocol()||window.location.protocol.replace(":",""))+"://"+(n.host()||window.location.host)};d.prototype._createResizeHandle=function(e){var t=document.createElement("DIV");t.id=e.id;t.style.position="absolute";t.style.width=e.width;t.style.height=e.height;t.style.left=e.left;t.style.top=e.top;t.style["z-index"]=n.RESIZE_HANDLE_ZINDEX;t.style.cursor=e.cursor;t.style.display="none";t.onmouseover=this._onResizeHandleMouseover(t);t.onmousedown=this._onResizeHandleMousedown(t,e.resize);t.onmouseleave=this._onResizeHandleMouseleave(t);return t};function c(e){return function(){e.style.background="#0854a0"}}function u(e,t){return function(i){i.preventDefault();a=true;this._resizeOverlay.style.display="block";document.onmouseup=this._onDocumentMouseup;document.onmousemove=this._onDocumentMousemove(e,t)}.bind(this)}function l(e){return function(){if(!a){e.style.background="transparent"}}}function h(){a=false;this._resizeOverlay.style.display="none";document.onmouseup=null;document.onmousemove=null}function m(e,t){return i(function(i){i.preventDefault();var o=150;t(e,{x:Math.max(Math.min(i.clientX,window.innerWidth-o),o),y:Math.max(Math.min(i.clientY,window.innerHeight-o),o)})},50)}function f(){return""+Date.now()}function p(){var e=window.document.getElementById("sap-ui-bootstrap");if(e&&e.dataset.sapUiLanguage){_(function(t){t.dataset.sapUiLanguage=e.dataset.sapUiLanguage})}if(e&&e.dataset.sapUiConfig){e.dataset.sapUiConfig.split(",").forEach(function(e){if(e.startsWith("language:")){_(function(t){t.dataset.sapUiConfig=t.dataset.sapUiConfig?t.dataset.sapUiConfig+","+e:e})}})}if(window["sap-ui-config"]?.language){window.communicationWindows.testRecorder["sap-ui-config"]=window.communicationWindows.testRecorder["sap-ui-config"]||{};window.communicationWindows.testRecorder["sap-ui-config"].language=window["sap-ui-config"].language}}function _(e){var t=window.communicationWindows.testRecorder.document.getElementById("sap-ui-bootstrap");if(t){e(t)}else{setTimeout(function(){_(e)},10)}}r=new d;return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/codeSnippets/CodeSnippetProvider", ["sap/ui/base/Object","sap/ui/testrecorder/codeSnippets/OPA5ControlSnippetGenerator","sap/ui/testrecorder/codeSnippets/RawControlSnippetGenerator","sap/ui/testrecorder/codeSnippets/UIVeri5ControlSnippetGenerator","sap/ui/testrecorder/codeSnippets/WDI5ControlSnippetGenerator","sap/ui/testrecorder/DialectRegistry","sap/ui/testrecorder/Dialects"],function(e,t,r,n,i,o,p){"use strict";var s=null;var c=e.extend("sap.ui.testrecorder.codeSnippets.ControlSnippetProvider",{constructor:function(){if(!s){e.apply(this,arguments)}else{return s}}});c.prototype.getSnippet=function(e){var t=c.getGenerator(o.getActiveDialect());return t.getSnippet(e).then(function(e){return e})};c.getGenerator=function(e){switch(e){case p.OPA5:return t;case p.RAW:return r;case p.UIVERI5:return n;case p.WDI5:return i;default:return r}};s=new c;return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/codeSnippets/ControlSnippetGenerator", ["sap/base/util/deepExtend","sap/ui/base/Object"],function(e,t){"use strict";var r=t.extend("sap.ui.testrecorder.codeSnippets.ControlSnippetGenerator",{});r.prototype.getSnippet=function(t){return new Promise(function(r,n){if(!t||!t.controlSelector){n(new Error("Control selector is required!"))}var o=this._generate(e({},t));r(o)}.bind(this))};r.prototype._generate=function(){return""};r.prototype._getSelectorAsString=function(e){var t=JSON.stringify(e,undefined,4);return t.replace(/\"([^(\")"]+)\":/g,"$1:")};r.prototype._getIndentation=function(e){var t="";for(var r=0;r<e*4;r+=1){t+=" "}return t};r.prototype._escapeQuotes=function(e){return e.replace(/"/g,'\\"')};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/codeSnippets/OPA5ControlSnippetGenerator", ["sap/ui/testrecorder/codeSnippets/ControlSnippetGenerator","sap/ui/testrecorder/interaction/Commands","sap/base/strings/capitalize"],function(t,e,n){"use strict";var r=t.extend("sap.ui.testrecorder.codeSnippets.OPA5ControlSnippetGenerator",{});r.prototype._generate=function(t){var e=t.controlSelector.interaction&&t.controlSelector.interaction.idSuffix;var n=this._getActionAsString(t.action,e);var r=this._getAssertionAsString(t.assertion);if(n){t.controlSelector.actions=[]}if(r){t.controlSelector.success=[]}delete t.controlSelector.interaction;var o=this._getSelectorAsString(t.controlSelector);var i=this._getSelectorWithAction(o,n);var s=this._getSelectorWithAssertion(i,r);return"this.waitFor("+s+");"};r.prototype._getActionAsString=function(t,n){n=n?'idSuffix: "'+n+'"':"";var r;switch(t){case e.PRESS:r=n&&"{\n"+this._getIndentation(3)+n+"\n"+this._getIndentation(2)+"}";return"new Press("+r+")";case e.ENTER_TEXT:r="{\n"+this._getIndentation(2)+(n&&n+",\n"+this._getIndentation(2))+'text: "test"'+"\n"+this._getIndentation(1)+"}";return"new EnterText("+r+")";default:return""}};r.prototype._getAssertionAsString=function(t){if(t){var e="oControl.get"+n(t.propertyName)+"()";if(!t.expectedValue||t.expectedValue==="false"){return"Opa5.assert.ok(!"+e+");"}else if(t.propertyType==="boolean"){return"Opa5.assert.ok("+e+");"}else{var r=this._escapeQuotes(t.expectedValue);return"Opa5.assert.strictEqual("+e+', "'+r+'");'}}else{return""}};r.prototype._getSelectorWithAction=function(t,e){return t.replace("actions: []","actions: "+e)};r.prototype._getSelectorWithAssertion=function(t,e){return t.replace("success: []","success: function (vControls) {\n"+this._getIndentation(2)+"var oControl = vControls[0] || vControls;\n"+this._getIndentation(2)+e+"\n"+this._getIndentation(1)+"}")};return new r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/codeSnippets/POMethodUtil", ["sap/ui/base/Object","sap/ui/testrecorder/interaction/Commands"],function(e,t){"use strict";var n=null;var r=e.extend("sap.ui.testrecorder.codeSnippets.POMethodUtil",{constructor:function(){if(!n){e.apply(this,arguments)}else{return n}}});r.prototype.getPOMethod=function(e,t,n){if(t&&t.formatAsPOMethod){var r=e.map(function(e){return e.replace(/^/gm,"    ")}).join("\n\n");if(n){return this._getMethodName(t)+": async () => {\n"+r+"\n}"}else{return this._getMethodName(t)+": function () {\n"+r+"\n}"}}else{return e.join("\n\n")}};r.prototype._getMethodName=function(e){if(e.multipleSnippets){switch(e.action){case t.PRESS:case t.ENTER_TEXT:return"iInteractWithTheControls";default:return"iAssertTheUIState"}}else{switch(e.action){case t.PRESS:return"iPressTheControl";case t.ENTER_TEXT:return"iEnterTextInTheControl";default:return"iAssertTheControlState"}}};n=new r;return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/codeSnippets/RawControlSnippetGenerator", ["sap/ui/testrecorder/codeSnippets/ControlSnippetGenerator"],function(e){"use strict";var t=e.extend("sap.ui.testrecorder.codeSnippets.RawControlSnippetGenerator",{});t.prototype._generate=function(e){return JSON.stringify(e.controlSelector,undefined,4)};return new t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/codeSnippets/RawSnippetUtil", ["sap/ui/base/Object"],function(e){"use strict";var n=null;var t=e.extend("sap.ui.testrecorder.codeSnippets.RawSnippetUtil",{constructor:function(){if(!n){e.apply(this,arguments)}else{return n}}});t.prototype.getJSON=function(e,n){if(n.multipleSnippets){var t=e.map(function(e){return e.replace(/^/gm,"        ")}).join(",\n");return'{\n    "selectors": [\n'+t+"\n    ]\n}"}else{return e[0]}};n=new t;return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/codeSnippets/UIVeri5ControlSnippetGenerator", ["sap/ui/testrecorder/codeSnippets/ControlSnippetGenerator","sap/ui/testrecorder/interaction/Commands"],function(e,t){"use strict";var r=e.extend("sap.ui.testrecorder.codeSnippets.UIVeri5ControlSnippetGenerator",{});r.prototype._generate=function(e){var t="element(by.control("+this._getSelectorAsString(e.controlSelector)+"))";var r=this._getSelectorWithAssertion(t,e.assertion);return r+this._getActionAsString(e.action)+";"};r.prototype._getActionAsString=function(e){switch(e){case t.PRESS:return".click()";case t.ENTER_TEXT:return'.sendKeys("test")';default:return""}};r.prototype._getSelectorWithAssertion=function(e,t){if(t){var r;if(!t.expectedValue||t.expectedValue==="false"){r=".toBeFalsy()"}else if(t.propertyType==="boolean"){r=".toBeTruthy()"}else{var o=this._escapeQuotes(t.expectedValue);r='.toEqual("'+o+'")'}return"expect("+e+'.asControl().getProperty("'+t.propertyName+'"))'+r}else{return e}};return new r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/codeSnippets/WDI5ControlSnippetGenerator", ["sap/ui/testrecorder/codeSnippets/ControlSnippetGenerator","sap/ui/testrecorder/interaction/Commands"],function(e,t){"use strict";var r=e.extend("sap.ui.testrecorder.codeSnippets.WDI5ControlSnippetGenerator",{});r.prototype._generate=function(e){var t="await browser.asControl({\n\tselector: "+this._getSelectorAsString(e.controlSelector)+"})";var r=this._getSelectorWithAssertion(t,e.assertion);return r+this._getActionAsString(e.action)+";"};r.prototype._getSelectorAsString=function(e){var t=JSON.stringify(e,undefined,8);return t.replace(/\"([^(\")"]+)\":/g,"$1:")};r.prototype._getActionAsString=function(e){switch(e){case t.PRESS:return".press()";case t.ENTER_TEXT:return'.enterText("test")';default:return""}};r.prototype._getSelectorWithAssertion=function(e,t){if(t){var r;if(!t.expectedValue||t.expectedValue==="false"){r=".toBeFalsy()"}else if(t.propertyType==="boolean"){r=".toBeTruthy()"}else{var o=this._escapeQuotes(t.expectedValue);r='.toEqual("'+o+'")'}var n=t.propertyName[0].toUpperCase()+t.propertyName.slice(1);return"const "+t.propertyName+" = "+e+".get"+n+"();\nexpect("+t.propertyName+")"+r}else{return e}};return new r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/controlSelectors/ControlSelectorGenerator", ["sap/ui/base/Object","sap/ui/test/RecordReplay"],function(e,t){"use strict";var n=e.extend("sap.ui.testrecorder.controlSelectors.ControlSelectorGenerator",{});n.prototype.getSelector=function(e){var n=o(e);return t.findControlSelectorByDOMElement({domElement:n,settings:e.settings}).then(function(e){return e})};function o(e){if(e.domElementId&&typeof e.domElementId==="string"){return document.getElementById(e.domElementId)}else if(e.controlId){return sap.ui.getCore().byId(e.controlId).getFocusDomRef()}}return new n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/inspector/ControlAPI", ["sap/ui/base/Object","sap/ui/core/support/ToolsAPI","sap/ui/test/_ControlFinder"],function(e,t,r){"use strict";var o=e.extend("sap.ui.testrecorder.inspector.ControlAPI",{});var n="default";var a="none";o.prototype.getFrameworkData=function(){var e=t.getFrameworkInformation();return{framework:{name:e.commonInformation.frameworkName,version:e.commonInformation.version}}};o.prototype.getAllControlData=function(){var e=t.getRenderedControlTree();return{renderedControls:e}};o.prototype.getControlData=function(e){var t;if(e.controlId){t=e.controlId}else if(e.domElementId){var o=r._getControlForElement(e.domElementId);if(o){t=o.getId()}else{return{}}}var n=this._getFormattedProperties(t);var a=this._getFormattedBindings(t);return{properties:n,bindings:a}};o.prototype._getFormattedProperties=function(e){var r=t.getControlProperties(e);r.own=[r.own];var o={};["own","inherited"].forEach(function(e){o[e]=[];r[e].forEach(function(t){Object.keys(t.properties).forEach(function(r){var n=t.properties[r];o[e].push({inheritedFrom:t.meta.controlName,property:r,value:n.value===undefined?"":n.value,type:n.type})})})});return o};o.prototype._getFormattedBindings=function(e){var r=t.getControlBindings(e);var o=r.contextPath?r.contextPath+"/":"";var i=Object.keys(r.properties)[0]&&r.properties[Object.keys(r.properties)[0]];var p=i&&i.model.names[0]||n;var s={context:[{path:r.contextPath||a,model:p}],properties:[],aggregations:[]};Object.keys(r.properties).forEach(function(e){var t=r.properties[e];s.properties.push({property:e,relativePath:t.path,absolutePath:o+t.path,model:t.model.names[0]||n})});Object.keys(r.aggregations).forEach(function(e){var t=r.aggregations[e].model;s.aggregations.push({aggregation:e,relativePath:t.path,absolutePath:o+t.path,model:t.names[0]||n})});return s};return new o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/inspector/ControlInspector", ["sap/ui/base/Object","sap/base/util/extend","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels","sap/ui/testrecorder/mutationObservers/AppMutationObserver","sap/ui/testrecorder/mutationObservers/ElementMutationObserver","sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/test/_ControlFinder","sap/ui/testrecorder/inspector/ControlAPI","sap/ui/testrecorder/inspector/ControlInspectorRepo","sap/ui/testrecorder/Constants","sap/ui/testrecorder/DialectRegistry","sap/ui/testrecorder/Dialects","sap/ui/testrecorder/controlSelectors/ControlSelectorGenerator","sap/ui/testrecorder/codeSnippets/POMethodUtil","sap/ui/testrecorder/codeSnippets/RawSnippetUtil","sap/ui/testrecorder/codeSnippets/CodeSnippetProvider","sap/ui/testrecorder/ui/models/SharedModel"],function(e,t,i,r,s,n,o,p,a,l,c,d,u,h,g,E,b,C){"use strict";var S=null;var f=new o(c.HIGHLIGHTER_ID);var m=Object.assign({},C.getData().settings);var I=e.extend("sap.ui.testrecorder.inspector.ControlInspector",{constructor:function(){if(!S){e.apply(this,arguments);this._appObserver=new s(this.getAllControlData.bind(this));this._selectedElementObserver=new n(this.getControlData.bind(this))}else{return S}}});I.prototype.init=function(){this._appObserver.start();i.subscribe(r.REQUEST_ALL_CONTROLS_DATA,this.getAllControlData.bind(this));i.subscribe(r.REQUEST_CONTROL_DATA,this.getControlData.bind(this));i.subscribe(r.REQUEST_CODE_SNIPPET,this.getCodeSnippet.bind(this));i.subscribe(r.HIGHLIGHT_CONTROL,this.highlightControl.bind(this));i.subscribe(r.SET_DIALECT,this.setDialect.bind(this));i.subscribe(r.UPDATE_SETTINGS,this.updateSettings.bind(this));i.subscribe(r.CLEAR_SNIPPETS,this.clearSnippets.bind(this))};I.prototype.getAllControlData=function(){i.publish(r.RECEIVE_ALL_CONTROLS_DATA,{renderedControls:a.getAllControlData().renderedControls,framework:a.getFrameworkData().framework});l.clear()};I.prototype.getControlData=function(e){var t=e.domElementId?document.getElementById(e.domElementId):sap.ui.getCore().byId(e.controlId).getDomRef();this._selectedElementObserver.stop();this._selectedElementObserver.start(t);var s=a.getControlData(e);i.publish(r.RECEIVE_CONTROL_DATA,s)};I.prototype.getCodeSnippet=function(e){var s=Object.assign({},e,{settings:m});var n=l.findSelector(e.domElementId);var o=n?Promise.resolve(n):h.getSelector(s);return o.then(function(e){n=e;return b.getSnippet({controlSelector:e,action:s.action,assertion:s.assertion,settings:m})}).then(function(i){l.save(e,n,i);var r=m.multipleSnippets?l.getSnippets():[i];if(d.getActiveDialect()===u.RAW){return E.getJSON(r,m)}else{return g.getPOMethod(r,t({action:e.action,assertion:e.assertion},m),d.getActiveDialect()===u.WDI5)}}).then(function(e){i.publish(r.RECEIVE_CODE_SNIPPET,{codeSnippet:e})}).catch(function(t){i.publish(r.RECEIVE_CODE_SNIPPET,{error:"Could not generate code snippet for "+JSON.stringify(e)+". Details: "+t,domElementId:s.domElementId})})};I.prototype.highlightControl=function(e){if(e.domElementId){f.highlight(e.domElementId)}else if(e.controlId){var t=p._findElements({id:e.controlId})[0];if(t){f.highlight(t.id)}}};I.prototype.setDialect=function(e){if(d.getActiveDialect()!==e){d.setActiveDialect(e);i.publish(r.DIALECT_CHANGED,{dialect:e});l.getRequests().forEach(this.getCodeSnippet.bind(this))}};I.prototype.updateSettings=function(e){Object.assign(m,e);var t=l.getRequests();if(D(e,"multipleSnippets")){this.clearSnippets();if(t.length){this.getCodeSnippet(t[t.length-1])}}if(D(e,["preferViewId"])){l.clear()}if(D(e,["formatAsPOMethod","preferViewId"])){if(m.multipleSnippets){t.forEach(this.getCodeSnippet.bind(this))}else if(t.length){this.getCodeSnippet(t[t.length-1])}}};I.prototype.clearSnippets=function(){l.clear();i.publish(r.RECEIVE_CODE_SNIPPET,{codeSnippet:""})};I.prototype.stop=function(){this._appObserver.stop();this._selectedElementObserver.stop()};function D(e,t){var i=Array.isArray(t)?t:[t];return i.filter(function(t){return e[t]!==null&&e[t]!==undefined}).length}S=new I;return S},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/inspector/ControlInspectorRepo", ["sap/ui/base/Object"],function(t){"use strict";var e=null;var n=[];var r=100;var o=t.extend("sap.ui.testrecorder.inspector.ControlInspectorRepo",{constructor:function(){if(!e){t.apply(this,arguments)}else{return e}}});o.prototype.findSelector=function(t){var e=n.filter(function(e){return e.domElementId===t&&e.selector});return e[0]&&e[0].selector||null};o.prototype.save=function(t,e,o){var i=Object.assign({selector:e,snippet:o},t);var s=-1;n.forEach(function(e,n){if(e.domElementId===t.domElementId&&JSON.stringify(e.assertion)===JSON.stringify(t.assertion)){s=n}});if(s>-1){n[s]=i}else{if(n.length===r){n.shift()}n.push(i)}};o.prototype.clear=function(){n=[]};o.prototype.getRequests=function(){return n.map(function(t){return{domElementId:t.domElementId,action:t.action,assertion:t.assertion}})};o.prototype.getSelectors=function(){return n.map(function(t){return t.selector})};o.prototype.getSnippets=function(){return n.map(function(t){return t.snippet})};o.prototype.getAll=function(){return n};e=new o;return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/interaction/Assert", ["sap/ui/test/_ControlFinder","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels","sap/ui/testrecorder/interaction/Commands"],function(e,t,n,i){"use strict";return{execute:function(o){var r=e._getIdentifiedDOMElementId("#"+o.domElementId);t.publish(n.SELECT_CONTROL_IN_TREE,{rootElementId:r,interactionElementId:o.domElementId,action:i.ASSERT,assertion:o.assertion})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/interaction/CommandExecutor", ["sap/ui/testrecorder/interaction/Commands","sap/ui/testrecorder/interaction/Highlight","sap/ui/testrecorder/interaction/Press","sap/ui/testrecorder/interaction/EnterText","sap/ui/testrecorder/interaction/Assert"],function(e,t,r,n,s){"use strict";return{execute:function(c,a){switch(c){case"HIGHLIGHT":t.execute(a.domElementId);break;case"PRESS":r.execute(a.domElementId);break;case"ENTER_TEXT":n.execute(a.domElementId);break;case"ASSERT":s.execute(a);break;default:throw new Error("Command "+c+" is not known! Known commands are: "+Object.keys(e))}}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/interaction/Commands", [],function(){"use strict";return{HIGHLIGHT:"HIGHLIGHT",PRESS:"PRESS",ENTER_TEXT:"ENTER_TEXT",ASSERT:"ASSERT"}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/interaction/ContextMenu", ["sap/ui/thirdparty/jquery","sap/ui/base/Object","sap/ui/core/Element","sap/ui/core/StaticArea","sap/ui/testrecorder/Constants","sap/ui/testrecorder/interaction/Commands","sap/ui/testrecorder/interaction/CommandExecutor","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels"],function(e,t,o,i,n,s,r,c,a){"use strict";var u=5;var d=null;var f={};var l={};var p={};var h=t.extend("sap.ui.testrecorder.interaction.ContextMenu",{});h.show=function(t){f=t.domElementId;if(d===null&&!document.getElementById(n.CONTEXTMENU_ID)){d=v(t)}if(t.items){var s=Object.keys(l).filter(function(e){return!(t.items[e]||t.items[e]===undefined)});var r=Object.keys(l).filter(function(e){return t.items[e]||t.items[e]===undefined});if(s.length===Object.keys(l).length){this.hide();return this}s.forEach(function(e){l[e].hide()});r.forEach(function(e){l[e].show()})}var c=e(i.getDomRef());e.map(c.find(":visible"),function(e){var t=o.closestTo(e);if(t){if(t.oPopup&&t.oPopup.setAutoClose&&!p[t.getId()]){p[t.getId()]={autoClose:t.oPopup.getAutoClose()};t.oPopup.setAutoClose(false)}}});var a=e(window).width();var E=e(window).height();var m=d.width();var b=d.height();var x=t.location.x+m+u>=a?t.location.x-m:t.location.x;var T=t.location.y+b+u>=E?t.location.y-b:t.location.y;d.css("top",T+u+"px");d.css("left",x+u+"px");h._show();return this};h.hide=function(){if(d){d.hide()}Object.keys(p).forEach(function(e){var t=sap.ui.getCore().byId(e).oPopup;t.setAutoClose(p[e].autoClose);t._$().focus()});p={}};h._show=function(){if(d){d.show()}};function v(t){var o=e("<div></div>");var i=e("<div></div>");var u=e("<div></div>");var d=e("<div></div>");l={highlight:i,press:u,enterText:d};i.text("Highlight");u.text("Press");d.text("Enter Text");i.on("click",function(){h.hide();var e={domElementId:f};if(t.withEvents){c.publish(a.CONTEXT_MENU_HIGHLIGHT,e)}else{r.execute(s.HIGHLIGHT,e)}});u.on("click",function(){h.hide();var e={domElementId:f};if(t.withEvents){c.publish(a.CONTEXT_MENU_PRESS,e)}else{r.execute(s.PRESS,e)}});d.on("click",function(){h.hide();var e={domElementId:f};if(t.withEvents){c.publish(a.CONTEXT_MENU_ENTER_TEXT,e)}else{r.execute(s.ENTER_TEXT,e)}});o.attr("id",n.CONTEXTMENU_ID);o.css("min-width","150px");o.css("position","absolute");o.css("z-index",1001);o.css("border","1px solid rgb(200, 142, 250)");o.css("border-radius","3px");o.css("background","#fff");o.css("box-sizing","border-box");[i,d,u].forEach(function(e){e.css("padding","16px");e.css("cursor","pointer");e.on("mouseenter",function(){e.css("background-color","#ebf5fe")}).on("mouseleave",function(){e.css("background-color","transparent")})});[i,u].forEach(function(e){e.css("border-bottom","1px solid #d9d9d9")});o.append(i);o.append(u);o.append(d);e(document.body).append(o);return o}return h});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/interaction/EnterText", ["sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/test/_ControlFinder","sap/ui/testrecorder/Constants","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels","sap/ui/testrecorder/interaction/Commands"],function(e,t,i,n,r,s){"use strict";var o=new e(i.HIGHLIGHTER_ID);return{execute:function(e){var i=t._getIdentifiedDOMElementId("#"+e);o.highlight(i);n.publish(r.SELECT_CONTROL_IN_TREE,{rootElementId:i,interactionElementId:e,action:s.ENTER_TEXT})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/interaction/Highlight", ["sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/test/_ControlFinder","sap/ui/testrecorder/Constants","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels"],function(e,t,i,n,r){"use strict";var s=new e(i.HIGHLIGHTER_ID);return{execute:function(e,i){var u=t._getIdentifiedDOMElementId("#"+e);s.highlight(u);n.publish(r.SELECT_CONTROL_IN_TREE,{rootElementId:u,interactionElementId:e})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/interaction/Press", ["sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/test/_ControlFinder","sap/ui/testrecorder/Constants","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels","sap/ui/testrecorder/interaction/Commands"],function(e,t,i,n,r,s){"use strict";var o=new e(i.HIGHLIGHTER_ID);return{execute:function(e){var i=t._getIdentifiedDOMElementId("#"+e);o.highlight(i);n.publish(r.SELECT_CONTROL_IN_TREE,{rootElementId:i,interactionElementId:e,action:s.PRESS})}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/interaction/RecordListener", ["sap/ui/base/Object","sap/ui/testrecorder/interaction/ContextMenu","sap/ui/testrecorder/interaction/CommandExecutor","sap/ui/testrecorder/interaction/Commands","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels"],function(t,e,n,i,o,r){"use strict";var s=null;var u=t.extend("sap.ui.testrecorder.interaction.RecordListener",{constructor:function(){if(!s){t.apply(this,arguments);this._fnClickListener=this._onClick.bind(this);this._fnContextmenuListener=this._onContextmenu.bind(this)}else{return s}}});u.prototype.init=function(){document.addEventListener("click",this._fnClickListener);document.addEventListener("contextmenu",this._fnContextmenuListener);o.subscribe(r.CONTEXT_MENU_HIGHLIGHT,this._onContextHighlight.bind(this));o.subscribe(r.CONTEXT_MENU_PRESS,this._onContextPress.bind(this));o.subscribe(r.CONTEXT_MENU_ENTER_TEXT,this._onContextEnterText.bind(this));o.subscribe(r.ASSERT_PROPERTY,this._onAssertProperty.bind(this))};u.prototype.stop=function(){e.hide();document.removeEventListener("click",this._fnClickListener);document.removeEventListener("contextmenu",this._fnContextmenuListener)};u.prototype._onClick=function(t){t.preventDefault();t.stopPropagation();e.hide()};u.prototype._onContextmenu=function(t){t.preventDefault();var n=c(t.target);e.show({domElementId:n,location:{x:t.pageX,y:t.pageY}})};u.prototype._onContextHighlight=function(t){n.execute(i.HIGHLIGHT,t)};u.prototype._onContextPress=function(t){n.execute(i.PRESS,t)};u.prototype._onAssertProperty=function(t){n.execute(i.ASSERT,t)};u.prototype._onContextEnterText=function(t){n.execute(i.ENTER_TEXT,t)};function c(t){if(t.id){return t.id}else if(t.parentElement){return c(t.parentElement)}else{return""}}s=new u;return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/library", ["sap/ui/core/library","sap/ui/core/Core","sap/ui/support/library"],function(){"use strict";var e=sap.ui.getCore().initLibrary({name:"sap.ui.testrecorder",dependencies:["sap.ui.core","sap.ui.support"],interfaces:[],controls:[],elements:[],noLibraryCSS:true,version:"1.120.22",extensions:{"sap.ui.support":{internalRules:true}}});return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/mutationObservers/AppMutationObserver", ["sap/ui/testrecorder/mutationObservers/MutationObserver"],function(e){"use strict";var t=e.extend("sap.ui.testrecorder.mutationObservers.AppMutationObserver",{metadata:{library:"sap.ui.testrecorder"},_getOptions:function(){return{subtree:true,childList:true}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/mutationObservers/ElementMutationObserver", ["sap/ui/testrecorder/mutationObservers/MutationObserver"],function(t){"use strict";var e=t.extend("sap.ui.testrecorder.mutationObservers.ElementMutationObserver",{metadata:{library:"sap.ui.testrecorder"},_onObservation:function(t){if(this._isValidMutation(t)){this._fnObservationCb({domElementId:this._oTarget.id})}},_getOptions:function(){return{subtree:true,attributes:true}}});return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/mutationObservers/MutationObserver", ["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/testrecorder/Constants","sap/base/util/restricted/_debounce"],function(t,e,n,i){"use strict";var r=e.extend("sap.ui.testrecorder.mutationObservers.MutationObserver",{metadata:{library:"sap.ui.testrecorder"},constructor:function(t){e.call(this);this._fnObservationCb=t;this._observer=new window.MutationObserver(this._onObservation.bind(this))},start:function(t){this._oTarget=t||document.body;this._observer.observe(this._oTarget,this._getOptions())},stop:function(){this._observer.disconnect()},_getOptions:function(){return{}},_onObservation:function(t){return i(function(){this._isValidMutation(t).then(function(t){if(t){this._fnObservationCb()}}.bind(this)).catch(function(t){throw new Error("Erro in mutation observer: "+t)})}.bind(this),100)()},_isValidMutation:function(t){return Promise.all(t.map(function(t){return new Promise(function(e,n){if(this._isRecorderElement(t)){e(false)}else{this._hasHiddenElements(t).then(function(t){e(!t)}).catch(n)}}.bind(this))}.bind(this))).then(function(t){return t.every(Boolean)})},_isRecorderElement:function(t){return[n.HIGHLIGHTER_ID,n.CONTEXTMENU_ID].filter(function(e){return t.target.id===e||t.addedNodes.length&&t.addedNodes[0].id===e||t.removedNodes.length&&t.removedNodes[0].id===e}).length},_hasHiddenElements:function(t){return new Promise(function(e){if(!t.addedNodes.length){e(false)}Promise.all(Array.prototype.map.call(t.addedNodes,function(t){return new Promise(function(e){this._waitForElement(t)().then(function(){e(this._isHidden(t))}.bind(this)).catch(function(){e(true)})}.bind(this))}.bind(this))).then(function(t){e(t.some(Boolean))})}.bind(this))},_waitForElement:function(t){return function(e){e=e||5;return new Promise(function(n,i){if(t instanceof HTMLElement){n()}else if(!e){i()}else{setTimeout(this._waitForElement(e-1),100)}})}},_isHidden:function(e){var n=t(e);return n.is(":hidden")||n.css("visibility")==="hidden"}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/ui/Overlay", ["sap/ui/core/Core","sap/ui/core/mvc/XMLView","sap/m/Page"],function(e,a,i){"use strict";e.attachInit(function(){a.create({viewName:"sap.ui.testrecorder.ui.views.Main"}).then(function(e){var a=new i("page",{showHeader:false,backgroundDesign:"Solid",content:[e]});a.placeAt("content")})})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/ui/controllers/Main.controller", ["sap/ui/thirdparty/jquery","sap/ui/Device","sap/ui/util/Storage","sap/ui/core/mvc/Controller","sap/ui/dom/includeStylesheet","sap/ui/testrecorder/ui/models/SharedModel","sap/ui/testrecorder/CommunicationBus","sap/ui/testrecorder/CommunicationChannels","sap/ui/model/json/JSONModel","sap/ui/model/resource/ResourceModel","sap/ui/model/Binding","sap/m/MessageToast","sap/m/Dialog","sap/m/CheckBox","sap/m/Button","sap/m/VBox","sap/ui/support/supportRules/ui/external/ElementTree","sap/ui/testrecorder/interaction/ContextMenu"],function(e,t,i,o,n,s,r,l,a,d,c,p,h,g,u,m,T,_){"use strict";return o.extend("sap.ui.testrecorder.ui.controllers.Main",{onInit:function(){this._minimized=false;this._selectionId=null;this._localStorage=new i(i.Type.local,"sap-ui-test-recorder");n("sap/ui/testrecorder/ui/styles/overlay.css");this.elementTree=new T(null,{filter:{issues:false,search:true},onSelectionChanged:this._onTreeSelectionChanged.bind(this),onContextMenu:this._onTreeContextMenu.bind(this),onInitialRendering:this._onElementTreeInitialRendering.bind(this)});this._setupModels();this.toggleHeaderToolbars()},onBeforeRendering:function(){r.publish(l.REQUEST_ALL_CONTROLS_DATA)},onAfterRendering:function(){r.subscribe(l.RECEIVE_ALL_CONTROLS_DATA,this._onUpdateAllControls.bind(this));r.subscribe(l.RECEIVE_CONTROL_DATA,this._onReceiveControlDetails.bind(this));r.subscribe(l.RECEIVE_CODE_SNIPPET,this._onUpdateCodeSnippet.bind(this));r.subscribe(l.SELECT_CONTROL_IN_TREE,this._onUpdateSelection.bind(this));r.subscribe(l.DIALECT_CHANGED,this._changeDialect.bind(this))},toggleHeaderToolbars:function(){this.byId("ttMaximizeHeaderBar").setVisible(this._minimized)},toggleMinimize:function(){this._minimized=!this._minimized;this.toggleHeaderToolbars();if(this._minimized){r.publish(l.MINIMIZE_IFRAME)}else{r.publish(l.SHOW_IFRAME)}},dockBottom:function(){r.publish(l.DOCK_IFRAME_BOTTOM)},dockRight:function(){r.publish(l.DOCK_IFRAME_RIGHT)},dockLeft:function(){r.publish(l.DOCK_IFRAME_LEFT)},openWindow:function(){r.publish(l.OPEN_NEW_WINDOW)},close:function(){r.publish(l.CLOSE_IFRAME)},copyCodeSnippet:function(){var e=this.byId("codeEditor").getValue();var i=function(t){if(t.clipboardData){t.clipboardData.setData("text/plain",e)}else{t.originalEvent.clipboardData.setData("text/plain",e)}t.preventDefault()};if(t.browser.msie&&window.clipboardData){window.clipboardData.setData("text",e)}else{document.addEventListener("copy",i);document.execCommand("copy");document.removeEventListener("copy",i)}},clearCodeSnippet:function(){r.publish(l.CLEAR_SNIPPETS);this.byId("codeEditor").setValue("")},openSettingsDialog:function(){if(!this.settingsDialog){this.settingsDialog=new h({title:this.getView().getModel("i18n").getProperty("TestRecorder.SettingsDialog.Title"),content:[new m({items:[new g({text:this.getView().getModel("i18n").getProperty("TestRecorder.SettingsDialog.IDCheckBox.Text"),name:"preferViewId",selected:this.model.getProperty("/settings/preferViewId"),select:this._onSelectCheckBox.bind(this)}),new g({text:this.getView().getModel("i18n").getProperty("TestRecorder.SettingsDialog.POMethodCheckBox.Text"),name:"formatAsPOMethod",selected:this.model.getProperty("/settings/formatAsPOMethod"),select:this._onSelectCheckBox.bind(this)})]})],endButton:new u({text:this.getView().getModel("i18n").getProperty("TestRecorder.SettingsDialog.CloseButton.Text"),press:this.closeSettingsDialog.bind(this)})});this.getView().addDependent(this.settingsDialog)}this.settingsDialog.open()},closeSettingsDialog:function(){if(this.settingsDialog){this.settingsDialog.close()}},handlePropertyIconPress:function(e){var t=e.getSource();var i=t.getParent().getParent();var o=i.getCells()[0].getItems()[1].getText();var n=i.getCells()[1].getText();var s=i.getCells()[2].getText();r.publish(l.ASSERT_PROPERTY,{domElementId:this._selectionId,assertion:{propertyName:o,expectedValue:n,propertyType:s}})},_setupModels:function(){this.model=s;this.getView().setModel(this.model);this.model.setProperty("/isInIframe",!window.opener);var e=this._localStorage.get("dialect");var t=this._localStorage.get("settings-preferViewId");var i=this._localStorage.get("settings-formatAsPOMethod");if(e){this.model.setProperty("/selectedDialect",e);r.publish(l.SET_DIALECT,e)}if(t!==null&&t!=="undefined"){this.model.setProperty("/settings/preferViewId",t)}if(i!==null&&i!=="undefined"){this.model.setProperty("/settings/formatAsPOMethod",i)}r.publish(l.UPDATE_SETTINGS,this.model.getProperty("/settings"));var o=new c(s,"/",s.getContext("/selectedDialect"));o.attachChange(function(){r.publish(l.SET_DIALECT,this.model.getProperty("/selectedDialect"))}.bind(this));var n=new d({bundleName:"sap.ui.core.messagebundle"});this.getView().setModel(n,"i18n");this.getView().setModel(new a({framework:{}}),"framework");this.getView().setModel(new a({controls:{bindings:{},properties:{},codeSnippet:"",renderedControls:[]}}),"controls")},_onUpdateAllControls:function(e){this.elementTree.setContainerId(this.byId("elementTreeContainer").getId());this._clearControlData();if(e.framework){this.getView().getModel("controls").setProperty("/framework",e.framework)}if(e.renderedControls){this.getView().getModel("controls").setProperty("/renderedControls",e.renderedControls);this.elementTree.setData({controls:e.renderedControls})}if(!this._minimized){p.show(this.getView().getModel("i18n").getProperty("TestRecorder.ControlTree.MessageToast"),{duration:1e3})}},_onReceiveControlDetails:function(e){if(e.properties){this.getView().getModel("controls").setProperty("/properties",e.properties)}if(e.bindings){this.getView().getModel("controls").setProperty("/bindings",e.bindings)}},_onUpdateCodeSnippet:function(e){if(e.codeSnippet!==undefined){this.getView().getModel("controls").setProperty("/codeSnippet",e.codeSnippet)}else if(e.error){var t=this.getView().getModel("i18n").getResourceBundle().getText("TestRecorder.Inspect.Snippet.NotFound.Text","#"+e.domElementId);this.getView().getModel("controls").setProperty("/codeSnippet",t)}},_onUpdateSelection:function(e){this._selectionId=e.rootElementId;this.elementTree.setSelectedElement(e.rootElementId,false);this._clearControlData();r.publish(l.REQUEST_CONTROL_DATA,{domElementId:e.rootElementId});r.publish(l.REQUEST_CODE_SNIPPET,{domElementId:e.interactionElementId,action:e.action,assertion:e.assertion});r.publish(l.HIGHLIGHT_CONTROL,{domElementId:e.rootElementId})},_onTreeSelectionChanged:function(e){this._selectionId=e;this._clearControlData();r.publish(l.REQUEST_CONTROL_DATA,{domElementId:e});r.publish(l.REQUEST_CODE_SNIPPET,{domElementId:e});r.publish(l.HIGHLIGHT_CONTROL,{domElementId:e})},_onTreeContextMenu:function(e){e=e||{};e.withEvents=true;e.items={highlight:false};_.show(e)},_onElementTreeInitialRendering:function(){var t=this.elementTree._filterContainer;var i=t.onkeyup;var o=t.onchange;var n=["filter","attributes","namespaces"];var s=this.model;n.forEach(function(i){var o=t.querySelector("["+i+"]");o.checked=s.getProperty("/elementTree/"+i);e(o).change()});var r=t.querySelector("[search]");r.value=s.getProperty("/elementTree/search");e(r).keyup();t.onchange=function(e){n.forEach(function(t){if(e.target.getAttribute(t)!==null){s.setProperty("/elementTree/"+t,e.target.checked)}});o.apply(this,arguments)};t.onkeyup=function(e){s.setProperty("/elementTree/search",e.target.value);i.apply(this,arguments)}},_clearControlData:function(){this.getView().getModel("controls").setProperty("/properties",{});this.getView().getModel("controls").setProperty("/bindings",{});this.getView().getModel("controls").setProperty("/codeSnippet","")},_changeDialect:function(e){this._localStorage.put("dialect",e.dialect)},_onSelectCheckBox:function(e){var t=e.getParameter("selected");var i=e.getSource().getName();var o={};o[i]=t;this.model.setProperty("/settings/"+i,t);this._localStorage.put("settings-"+i,t);r.publish(l.UPDATE_SETTINGS,o)},_onChangeMultiple:function(e){var t=e.getParameter("state");r.publish(l.UPDATE_SETTINGS,{multipleSnippets:t})},_onCodeEditorChange:function(e){var t=this.byId("codeEditor");var i=t.getValue().split("\n").length;if(i){t._oEditor.scrollToLine(i)}}})});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/testrecorder/ui/models/SharedModel", ["sap/ui/model/resource/ResourceModel","sap/ui/model/json/JSONModel","sap/ui/testrecorder/Dialects"],function(e,t,r){"use strict";var s=new e({bundleName:"sap.ui.core.messagebundle"});var l=new t({iFrameTitle:s.getProperty("TestRecorder.TitleBar.Title"),dialects:[{key:r.RAW,label:s.getProperty("TestRecorder.Inspect.Snippet.Dialect.Raw")},{key:r.OPA5,label:s.getProperty("TestRecorder.Inspect.Snippet.Dialect.OPA5")},{key:r.UIVERI5,label:s.getProperty("TestRecorder.Inspect.Snippet.Dialect.UIVeri5")},{key:r.WDI5,label:s.getProperty("TestRecorder.Inspect.Snippet.Dialect.WDI5")}],selectedDialect:r.OPA5,settings:{preferViewId:false,formatAsPOMethod:true,multipleSnippets:false},elementTree:{search:"",filter:false,attributes:false,namespaces:true}});return l});
sap.ui.require.preload({
	"sap/ui/testrecorder/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.testrecorder","type":"library","embeds":[],"applicationVersion":{"version":"1.120.22"},"title":"UI5 library: sap.ui.testrecorder","description":"UI5 library: sap.ui.testrecorder","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":[]},"sap.ui5":{"dependencies":{"minUI5Version":"1.120","libs":{"sap.ui.core":{"minVersion":"1.120.22"}}},"library":{"i18n":false,"css":false,"content":{"controls":[],"elements":[],"types":[],"interfaces":[]}}}}',
	"sap/ui/testrecorder/ui/views/Main.view.xml":'<mvc:View\n\theight="100%"\n\tviewName="sap.ui.testrecorder.ui.views.Main"\n\tcontrollerName="sap.ui.testrecorder.ui.controllers.Main"\n\txmlns="sap.m"\n\txmlns:mvc="sap.ui.core.mvc"\n\txmlns:c= "sap.ui.core"\n\txmlns:l="sap.ui.layout"\n\txmlns:f="sap.ui.layout.form"\n\txmlns:code="sap.ui.codeeditor" ><Page showHeader="false"><l:FixFlex><l:fixContent><Bar id="ttMaximizeHeaderBar" class="sapContrast ttPageBar ttMiniPageBar"><contentMiddle><Image src="../ui/images/Logo_O_22x22.png" densityAware="false"></Image><Text text="{/iFrameTitle}" /><c:Icon src="sap-icon://full-screen" press="toggleMinimize" /></contentMiddle></Bar><Bar id="ttStandardHeaderBar" class="sapContrast ttPageBar ttStandardPageBar"><contentLeft><Image src="../ui/images/Logo_O_22x22.png" densityAware="false"></Image><Text text="{/iFrameTitle}" /></contentLeft><contentMiddle><Text text="{controls>/framework/name} {controls>/framework/version}" /></contentMiddle><contentRight><c:Icon src="sap-icon://settings" press="openSettingsDialog" tooltip="{i18n>TestRecorder.TitleBar.Window.Settings.Tooltip}"/><c:Icon src="sap-icon://minimize" press="toggleMinimize" tooltip="{i18n>TestRecorder.TitleBar.Window.Minimize.Tooltip}" visible="{/isInIframe}" /><c:Icon src="sap-icon://slim-arrow-down" press="dockBottom" tooltip="{i18n>TestRecorder.TitleBar.Window.Dock.Bottom.Tooltip}" /><c:Icon src="sap-icon://slim-arrow-left" press="dockLeft" tooltip="{i18n>TestRecorder.TitleBar.Window.Dock.Left.Tooltip}" /><c:Icon src="sap-icon://slim-arrow-right" press="dockRight" tooltip="{i18n>TestRecorder.TitleBar.Window.Dock.Right.Tooltip}" /><c:Icon src="sap-icon://popup-window" press="openWindow" tooltip="{i18n>TestRecorder.TitleBar.Window.New.Tooltip}" visible="{/isInIframe}"/><c:Icon src="sap-icon://decline" press="close" tooltip="{i18n>TestRecorder.TitleBar.Window.Close.Tooltip}"/></contentRight></Bar></l:fixContent><l:flexContent><l:ResponsiveSplitter defaultPane="tree-pane"><l:PaneContainer><l:SplitPane requiredParentWidth="300" id="tree-pane"><Panel height="100%"><c:HTML id="elementTreeContainer" content=\'&lt;control-tree&gt;  &lt;/control-tree&gt;\'></c:HTML></Panel></l:SplitPane><l:SplitPane  requiredParentWidth="400"><Panel><ScrollContainer vertical="true"><VBox><HBox alignItems="Center"><Label text="{i18n>TestRecorder.Inspect.Snippet.Dropdown.Label}" labelFor="SelectDialect" class="sapUiSmallMarginEnd"/><Select\n\t\t\t\t\t\t\t\t\t\tid="SelectDialect"\n\t\t\t\t\t\t\t\t\t\tforceSelection="false"\n\t\t\t\t\t\t\t\t\t\tselectedKey="{/selectedDialect}"\n\t\t\t\t\t\t\t\t\t\titems="{/dialects}"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginEnd"><c:Item key="{key}" text="{label}" /></Select><Label text="{i18n>TestRecorder.Inspect.Snippet.MultiSwitch.Label}" labelFor="multiSwitch" class="sapUiSmallMarginEnd" /><Switch id="multiSwitch" state="{/settings/multipleSnippets}" type="AcceptReject" change="_onChangeMultiple"/></HBox></VBox><code:CodeEditor\n\t\t\t\t\t\t\t\tid="codeEditor"\n\t\t\t\t\t\t\t\tvalue="{\n\t\t\t\t\t\t\t\t\tpath: \'controls>/codeSnippet\',\n\t\t\t\t\t\t\t\t\tevents: {\n\t\t\t\t\t\t\t\t\t\tchange: \'._onCodeEditorChange\'\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}"\n\t\t\t\t\t\t\t\theight="calc(100vh - 180px)"\n\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\ttype="javascript"\n\t\t\t\t\t\t\t\tcolorTheme="theme-ambiance"\n\t\t\t\t\t\t\t\tlineNumbers="false"/><HBox justifyContent="End" alignItems="Center"><Button text="{i18n>TestRecorder.Inspect.Snippet.Copy.Text}" press="copyCodeSnippet"/><Button text="{i18n>TestRecorder.Inspect.Snippet.Clear.Text}" press="clearCodeSnippet" class="sapUiSmallMarginBegin"/></HBox></ScrollContainer></Panel></l:SplitPane><l:SplitPane requiredParentWidth="900px"><Panel class="ttCommonInfoPanel"><IconTabBar\n\t\t\t\t\t\t\t\tid="tabBar"\n\t\t\t\t\t\t\t\tclass="sapUiResponsiveContentPadding"\n\t\t\t\t\t\t\t\tstretchContentHeight="true"><items><IconTabFilter\n\t\t\t\t\t\t\t\t\t\tkey="properties"\n\t\t\t\t\t\t\t\t\t\ttext="{i18n>TestRecorder.Inspect.Properties.Title}"><Table\n\t\t\t\t\t\t\t\t\t\t\tid="propertiesTable"\n\t\t\t\t\t\t\t\t\t\t\titems="{controls>/properties/own}"\n\t\t\t\t\t\t\t\t\t\t\theaderText="{i18n>TestRecorder.Inspect.Properties.Own.Header.Text}" ><columns><Column><Text text="{i18n>TestRecorder.Inspect.Properties.Property.Text}" /></Column><Column><Text text="{i18n>TestRecorder.Inspect.Properties.Value.Text}" /></Column><Column><Text text="{i18n>TestRecorder.Inspect.Properties.Type.Text}" /></Column></columns><ColumnListItem><HBox><c:Icon src="sap-icon://add-process"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginEnd"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\ttooltip="{i18n>TestRecorder.Inspect.Properties.Property.Icon.Tooltip}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tpress="handlePropertyIconPress"/><Text text="{controls>property}"/></HBox><Text text="{controls>value}"/><Text text="{controls>type}"/></ColumnListItem></Table><Table\n\t\t\t\t\t\t\t\t\t\t\titems="{controls>/properties/inherited}"\n\t\t\t\t\t\t\t\t\t\t\theaderText="{i18n>TestRecorder.Inspect.Properties.Inherited.Header.Text}" ><columns><Column><Text text="{i18n>TestRecorder.Inspect.Properties.Property.Text}" /></Column><Column><Text text="{i18n>TestRecorder.Inspect.Properties.Value.Text}" /></Column><Column><Text text="{i18n>TestRecorder.Inspect.Properties.Type.Text}" /></Column><Column><Text text="{i18n>TestRecorder.Inspect.Properties.Inherited.Text}" /></Column></columns><ColumnListItem><HBox><c:Icon src="sap-icon://add-process"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginEnd"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\ttooltip="{i18n>TestRecorder.Inspect.Properties.Property.Icon.Tooltip}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tpress="handlePropertyIconPress"/><Text text="{controls>property}"/></HBox><Text text="{controls>value}"/><Text text="{controls>type}"/><Text text="{controls>inheritedFrom}"/></ColumnListItem></Table></IconTabFilter><IconTabFilter\n\t\t\t\t\t\t\t\t\t\tkey="bindings"\n\t\t\t\t\t\t\t\t\t\ttext="{i18n>TestRecorder.Inspect.Bindings.Title}"><Table\n\t\t\t\t\t\t\t\t\t\t\titems="{controls>/bindings/context}"\n\t\t\t\t\t\t\t\t\t\t\theaderText="{i18n>TestRecorder.Inspect.Bindings.Context.Header.Text}" ><columns><Column><Text text="{i18n>TestRecorder.Inspect.Bindings.Path.Text}" /></Column><Column><Text text="{i18n>TestRecorder.Inspect.Bindings.Model.Text}" /></Column></columns><ColumnListItem><Text text="{controls>path}"/><Text text="{controls>model}"/></ColumnListItem></Table><Table\n\t\t\t\t\t\t\t\t\t\t\titems="{controls>/bindings/properties}"\n\t\t\t\t\t\t\t\t\t\t\theaderText="{i18n>TestRecorder.Inspect.Bindings.Properties.Header.Text}" ><columns><Column><Text text="{i18n>TestRecorder.Inspect.Bindings.Property.Text}" /></Column><Column><Text text="{i18n>TestRecorder.Inspect.Bindings.RelativePath.Text}" /></Column><Column><Text text="{i18n>TestRecorder.Inspect.Bindings.AbsolutePath.Text}" /></Column><Column><Text text="{i18n>TestRecorder.Inspect.Bindings.Model.Text}" /></Column></columns><ColumnListItem><Text text="{controls>property}"/><Text text="{controls>relativePath}"/><Text text="{controls>absolutePath}"/><Text text="{controls>model}"/></ColumnListItem></Table><Table\n\t\t\t\t\t\t\t\t\t\t\titems="{controls>/bindings/aggregations}"\n\t\t\t\t\t\t\t\t\t\t\theaderText="{i18n>TestRecorder.Inspect.Bindings.Aggregations.Header.Text}" ><columns><Column><Text text="{i18n>TestRecorder.Inspect.Bindings.Aggregation.Text}" /></Column><Column><Text text="{i18n>TestRecorder.Inspect.Bindings.RelativePath.Text}" /></Column><Column><Text text="{i18n>TestRecorder.Inspect.Bindings.AbsolutePath.Text}" /></Column><Column><Text text="{i18n>TestRecorder.Inspect.Bindings.Model.Text}" /></Column></columns><ColumnListItem><Text text="{controls>aggregation}"/><Text text="{controls>relativePath}"/><Text text="{controls>absolutePath}"/><Text text="{controls>model}"/></ColumnListItem></Table></IconTabFilter></items></IconTabBar></Panel></l:SplitPane></l:PaneContainer></l:ResponsiveSplitter></l:flexContent></l:FixFlex></Page></mvc:View>\n'
});
//# sourceMappingURL=library-preload.js.map
