/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","./library","./CalendarLegendRenderer","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/unified/CalendarLegendItem","sap/ui/core/Core","sap/ui/Device","sap/ui/core/delegate/ItemNavigation"],function(e,t,i,n,jQuery,a,r,o,s){"use strict";var d=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var p=t.CalendarDayType;var u=t.StandardCalendarLegendItem;var g=e.extend("sap.ui.unified.CalendarLegend",{metadata:{library:"sap.ui.unified",properties:{standardItems:{type:"string[]",group:"Misc",defaultValue:["Today","Selected","WorkingDay","NonWorkingDay"]},columnWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"120px"}},aggregations:{items:{type:"sap.ui.unified.CalendarLegendItem",multiple:true,singularName:"item"},_standardItems:{type:"sap.ui.unified.CalendarLegendItem",multiple:true,visibility:"hidden"}},designtime:"sap/ui/unified/designtime/CalendarLegend.designtime"},constructor:function(t,i){e.prototype.constructor.apply(this,arguments);if(typeof t!=="string"){i=t}if(!i||i&&!i.standardItems){this._addStandardItems(this.getStandardItems())}this._bShouldRenderStandardItems=true;this._oItemNavigation=null},renderer:i});g.prototype.onAfterRendering=function(){if(!o.system.phone&&this._oParentControl){this._initItemNavigation()}};g.prototype.setStandardItems=function(e){var t;if(e&&e.length===1&&e[0]===""){e=[]}if(e&&e.length){e=this.validateProperty("standardItems",e);for(t=0;t<e.length;t++){if(!u[e[t]]){throw new Error("Invalid value '"+e[t]+"'. Property standardItems must contain values from sap.ui.unified.StandardCalendarLegendItem.")}}}this.setProperty("standardItems",e);this._addStandardItems(this.getStandardItems(),true);return this};g.prototype._initItemNavigation=function(){var e=this.getAggregation("_standardItems")||[],t=this.getItems()||[],i,n=[],a,r;i=e.concat(t);if(!i.length){return}r=i[0].getDomRef().parentElement;i.forEach(function(e,t){a=e.getFocusDomRef();a.setAttribute("tabindex","-1");n.push(a)});if(!this._oItemNavigation){this._oItemNavigation=(new s).setCycling(false).attachEvent(s.Events.AfterFocus,this._onItemNavigationAfterFocus,this).attachEvent(s.Events.FocusLeave,this._onItemNavigationFocusLeave,this).setDisabledModifiers({sapnext:["alt","meta","ctrl"],sapprevious:["alt","meta","ctrl"],saphome:["alt","meta","ctrl"],sapend:["meta","ctrl"]});this.addDelegate(this._oItemNavigation)}this._oItemNavigation.setRootDomRef(r).setItemDomRefs(n).setPageSize(i.length).setFocusedIndex(0)};g.prototype._onItemNavigationAfterFocus=function(e){var t=e.getSource(),i=t.getItemDomRefs()[t.getFocusedIndex()],n=r.byId(i.id).getType(),a=this._getParent();this._setSpecialDateTypeFilter(n);a&&a.invalidate()};g.prototype._onItemNavigationFocusLeave=function(e){var t=this._getParent();this._setSpecialDateTypeFilter();t&&t.invalidate()};g.prototype._setSpecialDateTypeFilter=function(e){this._sSpecialDateTypeFilter=e||""};g.prototype._getSpecialDateTypeFilter=function(){return this._sSpecialDateTypeFilter||""};g.prototype._setParent=function(e){this._oParentControl=e};g.prototype._getParent=function(){return this._oParentControl};g.prototype._getLegendAriaLabel=function(){return d.getText("LEGEND_ARIA_LABEL")};g.prototype._addStandardItems=function(e,t){var i,n=this.getId();if(t){this.destroyAggregation("_standardItems")}for(i=0;i<e.length;i++){var r=new a(n+"-"+e[i],{text:d.getText(g._Standard_Items_TextKeys[e[i]])});this.addAggregation("_standardItems",r)}};g._Standard_Items_TextKeys={Today:"LEGEND_TODAY",Selected:"LEGEND_SELECTED",WorkingDay:"LEGEND_NORMAL_DAY",NonWorkingDay:"LEGEND_NON_WORKING_DAY"};g.prototype._getItemType=function(e,t){var i=e.getType(),a,r;if(i&&i!==p.None){return i}r=this._getUnusedItemTypes(t);a=t.filter(function(e){return!e.getType()||e.getType()===p.None}).indexOf(e);if(a<0){n.error("Legend item is not in the legend",this);return i}if(r[a]){i=r[a]}else{i="Type"+(Object.keys(p).length+a-r.length-1)}return i};g.prototype._getItemByType=function(e){var t,i=this.getItems(),n;for(n=0;n<i.length;n++){if(this._getItemType(i[n],i)===e){t=i[n];break}}return t};g.prototype._getUnusedItemTypes=function(e){var t=jQuery.extend({},p),i,n;delete t[p.None];delete t[p.NonWorking];for(n=0;n<e.length;n++){i=e[n].getType();if(t[i]){delete t[i]}}return Object.keys(t)};g.prototype._extractItemIdsString=function(e){return e.map(function(e){return e.getId()}).join(" ")};return g});
//# sourceMappingURL=CalendarLegend.js.map