/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/date/UniversalDate","sap/ui/unified/CalendarAppointment","sap/ui/unified/CalendarLegendRenderer","sap/ui/Device","sap/ui/unified/library","sap/ui/core/InvisibleText","sap/ui/core/date/UI5Date","sap/base/Log","sap/ui/core/IconPool"],function(e,t,a,n,r,i,s,o){"use strict";var l=r.CalendarDayType;var p=r.CalendarIntervalType;var d=r.CalendarAppointmentVisualization;var c=r.CalendarAppointmentHeight;var g={apiVersion:2};g.render=function(e,t){var a=t.getTooltip_AsString();var r=t.getAppointmentsVisualization();var i=this.getLegendItems(t);e.openStart("div",t);e.class("sapUiCalendarRow");if(!n.system.phone&&t.getAppointmentsReducedHeight()){e.class("sapUiCalendarRowAppsRedHeight")}if(r!=d.Standard){e.class("sapUiCalendarRowVis"+r)}if(a){e.attr("title",a)}var s=t.getWidth();if(s){e.style("width",s)}var o=t.getHeight();if(o){e.style("height",o)}e.accessibilityState(t,{role:"row"});e.openEnd();this.renderAppointmentsRow(e,t,i);e.close("div")};g.renderAppointmentsRow=function(e,t,a){var n=t.getId();e.openStart("div",n+"-Apps");e.class("sapUiCalendarRowApps");e.attr("role","list");e.openEnd();this.renderBeforeAppointments(e,t);this.renderAppointments(e,t,a);this.renderAfterAppointments(e,t);e.close("div")};g.renderBeforeAppointments=function(e,t){};g.renderAfterAppointments=function(e,t){};g.renderResizeHandle=function(e,t,a){};g.renderAppointments=function(t,a,n){var r=a._getVisibleAppointments();var i=a._getVisibleIntervalHeaders();var s=a._getStartDate();var o=[];var l=0;var d=0;var c=[];var g=0;var v=0;var f=a.getIntervals();var A=a.getIntervalType();var u=100/f;var C=0;var T=new e(s);var I=false;var h=false;switch(A){case p.Hour:o=a.getNonWorkingHours()||[];l=s.getUTCHours();d=24;break;case p.Day:case p.Week:case p.OneMonth:case"OneMonth":o=a._getNonWorkingDays();l=s.getUTCDay();d=7;c=a.getNonWorkingHours()||[];g=s.getUTCHours();v=24;break;case p.Month:c=a._getNonWorkingDays();g=s.getUTCDay();v=7;break;default:break}if(a._isOneMonthsRowOnSmallSizes()){this.renderSingleDayInterval(t,a,r,n,i,o,l,d,c,g,v,true,true)}else{for(C=0;C<f;C++){if(h){I=true}else{I=false}h=false;switch(A){case p.Hour:T.setUTCHours(T.getUTCHours()+1);if(T.getUTCHours()==0){h=true}break;case p.Day:case p.Week:case p.OneMonth:case"OneMonth":T.setUTCDate(T.getUTCDate()+1);if(T.getUTCDate()==1){h=true}break;case p.Month:g=T.getUTCDay();T.setUTCMonth(T.getUTCMonth()+1);if(T.getUTCMonth()==0){h=true}break;default:break}this.renderInterval(t,a,C,u,i,o,l,d,c,g,v,I,h)}this.renderIntervalHeaders(t,a,u,i,f);if(!(a._getRelativeInfo&&a._getRelativeInfo().bIsRelative)){t.openStart("div",a.getId()+"-Now");t.class("sapUiCalendarRowNow");t.openEnd();t.close("div")}for(C=0;C<r.length;C++){var m=r[C];this.renderAppointment(t,a,m,n)}t.openStart("div",a.getId()+"-DummyApp");t.class("sapUiCalendarApp");t.class("sapUiCalendarAppTitleOnly");t.class("sapUiCalendarAppDummy");t.class("sapUiCalendarAppHeight1");t.openEnd();t.close("div")}};g.writeCustomAttributes=function(e,t){};g.renderInterval=function(t,a,n,r,i,o,l,d,c,g,v,f,A,u){var C=a.getId()+"-AppsInt"+n;var T;var I=a.getShowIntervalHeaders()&&(a.getShowEmptyIntervalHeaders()||i.length>0);var h=a.getStartDate().getMonth();var m=s.getInstance(a.getStartDate().getFullYear(),h+1,0).getDate();t.openStart("div",C);t.class("sapUiCalendarRowAppsInt");if(u){t.class(u)}t.style("width",r+"%");if(n>=m&&(a.getIntervalType()===p.OneMonth||a.getIntervalType()==="OneMonth")){t.class("sapUiCalItemOtherMonth")}for(T=0;T<o.length;T++){if((n+l)%d==o[T]){t.class("sapUiCalendarRowAppsNoWork");break}}if(!I){t.class("sapUiCalendarRowAppsIntNoHead")}if(f){t.class("sapUiCalendarRowAppsIntFirst")}if(A){t.class("sapUiCalendarRowAppsIntLast")}this.writeCustomAttributes(t,a);t.openEnd();if(I){t.openStart("div");t.class("sapUiCalendarRowAppsIntHead");t.openEnd();t.close("div")}if(a.getShowSubIntervals()){var U=a.getIntervalType();var b=0;switch(U){case p.Hour:b=4;break;case p.Day:case p.Week:case p.OneMonth:case"OneMonth":b=24;break;case p.Month:var S=a._getStartDate();var R=new e(S);R.setUTCMonth(R.getUTCMonth()+n+1,0);b=R.getUTCDate();R.setUTCDate(1);l=R.getUTCDay();break;default:break}var y=100/b;for(T=0;T<b;T++){t.openStart("div");t.class("sapUiCalendarRowAppsSubInt");t.style("width",y+"%");for(var w=0;w<c.length;w++){if((T+g)%v==c[w]){t.class("sapUiCalendarRowAppsNoWork");break}}t.openEnd();t.close("div")}}t.close("div")};g.renderIntervalHeaders=function(e,t,a,n,r){var i=t.getShowIntervalHeaders()&&(t.getShowEmptyIntervalHeaders()||n.length>0);if(i){for(var s=0;s<n.length;s++){var o=n[s],l,p;if(t._bRTL){p=a*o.interval;l=a*(r-o.last-1)}else{l=a*o.interval;p=a*(r-o.last-1)}this.renderIntervalHeader(e,t,o,t._bRTL,l,p)}}};g.renderIntervalHeader=function(e,t,a,n,r,i){var s=a.appointment.getId(),o={labelledby:{value:s+"-Descr",append:true}},p;var d=t._calculateAppoitnmentVisualCue(a.appointment);e.openStart("div",a.appointment);e.class("sapUiCalendarRowAppsIntHead");if(r!==undefined){e.style("left",r+"%")}if(i!==undefined){e.style("right",i+"%")}e.class("sapUiCalendarRowAppsIntHeadFirst");if(a.appointment.getSelected()){e.class("sapUiCalendarRowAppsIntHeadSel")}if(a.appointment.getTentative()){e.class("sapUiCalendarRowAppsIntHeadTent")}var c=a.appointment.getTooltip_AsString();if(c){e.attr("title",c)}var g=a.appointment.getType();var v=a.appointment.getColor();if(!v&&g&&g!=l.None){e.class("sapUiCalendarRowAppsIntHead"+g)}if(v){if(n){e.style("border-right-color",v)}else{e.style("border-left-color",v)}}e.accessibilityState(a.appointment,o);e.openEnd();e.openStart("div");e.class("sapUiCalendarIntervalHeaderCont");if(v){e.style("background-color",a.appointment._getCSSColorForBackground(v))}e.openEnd();if(d.appTimeUnitsDifRowStart>0){e.icon("sap-icon://arrow-left",["sapUiCalendarAppArrowIconLeft"],{title:null,role:"img"})}var f=a.appointment.getIcon();if(f){var A=["sapUiCalendarRowAppsIntHeadIcon"];var u={};u["id"]=s+"-Icon";u["title"]=null;u["alt"]=null;u["role"]="presentation";e.icon(f,A,u)}var C=a.appointment.getTitle();if(C){e.openStart("span",s+"-Title");e.class("sapUiCalendarRowAppsIntHeadTitle");e.openEnd();e.text(C);e.close("span")}var T=a.appointment.getText();if(T){e.openStart("span",s+"-Text");e.class("sapUiCalendarRowAppsIntHeadText");e.openEnd();e.text(T);e.close("span")}if(d.appTimeUnitsDifRowEnd>0){e.icon("sap-icon://arrow-right",["sapUiCalendarAppArrowIconRight"],{title:null,role:"img"})}p=t._oRb.getText("CALENDAR_START_TIME")+": "+t._oFormatAria.format(a.appointment.getStartDate())+"; "+t._oRb.getText("CALENDAR_END_TIME")+": "+t._oFormatAria.format(a.appointment.getEndDate());if(g&&g!==l.None){p+="; "+this.getAriaTextForType(g,this.getLegendItems(t))}e.openStart("span",s+"-Descr");e.class("sapUiInvisibleText");e.openEnd();e.text(p);e.close("span");e.close("div");e.close("div")};g.renderAppointment=function(e,t,a,n,r){var s=a.appointment;var o=s.getTooltip_AsString();var p=s.getType();var g=s.getColor();var v=s.getTitle();var f=s.getText();var A=s.getDescription();var u=s.getIcon();var C=s.getId();var T=t._getAppointmentReducedHeight(a);var I=s.getSelected();var h={role:"listitem",labelledby:{value:`${i.getStaticId("sap.m","ACC_CTR_TYPE_LISTITEM")} ${i.getStaticId("sap.ui.unified","APPOINTMENT")} ${C.concat("-Descr")}`,append:true},describedby:{value:I?i.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED"):"",append:true},selected:null};var m=t._getAppointmentRowCount(a,T);var U=t.getAriaLabelledBy();var b=t._calculateAppoitnmentVisualCue(s);if(U.length>0){h["labelledby"].value=h["labelledby"].value+" "+U.join(" ")}if(v){h["labelledby"].value=h["labelledby"].value+" "+C+"-Title"}if(f){h["labelledby"].value=h["labelledby"].value+" "+C+"-Text"}e.openStart("div",s);e.class("sapUiCalendarApp");e.class("sapUiCalendarAppHeight"+m);if(I){e.class("sapUiCalendarAppSel")}if(s.getTentative()){e.class("sapUiCalendarAppTent");h["labelledby"].value=h["labelledby"].value+" "+i.getStaticId("sap.ui.unified","APPOINTMENT_TENTATIVE")}if(m===1){e.class("sapUiCalendarAppTitleOnly")}if(u){e.class("sapUiCalendarAppWithIcon")}if(!r){if(t._bRTL){e.style("right",a.begin+"%");e.style("left",a.end+"%")}else{e.style("left",a.begin+"%");e.style("right",a.end+"%")}}e.attr("data-sap-level",a.level);if(t._sFocusedAppointmentId==C){e.attr("tabindex","0")}else{e.attr("tabindex","-1")}if(o){e.attr("title",o)}if(!g&&p&&p!=l.None){e.class("sapUiCalendarApp"+p)}if(g){if(t._bRTL){e.style("border-right-color",g)}else{e.style("border-left-color",g)}}e.accessibilityState(s,h);e.openEnd();e.openStart("div");e.class("sapUiCalendarAppCont");if(g&&t.getAppointmentsVisualization()===d.Filled){e.style("background-color",s._getCSSColorForBackground(g))}e.openEnd();if(s.getCustomContent().length){s.getCustomContent().forEach(function(t){e.renderControl(t)})}else{if(b.appTimeUnitsDifRowStart>0){e.icon("sap-icon://arrow-left",["sapUiCalendarAppArrowIconLeft"],{title:null,role:"img"})}if(u){var S=["sapUiCalendarAppIcon"];var R={};R["id"]=C+"-Icon";R["title"]=null;R["alt"]=null;R["role"]="presentation";e.icon(u,S,R)}e.openStart("div");e.class("sapUiCalendarAppTitleWrapper");e.openEnd();if(v){e.openStart("span",C+"-Title");e.class("sapUiCalendarAppTitle");e.openEnd();e.text(v);e.close("span")}if(f&&a.size!==c.HalfSize){e.openStart("span",C+"-Text");e.class("sapUiCalendarAppText");e.openEnd();e.text(f);e.close("span")}if(A&&a.size!==c.HalfSize&&(a.size!==c.Regular||!f)){e.openStart("span",C+"-Info");e.class("sapUiCalendarAppDescription");e.openEnd();e.text(A);e.close("span")}e.close("div");if(b.appTimeUnitsDifRowEnd>0){e.icon("sap-icon://arrow-right",["sapUiCalendarAppArrowIconRight"],{title:null,role:"img"})}}var y=t._oRb.getText("CALENDAR_START_TIME")+": "+t._oFormatAria.format(s.getStartDate());y=y+"; "+t._oRb.getText("CALENDAR_END_TIME")+": "+t._oFormatAria.format(s.getEndDate());if(t._getRelativeInfo&&t._getRelativeInfo().bIsRelative){var w=t._getRelativeInfo();y=t._oRb.getText("CALENDAR_START_TIME")+": "+w.intervalLabelFormatter(w._getIndexFromDate(s.getStartDate()));y=y+"; "+t._oRb.getText("CALENDAR_END_TIME")+": "+w.intervalLabelFormatter(w._getIndexFromDate(s.getEndDate()))}if(p&&p!=l.None){y=y+"; "+this.getAriaTextForType(p,n)}e.openStart("span",C+"-Descr");e.class("sapUiInvisibleText");e.openEnd();e.text(y);e.close("span");e.close("div");this.renderResizeHandle(e,t,s);e.close("div")};g.renderSingleDayInterval=function(a,n,r,i,o,l,d,c,g,v,f,A,u){var C=1,T=100,I=n.getId()+"-AppsInt"+C,h,m=n.getShowIntervalHeaders()&&(n.getShowEmptyIntervalHeaders()||o.length>0),U=s.getInstance(n.getStartDate()),b=U.getMonth(),S=s.getInstance(U.getFullYear(),b+1,0).getDate(),R,y=n._getPlanningCalendar(),w,D,E=[];U.setHours(0,0,0,0);w=r.concat(n.getIntervalHeaders().filter(function(e){var t=e.getStartDate().getTime(),a=e.getEndDate().getTime(),n=U.getTime(),r=n+1e3*60*60*24;return!(t>=r||a<=n)}).map(function(e){return{appointment:e,isHeader:true}})).sort(t._getComparer(U));if(y){E=y._getSelectedDates()}a.openStart("div",I);a.class("sapUiCalendarRowAppsInt");a.class("sapUiCalendarMonthRowAppsS");a.style("width",T+"%");if(C>=S&&(n.getIntervalType()===p.OneMonth||n.getIntervalType()==="OneMonth")){a.class("sapUiCalItemOtherMonth")}for(h=0;h<l.length;h++){if((C+d)%c==l[h]){a.class("sapUiCalendarRowAppsNoWork");break}}if(!m){a.class("sapUiCalendarRowAppsIntNoHead")}if(A){a.class("sapUiCalendarRowAppsIntFirst")}if(u){a.class("sapUiCalendarRowAppsIntLast")}a.openEnd();if(m){a.openStart("div");a.class("sapUiCalendarRowAppsIntHead");a.openEnd();a.close("div")}if(E.length>0){var _=0,H=w.length;if(y.getRows()[0]._calculateVisibleAppointments){var N=y.getRows()[0]._calculateVisibleAppointments(E,w);_=N.iStart;H=N.iEnd}for(h=_;h<H;h++){D=w[h];a.openStart("div");a.class("sapUiCalendarAppContainer");a.openEnd();a.openStart("div");a.class("sapUiCalendarAppContainerLeft");a.openEnd();a.openStart("div");a.class("sapUiCalendarAppStart");a.openEnd();a.text(D.appointment._getDateRangeIntersectionText(U).start);a.close("div");a.openStart("div");a.class("sapUiCalendarAppEnd");a.openEnd();a.text(D.appointment._getDateRangeIntersectionText(U).end);a.close("div");a.close("div");a.openStart("div");a.class("sapUiCalendarAppContainerRight");a.openEnd();if(D.isHeader){this.renderIntervalHeader(a,n,D)}else{this.renderAppointment(a,n,D,i,true)}a.close("div");a.close("div")}}if(r.length===0||E.length===0){a.openStart("div");a.class("sapUiCalendarNoApps");a.openEnd();var x=sap.ui.getCore().byId(n.getAssociation("row"));R=x.getNoAppointmentsText()?x.getNoAppointmentsText():sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("PLANNINGCALENDAR_ROW_NO_APPOINTMENTS");a.text(R);a.close("div")}if(!(n._getRelativeInfo&&n._getRelativeInfo().bIsRelative)){a.openStart("div",n.getId()+"-Now");a.class("sapUiCalendarRowNow");a.openEnd()}a.close("div");a.openStart("div",n.getId()+"-DummyApp");a.class("sapUiCalendarApp");a.class("sapUiCalendarAppTitleOnly");a.class("sapUiCalendarAppDummy");a.style("margin","0");a.style("height","0px");a.openEnd();a.close("div");if(n.getShowSubIntervals()){var M=n.getIntervalType();var k=0;switch(M){case p.Hour:k=4;break;case p.Day:case p.Week:case p.OneMonth:case"OneMonth":k=24;break;case p.Month:var L=new e(U);L.setUTCMonth(L.getUTCMonth()+C+1,0);k=L.getUTCDate();L.setUTCDate(1);d=L.getUTCDay();break;default:break}var O=100/k;for(h=0;h<k;h++){a.openStart("div");a.class("sapUiCalendarRowAppsSubInt");a.style("width",O+"%");for(var F=0;F<g.length;F++){if((h+v)%f==g[F]){a.class("sapUiCalendarRowAppsNoWork");break}}a.openEnd();a.close("div")}}a.close("div")};g.getLegendItems=function(e){var t=[],a,n=e.getLegend();if(n){a=sap.ui.getCore().byId(n);if(a){t=a.getItems()}else{o.error("CalendarLegend with id '"+n+"' does not exist!",e)}}return t};g.getAriaTextForType=function(e,t){var n,r,i,s;if(t&&t.length){for(var s=0;s<t.length;s++){i=t[s];if(i.getType()===e){n=i.getText();break}}}if(!n){r=a.getTypeAriaText(e);if(r){n=r.getText()}}return n};return g},true);
//# sourceMappingURL=CalendarRowRenderer.js.map