/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/commons/Button","sap/ui/commons/Menu","sap/ui/core/Control","./ExactAttribute","./ExactList","./library","./ExactBrowserRenderer","sap/ui/core/Popup"],function(t,e,i,o,r,s,a,u){"use strict";var n=u.Dock;var l=s.ExactOrder;var p=i.extend("sap.ui.ux3.ExactBrowser",{metadata:{deprecated:true,library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},headerTitle:{type:"string",group:"Misc",defaultValue:null},topListOrder:{type:"sap.ui.ux3.ExactOrder",defaultValue:l.Select},enableListClose:{type:"boolean",group:"Misc",defaultValue:false},listHeight:{type:"int",group:"Appearance",defaultValue:290},showHeader:{type:"boolean",group:"Misc",defaultValue:false},showTopList:{type:"boolean",group:"Misc",defaultValue:true},enableReset:{type:"boolean",group:"Misc",defaultValue:true},enableSave:{type:"boolean",group:"Misc",defaultValue:false},topListWidth:{type:"int",group:"Misc",defaultValue:168}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.ui.ux3.ExactAttribute",multiple:true,singularName:"attribute",forwarding:{idSuffix:"-rootAttribute",aggregation:"attributes"}},optionsMenu:{type:"sap.ui.commons.Menu",multiple:false},controls:{type:"sap.ui.core.Control",multiple:true,singularName:"control",visibility:"hidden"},rootAttribute:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{followUpControl:{type:"sap.ui.core.Control",multiple:false}},events:{attributeSelected:{parameters:{attribute:{type:"sap.ui.ux3.ExactAttribute"},allAttributes:{type:"object"}}},save:{}}}});p.prototype.init=function(){var e=this;this.data("sap-ui-fastnavgroup","true",true);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._attributeRoot=new o(this.getId()+"-rootAttribute");this.setAggregation("rootAttribute",this._attributeRoot);this._rootList=new r(this.getId()+"-rootlist");this._rootList.setData(this._attributeRoot);this.addAggregation("controls",this._rootList);this._resetButton=new t(this.getId()+"-RstBtn",{text:this._rb.getText("EXACT_BRWSR_RESET"),lite:true});this._resetButton.addStyleClass("sapUiUx3ExactBrwsrReset");this.addAggregation("controls",this._resetButton);this._resetButton.attachPress(function(){e.reset()});this._saveButton=new t(this.getId()+"-SvBtn",{text:this._rb.getText("EXACT_BRWSR_SAVE"),lite:true});this._saveButton.addStyleClass("sapUiUx3ExactBrwsrSave");this.addAggregation("controls",this._saveButton);this._saveButton.attachPress(function(){e.fireSave()});this._rootList.attachAttributeSelected(function(t){e.fireAttributeSelected({attribute:t.getParameter("attribute"),allAttributes:t.getParameter("allAttributes")})});this._rootList.attachEvent("_headerPress",function(t){var i=e.getOptionsMenu();if(i){var o=t.getParameter("domRef");i.open(t.getParameter("keyboard"),o,n.BeginTop,n.BeginBottom,o)}})};p.prototype.exit=function(){this._rootList.destroy();this._attributeRoot.destroy();this._rootList=null;this._attributeRoot=null;this._resetButton=null;this._saveButton=null;this._saveDialog=null;this._saveTextField=null;this._rb=null};p.prototype.onThemeChanged=function(t){if(this.getDomRef()){this.invalidate()}};p.prototype.getTitle=function(){return this._rootList.getTopTitle()};p.prototype.setTitle=function(t){this._rootList.setTopTitle(t);return this};p.prototype.setTopListOrder=function(t){this.setProperty("topListOrder",t,true);this._attributeRoot.setListOrder(t);return this};p.prototype.getTopListWidth=function(){return this._attributeRoot.getWidth()};p.prototype.setTopListWidth=function(t){this._attributeRoot.setWidth(t);return this};p.prototype.getHeaderTitle=function(){var t=this.getProperty("headerTitle");return t?t:this._rb.getText("EXACT_BRWSR_TITLE")};p.prototype.getEnableListClose=function(){return this._rootList.getShowClose()};p.prototype.setEnableListClose=function(t){this._rootList.setShowClose(t);return this};p.prototype.getListHeight=function(){return this._rootList.getTopHeight()};p.prototype.setListHeight=function(t){this._rootList.setTopHeight(t);return this};p.prototype.reset=function(){this._rootList._closeAll()};p.prototype.hasOptionsMenu=function(){return!!this.getOptionsMenu()};return p});
//# sourceMappingURL=ExactBrowser.js.map