/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/InvisibleText","sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/library","./library","sap/base/Log","sap/ui/events/KeyCodes","sap/ui/core/Configuration","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/ui/dom/jquery/Focusable"],function(t,jQuery,e,i,n,o,a,r,s,l){"use strict";var u=i.TitleLevel;var g=e.extend("sap.uxap.ObjectPageSectionBase",{metadata:{abstract:true,library:"sap.uxap",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:u.Auto},visible:{type:"boolean",group:"Appearance",defaultValue:true},importance:{type:"sap.uxap.Importance",group:"Behavior",defaultValue:n.Importance.High}},aggregations:{ariaLabelledBy:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},customAnchorBarButton:{type:"sap.m.Button",multiple:false},_grid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}},renderer:null});g.prototype.init=function(){this._bInternalVisible=true;this._bInternalTitleVisible=true;this._sInternalTitle="";this._sInternalTitleLevel=u.Auto;this._isHidden=false;this._oGridContentObserver=null;this._bRtl=r.getRTL()};g.prototype.onAfterRendering=function(){if(this._getObjectPageLayout()){this._getObjectPageLayout()._requestAdjustLayout().catch(function(){o.debug("ObjectPageSectionBase :: cannot adjustLayout",this)});this._getObjectPageLayout()._setSectionsFocusValues()}};g.prototype.onBeforeRendering=function(){var t="ariaLabelledBy";if(!this.getAggregation(t)){this.setAggregation(t,this._getAriaLabelledBy(),true)}else{this.updateInvisibleTextLabelValue()}};g.prototype.exit=function(){if(this._oInvisibleText){this._oInvisibleText.destroy();this._oInvisibleText=null}};g.prototype._getGrid=function(){if(!this.getAggregation("_grid")&&!this._bIsBeingDestroyed){this.setAggregation("_grid",new s({id:this.getId()+"-innerGrid",defaultSpan:"XL12 L12 M12 S12",hSpacing:1,vSpacing:1,width:"100%",containerQuery:true}),true);if(this._oGridContentObserver){this._oGridContentObserver.observe(this.getAggregation("_grid"),{aggregations:["content","subSections"]})}}return this.getAggregation("_grid")};g.prototype._resetLayoutData=function(t){t.forEach(function(t){if(t.getLayoutData()){t.destroyLayoutData()}},this)};g.prototype._assignLayoutData=function(t,e){var i=12,n=[],o=[],a,r,s,u;a={iRemaining:e.M,iColumnConfig:e.M};r={iRemaining:e.L,iColumnConfig:e.L};s={iRemaining:e.XL,iColumnConfig:e.XL};u=[s,r,a];t.forEach(function(t){if(t.getVisible&&t.getVisible()){n.push(t)}else{o.push(t)}});n.forEach(function(t,e){u.forEach(function(i){i.iCalculatedSize=this._getEffectiveColspanForGridItem(t,i.iRemaining,n,e,i.iColumnConfig)},this);t.setLayoutData(new l({spanS:i,spanM:a.iCalculatedSize*(i/a.iColumnConfig),spanL:r.iCalculatedSize*(i/r.iColumnConfig),spanXL:s.iCalculatedSize*(i/s.iColumnConfig),linebreakM:e>0&&a.iRemaining===a.iColumnConfig,linebreakL:e>0&&r.iRemaining===r.iColumnConfig,linebreakXL:e>0&&s.iRemaining===s.iColumnConfig}));if(t.isA("sap.uxap.ObjectPageSubSection")){t._oLayoutConfig={M:a.iCalculatedSize,L:r.iCalculatedSize,XL:s.iCalculatedSize}}u.forEach(function(t){t.iRemaining-=t.iCalculatedSize;if(t.iRemaining<1){t.iRemaining=t.iColumnConfig}})},this);o.forEach(function(t){t.setLayoutData(new l({visibleS:false,visibleM:false,visibleL:false,visibleXL:false}))});return n};g.prototype._getEffectiveColspanForGridItem=function(t,e,i,n,o){var a,r=o,s,l=this._getMinRequiredColspanForChild(t);if(!this._allowAutoextendColspanForChild(t)){return Math.min(o,l)}for(s=1;s<=r;s++){a=this._getMinRequiredColspanForChild(i[n+s]);if(a<=e-l){e-=a}else{break}}return e};g.prototype._getMinRequiredColspanForChild=function(t){};g.prototype._allowAutoextendColspanForChild=function(t){};g.prototype.setCustomAnchorBarButton=function(t){var e=this.setAggregation("customAnchorBarButton",t,true);if(this._getObjectPageLayout()){this._getObjectPageLayout()._updateNavigation()}return e};g.prototype.getSectionText=function(){return""};g.prototype.updateInvisibleTextLabelValue=function(){var t=this.getAggregation("ariaLabelledBy"),e=this._getAriaLabelledByText();if(t){sap.ui.getCore().byId(t.getId()).setText(e)}return this};g.prototype._getAriaLabelledBy=function(){var t=this._getAriaLabelledByText();return this._getInvisibleText().setText(t)};g.prototype._getAriaLabelledByText=function(){var t=this._getShouldLabelTitle()&&this._getTitle();return t||this.getSectionText()};g.prototype._getInvisibleText=function(){if(!this._oInvisibleText){this._oInvisibleText=new t;this._oInvisibleText.toStatic()}return this._oInvisibleText};g.prototype._getShouldLabelTitle=function(){return this.getShowTitle?this.getShowTitle():true};g.prototype._setInternalVisible=function(t,e){if(t!=this._bInternalVisible){this._bInternalVisible=t;if(e){this.invalidate()}}};g.prototype._getInternalVisible=function(){return this._bInternalVisible};g.prototype._setInternalTitleVisible=function(t,e){if(t!=this._bInternalTitleVisible){this._bInternalTitleVisible=t;if(e){this.invalidate()}}};g.prototype._getInternalTitleVisible=function(){return this._bInternalTitleVisible};g.prototype._setInternalTitle=function(t,e){if(t!=this._sInternalTitle){this._sInternalTitle=t;if(e){this.invalidate()}}};g.prototype._getTitle=function(){return this._getInternalTitle()||this.getTitle()};g.prototype._getInternalTitle=function(){return this._sInternalTitle};g.prototype._getARIALevel=function(){var t=this._getTitleLevel();if(t===u.Auto){t=u.H2}return t.slice(-1)};g.prototype._getTitleLevel=function(){var t=this.getTitleLevel();return t===u.Auto?this._getInternalTitleLevel():t};g.prototype._setInternalTitleLevel=function(t,e){if(t!==this._sInternalTitleLevel){this._sInternalTitleLevel=t;if(e){this.invalidate()}}};g.prototype._getInternalTitleLevel=function(){return this._sInternalTitleLevel};g.prototype._getObjectPageLayout=function(){return n.Utilities.getClosestOPL(this)};g.prototype._notifyObjectPageLayout=function(){if(this._getObjectPageLayout()&&this._getObjectPageLayout().$().length){this._getObjectPageLayout()._requestAdjustLayoutAndUxRules()}};["addAggregation","insertAggregation","removeAllAggregation","removeAggregation","destroyAggregation"].forEach(function(t){g.prototype[t]=function(i,n,o,a){if(["addAggregation","removeAggregation"].indexOf(t)>-1){a=o}if(["removeAllAggregation","destroyAggregation"].indexOf(t)>-1){a=n}var r=e.prototype[t].apply(this,arguments);if(a!==true){this._notifyObjectPageLayout()}return r}});g.prototype.setVisible=function(t,e){if(this.getVisible()===t){return this}if(!this._getObjectPageLayout()){return this.setProperty("visible",t,e)}this.setProperty("visible",t,true);this._notifyObjectPageLayout();this.invalidate();return this};g.prototype.setTitle=function(t,e){this.setProperty("title",t,e);this._notifyObjectPageLayout();this.updateInvisibleTextLabelValue();return this};g.prototype._shouldBeHidden=function(){return g._importanceMap[this.getImportance()]>g._importanceMap[this._sCurrentLowestImportanceLevelToShow]};g._importanceMap={Low:3,Medium:2,High:1};g.prototype._updateShowHideState=function(t){var e=this._getObjectPageLayout();this._isHidden=t;this.$().children(this._sContainerSelector).toggle(!t);if(e){e._requestAdjustLayout()}return this};g.prototype._getIsHidden=function(){return this._isHidden};g.prototype._expandSection=function(){return this._updateShowHideState(false)};g.prototype._showHideContent=function(){return this._updateShowHideState(!this._getIsHidden())};g.prototype._applyImportanceRules=function(t){this._sCurrentLowestImportanceLevelToShow=t;if(this.getDomRef()){this._updateShowHideState(this._shouldBeHidden())}else{this._isHidden=this._shouldBeHidden()}};g.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;g.prototype.onkeydown=function(t){if(t.keyCode===a.SPACE&&t.srcControl.isA("sap.uxap.ObjectPageSection")){t.preventDefault()}if(t.keyCode===a.F7){var e=this.getSubSections(),i=e[0],n;if(e.length===1){n=i._oLastFocusedControlF7;if(n){n.$().trigger("focus")}else{i.$().firstFocusableDomRef().focus()}}else{if(i.getActions().length){i.getActions()[0].$().trigger("focus")}}}};g.prototype.onsapdown=function(t){var e=t.currentTarget,i=e.nextSibling;if(e.classList.contains("sapUxAPObjectPageSubSection")){var n=e.parentElement;if(n.nextElementSibling){i=n.nextElementSibling.querySelector(".sapUxAPObjectPageSubSection")}}this._handleFocusing(t,i)};g.prototype._handleFocusing=function(t,e){var i;if(this._targetIsCorrect(t)&&e){i=jQuery(t.currentTarget).parent().children();t.preventDefault();e.focus();if(i.length>1){this._scrollParent(jQuery(e).attr("id"))}}};g.prototype._targetIsCorrect=function(t){return t.srcControl===this};g.prototype.onsapright=function(t){var e=this._bRtl?"onsapup":"onsapdown";this[e](t)};g.prototype.onsapup=function(t){var e=t.currentTarget,i=e.previousSibling;if(e.classList.contains("sapUxAPObjectPageSubSection")){var n=e.parentElement;if(n.previousElementSibling){i=n.previousElementSibling.querySelector(".sapUxAPObjectPageSubSection")}}this._handleFocusing(t,i)};g.prototype.onsapleft=function(t){var e=this._bRtl?"onsapdown":"onsapup";this[e](t)};g.prototype.onsaphome=function(t){var e=t.currentTarget,i=e.parentElement.firstChild;if(e.classList.contains("sapUxAPObjectPageSubSection")){i=e.closest(".sapUxAPObjectPageSection").querySelector(".sapUxAPObjectPageSubSection")}this._handleFocusing(t,i)};g.prototype.onsapend=function(t){var e=t.currentTarget,i=e.parentElement.lastChild,n;if(e.classList.contains("sapUxAPObjectPageSubSection")){n=e.closest(".sapUxAPObjectPageSection").querySelectorAll(".sapUxAPObjectPageSubSection");i=n[n.length-1]}this._handleFocusing(t,i)};g.prototype.onsappageup=function(t){if(!this._targetIsCorrect(t)){return}t.preventDefault();var e,i=t.currentTarget;var n=jQuery(i).parent().children();var o;if(i.classList.contains("sapUxAPObjectPageSubSection")){n=jQuery(i.closest(".sapUxAPObjectPageSection")).find(".sapUxAPObjectPageSubSection")}n.each(function(i,n){if(jQuery(n).attr("id")===t.currentTarget.id){e=i-(g.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return}});if(e&&n[e]){n[e].focus();o=jQuery(n[e]).attr("id")}else if(n[0]){n[0].focus();o=jQuery(n[0]).attr("id")}if(n.length>1){this._scrollParent(o)}};g.prototype.onsappagedown=function(t){if(!this._targetIsCorrect(t)){return}t.preventDefault();var e,i=t.currentTarget;var n=jQuery(i).parent().children();var o;if(i.classList.contains("sapUxAPObjectPageSubSection")){n=jQuery(i.closest(".sapUxAPObjectPageSection")).find(".sapUxAPObjectPageSubSection")}n.each(function(i,n){if(jQuery(n).attr("id")===t.currentTarget.id){e=i+g.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return}});if(e&&n[e]){n[e].focus();o=jQuery(n[e]).attr("id")}else if(n[n.length-1]){n[n.length-1].focus();o=jQuery(n[n.length-1]).attr("id")}if(n.length>1){this._scrollParent(o)}};g.prototype._scrollParent=function(t){if(this._getObjectPageLayout()){this._getObjectPageLayout().scrollToSection(t,0,10)}};return g});
//# sourceMappingURL=ObjectPageSectionBase.js.map