//@ui5-bundle Eventing-preload-0.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/security/encodeCSS", ["sap/base/strings/toHex"],function(r){"use strict";var e=/[\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\xff\u2028\u2029][0-9A-Fa-f]?/g;var t=function(e){var t=e.charCodeAt(0);if(e.length===1){return"\\"+r(t)}else{return"\\"+r(t)+" "+e.substr(1)}};var n=function(r){return r.replace(e,t)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/security/encodeXML", ["sap/base/strings/toHex"],function(x){"use strict";var e=/[\x00-\x2b\x2f\x3a-\x40\x5b-\x5e\x60\x7b-\xff\u2028\u2029]/g,t=/[\x00-\x08\x0b\x0c\x0e-\x1f\x7f-\x9f]/,f={"<":"&lt;",">":"&gt;","&":"&amp;",'"':"&quot;"};var r=function(e){var r=f[e];if(!r){if(t.test(e)){r="&#xfffd;"}else{r="&#x"+x(e.charCodeAt(0))+";"}f[e]=r}return r};var a=function(x){return x.replace(e,r)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/strings/capitalize", [],function(){"use strict";var r=function(r){return r.charAt(0).toUpperCase()+r.substring(1)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/strings/escapeRegExp", [],function(){"use strict";var r=/[[\]{}()*+?.\\^$|]/g;var e=function(e){return e.replace(r,"\\$&")};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/strings/toHex", [],function(){"use strict";var t=function(t,r){var n=t.toString(16);if(r){n=n.padStart(r,"0")}return n};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/JSTokenizer", [],function(){"use strict";
/*
	 * The following code has been taken from the component JSON in JavaScript
	 * from Douglas Crockford which is licensed under Public Domain
	 * (http://www.json.org/ > JavaScript > json-2). The code contains
	 * local modifications.
	 *
	 * Git URL: https://github.com/douglascrockford/JSON-js/blob/ff55d8d4513b149e2511aee01c3a61d372837d1f/json_parse.js
	 */var t=function(){this.at;this.ch;this.escapee={'"':'"',"'":"'","\\":"\\","/":"/",b:"\b",f:"\f",n:"\n",r:"\r",t:"\t"};this.text};t.prototype.error=function(t){throw{name:"SyntaxError",message:t,at:this.at,text:this.text}};t.prototype.next=function(t){if(t&&t!==this.ch){this.error("Expected '"+t+"' instead of '"+this.ch+"'")}this.ch=this.text.charAt(this.at);this.at+=1;return this.ch};t.prototype.number=function(){var t,i="";if(this.ch==="-"){i="-";this.next("-")}while(this.ch>="0"&&this.ch<="9"){i+=this.ch;this.next()}if(this.ch==="."){i+=".";while(this.next()&&this.ch>="0"&&this.ch<="9"){i+=this.ch}}if(this.ch==="e"||this.ch==="E"){i+=this.ch;this.next();if(this.ch==="-"||this.ch==="+"){i+=this.ch;this.next()}while(this.ch>="0"&&this.ch<="9"){i+=this.ch;this.next()}}t=+i;if(!isFinite(t)){this.error("Bad number")}else{return t}};t.prototype.string=function(){var t,i,h="",e,s;if(this.ch==='"'||this.ch==="'"){e=this.ch;while(this.next()){if(this.ch===e){this.next();return h}if(this.ch==="\\"){this.next();if(this.ch==="u"){s=0;for(i=0;i<4;i+=1){t=parseInt(this.next(),16);if(!isFinite(t)){break}s=s*16+t}h+=String.fromCharCode(s)}else if(typeof this.escapee[this.ch]==="string"){h+=this.escapee[this.ch]}else{break}}else{h+=this.ch}}}this.error("Bad string")};t.prototype.name=function(){var t="",i=function(t){return t==="_"||t==="$"||t>="0"&&t<="9"||t>="a"&&t<="z"||t>="A"&&t<="Z"};if(i(this.ch)){t+=this.ch}else{this.error("Bad name")}while(this.next()){if(this.ch===" "){this.next();return t}if(this.ch===":"){return t}if(i(this.ch)){t+=this.ch}else{this.error("Bad name")}}this.error("Bad name")};t.prototype.white=function(){while(this.ch&&this.ch<=" "){this.next()}};t.prototype.word=function(){switch(this.ch){case"t":this.next("t");this.next("r");this.next("u");this.next("e");return true;case"f":this.next("f");this.next("a");this.next("l");this.next("s");this.next("e");return false;case"n":this.next("n");this.next("u");this.next("l");this.next("l");return null}this.error("Unexpected '"+this.ch+"'")};t.prototype.array=function(){var t=[];if(this.ch==="["){this.next("[");this.white();if(this.ch==="]"){this.next("]");return t}while(this.ch){t.push(this.value());this.white();if(this.ch==="]"){this.next("]");return t}this.next(",");this.white()}}this.error("Bad array")};var i=function(){var t,i={};if(this.ch==="{"){this.next("{");this.white();if(this.ch==="}"){this.next("}");return i}while(this.ch){if(this.ch>="0"&&this.ch<="9"){t=this.number()}else if(this.ch==='"'||this.ch==="'"){t=this.string()}else{t=this.name()}this.white();this.next(":");if(Object.hasOwn(i,t)){this.error('Duplicate key "'+t+'"')}i[t]=this.value();this.white();if(this.ch==="}"){this.next("}");return i}this.next(",");this.white()}}this.error("Bad object")};t.prototype.value=function(){this.white();switch(this.ch){case"{":return i.call(this);case"[":return this.array();case'"':case"'":return this.string();case"-":return this.number();default:return this.ch>="0"&&this.ch<="9"?this.number():this.word()}};t.prototype.getIndex=function(){return this.at-1};t.prototype.getCh=function(){return this.ch};t.prototype.init=function(t,i){this.text=t;this.at=i||0;this.ch=" "};t.prototype.setIndex=function(t){if(t<this.at-1){throw new Error("Must not set index "+t+" before previous index "+(this.at-1))}this.at=t;this.next()};t.parseJS=function(i,h){var e=new t;var s;e.init(i,h);s=e.value();if(isNaN(h)){e.white();if(e.getCh()){e.error("Syntax error")}return s}else{return{result:s,at:e.getIndex()}}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/deepClone", ["./isPlainObject"],function(e){"use strict";var r=function(e,r){if(!r){r=10}return n(e,0,r)};function n(e,r,n){if(r>n){throw new TypeError("The structure depth of the source exceeds the maximum depth ("+n+")")}if(e==null){return e}else if(e instanceof Date){if(e.clone){return e.clone()}return new Date(e.getTime())}else if(Array.isArray(e)){return t(e,r,n)}else if(typeof e==="object"){return i(e,r,n)}else{return e}}function t(e,r,t){var i=[];for(var o=0;o<e.length;o++){i.push(n(e[o],r+1,t))}return i}function i(r,t,i){if(!e(r)){throw new TypeError("Cloning is only supported for plain objects")}var o={};for(var u in r){if(u==="__proto__"){continue}o[u]=n(r[u],t+1,i)}return o}return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/base/util/merge", ["./_merge"],function(e){"use strict";var r=function(){var r=[true,false];r.push.apply(r,arguments);return e.apply(null,r)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/BindingInfo", ["sap/base/config","sap/ui/base/DesignTime","sap/ui/core/getCompatibilityVersion","sap/ui/base/BindingParser","sap/ui/model/BindingMode","sap/base/Log"],function(e,t,r,a,i){"use strict";var n=Symbol("ui5object");const s=Symbol("ModelNameExtracted");function o(e){if(!e[s]){const t=e.path.indexOf(">");if(t>0){e.model=e.path.substr(0,t);e.path=e.path.substr(t+1);e[s]=true}}return e}var p={createProperty:function(e){if(!e.parts){e.parts=[];e.parts[0]={path:e.path,targetType:e.targetType,type:e.type,suspended:e.suspended,formatOptions:e.formatOptions,constraints:e.constraints,model:e.model,mode:e.mode,value:e.value};delete e.path;delete e.targetType;delete e.mode;delete e.model;delete e.value}for(var t=0;t<e.parts.length;t++){var r=e.parts[t];if(typeof r=="string"){r={path:r};e.parts[t]=r}if(r.path!==undefined){o(r)}if(e.formatter&&r.mode!=i.OneWay&&r.mode!=i.OneTime){r.mode=i.OneWay}}e.skipPropertyUpdate=0;e.skipModelUpdate=0;return e},createAggregation:function(e,t){if(!(e.template||e.factory)){if(t){e.factory=function(){throw new Error("dummy factory called unexpectedly ")}}}else if(e.template){e.factory=function(t){return e.template.clone(t)}}o(e);return e},createObject:function(e){o(e);return e},extract:function(e,t,r){var a;if(e&&typeof e==="object"){if(e.Type){a=undefined}else if(e[n]){delete e[n]}else if(e.ui5object){delete e.ui5object}else if(e.path!=undefined||e.parts||r&&e.value!=undefined){a=e}}if(typeof e==="string"){a=p.parse(e,t,true)}return a},escape:function(){return p.parse.escape.apply(this,arguments)},UI5ObjectMarker:n};function u(){var t=e.get({name:"sapUiBindingSyntax",type:e.Type.String,defaultValue:"default",freeze:true});if(t==="default"){t=r("sapCoreBindingSyntax").compareTo("1.26")<0?"simple":"complex"}return t}Object.defineProperty(p,"parse",{get:function(){if(!this.oParser){this.oParser=a.complexParser;this.oParser=u()==="simple"?a.simpleParser:a.complexParser;if(t.isDesignModeEnabled()==true){a._keepBindingStrings=true}}return this.oParser},set:function(e){this.oParser=e}});return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/BindingParser", ["./ExpressionParser","sap/ui/model/BindingMode","sap/ui/model/Filter","sap/ui/model/Sorter","sap/base/Log","sap/base/util/JSTokenizer","sap/base/util/resolveReference"],function(e,t,r,n,i,o,s){"use strict";var a={_keepBindingStrings:false};var f=/^\{\s*('|"|)[a-zA-Z$_][a-zA-Z0-9$_]*\1\s*:/;var u=/(\\[\\\{\}])|(\{)/g;var p=/([\\\{\}])/g;function l(e,t){var r=e.some(function(e){return e.requiresIContext});function n(n){var i,o=e.length,s=arguments,a=new Array(o);for(i=0;i<o;i+=1){if(e[i].requiresIContext){s=arguments}else if(r){s=Array.prototype.slice.call(arguments,1)}a[i]=e[i].apply(this,s)}if(t){return t.apply(this,a)}return o>1?a.join(" "):a[0]}if(r){n.requiresIContext=true}n.textFragments=t&&t.textFragments||"sap.ui.base.BindingParser: composeFormatters";return n}function c(e){var t=function(){var t=[],r=e.length,n;for(n=0;n<r;n++){if(typeof e[n]==="number"){t.push(arguments[e[n]])}else{t.push(e[n])}}return t.join("")};t.textFragments=e;return t}function d(e){var t=e.indexOf(">"),r={path:e};if(t>0){r.model=e.slice(0,t);r.path=e.slice(t+1)}return r}function y(e,t){try{a.mergeParts(e)}catch(e){i.error("[FUTURE FATAL] Cannot merge parts: "+e.message,t,"sap.ui.base.BindingParser")}}function h(e,t){var o=Object.assign({".":e.oContext},e.mLocals);function a(t,r){if(typeof t[r]==="string"){var n=t[r];t[r]=s(t[r],o,{preferDotContext:e.bPreferContext,bindDotContext:!e.bStaticContext});if(typeof t[r]!=="function"){if(e.bTolerateFunctionsNotFound){e.aFunctionsNotFound=e.aFunctionsNotFound||[];e.aFunctionsNotFound.push(n)}else{i.error("[FUTURE FATAL] "+r+" function "+n+" not found!")}}}}function f(t){var r;var n=t.type;if(typeof n==="string"){r=s(n,o,{bindContext:false,useProbingRequire:!e.aTypePromises});var a=function(e){if(typeof e==="function"){t.type=new e(t.formatOptions,t.constraints)}else{t.type=e}if(!t.type){i.error("[FUTURE FATAL] Failed to resolve type '"+n+"'. Maybe not loaded or a typo?")}delete t.formatOptions;delete t.constraints};if(e.aTypePromises){var f;if(typeof r==="function"&&!r._sapUiLazyLoader||r&&typeof r==="object"){f=Promise.resolve(a(r))}else{f=new Promise(function(e,t){sap.ui.require([n.replace(/\./g,"/")],e,t)}).catch(function(e){i.error("[FUTURE FATAL]",e)}).then(a)}e.aTypePromises.push(f)}else{a(r)}}}function u(e){if(e!=null&&typeof e==="object"){for(var t in e){a(e,t)}}}function p(e,t){var n=e[t];if(Array.isArray(n)){n.forEach(function(e,t){p(n,t)});return}if(n&&typeof n==="object"){a(n,"test");p(n,"filters");p(n,"condition");e[t]=new r(n)}}function l(e,t){var r=e[t];if(Array.isArray(r)){r.forEach(function(e,t){l(r,t)});return}if(r&&typeof r==="object"){a(r,"group");a(r,"comparator");e[t]=new n(r)}}if(typeof t==="object"){if(Array.isArray(t.parts)){t.parts.forEach(function(t){h(e,t)})}f(t);p(t,"filters");l(t,"sorter");u(t.events);a(t,"formatter");a(t,"factory");a(t,"groupHeaderFactory")}return t}function m(e,t,r){var n=o.parseJS,i,s;if(f.test(t.slice(r))){i=n(t,r);h(e,i.result);return i}s=t.indexOf("}",r);if(s<r){throw new SyntaxError("no closing braces found in '"+t+"' after pos:"+r)}return{result:d(t.slice(r+1,s)),at:s+1}}a.simpleParser=function(e){var t=arguments[7];var r;if(e.startsWith("{")&&e.endsWith("}")){r=d(e.slice(1,-1))}if(t){return{bindingInfo:r,resolved:Promise.resolve()}}return r};a.simpleParser.escape=function(e){return e};a.complexParser=function(r,n,i,o,s,f,p,l){var d=false,h={parts:[]},g=false,x={oContext:n,mLocals:p,aFunctionsNotFound:undefined,bPreferContext:f,bStaticContext:s,bTolerateFunctionsNotFound:o,aTypePromises:l?[]:undefined},v=[],F,b=0,A,P;function T(t,i,o){var a=e.parse(m.bind(null,x),r,i,null,p||(s?n:null));function f(e,t){if(e.parts){e.parts.forEach(function(t,r){if(typeof t==="string"){t=e.parts[r]={path:t}}f(t,r)});d=d||t!==undefined}else{e.mode=o}}if(t.charAt(a.at)!=="}"){throw new SyntaxError("Expected '}' and instead saw '"+t.charAt(a.at)+"' in expression binding "+t+" at position "+a.at)}a.at+=1;if(a.result){f(a.result)}else{v[v.length-1]=String(a.constant);F=true}return a}u.lastIndex=0;while((A=u.exec(r))!==null){if(b<A.index){v.push(r.slice(b,A.index))}if(A[1]){v.push(A[1].slice(1));F=true}else{v.push(h.parts.length);if(r.indexOf(":=",A.index)===A.index+1){P=T(r,A.index+3,t.OneTime)}else if(r.charAt(A.index+1)==="="){P=T(r,A.index+2,t.OneWay)}else{P=m(x,r,A.index)}if(P.result){h.parts.push(P.result);g=g||"parts"in P.result}u.lastIndex=P.at}b=u.lastIndex}if(b<r.length){v.push(r.slice(b))}if(h.parts.length>0){if(v.length===1){h=h.parts[0];g=d}else{h.formatter=c(v)}if(g){y(h,r)}if(a._keepBindingStrings){h.bindingString=r}if(x.aFunctionsNotFound){h.functionsNotFound=x.aFunctionsNotFound}if(l){return{bindingInfo:h,resolved:Promise.all(x.aTypePromises),wait:x.aTypePromises.length>0}}return h}else if(i&&F){var C=v.join("");if(l){return{bindingInfo:C,resolved:Promise.resolve()}}return C}};a.complexParser.escape=function(e){return e.replace(p,"\\$1")};a.mergeParts=function(e){var t=[],r=[];e.parts.forEach(function(e){var n,i=function(){return e},o,s=r.length;function a(){return arguments[s]}if(e&&typeof e==="object"){if(e.parts){for(o in e){if(o!=="formatter"&&o!=="parts"){throw new Error("Unsupported property: "+o)}}r=r.concat(e.parts);n=r.length;if(e.formatter){if(e.formatter.requiresIContext===true){i=function(t){var r=Array.prototype.slice.call(arguments,s+1,n+1);r.unshift(t._slice(s,n));return e.formatter.apply(this,r)};i.requiresIContext=true}else{i=function(){return e.formatter.apply(this,Array.prototype.slice.call(arguments,s,n))}}}else if(n-s>1){i=function(){return Array.prototype.slice.call(arguments,s,n).join(" ")}}else{i=a}}else if("path"in e){r.push(e);i=a}}t.push(i)});e.parts=r;e.formatter=l(t,e.formatter)};a.parseExpression=function(t,r,n,i){n=n||{};if(i){n.mLocals=i}return e.parse(m.bind(null,n),t,r,i)};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/Event", ["./Object","sap/base/assert"],function(t,e){"use strict";var r=t.extend("sap.ui.base.Event",{constructor:function(e,r,n){t.apply(this);if(arguments.length>0){this.init(e,r,n)}}});r.prototype.init=function(r,n,s){e(typeof r==="string","Event.init: sId must be a string");e(t.isObjectA(n,"sap.ui.base.EventProvider"),"Event.init: oSource must be an EventProvider");this.sId=r;this.oSource=n;this.mParameters=s||{};this.bCancelBubble=false;this.bPreventDefault=false};r.prototype.reset=function(){this.sId="";this.oSource=null;this.mParameters=null;this.bCancelBubble=false;this.bPreventDefault=false};r.prototype.getId=function(){return this.sId};r.prototype.getSource=function(){return this.oSource};r.prototype.getParameters=function(){return this.mParameters};r.prototype.getParameter=function(t){e(typeof t==="string"&&t,"Event.getParameter: sName must be a non-empty string");return this.mParameters[t]};r.prototype.cancelBubble=function(){this.bCancelBubble=true};r.prototype.preventDefault=function(){this.bPreventDefault=true};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/EventProvider", ["./Event","./Object","sap/base/assert","sap/base/Log"],function(t,e,n,i){"use strict";var r=e.extend("sap.ui.base.EventProvider",{constructor:function(){e.call(this);this.mEventRegistry={}}});var o="EventHandlerChange";r.M_EVENTS={EventHandlerChange:o};r.prototype.attachEvent=function(t,e,i,r){var a=this.mEventRegistry;n(typeof t==="string"&&t,"EventProvider.attachEvent: sEventId must be a non-empty string");if(typeof e==="function"){r=i;i=e;e=undefined}n(typeof i==="function","EventProvider.attachEvent: fnFunction must be a function");n(!r||typeof r==="object","EventProvider.attachEvent: oListener must be empty or an object");r=r===this?undefined:r;var s=a[t];if(!Array.isArray(s)){s=a[t]=[]}s.push({oListener:r,fFunction:i,oData:e});if(a[o]){this.fireEvent(o,{EventId:t,type:"listenerAttached",listener:r,func:i,data:e})}return this};r.prototype.attachEventOnce=function(t,e,i,r){if(typeof e==="function"){r=i;i=e;e=undefined}n(typeof i==="function","EventProvider.attachEventOnce: fnFunction must be a function");var o=function(){this.detachEvent(t,o);i.apply(r||this,arguments)};o.oOriginal={fFunction:i,oListener:r,oData:e};this.attachEvent(t,e,o,undefined);return this};r.prototype.detachEvent=function(t,e,i){var r=this.mEventRegistry;n(typeof t==="string"&&t,"EventProvider.detachEvent: sEventId must be a non-empty string");n(typeof e==="function","EventProvider.detachEvent: fnFunction must be a function");n(!i||typeof i==="object","EventProvider.detachEvent: oListener must be empty or an object");var a=r[t];if(!Array.isArray(a)){return this}var s,f;i=i===this?undefined:i;for(var v=0,u=a.length;v<u;v++){if(a[v].fFunction===e&&a[v].oListener===i){s=a[v];a.splice(v,1);break}}if(!s){for(var v=0,u=a.length;v<u;v++){f=a[v].fFunction.oOriginal;if(f&&f.fFunction===e&&f.oListener===i){s=f;a.splice(v,1);break}}}if(a.length==0){delete r[t]}if(s&&r[o]){this.fireEvent(o,{EventId:t,type:"listenerDetached",listener:s.oListener,func:s.fFunction,data:s.oData})}return this};r.prototype.fireEvent=function(e,n,r,o){if(typeof n==="boolean"){o=r;r=n}var a=this,s=false,f,v,u,c,h;do{f=a.mEventRegistry[e];if(Array.isArray(f)){f=f.slice();v=new t(e,this,n);for(u=0,c=f.length;u<c;u++){h=f[u];const t=h.fFunction.call(h.oListener||a,v,h.oData);if(typeof t?.then==="function"){t.catch?.(t=>{i.error(`EventProvider.fireEvent: Event Listener for event '${e}' failed during execution.`,t)})}}o=o&&!v.bCancelBubble}a=a.getEventingParent()}while(o&&a);if(v){s=v.bPreventDefault}return r?!s:this};r.prototype.hasListeners=function(t){return!!this.mEventRegistry[t]};r.getEventList=function(t){return t.mEventRegistry};r.hasListener=function(t,e,i,r){n(typeof e==="string"&&e,"EventProvider.hasListener: sEventId must be a non-empty string");n(typeof i==="function","EventProvider.hasListener: fnFunction must be a function");n(!r||typeof r==="object","EventProvider.hasListener: oListener must be empty or an object");var o=t&&t.mEventRegistry[e];if(o){for(var a=0,s=o.length;a<s;a++){if(o[a].fFunction===i&&o[a].oListener===r){return true}}}return false};r.prototype.getEventingParent=function(){return null};r.prototype.toString=function(){if(this.getMetadata){return"EventProvider "+this.getMetadata().getName()}else{return"EventProvider"}};r.prototype.destroy=function(){this.mEventRegistry={};e.prototype.destroy.apply(this,arguments)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/ExpressionParser", ["sap/base/Log","sap/base/strings/escapeRegExp","sap/base/util/deepEqual","sap/base/util/JSTokenizer","sap/ui/performance/Measurement","sap/ui/thirdparty/URI"],function(e,n,t,r,i,u){"use strict";
//License granted by Douglas Crockford to SAP, Apache License 2.0
//    (http://www.apache.org/licenses/LICENSE-2.0)
var a=I.bind(null,undefined),s={Array:Array,Boolean:Boolean,Date:Date,encodeURIComponent:encodeURIComponent,Infinity:Infinity,isFinite:isFinite,isNaN:isNaN,JSON:JSON,Math:Math,NaN:NaN,Number:Number,Object:Object,odata:{collection:function(e){return e.filter(function(e){return e!==undefined})},compare:function(){var e=sap.ui.require("sap/ui/model/odata/v4/ODataUtils");if(!e){e=sap.ui.requireSync("sap/ui/model/odata/v4/ODataUtils")}if(!e){throw new TypeError("Expression uses 'odata.compare' which requires to"+" import 'sap/ui/model/odata/v4/ODataUtils' in advance")}return e.compare.apply(e,arguments)},fillUriTemplate:function(e,n){if(!u.expand){sap.ui.requireSync("sap/ui/thirdparty/URITemplate")}if(!u.expand){throw new TypeError("Expression uses 'odata.fillUriTemplate' which requires"+" to import 'sap/ui/thirdparty/URITemplate' in advance")}return u.expand(e.trim(),n).toString()},uriEncode:function(){var e=sap.ui.require("sap/ui/model/odata/ODataUtils");if(!e){e=sap.ui.requireSync("sap/ui/model/odata/ODataUtils")}if(!e){throw new TypeError("Expression uses 'odata.uriEncode' which requires to"+" import 'sap/ui/model/odata/ODataUtils' in advance")}return e.formatValue.apply(e,arguments)}},parseFloat:parseFloat,parseInt:parseInt,RegExp:RegExp,String:String,undefined:undefined},o=/\d/,l="sap.ui.base.ExpressionParser",d=/[a-z_$][a-z0-9_$]*/i,c=/[a-z_$]/i,f=[l],p=l+"#parse",v={BINDING:{led:D,nud:function(e,n){return g.bind(null,e.value)}},ERROR:{lbp:Infinity,led:function(e,n,t){U(e.value.message,e.value.text,e.value.at)},nud:function(e,n){U(e.value.message,e.value.text,e.value.at)}},IDENTIFIER:{led:D,nud:function(n,t){if(!(n.value in t.globals)){e.warning("Unsupported global identifier '"+n.value+"' in expression parser input '"+t.input+"'",undefined,l)}return I.bind(null,t.globals[n.value])}},CONSTANT:{led:D,nud:function(e,n){return I.bind(null,e.value)}},".":{lbp:18,led:function(e,n,t){return E.bind(null,t,n.advance("IDENTIFIER").value)},nud:D},"(":{lbp:17,led:function(e,n,t){var r=[],i=true;while(n.current().id!==")"){if(i){i=false}else{n.advance(",")}r.push(n.expression(0))}n.advance(")");return y.bind(null,t,r)},nud:function(e,n){var t=n.expression(0);n.advance(")");return t}},"[":{lbp:18,led:function(e,n,t){var r=n.expression(0);n.advance("]");return T.bind(null,t,r)},nud:function(e,n){var t=[],r=true;while(n.current().id!=="]"){if(r){r=false}else{n.advance(",")}t.push(n.current().id===","?a:n.expression(0))}n.advance("]");return x.bind(null,t)}},"!":{lbp:15,led:D,nud:function(e,n){return R.bind(null,n.expression(this.lbp),function(e){return!e})}},typeof:{lbp:15,led:D,nud:function(e,n){return R.bind(null,n.expression(this.lbp),function(e){return typeof e})}},"?":{lbp:4,led:function(e,n,t){var r,i;i=n.expression(this.lbp-1);n.advance(":");r=n.expression(this.lbp-1);return m.bind(null,t,i,r)},nud:D},")":{led:D,nud:D},"]":{led:D,nud:D},"{":{led:D,nud:function(e,n){var t=true,r,i={},u;while(n.current().id!=="}"){if(t){t=false}else{n.advance(",")}if(n.current()&&n.current().id==="CONSTANT"&&typeof n.current().value==="string"){r=n.advance().value}else{r=n.advance("IDENTIFIER").value}n.advance(":");u=n.expression(0);i[r]=u}n.advance("}");return w.bind(null,i)}},"}":{lbp:-1,led:D,nud:D},",":{led:D,nud:D},":":{led:D,nud:D}},b=["===","!==","!","||","&&",".","(",")","{","}",":",",","?","*","/","%","+","-","<=","<",">=",">","[","]"],h;b.forEach(function(e,t){b[t]=n(e)});h=new RegExp(b.join("|"),"g");O("*",14,function(e,n){return e*n});O("/",14,function(e,n){return e/n});O("%",14,function(e,n){return e%n});O("+",13,function(e,n){return e+n}).nud=function(e,n){return R.bind(null,n.expression(this.lbp),function(e){return+e})};O("-",13,function(e,n){return e-n}).nud=function(e,n){return R.bind(null,n.expression(this.lbp),function(e){return-e})};O("<=",11,function(e,n){return e<=n});O("<",11,function(e,n){return e<n});O(">=",11,function(e,n){return e>=n});O(">",11,function(e,n){return e>n});O("in",11,function(e,n){return e in n});O("===",10,function(e,n){return e===n});O("!==",10,function(e,n){return e!==n});O("&&",7,function(e,n){return e&&n()},true);O("||",6,function(e,n){return e||n()},true);function x(e,n){return e.map(function(e){return e(n)})}function g(e,n){return S(n[e])}function m(e,n,t,r){return e(r)?n(r):t(r)}function I(e){return e}function E(e,n,t,r){var i=e(t),u=i[n];if(r){r.base=i}return S(u)}function y(e,n,t){var r={};return S(e(t,r).apply(r.base,n.map(function(e){return e(t)})))}function N(e,n,t,r,i){return t(e(i),r?n.bind(null,i):n(i))}function w(e,n){var t,r={};for(t in e){r[t]=e[t](n)}return r}function T(e,n,t,r){var i=e(t),u=n(t),a=i[u];if(r){r.base=i}return S(a)}function R(e,n,t){return n(e(t))}function O(e,n,t,r){v[e]={lbp:n,led:function(e,n,i){var u=r?this.lbp-1:this.lbp;return N.bind(null,i,n.expression(u),t,r)},nud:D};return v[e]}function S(e){return e===Function?undefined:e}function U(n,t,r){var i=new SyntaxError(n);i.at=r;i.text=t;if(r!==undefined){n+=" at position "+r}e.error(n,t,l);throw i}function D(e){U("Unexpected "+e.id,e.input,e.start+1)}function F(e,n,i){var u=[],a=[],s=[],l=new r;function f(e,i,s){var o=false,l,d,c;function f(e){if(s){if(e.parts){e.parts.forEach(f)}else{e.targetType=e.targetType||"any"}}}for(l in e){switch(typeof e[l]){case"boolean":case"number":case"string":case"undefined":break;default:o=true}}f(e);if(o){d=r.parseJS(n,i).result;f(d)}else{d=e}for(c=0;c<u.length;c+=1){if(t(a[c],d)){return c}}a[c]=d;u[c]=e;return c}function p(){var t,r,i,u,a;l.white();t=l.getCh();i=l.getIndex();if((t==="$"||t==="%")&&n[i+1]==="{"){r=e(n,i+1);a={id:"BINDING",value:f(r.result,i+1,t==="%")};l.setIndex(r.at)}else if(c.test(t)){u=d.exec(n.slice(i));switch(u[0]){case"false":case"null":case"true":a={id:"CONSTANT",value:l.word()};break;case"in":case"typeof":a={id:u[0]};l.setIndex(i+u[0].length);break;default:a={id:"IDENTIFIER",value:u[0]};l.setIndex(i+u[0].length)}}else if(o.test(t)||t==="."&&o.test(n[i+1])){a={id:"CONSTANT",value:l.number()}}else if(t==="'"||t==='"'){a={id:"CONSTANT",value:l.string()}}else{h.lastIndex=i;u=h.exec(n);if(!u||u.index!==i){return false}a={id:u[0]};l.setIndex(i+u[0].length)}a.input=n;a.start=i;a.end=l.getIndex();s.push(a);return true}l.init(n,i);try{while(p()){}}catch(e){if(e.name==="SyntaxError"){s.push({id:"ERROR",value:e})}else{throw e}}return{at:l.getIndex(),parts:u,tokens:s}}function q(n,t){return function(){try{return n.apply(this,arguments)}catch(n){e.warning(String(n),t,l)}}}function C(e,n,t){var r,i=0,u={advance:s,current:o,expression:l,globals:t,input:n},a;function s(t){var r=e[i];if(t){if(!r){U("Expected "+t+" but instead saw end of input",n)}else if(r.id!==t){U("Expected "+t+" but instead saw "+n.slice(r.start,r.end),n,r.start+1)}}i+=1;return r}function o(){return e[i]}function l(t){var r;a=s();if(!a){U("Expected expression but instead saw end of input",n)}r=v[a.id].nud(a,u);while(i<e.length){a=o();if(t>=(v[a.id].lbp||0)){break}s();r=v[a.id].led(a,u,r)}return r}r=l(0);return{at:o()&&o().start,formatter:q(r,n)}}return{parse:function(e,n,t,r,u){var a,o;i.average(p,"",f);o=F(e,n,t);r=r||s;if(u){r=Object.assign({},r,u)}a=C(o.tokens,n,r);i.end(p);if(!o.parts.length){return{constant:a.formatter(),at:a.at||o.at}}function l(){return a.formatter(arguments)}l.textFragments=true;return{result:{formatter:l,parts:o.parts},at:a.at||o.at}}}},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/ManagedObject", ["./DataType","./EventProvider","./ManagedObjectMetadata","./Object","./BindingInfo","sap/ui/util/ActivityDetection","sap/ui/util/_enforceNoReturnValue","sap/base/util/ObjectPath","sap/base/Log","sap/base/assert","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/uid","sap/base/util/extend","sap/base/util/isEmptyObject"],function(t,e,i,n,r,s,o,a,g,p,f,d,h,l,u){"use strict";var c;var y=Symbol("bindingInfoFactory");var b=e.extend("sap.ui.base.ManagedObject",{metadata:{abstract:true,publicMethods:["getId","getMetadata","getModel","setModel","hasModel","bindProperty","unbindProperty","bindAggregation","unbindAggregation","bindObject","unbindObject","getObjectBinding"],library:"sap.ui.core",properties:{},aggregations:{},associations:{},events:{validationSuccess:{enableEventBubbling:true,parameters:{element:{type:"sap.ui.base.ManagedObject"},property:{type:"string"},type:{type:"sap.ui.model.Type"},newValue:{type:"any"},oldValue:{type:"any"}}},validationError:{enableEventBubbling:true,parameters:{element:{type:"sap.ui.base.ManagedObject"},property:{type:"string"},type:{type:"sap.ui.model.Type"},newValue:{type:"any"},oldValue:{type:"any"},message:{type:"string"}}},parseError:{enableEventBubbling:true,parameters:{element:{type:"sap.ui.base.ManagedObject"},property:{type:"string"},type:{type:"sap.ui.model.Type"},newValue:{type:"any"},oldValue:{type:"any"},message:{type:"string"}}},formatError:{enableEventBubbling:true,parameters:{element:{type:"sap.ui.base.ManagedObject"},property:{type:"string"},type:{type:"sap.ui.model.Type"},newValue:{type:"any"},oldValue:{type:"any"}}},modelContextChange:{}},specialSettings:{id:"sap.ui.core.ID",models:"object",bindingContexts:"object",objectBindings:"object",metadataContexts:"object",Type:{type:"string",visibility:"hidden"}}},constructor:function(i,n,r){e.call(this);const s=this;if(typeof i!=="string"&&i!==undefined){r=n;n=i;i=n&&n.id}if(!i){i=this.getMetadata().uid()}else{var a=b._fnIdPreprocessor;i=a?a.call(this,i):i;var g=c||(c=t.getType("sap.ui.core.ID"));if(!g.isValid(i)){throw new Error('"'+i+'" is not a valid ID.')}}this.sId=i;this.mProperties=this.getMetadata().createPropertyBag();this.mAggregations={};this.mAssociations={};this.oParent=null;this.aDelegates=[];this.aBeforeDelegates=[];this.iSuppressInvalidate=0;this.oPropagatedProperties=b._oEmptyPropagatedProperties;this.mSkipPropagation={};this._bIsOwnerActive=true;this.oModels={};this.aPropagationListeners=[];this.oBindingContexts={};this.mElementBindingContexts={};this.mBindingInfos={};this.mObjectBindingInfos={};this._oContextualSettings=b._defaultContextualSettings;this._sOwnerId=b._sOwnerId;(function(){var t=false;if(s.register){s.register()}try{if(s._initCompositeSupport){s._initCompositeSupport(n)}if(s.init){o(s.init(),{name:"init",component:s.getId()})}s.applySettings(n,r);t=true}finally{if(!t&&s.deregister){s.deregister()}}})()}},i);Object.defineProperty(b,"bindingParser",{set:function(t){r.parse=t},get:function(){return r.parse}});function m(t){p(t===undefined||typeof t==="string"&&!/^(undefined|null)?$/.test(t),"sModelName must be a string or omitted")}var v=false;function P(t){if(!v){var e=Object.values(t)[0];if(e&&e.mixinBindingSupport){e.mixinBindingSupport(b.prototype);v=true}}}function A(t,e,i){if(!t||t instanceof b||typeof t!=="object"||t instanceof String){return t}function n(t){if(typeof t==="function"){return t}if(typeof t==="string"){const e=a.get(t);if(e!=null){g.error(`Defining the object type ('${t}') via its string name is deprecated, since it leads to accesses to the global namespace. `+`The object type either stems from an explicitly given 'Type' value or was inferred from the default aggregation type. `+`Please require the respective object type module beforehand. `+`For control development, please also refer to the runtime metadata property 'defaultClass', which allows you to specify a default aggregation class type via constructor reference.`)}return e}}let r;r=n(t.Type);r??=e?.defaultClass;r??=n(e?.type);if(typeof r==="function"){return new r(t,i)}var s="Don't know how to create a ManagedObject from "+t+" ("+typeof t+")";g.fatal(s);throw new Error(s)}b.create=A;b._fnIdPreprocessor=null;b._fnSettingsPreprocessor=null;b.runWithPreprocessors=function(t,e,i){p(typeof t==="function","fn must be a function");p(!e||typeof e==="object","oPreprocessors must be an object");var n={id:this._fnIdPreprocessor,settings:this._fnSettingsPreprocessor};e=e||{};this._fnIdPreprocessor=e.id;this._fnSettingsPreprocessor=e.settings;try{return t.call(i)}finally{this._fnIdPreprocessor=n.id;this._fnSettingsPreprocessor=n.settings}};b.runWithOwner=function(t,e,i){p(typeof t==="function","fn must be a function");var n=b._sOwnerId;try{b._sOwnerId=e;return t.call(i)}finally{b._sOwnerId=n}};b.prototype.applySettings=function(e,i){if(!e||u(e)){return this}var r=this,s=this.getMetadata(),o=s.getJSONKeys(),a=b._fnSettingsPreprocessor,f,d,h;function l(t){for(var e=0,n=t.length;e<n;e++){var s=t[e];if(Array.isArray(s)){l(s)}else{r[h._sMutator](A(s,h,i))}}}function c(t){r[h._sMutator](t[0],t[1],t[2])}function y(e){var i=t.getType(e),n=i&&i.getPrimitiveType().getName();return n==="object"||n==="any"}a&&a.call(this,e);if(e.metadataContexts&&this._processMetadataContexts){this._processMetadataContexts(e.metadataContexts,e)}if(e.models){if(typeof e.models!=="object"){throw new Error("models must be a simple object")}if(n.isObjectA(e.models,"sap.ui.model.Model")){this.setModel(e.models)}else{for(f in e.models){this.setModel(e.models[f],f==="undefined"?undefined:f)}}}if(e.bindingContexts){if(typeof e.bindingContexts!=="object"){throw new Error("bindingContexts must be a simple object")}var m=e.bindingContexts;if(n.isObjectA(m,"sap.ui.model.Context")){this.setBindingContext(e.bindingContexts)}else{for(f in e.bindingContexts){this.setBindingContext(e.bindingContexts[f],f==="undefined"?undefined:f)}}}if(e.objectBindings){if(typeof e.objectBindings!=="string"&&typeof e.objectBindings!=="object"){throw new Error("binding must be a string or simple object")}if(typeof e.objectBindings==="string"||e.objectBindings.path){this.bindObject(e.objectBindings)}else{for(f in e.objectBindings){e.objectBindings[f].model=f==="undefined"?undefined:f;this.bindObject(e.objectBindings[f])}}}for(f in e){d=e[f];if((h=o[f])!==undefined){var v;switch(h._iKind){case 0:v=this.extractBindingInfo(d,i,!y(h.type));if(v&&typeof v==="object"){this.bindProperty(f,v)}else{this[h._sMutator](typeof v==="string"?v:d)}break;case 1:v=h.altTypes&&this.extractBindingInfo(d,i,!h.altTypes.some(y));if(v&&typeof v==="object"){this.bindProperty(f,v)}else{if(Array.isArray(d)){if(d.length>1){g.error("[FUTURE FATAL] Tried to add an array of controls to a single aggregation")}d=d[0]}this[h._sMutator](A(typeof v==="string"?v:d,h,i))}break;case 2:v=this.extractBindingInfo(d,i);if(v&&typeof v==="object"){this.bindAggregation(f,v)}else{d=typeof v==="string"?v:d;if(d){if(Array.isArray(d)){l(d)}else{r[h._sMutator](A(d,h,i))}}}break;case 3:this[h._sMutator](d);break;case 4:if(d){if(Array.isArray(d)){for(var P=0,_=d.length;P<_;P++){this[h._sMutator](d[P])}}else{this[h._sMutator](d)}}break;case 5:if(typeof d=="function"){this[h._sMutator](d)}else if(Array.isArray(d[0])&&(d.length<=1||Array.isArray(d[1]))){d.forEach(c)}else{c(d)}break;case-1:break;default:break}}else{p(false,"ManagedObject.apply: encountered unknown setting '"+f+"' for class '"+s.getName()+"' (value:'"+d+"')")}}return this};b.escapeSettingsValue=function(t){return typeof t==="string"?r.escape(t):t};b.prototype.toString=function(){return"ManagedObject "+this.getMetadata().getName()+"#"+this.getId()};b.prototype.getId=function(){return this.sId};b.prototype.setProperty=function(t,i,n){var r=this.mProperties[t];i=this.validateProperty(t,i);if(d(r,i)){this.mProperties[t]=i;return this}if(n){s.refresh()}this.mProperties[t]=i;if(!n&&!this.isInvalidateSuppressed()){this.invalidate()}this.updateModelProperty(t,i,r);i=this.mProperties[t];if(this.mEventRegistry["_change"]){e.prototype.fireEvent.call(this,"_change",{id:this.getId(),name:t,oldValue:r,newValue:i})}if(this._observer){this._observer.propertyChange(this,t,r,i)}return this};b.prototype.getProperty=function(e){var i=this.mProperties[e],n=this.getMetadata().getManagedProperty(e),r;if(!n){throw new Error('Property "'+e+'" does not exist in '+this)}r=t.getType(n.type);if(r instanceof t&&r.isArrayType()&&Array.isArray(i)){i=i.slice(0)}if(i instanceof String){i=i.valueOf()}if(n.byValue){i=f(i)}return i};b.prototype.validateProperty=function(e,i){var n=this.getMetadata().getManagedProperty(e),r;if(!n){throw new Error('Property "'+e+'" does not exist in '+this)}r=t.getType(n.type);if(r instanceof t&&r.isArrayType()&&Array.isArray(i)){i=i.slice(0)}if(i==null){i=n.getDefaultValue()}else if(r instanceof t){if(r.getName()=="string"){if(!(typeof i=="string"||i instanceof String)){i=""+i}}else if(r.getName()=="string[]"){if(typeof i=="string"){i=[i]}if(!Array.isArray(i)){throw new Error('"'+i+'" is of type '+typeof i+", expected string[]"+' for property "'+e+'" of '+this)}for(var s=0;s<i.length;s++){if(typeof i[s]!=="string"){i[s]=""+i[s]}}}else if(!r.isValid(i)){throw new Error('"'+i+'" is of type '+typeof i+", expected "+r.getName()+' for property "'+e+'" of '+this)}}if(n.byValue){i=f(i)}if(r&&r.normalize&&typeof r.normalize==="function"){i=r.normalize(i)}return i};b.prototype.isPropertyInitial=function(t){return!Object.hasOwn(this.mProperties,t)&&!this.isBound(t)};b.prototype.resetProperty=function(t){if(this.mProperties.hasOwnProperty(t)){var e=this.getMetadata().getManagedProperty(t);e.set(this,null);if(this.mProperties[t]===e.getDefaultValue()){delete this.mProperties[t]}}return this};b.prototype.getOriginInfo=function(t){var e=this.mProperties[t];if(!(e instanceof String&&e.originInfo)){return null}return e.originInfo};b.prototype.setAssociation=function(t,e,i){if(e instanceof b){e=e.getId()}else if(e!=null&&typeof e!=="string"){p(false,"setAssociation(): sId must be a string, an instance of sap.ui.base.ManagedObject or null");return this}if(this.mAssociations[t]===e){return this}if(i){this.iSuppressInvalidate++}if(this._observer&&this.mAssociations[t]!=null){this._observer.associationChange(this,t,"remove",this.mAssociations[t])}this.mAssociations[t]=e;if(this._observer&&this.mAssociations[t]!=null){this._observer.associationChange(this,t,"insert",e)}if(!this.isInvalidateSuppressed()){this.invalidate()}if(i){this.iSuppressInvalidate--}return this};b.prototype.getAssociation=function(t,e){var i=this.mAssociations[t];if(!i){i=this.mAssociations[t]=e||null}else{if(typeof i.length==="number"&&!i.propertyIsEnumerable("length")){return i.slice()}return i}return i};b.prototype.addAssociation=function(t,e,i){if(e instanceof b){e=e.getId()}else if(typeof e!=="string"){p(false,"addAssociation(): sId must be a string or an instance of sap.ui.base.ManagedObject");return this}if(i){this.iSuppressInvalidate++}var n=this.mAssociations[t];if(!n){n=this.mAssociations[t]=[e]}else{n.push(e)}if(this._observer){this._observer.associationChange(this,t,"insert",e)}if(!this.isInvalidateSuppressed()){this.invalidate()}if(i){this.iSuppressInvalidate--}return this};b.prototype.removeAssociation=function(t,e,i){var n=this.mAssociations[t];var r=null;if(!n){return null}if(i){this.iSuppressInvalidate++}if(typeof e=="object"&&e.getId){e=e.getId()}if(typeof e=="string"){for(var s=0;s<n.length;s++){if(n[s]==e){e=s;break}}}if(typeof e=="number"){if(e<0||e>=n.length){g.warning("[FUTURE FATAL] ManagedObject.removeAssociation called with invalid index: "+t+", "+e)}else{r=n[e];n.splice(e,1);if(this._observer){this._observer.associationChange(this,t,"remove",r)}if(!this.isInvalidateSuppressed()){this.invalidate()}}}if(i){this.iSuppressInvalidate--}return r};b.prototype.removeAllAssociation=function(t,e){var i=this.mAssociations[t];if(!i){return[]}delete this.mAssociations[t];if(!i.length){return i}if(e){this.iSuppressInvalidate++}if(this._observer){this._observer.associationChange(this,t,"remove",i)}if(!this.isInvalidateSuppressed()){this.invalidate()}if(e){this.iSuppressInvalidate--}return i};b.prototype.validateAggregation=function(e,i,r,s){var o=this.getMetadata(),g=o.getManagedAggregation(e),f,d,h,l;if(!g){throw new Error('Aggregation "'+e+'" does not exist in '+this)}if(g.multiple!==r){throw new Error("Aggregation '"+e+"' of "+this+" used with wrong cardinality (declared as "+(g.multiple?"0..n":"0..1")+")")}var u=o.getAggregationForwarder(e);if(u&&!s){u.getTarget(this).validateAggregation(u.targetAggregationName,i,r)}if(!g.multiple&&!i){return i}if(n.isObjectA(i,g.type)){return i}f=g.altTypes;if(f&&f.length){if(i==null){return i}for(h=0;h<f.length;h++){d=t.getType(f[h]);if(d instanceof t){if(d.isValid(i)){return i}}}}d=a.get(g.type);if(typeof d==="function"&&i instanceof d){return i}l='"'+i+'" is not valid for aggregation "'+e+'" of '+this;if(t.isInterfaceType(g.type)){p(false,l);return i}else{throw new Error(l)}};b.prototype.setAggregation=function(t,e,i){var n=this.getMetadata().getAggregationForwarder(t);if(n){e=this.validateAggregation(t,e,false,true);return n.set(this,e)}var r=this.mAggregations[t];if(r===e){return this}e=this.validateAggregation(t,e,false);if(i){this.iSuppressInvalidate++}this.mAggregations[t]=null;if(r instanceof b){r.setParent(null)}else{if(this._observer!=null&&r!=null){this._observer.aggregationChange(this,t,"remove",r)}}this.mAggregations[t]=e;if(e instanceof b){e.setParent(this,t,i)}else{if(!this.isInvalidateSuppressed()){this.invalidate()}if(this._observer!=null&&e!=null){this._observer.aggregationChange(this,t,"insert",e)}}if(i){this.iSuppressInvalidate--}return this};b.prototype.getAggregation=function(t,e){var i=this.getMetadata().getAggregationForwarder(t);if(i){return i.get(this)}var n=this.mAggregations[t];if(!n){n=this.mAggregations[t]=e||null}if(n){if(typeof n.length==="number"&&!n.propertyIsEnumerable("length")){return n.slice()}return n}else{return null}};b.prototype.indexOfAggregation=function(t,e){var i=this.getMetadata().getAggregationForwarder(t);if(i){return i.indexOf(this,e)}var n=this.mAggregations[t];if(n){if(n.length==undefined){return-2}for(var r=0;r<n.length;r++){if(n[r]==e){return r}}}return-1};b.prototype.insertAggregation=function(t,e,i,n){if(!e){return this}e=this.validateAggregation(t,e,true,true);var r=this.getMetadata().getAggregationForwarder(t);if(r){return r.insert(this,e,i)}var s=this.mAggregations[t]||(this.mAggregations[t]=[]);var o;if(i<0){o=0}else if(i>s.length){o=s.length}else{o=i}if(o!==i){g.warning("[FUTURE FATAL] ManagedObject.insertAggregation: index '"+i+"' out of range [0,"+s.length+"], forced to "+o)}s.splice(o,0,e);e.setParent(this,t,n);return this};b.prototype.addAggregation=function(t,e,i){if(!e){return this}e=this.validateAggregation(t,e,true,true);var n=this.getMetadata().getAggregationForwarder(t);if(n){return n.add(this,e)}var r=this.mAggregations[t];if(!r){r=this.mAggregations[t]=[e]}else{r.push(e)}e.setParent(this,t,i);return this};b.prototype.removeAggregation=function(t,e,i){var n=this.getMetadata().getAggregationForwarder(t);if(n){return n.remove(this,e)}var r=this.mAggregations[t],s=null,o;if(!r){return null}if(i){this.iSuppressInvalidate++}if(typeof e=="string"){for(o=0;o<r.length;o++){if(r[o]&&r[o].getId()===e){e=o;break}}}if(typeof e=="object"){for(o=0;o<r.length;o++){if(r[o]==e){e=o;break}}}if(typeof e=="number"){if(e<0||e>=r.length){g.warning("[FUTURE FATAL] ManagedObject.removeAggregation called with invalid index: "+t+", "+e)}else{s=r[e];r.splice(e,1);s.setParent(null);if(!this.isInvalidateSuppressed()){this.invalidate()}}}if(i){this.iSuppressInvalidate--}return s};b.prototype.removeAllAggregation=function(t,e){var i=this.getMetadata().getAggregationForwarder(t);if(i){return i.removeAll(this)}var n=this.mAggregations[t];if(!n){return[]}delete this.mAggregations[t];if(!n.length){return n}if(e){this.iSuppressInvalidate++}for(var r=0;r<n.length;r++){n[r].setParent(null)}if(!this.isInvalidateSuppressed()){this.invalidate()}if(e){this.iSuppressInvalidate--}return n};b.prototype.destroyAggregation=function(t,e){var i=this.getMetadata().getAggregationForwarder(t);if(i){return i.destroy(this)}var n=this.mAggregations[t],r,s;if(!n){return this}delete this.mAggregations[t];if(Array.isArray(n)&&!n.length){return this}if(e){this.iSuppressInvalidate++}if(n instanceof b){n.destroy(e);if(this._observer){this._observer.aggregationChange(this,t,"remove",n)}}else if(Array.isArray(n)){for(r=n.length-1;r>=0;r--){s=n[r];if(s){s.destroy(e);if(this._observer){this._observer.aggregationChange(this,t,"remove",s)}}}}if(!this.isInvalidateSuppressed()){this.invalidate()}if(e){this.iSuppressInvalidate--}return this};b.prototype.invalidate=function(){if(this.oParent&&this.oParent.isInvalidateSuppressed&&!this.oParent.isInvalidateSuppressed()){this.oParent.invalidate(this)}};b.prototype.isInvalidateSuppressed=function(){return this.iSuppressInvalidate>0};b.prototype._removeChild=function(t,e,i){if(!e){g.error("[FUTURE FATAL] Cannot remove aggregated child without aggregation name.",null,this)}else{if(i){this.iSuppressInvalidate++}var n=this.indexOfAggregation(e,t);var r=this.getMetadata().getAggregation(e);if(n==-2){if(r&&this[r._sMutator]){this[r._sMutator](null)}else{this.setAggregation(e,null,i)}}else if(n>-1){if(r&&this[r._sRemoveMutator]){this[r._sRemoveMutator](n)}else{this.removeAggregation(e,n,i)}}if(i){this.iSuppressInvalidate--}}};function _(t,e){while(t&&t!==e){t=t.oParent}return!!t}b.prototype.setParent=function(t,e,i){p(t==null||t instanceof b,"oParent either must be null, undefined or a ManagedObject");var n;if(!t){if(this.oParent){n=this._observer||this.oParent._observer;if(n){n.parentChange(this,this.sParentAggregationName,"unset",this.oParent)}if(this.aAPIParentInfos&&this.aAPIParentInfos.forwardingCounter===0){delete this.aAPIParentInfos}}this.oParent=null;this.sParentAggregationName=null;var r=b._oEmptyPropagatedProperties;if(r!==this.oPropagatedProperties){this.oPropagatedProperties=r;if(!this._bIsBeingDestroyed){Promise.resolve().then(function(){if(!this.oParent){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true);this.fireModelContextChange()}}.bind(this))}}this._oContextualSettings=b._defaultContextualSettings;if(!this._bIsBeingDestroyed){Promise.resolve().then(function(){if(!this.oParent){this._propagateContextualSettings()}}.bind(this))}s.refresh();return}if(_(t,this)){throw new Error("Cycle detected: new parent '"+t+"' is already a descendant of (or equal to) '"+this+"'")}if(i){s.refresh();t.iSuppressInvalidate++}var o=this.getParent();if(o){o._removeChild(this,this.sParentAggregationName)}this.oParent=t;this.sParentAggregationName=e;if(!t.mSkipPropagation[e]){var r=this.aAPIParentInfos?this.aAPIParentInfos[0].parent._getPropertiesToPropagate():t._getPropertiesToPropagate();if(r!==this.oPropagatedProperties){this.oPropagatedProperties=r;if(this.hasModel()){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true)}this._callPropagationListener();this.fireModelContextChange()}}this._applyContextualSettings(t._oContextualSettings);if(t&&!t.isInvalidateSuppressed()){t.invalidate(this)}if(i){t.iSuppressInvalidate--}n=this._observer||this.oParent._observer;if(n){n.parentChange(this,e,"set",this.oParent)}return this};b.prototype._applyContextualSettings=function(t){t=t||b._defaultContextualSettings;if(this._oContextualSettings!==t){this._oContextualSettings=t;this._propagateContextualSettings();if(this._bIsOwnerActive){this._onContextualSettingsChanged()}}};b.prototype._onContextualSettingsChanged=function(){};b.prototype._propagateContextualSettings=function(){var t=this._oContextualSettings,e,i,n;for(e in this.mAggregations){i=this.mAggregations[e];if(i instanceof b){i._applyContextualSettings(t)}else if(i instanceof Array){for(n=0;n<i.length;n++){if(i[n]instanceof b){i[n]._applyContextualSettings(t)}}}}};b.prototype._getContextualSettings=function(){return this._oContextualSettings};b.prototype.getParent=function(){return this.oParent};b.prototype.destroy=function(t){var i,n;if(this.bIsDestroyed){return}var r=this;this._bIsBeingDestroyed=true;if(t){this.iSuppressInvalidate++}for(i in this.mBindingInfos){n=this.mBindingInfos[i];if(n.binding){if(n.factory){this._detachAggregationBindingHandlers(i)}else{this._detachPropertyBindingHandlers(i)}}}for(i in this.mObjectBindingInfos){n=this.mObjectBindingInfos[i];if(n.binding){this._detachObjectBindingHandlers(n)}}if(this.exit){o(this.exit(),{name:"exit",component:this.getId()})}if(this._exitCompositeSupport){this._exitCompositeSupport()}for(var s in this.mAggregations){this.destroyAggregation(s,t)}if(this.deregister){this.deregister()}if(this.oParent&&this.sParentAggregationName){this.oParent._removeChild(this,this.sParentAggregationName,t)}delete this.oParent;for(i in this.mBindingInfos){if(this.mBindingInfos[i].factory){this.unbindAggregation(i,true)}else{this.unbindProperty(i,true)}}for(i in this.mObjectBindingInfos){this.unbindObject(i,true)}if(t){this.iSuppressInvalidate--}if(this._observer){this._observer.objectDestroyed(this)}if(this.aAPIParentInfos){this.aAPIParentInfos=null}e.prototype.destroy.apply(this,arguments);this.setParent=function(){throw Error("The object with ID "+r.getId()+" was destroyed and cannot be used anymore.")};this.bIsDestroyed=true};b.prototype.isBinding=function(t,e){return typeof this.extractBindingInfo(t)==="object"};b.prototype.extractBindingInfo=function(t,e,i){var n=r.extract(t,e,i);if(typeof t==="object"&&n&&n.template){n.template=A(n.template)}return n};b.prototype.getBindingInfo=function(t){var e=this.getMetadata().getAggregationForwarder(t);if(e&&e.forwardBinding){return e.getTarget(this).getBindingInfo(e.targetAggregationName)}return this.mBindingInfos[t]};b.prototype._getObjectBindingInfo=function(t){return this.mObjectBindingInfos[t]};b.prototype.bindObject=function(t){var e,i;if(typeof t=="string"){i=t;t={path:i,parameters:arguments[1]}}t=r.createObject(t);e=t.model;if(this.getObjectBinding(e)){this.unbindObject(e,true)}this.mObjectBindingInfos[e]=t;if(this.getModel(e)){this._bindObject(t)}return this};function I(t){g.error("[FUTURE FATAL] Unexpected call of '"+t+"'.")}b.prototype._bindObject=I.bind(null,"_bindObject");b.prototype._detachObjectBindingHandlers=I.bind(null,"_detachObjectBindingHandlers");b.prototype.unbindObject=function(t,e){var i=this.mObjectBindingInfos[t];if(i){delete this.mObjectBindingInfos[t];if(i.binding){this._unbindObject(i,t,e)}}return this};b.prototype._unbindObject=I.bind(null,"_unbindObject");b.prototype.bindContext=function(t){return this.bindObject(t)};b.prototype.unbindContext=function(t){return this.unbindObject(t)};b.prototype.bindProperty=function(t,e,i,s){var o=true,a=this.getMetadata().getPropertyLikeSetting(t);if(!a){throw new Error('Property "'+t+'" does not exist in '+this)}if(typeof e=="string"){e={parts:[{path:e,type:n.isObjectA(i,"sap.ui.model.Type")?i:undefined,mode:s}],formatter:typeof i==="function"?i:undefined}}if(this.isBound(t)){this.unbindProperty(t,true)}e=r.createProperty(e);this.mBindingInfos[t]=e;if(this._observer){this._observer.bindingChange(this,t,"prepare",e,"property")}for(var g=0;g<e.parts.length;g++){if(e.parts[g].value===undefined&&!this.getModel(e.parts[g].model)){o=false;break}}if(o){this._bindProperty(t,e)}return this};b.prototype._bindProperty=function(t,e){var i=true;for(var n=0;n<e.parts.length;n++){if(e.parts[n].value===undefined){i=false;break}}if(i){var r=[];e.parts.forEach(function(t){r.push(t.formatter?t.formatter(t.value):t.value)});var s=e.formatter?e.formatter(r):r.join(" ");var o=this.getMetadata().getPropertyLikeSetting(t);this[o._sMutator](s)}else{I.call(this,"_bindProperty")}};b.prototype._detachPropertyBindingHandlers=function(t){};b.prototype.unbindProperty=function(t,e){var i=this.mBindingInfos[t];if(i){if(i.binding){this._unbindProperty(i,t)}if(this._observer&&!this._bIsBeingDestroyed){this._observer.bindingChange(this,t,"remove",this.mBindingInfos[t],"property")}delete this.mBindingInfos[t];if(!e){this.resetProperty(t)}}return this};b.prototype._unbindProperty=I.bind(null,"_unbindProperty");b.prototype.updateProperty=function(t){};b.prototype.updateModelProperty=function(t,e,i){};var B=1;b.prototype.bindAggregation=function(t,e){var i,n,s,o,a=this.getMetadata(),p=a.getAggregation(t);if(!p){throw new Error('Aggregation "'+t+'" does not exist in '+this)}if(!p.multiple){g.error('[FUTURE FATAL] Binding of single aggregation "'+t+'" of '+this+" is not supported!")}if(typeof e=="string"){i=arguments[1];n=arguments[2];s=arguments[3];o=arguments[4];e={path:i,sorter:s,filters:o};if(n instanceof b){e.template=n}else if(typeof n==="function"){e.factory=n}}var f=a.getAggregationForwarder(t);if(f&&f.forwardBinding){f.getTarget(this).bindAggregation(f.targetAggregationName,e);return this}if(this.isBound(t)){this.unbindAggregation(t)}if(e.template){if(e.template._sapui_candidateForDestroy){g.warning("A binding template that is marked as 'candidate for destroy' is reused in a binding. "+"You can use 'templateShareable:true' to fix this issue for all bindings that are affected "+"(The template is used in aggregation '"+t+"' of object '"+this.getId()+"'). "+"For more information, see documentation under 'Aggregation Binding'.");delete e.template._sapui_candidateForDestroy}if(e.templateShareable===undefined){e.templateShareable=B}}e=r.createAggregation(e,p._doesNotRequireFactory);this.mBindingInfos[t]=e;if(!(e.template||e.factory)){throw new Error("Missing template or factory function for aggregation "+t+" of "+this+" !")}if(e.factory){var d=e.factory[y]||e.factory;var h=this._sOwnerId;e.factory=function(t,e){return b.runWithOwner(d.bind(null,t,e),h)};e.factory[y]=d}if(this._observer){this._observer.bindingChange(this,t,"prepare",e,"aggregation")}if(this.getModel(e.model)){this._bindAggregation(t,e)}return this};b.prototype._bindAggregation=I.bind(null,"_bindAggregation");b.prototype._detachAggregationBindingHandlers=I.bind(null,"_detachAggregationBindingHandlers");b.prototype.unbindAggregation=function(t,e){var i=this.getMetadata().getAggregationForwarder(t);if(i&&i.forwardBinding){i.getTarget(this).unbindAggregation(i.targetAggregationName,e);return this}var n=this.mBindingInfos[t],r=this.getMetadata().getAggregation(t);if(n){if(n.binding){this._unbindAggregation(n,t)}if(n.template){if(!n.templateShareable&&n.template.destroy){n.template.destroy()}if(n.templateShareable===B){n.template._sapui_candidateForDestroy=true}}if(this._observer&&!this._bIsBeingDestroyed){this._observer.bindingChange(this,t,"remove",this.mBindingInfos[t],"aggregation")}delete this.mBindingInfos[t];if(!e){this[r._sDestructor]()}}return this};b.prototype._unbindAggregation=I.bind(null,"_unbindAggregation");b.prototype.updateAggregation=function(t,e,i){};b.prototype.refreshAggregation=function(t){};b.prototype.propagateMessages=function(t,e){g.warning("[FUTURE FATAL] ]Message for "+this+", Property "+t)};b.prototype.isTreeBinding=function(t){return false};b.prototype.updateBindings=function(t,e){};b.prototype.isBound=function(t){return!!this.getBindingInfo(t)};b.prototype.getObjectBinding=function(t){m(t);var e=this._getObjectBindingInfo(t);return e&&e.binding};b.prototype.getEventingParent=function(){return this.oParent};b.prototype.getBinding=function(t){var e=this.getBindingInfo(t);return e&&e.binding};b.prototype.getBindingPath=function(t){var e=this.getBindingInfo(t);return e&&(e.path||e.parts&&e.parts[0]&&e.parts[0].path)};b.prototype.setBindingContext=function(t,e){m(e);var i=this.oBindingContexts[e];if(i!==t||t&&t.hasChanged()){if(t===undefined){delete this.oBindingContexts[e]}else{this.oBindingContexts[e]=t}this.updateBindingContext(false,e);this.propagateProperties(e);this.fireModelContextChange()}return this};b.prototype.setElementBindingContext=function(t,e){};b.prototype.updateBindingContext=function(t,e,i){};b.prototype.getBindingContext=function(t){var e=this.getModel(t),i=this.mElementBindingContexts[t];if(i&&!e){return i}else if(i&&e&&i.getModel()===e){return i}else if(i===null){return i}else{return this._getBindingContext(t)}};b.prototype._getBindingContext=function(t){var e=this.getModel(t),i=this.oBindingContexts[t],n=this.oPropagatedProperties.oBindingContexts[t];if(i&&!e){return this.oBindingContexts[t]}else if(i&&e&&i.getModel()===e){return this.oBindingContexts[t]}else if(i===null){return i}else if(n&&e&&n.getModel()!==e){return undefined}else{return n}};b.prototype.setModel=function(t,e){p(t==null||n.isObjectA(t,"sap.ui.model.Model"),"oModel must be an instance of sap.ui.model.Model, null or undefined");p(e===undefined||typeof e==="string"&&!/^(undefined|null)?$/.test(e),"sName must be a string or omitted");if(!t&&this.oModels[e]){delete this.oModels[e];this.propagateProperties(e);this.updateBindings(false,e);this.fireModelContextChange()}else if(t&&t!==this.oModels[e]){this.oModels[e]=t;this.propagateProperties(e);this.updateBindingContext(false,e);this.updateBindings(false,e);this.fireModelContextChange()}return this};b.prototype.addPropagationListener=function(t){p(typeof t==="function","listener must be a function");this.aPropagationListeners.push(t);this.propagateProperties(false);this._callPropagationListener(t);return this};b.prototype.removePropagationListener=function(t){p(typeof t==="function","listener must be a function");var e=this.aPropagationListeners;var i=e.indexOf(t);if(i>=0){e.splice(i,1);this.propagateProperties(false)}return this};b.prototype.getPropagationListeners=function(){return this.oPropagatedProperties.aPropagationListeners.concat(this.aPropagationListeners)};b.prototype._callPropagationListener=function(t){var e;if(t){t(this)}else{e=this.getPropagationListeners();for(var i=0;i<e.length;i++){t=e[i];t(this)}}return this};b._oEmptyPropagatedProperties={oModels:{},oBindingContexts:{},aPropagationListeners:[]};function C(t,e){return!e.aAPIParentInfos||e.aAPIParentInfos[0].parent===t}b.prototype.propagateProperties=function(t){var e=this._getPropertiesToPropagate(),i=t===true,n=t===false,r=i?undefined:t,s,o,a,g=Object.assign({},this.mAggregations,this.mForwardedAggregations);P(e.oModels);for(s in g){if(this.mSkipPropagation[s]){continue}o=g[s];if(o instanceof b){if(C(this,o)){this._propagateProperties(t,o,e,i,r,n)}}else if(o instanceof Array){for(a=0;a<o.length;a++){if(o[a]instanceof b){if(C(this,o[a])){this._propagateProperties(t,o[a],e,i,r,n)}}}}}};b.prototype._propagateProperties=function(t,e,i,n,r,s){if(!i){i=this._getPropertiesToPropagate();n=t===true;s=t===false;r=n?undefined:t}P(i.oModels);if(e.oPropagatedProperties!==i){e.oPropagatedProperties=i;if(s!==true){e.updateBindings(n,r);e.updateBindingContext(false,r,n)}e.propagateProperties(t);if(s||n){e._callPropagationListener()}e.fireModelContextChange()}};b.prototype._getPropertiesToPropagate=function(){var t=u(this.oModels),e=u(this.oBindingContexts),i=this.aPropagationListeners.length===0,n=u(this.mElementBindingContexts);function r(t,e,i,n){return t?e:l({},e,i,n)}function s(t,e,i){return t?e:e.concat(i)}if(e&&t&&n&&i){return this.oPropagatedProperties}else{return{oModels:r(t,this.oPropagatedProperties.oModels,this.oModels),oBindingContexts:r(e&&n,this.oPropagatedProperties.oBindingContexts,this.oBindingContexts,this.mElementBindingContexts),aPropagationListeners:s(i,this.oPropagatedProperties.aPropagationListeners,this.aPropagationListeners)}}};b.prototype.getModel=function(t){m(t);return this.oModels[t]||this.oPropagatedProperties.oModels[t]};b.prototype.getOwnModels=function(){return this.oModels};b.prototype.hasModel=function(){return!(u(this.oModels)&&u(this.oPropagatedProperties.oModels))};b.prototype.clone=function(t,e,n){var s=true,o=true;if(n){s=!!n.cloneChildren;o=!!n.cloneBindings}if(!t){t=i.uid("clone")||h()}if(!e&&s){e=this.findAggregatedObjects(true,null,true).map(function(t){return t.getId()});e.push(this.getId())}var a=this.getMetadata(),p=a._oClass,d=this.getId()+"-"+t,l={},u,c=this.mProperties,y,m,v,P=r.escape,A,_;var I=Object.keys(c);var C;A=I.length;while(A>0){y=I[--A];u=a.getProperty(y);if(u&&!(this.isBound(y)&&o)){if(typeof c[y]==="string"){l[y]=P(c[y])}else{C=u.byValue?f(c[y]):c[y];if(C&&typeof C==="object"&&!Object.isFrozen(C)){C[r.UI5ObjectMarker]=true}l[y]=C}}}l["models"]=this.oModels;l["bindingContexts"]=this.oBindingContexts;if(s){var M=Object.assign({},this.mAggregations,this.mForwardedAggregations);for(m in M){var x=M[m];if(a.hasAggregation(m)&&!(this.isBound(m)&&o)){if(x instanceof b){l[m]=x.clone(t,e)}else if(Array.isArray(x)){l[m]=[];for(var A=0;A<x.length;A++){l[m].push(x[A].clone(t,e))}}else{l[m]=typeof x==="string"?P(x):x}}}for(m in this.mAssociations){if(!a.hasAssociation(m)){continue}var j=this.mAssociations[m];if(Array.isArray(j)){j=j.slice(0);for(var A=0;A<j.length;A++){if(e.indexOf(j[A])>=0){j[A]+="-"+t}}}else if(e.indexOf(j)>=0){j+="-"+t}l[m]=j}}v=new p(d,l);function w(i,n,r,s,o){var a=!r;var p=Object.assign({},i);if(!i.templateShareable&&i.template&&i.template.clone){p.template=i.template.clone(t,e);delete p.factory}else if(i.templateShareable===B){i.templateShareable=p.templateShareable=true;g.error("During a clone operation, a template was found that neither was marked with 'templateShareable:true' nor 'templateShareable:false'. "+"The framework won't destroy the template. This could cause errors (e.g. duplicate IDs) or memory leaks "+"(The template is used in aggregation '"+o+"' of object '"+s.getId()+"')."+"For more information, see documentation under 'Aggregation Binding'.")}delete p.binding;delete p.modelChangeHandler;delete p.dataStateChangeHandler;delete p.modelRefreshHandler;if(a){n.bindObject(p)}else if(i.factory){n.bindAggregation(r,p)}else{n.bindProperty(r,p)}}for(m in this.mEventRegistry){v.mEventRegistry[m]=this.mEventRegistry[m].slice()}if(o){for(m in this.mObjectBindingInfos){w(this.mObjectBindingInfos[m],v)}for(m in this.mBindingInfos){w(this.mBindingInfos[m],v,m,this,m)}}if(b._supportInfo){b._supportInfo.addSupportInfo(v.getId(),b._supportInfo.byId(this.getId()))}if(this._cloneMetadataContexts){this._cloneMetadataContexts(v)}if(this.mForwardedAggregations){for(m in this.mForwardedAggregations){var S=v.getMetadata().getAggregationForwarder(m);if(S){_=S.getTarget(v,true);if(S.forwardBinding&&this.isBound(m)){w(this.getBindingInfo(m),_,S.targetAggregationName,this,m)}}}}return v};b.prototype.findAggregatedObjects=function(t,e,i){var n=[];if(e&&typeof e!=="function"){e=null}function r(s){var o,a,g;if(i){for(g in s.mBindingInfos){o=s.mBindingInfos[g].template;if(o){if(!e||e(o)){n.push(o)}if(t){r(o)}}}}for(g in s.mAggregations){o=s.mAggregations[g];if(Array.isArray(o)){for(a=0;a<o.length;a++){if(!e||e(o[a])){n.push(o[a])}if(t){r(o[a])}}}else if(o instanceof b){if(!e||e(o)){n.push(o)}if(t){r(o)}}}}r(this);return n};b.prototype.onOwnerDeactivation=function(){this._bIsOwnerActive=false};b.prototype.onOwnerActivation=function(){this._bIsOwnerActive=true;this._onContextualSettingsChanged()};b.prototype.isDestroyStarted=function(){return!!this._bIsBeingDestroyed};b.prototype.isDestroyed=function(){return!!this.bIsDestroyed};b._defaultContextualSettings={};return b});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/ManagedObjectMetadata", ["./DataType","./Metadata","./Object","sap/base/Log","sap/base/assert","sap/base/config","sap/base/strings/capitalize","sap/base/strings/escapeRegExp","sap/base/util/merge","sap/base/util/isPlainObject"],function(t,e,i,r,n,s,o,a,g,u){"use strict";var l=function(t,i){e.apply(this,arguments)};var h;l.prototype=Object.create(e.prototype);l.prototype.constructor=l;var p=/(children|ies|ves|oes|ses|ches|shes|xes|s)$/i;var f={children:-3,ies:"y",ves:"f",oes:-2,ses:-2,ches:-2,shes:-2,xes:-2,s:-1};function c(t){return t.replace(p,function(t,e){var i=f[e.toLowerCase()];return typeof i==="string"?i:e.slice(0,i)})}function m(t,e){return function(){r.warning("Usage of deprecated feature: "+e);return t.apply(this,arguments)}}function d(t,e){var i=null;for(var r in e){if(Object.hasOwn(e,r)&&typeof t[r]==="undefined"){i=i||{};i[r]=e[r]}}return i}function y(t,e,r){const n=e.defaultClass;if(n){if(!i.isObjectA(n.prototype,t.type)){throw new TypeError(`The 'defaultClass' of the aggregation '${t.name}' in '${r.getName()}' is not of type '${t.type}'.`)}else if(t.altTypes?.includes("object")){throw new TypeError(`The aggregation '${t.name}' in '${r.getName()}' must not defined a 'defaultClass' together with the altType 'object'.`)}}else if(e.hasOwnProperty("defaultClass")){throw new TypeError(`The 'defaultClass' of the aggregation '${t.name}' in '${r.getName()}' is defined with a nullish value (${n}).`)}return n}var A={SPECIAL_SETTING:-1,PROPERTY:0,SINGLE_AGGREGATION:1,MULTIPLE_AGGREGATION:2,SINGLE_ASSOCIATION:3,MULTIPLE_ASSOCIATION:4,EVENT:5};l._guessSingularName=c;function _(t,e,i){i=typeof i!=="object"?{type:i}:i;this.name=e;this.type=i.type||"any";this.visibility=i.visibility||"public";this.defaultValue=i.defaultValue;this.appData=d(this,i);this._oParent=t;this._sUID="special:"+e;this._iKind=A.SPECIAL_SETTING}function v(t,e,i){i=typeof i!=="object"?{type:i}:i;this.name=e;this.type=i.type||"string";this.group=i.group||"Misc";this.defaultValue=i.defaultValue!==null?i.defaultValue:null;this.bindable=!!i.bindable;this.deprecated=!!i.deprecated||false;this.visibility=i.visibility||"public";this.byValue=i.byValue===true;this.selector=typeof i.selector==="string"?i.selector:null;this.appData=d(this,i);this._oParent=t;this._sUID=e;this._iKind=A.PROPERTY;var r=o(e);this._sMutator="set"+r;this._sGetter="get"+r;if(this.bindable){this._sBind="bind"+r;this._sUnbind="unbind"+r}else{this._sBind=this._sUnbind=undefined}this._oType=null}v.prototype.generate=function(t){var e=this,i=e.name;t(e._sGetter,function(){return this.getProperty(i)});t(e._sMutator,function(t){this.setProperty(i,t);return this},e);if(e.bindable){t(e._sBind,function(t,e,r){this.bindProperty(i,t,e,r);return this},e);t(e._sUnbind,function(t){this.unbindProperty(i,t);return this})}};v.prototype.getType=function(){if(!this._oType){this._oType=t.getType(this.type)}return this._oType};v.prototype.getDefaultValue=function(){var e=this.defaultValue,i;if(e===null){i=this.getType();if(i instanceof t){e=i.getDefaultValue()}}return e};v.prototype.get=function(t){if(this.visibility!=="public"){return t.getProperty(this.name)}return t[this._sGetter]()};v.prototype.set=function(t,e){if(this.visibility!=="public"){return t.setProperty(this.name,e)}return t[this._sMutator](e)};function P(t,e,i){i=typeof i!=="object"?{type:i}:i;this.name=e;this.type=i.type||"sap.ui.core.Control";this.altTypes=Array.isArray(i.altTypes)?i.altTypes:undefined;this.defaultClass=y(this,i,t)||null;this.multiple=typeof i.multiple==="boolean"?i.multiple:true;this.singularName=this.multiple?i.singularName||c(e):undefined;this.bindable=!!i.bindable;this.deprecated=i.deprecated||false;this.visibility=i.visibility||"public";this.selector=i.selector||null;this.forwarding=i.forwarding;this._doesNotRequireFactory=!!i._doesNotRequireFactory;this.appData=d(this,i);this._oParent=t;this._sUID="aggregation:"+e;this._iKind=this.multiple?A.MULTIPLE_AGGREGATION:A.SINGLE_AGGREGATION;this._oForwarder=this.forwarding?new b(this):undefined;var r=o(e);this._sGetter="get"+r;if(this.multiple){var n=o(this.singularName);this._sMutator="add"+n;this._sInsertMutator="insert"+n;this._sRemoveMutator="remove"+n;this._sRemoveAllMutator="removeAll"+r;this._sIndexGetter="indexOf"+n;this._sUpdater="update"+r;this._sRefresher="refresh"+r}else{this._sMutator="set"+r;this._sInsertMutator=this._sRemoveMutator=this._sRemoveAllMutator=this._sIndexGetter=this._sUpdater=this._sRefresher=undefined}this._sDestructor="destroy"+r;if(this.bindable){this._sBind="bind"+r;this._sUnbind="unbind"+r}else{this._sBind=this._sUnbind=undefined}}P.prototype.generate=function(t){var e=this,i=e.name;if(!e.multiple){t(e._sGetter,function(){return this.getAggregation(i)});t(e._sMutator,function(t){this.setAggregation(i,t);return this},e)}else{t(e._sGetter,function(){return this.getAggregation(i,[])});t(e._sMutator,function(t){this.addAggregation(i,t);return this},e);t(e._sInsertMutator,function(t,e){this.insertAggregation(i,t,e);return this},e);t(e._sRemoveMutator,function(t){return this.removeAggregation(i,t)});t(e._sRemoveAllMutator,function(){return this.removeAllAggregation(i)});t(e._sIndexGetter,function(t){return this.indexOfAggregation(i,t)})}t(e._sDestructor,function(){this.destroyAggregation(i);return this});if(e.bindable){t(e._sBind,function(t,e,r,n){this.bindAggregation(i,t,e,r,n);return this},e);t(e._sUnbind,function(t){this.unbindAggregation(i,t);return this})}};P.prototype.getType=function(){if(!this._oType){this._oType=t.getType(this.type)}return this._oType};P.prototype.get=function(t){if(this.visibility!=="public"){return t.getAggregation(this.name,this.multiple?[]:undefined)}return t[this._sGetter]()};P.prototype.set=function(t,e){if(this.visibility!=="public"){return t.setAggregation(this.name,e)}return t[this._sMutator](e)};P.prototype.add=function(t,e){if(this.visibility!=="public"){return t.addAggregation(this.name,e)}return t[this._sMutator](e)};P.prototype.insert=function(t,e,i){if(this.visibility!=="public"){return t.insertAggregation(this.name,e,i)}return t[this._sInsertMutator](e,i)};P.prototype.remove=function(t,e){if(this.visibility!=="public"){return t.removeAggregation(this.name,e)}return t[this._sRemoveMutator](e)};P.prototype.removeAll=function(t){if(this.visibility!=="public"){return t.removeAllAggregation(this.name)}return t[this._sRemoveAllMutator]()};P.prototype.indexOf=function(t,e){if(this.visibility!=="public"){return t.indexOfAggregation(this.name,e)}return t[this._sIndexGetter](e)};P.prototype.destroy=function(t){return t[this._sDestructor]()};P.prototype.update=function(t,e,i){if(t[this._sUpdater]){t[this._sUpdater](e,i)}else{t.updateAggregation(this.name,e,i)}};P.prototype.refresh=function(t,e){if(t[this._sRefresher]){t[this._sRefresher](e)}else{this.update(t,e)}};function b(t){var e=t.forwarding;this.aggregation=t;this.targetAggregationName=e.aggregation;this.forwardBinding=e.forwardBinding;this.targetAggregationInfo=null;if(e.getter){if(typeof e.getter==="function"){this._getTarget=e.getter}else{this._getTarget=function(t){return function(){return this[t]()}}(e.getter)}}else if(e.idSuffix){this._getTarget=function(t){return function(){h=h||sap.ui.require("sap/ui/core/Element");return h&&h.getElementById(this.getId()+t)}}(e.idSuffix)}else{throw new Error("Either getter or idSuffix must be given for forwarding the aggregation "+t.name+" to the aggregation "+e.aggregation+" in "+t._oParent.getName())}}b.prototype._getTargetAggregationInfo=function(t){var e=this.targetAggregationInfo;if(!e&&t){e=this.targetAggregationInfo=t.getMetadata().getAggregation(this.targetAggregationName);if(!e){throw new Error("Target aggregation "+this.targetAggregationName+" not found on "+t)}if(this.aggregation.multiple&&!e.multiple){throw new Error("Aggregation "+this.aggregation+" (multiple: "+this.aggregation.multiple+") cannot be forwarded to aggregation "+this.targetAggregationName+" (multiple: "+e.multiple+")")}if(!this.aggregation.multiple&&e.multiple&&this.aggregation.forwarding.forwardBinding){throw new Error("Aggregation "+this.aggregation+" (multiple: "+this.aggregation.multiple+") cannot be forwarded to aggregation "+this.targetAggregationName+" (multiple: "+e.multiple+") with 'forwardBinding' set to 'true'")}}return e};b.prototype.getTarget=function(t,e){var i=this._getTarget.call(t);this._getTargetAggregationInfo(i);if(i){t.mForwardedAggregations=t.mForwardedAggregations||{};if(t.mForwardedAggregations[this.aggregation.name]===undefined||e){var r=i.mAggregations[this.targetAggregationInfo.name];if(r&&!e&&!this.aggregation.forwarding.forwardBinding&&!(Array.isArray(r)&&r.length===0)){throw new Error("There is already content in aggregation "+this.targetAggregationInfo.name+" of "+i+" to which forwarding is being set up now.")}else{var n=i.mAggregations[this.targetAggregationInfo.name]||(this.targetAggregationInfo.multiple?[]:null);t.mForwardedAggregations[this.aggregation.name]=i.mAggregations[this.targetAggregationInfo.name]=n}}}return i};b.prototype.get=function(t){var e=this.getTarget(t);if(e){var i=this.targetAggregationInfo.get(e);if(!this.aggregation.multiple&&this.targetAggregationInfo.multiple){i=i[0]}return i}else{return this.aggregation.multiple?[]:null}};b.prototype.indexOf=function(t,e){var i=this.getTarget(t);return this.targetAggregationInfo.indexOf(i,e)};b.prototype.set=function(t,e){var i=this.getTarget(t);t.mForwardedAggregations[this.aggregation.name]=e;if(this.targetAggregationInfo.multiple){var r=this.targetAggregationInfo.get(i);if(r&&r[0]){if(r[0]===e){return t}this.targetAggregationInfo.removeAll(i)}l.addAPIParentInfoBegin(e,t,this.aggregation.name);this.targetAggregationInfo.add(i,e)}else{l.addAPIParentInfoBegin(e,t,this.aggregation.name);this.targetAggregationInfo.set(i,e)}l.addAPIParentInfoEnd(e);return t};b.prototype.add=function(t,e){var i=this.getTarget(t);l.addAPIParentInfoBegin(e,t,this.aggregation.name);this.targetAggregationInfo.add(i,e);l.addAPIParentInfoEnd(e);return t};b.prototype.insert=function(t,e,i){var r=this.getTarget(t);l.addAPIParentInfoBegin(e,t,this.aggregation.name);this.targetAggregationInfo.insert(r,e,i);l.addAPIParentInfoEnd(e);return t};l.addAPIParentInfoBegin=function(t,e,i){if(!t){return}var r={parent:e,aggregationName:i};if(t.aAPIParentInfos){if(t.aAPIParentInfos.forwardingCounter){t.aAPIParentInfos.forwardingCounter++}else{delete t.aAPIParentInfos}}if(!t.aAPIParentInfos){t.aAPIParentInfos=[r];t.aAPIParentInfos.forwardingCounter=1}else{t.aAPIParentInfos.push(r)}};l.addAPIParentInfoEnd=function(t){t&&t.aAPIParentInfos&&t.aAPIParentInfos.forwardingCounter--};b.prototype.remove=function(t,e){var i=this.getTarget(t);var r=this.targetAggregationInfo.remove(i,e);if(r){r.aAPIParentInfos&&r.aAPIParentInfos.pop()}return r};b.prototype.removeAll=function(t){var e=this.getTarget(t);delete t.mForwardedAggregations[this.aggregation.name];var i=this.targetAggregationInfo.removeAll(e);for(var r=0;r<i.length;r++){if(i[r].aAPIParentInfos){i[r].aAPIParentInfos.pop()}}return i};b.prototype.destroy=function(t){var e=this.getTarget(t);delete t.mForwardedAggregations[this.aggregation.name];if(e){this.targetAggregationInfo.destroy(e)}return t};function I(t,e,i){i=typeof i!=="object"?{type:i}:i;this.name=e;this.type=i.type||"sap.ui.core.Control";this.multiple=i.multiple||false;this.singularName=this.multiple?i.singularName||c(e):undefined;this.deprecated=i.deprecated||false;this.visibility=i.visibility||"public";this.appData=d(this,i);this._oParent=t;this._sUID="association:"+e;this._iKind=this.multiple?A.MULTIPLE_ASSOCIATION:A.SINGLE_ASSOCIATION;var r=o(e);this._sGetter="get"+r;if(this.multiple){var n=o(this.singularName);this._sMutator="add"+n;this._sRemoveMutator="remove"+n;this._sRemoveAllMutator="removeAll"+r}else{this._sMutator="set"+r;this._sRemoveMutator=this._sRemoveAllMutator=undefined}}I.prototype.generate=function(t){var e=this,i=e.name;if(!e.multiple){t(e._sGetter,function(){return this.getAssociation(i)});t(e._sMutator,function(t){this.setAssociation(i,t);return this},e)}else{t(e._sGetter,function(){return this.getAssociation(i,[])});t(e._sMutator,function(t){this.addAssociation(i,t);return this},e);t(e._sRemoveMutator,function(t){return this.removeAssociation(i,t)});t(e._sRemoveAllMutator,function(){return this.removeAllAssociation(i)});if(i!==e.singularName){t("removeAll"+o(e.singularName),function(){r.warning("Usage of deprecated method "+e._oParent.getName()+".prototype."+"removeAll"+o(e.singularName)+","+" use method "+e._sRemoveAllMutator+" (plural) instead.");return this[e._sRemoveAllMutator]()})}}};I.prototype.getType=function(){if(!this._oType){this._oType=t.getType(this.type)}return this._oType};I.prototype.get=function(t){if(this.visibility!=="public"){return t.getAssociation(this.name,this.multiple?[]:undefined)}return t[this._sGetter]()};I.prototype.set=function(t,e){if(this.visibility!=="public"){return t.setAssociation(this.name,e)}return t[this._sMutator](e)};I.prototype.add=function(t,e){if(this.visibility!=="public"){return t.addAssociation(this.name,e)}return t[this._sMutator](e)};I.prototype.remove=function(t,e){if(this.visibility!=="public"){return t.removeAssociation(this.name,e)}return t[this._sRemoveMutator](e)};I.prototype.removeAll=function(t){if(this.visibility!=="public"){return t.removeAllAssociation(this.name)}return t[this._sRemoveAllMutator]()};function T(t,e,i){this.name=e;this.allowPreventDefault=i.allowPreventDefault||false;this.deprecated=i.deprecated||false;this.visibility="public";this.allowPreventDefault=!!i.allowPreventDefault;this.enableEventBubbling=!!i.enableEventBubbling;this.appData=d(this,i);this._oParent=t;this._sUID="event:"+e;this._iKind=A.EVENT;var r=o(e);this._sMutator="attach"+r;this._sDetachMutator="detach"+r;this._sTrigger="fire"+r}T.prototype.generate=function(t){var e=this,i=e.name,r=e.allowPreventDefault,n=e.enableEventBubbling;t(e._sMutator,function(t,e,r){this.attachEvent(i,t,e,r);return this},e);t(e._sDetachMutator,function(t,e){this.detachEvent(i,t,e);return this});t(e._sTrigger,function(t){return this.fireEvent(i,t,r,n)})};T.prototype.attach=function(t,e,i,r){return t[this._sMutator](e,i,r)};T.prototype.detach=function(t,e,i){return t[this._sDetachMutator](e,i)};T.prototype.fire=function(t,e){return t[this._sTrigger](e,this.allowPreventDefault,this.enableEventBubbling)};l.prototype.metaFactorySpecialSetting=_;l.prototype.metaFactoryProperty=v;l.prototype.metaFactoryAggregation=P;l.prototype.metaFactoryAssociation=I;l.prototype.metaFactoryEvent=T;l.prototype.applySettings=function(t){var i=this,r=t.metadata;e.prototype.applySettings.call(this,t);function n(t,e){var r={},n;if(t){for(n in t){if(Object.hasOwn(t,n)){r[n]=new e(i,n,t[n])}}}return r}function s(t,e){var i={},r;for(r in t){if(e===(t[r].visibility==="public")){i[r]=t[r]}}return i}var o=/([a-z][^.]*(?:\.[a-z][^.]*)*)\./;function a(t){var e=o.exec(t);return e&&e[1]||""}this._sLibraryName=r.library||a(this.getName());this._mSpecialSettings=n(r.specialSettings,this.metaFactorySpecialSetting);var g=n(r.properties,this.metaFactoryProperty);this._mProperties=s(g,true);this._mPrivateProperties=s(g,false);var u=n(r.aggregations,this.metaFactoryAggregation);this._mAggregations=s(u,true);this._mPrivateAggregations=s(u,false);this._sDefaultAggregation=r.defaultAggregation||null;this._sDefaultProperty=r.defaultProperty||null;var l=n(r.associations,this.metaFactoryAssociation);this._mAssociations=s(l,true);this._mPrivateAssociations=s(l,false);this._mEvents=n(r.events,this.metaFactoryEvent);this._oDesignTime=t.metadata["designtime"]||t.metadata["designTime"];this._sProvider=t.metadata["provider"];if(t.metadata.__version>1){this.generateAccessors()}};l.prototype.afterApplySettings=function(){e.prototype.afterApplySettings.call(this);var t=this.getParent();if(t instanceof l){this._mAllEvents=Object.assign({},t._mAllEvents,this._mEvents);this._mAllPrivateProperties=Object.assign({},t._mAllPrivateProperties,this._mPrivateProperties);this._mAllProperties=Object.assign({},t._mAllProperties,this._mProperties);this._mAllPrivateAggregations=Object.assign({},t._mAllPrivateAggregations,this._mPrivateAggregations);this._mAllAggregations=Object.assign({},t._mAllAggregations,this._mAggregations);this._mAllPrivateAssociations=Object.assign({},t._mAllPrivateAssociations,this._mPrivateAssociations);this._mAllAssociations=Object.assign({},t._mAllAssociations,this._mAssociations);this._sDefaultAggregation=this._sDefaultAggregation||t._sDefaultAggregation;this._sDefaultProperty=this._sDefaultProperty||t._sDefaultProperty;this._mAllSpecialSettings=Object.assign({},t._mAllSpecialSettings,this._mSpecialSettings);this._sProvider=this._sProvider||t._sProvider}else{this._mAllEvents=this._mEvents;this._mAllPrivateProperties=this._mPrivateProperties;this._mAllProperties=this._mProperties;this._mAllPrivateAggregations=this._mPrivateAggregations;this._mAllAggregations=this._mAggregations;this._mAllPrivateAssociations=this._mPrivateAssociations;this._mAllAssociations=this._mAssociations;this._mAllSpecialSettings=this._mSpecialSettings}};l.Kind=A;l.prototype.getLibraryName=function(){return this._sLibraryName};l.prototype.addProperty=function(t,e){var i=this._mProperties[t]=new v(this,t,e);if(!this._mAllProperties[t]){this._mAllProperties[t]=i}if(this._fnPropertyBagFactory){this._fnPropertyBagFactory.prototype[t]=i.getDefaultValue()}};l.prototype.hasProperty=function(t){return!!this._mAllProperties[t]};l.prototype.getProperty=function(t){var e=this._mAllProperties[t];return typeof e==="object"?e:undefined};l.prototype.getProperties=function(){return this._mProperties};l.prototype.getAllProperties=function(){return this._mAllProperties};l.prototype.getAllPrivateProperties=function(){return this._mAllPrivateProperties};l.prototype.getManagedProperty=function(t){t=t||this._sDefaultProperty;var e=t?this._mAllProperties[t]||this._mAllPrivateProperties[t]:undefined;return typeof e==="object"?e:undefined};l.prototype.getDefaultPropertyName=function(){return this._sDefaultProperty};l.prototype.getDefaultProperty=function(){return this.getProperty(this.getDefaultPropertyName())};l.prototype.hasAggregation=function(t){return!!this._mAllAggregations[t]};l.prototype.getAggregation=function(t){t=t||this._sDefaultAggregation;var e=t?this._mAllAggregations[t]:undefined;return typeof e==="object"?e:undefined};l.prototype.getAggregations=function(){return this._mAggregations};l.prototype.getAllAggregations=function(){return this._mAllAggregations};l.prototype.getAllPrivateAggregations=function(){return this._mAllPrivateAggregations};l.prototype.getManagedAggregation=function(t){t=t||this._sDefaultAggregation;var e=t?this._mAllAggregations[t]||this._mAllPrivateAggregations[t]:undefined;return typeof e==="object"?e:undefined};l.prototype.getDefaultAggregationName=function(){return this._sDefaultAggregation};l.prototype.getDefaultAggregation=function(){return this.getAggregation()};l.prototype.forwardAggregation=function(t,e){var i=this.getAggregation(t);if(!i){throw new Error("aggregation "+t+" does not exist")}if(!e||!e.aggregation||!(e.idSuffix||e.getter)||e.idSuffix&&e.getter){throw new Error("an 'mOptions' object with 'aggregation' property and either 'idSuffix' or 'getter' property (but not both) must be given"+" but does not exist")}if(i._oParent===this){i.forwarding=e;i._oForwarder=new b(i)}else{i=new this.metaFactoryAggregation(this,t,{type:i.type,altTypes:i.altTypes,multiple:i.multiple,singularName:i.singularName,bindable:i.bindable,deprecated:i.deprecated,visibility:i.visibility,selector:i.selector,forwarding:e});this._mAggregations[t]=this._mAllAggregations[t]=i}};l.prototype.getAggregationForwarder=function(t){var e=this._mAllAggregations[t];return e?e._oForwarder:undefined};l.prototype.getDefaultPropertyName=function(){return this._sDefaultProperty};l.prototype.getDefaultProperty=function(){return this.getProperty(this.getDefaultPropertyName())};l.prototype.getPropertyLikeSetting=function(t){var e=this._mAllProperties[t];if(typeof e==="object"){return e}e=this._mAllAggregations[t];return typeof e==="object"&&e.altTypes&&e.altTypes.length>0?e:undefined};l.prototype.hasAssociation=function(t){return!!this._mAllAssociations[t]};l.prototype.getAssociation=function(t){var e=this._mAllAssociations[t];return typeof e==="object"?e:undefined};l.prototype.getAssociations=function(){return this._mAssociations};l.prototype.getAllAssociations=function(){return this._mAllAssociations};l.prototype.getAllPrivateAssociations=function(){return this._mAllPrivateAssociations};l.prototype.getManagedAssociation=function(t){var e=this._mAllAssociations[t]||this._mAllPrivateAssociations[t];return typeof e==="object"?e:undefined};l.prototype.hasEvent=function(t){return!!this._mAllEvents[t]};l.prototype.getEvent=function(t){var e=this._mAllEvents[t];return typeof e==="object"?e:undefined};l.prototype.getEvents=function(){return this._mEvents};l.prototype.getAllEvents=function(){return this._mAllEvents};l.prototype.addSpecialSetting=function(t,e){var i=new _(this,t,e);this._mSpecialSettings[t]=i;if(!this._mAllSpecialSettings[t]){this._mAllSpecialSettings[t]=i}};l.prototype.hasSpecialSetting=function(t){return!!this._mAllSpecialSettings[t]};l.prototype.getPropertyDefaults=function(){var t=this._mDefaults,e;if(t){return t}if(this.getParent()instanceof l){t=Object.assign({},this.getParent().getPropertyDefaults())}else{t={}}for(e in this._mProperties){t[e]=this._mProperties[e].getDefaultValue()}for(e in this._mPrivateProperties){t[e]=this._mPrivateProperties[e].getDefaultValue()}this._mDefaults=t;return t};l.prototype.createPropertyBag=function(){if(!this._fnPropertyBagFactory){this._fnPropertyBagFactory=function t(){};this._fnPropertyBagFactory.prototype=this.getPropertyDefaults()}return new this._fnPropertyBagFactory};l.prototype.getJSONKeys=function(){if(this._mJSONKeys){return this._mJSONKeys}var t={},e={};function i(i){var r,n,s;for(r in i){n=i[r];s=t[r];if(!s||n._iKind<s._iKind){t[r]=e[r]=n}e[n._sUID]=n}}i(this._mAllSpecialSettings);i(this.getAllProperties());i(this.getAllAggregations());i(this.getAllAssociations());i(this.getAllEvents());this._mJSONKeys=e;this._mAllSettings=t;return this._mJSONKeys};l.prototype.getAllSettings=function(){if(!this._mAllSettings){this.getJSONKeys()}return this._mAllSettings};l.prototype.removeUnknownSettings=function(t){n(t==null||typeof t==="object","mSettings must be null or undefined or an object");if(t==null){return t}var e=this.getJSONKeys(),i={},r;for(r in t){if(Object.hasOwn(e,r)){i[r]=t[r]}}return i};l.prototype.generateAccessors=function(){var t=this.getClass().prototype,e=this.getName()+".",i=this._aPublicMethods,r;function n(r,n,s){if(!t[r]){t[r]=s&&s.deprecated?m(n,e+s.name):n}i.push(r)}for(r in this._mProperties){this._mProperties[r].generate(n)}for(r in this._mAggregations){this._mAggregations[r].generate(n)}for(r in this._mAssociations){this._mAssociations[r].generate(n)}for(r in this._mEvents){this._mEvents[r].generate(n)}};function w(t){return new Promise(function(e,i){sap.ui.require(["sap/ui/core/Lib"],function(i){var r=t.getLibraryName(),n=i.getPreloadMode(),s=i.all()[r];if(s&&s.designtime){var o;if(n==="async"||n==="sync"){o=sap.ui.loader._.loadJSResourceAsync(s.designtime.replace(/\.designtime$/,"-preload.designtime.js"),true)}else{o=Promise.resolve()}e(new Promise(function(t,e){o.then(function(){sap.ui.require([s.designtime],function(e){t(e)},e)})}))}e(null)},i)})}function D(t){if(u(t._oDesignTime)||!t._oDesignTime){return Promise.resolve(t._oDesignTime||{})}return new Promise(function(e,i){var r;if(typeof t._oDesignTime==="string"){r=t._oDesignTime}else{r=t.getName().replace(/\./g,"/")+".designtime"}w(t).then(function(n){sap.ui.require([r],function(i){i.designtimeModule=r;t._oDesignTime=i;i._oLib=n;e(i)},i)})})}var S={};l.setDesignTimeDefaultMapping=function(t){S=t};function E(t){var e=i.isObjectA(t,"sap.ui.base.ManagedObject")&&typeof t.data==="function"&&t.data("sap-ui-custom-settings")&&t.data("sap-ui-custom-settings")["sap.ui.dt"]&&t.data("sap-ui-custom-settings")["sap.ui.dt"].designtime;if(typeof e==="string"){e=S[e]||e;return new Promise(function(i,r){sap.ui.require([e],function(e){if(typeof e==="function"){i(e(t))}else{i(e)}},r)})}else{return Promise.resolve({})}}function N(t,e){var i=t;if("default"in t){i=g({},t.default,e!=="default"&&t[e]||null)}return i}function M(t,e,i){return g({},N(e,i),{templates:{create:null}},N(t,i),{designtimeModule:t.designtimeModule||undefined,_oLib:t._oLib})}l.prototype.loadDesignTime=function(t,e){e=typeof e==="string"&&e||"default";var i=E(t);if(!this._oDesignTimePromise){var r;var n=this.getParent();if(n instanceof l){r=n.loadDesignTime(null,e)}else{r=Promise.resolve({})}this._oDesignTimePromise=D(this).then(function(t){return r.then(function(i){return M(t,i,e)})})}return Promise.all([i,this._oDesignTimePromise]).then(function(t){var i=t[0],r=t[1];return g({},r,N(i||{},e))})};var O={},j;function R(t){n(!/[0-9]+$/.exec(t),"AutoId Prefixes must not end with numbers");t=l.getUIDPrefix()+t;var e=O[t]||0;O[t]=e+1;return t+e}l.uid=R;l.getUIDPrefix=function(){if(j===undefined){j=s.get({name:"sapUiUidPrefix",type:s.Type.String,defaultValue:"__",freeze:true})}return j};l.prototype.uid=function(){var t=this._sUIDToken;if(typeof t!=="string"){t=this.getName();t=t.slice(t.lastIndexOf(".")+1);t=t.replace(/([a-z])([A-Z])/g,"$1 $2").split(" ").slice(-1)[0];t=this._sUIDToken=t.replace(/([^A-Za-z0-9-_.:])|([0-9]+$)/g,"").toLowerCase()}return R(t)};var G;l.isGeneratedId=function(t){G=G||new RegExp("(^|-{1,3})"+a(l.getUIDPrefix()));return G.test(t)};return l},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/base/ManagedObjectRegistry", ["sap/ui/base/ManagedObject","sap/base/Log","sap/base/assert"],function(e,t,n){"use strict";const i={create(i){const r=Object.create(null);let o=0;i??={};const a={init(n){if(typeof n!=="function"||!(n.prototype instanceof e)){throw new TypeError("ManagedObjectRegistry mixin can only be applied to subclasses of sap.ui.base.ManagedObject")}var s=i.onDuplicate||function(e,i,r){var o=n.getMetadata().getStereotype();t.error('adding object "'+o+"\" with duplicate id '"+e+"'");throw new Error('Error: adding object "'+o+"\" with duplicate id '"+e+"'")};var c=i.onDeregister||null;n.prototype.register=function e(){var t=this.getId(),n=r[t];if(n&&n!==this){s(t,n,this);o--}r[t]=this;o++};n.prototype.deregister=function e(){var t=this.getId();if(r[t]){if(c){c(t)}delete r[t];o--}};delete a.init;Object.freeze(a)},get size(){return o},all:function(){var e=Object.create(null);return Object.assign(e,r)},get:function(e){n(e==null||typeof e==="string","id must be a string when defined");return e==null?undefined:r[e]},forEach:function(e,t){if(typeof e!=="function"){throw new TypeError(e+" is not a function")}if(t!=null){e=e.bind(t)}for(var n in r){e(r[n],n)}},filter:function(e,t){if(typeof e!=="function"){throw new TypeError(e+" is not a function")}if(t!=null){e=e.bind(t)}var n=[],i;for(i in r){if(e(r[i],i)){n.push(r[i])}}return n}};return a},apply(e,t){const n=i.create(t);n.init(e);e.registry=n}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Element", ["../base/DataType","../base/Object","../base/ManagedObject","./ElementMetadata","../Device","sap/ui/performance/trace/Interaction","sap/base/Log","sap/base/assert","sap/ui/thirdparty/jquery","sap/ui/events/F6Navigation","sap/ui/util/_enforceNoReturnValue","./RenderManager","./Configuration","./EnabledPropagator","./ElementRegistry","./Theming","sap/ui/core/util/_LocalizationHelper"],function(e,t,r,i,n,o,a,s,jQuery,u,l,p,d,f,g,h,c){"use strict";var y=r.extend("sap.ui.core.Element",{metadata:{stereotype:"element",abstract:true,publicMethods:["getId","getMetadata","getTooltip_AsString","getTooltip_Text","getModel","setModel","hasModel","bindElement","unbindElement","getElementBinding","prop","getLayoutData","setLayoutData"],library:"sap.ui.core",aggregations:{tooltip:{type:"sap.ui.core.TooltipBase",altTypes:["string"],multiple:false},customData:{type:"sap.ui.core.CustomData",multiple:true,singularName:"customData"},layoutData:{type:"sap.ui.core.LayoutData",multiple:false,singularName:"layoutData"},dependents:{type:"sap.ui.core.Element",multiple:true},dragDropConfig:{type:"sap.ui.core.dnd.DragDropBase",multiple:true,singularName:"dragDropConfig"}}},constructor:function(e,t){r.apply(this,arguments);this._iRenderingDelegateCount=0},renderer:null},i);g.init(y);y.defineClass=function(e,r,n){return t.defineClass(e,r,n||i)};y.prototype.getInterface=function(){return this};y.prototype._handleEvent=function(e){var t=this,r="on"+e.type;function i(i){var n,o,a;if(i&&(o=i.length)>0){i=o===1?i:i.slice();for(n=0;n<o;n++){if(e.isImmediateHandlerPropagationStopped()){return}a=i[n].oDelegate;if(a[r]){a[r].call(i[n].vThis===true?t:i[n].vThis||a,e)}}}}i(this.aBeforeDelegates);if(e.isImmediateHandlerPropagationStopped()){return}if(this[r]){if(e._bNoReturnValue){l(this[r](e),{name:r,component:this.getId()})}else{this[r](e)}}i(this.aDelegates)};y.prototype.init=function(){return undefined};y.prototype.exit=function(){return undefined};y.create=r.create;y.prototype.toString=function(){return"Element "+this.getMetadata().getName()+"#"+this.sId};y.prototype.getDomRef=function(e){return document.getElementById(e?this.getId()+"-"+e:this.getId())};y.prototype.$=function(e){return jQuery(this.getDomRef(e))};y.prototype.isActive=function(){return this.oParent&&this.oParent.isActive()};y.prototype.prop=function(e,t){var r=this.getMetadata().getAllSettings()[e];if(r){if(arguments.length==1){return this[r._sGetter]()}else{this[r._sMutator](t);return this}}};y.prototype.setProperty=function(e,t,i){if(e!="enabled"||i){return r.prototype.setProperty.apply(this,arguments)}var n=this.mProperties.enabled;r.prototype.setProperty.apply(this,arguments);if(n!=this.mProperties.enabled){f.updateDescendants(this)}return this};y.prototype.insertDependent=function(e,t){this.insertAggregation("dependents",e,t,true);return this};y.prototype.addDependent=function(e){this.addAggregation("dependents",e,true);return this};y.prototype.removeDependent=function(e){return this.removeAggregation("dependents",e,true)};y.prototype.removeAllDependents=function(){return this.removeAllAggregation("dependents",true)};y.prototype.destroyDependents=function(){this.destroyAggregation("dependents",true);return this};y.prototype.rerender=function(){if(this.oParent){this.oParent.rerender()}};y.prototype.getUIArea=function(){return this.oParent?this.oParent.getUIArea():null};y.prototype.destroy=function(e){if(this.bIsDestroyed){return}var t=!this.getParent();y._updateFocusInfo(this);r.prototype.destroy.call(this,e);this.data=E;var i=this.getDomRef();if(!i){return}var n=e==="KeepDom";if(e===true||!n&&t||this.isA("sap.ui.core.PopupInterface")||p.isPreservedContent(i)){jQuery(i).remove()}else{i.removeAttribute("data-sap-ui-preserve");if(!n){i.id="sap-ui-destroyed-"+this.getId();for(var o=0,a=i.querySelectorAll('[id^="'+this.getId()+'-"]');o<a.length;o++){a[o].id="sap-ui-destroyed-"+a[o].id}}}};y.prototype.fireEvent=function(e,t,i,n){if(this.hasListeners(e)){o.notifyStepStart(e,this)}if(typeof t==="boolean"){n=i;i=t;t=null}t=t||{};t.id=t.id||this.getId();if(y._interceptEvent){y._interceptEvent(e,this,t)}return r.prototype.fireEvent.call(this,e,t,i,n)};y._interceptEvent=undefined;function m(e,t,r){if(t.canSkipRendering||!(t.onAfterRendering||t.onBeforeRendering)){return}e._iRenderingDelegateCount+=r||-1;if(e.bOutput===true&&e._iRenderingDelegateCount==r){p.canSkipRendering(e,1)}}y.prototype.hasRenderingDelegate=function(){return Boolean(this._iRenderingDelegateCount)};y.prototype.addDelegate=function(e,t,r,i){s(e,"oDelegate must be not null or undefined");if(!e){return this}this.removeDelegate(e);if(typeof t==="object"){i=r;r=t;t=false}if(typeof r==="boolean"){i=r;r=undefined}(t?this.aBeforeDelegates:this.aDelegates).push({oDelegate:e,bClone:!!i,vThis:r===this?true:r});m(this,e,1);return this};y.prototype.removeDelegate=function(e){var t;for(t=0;t<this.aDelegates.length;t++){if(this.aDelegates[t].oDelegate==e){this.aDelegates.splice(t,1);m(this,e,0);t--}}for(t=0;t<this.aBeforeDelegates.length;t++){if(this.aBeforeDelegates[t].oDelegate==e){this.aBeforeDelegates.splice(t,1);m(this,e,0);t--}}return this};y.prototype.addEventDelegate=function(e,t){return this.addDelegate(e,false,t,true)};y.prototype.removeEventDelegate=function(e){return this.removeDelegate(e)};y.prototype.getFocusDomRef=function(){return this.getDomRef()||null};y.prototype.isFocusable=function(){var e=this.getFocusDomRef();if(!e){return false}var t=e;var r=t.getBoundingClientRect();while(r.x<0||r.x>window.innerWidth||r.y<0||r.y>window.innerHeight){if(t.assignedSlot){t=t.assignedSlot}if(t.parentElement){t=t.parentElement}else if(t.parentNode&&t.parentNode.nodeType===Node.DOCUMENT_FRAGMENT_NODE){t=t.parentNode.host}else{break}r=t.getBoundingClientRect()}var i=document.elementsFromPoint(r.x,r.y);var n=i.findIndex(function(t){return t.contains(e)});var o=i.findIndex(function(e){return e.classList.contains("sapUiBLy")||e.classList.contains("sapUiBlockLayer")});if(o!==-1&&n>o){return false}return jQuery(e).is(":sapFocusable")};function D(e){var t,r=[];t=e.parentNode;while(t){r.push({node:t,scrollLeft:t.scrollLeft,scrollTop:t.scrollTop});t=t.parentNode}return r}function v(e){e.forEach(function(e){var t=e.node;if(t.scrollLeft!==e.scrollLeft){t.scrollLeft=e.scrollLeft}if(t.scrollTop!==e.scrollTop){t.scrollTop=e.scrollTop}})}y.prototype.focus=function(e){var t=this.getFocusDomRef(),r=[];e=e||{};if(t){if(n.browser.safari){if(e.preventScroll===true){r=D(t)}t.focus();if(r.length>0){setTimeout(v.bind(null,r),0)}}else{t.focus(e)}}};y.prototype.getFocusInfo=function(){return{id:this.getId()}};y.prototype.applyFocusInfo=function(e){this.focus(e);return this};y.prototype._refreshTooltipBaseDelegate=function(e){var r=this.getTooltip();if(t.isObjectA(r,"sap.ui.core.TooltipBase")){this.removeDelegate(r)}if(t.isObjectA(e,"sap.ui.core.TooltipBase")){e._currentControl=this;this.addDelegate(e)}};y.prototype.setTooltip=function(e){this._refreshTooltipBaseDelegate(e);this.setAggregation("tooltip",e);return this};y.prototype.getTooltip=function(){return this.getAggregation("tooltip")};y.runWithPreprocessors=r.runWithPreprocessors;y.prototype.getTooltip_AsString=function(){var e=this.getTooltip();if(typeof e==="string"||e instanceof String){return e}return undefined};y.prototype.getTooltip_Text=function(){var e=this.getTooltip();if(e&&typeof e.getText==="function"){return e.getText()}return e};var b=y.extend("sap.ui.core.CustomData",{metadata:{library:"sap.ui.core",properties:{key:{type:"string",group:"Data",defaultValue:null},value:{type:"any",group:"Data",defaultValue:null},writeToDom:{type:"boolean",group:"Data",defaultValue:false}},designtime:"sap/ui/core/designtime/CustomData.designtime"}});b.prototype.setValue=function(e){this.setProperty("value",e,true);var t=this.getParent();if(t&&t.getDomRef()){var r=this._checkWriteToDom(t);if(r){t.$().attr(r.key,r.value)}}return this};b.prototype._checkWriteToDom=function(t){if(!this.getWriteToDom()){return null}var r=this.getKey();var i=this.getValue();function n(e){a.error("[FUTURE FATAL] CustomData with key "+r+" should be written to HTML of "+t+" but "+e);return null}if(typeof i!="string"){return n("the value is not a string.")}var o=e.getType("sap.ui.core.ID");if(!o.isValid(r)||r.indexOf(":")!=-1){return n("the key is not valid (must be a valid sap.ui.core.ID without any colon).")}if(r==u.fastNavigationKey){i=/^\s*(x|true)\s*$/i.test(i)?"true":"false"}else if(r.indexOf("sap-ui")==0){return n("the key is not valid (may not start with 'sap-ui').")}return{key:"data-"+r,value:i}};function _(e,t){var r=e.getAggregation("customData");if(r){for(var i=0;i<r.length;i++){if(r[i].getKey()==t){return r[i]}}}return null}function T(e,t,r,i){var n=_(e,t);if(r===null){if(!n){return}var o=e.getAggregation("customData").length;if(o==1){e.destroyAggregation("customData",true)}else{e.removeAggregation("customData",n,true);n.destroy()}}else if(n){n.setValue(r);n.setWriteToDom(i)}else{e.addAggregation("customData",new b({key:t,value:r,writeToDom:i}),true)}}y.prototype.data=function(){var e=arguments.length;if(e==0){var t=this.getAggregation("customData"),r={};if(t){for(var i=0;i<t.length;i++){r[t[i].getKey()]=t[i].getValue()}}return r}else if(e==1){var n=arguments[0];if(n===null){this.destroyAggregation("customData",true);return this}else if(typeof n=="string"){var o=_(this,n);return o?o.getValue():null}else if(typeof n=="object"){for(var a in n){T(this,a,n[a])}return this}else{throw new TypeError("When data() is called with one argument, this argument must be a string, an object or null, but is "+typeof n+":"+n+" (on UI Element with ID '"+this.getId()+"')")}}else if(e==2){T(this,arguments[0],arguments[1]);return this}else if(e==3){T(this,arguments[0],arguments[1],arguments[2]);return this}else{throw new TypeError("data() may only be called with 0-3 arguments (on UI Element with ID '"+this.getId()+"')")}};y._CustomData=b;y.getMetadata().getAggregation("customData").defaultClass=b;function E(){var e=arguments.length;if(e===1&&arguments[0]!==null&&typeof arguments[0]=="object"||e>1&&e<4&&arguments[1]!==null){a.error("[FUTURE FATAL] Cannot create custom data on an already destroyed element '"+this+"'");return this}return y.prototype.data.apply(this,arguments)}y.prototype.clone=function(e,t){var i=r.prototype.clone.apply(this,arguments);for(var n=0;n<this.aDelegates.length;n++){if(this.aDelegates[n].bClone){i.aDelegates.push(this.aDelegates[n])}}for(var o=0;o<this.aBeforeDelegates.length;o++){if(this.aBeforeDelegates[o].bClone){i.aBeforeDelegates.push(this.aBeforeDelegates[o])}}if(this._sapui_declarativeSourceInfo){i._sapui_declarativeSourceInfo=Object.assign({},this._sapui_declarativeSourceInfo)}return i};y.prototype.findElements=r.prototype.findAggregatedObjects;function C(e){var t=e.getParent();if(t){var r=jQuery.Event("LayoutDataChange");r.srcControl=e;t._handleEvent(r)}}y.prototype.setLayoutData=function(e){this.setAggregation("layoutData",e,true);C(this);return this};y.prototype.destroyLayoutData=function(){this.destroyAggregation("layoutData",true);C(this);return this};y.prototype.bindElement=r.prototype.bindObject;y.prototype.unbindElement=r.prototype.unbindObject;y.prototype.getElementBinding=r.prototype.getObjectBinding;y.prototype._getFieldGroupIds=function(){var e;if(this.getMetadata().hasProperty("fieldGroupIds")){e=this.getFieldGroupIds()}if(!e||e.length==0){var t=this.getParent();if(t&&t._getFieldGroupIds){return t._getFieldGroupIds()}}return e||[]};y.prototype.getDomRefForSetting=function(e){var t=this.getMetadata().getAllSettings()[e];if(t&&t.selector){var r=this.getDomRef();if(r){r=r.parentNode;if(r&&r.querySelector){var i=t.selector.replace(/\{id\}/g,this.getId().replace(/(:|\.)/g,"\\$1"));return r.querySelector(i)}}}return null};y.prototype._getMediaContainerWidth=function(){if(typeof this._oContextualSettings==="undefined"){return undefined}return this._oContextualSettings.contextualWidth};y.prototype._getCurrentMediaContainerRange=function(e){var t=this._getMediaContainerWidth();e=e||n.media.RANGESETS.SAP_STANDARD;return n.media.getCurrentRange(e,t)};y.prototype._onContextualSettingsChanged=function(){var e=this._getMediaContainerWidth(),t=e!==undefined,r=t^!!this._bUsingContextualWidth,i=this._aContextualWidthListeners||[];if(r){if(t){i.forEach(function(e){n.media.detachHandler(e.callback,e.listener,e.name)})}else{i.forEach(function(e){n.media.attachHandler(e.callback,e.listener,e.name)})}this._bUsingContextualWidth=t}i.forEach(function(e){var t=this._getCurrentMediaContainerRange(e.name);if(t&&t.from!==e.media.from){e.media=t;e.callback.call(e.listener||window,t)}},this)};y.prototype._attachMediaContainerWidthChange=function(e,t,r){r=r||n.media.RANGESETS.SAP_STANDARD;this._aContextualWidthListeners=this._aContextualWidthListeners||[];this._aContextualWidthListeners.push({callback:e,listener:t,name:r,media:this._getCurrentMediaContainerRange(r)});if(!this._bUsingContextualWidth){n.media.attachHandler(e,t,r)}};y.prototype._detachMediaContainerWidthChange=function(e,t,r){var i;r=r||n.media.RANGESETS.SAP_STANDARD;if(!this._aContextualWidthListeners){return}for(var o=0,a=this._aContextualWidthListeners.length;o<a;o++){i=this._aContextualWidthListeners[o];if(i.callback===e&&i.listener===t&&i.name===r){if(!this._bUsingContextualWidth){n.media.detachHandler(e,t,r)}this._aContextualWidthListeners.splice(o,1);break}}};var A;y._updateFocusInfo=function(e){A=A||sap.ui.require("sap/ui/core/FocusHandler");if(A){A.updateControlFocusInfo(e)}};y.closestTo=function(e,t){var r="[data-sap-ui]",i,n;if(e===undefined||e===null){return undefined}if(typeof e==="string"){i=document.querySelector(e)}else if(typeof e==="object"&&e.nodeType===Node.ELEMENT_NODE&&typeof e.nodeName==="string"){i=e}else if(e.jquery){i=e[0];a.error("[FUTURE FATAL] Do not call Element.closestTo() with jQuery object as parameter. \t\t\t\tThe function should be called with either a DOM Element or a CSS selector. \t\t\t\t(future error, ignored for now)")}else{throw new TypeError("Element.closestTo accepts either a DOM element or a CSS selector string as parameter, but not '"+e+"'")}if(t){r+=",[data-sap-ui-related]"}i=i&&i.closest(r);if(i){if(t){n=i.getAttribute("data-sap-ui-related")}n=n||i.getAttribute("id")}return y.getElementById(n)};y.getElementById=g.get;y.getActiveElement=()=>{try{var e=jQuery(document.activeElement);if(e.is(":focus")){return y.closestTo(e[0])}}catch(e){}};y.registry=g;h.attachApplied(function(e){var t=jQuery.Event("ThemeChanged");t.theme=e.theme;g.forEach(function(e){t._bNoReturnValue=true;e._handleEvent(t)})});c.registerForUpdate("Elements",g.all);return y});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ElementMetadata", ["sap/base/Log","sap/base/util/ObjectPath","sap/ui/base/ManagedObjectMetadata","sap/ui/core/Renderer"],function(e,t,r,n){"use strict";var i=function(e,t){r.apply(this,arguments)};i.prototype=Object.create(r.prototype);i.prototype.constructor=i;i.uid=r.uid;i.prototype.getElementName=function(){return this._sClassName};i.prototype.getRendererName=function(){return this._sRendererName};i.prototype.getRenderer=function(){if(this._oRenderer){return this._oRenderer}var r=this.getRendererName();if(!r){return undefined}this._oRenderer=sap.ui.require(r.replace(/\./g,"/"))||t.get(r);if(this._oRenderer){return this._oRenderer}e.warning("Synchronous loading of Renderer for control class '"+this.getName()+"', due to missing Renderer dependency.","SyncXHR",null,function(){return{type:"SyncXHR",name:r}});this._oRenderer=sap.ui.requireSync(r.replace(/\./g,"/"))||t.get(r);return this._oRenderer};i.prototype.applySettings=function(e){var o=e.metadata;this._sVisibility=o.visibility||"public";var a=Object.hasOwn(e,"renderer")?e.renderer||"":undefined;delete e.renderer;r.prototype.applySettings.call(this,e);var d=this.getParent();this._sRendererName=this.getName()+"Renderer";this.dnd=Object.assign({draggable:false,droppable:false},d.dnd,typeof o.dnd=="boolean"?{draggable:o.dnd,droppable:o.dnd}:o.dnd);if(typeof a!=="undefined"){if(typeof a==="string"){this._sRendererName=a||undefined;return}if((typeof a==="object"||typeof a==="function")&&typeof a.render==="function"){var s=sap.ui.require(this.getRendererName().replace(/\./g,"/"))||t.get(this.getRendererName());if(s===a){this._oRenderer=a;return}if(s===undefined&&typeof a.extend==="function"){t.set(this.getRendererName(),a);this._oRenderer=a;return}}if(typeof a==="function"){a={render:a}}var p;if(d instanceof i){p=d.getRenderer()}this._oRenderer=n.extend.call(p||n,this.getRendererName(),a)}};i.prototype.afterApplySettings=function(){r.prototype.afterApplySettings.apply(this,arguments);this.register&&this.register(this)};i.prototype.isHidden=function(){return this._sVisibility==="hidden"};var o=i.prototype.metaFactoryAggregation;function a(e,t,r){o.apply(this,arguments);this.dnd=Object.assign({draggable:false,droppable:false,layout:"Vertical"},typeof r.dnd=="boolean"?{draggable:r.dnd,droppable:r.dnd}:r.dnd)}a.prototype=Object.create(o.prototype);a.prototype.constructor=a;i.prototype.metaFactoryAggregation=a;i.prototype.getDragDropInfo=function(e){if(!e){return this.dnd}var t=this._mAllAggregations[e]||this._mAllPrivateAggregations[e];if(!t){return{}}return t.dnd};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/ElementRegistry", ["sap/base/Log","sap/ui/base/ManagedObjectRegistry","sap/ui/core/Configuration"],(e,t,r)=>{"use strict";const i=function(t,i,a){if(i._sapui_candidateForDestroy){e.debug("destroying dangling template "+i+" when creating new object with same ID");i.destroy()}else{var n="adding element with duplicate id '"+t+"'";if(!r.getNoDuplicateIds()){e.warning(n);return}e.error(n);throw new Error("Error: "+n)}};const a=t.create({onDuplicate:i});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/EnabledPropagator", ["sap/ui/dom/jquery/Selectors"],function(){"use strict";var e=function(e,n){if(!this.isA||!this.isA("sap.ui.core.Control")){throw new Error("EnabledPropagator only supports subclasses of Control")}this._bUseEnabledPropagator=true;var s=this.getEnabled;if(s===undefined){this.getEnabled=function(){return this._bUseEnabledPropagator&&t(this)?false:this.getProperty("enabled")};e=e===undefined?true:Boolean(e);if(n){this.getMetadata().addProperty("Enabled",{type:"boolean",group:"Behavior",defaultValue:e})}this.getMetadata().addProperty("enabled",{type:"boolean",group:"Behavior",defaultValue:e});this.getMetadata().addPublicMethods("getEnabled")}else{this.getEnabled=function(){return this._bUseEnabledPropagator&&t(this)?false:s.apply(this,arguments)}}if(this.setEnabled===undefined){this.setEnabled=function(e){a(this,e);return this.setProperty("enabled",e)};this.getMetadata().addPublicMethods("setEnabled")}else{var r=this.setEnabled;this.setEnabled=function(e){a(this,e);return r.apply(this,arguments)}}this.useEnabledPropagator=function(e){this._bUseEnabledPropagator=e};this.getMetadata().addPublicMethods("useEnabledPropagator")};e.updateDescendants=function(e){e.isActive()&&e.findElements(true,function(e){if(e._bUseEnabledPropagator&&e.bOutput==true){e.invalidate()}})};function t(e){let t;for(t=e.getParent();t&&!t.getEnabled&&t.getParent;t=t.getParent()){}return t&&t.getEnabled&&!t.getEnabled()}function a(e,t){var a=e.getDomRef();if(!t&&a&&a.contains(document.activeElement)){var n=e.$().parent().closest(":focusable")[0];if(n){n.focus({preventScroll:true})}}}return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/FocusHandler", ["../base/EventProvider","../base/Object","sap/base/Log","sap/ui/core/UIAreaRegistry","sap/ui/thirdparty/jquery","sap/ui/dom/_ready"],function(t,o,e,n,jQuery,r){"use strict";var s;var u;var i;var a=new t;var c="focusInfo";var l={};var f=o.extend("sap.ui.core.FocusHandler",{constructor:function(){o.apply(this);this.oCurrent=null;this.oLast=null;this.aEventQueue=[];this.oLastFocusedControlInfo=null;this.oPatchingControlFocusInfo=null;this.fnEventHandler=this.onEvent.bind(this);r().then(function(){var t=document.body;t.addEventListener("focus",this.fnEventHandler,true);t.addEventListener("blur",this.fnEventHandler,true);e.debug("FocusHandler setup on Root "+t.type+(t.id?": "+t.id:""),null,"sap.ui.core.FocusHandler")}.bind(this))}});f.prototype.getControlFocusInfo=function(t){var o;s??=sap.ui.require("sap/ui/core/Element");t=t||s?.getActiveElement()?.getId();if(!t){return null}o=p(t);if(o){return{id:t,control:o,info:o.getFocusInfo(),type:o.getMetadata().getName(),focusref:o.getFocusDomRef()}}return null};f.prototype.storePatchingControlFocusInfo=function(t){var o=document.activeElement;if(!o||!t.contains(o)){this.oPatchingControlFocusInfo=null}else{this.oPatchingControlFocusInfo=this.getControlFocusInfo();if(this.oPatchingControlFocusInfo){this.oPatchingControlFocusInfo.patching=true}}};f.prototype.getPatchingControlFocusInfo=function(){return this.oPatchingControlFocusInfo};f.prototype.updateControlFocusInfo=function(t){if(t&&this.oLastFocusedControlInfo&&this.oLastFocusedControlInfo.control===t){var o=t.getId();this.oLastFocusedControlInfo=this.getControlFocusInfo(o);e.debug("Update focus info of control "+o,null,"sap.ui.core.FocusHandler")}};f.prototype.addFocusInfoExtender=function(t,o){a.attachEvent(c,l,t,o);return this};f.prototype.removeFocusInfoExtender=function(t,o){a.detachEvent(c,t,o);return this};f.prototype.restoreFocus=function(t){var o=t||this.oLastFocusedControlInfo;if(!o){return}var n=p(o.id);var r=o.focusref;if(n&&o.info&&n.getMetadata().getName()==o.type&&(o.patching||n.getFocusDomRef()!=r&&(t||n!==o.control||o.preserved))){e.debug("Apply focus info of control "+o.id,null,"sap.ui.core.FocusHandler");o.control=n;this.oLastFocusedControlInfo=o;delete this.oLastFocusedControlInfo.patching;l.info=o.info;a.fireEvent(c,{domRef:n.getDomRef()});n.applyFocusInfo(l.info);Object.keys(l).forEach(function(t){delete l[t]})}else{e.debug("Apply focus info of control "+o.id+" not possible",null,"sap.ui.core.FocusHandler")}};f.prototype.destroy=function(t){var o=t.data.oRootRef;if(o){o.removeEventListener("focus",this.fnEventHandler,true);o.removeEventListener("blur",this.fnEventHandler,true)}};f.prototype.onEvent=function(t){var o=jQuery.event.fix(t);e.debug("Event "+o.type+" reached Focus Handler (target: "+o.target+(o.target?o.target.id:"")+")",null,"sap.ui.core.FocusHandler");var n=o.type=="focus"||o.type=="focusin"?"focus":"blur";this.aEventQueue.push({type:n,controlId:d(o.target)});if(this.aEventQueue.length==1){this.processEvent()}};f.prototype.processEvent=function(){var t=this.aEventQueue[0];if(!t){return}try{if(t.type=="focus"){this.onfocusEvent(t.controlId)}else if(t.type=="blur"){this.onblurEvent(t.controlId)}}finally{this.aEventQueue.shift();if(this.aEventQueue.length>0){this.processEvent()}}};f.prototype.onfocusEvent=function(t){var o=p(t);if(o){this.oLastFocusedControlInfo=this.getControlFocusInfo(t);e.debug("Store focus info of control "+t,null,"sap.ui.core.FocusHandler")}this.oCurrent=t;if(!this.oLast){return}if(this.oLast!=this.oCurrent){h(this.oLast,t)}this.oLast=null};f.prototype.onblurEvent=function(t){if(!this.oCurrent){return}this.oLast=t;this.oCurrent=null;setTimeout(this["checkForLostFocus"].bind(this),0)};f.prototype.checkForLostFocus=function(){if(this.oCurrent==null&&this.oLast!=null){h(this.oLast,null)}this.oLast=null};f.prototype.trackFocusForPreservedElement=function(t){if(t.contains(document.activeElement)&&this.oLastFocusedControlInfo&&document.activeElement===this.oLastFocusedControlInfo.focusref){this.oLastFocusedControlInfo.preserved=true}};var d=function(t){var o=jQuery(t).closest("[data-sap-ui]").attr("id");if(o){return o}return null};var h=function(t,o){var e=p(t);if(e){var n=jQuery.Event("sapfocusleave");n.target=e.getDomRef();var r=p(o);n.relatedControlId=r?r.getId():null;n.relatedControlFocusInfo=r?r.getFocusInfo():null;u=u||sap.ui.require("sap/ui/core/UIArea");if(u){var s=e.getUIArea();var a=null;if(s){a=s}else{i=i||sap.ui.require("sap/ui/core/StaticArea");if(i){var c=i.getDomRef();if(c.contains(n.target)){a=i.getUIArea()}}}if(a){a._handleEvent(n)}}}};function p(t){var o;if(!s){s=sap.ui.require("sap/ui/core/Element")}if(s){o=s.getElementById(t)}return o||null}return new f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/InvisibleRenderer", [],function(){"use strict";var e={apiVersion:2};e.PlaceholderPrefix="sap-ui-invisible-";e.createInvisiblePlaceholderId=function(e){return this.PlaceholderPrefix+e.getId()};e.getDomRef=function(e){return document.getElementById(this.createInvisiblePlaceholderId(e))};e.render=function(e,i,r){var t=this.createInvisiblePlaceholderId(i);r=r||"span";e.openStart(r,t);e.attr("data-sap-ui",t);e.attr("aria-hidden","true");e.class("sapUiHiddenPlaceholder");e.openEnd(true);e.close(r)};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/LabelEnablement", ["../base/ManagedObject","sap/base/assert"],function(e,t){"use strict";var r={};var i=["sap.ui.comp.navpopover.SmartLink","sap.m.Link","sap.m.Label","sap.m.Text","sap.m.Select","sap.ui.webc.main.Label","sap.ui.webc.main.Link"];var n;function a(e,t){if(!e){return null}n=n?n:sap.ui.require("sap/ui/core/Element");var r=n.getElementById(e);if(r&&t&&(!r.isA("sap.ui.core.Control")||r.getDomRef())){r.invalidate()}return r}function s(e){var t=e.getLabelFor()||e._sAlternativeId||"";return t}function u(e,t){var i=e.getId();var n=e.__sLabeledControl;var u=t?null:s(e);if(n==u){return}if(!t){e.invalidate()}if(u){e.__sLabeledControl=u}else{delete e.__sLabeledControl}var o;if(n){o=r[n];if(o){o=o.filter(function(e){return e!=i});if(o.length){r[n]=o}else{delete r[n]}}}if(u){o=r[u]||[];o.push(i);r[u]=o}var l=a(n,true);var f=a(u,true);if(l){e.detachRequiredChange(l)}if(f){e.attachRequiredChange(f)}}function o(e){if(!e){throw new Error("sap.ui.core.LabelEnablement cannot enrich null")}var t=e.getMetadata();if(!t.isInstanceOf("sap.ui.core.Label")){throw new Error("sap.ui.core.LabelEnablement only supports Controls with interface sap.ui.core.Label")}var r=t.getAssociation("labelFor");if(!r||r.multiple){throw new Error("sap.ui.core.LabelEnablement only supports Controls with a to-1 association 'labelFor'")}}function l(e){if(!e){return true}if(e.isA("sap.ui.core.ILabelable")){return e.hasLabelableHTMLElement()}var t=e.getMetadata().getName();return i.indexOf(t)<0}var f={};f.writeLabelForAttribute=function(e,t){if(!t||!t.getLabelForRendering){return}var r=t.getLabelForRendering();if(!r){return}var i=a(r);if(i&&i.getIdForLabel){r=i.getIdForLabel()}if(r&&l(i)){e.attr("for",r)}};f.getReferencingLabels=function(e){var t=e?e.getId():null;if(!t){return[]}return r[t]||[]};f.isRequired=function(e){if(g(e)){return true}var t=f.getReferencingLabels(e),r;n=n?n:sap.ui.require("sap/ui/core/Element");for(var i=0;i<t.length;i++){r=n.getElementById(t[i]);if(g(r)){return true}}return false};function g(e){return!!(e&&e.getRequired&&e.getRequired())}f.enrich=function(i){o(i);i.__orig_setLabelFor=i.setLabelFor;i.setLabelFor=function(e){var t=this.__orig_setLabelFor.apply(this,arguments);u(this);return t};i.__orig_exit=i.exit;i.exit=function(){this._sAlternativeId=null;u(this,true);if(i.__orig_exit){i.__orig_exit.apply(this,arguments)}};i.setAlternativeLabelFor=function(r){if(r instanceof e){r=r.getId()}else if(r!=null&&typeof r!=="string"){t(false,"setAlternativeLabelFor(): sId must be a string, an instance of sap.ui.base.ManagedObject or null");return this}this._sAlternativeId=r;u(this);return this};i.getLabelForRendering=function(){var e=this.getLabelFor()||this._sAlternativeId;var t=a(e);var r;n=n?n:sap.ui.require("sap/ui/core/Element");if(t&&!t.isA("sap.ui.core.ILabelable")&&t.getIdForLabel&&t.getIdForLabel()){r=n.getElementById(t.getIdForLabel());if(r){t=r}}return l(t)?e:""};i.isLabelFor=function(e){var t=e.getId();var i=r[t];return i&&i.indexOf(this.getId())>-1};if(!i.getMetadata().getProperty("required")){return}i.__orig_setRequired=i.setRequired;i.setRequired=function(e){var t=this.getRequired(),r=this.__orig_setRequired.apply(this,arguments);if(this.getRequired()!==t){a(this.__sLabeledControl,true)}return r};i.isRequired=function(){var e=a(this.getLabelForRendering(),false);return g(this)||g(e)};i.isDisplayOnly=function(){if(this.getDisplayOnly){return this.getDisplayOnly()}else{return false}};i.isWrapping=function(){if(this.getWrapping){return this.getWrapping()}else{return false}};i.disableRequiredChangeCheck=function(e){this._bNoRequiredChangeCheck=e};i.attachRequiredChange=function(e){if(e&&!this._bNoRequiredChangeCheck){if(e.getMetadata().getProperty("required")){e.attachEvent("_change",s,this)}this._bRequiredAttached=true}};i.detachRequiredChange=function(e){if(e&&!this._bNoRequiredChangeCheck){if(e.getMetadata().getProperty("required")){e.detachEvent("_change",s,this)}this._bRequiredAttached=false}};function s(e){if(e.getParameter("name")=="required"){this.invalidate()}}i.__orig_onAfterRendering=i.onAfterRendering;i.onAfterRendering=function(e){var t;if(this.__orig_onAfterRendering){t=this.__orig_onAfterRendering.apply(this,arguments)}if(!this._bNoRequiredChangeCheck&&!this._bRequiredAttached&&this.__sLabeledControl){var r=a(this.__sLabeledControl,false);this.attachRequiredChange(r)}return t}};return f},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Patcher", ["sap/ui/Device"],function(t){"use strict";var e=document.createElement("title").style;var r=document.createElement("template");var i={value:function(t,e){if(t.tagName=="INPUT"){t.value=e==null?"":e}},checked:function(t,e){if(t.tagName=="INPUT"){t.checked=e==null?false:true}},selected:function(t,e){if(t.tagName=="OPTION"){t.selected=e==null?false:true}}};if(t.browser.safari){i.style=function(t,e){if(e==null){t.style="";return true}}}var n=function(t,e){if(t=="svg"){return document.createElementNS("http://www.w3.org/2000/svg","svg")}var r=e&&e.namespaceURI;if(!r||r=="http://www.w3.org/1999/xhtml"||e.localName=="foreignObject"){return document.createElement(t)}return document.createElementNS(r,t)};var s=function(){this._oRoot=null;this._oCurrent=null;this._oParent=null;this._oReference=null;this._oNewElement=null;this._oNewParent=null;this._oNewReference=null;this._iTagOpenState=0;this._sStyles="";this._sClasses="";this._mAttributes=Object.create(null)};s.prototype.setRootNode=function(t){if(this._oRoot){this.reset()}this._oRoot=t||document.createDocumentFragment()};s.prototype.getRootNode=function(){return this._oRoot};s.prototype.getCurrentNode=function(){return this._oCurrent};s.prototype.reset=function(){this._oRoot=this._oCurrent=this._oParent=this._oReference=this._oNewElement=this._oNewParent=this._oNewReference=null;this._iTagOpenState=0};s.prototype._walkOnTree=function(){this._oReference=null;if(!this._oCurrent){if(this._oRoot.nodeType==11){this._oParent=this._oRoot}else{this._oParent=this._oRoot.parentNode;this._oCurrent=this._oRoot}}else if(this._iTagOpenState){this._oParent=this._oCurrent;this._oCurrent=this._oCurrent.firstChild}else{this._oParent=this._oCurrent.parentNode;this._oCurrent=this._oCurrent.nextSibling}};s.prototype._matchElement=function(t){if(!t){return}if(!this._oCurrent){return}if(this._oCurrent.id==t||this._oCurrent==this._oRoot){return}var e=document.getElementById(t);if(e){this._oCurrent=this._oParent.insertBefore(e,this._oCurrent);return}if(this._oCurrent.id){this._oReference=this._oCurrent;this._oCurrent=null}};s.prototype._matchNodeName=function(t){if(!this._oCurrent){return}var e=this._oCurrent.nodeType==1?this._oCurrent.localName:this._oCurrent.nodeName;if(e==t){return}this._oReference=this._oCurrent;this._oCurrent=null};s.prototype._getAttributes=function(){for(var t=0,e=this._oCurrent.getAttributeNames();t<e.length;t++){this._mAttributes[e[t]]=this._oCurrent.getAttribute(e[t])}};s.prototype._setNewElement=function(t){if(!t){return}if(!this._oNewElement){this._oNewElement=this._oCurrent;this._oNewParent=this._oParent;this._oNewReference=this._oReference}else{this._oParent.insertBefore(this._oCurrent,this._oReference)}};s.prototype._insertNewElement=function(){if(this._oCurrent==this._oNewElement){this._oNewParent[this._oNewReference==this._oRoot?"replaceChild":"insertBefore"](this._oNewElement,this._oNewReference);this._oNewElement=this._oNewParent=this._oNewReference=null}};s.prototype.isCreating=function(){return Boolean(this._oNewElement)};s.prototype.alignWithDom=function(t,e){this._walkOnTree();if(!this._oCurrent||this._oCurrent.id!=t.id||this._oParent!=t.parentNode){this._oCurrent=this._oParent.insertBefore(t,this._oCurrent)}if(e){this._oCurrent=e(t)||this._oCurrent}this._iTagOpenState=0;return this};s.prototype.openStart=function(t,e){this._walkOnTree();this._matchElement(e);this._matchNodeName(t);if(this._oCurrent){this._getAttributes();this._iTagOpenState=2}else{this._oCurrent=n(t,this._oParent);this._setNewElement(this._oCurrent);this._iTagOpenState=1}if(e){this.attr("id",e)}return this};s.prototype.voidStart=s.prototype.openStart;s.prototype.attr=function(t,e){if(t==="style"){this._sStyles=e;return this}if(this._iTagOpenState==1){this._oCurrent.setAttribute(t,e);return this}var r=String(e);var n=this._mAttributes[t];var s=i[t];if(n!==undefined){delete this._mAttributes[t]}if(s&&s(this._oCurrent,r,n)){return this}if(n!==r){this._oCurrent.setAttribute(t,r)}return this};s.prototype.class=function(t){if(t){this._sClasses+=this._sClasses?" "+t:t}return this};s.prototype.style=function(t,r){if(!t||r==null||r==""){return this}r=r+"";if(r.includes(";")){e.setProperty(t,r);r=e.getPropertyValue(t)}this._sStyles+=(this._sStyles?" ":"")+(t+": "+r+";");return this};s.prototype.openEnd=function(){if(this._sClasses){this.attr("class",this._sClasses);this._sClasses=""}if(this._sStyles){if(this._mAttributes.style!=this._sStyles){this._oCurrent.style=this._sStyles}delete this._mAttributes.style;this._sStyles=""}if(this._iTagOpenState==1){return this}for(var t in this._mAttributes){var e=i[t];if(!e||!e(this._oCurrent,null)){this._oCurrent.removeAttribute(t)}delete this._mAttributes[t]}return this};s.prototype.voidEnd=function(){this.openEnd();this._iTagOpenState=0;this._insertNewElement();return this};s.prototype.text=function(t){this._walkOnTree();this._matchNodeName("#text");if(!this._oCurrent){this._oCurrent=document.createTextNode(t);this._oParent.insertBefore(this._oCurrent,this._oReference)}else if(this._oCurrent.data!=t){this._oCurrent.data=t}this._iTagOpenState=0;return this};s.prototype.close=function(t){if(this._iTagOpenState){this._iTagOpenState=0;if(this._oCurrent.lastChild){this._oCurrent.textContent=""}}else{var e=this._oCurrent.parentNode;for(var r=e.lastChild;r&&r!=this._oCurrent;r=e.lastChild){e.removeChild(r)}this._oCurrent=e}this._insertNewElement();return this};s.prototype.unsafeHtml=function(t,e,i){var n=null;var s=this._oCurrent;if(!s){n=this._oRoot}else if(this._iTagOpenState){n=s.firstChild;if(t){this._iTagOpenState=0;s.insertAdjacentHTML("afterbegin",t);this._oCurrent=n?n.previousSibling:s.lastChild}}else{n=s.nextSibling;if(t){if(s.nodeType==1){s.insertAdjacentHTML("afterend",t)}else{r.innerHTML=t;s.parentNode.insertBefore(r.content,n)}this._oCurrent=n?n.previousSibling:s.parentNode.lastChild}}if(t&&i){var o=[this._oCurrent];for(var h=this._oCurrent.previousSibling;h&&h!=s;h=h.previousSibling){o.unshift(h)}i(o)}if(e&&n&&n.id==e){n.remove()}return this};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/RenderManager", ["./LabelEnablement","sap/ui/base/Object","sap/ui/performance/trace/Interaction","sap/base/util/uid","sap/ui/util/ActivityDetection","sap/ui/thirdparty/jquery","sap/base/security/encodeXML","sap/base/security/encodeCSS","sap/base/assert","sap/ui/performance/Measurement","sap/base/Log","sap/base/util/extend","./ControlBehavior","./InvisibleRenderer","./Patcher","./FocusHandler"],function(e,t,n,r,i,jQuery,a,s,o,l,u,f,c,d,p,h){"use strict";var g;var m=["renderControl","cleanupControlWithoutRendering","accessibilityState","icon"];var y=["write","writeEscaped","writeAcceleratorKey","writeControlData","writeElementData","writeAttribute","writeAttributeEscaped","addClass","writeClasses","addStyle","writeStyles","writeAccessibilityState","writeIcon","translate","getConfiguration","getHTML"];var b=["openStart","voidStart","attr","class","style","openEnd","voidEnd","text","unsafeHtml","close"];var v=["render","flush","destroy"];var C=document.createElement("template");var S="data-sap-ui-stylekey";var E="data-sap-ui-render";function A(){var e=this,r,s,f,c,g="",w=false,I,D="",O={},j={},T=[],N=new p,M,B;function H(){o(!(M=B=""));r=e.aBuffer=[];s=e.aRenderedControls=[];f=e.aStyleStack=[{}];I=undefined;w=false;g=""}function L(e,t){r.push(" ",e,'="',t,'"')}function F(e){var t=f[f.length-1];var n;if(e){n=e.aCustomStyleClasses}else if(e===false){n=[]}else{n=t.aCustomStyleClasses}if(t.aClasses||n){var r=[].concat(t.aClasses||[],n||[]);if(r.length){L("class",r.join(" "))}}if(!e){t.aCustomStyleClasses=null}t.aClasses=null}function q(){var e=f[f.length-1];if(e.aStyle&&e.aStyle.length){L(S,T.push(e.aStyle.join(" "))-1)}e.aStyle=null}function V(e,t){o(e&&typeof e=="string"&&/^[a-z_][a-zA-Z0-9_\-]*$/.test(e),"The "+t+" name provided '"+e+"' is not valid; it must contain alphanumeric characters, hyphens or underscores")}function U(e){o(g,"There is no open tag; '"+e+"' must not be called without an open tag")}function W(e){var t=e===undefined?!g:e;o(t,"There is an open tag; '"+g+"' tag has not yet ended with '"+(w?"voidEnd":"openEnd")+"'")}function G(e){V(e,"attr");o((e!="class"||B!="class"&&(B="attr"))&&(e!="style"||M!="style"&&(M="attr")),"Attributes 'class' and 'style' must not be written when the methods with the same name"+" have been called for the same element already")}function X(e){o(B!="attr"&&(B="class"),"Method class() must not be called after the 'class' attribute has been written for the same element");o(typeof e=="string"&&!/\s/.test(e)&&arguments.length===1,"Method 'class' must be called with exactly one class name")}function $(e){o(M!="attr"&&(M="style"),"Method style() must not be called after the 'style' attribute has been written for the same element");o(e&&typeof e=="string"&&!/\s/.test(e),"Method 'style' must be called with a non-empty string name")}this.write=function(e){o(typeof e==="string"||typeof e==="number","sText must be a string or number");r.push.apply(r,arguments);return this};this.writeEscaped=function(e,t){if(e!=null){e=a(String(e));if(t){e=e.replace(/&#xa;/g,"<br>")}r.push(e)}return this};this.writeAttribute=function(e,t){o(typeof e==="string","sName must be a string");o(typeof t==="string"||typeof t==="number"||typeof t==="boolean","value must be a string, number or boolean");r.push(" ",e,'="',t,'"');return this};this.writeAttributeEscaped=function(e,t){o(typeof e==="string","sName must be a string");r.push(" ",e,'="',a(String(t)),'"');return this};this.addStyle=function(e,t){o(typeof e==="string","sName must be a string");if(t!=null&&t!=""){o(typeof t==="string"||typeof t==="number","value must be a string or number");var n=f[f.length-1];if(!n.aStyle){n.aStyle=[]}n.aStyle.push(e+": "+t+";")}return this};this.writeStyles=function(){q();return this};this.addClass=function(e){if(e){o(typeof e==="string","sName must be a string");var t=f[f.length-1];if(!t.aClasses){t.aClasses=[]}t.aClasses.push(e)}return this};this.writeClasses=function(e){o(!e||typeof e==="boolean"||t.isObjectA(e,"sap.ui.core.Element"),"oElement must be empty, a boolean, or an sap.ui.core.Element");F(e);return this};this.openStart=function(e,n){V(e,"tag");W();o(!(M=B=""));g=e;r.push("<"+e);if(n){if(typeof n=="string"){this.attr("id",n)}else{o(n&&t.isObjectA(n,"sap.ui.core.Element"),"vControlOrId must be an sap.ui.core.Element");this.attr("id",n.getId());_(this,n)}}return this};this.openEnd=function(e){U("openEnd");W(!w);o(e===undefined||e===true,"The private parameter bExludeStyleClasses must be true or omitted!");g="";F(e===true?false:undefined);q();r.push(">");return this};this.close=function(e){V(e,"tag");W();r.push("</"+e+">");return this};this.voidStart=function(e,t){this.openStart(e,t);w=true;return this};this.voidEnd=function(e){U("voidEnd");W(w||!g);w=false;g="";F(e?false:undefined);q();r.push(">");return this};this.unsafeHtml=function(e){W();r.push(e);return this};this.text=function(e){W();if(e!=null){e=a(String(e));r.push(e)}return this};this.attr=function(e,t){G(e);if(e=="style"){f[f.length-1].aStyle=[t]}else{r.push(" ",e,'="',a(String(t)),'"')}return this};this.class=function(e){if(e){X.apply(this,arguments);var t=f[f.length-1];if(!t.aClasses){t.aClasses=[]}t.aClasses.push(a(e))}return this};this.style=function(e,t){$(e);if(t!=null&&t!=""){o(typeof t==="string"||typeof t==="number","value must be a string or number");var n=f[f.length-1];if(!n.aStyle){n.aStyle=[]}n.aStyle.push(e+": "+t+";")}return this};j.openStart=function(e,t){V(e,"tag");W();o(!(M=B=""));g=e;if(!t){N.openStart(e)}else if(typeof t=="string"){N.openStart(e,t)}else{N.openStart(e,t.getId());_(this,t)}return this};j.voidStart=function(e,t){this.openStart(e,t);w=true;return this};j.attr=function(e,t){G(e);U("attr");N.attr(e,t);return this};j.class=function(e){if(e){X.apply(this,arguments);U("class");N.class(e)}return this};j.style=function(e,t){$(e);U("style");N.style(e,t);return this};j.openEnd=function(e){if(e!==true){var t=f[f.length-1];var n=t.aCustomStyleClasses;if(n){n.forEach(N.class,N);t.aCustomStyleClasses=null}}U("openEnd");W(!w);o(e===undefined||e===true,"The private parameter bExludeStyleClasses must be true or omitted!");g="";N.openEnd();return this};j.voidEnd=function(e){if(!e){var t=f[f.length-1];var n=t.aCustomStyleClasses;if(n){n.forEach(N.class,N);t.aCustomStyleClasses=null}}U("voidEnd");W(w||!g);w=false;g="";N.voidEnd();return this};j.text=function(e){W();if(e!=null){N.text(e)}return this};j.unsafeHtml=function(e){W();N.unsafeHtml(e);return this};j.close=function(e){V(e,"tag");W();N.close(e);return this};function z(e){c=true;try{var t=new jQuery.Event("BeforeRendering");t.srcControl=e;e._bOnBeforeRenderingPhase=true;e._handleEvent(t)}finally{e._bOnBeforeRenderingPhase=false;c=false}}this.cleanupControlWithoutRendering=function(e){o(!e||t.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control or empty");if(!e){return}var n=e.getDomRef();if(n){z(e);A.preserveContent(n,false,false);if(!n.hasAttribute(P)){e._bNeedsRendering=false;e.bOutput=false}}};function J(e,t){if(t){z(e)}if(e.bOutput==true){var n=e.aBindParameters;if(n&&n.length>0){var i=e.$();n.forEach(function(e){i.off(e.sEventType,e.fnProxy)})}}var a=k(e);if(a==d){d.render(I?j:O,e);e.bOutput="invisible"}else if(a&&typeof a.render==="function"){var o={};if(e.aCustomStyleClasses&&e.aCustomStyleClasses.length>0){o.aCustomStyleClasses=e.aCustomStyleClasses}f.push(o);e._bRenderingPhase=true;if(I){var l=N.getCurrentNode();a.render(j,e);if(N.getCurrentNode()==l){N.unsafeHtml("",e.getId());e.bOutput=false}else{e.bOutput=true}}else{var c=r.length;a.render(O,e);e.bOutput=r.length!=c}e._bRenderingPhase=false;f.pop()}else{u.error("The renderer for class "+e.getMetadata().getName()+" is not defined or does not define a render function! Rendering of "+e.getId()+" will be skipped!")}s.push(e);e._bNeedsRendering=false;var p=e.getUIArea();if(p){p._onControlRendered(e)}}this.renderControl=function(e){o(!e||t.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control or empty");if(!e){return this}var n,i;var a=true;if(r.length){I=false}else if(I===undefined){z(e);a=false;i=k(e);if(A.getApiVersion(i)!=1){n=e.getDomRef()||d.getDomRef(e);if(A.isPreservedContent(n)){I=false}else{n&&h.storePatchingControlFocusInfo(n);N.setRootNode(n);I=true}}else{I=false}}else if(!D&&I){i=k(e);if(A.getApiVersion(i)==1){D=e.getId();I=false}}if(I){if(e._bNeedsRendering||!e.getParent()||N.isCreating()||!A.canSkipRendering(e)||!(n=n||e.getDomRef()||d.getDomRef(e))||n.hasAttribute(E)||n.querySelector("["+E+"]")){J(e,a)}else{N.alignWithDom(n)}}else{J(e,a);if(D&&D===e.getId()){N.unsafeHtml(r.join(""),D,Y);D="";I=true;r=[]}}return this};this.getHTML=function(e){o(e&&t.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control");var n=r;var i=r=this.aBuffer=[];this.renderControl(e);r=this.aBuffer=n;return i.join("")};function K(e){var t,n=s.length;for(t=0;t<n;t++){s[t]._sapui_bInAfterRenderingPhase=true}c=true;try{for(t=0;t<n;t++){var r=s[t];if(r.bOutput&&r.bOutput!=="invisible"){var i=new jQuery.Event("AfterRendering");i.srcControl=r;l.start(r.getId()+"---AfterRendering","AfterRendering of "+r.getMetadata().getName(),["rendering","after"]);r._handleEvent(i);l.end(r.getId()+"---AfterRendering")}}}finally{for(t=0;t<n;t++){delete s[t]._sapui_bInAfterRenderingPhase}c=false}try{h.restoreFocus(e)}catch(e){u.warning("Problems while restoring the focus after rendering: "+e,null)}for(t=0;t<n;t++){var r=s[t],a=r.aBindParameters,o;if(a&&a.length>0&&(o=r.getDomRef())){var f=jQuery(o);for(var d=0;d<a.length;d++){var p=a[d];f.on(p.sEventType,p.fnProxy)}}}}function Z(e,t,n){var a;if(!I){a=h.getControlFocusInfo();var s=r.join("");if(s&&T.length){if(n instanceof SVGElement&&n.localName!="foreignObject"){C.innerHTML="<svg>"+s+"</svg>";C.replaceWith.apply(C.content.firstChild,C.content.firstChild.childNodes)}else{C.innerHTML=s}Y(C.content.childNodes);e(C.content)}else{e(s)}}else{var o=N.getRootNode();if(o.nodeType==11){a=h.getControlFocusInfo();e(o.lastChild?o:"")}else{a=h.getPatchingControlFocusInfo()}N.reset()}K(a);H();i.refresh();if(t){t()}}function Q(e,t){var n=e.getAttribute(S);if(n!=t){return 0}e.style=T[t];e.removeAttribute(S);return 1}function Y(e){if(!T.length){return}var t=0;e.forEach(function(e){if(e.nodeType==1){t+=Q(e,t);e.querySelectorAll("["+S+"]").forEach(function(e){t+=Q(e,t)})}});T=[]}this.flush=function(e,t,r){o(typeof e==="object"&&e.ownerDocument==document,"oTargetDomNode must be a DOM element");var i=n.notifyAsyncStep();if(!t&&typeof r!=="number"&&!r){A.preserveContent(e)}Z(function(t){for(var n=0;n<s.length;n++){var i=s[n].getDomRef();if(i&&!A.isPreservedContent(i)){if(A.isInlineTemplate(i)){jQuery(i).empty()}else{jQuery(i).remove()}}}if(typeof r==="number"){if(r<=0){x(e,"prepend",t)}else{var a=e.children[r-1];if(a){x(a,"after",t)}else{x(e,"append",t)}}}else if(!r){jQuery(e).html(t)}else{x(e,"append",t)}},i,e)};this.render=function(e,r){o(e&&t.isObjectA(e,"sap.ui.core.Control"),"oControl must be a control");o(typeof r==="object"&&r.ownerDocument==document,"oTargetDomNode must be a DOM element");if(c){u.error("Render must not be called within Before or After Rendering Phase. Call ignored.",null,this);return}var i=n.notifyAsyncStep();H();this.renderControl(e);Z(function(t){if(e&&r){var n=e.getDomRef();if(!n||A.isPreservedContent(n)){n=d.getDomRef(e)||document.getElementById(R.Dummy+e.getId())}var i=n&&n.parentNode!=r;if(i){if(!A.isPreservedContent(n)){if(A.isInlineTemplate(n)){jQuery(n).empty()}else{jQuery(n).remove()}}if(t){x(r,"append",t)}}else{if(t){if(n){if(A.isInlineTemplate(n)){jQuery(n).html(t)}else{x(n,"after",t);jQuery(n).remove()}}else{x(r,"append",t)}}else{if(A.isInlineTemplate(n)){jQuery(n).empty()}else{if(!e.getParent()||!e.getParent()._onChildRerenderedEmpty||!e.getParent()._onChildRerenderedEmpty(e,n)){jQuery(n).remove()}}}}}},i,r)};this.destroy=function(){H()};var ee={};m.forEach(function(e){O[e]=j[e]=ee[e]=this[e]},this);b.forEach(function(e){O[e]=ee[e]=this[e]},this);y.forEach(function(e){O[e]=ee[e]=this[e]},this);v.forEach(function(e){ee[e]=this[e]},this);this.getRendererInterface=function(){return O};this.getInterface=function(){return ee};H()}A.prototype.getConfiguration=function(){return sap.ui.require("sap/ui/core/Configuration")};A.prototype.translate=function(e){};A.prototype.writeAcceleratorKey=function(){return this};A.prototype.writeControlData=function(e){o(e&&t.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control");this.writeElementData(e);return this};A.prototype.writeElementData=function(e){o(e&&t.isObjectA(e,"sap.ui.core.Element"),"oElement must be an sap.ui.core.Element");this.attr("id",e.getId());_(this,e);return this};A.prototype.accessibilityState=function(n,r){if(!c.isAccessibilityEnabled()){return this}if(arguments.length==1&&!t.isObjectA(n,"sap.ui.core.Element")){r=n;n=null}var i={};if(n!=null){var a=n.getMetadata();var s=function(e,t,r){var s=a.getProperty(e);if(s&&n[s._sGetter]()===r){i[t]="true"}};var o=function(t,r){var s=a.getAssociation(t);if(s&&s.multiple){var o=n[s._sGetter]();if(t=="ariaLabelledBy"){var l=e.getReferencingLabels(n);var u=l.length;if(u){var f=[];for(var c=0;c<u;c++){if(o.indexOf(l[c])<0){f.push(l[c])}}o=f.concat(o)}}if(o.length>0){i[r]=o.join(" ")}}};s("editable","readonly",false);s("enabled","disabled",false);s("visible","hidden",false);if(e.isRequired(n)){i["required"]="true"}s("selected","selected",true);s("checked","checked",true);o("ariaDescribedBy","describedby");o("ariaLabelledBy","labelledby")}if(r){var l=function(e){var t=typeof e;return e===null||t==="number"||t==="string"||t==="boolean"};var u={};var f,d,p;for(f in r){d=r[f];if(l(d)){u[f]=d}else if(typeof d==="object"&&l(d.value)){p="";if(d.append&&(f==="describedby"||f==="labelledby")){p=i[f]?i[f]+" ":""}u[f]=p+d.value}}Object.assign(i,u)}if(t.isObjectA(n,"sap.ui.core.Element")){var h=n.getParent();if(h&&h.enhanceAccessibilityState){var g=Object.assign({},i);h.enhanceAccessibilityState(n,i);if(i.canSkipRendering==false||i.canSkipRendering==undefined&&t.isObjectA(n,"sap.ui.core.Control")&&A.canSkipRendering(n)&&JSON.stringify(g)!=JSON.stringify(i)){this.attr(E,"")}delete i.canSkipRendering}}for(var m in i){if(i[m]!=null&&i[m]!==""){this.attr(m==="role"?m:"aria-"+m,i[m])}}return this};A.prototype.writeAccessibilityState=A.prototype.accessibilityState;A.prototype.icon=function(e,t,n){var i=sap.ui.require("sap/ui/core/IconPool");if(!i){u.warning("Synchronous loading of IconPool due to sap.ui.core.RenderManager#icon call. "+"Ensure that 'sap/ui/core/IconPool is loaded before this function is called","SyncXHR",null,function(){return{type:"SyncXHR",name:"rendermanager-icon"}});i=sap.ui.requireSync("sap/ui/core/IconPool")}var a=i.isIconURI(e),o=false,l,c,d,p,h;if(typeof t==="string"){t=[t]}if(a){c=i.getIconInfo(e);if(!c){u.error("An unregistered icon: "+e+" is used in sap.ui.core.RenderManager's writeIcon method.");return this}if(!t){t=[]}t.push("sapUiIcon");if(!c.suppressMirroring){t.push("sapUiIconMirrorInRTL")}}if(a){this.openStart("span")}else{this.voidStart("img")}if(Array.isArray(t)){t.forEach(function(e){this.class(e)},this)}if(a){d={"data-sap-ui-icon-content":c.content,role:"presentation",title:c.text||null};this.style("font-family","'"+s(c.fontFamily)+"'")}else{d={role:"presentation",alt:"",src:e}}n=f(d,n);if(!n.id){n.id=r()}if(n.role==="presentation"){n["aria-hidden"]=true}if(a){p=n.alt||n.title||c.text||c.name;h=n.id+"-label";if(n["aria-labelledby"]){o=true;n["aria-labelledby"]+=" "+h}else if(!n.hasOwnProperty("aria-label")){n["aria-label"]=p}}if(typeof n==="object"){for(l in n){if(n.hasOwnProperty(l)&&n[l]!==null){this.attr(l,n[l])}}}if(a){this.openEnd();if(o){this.openStart("span");this.style("display","none");this.attr("id",h);this.openEnd();this.text(p);this.close("span")}this.close("span")}else{this.voidEnd()}return this};A.prototype.writeIcon=A.prototype.icon;A.prototype.getRenderer=function(e){o(e&&t.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control");return A.getRenderer(e)};var R=A.RenderPrefixes={Invisible:d.PlaceholderPrefix,Dummy:"sap-ui-dummy-",Temporary:"sap-ui-tmp-"};A.getRenderer=function(e){o(e&&t.isObjectA(e,"sap.ui.core.Control"),"oControl must be an sap.ui.core.Control");return e.getMetadata().getRenderer()};A.forceRepaint=function(e){var t=e?window.document.getElementById(e):null;var n=typeof e=="string"?t:e;if(n){u.debug("forcing a repaint for "+(n.id||String(n)));var r=n.style.display;var i=document.activeElement;n.style.display="none";n.offsetHeight;n.style.display=r;if(document.activeElement!==i&&i){i.focus()}}};A.createInvisiblePlaceholderId=function(e){return d.createInvisiblePlaceholderId(e)};var w="sap-ui-preserve",I="sap-ui-static",P="data-sap-ui-preserve",D="data-sap-ui-area";function O(){var e=jQuery(document.getElementById(w));if(e.length===0){e=jQuery("<div></div>",{"aria-hidden":"true",id:w}).addClass("sapUiHidden").addClass("sapUiForcedHidden").css("width","0").css("height","0").css("overflow","hidden").appendTo(document.body)}return e}function j(e){var t=jQuery("<div></div>",{id:R.Dummy+e.id}).addClass("sapUiHidden");if(e.hasAttribute(E)){t.attr(E,"")}t.insertBefore(e)}var T=[];A.attachPreserveContent=function(e,t){A.detachPreserveContent(e);T.push({fn:e,context:t})};A.detachPreserveContent=function(e){T=T.filter(function(t){return t.fn!==e})};A.preserveContent=function(e,t,n,r){o(typeof e==="object"&&e.ownerDocument==document,"oRootNode must be a DOM element");g=g?g:sap.ui.require("sap/ui/core/Element");T.forEach(function(t){t.fn.call(t.context||A,{domNode:e})});var i=O();function a(t){while(t&&t!=e&&t.parentNode){t=t.parentNode;if(t.hasAttribute(P)){return true}if(t.hasAttribute("data-sap-ui")){break}}}function s(e,t,n){if(e===t){return true}for(var r=t.getParent();r;r=r.isA("sap.ui.core.UIComponent")?r.oContainer:r.getParent()){if(r.isA("sap.ui.core.Control")){if(!r.getVisible()){return false}var i=r.getDomRef();if(i&&!i.contains(n)){return false}}if(r===e){return true}}}function u(t){if(t.id===w||t.id===I){return}var o=t.getAttribute(P);if(o){let n;if(r){n=g.getElementById(o);if(n&&s(r,n,t)){return}}if(t===e||a(t)){j(t)}else if(n&&t.hasAttribute(E)){j(t)}h.trackFocusForPreservedElement(t);i.append(t)}else if(n&&t.id){h.trackFocusForPreservedElement(t);A.markPreservableContent(jQuery(t),t.id);i.append(t);return}if(!t.hasAttribute(D)){var l=t.firstChild;while(l){t=l;l=l.nextSibling;if(t.nodeType===1){u(t)}}}}l.start(e.id+"---preserveContent","preserveContent for "+e.id,["rendering","preserve"]);if(t){u(e)}else{jQuery(e).children().each(function(e,t){u(t)})}l.end(e.id+"---preserveContent")};A.findPreservedContent=function(e){o(typeof e==="string","sId must be a string");var t=O(),n=t.children("["+P+"='"+e.replace(/(:|\.)/g,"\\$1")+"']");return n};A.markPreservableContent=function(e,t){e.attr(P,t)};A.isPreservedContent=function(e){return e&&e.getAttribute(P)&&e.parentNode&&e.parentNode.id==w};A.getPreserveAreaRef=function(){return O()[0]};var N="data-sap-ui-template";A.markInlineTemplate=function(e){e.attr(N,"")};A.isInlineTemplate=function(e){return e&&e.hasAttribute(N)};A.getApiVersion=function(e){return e&&e.hasOwnProperty("apiVersion")?e.apiVersion:1};A.canSkipRendering=function(e,t){var n=this.getRenderer(e);var r=this.getApiVersion(n)==4;if(!r&&t!=2){return false}var i=r&&!e.hasRenderingDelegate();if(t){var a=e.getDomRef();if(a){a.toggleAttribute(E,!i)}}return i};function _(e,n){var r=n.getId();e.attr("data-sap-ui",r);if(t.isObjectA(n,"sap.ui.core.Control")&&!A.canSkipRendering(n)){e.attr(E,"")}if(n.__slot){e.attr("slot",n.__slot)}n.getCustomData().forEach(function(t){var r=t._checkWriteToDom(n);if(r){e.attr(r.key.toLowerCase(),r.value)}});var i=n.getDragDropConfig().some(function(e){return e.isDraggable(n)});if(!i){var a=n.getParent();if(a&&a.getDragDropConfig){i=a.getDragDropConfig().some(function(e){return e.isDraggable(n)})}}if(i){e.attr("draggable","true");e.attr("data-sap-ui-draggable","true")}return this}var M={before:"beforebegin",prepend:"afterbegin",append:"beforeend",after:"afterend"};function x(e,t,n){if(typeof n=="string"){e.insertAdjacentHTML(M[t],n)}else{e[t](n)}}function k(e){var t=e.getMetadata();var n=!e.getVisible()&&t.getProperty("visible")._oParent.getName()=="sap.ui.core.Control";return n?d:t.getRenderer()}return A},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/Renderer", ["sap/base/Log","sap/base/util/isPlainObject","sap/base/util/ObjectPath","sap/base/assert","sap/base/util/extend","sap/ui/core/Configuration"],function(e,r,t,n,a,i){"use strict";var s={};var u;function c(e,i){n(this!=null,"BaseRenderer must be a non-null object");n(typeof e==="string"&&e,"Renderer.extend must be called with a non-empty name for the new renderer");n(i==null||r(i)&&Object.keys(i).every(function(e){return i[e]!==undefined}),"oRendererInfo can be omitted or must be a plain object without any undefined property values");var s=Object.create(this);s.extend=c;a(s,i);t.set(e,s);return s}s.extend=function(e,r){if(typeof e==="string"){return c.call(this,e,r)}else if(this===s){var t=Object.create(e||null);t._super=e;t.extend=c;return t}else{throw new TypeError("The signature extend(BaseRenderer) without a name can only be called on sap.ui.core.Renderer")}};s.getTextAlign=function(r,t){u=sap.ui.require("sap/ui/core/library");if(!u){e.warning("Synchronous loading of a library.js. Ensure that 'sap/ui/core/library.js' is loaded"+" before sap.ui.core.Renderer#getTextAlign is called.","SyncXHR",null,function(){return{type:"SyncXHR",name:"renderer-getTextAlign"}});u=sap.ui.requireSync("sap/ui/core/library")}var n=u.TextAlign;var a=u.TextDirection;var s="",c=i.getRTL();switch(r){case n.End:switch(t){case a.LTR:s="right";break;case a.RTL:s="left";break;default:s=c?"left":"right";break}break;case n.Begin:switch(t){case a.LTR:s="left";break;case a.RTL:s="right";break;default:s=c?"right":"left";break}break;case n.Right:if(!c||t==a.LTR){s="right"}break;case n.Center:s="center";break;case n.Left:if(c||t==a.RTL){s="left"}break}return s};return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/UIAreaRegistry", ["sap/base/Log","sap/ui/base/ManagedObjectRegistry"],(r,e)=>{"use strict";const a=function(e,a,t){var i="adding UIArea with duplicate id '"+e+"'";r.error(i);throw new Error("Error: "+i)};const t=e.create({onDuplicate:a});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/core/util/_LocalizationHelper", ["sap/base/Event","sap/base/Log","sap/base/i18n/Formatting","sap/base/i18n/Localization","sap/ui/thirdparty/jquery"],(t,e,n,o,jQuery)=>{"use strict";const a={};function i(){let t=[];for(const e of Object.values(a)){t=[...t,...Object.values(e())]}return t}function s(n){let o="LocalizationChanged";o="localizationChanged";const a=t.getParameters(n),s=jQuery.Event(o,{changes:a}),l=i(),r=a.rtl!==undefined;e.info("localization settings changed: "+Object.keys(a).join(","),null,"sap/ui/core/util/LocalizationHelper");if(r){document.documentElement.setAttribute("dir",a.rtl?"rtl":"ltr");e.info("RTL mode "+a.rtl?"activated":"deactivated")}for(const t of l){for(const e in t.oModels){const n=t.oModels[e];n?._handleLocalizationChange?.()}}for(const t of l){for(const e in t.mBindingInfos){const n=t.mBindingInfos[e];const o=n.parts;if(o){for(let t=0;t<o.length;t++){n.type?._handleLocalizationChange?.()}n.modelChangeHandler?.()}}if(r&&t.isA("sap.ui.core.UIArea")){t.invalidate()}if(t.isA("sap.ui.core.Element")){s._bNoReturnValue=true;t._handleEvent(s)}}}n.attachChange(s);o.attachChange(s);const l={init(){const t=o.getRTL()?"rtl":"ltr";document.documentElement.setAttribute("dir",t);e.info("Content direction set to '"+t+"'",null,"sap/ui/core/util/_LocalizationHelper")},registerForUpdate(t,e){a[t]=e}};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/dom/jquery/Selectors", ["sap/ui/thirdparty/jquery"],function(jQuery){"use strict";function e(e,t){var r=Object.getOwnPropertyDescriptor(e,t);return r&&r.value}
/*!
	 * The following functions are taken from jQuery UI 1.8.17 but modified
	 *
	 * Copyright 2011, AUTHORS.txt (http://jqueryui.com/about)
	 * Dual licensed under the MIT or GPL Version 2 licenses.
	 * http://jquery.org/license
	 *
	 * http://docs.jquery.com/UI
	 */function t(e){var t=jQuery(e).offsetParent();var r=false;var a=jQuery(e).parents().filter(function(){if(this===t){r=true}return r});return!jQuery(e).add(a).filter(function(){return jQuery.css(this,"visibility")==="hidden"||jQuery.expr.pseudos.hidden(this)}).length}function r(e,r){var a=e.nodeName.toLowerCase();if(a==="area"){var s=e.parentNode,n=s.name,i;if(!e.href||!n||s.nodeName.toLowerCase()!=="map"){return false}i=jQuery("img[usemap='#"+n+"']")[0];return!!i&&t(i)}return(/input|select|textarea|button|object/.test(a)?!e.disabled:a=="a"?e.href||r:r)&&t(e)}if(!e(jQuery.expr.pseudos,"focusable")){
/*!
		 * The following function is taken from jQuery UI 1.8.17
		 *
		 * Copyright 2011, AUTHORS.txt (http://jqueryui.com/about)
		 * Dual licensed under the MIT or GPL Version 2 licenses.
		 * http://jquery.org/license
		 *
		 * http://docs.jquery.com/UI
		 *
		 * But since visible is modified, focusable is different from the jQuery UI version too.
		 */
jQuery.expr.pseudos.focusable=function(e){return r(e,!isNaN(jQuery.attr(e,"tabindex")))}}if(!e(jQuery.expr.pseudos,"sapTabbable")){
/*!
		 * The following function is taken from
		 * jQuery UI Core 1.11.1
		 * http://jqueryui.com
		 *
		 * Copyright 2014 jQuery Foundation and other contributors
		 * Released under the MIT license.
		 * http://jquery.org/license
		 *
		 * http://api.jqueryui.com/category/ui-core/
		 */
jQuery.expr.pseudos.sapTabbable=function(e){var t=jQuery.attr(e,"tabindex"),a=isNaN(t);return(a||t>=0)&&r(e,!a)}}if(!e(jQuery.expr.pseudos,"sapFocusable")){jQuery.expr.pseudos.sapFocusable=function(e){return r(e,!isNaN(jQuery.attr(e,"tabindex")))}}return jQuery});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/events/ControlEvents", ["sap/ui/thirdparty/jquery"],function(jQuery){"use strict";var e={};e.events=["click","dblclick","contextmenu","focusin","focusout","keydown","keypress","keyup","mousedown","mouseout","mouseover","mouseup","select","selectstart","dragstart","dragenter","dragover","dragleave","dragend","drop","compositionstart","compositionend","paste","cut","input","change"];e.bindAnyEvent=function(n){if(n){jQuery(document).on(e.events.join(" "),n)}};e.unbindAnyEvent=function n(t){if(t){jQuery(document).off(e.events.join(" "),t)}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/events/F6Navigation", ["sap/ui/thirdparty/jquery","sap/ui/events/PseudoEvents","sap/ui/dom/jquery/Selectors"],function(jQuery,e){"use strict";var t={};var n=false;t.fastNavigationKey="sap-ui-fastnavgroup";function r(e){var t=document.querySelector("html");var n,r;while(e&&e!==t){if(e.getAttribute("data-sap-ui-customfastnavgroup")==="true"){r=e}if(e.getAttribute("data-sap-ui-fastnavgroup")==="true"){n=n||e}if(r){break}e=e.assignedSlot||e.parentElement||e.parentNode.host}return r||n}function i(e){if(e.activeElement&&e.activeElement.shadowRoot){return i(e.activeElement.shadowRoot)}return e.activeElement}function s(e,t){var n=e.parentElement||e.parentNode||e.host;if(n&&n!==t){return s(n,t)}return e!==document}function a(e){var t=e.element;var n=e.skipChild;var r=e.scope;if(t.id==="sap-ui-static"){n=true}if(!n){if(t.shadowRoot&&t.shadowRoot.firstElementChild){return t.shadowRoot.firstElementChild}else if(t.assignedElements&&t.assignedElements().length){return t.assignedElements()[0]}else if(t.firstElementChild){return t.firstElementChild}}if(t.assignedSlot){var i=t.assignedSlot.assignedElements();var s=i.indexOf(t)+1;if(s<i.length){return i[s]}}else if(t.nextElementSibling){return t.nextElementSibling}if(t.parentNode===r){return r}return a({element:t.assignedSlot||t.parentElement||t.parentNode||t.host,skipChild:true,scope:r})}function l(e){var t=e.element;var n=e.scope;var r=e.checkChildren||t===n;var i;if(t.id==="sap-ui-static"){r=false}if(r){var s;if(t.shadowRoot){s=t.shadowRoot}else if(t.lastElementChild){s=t.lastElementChild}else if(t.assignedElements&&t.assignedElements().length){i=t.assignedElements();s=i[i.length-1]}if(s){return l({element:s,checkChildren:true,scope:n})}else{return t.nodeType===11?t.host:t}}if(t.assignedSlot){i=t.assignedSlot.assignedElements();var a=i.indexOf(t)-1;if(a>=0){return l({element:i[a],checkChildren:true,scope:n})}}else if(t.previousElementSibling){return l({element:t.previousElementSibling,checkChildren:true,scope:n})}var o;if(t.assignedSlot){o=t.assignedSlot}else if(t.parentElement){o=t.parentElement}else if(t.parentNode){o=t.parentNode.host}return o}function o(e,t,r){var i;if(r){i=a({element:e,scope:t})}else{i=l({element:e,scope:t})}if(i===t){n=true}if(jQuery.expr.pseudos.sapTabbable(i)){var s={element:i,startOver:n};n=false;return s}else{return o(i,t,r)}}t.handleF6GroupNavigation=function(t,n){var a=e.events.sapskipforward,l=e.events.sapskipback,u=a.aTypes.includes(t.type)&&a.fnCheck(t),d=u||l.aTypes.includes(t.type)&&l.fnCheck(t),f=null,p;if(!d||t.isMarked("sapui5_handledF6GroupNavigation")||t.isMarked()||t.isDefaultPrevented()){return}t.setMark("sapui5_handledF6GroupNavigation");t.setMarked();t.preventDefault();if(n&&n.skip){return}var v=n&&n.target?n.target:i(document);var c;if(n&&n.scope){c=n.scope}else{c=document.documentElement}if(!s(v,c)){return}var m=r(v);var h;var g;p=v;do{g=o(p,c,u);p=g.element;h=r(p)}while(!g.startOver&&m===h);if(!u){var E,k;do{p=E||p;g=o(p,c,u);E=g.element;k=r(E)}while(k===h&&!g.startOver)}if(h&&h.getAttribute("data-sap-ui-customfastnavgroup")==="true"&&h.id){var C=sap.ui.require("sap/ui/core/Element");var S=C?.getElementById(h.id);if(S){f=jQuery.Event("BeforeFastNavigationFocus");f.target=p;f.source=v;f.forward=u;S._handleEvent(f)}}if(!f||!f.isDefaultPrevented()){p.focus()}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/events/KeyCodes", [],function(){"use strict";var A={BACKSPACE:8,TAB:9,ENTER:13,SHIFT:16,CONTROL:17,ALT:18,BREAK:19,CAPS_LOCK:20,ESCAPE:27,SPACE:32,PAGE_UP:33,PAGE_DOWN:34,END:35,HOME:36,ARROW_LEFT:37,ARROW_UP:38,ARROW_RIGHT:39,ARROW_DOWN:40,PRINT:44,INSERT:45,DELETE:46,DIGIT_0:48,DIGIT_1:49,DIGIT_2:50,DIGIT_3:51,DIGIT_4:52,DIGIT_5:53,DIGIT_6:54,DIGIT_7:55,DIGIT_8:56,DIGIT_9:57,A:65,B:66,C:67,D:68,E:69,F:70,G:71,H:72,I:73,J:74,K:75,L:76,M:77,N:78,O:79,P:80,Q:81,R:82,S:83,T:84,U:85,V:86,W:87,X:88,Y:89,Z:90,WINDOWS:91,CONTEXT_MENU:93,TURN_OFF:94,SLEEP:95,NUMPAD_0:96,NUMPAD_1:97,NUMPAD_2:98,NUMPAD_3:99,NUMPAD_4:100,NUMPAD_5:101,NUMPAD_6:102,NUMPAD_7:103,NUMPAD_8:104,NUMPAD_9:105,NUMPAD_ASTERISK:106,NUMPAD_PLUS:107,NUMPAD_MINUS:109,NUMPAD_COMMA:110,NUMPAD_SLASH:111,F1:112,F2:113,F3:114,F4:115,F5:116,F6:117,F7:118,F8:119,F9:120,F10:121,F11:122,F12:123,NUM_LOCK:144,SCROLL_LOCK:145,OPEN_BRACKET:186,PLUS:187,COMMA:188,SLASH:189,DOT:190,PIPE:191,SEMICOLON:192,MINUS:219,GREAT_ACCENT:220,EQUALS:221,SINGLE_QUOTE:222,BACKSLASH:226};return A});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/events/PseudoEvents", ["sap/base/i18n/Localization","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(e,s,jQuery){"use strict";var a={};function r(e,s,a,r){return e.shiftKey==r&&e.altKey==a&&o(e)==s}function n(e){return e.shiftKey||e.altKey||o(e)}function o(e){return!!(e.metaKey||e.ctrlKey)}a.events={sapdown:{sName:"sapdown",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="ArrowDown":e.keyCode==s.ARROW_DOWN)&&!n(e)}},sapdownmodifiers:{sName:"sapdownmodifiers",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="ArrowDown":e.keyCode==s.ARROW_DOWN)&&n(e)}},sapshow:{sName:"sapshow",aTypes:["keydown"],fnCheck:function(e){if(e.key){return e.key==="F4"&&!n(e)||e.key==="ArrowDown"&&r(e,false,true,false)}return e.keyCode==s.F4&&!n(e)||e.keyCode==s.ARROW_DOWN&&r(e,false,true,false)}},sapup:{sName:"sapup",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="ArrowUp":e.keyCode==s.ARROW_UP)&&!n(e)}},sapupmodifiers:{sName:"sapupmodifiers",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="ArrowUp":e.keyCode==s.ARROW_UP)&&n(e)}},saphide:{sName:"saphide",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="ArrowUp":e.keyCode==s.ARROW_UP)&&r(e,false,true,false)}},sapleft:{sName:"sapleft",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="ArrowLeft":e.keyCode==s.ARROW_LEFT)&&!n(e)}},sapleftmodifiers:{sName:"sapleftmodifiers",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="ArrowLeft":e.keyCode==s.ARROW_LEFT)&&n(e)}},sapright:{sName:"sapright",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="ArrowRight":e.keyCode==s.ARROW_RIGHT)&&!n(e)}},saprightmodifiers:{sName:"saprightmodifiers",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="ArrowRight":e.keyCode==s.ARROW_RIGHT)&&n(e)}},saphome:{sName:"saphome",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="Home":e.keyCode==s.HOME)&&!n(e)}},saphomemodifiers:{sName:"saphomemodifiers",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="Home":e.keyCode==s.HOME)&&n(e)}},saptop:{sName:"saptop",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="Home":e.keyCode==s.HOME)&&r(e,true,false,false)}},sapend:{sName:"sapend",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="End":e.keyCode==s.END)&&!n(e)}},sapendmodifiers:{sName:"sapendmodifiers",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="End":e.keyCode==s.END)&&n(e)}},sapbottom:{sName:"sapbottom",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="End":e.keyCode==s.END)&&r(e,true,false,false)}},sappageup:{sName:"sappageup",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="PageUp":e.keyCode==s.PAGE_UP)&&!n(e)}},sappageupmodifiers:{sName:"sappageupmodifiers",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="PageUp":e.keyCode==s.PAGE_UP)&&n(e)}},sappagedown:{sName:"sappagedown",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="PageDown":e.keyCode==s.PAGE_DOWN)&&!n(e)}},sappagedownmodifiers:{sName:"sappagedownmodifiers",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="PageDown":e.keyCode==s.PAGE_DOWN)&&n(e)}},sapselect:{sName:"sapselect",aTypes:["keydown"],fnCheck:function(e){if(e.key){return(e.key==="Enter"||e.key===" ")&&!n(e)}return(e.keyCode==s.ENTER||e.keyCode==s.SPACE)&&!n(e)}},sapselectmodifiers:{sName:"sapselectmodifiers",aTypes:["keydown"],fnCheck:function(e){if(e.key){return(e.key==="Enter"||e.key===" ")&&n(e)}return(e.keyCode==s.ENTER||e.keyCode==s.SPACE)&&n(e)}},sapspace:{sName:"sapspace",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key===" ":e.keyCode==s.SPACE)&&!n(e)}},sapspacemodifiers:{sName:"sapspacemodifiers",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key===" ":e.keyCode==s.SPACE)&&n(e)}},sapenter:{sName:"sapenter",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="Enter":e.keyCode==s.ENTER)&&!n(e)}},sapentermodifiers:{sName:"sapentermodifiers",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="Enter":e.keyCode==s.ENTER)&&n(e)}},sapbackspace:{sName:"sapbackspace",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="Backspace":e.keyCode==s.BACKSPACE)&&!n(e)}},sapbackspacemodifiers:{sName:"sapbackspacemodifiers",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="Backspace":e.keyCode==s.BACKSPACE)&&n(e)}},sapdelete:{sName:"sapdelete",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="Delete":e.keyCode==s.DELETE)&&!n(e)}},sapdeletemodifiers:{sName:"sapdeletemodifiers",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="Delete":e.keyCode==s.DELETE)&&n(e)}},sapexpand:{sName:"sapexpand",aTypes:["keydown"],fnCheck:function(e){return(e.key?(e.key==="+"||e.key==="Add")&&e.location==="NUMPAD":e.keyCode==s.NUMPAD_PLUS)&&!n(e)}},sapexpandmodifiers:{sName:"sapexpandmodifiers",aTypes:["keydown"],fnCheck:function(e){return(e.key?(e.key==="+"||e.key==="Add")&&e.location==="NUMPAD":e.keyCode==s.NUMPAD_PLUS)&&n(e)}},sapcollapse:{sName:"sapcollapse",aTypes:["keydown"],fnCheck:function(e){return(e.key?(e.key==="-"||e.key==="Subtract")&&e.location==="NUMPAD":e.keyCode==s.NUMPAD_MINUS)&&!n(e)}},sapcollapsemodifiers:{sName:"sapcollapsemodifiers",aTypes:["keydown"],fnCheck:function(e){return(e.key?(e.key==="-"||e.key==="Subtract")&&e.location==="NUMPAD":e.keyCode==s.NUMPAD_MINUS)&&n(e)}},sapcollapseall:{sName:"sapcollapseall",aTypes:["keydown"],fnCheck:function(e){return(e.key?(e.key==="*"||e.key==="Multiply")&&e.location==="NUMPAD":e.keyCode==s.NUMPAD_ASTERISK)&&!n(e)}},sapescape:{sName:"sapescape",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="Escape":e.keyCode==s.ESCAPE)&&!n(e)}},saptabnext:{sName:"saptabnext",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="Tab":e.keyCode==s.TAB)&&!n(e)}},saptabprevious:{sName:"saptabprevious",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="Tab":e.keyCode==s.TAB)&&r(e,false,false,true)}},sapskipforward:{sName:"sapskipforward",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="F6":e.keyCode==s.F6)&&!n(e)||(e.key?e.key==="ArrowDown":e.keyCode==s.ARROW_DOWN)&&r(e,true,true,false)}},sapskipback:{sName:"sapskipback",aTypes:["keydown"],fnCheck:function(e){return(e.key?e.key==="F6":e.keyCode==s.F6)&&r(e,false,false,true)||(e.key?e.key==="ArrowUp":e.keyCode==s.ARROW_UP)&&r(e,true,true,false)}},sapdecrease:{sName:"sapdecrease",aTypes:["keydown"],fnCheck:function(a){var r=e.getRTL();if(a.key){if(r){return(a.key==="ArrowRight"||a.key==="ArrowDown")&&!n(a)}else{return(a.key==="ArrowLeft"||a.key==="ArrowDown")&&!n(a)}}var o=r?s.ARROW_RIGHT:s.ARROW_LEFT;return(a.keyCode==o||a.keyCode==s.ARROW_DOWN)&&!n(a)}},sapminus:{sName:"sapminus",aTypes:["keypress"],fnCheck:function(e){return e.key?e.key==="-"||e.key==="Subtract":String.fromCharCode(e.which)=="-"}},sapdecreasemodifiers:{sName:"sapdecreasemodifiers",aTypes:["keydown"],fnCheck:function(a){var r=e.getRTL();if(a.key){if(r){return(a.key==="ArrowRight"||a.key==="ArrowDown")&&n(a)}else{return(a.key==="ArrowLeft"||a.key==="ArrowDown")&&n(a)}}var o=r?s.ARROW_RIGHT:s.ARROW_LEFT;return(a.keyCode==o||a.keyCode==s.ARROW_DOWN)&&n(a)}},sapincrease:{sName:"sapincrease",aTypes:["keydown"],fnCheck:function(a){var r=e.getRTL();var o;if(a.key){if(r){return(a.key==="ArrowLeft"||a.key==="ArrowUp")&&!n(a)}else{return(a.key==="ArrowRight"||a.key==="ArrowUp")&&!n(a)}}o=r?s.ARROW_LEFT:s.ARROW_RIGHT;return(a.keyCode==o||a.keyCode==s.ARROW_UP)&&!n(a)}},sapplus:{sName:"sapplus",aTypes:["keypress"],fnCheck:function(e){return e.key?e.key==="+"||e.key==="Add":String.fromCharCode(e.which)=="+"}},sapincreasemodifiers:{sName:"sapincreasemodifiers",aTypes:["keydown"],fnCheck:function(a){var r=e.getRTL();if(a.key){if(r){return(a.key==="ArrowLeft"||a.key==="ArrowUp")&&n(a)}else{return(a.key==="ArrowRight"||a.key==="ArrowUp")&&n(a)}}var o=r?s.ARROW_LEFT:s.ARROW_RIGHT;return(a.keyCode==o||a.keyCode==s.ARROW_UP)&&n(a)}},sapprevious:{sName:"sapprevious",aTypes:["keydown"],fnCheck:function(a){var r=e.getRTL();if(a.key){if(r){return(a.key==="ArrowRight"||a.key==="ArrowUp")&&!n(a)}else{return(a.key==="ArrowLeft"||a.key==="ArrowUp")&&!n(a)}}var o=r?s.ARROW_RIGHT:s.ARROW_LEFT;return(a.keyCode==o||a.keyCode==s.ARROW_UP)&&!n(a)}},sappreviousmodifiers:{sName:"sappreviousmodifiers",aTypes:["keydown"],fnCheck:function(a){var r=e.getRTL();if(a.key){if(r){return(a.key==="ArrowRight"||a.key==="ArrowUp")&&n(a)}else{return(a.key==="ArrowLeft"||a.key==="ArrowUp")&&n(a)}}var o=r?s.ARROW_RIGHT:s.ARROW_LEFT;return(a.keyCode==o||a.keyCode==s.ARROW_UP)&&n(a)}},sapnext:{sName:"sapnext",aTypes:["keydown"],fnCheck:function(a){var r=e.getRTL();if(a.key){if(r){return(a.key==="ArrowLeft"||a.key==="ArrowDown")&&!n(a)}else{return(a.key==="ArrowRight"||a.key==="ArrowDown")&&!n(a)}}var o=r?s.ARROW_LEFT:s.ARROW_RIGHT;return(a.keyCode==o||a.keyCode==s.ARROW_DOWN)&&!n(a)}},sapnextmodifiers:{sName:"sapnextmodifiers",aTypes:["keydown"],fnCheck:function(a){var r=e.getRTL();if(a.key){if(r){return(a.key==="ArrowLeft"||a.key==="ArrowDown")&&n(a)}else{return(a.key==="ArrowRight"||a.key==="ArrowDown")&&n(a)}}var o=r?s.ARROW_LEFT:s.ARROW_RIGHT;return(a.keyCode==o||a.keyCode==s.ARROW_DOWN)&&n(a)}},sapdelayeddoubleclick:{sName:"sapdelayeddoubleclick",aTypes:["click"],fnCheck:function(e){var s=jQuery(e.target);var a=e.timeStamp;var r=s.data("sapdelayeddoubleclick_lastClickTimestamp");var n=r||0;s.data("sapdelayeddoubleclick_lastClickTimestamp",a);var o=a-n;return o>=300&&o<=1300}}};a.order=["sapdown","sapdownmodifiers","sapshow","sapup","sapupmodifiers","saphide","sapleft","sapleftmodifiers","sapright","saprightmodifiers","saphome","saphomemodifiers","saptop","sapend","sapendmodifiers","sapbottom","sappageup","sappageupmodifiers","sappagedown","sappagedownmodifiers","sapselect","sapselectmodifiers","sapspace","sapspacemodifiers","sapenter","sapentermodifiers","sapexpand","sapbackspace","sapbackspacemodifiers","sapdelete","sapdeletemodifiers","sapexpandmodifiers","sapcollapse","sapcollapsemodifiers","sapcollapseall","sapescape","saptabnext","saptabprevious","sapskipforward","sapskipback","sapprevious","sappreviousmodifiers","sapnext","sapnextmodifiers","sapdecrease","sapminus","sapdecreasemodifiers","sapincrease","sapplus","sapincreasemodifiers","sapdelayeddoubleclick"];a.getBasicTypes=function(){var e=a.events,s=[];for(var r in e){if(e[r].aTypes){for(var n=0,o=e[r].aTypes.length;n<o;n++){var k=e[r].aTypes[n];if(s.indexOf(k)==-1){s.push(k)}}}}this.getBasicTypes=function(){return s.slice()};return s};a.addEvent=function(e){a.events[e.sName]=e;a.order.push(e.sName)};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/events/TouchToMouseMapping", [],function(){"use strict";var e={};e.init=function(t){var n=t,r=false,u=null,o=false,i,a,c=0;var s=["mousedown","mouseover","mouseup","mouseout","click"];var v=function(e,t){if(!r){return}var o=t.type=="touchend"?t.changedTouches[0]:t.touches[0];var i=n.createEvent("MouseEvent");i.initMouseEvent(e,true,true,window,t.detail,o.screenX,o.screenY,o.clientX,o.clientY,t.ctrlKey,t.shiftKey,t.altKey,t.metaKey,t.button,t.relatedTarget);i.isSynthetic=true;window.setTimeout(function(){u.dispatchEvent(i)},0)};var f=function(e){return e.target.tagName.match(/input|textarea|select/i)};var d=function(e){if(!e.isSynthetic&&!f(e)){e.stopPropagation();e.preventDefault()}};var l=function(e){var t=e.touches,n;r=t.length==1&&!f(e);o=false;if(r){n=t[0];u=n.target;if(u.nodeType===3){u=u.parentNode}i=n.clientX;a=n.clientY;v("mousedown",e)}};var h=function(e){var t;if(r){t=e.touches[0];if(Math.abs(t.clientX-i)>10||Math.abs(t.clientY-a)>10){o=true}if(o){v("mousemove",e)}}};var m=function(e){v("mouseup",e);if(!o){v("click",e)}};var E=function(e){v("mouseup",e)};for(;c<s.length;c++){n.addEventListener(s[c],d,true)}n.addEventListener("touchstart",l,true);n.addEventListener("touchmove",h,true);n.addEventListener("touchend",m,true);n.addEventListener("touchcancel",E,true);e.disableTouchToMouseHandling=function(){var e=0;n.removeEventListener("touchstart",l,true);n.removeEventListener("touchmove",h,true);n.removeEventListener("touchend",m,true);n.removeEventListener("touchcancel",E,true);for(;e<s.length;e++){n.removeEventListener(s[e],d,true)}}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/events/checkMouseEnterOrLeave", [],function(){"use strict";var e=function e(r,t){if(r.type!="mouseover"&&r.type!="mouseout"){return false}var a=false;var u=t;var n=r.relatedTarget;try{while(n&&n!==u){n=n.parentNode}if(n!==u){a=true}}catch(e){}return a};return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/events/jquery/EventSimulation", ["sap/base/util/Version","sap/ui/core/Element","sap/ui/events/PseudoEvents","sap/ui/events/checkMouseEnterOrLeave","sap/ui/events/ControlEvents","sap/ui/Device","sap/ui/events/TouchToMouseMapping","sap/ui/thirdparty/jquery","sap/ui/thirdparty/jquery-mobile-custom"],function(e,t,n,o,a,s,i,jQuery){"use strict";var u={};var r=e(jQuery.fn.jquery);u.aAdditionalControlEvents=[];u.aAdditionalPseudoEvents=[];u._createSimulatedEvent=function(e,t,n){var o="__"+e+"Handler";var a="sap"+e;this.aAdditionalControlEvents.push(a);this.aAdditionalPseudoEvents.push({sName:e,aTypes:[a],fnCheck:function(e){return true}});jQuery.event.special[a]={add:function(o){var s=this,i=jQuery(this),u={domRef:s,eventName:e,sapEventName:a,eventHandle:o};var r=function(e){n(e,u)};o.__sapSimulatedEventHandler=r;for(var c=0;c<t.length;c++){i.on(t[c],r)}},remove:function(e){var n=jQuery(this);var a=e.__sapSimulatedEventHandler;n.removeData(o+e.guid);for(var s=0;s<t.length;s++){jQuery.event.remove(this,t[s],a)}}}};u._handleMouseToTouchEvent=function(e,n){if(e.isMarked("delayedMouseEvent")){return}var a=jQuery(n.domRef),s=t.closestTo(e.target),i=a.data("__touchstart_control"),u=i&&window.document.getElementById(i);if(e.type==="mouseout"&&!o(e,n.domRef)&&(!u||!o(e,u))){return}var r=jQuery.event.fix(e.originalEvent||e);r.type=n.sapEventName;if(r.isMarked("firstUIArea")){r.setMark("handledByUIArea",false)}var c=[{identifier:1,pageX:r.pageX,pageY:r.pageY,clientX:r.clientX,clientY:r.clientY,screenX:r.screenX,screenY:r.screenY,target:r.target,radiusX:1,radiusY:1,rotationAngle:0}];switch(n.eventName){case"touchstart":if(s){a.data("__touchstart_control",s.getId())}case"touchmove":r.touches=r.changedTouches=r.targetTouches=c;break;case"touchend":r.changedTouches=c;r.touches=r.targetTouches=[];break}if(n.eventName==="touchstart"||a.data("__touch_in_progress")){a.data("__touch_in_progress","X");if(e.type==="mouseout"){r.setMarked("fromMouseout")}if(n.eventName!=="touchstart"&&(!s||s.getId()!==i)){r.setMark("scopeCheckId",i)}if(e.type!=="dragstart"){n.eventHandle.handler.call(n.domRef,r)}if((n.eventName==="touchend"||e.type==="dragstart")&&!r.isMarked("fromMouseout")){a.removeData("__touch_in_progress");a.removeData("__touchstart_control")}}};u._initTouchEventSimulation=function(){this._createSimulatedEvent("touchstart",["mousedown"],this._handleMouseToTouchEvent);this._createSimulatedEvent("touchend",["mouseup","mouseout"],this._handleMouseToTouchEvent);this._createSimulatedEvent("touchmove",["mousemove","dragstart"],this._handleMouseToTouchEvent)};u._initContextMenuSimulation=function(){var e=function(e,t){var n=jQuery.event.fix(e.originalEvent||e);n.type=t.sapEventName;if(!window.getSelection||!window.getSelection()||window.getSelection().toString()===""){t.eventHandle.handler.call(t.domRef,n)}};this._createSimulatedEvent("contextmenu",["taphold"],e)};u._initMouseEventSimulation=function(){var e=false,t=jQuery.vmouse.moveDistanceThreshold,n,o,a,s;var i=function(e,t,n){var o=jQuery.event.fix(e.originalEvent||e);o.type=t.sapEventName;delete o.touches;delete o.changedTouches;delete o.targetTouches;o.screenX=n.screenX;o.screenY=n.screenY;o.clientX=n.clientX;o.clientY=n.clientY;o.ctrlKey=n.ctrlKey;o.altKey=n.altKey;o.shiftKey=n.shiftKey;o.button=0;return o};var u=function(a,s){if(a.isMarked("handledByTouchToMouse")){return}a.setMarked("handledByTouchToMouse");if(!e){var u=a.originalEvent.touches[0];e=Math.abs(u.pageX-n)>t||Math.abs(u.pageY-o)>t}var r=i(a,s,a.touches[0]);setTimeout(function(){r.setMark("handledByUIArea",false);s.eventHandle.handler.call(s.domRef,r)},0)};var r=function(t,u){if(t.isMarked("handledByTouchToMouse")){return}t.setMarked("handledByTouchToMouse");var r,c,d;function l(){return i(t,u,u.eventName==="mouseup"?t.changedTouches[0]:t.touches[0])}if(t.type==="touchstart"){var h=t.originalEvent.touches[0];e=false;n=h.pageX;o=h.pageY;a=Math.round(h.pageX-jQuery(t.target).offset().left);s=Math.round(h.pageY-jQuery(t.target).offset().top);r=l();setTimeout(function(){r.setMark("handledByUIArea",false);u.eventHandle.handler.call(u.domRef,r)},0)}else if(t.type==="touchend"){c=l();d=!e;setTimeout(function(){c.setMark("handledByUIArea",false);u.eventHandle.handler.call(u.domRef,c);if(d){c.type="click";c.getPseudoTypes=jQuery.Event.prototype.getPseudoTypes;c.setMark("handledByUIArea",false);c.offsetX=a;c.offsetY=s;u.eventHandle.handler.call(u.domRef,c)}},0)}};this._createSimulatedEvent("mousedown",["touchstart"],r);this._createSimulatedEvent("mousemove",["touchmove"],u);this._createSimulatedEvent("mouseup",["touchend","touchcancel"],r)};u._init=function(e){this.aAdditionalControlEvents.push("swipe","tap","swipeleft","swiperight","scrollstart","scrollstop");this.aAdditionalPseudoEvents.push({sName:"swipebegin",aTypes:["swipeleft","swiperight"],fnCheck:function(e){var t=sap.ui.getCore().getConfiguration().getRTL();return t&&e.type==="swiperight"||!t&&e.type==="swipeleft"}});this.aAdditionalPseudoEvents.push({sName:"swipeend",aTypes:["swipeleft","swiperight"],fnCheck:function(e){var t=sap.ui.getCore().getConfiguration().getRTL();return!t&&e.type==="swiperight"||t&&e.type==="swipeleft"}});if(r.compareTo("1.9.1")<0){e=e.concat(this.aAdditionalControlEvents)}else{e=this.aAdditionalControlEvents.concat(e)}for(var t=0;t<this.aAdditionalPseudoEvents.length;t++){n.addEvent(this.aAdditionalPseudoEvents[t])}return e};if(s.browser.webkit&&/Mobile/.test(navigator.userAgent)&&s.support.touch){i.init(window.document);u.disableTouchToMouseHandling=i.disableTouchToMouseHandling}if(!u.disableTouchToMouseHandling){u.disableTouchToMouseHandling=function(){}}if(s.support.touch){a.events.push("touchstart","touchend","touchmove","touchcancel")}(function e(){u.touchEventMode="SIM";if(s.support.touch){u.touchEventMode="ON";if(r.compareTo("3.0.0")<0){jQuery.event.props.push("touches","targetTouches","changedTouches")}}u._initTouchEventSimulation();if(s.os.ios){u._initContextMenuSimulation()}if(s.support.touch){u.disableTouchToMouseHandling();u._initMouseEventSimulation()}a.events=u._init(a.events)})();return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/model/BindingMode", function(){"use strict";var e={Default:"Default",OneTime:"OneTime",OneWay:"OneWay",TwoWay:"TwoWay"};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/model/Filter", ["./FilterOperator","sap/base/Log","sap/ui/base/Object","sap/ui/core/Configuration"],function(t,e,r,i){"use strict";var a=r.extend("sap.ui.model.Filter",{constructor:function(i,s,o,l){r.call(this);if(typeof i==="object"&&!Array.isArray(i)){this.sPath=i.path;this.sOperator=i.operator;this.oValue1=i.value1;this.oValue2=i.value2;this.sVariable=i.variable;this.oCondition=i.condition;this.aFilters=i.filters||i.aFilters;this.bAnd=i.and||i.bAnd;this.fnTest=i.test;this.fnCompare=i.comparator;this.bCaseSensitive=i.caseSensitive}else{if(Array.isArray(i)){this.aFilters=i}else{this.sPath=i}if(typeof s==="boolean"){this.bAnd=s}else if(typeof s==="function"){this.fnTest=s}else{this.sOperator=s}this.oValue1=o;this.oValue2=l;if(this.sOperator===t.Any||this.sOperator===t.All){throw new Error("The filter operators 'Any' and 'All' are only supported with the parameter object notation.")}}if(this.aFilters?.includes(a.NONE)){throw new Error("Filter.NONE not allowed in multiple filter")}else if(this.oCondition&&this.oCondition===a.NONE){throw new Error("Filter.NONE not allowed as condition")}if(this.sOperator===t.Any){if(this.sVariable&&this.oCondition){this._checkLambdaArgumentTypes()}else if(!this.sVariable&&!this.oCondition){}else{throw new Error("When using the filter operator 'Any', a lambda variable and a condition have to be given or neither.")}}else if(this.sOperator===t.All){this._checkLambdaArgumentTypes()}else if(Array.isArray(this.aFilters)&&!this.sPath&&!this.sOperator&&!this.oValue1&&!this.oValue2){this._bMultiFilter=true;if(!this.aFilters.every(n)){e.error("Filter in aggregation of multi filter has to be instance of"+" sap.ui.model.Filter")}}else if(!this.aFilters&&this.sPath!==undefined&&(this.sOperator&&this.oValue1!==undefined||this.fnTest)){this._bMultiFilter=false}else{e.error("Wrong parameters defined for filter.")}}});a.NONE=new a({path:"/",test:()=>false});a.checkFilterNone=function(t){if(Array.isArray(t)&&t.length>1&&t.includes(a.NONE)){throw new Error("Filter.NONE cannot be used together with other filters")}};a.prototype._checkLambdaArgumentTypes=function(){if(!this.sVariable||typeof this.sVariable!=="string"){throw new Error("When using the filter operators 'Any' or 'All', a string has to be given as argument 'variable'.")}if(!n(this.oCondition)){throw new Error("When using the filter operator 'Any' or 'All', a valid instance of sap.ui.model.Filter has to be given as argument 'condition'.")}};function n(t){return t instanceof a}var s={Logical:"Logical",Binary:"Binary",Unary:"Unary",Lambda:"Lambda",Reference:"Reference",Literal:"Literal",Variable:"Variable",Call:"Call",Custom:"Custom"};var o={Equal:"==",NotEqual:"!=",LessThan:"<",GreaterThan:">",LessThanOrEqual:"<=",GreaterThanOrEqual:">=",And:"&&",Or:"||",Not:"!"};var l={Contains:"contains",StartsWith:"startswith",EndsWith:"endswith"};a.prototype.getAST=function(e){var r,i,a,n,h,u,f,p,c;function d(t,e,r){return{type:s.Logical,op:t,left:e,right:r}}function b(t,e,r){return{type:s.Binary,op:t,left:e,right:r}}function y(t,e){return{type:s.Unary,op:t,arg:e}}function g(t,e,r,i){return{type:s.Lambda,op:t,ref:e,variable:r,condition:i}}function A(t){return{type:s.Reference,path:t}}function E(t){return{type:s.Literal,value:t}}function N(t){return{type:s.Variable,name:t}}function O(t,e){return{type:s.Call,name:t,args:e}}if(this.aFilters){i=this.bAnd?o.And:o.Or;a=this.bAnd?"AND":"OR";r=this.aFilters[this.aFilters.length-1].getAST(e);for(var m=this.aFilters.length-2;m>=0;m--){r=d(i,this.aFilters[m].getAST(e),r)}}else{i=this.sOperator;a=this.sOperator;n=A(this.sPath);h=E(this.oValue1);switch(i){case t.EQ:r=b(o.Equal,n,h);break;case t.NE:r=b(o.NotEqual,n,h);break;case t.LT:r=b(o.LessThan,n,h);break;case t.GT:r=b(o.GreaterThan,n,h);break;case t.LE:r=b(o.LessThanOrEqual,n,h);break;case t.GE:r=b(o.GreaterThanOrEqual,n,h);break;case t.Contains:r=O(l.Contains,[n,h]);break;case t.StartsWith:r=O(l.StartsWith,[n,h]);break;case t.EndsWith:r=O(l.EndsWith,[n,h]);break;case t.NotContains:r=y(o.Not,O(l.Contains,[n,h]));break;case t.NotStartsWith:r=y(o.Not,O(l.StartsWith,[n,h]));break;case t.NotEndsWith:r=y(o.Not,O(l.EndsWith,[n,h]));break;case t.BT:u=h;f=E(this.oValue2);r=d(o.And,b(o.GreaterThanOrEqual,n,u),b(o.LessThanOrEqual,n,f));break;case t.NB:u=h;f=E(this.oValue2);r=d(o.Or,b(o.LessThan,n,u),b(o.GreaterThan,n,f));break;case t.Any:case t.All:p=N(this.sVariable);c=this.oCondition.getAST(e);r=g(i,n,p,c);break;default:throw new Error("Unknown operator: "+i)}}if(e&&!r.origin){r.origin=a}return r};a.prototype.getComparator=function(){return this.fnCompare};a.prototype.getCondition=function(){return this.oCondition};a.prototype.getOperator=function(){return this.sOperator};a.prototype.getPath=function(){return this.sPath};a.prototype.getFilters=function(){return this.aFilters&&this.aFilters.slice()};a.prototype.getTest=function(){return this.fnTest};a.prototype.getValue1=function(){return this.oValue1};a.prototype.getValue2=function(){return this.oValue2};a.prototype.getVariable=function(){return this.sVariable};a.prototype.isAnd=function(){return!!this.bAnd};a.prototype.isCaseSensitive=function(){return this.bCaseSensitive};a.defaultComparator=function(t,e){if(t==e){return 0}if(t==null||e==null){return NaN}if(typeof t=="string"&&typeof e=="string"){return t.localeCompare(e,i.getLanguageTag())}if(t<e){return-1}if(t>e){return 1}return NaN};return a});
//# sourceMappingURL=Eventing-preload-0.js.map
