/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/library","sap/ui/core/Control","sap/ui/base/ManagedObjectObserver","sap/m/library","sap/m/Toolbar","sap/m/ToolbarSeparator","sap/m/OverflowToolbar","sap/m/Button","sap/ui/core/InvisibleText","./DynamicPageTitleRenderer","sap/base/Log","sap/ui/core/Icon","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/core/InvisibleMessage","sap/ui/core/Core"],function(t,e,i,n,a,o,s,r,p,c,h,g,l,d,u,A,_){"use strict";var f=t.DynamicPageTitleArea;var b=a.ToolbarStyle;var y=e.InvisibleMessageMode;var v=i.extend("sap.f.DynamicPageTitle",{metadata:{library:"sap.f",properties:{primaryArea:{type:"sap.f.DynamicPageTitleArea",group:"Appearance",defaultValue:f.Begin,deprecated:true},areaShrinkRatio:{type:"sap.f.DynamicPageTitleShrinkRatio",group:"Appearance",defaultValue:"1:1.6:1.6"},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance"}},aggregations:{heading:{type:"sap.ui.core.Control",multiple:false},snappedHeading:{type:"sap.ui.core.Control",multiple:false},expandedHeading:{type:"sap.ui.core.Control",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},navigationActions:{type:"sap.m.Button",multiple:true,singularName:"navigationAction"},content:{type:"sap.ui.core.Control",multiple:true},snappedContent:{type:"sap.ui.core.Control",multiple:true},expandedContent:{type:"sap.ui.core.Control",multiple:true},snappedTitleOnMobile:{type:"sap.m.Title",multiple:false},breadcrumbs:{type:"sap.m.IBreadcrumbs",multiple:false},_actionsToolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_navActionsToolbar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},_navActionsToolbarSeparator:{type:"sap.m.ToolbarSeparator",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_snappedTitleOnMobileIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"}},events:{stateChange:{parameters:{isExpanded:{type:"boolean"}}}},designtime:"sap/f/designtime/DynamicPageTitle.designtime"},renderer:h});function S(t){if(arguments.length===1){return t&&"length"in t?t.length>0:!!t}return Array.prototype.slice.call(arguments).every(function(t){return S(t)})}v.NAV_ACTIONS_PLACEMENT_BREAK_POINT=1280;v.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS={headingAreaShrinkFactor:1.6,contentAreaShrinkFactor:1,actionsAreaShrinkFactor:1.6};v.TOGGLE_HEADER_TEXT_ID=c.getStaticId("sap.f","TOGGLE_HEADER");v.DEFAULT_HEADER_TEXT_ID=c.getStaticId("sap.f","DEFAULT_HEADER_TEXT");v._getResourceBundle=function(){return _.getLibraryResourceBundle("sap.f")};v.ARIA={TOOLBAR_HEADER_ACTIONS:v._getResourceBundle().getText("ARIA_LABEL_TOOLBAR_HEADER_ACTIONS")};v._renderControl=function(t,e){var i;if(!e||!t){return}i=_.createRenderManager();i.renderControl(e);i.flush(t);i.destroy()};function T(t){return typeof t==="function"}v.prototype.init=function(){this._bExpandedState=true;this._bShowExpandButton=false;this._bIsFocusable=true;this._bNavigationActionsInTopArea=false;this._oInvisibleMessage=null;this._aCachedInvisibleTexts=[];this._fnActionSubstituteParentFunction=function(){return this}.bind(this);this._oObserver=new n(v.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["content","_actionsToolbar"]})};v.prototype.onBeforeRendering=function(){this._getActionsToolbar();this._observeControl(this.getBreadcrumbs());this._detachFocusSpanHandlers()};v.prototype.onAfterRendering=function(){this._cacheDomElements();this._attachFocusSpanHandlers();this._toggleState(this._bExpandedState);this._toggleFocusableState(this._bIsFocusable);this._doNavigationActionsLayout();this._updateTopAreaVisibility();if(this._getFocusSpan().is(":focus")){this._addFocusClass()}if(!this._oInvisibleMessage){this._oInvisibleMessage=A.getInstance()}};v.prototype.exit=function(){if(this._oObserver){this._oObserver.disconnect();this._oObserver=null}this._destroyInvisibleTexts()};v.prototype.setPrimaryArea=function(t){var e=this.getAreaShrinkRatio(),i=this._getShrinkFactorsObject(),n=this.getMetadata().getProperty("areaShrinkRatio").getDefaultValue();if(!this.getDomRef()){return this.setProperty("primaryArea",t,true)}if(e!==n){return this.setProperty("primaryArea",t,true)}if(t===f.Begin){this._setShrinkFactors(i.headingAreaShrinkFactor,i.contentAreaShrinkFactor,i.actionsAreaShrinkFactor)}else{this._setShrinkFactors(v.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.headingAreaShrinkFactor,v.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.contentAreaShrinkFactor,v.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.actionsAreaShrinkFactor)}return this.setProperty("primaryArea",t,true)};v.prototype.setAreaShrinkRatio=function(t){t=this.validateProperty("areaShrinkRatio",t);this.setProperty("areaShrinkRatio",t,true);var e=this._getShrinkFactorsObject();if(this.getPrimaryArea()===f.Middle){g.warning("DynamicPageTitle :: Property primaryArea is disregarded when areaShrinkRatio is set.",this)}if(e.headingAreaShrinkFactor>1&&e.contentAreaShrinkFactor>1&&e.actionsAreaShrinkFactor>1){g.warning("DynamicPageTitle :: One of the shrink factors should be set to 1.",this)}this._setShrinkFactors(e.headingAreaShrinkFactor,e.contentAreaShrinkFactor,e.actionsAreaShrinkFactor);return this};v.prototype.ontap=function(t){var e=t.srcControl;if(e===this||e===this.getAggregation("_actionsToolbar")||e===this.getAggregation("breadcrumbs")||e===this.getAggregation("snappedTitleOnMobile")){this.fireEvent("_titlePress")}};v.prototype.onmouseover=function(){if(this._bTitleMouseOverFired){return}this.fireEvent("_titleMouseOver");this._bTitleMouseOverFired=true};v.prototype.onmouseout=function(t){if(t&&this.getDomRef().contains(t.relatedTarget)){return}this.fireEvent("_titleMouseOut");this._bTitleMouseOverFired=false};v.prototype.onkeyup=function(t){if(t&&t.which===u.SPACE&&!t.shiftKey){this.onsapenter(t)}};v.prototype.onsapspace=function(t){if(t.srcControl===this){t.preventDefault()}};v.prototype.onsapenter=function(t){if(t.srcControl===this){this.fireEvent("_titlePress")}};["addAction","insertAction","removeAction","indexOfAction","removeAllActions","destroyActions","getActions"].forEach(function(t){v.prototype[t]=function(e){var i=this._getActionsToolbar(),n=t.replace(/Actions?/,"Content"),a=true,o;if(t==="addAction"||t==="insertAction"){if(!this._actionExists(e,"actions")){i[n].apply(i,arguments);this._preProcessAction(e,"actions")}o=this}else if(t==="removeAction"){this._postProcessAction(e)}else if(t==="removeAllActions"){this.getActions().forEach(this._postProcessAction,this)}else if(t==="destroyActions"){this.getActions().forEach(this._postProcessAction,this);i[n].apply(i,arguments);o=this}else if(t==="getActions"){a=false}o=o||i[n].apply(i,arguments);a&&this._updateSeparatorVisibility();return o}});["addNavigationAction","insertNavigationAction","removeNavigationAction","indexOfNavigationAction","removeAllNavigationActions","destroyNavigationActions","getNavigationActions"].forEach(function(t){v.prototype[t]=function(e){var i=this._getNavigationActionsToolbar(),n=t.replace(/NavigationActions?/,"Content"),a=true,o;if(t==="addNavigationAction"||t==="insertNavigationAction"){if(!this._actionExists(e,"navigationActions")){i[n].apply(i,arguments);this._preProcessAction(e,"navigationActions")}o=this}else if(t==="removeNavigationAction"){this._postProcessAction(e)}else if(t==="removeAllNavigationActions"){this.getNavigationActions().forEach(this._postProcessAction,this)}else if(t==="destroyNavigationActions"){this.getNavigationActions().forEach(this._postProcessAction,this);i[n].apply(i,arguments);o=this}else if(t==="getNavigationActions"){a=false}o=o||i[n].apply(i,arguments);a&&this._updateTopAreaVisibility();return o}});v.prototype.clone=function(t,e,n){var a=i.prototype.clone.apply(this,arguments),o=true;if(n){o=!!n.cloneChildren}if(!o){return a}var s=function(t){if(!this.isBound(t)){var e=this.getMetadata().getAggregation(t);e.get(this).forEach(function(t){e.add(a,t.clone())},this)}}.bind(this);s("actions");s("navigationActions");return a};v.prototype._getInvisibleText=function(t,e){var i=new c({id:t+"-InvisibleText",text:e}).toStatic();this._aCachedInvisibleTexts.push(i);return i};v.prototype._destroyInvisibleTexts=function(){this._aCachedInvisibleTexts.forEach(function(t){t.destroy()});this._aCachedInvisibleTexts=[]};v.prototype._actionExists=function(t,e){return this.getMetadata().getAggregation(e).get(this).indexOf(t)>-1};v.prototype._cacheDomElements=function(){this.$topNavigationActionsArea=this.$("topNavigationArea");this.$mainNavigationActionsArea=this.$("mainNavigationArea");this.$beginArea=this.$("left-inner");this.$topArea=this.$("top");this.$mainArea=this.$("main");this.$middleArea=this.$("content");this.$snappedTitleOnMobileWrapper=this.$("snapped-title-on-mobile-wrapper");this.$snappedHeadingWrapper=this.$("snapped-heading-wrapper");this.$expandHeadingWrapper=this.$("expand-heading-wrapper");this.$snappedWrapper=this.$("snapped-wrapper");this.$expandWrapper=this.$("expand-wrapper");this._$focusSpan=this.$("focusSpan")};v.prototype._getActionsToolbar=function(){var t=this.getId()+"-_actionsToolbar";if(!this.getAggregation("_actionsToolbar")){this.setAggregation("_actionsToolbar",new r({id:t,style:b.Clear,ariaLabelledBy:this._getInvisibleText(t,v.ARIA.TOOLBAR_HEADER_ACTIONS)}).addStyleClass("sapFDynamicPageTitleActionsBar"),true)}return this.getAggregation("_actionsToolbar")};v.prototype._getNavigationActionsToolbar=function(){var t=this.getId()+"-navActionsToolbar";if(!this.getAggregation("_navActionsToolbar")){this.setAggregation("_navActionsToolbar",new o({id:t,style:b.Clear,ariaLabelledBy:this._getInvisibleText(t,v.ARIA.TOOLBAR_HEADER_ACTIONS)}).addStyleClass("sapFDynamicPageTitleActionsBar"),true)}return this.getAggregation("_navActionsToolbar")};v.prototype._getToolbarSeparator=function(){if(!this.getAggregation("_navActionsToolbarSeparator")){this.setAggregation("_navActionsToolbarSeparator",new s({id:this.getId()+"-separator"}),true)}return this.getAggregation("_navActionsToolbarSeparator")};v.prototype._toggleFocusableState=function(t){var e;this._bIsFocusable=t;e=this._getFocusSpan();if(e){t?e.show():e.hide()}};v.prototype._preProcessAction=function(t,e){if(T(t._fnOriginalGetParent)){return}this._observeControl(t);t._fnOriginalGetParent=t.getParent;t.getParent=this._fnActionSubstituteParentFunction;t._sOriginalParentAggregationName=t.sParentAggregationName;t.sParentAggregationName=e};v.prototype._postProcessAction=function(t){if(!T(t._fnOriginalGetParent)){return}this._unobserveControl(t);t.getParent=t._fnOriginalGetParent;t._fnOriginalGetParent=null;t.sParentAggregationName=t._sOriginalParentAggregationName;t._sOriginalParentAggregationName=null};v.prototype.onLayoutDataChange=function(t){var e=t.srcControl,i=e&&typeof e._fnOriginalGetParent==="function"&&e._fnOriginalGetParent();if(i){i.onLayoutDataChange(t)}};v.prototype._observeControl=function(t){this._oObserver.observe(t,{properties:["visible"]})};v.prototype._unobserveControl=function(t){this._oObserver.unobserve(t,{properties:["visible"]})};v.prototype._doNavigationActionsLayout=function(){var t,e,i;if(this.getNavigationActions().length===0){return}i=this._getNavigationActionsToolbar();t=this._shouldRenderNavigationActionsInTopArea();if(t){e=this.$topNavigationActionsArea[0]}else{e=this.$mainNavigationActionsArea[0]}this._bNavigationActionsInTopArea=t;v._renderControl(e,i);this._updateSeparatorVisibility()};v.prototype._updateTopAreaVisibility=function(t){var e=this._areNavigationActionsInTopArea(),i=this._shouldRenderNavigationActionsInTopArea(t),n=this.getBreadcrumbs()&&this.getBreadcrumbs().getVisible(),a=d.system.phone&&this.getSnappedTitleOnMobile()&&!this._bExpandedState,o=(n||i)&&!a,s=this.getNavigationActions().length>0&&i^e,r=this.$topArea;this._toggleTopAreaVisibility(o);r&&r.toggleClass("sapFDynamicPageTitleTopBreadCrumbsOnly",n&&!i);if(s){this._toggleNavigationActionsPlacement(i)}else{this._updateSeparatorVisibility()}};v.prototype._onResize=function(t){this._updateTopAreaVisibility(t)};v.prototype._toggleNavigationActionsPlacement=function(t){this["_showNavigationActionsIn"+(t?"Top":"Main")+"Area"]();this._updateSeparatorVisibility()};v.prototype._showNavigationActionsInTopArea=function(){var t=this._getNavigationActionsToolbar(),e;if(this.$topNavigationActionsArea&&this.$topNavigationActionsArea.length>0){e=document.activeElement;this.$topNavigationActionsArea.html(t.$());e&&e.focus()}this._bNavigationActionsInTopArea=true};v.prototype._showNavigationActionsInMainArea=function(){var t=this._getNavigationActionsToolbar(),e;if(this.$mainNavigationActionsArea&&this.$mainNavigationActionsArea.length>0){e=document.activeElement;this.$mainNavigationActionsArea.html(t.$());e&&e.focus()}this._bNavigationActionsInTopArea=false};v.prototype._areNavigationActionsInTopArea=function(){return this._bNavigationActionsInTopArea};v.prototype._updateSeparatorVisibility=function(){if(this.getDomRef()){this._getToolbarSeparator().toggleStyleClass("sapUiHidden",!this._shouldShowSeparator())}};v.prototype._toggleTopAreaVisibility=function(t){if(this.getDomRef()){this.$("top").toggleClass("sapUiHidden",!t)}};v.prototype._shouldShowSeparator=function(){var t,e;if(this._bNavigationActionsInTopArea){return false}t=this._getVisibleActions().length>0;e=this._getVisibleNavigationActions().length>0;return t&&e};v.prototype._getVisibleActions=function(){return this.getActions().filter(function(t){return t.getVisible()})};v.prototype._getVisibleNavigationActions=function(){return this.getNavigationActions().filter(function(t){return t.getVisible()})};v.prototype._setShrinkFactors=function(t,e,i){this.$("left-inner").css("flex-shrink",t);this.$("content").css("flex-shrink",e);this.$("mainActions").css("flex-shrink",i)};v.prototype._shouldRenderNavigationActionsInTopArea=function(t){var e,i,n;if(this._getVisibleNavigationActions().length===0){return false}e=t?t:this._getWidth();i=this._getVisibleActions().length>0;n=this.getBreadcrumbs()&&this.getBreadcrumbs().getVisible();return e<v.NAV_ACTIONS_PLACEMENT_BREAK_POINT&&(n||i)};v.prototype._toggleState=function(t,e){var i=this._bExpandedState;this._bExpandedState=t;if(!this.getDomRef()){return}if(d.system.phone&&this.getSnappedTitleOnMobile()){this.$snappedTitleOnMobileWrapper.toggleClass("sapUiHidden",t);this.$topArea.toggleClass("sapUiHidden",!t);this.$mainArea.toggleClass("sapUiHidden",!t);this.$().toggleClass("sapContrast",!t)}else{if(S(this.getSnappedHeading())){this.$snappedHeadingWrapper.toggleClass("sapUiHidden",t)}if(S(this.getExpandedHeading())){this.$expandHeadingWrapper.toggleClass("sapUiHidden",!t)}if(e&&i!==t){this.fireEvent("stateChange",{isExpanded:t})}}if(S(this.getSnappedContent())){this.$snappedWrapper.toggleClass("sapUiHidden",t);this.$snappedWrapper.parent().toggleClass("sapFDynamicPageTitleMainSnapContentVisible",!t)}if(S(this.getExpandedContent())){this.$expandWrapper.toggleClass("sapUiHidden",!t);this.$expandWrapper.parent().toggleClass("sapFDynamicPageTitleMainExpandContentVisible",t)}};v.prototype._getExpandButton=function(){if(!this.getAggregation("_expandButton")){var t=new p({id:this.getId()+"-expandBtn",icon:"sap-icon://slim-arrow-down",press:this._onExpandButtonPress.bind(this),tooltip:v._getResourceBundle().getText("EXPAND_HEADER_BUTTON_TOOLTIP")}).addStyleClass("sapFDynamicPageToggleHeaderIndicator sapUiHidden");this.setAggregation("_expandButton",t,true)}return this.getAggregation("_expandButton")};v.prototype._getSnappedTitleOnMobileIcon=function(){if(!this.getAggregation("_snappedTitleOnMobileIcon")){var t=new l({id:this.getId()+"-snappedTitleOnMobileIcon",src:"sap-icon://slim-arrow-down",press:this._onExpandButtonPress.bind(this)});this.setAggregation("_snappedTitleOnMobileIcon",t,true)}return this.getAggregation("_snappedTitleOnMobileIcon")};v.prototype._onExpandButtonPress=function(){this.fireEvent("_titleVisualIndicatorPress")};v.prototype._toggleExpandButton=function(t){this._setShowExpandButton(t);this._getExpandButton().toggleStyleClass("sapUiHidden",!t)};v.prototype._getShowExpandButton=function(){return this._bShowExpandButton};v.prototype._setShowExpandButton=function(t){this._bShowExpandButton=!!t};v.prototype._focusExpandButton=function(){var t=v._getResourceBundle().getText("SNAPPED_HEADER");this._getExpandButton().$().trigger("focus");this._oInvisibleMessage.announce(t,y.Polite)};v.prototype._getWidth=function(){return this.$().outerWidth()};v.prototype.getFocusDomRef=function(){return this._getFocusSpan()[0]||null};v.prototype._getState=function(){var t=this.getActions().length>0,e=this.getNavigationActions().length>0,i=this.getContent(),n=this.getSnappedContent(),a=this.getExpandedContent(),o=a.length>0,s=n.length>0,r=this._getShrinkFactorsObject(),p=this._getExpandButton(),c=this._getFocusSpan(),h=this.getBreadcrumbs(),g=this.getSnappedTitleOnMobile(),l=this._getSnappedTitleOnMobileIcon(),u=g&&d.system.phone,A=h||e,_=!!(h&&!e),b=e&&!h,y=this.getMetadata().getProperty("areaShrinkRatio").getDefaultValue(),S=this.getAreaShrinkRatio()===y;S=S&&this.getPrimaryArea()===f.Middle;if(S){r.headingAreaShrinkFactor=v.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.headingAreaShrinkFactor;r.contentAreaShrinkFactor=v.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.contentAreaShrinkFactor;r.actionsAreaShrinkFactor=v.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.actionsAreaShrinkFactor}p.toggleStyleClass("sapUiHidden",!this._getShowExpandButton());return{id:this.getId(),actionBar:this._getActionsToolbar(),navigationBar:this._getNavigationActionsToolbar(),hasActions:t,hasNavigationActions:e,content:i,hasContent:i.length>0,heading:this.getHeading(),snappedHeading:this.getSnappedHeading(),expandedHeading:this.getExpandedHeading(),expandButton:p,focusSpan:c,snappedTitleOnMobileContext:g,snappedTitleOnMobileIcon:l,snappedContent:n,expandedContent:a,hasSnappedContent:s,hasExpandedContent:o,hasSnappedTitleOnMobile:u,hasAdditionalContent:o||s&&!u,isSnapped:!this._bExpandedState,headingAreaShrinkFactor:r.headingAreaShrinkFactor,contentAreaShrinkFactor:r.contentAreaShrinkFactor,actionsAreaShrinkFactor:r.actionsAreaShrinkFactor,breadcrumbs:this.getBreadcrumbs(),separator:this._getToolbarSeparator(),hasTopContent:A,hasOnlyBreadcrumbs:_,hasOnlyNavigationActions:b,contentAreaHasContent:this._bContentAreaHasContent,actionsAreaHasContent:this._bActionsAreaHasContent,isFocusable:this._bIsFocusable,actionsAreaMinWidth:this._sActionsAreaMinWidth,contentAreaMinWidth:this._sContentAreaMinWidth}};v.prototype._getShrinkFactorsObject=function(){var t={},e=this.getAreaShrinkRatio().split(":");t.headingAreaShrinkFactor=parseFloat(e[0]);t.contentAreaShrinkFactor=parseFloat(e[1]);t.actionsAreaShrinkFactor=parseFloat(e[2]);return t};v.prototype._observeChanges=function(t){var e=t.object,i=t.name;if(e===this){if(i==="content"||i==="_actionsToolbar"){this._observeContentChanges(t)}}else if(i==="visible"){this._updateTopAreaVisibility()}};v.prototype._observeContentChanges=function(t){var e=t.child,i=t.mutation,n=e.$().parent();if(!(e instanceof r)){return}if(i==="insert"){e.attachEvent("_contentSizeChange",this._onContentSizeChange,this);e.attachEvent("_minWidthChange",this._onContentMinWidthChange,this)}else if(i==="remove"){e.detachEvent("_contentSizeChange",this._onContentSizeChange,this);e.detachEvent("_minWidthChange",this._onContentMinWidthChange,this);this._setContentAreaFlexBasis(0,n);n.css({"min-width":""})}};v.prototype._onContentSizeChange=function(t){var e=t.getParameter("contentSize");this._setContentAreaFlexBasis(e,t.getSource().$().parent())};v.prototype._onContentMinWidthChange=function(t){var e=t.getParameter("minWidth"),i=e>0?e+"px":"",n=t.getSource().$().parent();n.css({"min-width":i});if(n.hasClass("sapFDynamicPageTitleMainContent")){this._sContentAreaMinWidth=i}else if(n.hasClass("sapFDynamicPageTitleMainActions")){this._sActionsAreaMinWidth=i}};v.prototype._setContentAreaFlexBasis=function(t,e){var i;t=parseInt(t);i=t&&t>1;if(e.hasClass("sapFDynamicPageTitleMainContent")){this._bContentAreaHasContent=i;e.toggleClass("sapFDynamicPageTitleMainContentHasContent",i)}else if(e.hasClass("sapFDynamicPageTitleMainActions")){this._bActionsAreaHasContent=i;e.toggleClass("sapFDynamicPageTitleMainActionsHasContent",i)}};v.prototype._updateARIAState=function(t){var e=this._getARIALabelReferences(t),i=this._getFocusSpan();if(i){i.attr("aria-labelledby",e);i.attr("aria-expanded",t)}return this};v.prototype._getARIALabelReferences=function(t){var e="",i,n,a=this.getHeading()||(t?this.getExpandedHeading():this.getSnappedHeading());if(a){i=a.getTitle&&a.getTitle();if(i&&i.getId){n=i.getId()}e+=n||a.getId()}return e||v.DEFAULT_HEADER_TEXT_ID};v.prototype._focus=function(){this._getFocusSpan().trigger("focus")};v.prototype._getAriaDescribedByReferences=function(){var t=this.getAriaDescribedBy(),e=v.TOGGLE_HEADER_TEXT_ID;if(t.length>0){e+=" "+t.join(" ")}return e};v.prototype._attachFocusSpanHandlers=function(){this._$focusSpan.on("focusin",this._addFocusClass.bind(this));this._$focusSpan.on("focusout",this._removeFocusClass.bind(this))};v.prototype._detachFocusSpanHandlers=function(){if(this._$focusSpan){this._$focusSpan.off("focusin");this._$focusSpan.off("focusout")}};v.prototype._getFocusSpan=function(){return this._$focusSpan};v.prototype._addFocusClass=function(){this.$().addClass("sapFDynamicPageTitleFocus")};v.prototype._removeFocusClass=function(){this.$().removeClass("sapFDynamicPageTitleFocus")};return v});
//# sourceMappingURL=DynamicPageTitle.js.map