/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Input","./ComboBoxTextField","./ComboBoxBaseRenderer","./SuggestionsPopover","sap/ui/base/ManagedObjectObserver","sap/ui/core/SeparatorItem","sap/ui/core/InvisibleText","sap/ui/base/ManagedObject","sap/base/Log","./library","sap/ui/Device","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/m/inputUtils/forwardItemProperties","sap/m/inputUtils/highlightDOMElements","sap/m/inputUtils/highlightItemsWithContains","sap/m/inputUtils/ListHelpers","sap/ui/core/IconPool","sap/ui/core/Core"],function(t,e,i,s,o,n,r,a,u,p,l,h,c,jQuery,d,g,f,I,y,m){"use strict";var b=p.PlacementType;var v=["value","enabled","name","placeholder","editable","textAlign","textDirection","valueState","valueStateText"];var S=e.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m",abstract:true,defaultAggregation:"items",properties:{showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},open:{type:"boolean",defaultValue:false},showClearIcon:{type:"boolean",defaultValue:false},effectiveShowClearIcon:{type:"boolean",defaultValue:false,visibility:"hidden"}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}},dnd:{draggable:false,droppable:true}},renderer:i});S.prototype.oncompositionend=function(t){e.prototype.oncompositionend.apply(this,arguments);if(!l.browser.firefox){this.handleInputValidation(t,this.isComposingCharacter())}};S.prototype.shouldShowClearIcon=function(){return this.getProperty("effectiveShowClearIcon")&&!!this.getValue()&&this.getEditable()&&this.getEnabled()};S.prototype.updateItems=function(t){this.bItemsUpdated=false;var e=this.getItems().length;var i;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){if(this.isOpen()){I.fillList(this.getItems(),this._getList(),this._mapItemToListItem.bind(this));this.setRecreateItems(false)}this.onItemsLoaded()}i=this._getList();if(i&&e===this.getItems().length){i.setBusy(false);i.setShowNoData(!this.getItems().length);this.bInitialBusyIndicatorState=false}};S.prototype.setFilterFunction=function(t){if(t===null||t===undefined){this.fnFilter=null;return this}if(typeof t!=="function"){u.warning("Passed filter is not a function and the default implementation will be used")}else{this.fnFilter=t}return this};S.prototype.highlightList=function(t){var e=[];e=this._getList().$().find(".sapMSLIInfo [id$=-infoText], .sapMSLITitleOnly [id$=-titleText]");if(this.useHighlightItemsWithContains()){f(e,t)}else{g(e,t)}};S.prototype.useHighlightItemsWithContains=function(){return false};S.prototype._decoratePopupInput=function(t){if(t){this.setTextFieldHandler(t);t.setShowClearIcon(this.getShowClearIcon())}return t};S.prototype.setTextFieldHandler=function(t){var e=this,i=t._handleEvent;t._handleEvent=function(t){i.apply(this,arguments);if(/keydown|keyup|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(t.type)){e._handleEvent(t)}}};S.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items")};S.prototype.loadItems=function(t,e){var i=typeof t==="function";if(this.hasLoadItemsEventListeners()&&this.getItems().length===0){this._bOnItemsLoadedScheduled=false;if(i){e=jQuery.extend({action:t,busyIndicator:true,busyIndicatorDelay:300},e);this.aMessageQueue.push(e);if(this.iLoadItemsEventInitialProcessingTimeoutID===-1&&e.busyIndicator){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function t(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true)}.bind(this),e.busyIndicatorDelay)}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems()}}else if(i){t.call(this)}};S.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState)}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay)}for(var t=0,e,i,s;t<this.aMessageQueue.length;t++){e=this.aMessageQueue.shift();t--;s=t+1===this.aMessageQueue.length;i=s?null:this.aMessageQueue[t+1];if(typeof e.action==="function"){if(e.name==="input"&&!s&&i.name==="input"){continue}e.action.call(this)}}};S.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems")};S.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0)}};S.prototype.getPickerInvisibleTextId=function(){return r.getStaticId("sap.m","COMBOBOX_AVAILABLE_OPTIONS")};S.prototype._getGroupHeaderInvisibleText=function(){if(!this._oGroupHeaderInvisibleText){this._oGroupHeaderInvisibleText=new r;this._oGroupHeaderInvisibleText.toStatic()}return this._oGroupHeaderInvisibleText};S.prototype._isListInSuggestMode=function(){return this._getList().getItems().some(function(t){return!t.getVisible()&&I.getItemByListItem(this.getItems(),t).getEnabled()},this)};S.prototype.getSelectable=function(t){return t._bSelectable};S.prototype._setItemsShownWithFilter=function(t){this._bItemsShownWithFilter=t};S.prototype._getItemsShownWithFilter=function(){return this._bItemsShownWithFilter};S.prototype._getClearIcon=function(){if(this._oClearIcon){return this._oClearIcon}this._oClearIcon=this.addEndIcon({src:y.getIconURI("decline"),noTabStop:true,visible:false,alt:this._oRb.getText("INPUT_CLEAR_ICON_ALT"),useIconTooltip:false,decorative:false,press:this.handleClearIconPress.bind(this)},0);this._oClearIcon.addStyleClass("sapMComboBoxBaseClearIcon");return this._oClearIcon};S.prototype.handleClearIconPress=function(t){};S.prototype.onkeyup=function(t){if(!this.getEnabled()||!this.getEditable()){return}this.getShowClearIcon()&&this.setProperty("effectiveShowClearIcon",!!this.getValue())};S.prototype.setValue=function(t){e.prototype.setValue.apply(this,arguments);this.setProperty("effectiveShowClearIcon",!!t);return this};S.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oRb=m.getLibraryResourceBundle("sap.m");this.setPickerType(l.system.phone?"Dialog":"Dropdown");this._setItemsShownWithFilter(false);this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this._bShouldClosePicker=false;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;this.getArrowIcon().addEventDelegate({onmousedown:function(t){this._bShouldClosePicker=this.isOpen()}},this);this.getArrowIcon().attachPress(this._handlePopupOpenAndItemsLoad.bind(this,true,this));this.fnFilter=null;var t=new o(function(t){var e=t.mutation;var i=t.child;var s={remove:"detachEvent",insert:"attachEvent"};var o={remove:"handleItemRemoval",insert:"handleItemInsertion"};if(!i[s[e]]||!this[o[e]]){return}i[s[e]]("_change",this.onItemChange,this);this.setRecreateItems(true);this[o[e]](i)}.bind(this));t.observe(this,{aggregations:["items"]})};S.prototype.handleItemRemoval=function(t){};S.prototype.handleItemInsertion=function(t){};S.prototype.setRecreateItems=function(t){this._bRecreateItems=t};S.prototype.getRecreateItems=function(){return this._bRecreateItems};S.prototype.onBeforeRendering=function(){var t=this.isOpen(),i=t?this._getSuggestionsPopover()._getValueStateHeader().getText():null,s=t?this._getSuggestionsPopover()._getValueStateHeader().getValueState():null;e.prototype.onBeforeRendering.apply(this,arguments);if(t&&(this.getValueStateText()&&i!==this.getValueStateText()||this.getValueState()!==s||this.getFormattedValueStateText())){this._updateSuggestionsPopoverValueState()}};S.prototype._handlePopupOpenAndItemsLoad=function(t,e){var i;if(!this.getEnabled()||!this.getEditable()){return}if(t&&this._getItemsShownWithFilter()){this._bShouldClosePicker=false;this.toggleIconPressedStyle(true);this.bOpenedByKeyboardOrButton=false;this.clearFilter();this._setItemsShownWithFilter(false);return}if(this._bShouldClosePicker){this._bShouldClosePicker=false;this.close();return}this.loadItems();this.bOpenedByKeyboardOrButton=t;if(this.isPlatformTablet()){this.syncPickerContent();i=this.getPicker();i.setInitialFocus(i)}if(e){i=this.getPicker();i&&i.setInitialFocus(e)}this.open()};S.prototype.exit=function(){e.prototype.exit.apply(this,arguments);this._oRb=null;if(this._getGroupHeaderInvisibleText()){this._getGroupHeaderInvisibleText().destroy();this._oGroupHeaderInvisibleText=null}if(this._oSuggestionPopover){this._oSuggestionPopover.destroy();this._oSuggestionPopover=null}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;this.fnFilter=null};S.prototype.onsapshow=function(t){if(!this.getEnabled()||!this.getEditable()){return}t.setMarked();if(t.keyCode===c.F4){this.onF4(t)}if(this._getItemsShownWithFilter()){this.loadItems(this._handlePopupOpenAndItemsLoad.bind(this,true));return}if(this.isOpen()){this.close();return}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open()};S.prototype.onF4=function(t){t.preventDefault()};S.prototype.onsapescape=function(t){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){t.setMarked();t.preventDefault();this.close()}else{e.prototype.onsapescape.apply(this,arguments)}};S.prototype.onsaphide=S.prototype.onsapshow;S.prototype.onsapfocusleave=function(t){if(!t.relatedControlId){e.prototype.onsapfocusleave.apply(this,arguments);return}var i=sap.ui.getCore().byId(t.relatedControlId);if(i===this){return}var s=this.getPicker(),o=i&&i.getFocusDomRef();if(s&&h(s.getFocusDomRef(),o)){return}e.prototype.onsapfocusleave.apply(this,arguments)};S.prototype.getPopupAnchorDomRef=function(){return this.getDomRef()};S.prototype.addContent=function(t){};S.prototype.getList=function(){u.warning("[Warning]:","You are attempting to use deprecated method 'getList()', please refer to SAP note 2746748.",this);return this._getList()};S.prototype._getList=function(){var t=this._oSuggestionPopover&&this._oSuggestionPopover.getItemsContainer();if(this.bIsDestroyed||!t){return null}return t};S.prototype.setPickerType=function(t){this._sPickerType=t};S.prototype.getPickerType=function(){return this._sPickerType};S.prototype._updateSuggestionsPopoverValueState=function(){var t=this._getSuggestionsPopover();if(!t){return}var e=this.getValueState(),i=this.getValueState()!==t._getValueStateHeader().getValueState(),s=this.getFormattedValueStateText(),o=this.getValueStateText(),n=s||i;if(t.isOpen()&&!n){this.setFormattedValueStateText(t._getValueStateHeader().getFormattedText())}t.updateValueState(e,s||o,this.getShowValueStateMessage())};S.prototype.shouldValueStateMessageBeOpened=function(){var t=e.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);return t&&!this.isOpen()};S.prototype.onPropertyChange=function(t,e){var i=t.getParameter("newValue"),s=t.getParameter("name"),o="set"+s.charAt(0).toUpperCase()+s.slice(1),n=e&&e.srcControl||this.getPickerTextField();if(this.getInputForwardableProperties().indexOf(s)>-1&&n&&typeof n[o]==="function"){n[o](i)}};S.prototype.getInputForwardableProperties=function(){return v};S.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog"};S.prototype.isPlatformTablet=function(){var t=!l.system.combi,e=l.system.tablet&&t;return e};S.prototype.getDropdownSettings=function(){return{showArrow:false,placement:b.VerticalPreferredBottom,offsetX:0,offsetY:0,bounce:false,ariaLabelledBy:this.getPickerInvisibleTextId()||undefined}};S.prototype._configureList=function(){};S.prototype.createPicker=function(t){var e=this.getAggregation("picker");if(e){return e}this._oSuggestionPopover=this._createSuggestionsPopover();e=this._oSuggestionPopover.getPopover();this.setAggregation("picker",e,true);this.configPicker(e);return e};S.prototype.configPicker=function(t){};S.prototype._hasShowSelectedButton=function(){return false};S.prototype._createSuggestionsPopover=function(){var e=new s(this);e.decorateParent(this);e.createSuggestionPopup(this,{showSelectedButton:this._hasShowSelectedButton()},t);this._decoratePopupInput(e.getInput());e.initContent(this.getId());this.forwardEventHandlersToSuggPopover(e);this._configureList(e.getItemsContainer());return e};S.prototype.forwardEventHandlersToSuggPopover=function(t){t.setOkPressHandler(this._handleOkPress.bind(this));t.setCancelPressHandler(this._handleCancelPress.bind(this));t.setInputLabels(this.getLabels.bind(this))};S.prototype._handleOkPress=function(){var t=this,e=t.getPickerTextField();t.updateDomValue(e.getValue());t.onChange();t.close()};S.prototype._handleCancelPress=function(){this.close();this.revertSelection()};S.prototype.setSelectable=function(t,e){if(this.indexOfItem(t)<0){return}t._bSelectable=e;var i=I.getListItem(t);if(i){i.setVisible(e)}};S.prototype.onBeforeOpen=function(){this._updateSuggestionsPopoverValueState();if(!this._getItemsShownWithFilter()){this.toggleIconPressedStyle(true)}};S.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;this._setItemsShownWithFilter(false);this._updateSuggestionsPopoverValueState()};S.prototype.getPicker=function(){var t=this.getAggregation("picker");if(t&&!t.bIsDestroyed&&!this.bIsDestroyed){return t}return null};S.prototype._getSuggestionsPopover=function(){return this._oSuggestionPopover};S.prototype.getValueStateLinks=function(){var t=this.getPicker()&&this.getPicker().getCustomHeader()&&typeof this.getPicker().getCustomHeader().getFormattedText==="function",e=t&&this.getPicker().getCustomHeader().getFormattedText(),i=e&&e.getControls();return i||[]};S.prototype.getPickerTextField=function(){var t=this._getSuggestionsPopover();return t?t.getInput():null};S.prototype.getPickerTitle=function(){var t=this.getPicker(),e=t&&t.getCustomHeader();if(this.isPickerDialog()&&e){return e.getContentMiddle()[0]}return null};S.prototype.revertSelection=function(){};S.prototype.hasContent=function(){return this.getItems().length>0};S.prototype.syncPickerContent=function(){};S.prototype.open=function(){var t=this.getPicker();if(t){t.open()}return this};S.prototype.getVisibleItems=function(){return I.getVisibleItems(this.getItems())};S.prototype.isItemSelected=function(){};S.prototype.getKeys=function(t){t=t||this.getItems();for(var e=0,i=[];e<t.length;e++){i[e]=t[e].getKey()}return i};S.prototype.findItem=function(t,e){var i="get"+t.charAt(0).toUpperCase()+t.slice(1);for(var s=0,o=this.getItems();s<o.length;s++){if(o[s][i]()===e){return o[s]}}return null};S.prototype.getItemByText=function(t){return this.findItem("text",t)};S.prototype.clearFilter=function(){this.getItems().forEach(function(t){var e=I.getListItem(t);if(e){e.setVisible(t.getEnabled()&&this.getSelectable(t))}},this)};S.prototype.onItemChange=function(t,e){d({item:t.getSource(),propName:t.getParameter("name"),propValue:t.getParameter("newValue")},e)};S.prototype.clearSelection=function(){};S.prototype.setInternalBusyIndicator=function(t){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments)};S.prototype.setInternalBusyIndicatorDelay=function(t){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments)};S.prototype.getItemAt=function(t){return this.getItems()[+t]||null};S.prototype.getFirstItem=function(){return this.getItems()[0]||null};S.prototype.getLastItem=function(){var t=this.getItems();return t[t.length-1]||null};S.prototype.getEnabledItems=function(t){return I.getEnabledItems(t||this.getItems())};S.prototype.getItemByKey=function(t){return this.findItem("key",t)};S.prototype.addItemGroup=function(t,e,i){e=e||new n({text:a.escapeSettingsValue(t.text)||a.escapeSettingsValue(t.key)});this.addAggregation("items",e,i);if(this._getList()&&e.isA("sap.ui.core.SeparatorItem")){this._getList().addItem(this._mapItemToListItem(e))}return e};S.prototype.isOpen=function(){var t=this.getPicker();return!!(t&&t.isOpen())};S.prototype.close=function(){var t=this.getPicker();if(t){t.close()}return this};S.prototype.intersectItems=function(t,e){return t.filter(function(t){return e.map(function(t){return t.getId()}).indexOf(t.getId())!==-1})};S.prototype.showItems=function(t){var e=this.fnFilter,i=function(){if(!this.getItems().length){return}this.detachLoadItems(i);this.setFilterFunction(t||function(){return true});this.applyShowItemsFilters();this._handlePopupOpenAndItemsLoad(false,this);this.setFilterFunction(e)}.bind(this);if(!this.getEnabled()||!this.getEditable()){return}this._setItemsShownWithFilter(true);this.attachLoadItems(i);this.loadItems(i)};S.prototype.applyShowItemsFilters=function(){};return S});
//# sourceMappingURL=ComboBoxBase.js.map