/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/model/type/Date","sap/ui/model/odata/type/ODataType","sap/ui/model/odata/type/DateTimeBase","./InputBase","./ValueStateHeader","sap/ui/core/Core","sap/ui/core/LocaleData","sap/ui/core/library","sap/ui/core/format/DateFormat","./DateTimeFieldRenderer","sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/Configuration","sap/ui/core/date/UI5Date","sap/ui/unified/calendar/CalendarUtils","sap/ui/dom/jquery/cursorPos"],function(t,e,a,r,i,s,o,n,u,l,p,h,jQuery,g,c,f){"use strict";var y=n.CalendarType;var d=n.ValueState;var _=r.extend("sap.m.DateTimeField",{metadata:{abstract:true,library:"sap.m",properties:{displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null},initialFocusedDateValue:{type:"object",group:"Data",defaultValue:null}},events:{liveChange:{parameters:{value:{type:"string"},previousValue:{type:"string"}}}}},renderer:l});_.prototype.setValue=function(t){t=this.validateProperty("value",t);var e=this.getValue();if(t===e){return this}else{this.setLastValue(t)}var a=this._parseAndValidateValue(t);this.setProperty("dateValue",a,this._bPreferUserInteraction);this._formatValueAndUpdateOutput(a,t);this.setProperty("value",t,this._bPreferUserInteraction);return this};_.prototype._parseAndValidateValue=function(t){this._bValid=true;var e;if(t){try{e=this._parseValue(t)}catch(t){}if(Array.isArray(e)){e=e[0]}if(!e||!e.getTime||e.getTime()<this._oMinDate.getTime()||e.getTime()>this._oMaxDate.getTime()){this._bValid=false;h.warning("Value can not be converted to a valid date",this)}}return e};_.prototype._formatValueAndUpdateOutput=function(t,e){if(!this.getDomRef()){return}var a=t?this._formatValue(t):e;if(this._bPreferUserInteraction){this.handleInputValueConcurrency(a)}else if(this._$input.val()!==a){this._$input.val(a);this._curpos=this._$input.cursorPos()}};_.prototype._inPreferredUserInteraction=function(){if(this._bPreferUserInteraction&&this.getDomRef()){var t=this.getFocusDomRef(),e=t&&this._getInputValue(),a=this.getProperty("value"),r=document.activeElement===t;return r&&e&&a!==e}return false};_.prototype.setDateValue=function(t){if(!this._isValidDate(t)){throw new Error("Date must be a JavaScript or UI5Date date object; "+this)}if(p(this.getDateValue(),t)){return this}t=this._dateValidation(t);var e=this._formatValue(t,true);if(e!==this.getValue()){this.setLastValue(e)}this.setProperty("value",e);if(this.getDomRef()){var a=this._formatValue(t);if(this._$input.val()!==a){this._$input.val(a);this._curpos=this._$input.cursorPos()}}return this};_.prototype.setValueFormat=function(t){this.setProperty("valueFormat",t,true);var e=this.getValue();if(e){this._handleDateValidation(this._parseValue(e))}return this};_.prototype.setDisplayFormat=function(t){this.setProperty("displayFormat",t,true);this.updateDomValue(this._formatValue(this.getDateValue()));this.setPlaceholder(this._getPlaceholder());return this};_.prototype.getDisplayFormatType=function(){return null};_.prototype.onfocusin=function(t){if(!jQuery(t.target).hasClass("sapUiIcon")){this.addStyleClass("sapMFocus")}if(!jQuery(t.target).hasClass("sapMInputBaseIconContainer")&&!(this._oPopup&&this._oPopup.isOpen())){this.openValueStateMessage()}else if(this._oValueStateHeader){this._oValueStateHeader.setValueState(this.getValueState()).setText(this._getTextForPickerValueStateContent()).setVisible(this.getValueState()!==d.None)}this._sPreviousValue=this.getDOMValue()};_.prototype.oninput=function(t){r.prototype.oninput.call(this,t);if(t.isMarked("invalid")){return}var e=this.getDOMValue();if(e!==this._sPreviousValue){this.fireLiveChange({value:e,previousValue:this._sPreviousValue});this._sPreviousValue=e}};_.prototype.getDOMValue=function(){return this._$input.val()};_.prototype._getValueStateHeader=function(){var t;if(!this._oValueStateHeader){t=this.getValueState();this._oValueStateHeader=new i({text:this._getTextForPickerValueStateContent(),valueState:t,visible:t!==d.None})}return this._oValueStateHeader};_.prototype._dateValidation=function(t){this._bValid=true;this.setProperty("dateValue",t);return t};_.prototype._handleDateValidation=function(t){this._bValid=true;this.setProperty("dateValue",t)};_.prototype._getPlaceholder=function(){var a=this.getPlaceholder(),r=this.getBinding("value"),i=r&&r.getType&&r.getType(),s;if(!a){if(i instanceof t){return i.getPlaceholderText()}if(i instanceof e&&i.oFormat){return i.oFormat.getPlaceholderText()}s=!!this._getDisplayFormatPattern();a=this._getFormatter(s).getPlaceholderText()}return a};_.prototype._getLocaleBasedPattern=function(t){return o.getInstance(g.getFormatSettings().getFormatLocale()).getDatePattern(t)};_.prototype._parseValue=function(t,e){var r=this.getBinding("value"),i=r&&r.getType&&r.getType(),s=this._getFormatter(e),o,n,u;if(this._isSupportedBindingType(i)){try{u=i.parseValue(t,"string");if(typeof u==="string"&&i instanceof a){u=a.prototype.parseValue.call(i,t,"string")}o=i.oFormatOptions;if(o&&o.source&&o.source.pattern=="timestamp"){u=c.getInstance(u)}else if(o&&o.source&&typeof o.source.pattern==="string"){u=i.oInputFormat.parse(t)}}catch(t){}if(u&&(i.oFormatOptions&&this._isFormatOptionsUTC(i.oFormatOptions)||i.oConstraints&&i.oConstraints.isDateOnly)){n=c.getInstance(u.getUTCFullYear(),u.getUTCMonth(),u.getUTCDate(),u.getUTCHours(),u.getUTCMinutes(),u.getUTCSeconds(),u.getUTCMilliseconds());n.setFullYear(u.getUTCFullYear());u=n}return u}return s.parse(t)};_.prototype._formatValue=function(t,e){if(!t){return""}var a=this.getBinding("value"),r=a&&a.getType&&a.getType(),i,s;if(this._isSupportedBindingType(r)){if(r.oFormatOptions&&r.oFormatOptions.UTC||r.oConstraints&&r.oConstraints.isDateOnly){s=f._createUTCDate(t,true);s.setUTCFullYear(t.getFullYear());t=s}i=r.oFormatOptions;if(i&&i.source&&i.source.pattern=="timestamp"){t=t.getTime()}else if(r.oOutputFormat){return r.oOutputFormat.format(t)}return r.formatValue(t,"string")}return this._getFormatter(!e).format(t)};_.prototype._isSupportedBindingType=function(t){return!!t&&t.isA(["sap.ui.model.type.Date","sap.ui.model.odata.type.DateTime","sap.ui.model.odata.type.DateTimeOffset"])};_.prototype._isFormatOptionsUTC=function(t){return t.UTC||t.source&&t.source.UTC};_.prototype._getDefaultDisplayStyle=function(){return"medium"};_.prototype._getDefaultValueStyle=function(){return"short"};_.prototype._getFormatter=function(t){var e=this._getBoundValueTypePattern(),a=false,r,i=this.getBinding("value"),s;if(i&&i.oType&&i.oType.oOutputFormat){a=!!i.oType.oOutputFormat.oFormatOptions.relative;s=i.oType.oOutputFormat.oFormatOptions.calendarType}if(!e){if(t){e=this.getDisplayFormat()||this._getDefaultDisplayStyle();s=this.getDisplayFormatType()}else{e=this.getValueFormat()||this._getDefaultValueStyle();s=y.Gregorian}}if(!s){s=g.getCalendarType()}if(t){if(e===this._sUsedDisplayPattern&&s===this._sUsedDisplayCalendarType){r=this._oDisplayFormat}}else{if(e===this._sUsedValuePattern&&s===this._sUsedValueCalendarType){r=this._oValueFormat}}if(r){return r}return this._getFormatterInstance(r,e,a,s,t)};_.prototype._getFormatterInstance=function(t,e,a,r,i){if(this._checkStyle(e)){t=this._getFormatInstance({style:e,strictParsing:true,relative:a,calendarType:r},i)}else{t=this._getFormatInstance({pattern:e,strictParsing:true,relative:a,calendarType:r},i)}if(i){this._sUsedDisplayPattern=e;this._sUsedDisplayCalendarType=r;this._oDisplayFormat=t}else{this._sUsedValuePattern=e;this._sUsedValueCalendarType=r;this._oValueFormat=t}return t};_.prototype._getFormatInstance=function(t,e){return u.getInstance(t)};_.prototype._checkStyle=function(t){return t==="short"||t==="medium"||t==="long"||t==="full"};_.prototype._getDisplayFormatPattern=function(){var t=this._getBoundValueTypePattern();if(t){return t}t=this.getDisplayFormat();if(this._checkStyle(t)){t=this._getLocaleBasedPattern(t)}return t};_.prototype._getBoundValueTypePattern=function(){var a=this.getBinding("value"),r=a&&a.getType&&a.getType();if(r instanceof t){return r.getOutputPattern()}if(r instanceof e&&r.getFormat){return r.getFormat().oFormatOptions.pattern}return undefined};_.prototype._isValidDate=function(t){return!t||Object.prototype.toString.call(t)==="[object Date]"};_.prototype._getTextForPickerValueStateContent=function(){return this.getValueStateText()||this._getDefaultTextForPickerValueStateContent()};_.prototype._getDefaultTextForPickerValueStateContent=function(){var t=this.getValueState(),e,a;if(t===d.None){a=""}else{e=s.getLibraryResourceBundle("sap.ui.core");a=e.getText("VALUE_STATE_"+t.toUpperCase())}return a};return _});
//# sourceMappingURL=DateTimeField.js.map