/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/format/DateFormat","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/DateTypeRange","sap/ui/unified/library","sap/ui/core/LocaleData","sap/ui/core/Locale","sap/ui/core/delegate/ItemNavigation","sap/ui/core/dnd/DragDropInfo","sap/ui/core/CustomData","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/core/Core","./Link","./library","./PlanningCalendarLegend","./SinglePlanningCalendarMonthGridRenderer","sap/ui/thirdparty/jquery","sap/ui/core/InvisibleMessage","sap/ui/core/library","sap/ui/core/date/CalendarWeekNumbering","sap/ui/core/date/CalendarUtils","sap/ui/core/Configuration","sap/ui/core/date/UI5Date","sap/ui/unified/DateRange"],function(e,t,a,n,i,r,o,s,l,g,p,u,c,d,h,f,D,m,jQuery,_,y,v,S,C,A,b){"use strict";var M=1.5625;var R=1.5;var I=2.125;var P=1.75;var k=y.InvisibleMessageMode;var L=f.SinglePlanningCalendarSelectionMode;var T=f.LinkAccessibleRole;var E=e.extend("sap.m.SinglePlanningCalendarMonthGrid",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},enableAppointmentsDragAndDrop:{type:"boolean",group:"Misc",defaultValue:false},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},calendarWeekNumbering:{type:"sap.ui.core.date.CalendarWeekNumbering",group:"Appearance",defaultValue:null},dateSelectionMode:{type:"sap.m.SinglePlanningCalendarSelectionMode",group:"Behavior",defaultValue:L.SingleSelect}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment",dnd:{draggable:true}},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},_appsPlaceholders:{type:"sap.m.SinglePlanningCalendarMonthGrid._internal.IntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}},selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"}},dnd:true,associations:{legend:{type:"sap.m.PlanningCalendarLegend",multiple:false}},events:{cellPress:{parameters:{startDate:{type:"object"},endDate:{type:"object"}}},moreLinkPress:{parameters:{date:{type:"object"}}},appointmentDrop:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},startDate:{type:"object"},endDate:{type:"object"},copy:{type:"boolean"}}},appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"}}}}},renderer:m});E.prototype.init=function(){this._aLinks=[];this._handleMorePress=this._handleMorePress.bind(this);this._oDateFormat=t.getDateTimeInstance({pattern:"YYYYMMdd"});this._oFormatAriaApp=t.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' "+this._getCoreLocaleData().getTimePattern("medium")});this._oFormatAriaFullDayCell=t.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY"});this.setStartDate(A.getInstance());this._configureAppointmentsDragAndDrop();this._oUnifiedRB=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified")};E.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}for(var e=0;e<this._aLinks.length;e++){if(this._aLinks[e]){this._aLinks[e].destroy()}}delete this._aLinks};E.prototype.onBeforeRendering=function(){var e=this.getStartDate();this._oAppointmentsToRender=this._calculateAppointmentsNodes(e);this._createAppointmentsDndPlaceholders(e);this._oInvisibleMessage=_.getInstance();if(this.getFirstDayOfWeek()!==-1&&this.getCalendarWeekNumbering()){c.warning("Both properties firstDayOfWeek and calendarWeekNumbering should not be used at the same time!")}};E.prototype._checkDateSelected=function(e){var t=this.getAggregation("selectedDates");var n;var i;var r;if(!t){return false}for(var o=0;o<t.length;o++){n=t[o];i=n.getStartDate()&&a.fromLocalJSDate(n.getStartDate());r=n.getEndDate()&&a.fromLocalJSDate(n.getEndDate());if(i&&e.isSame(i)||i&&r&&e.isSameOrAfter(i)&&e.isSameOrBefore(r)){return true}}return false};E.prototype.onAfterRendering=function(){this._initItemNavigation()};E.prototype._getColumns=function(){return 7};E.prototype._getRows=function(){return 6};E.prototype._getDateFormatter=function(){return this._oDateFormat};E.prototype._getAppointmetsForADay=function(e){return this._oAppointmentsToRender.filter(function(t){return t.start.valueOf()===e.valueOf()})};E.prototype._getPreviousAppointmetsForADay=function(e){return this._oAppointmentsToRender.filter(function(t){return t.start.valueOf()<e.valueOf()&&t.end.valueOf()>=e.valueOf()}).map(function(t){var a={data:t.data,start:t.start,end:t.end,len:t.len,level:t.level,width:t.width};a.width-=n._daysBetween(e,t.start);a.hasPrevious=true;return a},this)};E.prototype.onmouseup=function(e){var t=L.MultiSelect===this.getDateSelectionMode();if(!t&&!(e.metaKey||e.ctrlKey)){this.removeAllSelectedDates()}this._bMultiDateSelect=true;this._fireSelectionEvent(e)};E.prototype.onmousedown=function(e){if(!e.target.classList.contains("sapMSPCMonthWeekNumber")){return}const t=e.originalEvent.target.nextSibling.children[0];const a=this._aGridCells.indexOf(t);this._oItemNavigation.focusItem(a)};E.prototype._rangeSelection=function(e){var t=A.getInstance(e),n=false,i,r,o;for(r=0;r<7;r++){if(!this._checkDateSelected(a.fromLocalJSDate(t))){n=true;break}t.setDate(t.getDate()+1)}t=A.getInstance(e);for(r=0;r<7;r++){o=Date.UTC(t.getFullYear(),t.getMonth(),t.getDate());i=document.querySelector('[sap-ui-date="'+o+'"]');if(!(n&&i&&i.classList.contains("sapMSPCMonthDaySelected"))){this._toggleMarkCell(i,t)}t.setDate(t.getDate()+1)}};E.prototype.removeAllSelectedDates=function(){this.removeAllAggregation("selectedDates")};E.prototype.onkeydown=function(e){var t=L.MultiSelect===this.getDateSelectionMode();if(e.which===u.SPACE||e.which===u.ENTER||e.which===u.ARROW_UP||e.which===u.ARROW_DOWN||e.which===u.ARROW_LEFT||e.which===u.ARROW_RIGHT){if(e.which===u.SPACE&&!e.shiftKey&&t){this._bMultiDateSelect=true}else if(e.which===u.SPACE&&e.shiftKey&&t){this._bCurrentWeekSelection=true}else if((e.which===u.ARROW_UP||e.which===u.ARROW_DOWN||e.which===u.ARROW_LEFT||e.which===u.ARROW_RIGHT)&&e.shiftKey&&t){this._bMultiDateSelectWithArrow=true}this._fireSelectionEvent(e);var a=this._findSrcControl(e);if(a&&a.isA("sap.ui.unified.CalendarAppointment")){var n=a.getSelected()?"APPOINTMENT_SELECTED":"APPOINTMENT_UNSELECTED";this._oInvisibleMessage.announce(this._oUnifiedRB.getText(n),k.Polite)}e.preventDefault()}};E.prototype._findSrcControl=function(e){var t=e.target,a=t.parentElement,n;if(!a||a.classList.contains("sapMSPCMonthDays")){return e.srcControl}else if(a.classList.contains("sapUiCalendarRowApps")){n=a.getAttribute("data-sap-ui-related")||a.id}else{n=t.getAttribute("data-sap-ui-related")||t.id}return this.getAppointments().find(function(e){return e.sId===n})};E.prototype._handelMultiDateSelection=function(e,t,n,i){if(this._bMultiDateSelect){this._bMultiDateSelect=false;this._toggleMarkCell(e,t)}else if(this._bMultiDateSelectWithArrow){this._bMultiDateSelectWithArrow=false;var r=A.getInstance(a.fromLocalJSDate(t));switch(i.which){case u.ARROW_UP:r.setDate(r.getDate()-7);break;case u.ARROW_DOWN:r.setDate(r.getDate()+7);break;case u.ARROW_LEFT:r.setDate(r.getDate()-1);break;case u.ARROW_RIGHT:r.setDate(r.getDate()+1);break;default:break}e=document.querySelector('[sap-ui-date="'+r.getTime()+'"]');t=A.getInstance(r.getTime());t=A.getInstance(r.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate());this._toggleMarkCell(e,t)}else if(this._bCurrentWeekSelection&&L.MultiSelect===this.getDateSelectionMode()){var o=t.getDate(),l=S.getWeekConfigurationValues(this.getCalendarWeekNumbering(),new s(C.getFormatSettings().getFormatLocale().toString())),g=this.getFirstDayOfWeek(),p,c;this._bCurrentWeekSelection=false;if(g<0||g>6){if(l){p=l.firstDayOfWeek}else{var d=this._getCoreLocaleData();p=d.getFirstDayOfWeek()}}else{p=g}c=o-t.getDay()+p;if(c>o){c-=7}t.setDate(c);n.setDate(t.getDate()+6);this._rangeSelection(t,n)}};E.prototype._fireSelectionEvent=function(e){var t=this._findSrcControl(e),a=e.target,n=a&&a.classList.contains("sapMSPCMonthDay"),i=a&&a.classList.contains("sapMLnk"),r=a&&a.classList.contains("sapMSPCMonthWeekNumber"),o=r&&e.originalEvent.target.nextSibling.children[0],s,l,g;if(t&&t.isA("sap.m.SinglePlanningCalendarMonthGrid")&&n&&!i){s=parseInt(a.getAttribute("sap-ui-date"));l=A.getInstance(s);l=A.getInstance(l.getUTCFullYear(),l.getUTCMonth(),l.getUTCDate());g=A.getInstance(l);g.setDate(g.getDate()+1);if(this._bMultiDateSelect||this._bCurrentWeekSelection||this._bMultiDateSelectWithArrow){this._handelMultiDateSelection(a,l,g,e);this.fireEvent("selectDate",{startDate:l,endDate:g})}this.fireEvent("cellPress",{startDate:l,endDate:g});this.fireAppointmentSelect({appointment:undefined,appointments:this._toggleAppointmentSelection(undefined,true)})}else if(r){s=parseInt(o.getAttribute("sap-ui-date"));l=A.getInstance(s);l=A.getInstance(l.getUTCFullYear(),l.getUTCMonth(),l.getUTCDate());g=A.getInstance(l);g.setDate(g.getDate()+6);this._bCurrentWeekSelection=true;this._bMultiDateSelect=false;this._handelMultiDateSelection(a,l,g,e);this.fireEvent("selectDate",{startDate:l,endDate:g})}else if(t&&t.isA("sap.ui.unified.CalendarAppointment")){if(a.parentElement&&a.parentElement.getAttribute("id")){var p=a.parentElement.getAttribute("id");var u=a.parentElement.getAttribute("data-sap-ui-related");var c=p.replace(u+"-","");t._setAppointmentPartSuffix(c)}this.fireAppointmentSelect({appointment:t,appointments:this._toggleAppointmentSelection(t,!(e.ctrlKey||e.metaKey))})}};E.prototype._toggleMarkCell=function(e,t){if(e&&!e.classList.contains("sapMSPCMonthDaySelected")){this.addAggregation("selectedDates",new b({startDate:A.getInstance(t)}))}else{var n=this.getAggregation("selectedDates");if(!n){return}for(var i=0;i<n.length;i++){var r=n[i].getStartDate();if(a.fromLocalJSDate(r).isSame(a.fromLocalJSDate(t))){this.removeAggregation("selectedDates",i);break}}}};E.prototype._toggleAppointmentSelection=function(e,t){var a=[],n=e&&e.getDomRef(),i,r,o;if(t){i=this.getAppointments();for(o=0,r=i.length;o<r;o++){if((!e||i[o].getId()!==e.getId())&&i[o].getSelected()){i[o].setProperty("selected",false);a.push(i[o])}}}if(e){e.setProperty("selected",!e.getSelected());a.push(e);this._sSelectedAppointment=e.getSelected()&&n?e:undefined}else{this._sSelectedAppointment=undefined}return a};E.prototype._getMoreLink=function(e,t,a){var n=d.getLibraryResourceBundle("sap.m").getText("SPC_MORE_LINK",[e.toString()]),i=new h({accessibleRole:T.Button,text:n,press:this._handleMorePress}).addCustomData(new p({key:"date",value:t.valueOf().toString(),writeToDom:true}));if(this._aLinks[a]){this._aLinks[a].destroy()}this._aLinks[a]=i;return i};E.prototype._handleMorePress=function(e){var t=parseInt(e.getSource().getCustomData()[0].getValue()),a=A.getInstance(t);a=A.getInstance(a.getUTCFullYear(),a.getUTCMonth(),a.getUTCDate());this.fireEvent("moreLinkPress",{date:a})};E.prototype._getCoreLocaleData=function(){var e=d.getConfiguration().getFormatSettings().getFormatLocale().toString(),t=new s(e);return o.getInstance(t)};E.prototype._getCells=function(){return this._getVisibleDays(this.getStartDate())};E.prototype._getVerticalLabels=function(){var e=this._getVisibleDays(this.getStartDate()),a=this._getColumns(),n=[],i=d.getConfiguration().getFormatLocale().toString();for(var r=0;r<this._getRows();r++){var o=t.getInstance({pattern:"w",calendarType:"Gregorian",calendarWeekNumbering:this.getCalendarWeekNumbering()},new s(i));var l=Number(o.format(e[r*a].toUTCJSDate(),true));n.push(l)}return n};E.prototype._getVisibleDays=function(e){var t,n,i,r,o,s,l=[];if(!e){return l}s=this._getFirstDayOfWeek();t=a.fromLocalJSDate(e);o=new a(t);o.setDate(1);r=o.getDay()-s;if(r<0){r=7+r}if(r>0){o.setDate(1-r)}n=new a(o);for(var g=0;g<this._getColumns()*this._getRows();g++){i=new a(n);l.push(i);n.setDate(n.getDate()+1)}return l};E.prototype._getFirstDayOfWeek=function(){var e,t;if(this.getFirstDayOfWeek()<0||this.getFirstDayOfWeek()>6){e=S.getWeekConfigurationValues(this.getCalendarWeekNumbering(),new s(C.getFormatSettings().getFormatLocale().toString()));if(e){return e.firstDayOfWeek}else{t=this._getCoreLocaleData();return t.getFirstDayOfWeek()}}else{return this.getFirstDayOfWeek()}};E.prototype._getAppointmentsToRender=function(){return this._oAppointmentsToRender};E.prototype._calculateAppointmentsNodes=function(e){var t=this._getVisibleDays(e),i=t[0],r=t[t.length-1],o=this.getAppointments().filter(function(e){var t=e.getStartDate()&&e.getEndDate();if(!t){c.warning("Appointment "+e.getId()+" has no start or no end date. It is ignored.")}return t}).map(function(e){var t=a.fromLocalJSDate(e.getStartDate()),i=a.fromLocalJSDate(e.getEndDate());return{data:e,start:t,end:i,len:n._daysBetween(i,t)}}).filter(function(e){return n._isBetween(e.start,i,r,true)||n._isBetween(e.end,i,r,true)||n._isBetween(i,e.start,r,true)&&n._isBetween(r,i,e.end,true)}).sort(function e(t,a){return t.start.valueOf()-a.start.valueOf()}),s=[],l,g,p,u,d,h,f;for(d=0;d<t.length;d++){s.push([])}for(d=0;d<o.length;d++){l=o[d];g=n._daysBetween(l.start,t[0]);p=g+l.len;g=g>0?g:0;p=p<t.length?p:t.length-1;l.width=l.len+1;u=s[g].indexOf(true);if(u===-1){u=s[g].length}l.level=u;for(h=g;h<=p;h++){s[h][u]=false;for(f=0;f<u;f++){if(s[h][f]===undefined){s[h][f]=true}}}}this._aAppsLevelsPerDay=s;return o};E.prototype._getMoreCountPerCell=function(e){var t=this._aAppsLevelsPerDay[e];var a=this._getMaxAppointments();var n=0;if(t.length<a){return 0}for(var i=a-1;i<t.length;i++){if(!t[i]){n++}}return n};E.prototype._configureAppointmentsDragAndDrop=function(){this.addDragDropConfig(new g({sourceAggregation:"appointments",targetAggregation:"_appsPlaceholders",dragStart:function(e){if(!this.getEnableAppointmentsDragAndDrop()){e.preventDefault();return false}var t=function(){var e=jQuery(".sapMSinglePCOverlay");setTimeout(function(){e.addClass("sapMSinglePCOverlayDragging")});jQuery(document).one("dragend",function(){e.removeClass("sapMSinglePCOverlayDragging")})};t()}.bind(this),dragEnter:function(e){var t=e.getParameter("dragSession"),a=function(){var e=jQuery(t.getIndicator());e.css("min-height",t.getDropControl().$().outerHeight());e.css("min-width",t.getDropControl().$().outerWidth())};if(!t.getIndicator()){setTimeout(a,0)}else{a()}},drop:function(e){var t=e.getParameter("dragSession"),i=t.getDragControl(),r=t.getDropControl(),o=r.getDate(),s=a.fromLocalJSDate(i.getStartDate()),l=a.fromLocalJSDate(i.getEndDate()),g=n._daysBetween(o,s),p=new a(s),u=new a(l),c=e.getParameter("browserEvent"),d=c.metaKey||c.ctrlKey;p.setDate(p.getDate()+g);u.setDate(u.getDate()+g);this.$().find(".sapMSinglePCOverlay").removeClass("sapMSinglePCOverlayDragging");if(s.valueOf()===o.valueOf()){return}this.fireAppointmentDrop({appointment:i,startDate:p.toLocalJSDate(),endDate:u.toLocalJSDate(),copy:d})}.bind(this)}))};E.prototype._initItemNavigation=function(){var e=this.getDomRef();this._aGridCells=this.$().find(".sapMSPCMonthDay").toArray();if(!this._oItemNavigation){this._oItemNavigation=new l;this.addDelegate(this._oItemNavigation);this._oItemNavigation.attachEvent(l.Events.BorderReached,this._itemNavigationBorderReached,this)}this._oItemNavigation.setRootDomRef(e);this._oItemNavigation.setItemDomRefs(this._aGridCells);this._oItemNavigation.setCycling(false);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt","meta"],sapend:["meta"]});this._oItemNavigation.setTableMode(false).setColumns(this._getColumns(),true);this._oItemNavigation.setPageSize(this._aGridCells.length)};E.prototype._itemNavigationBorderReached=function(e){var t,a,n=e.getParameter("event"),i;if(n.target.classList.contains("sapMSPCMonthDay")){t=n.target;a=parseInt(t.getAttribute("sap-ui-date"));switch(n.keyCode){case u.ARROW_LEFT:i=-1;break;case u.ARROW_UP:i=-this._getColumns();break;case u.ARROW_RIGHT:i=1;break;case u.ARROW_DOWN:i=this._getColumns();break;default:break}this.fireEvent("borderReached",{startDate:a,offset:i})}};E.prototype._createAppointmentsDndPlaceholders=function(e){var t=this._getVisibleDays(e);this.destroyAggregation("_appsPlaceholders");for(var a=0;a<t.length;a++){var n=new W({date:t[a]});this.addAggregation("_appsPlaceholders",n,true)}};var W=e.extend("sap.m.SinglePlanningCalendarMonthGrid._internal.IntervalPlaceholder",{metadata:{properties:{date:{type:"object",group:"Data"}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t).class("sapMSinglePCPlaceholder").openEnd().close("div")}}});E.prototype._getCellStartInfo=function(e){var t=d.getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_START_TIME");return t+": "+this._oFormatAriaFullDayCell.format(e)+"; "};E.prototype._getAppointmentAnnouncementInfo=function(e){var t=d.getLibraryResourceBundle("sap.ui.unified"),a=t.getText("CALENDAR_START_TIME"),n=t.getText("CALENDAR_END_TIME"),i=this._oFormatAriaApp.format(e.getStartDate()),r=this._oFormatAriaApp.format(e.getEndDate()),o=a+": "+i+"; "+n+": "+r;return o+"; "+D.findLegendItemForItem(d.byId(this._sLegendId),e)};E.prototype._getMaxAppointments=function(){return this._isCompact()?4:3};E.prototype._getDensitySizes=function(){return this._isCompact()?{appHeight:M,cellHeaderHeight:R}:{appHeight:I,cellHeaderHeight:P}};E.prototype._isCompact=function(){var e=this.getDomRef()||(this.getParent()&&this.getParent().getDomRef&&this.getParent().getDomRef()||this.getParent()&&this.getParent().getRootNode&&this.getParent().getRootNode()||document.body);while(e&&e.classList){if(e.classList.contains("sapUiSizeCompact")){return true}e=e.parentNode}return false};E.prototype._getSpecialDates=function(){var e=this.getSpecialDates();for(var t=0;t<e.length;t++){var a=e[t].getSecondaryType()===r.CalendarDayType.NonWorking&&e[t].getType()!==r.CalendarDayType.NonWorking;if(a){var n=new i;n.setType(r.CalendarDayType.NonWorking);n.setStartDate(e[t].getStartDate());if(e[t].getEndDate()){n.setEndDate(e[t].getEndDate())}e.push(n)}}return e};E.prototype._isNonWorkingDay=function(e){return this._getSpecialDates().filter(function(e){return e.getType()===r.CalendarDayType.NonWorking}).map(function(e){return a.fromLocalJSDate(e.getStartDate())}).some(function(t){return t.isSame(e)})};E.prototype.applyFocusInfo=function(){this._sSelectedAppointment&&this._sSelectedAppointment.focus();return this};return E});
//# sourceMappingURL=SinglePlanningCalendarMonthGrid.js.map