/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/library","sap/ui/core/Control","sap/ui/model/type/Date","sap/ui/model/odata/type/ODataType","sap/ui/core/format/DateFormat","sap/ui/core/LocaleData","sap/ui/core/Locale","./library","./Button","sap/ui/core/date/UI5Date","./TimePickerInternalsRenderer","sap/ui/core/Configuration"],function(t,e,r,o,i,n,s,a,u,p,l,c){"use strict";var y=1,h=a.ButtonType,_=t.CalendarType;var g=e.extend("sap.m.TimePickerInternals",{metadata:{library:"sap.m",properties:{localeId:{type:"string",group:"Data"},displayFormat:{type:"string",group:"Appearance"},minutesStep:{type:"int",group:"Misc",defaultValue:y},secondsStep:{type:"int",group:"Misc",defaultValue:y},value:{type:"string",group:"Data",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},support2400:{type:"boolean",group:"Misc",defaultValue:false},showCurrentTimeButton:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{_buttonAmPm:{type:"sap.m.SegmentedButton",multiple:false,visibility:"hidden"},_nowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}}},renderer:l});g.prototype.init=function(){var t=c.getFormatSettings().getFormatLocale(),e=n.getInstance(t),r=e.getDayPeriods("abbreviated"),o=e.getTimePattern("medium");this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sAM=r[0];this._sPM=r[1];this._kbdBuffer="";this.setDisplayFormat(o);this._setTimeValues();this._sMinutes;this._sSeconds;this._clickAttached;this._setAriaLabel(this._oResourceBundle.getText("TIMEPICKER_CLOCK_DIAL_LABEL"));this._setAriaRoleDescription(this._oResourceBundle.getText("TIMEPICKER_INPUTS_ROLE_DESCRIPTION"))};g.prototype.exit=function(){this._destroyControls();this.destroyAggregation("_texts");if(this._oNowButton){this._oNowButton.destroy();this._oNowButton=null}};g.prototype.setDisplayFormat=function(t){this.setProperty("displayFormat",t,true);this._destroyControls();this._createControls();return this};g.prototype.setLocaleId=function(t){var e,r;t=this.validateProperty("localeId",t);this.setProperty("localeId",t,true);if(t){e=new s(t);r=n.getInstance(e).getDayPeriods("abbreviated");this._sAM=r[0];this._sPM=r[1];this._destroyControls();this._createControls()}return this};g.prototype.setSupport2400=function(t){this.setProperty("support2400",t,true);this._destroyControls();this._createControls();return this};g.prototype.setMinutesStep=function(t){this.setProperty("minutesStep",t,true);this._destroyControls();this._createControls();return this};g.prototype.setSecondsStep=function(t){this.setProperty("secondsStep",t,true);this._destroyControls();this._createControls();return this};g.prototype.setShowCurrentTimeButton=function(t){this._getCurrentTimeButton().setVisible(t);return this.setProperty("showCurrentTimeButton",t)};g.prototype._destroyControls=function(){};g.prototype._createControls=function(){};g.prototype._setTimeValues=function(t,e){};g.prototype._checkStyle=function(t){return t==="short"||t==="medium"||t==="long"||t==="full"};g.prototype._getDisplayFormatPattern=function(){var t=this.getDisplayFormat();if(this._checkStyle(t)){t=this._getLocaleBasedPattern(t)}return t};g.prototype._getValueFormatPattern=function(){var t=this._getBoundValueTypePattern()||this.getValueFormat()||"medium";if(this._checkStyle(t)){t=this._getLocaleBasedPattern(t)}return t};g.prototype._getLocaleBasedPattern=function(t){return n.getInstance(c.getFormatSettings().getFormatLocale()).getTimePattern(t)};g.prototype._getFormatButton=function(){return this.getAggregation("_buttonAmPm")};g.prototype._parseValue=function(t){return this._getFormatter().parse(t)};g.prototype._getFormatter=function(){var t=this._getBoundValueTypePattern(),e=false,r=this.getBinding("value"),o;if(r&&r.oType&&r.oType.oOutputFormat){e=!!r.oType.oOutputFormat.oFormatOptions.relative;o=r.oType.oOutputFormat.oFormatOptions.calendarType}if(!t){t=this.getValueFormat()||"medium";o=_.Gregorian}if(!o){o=c.getCalendarType()}return this._getFormatterInstance(t,e,o)};g.prototype._getBoundValueTypePattern=function(){var t=this.getBinding("value"),e=t&&t.getType&&t.getType();if(e instanceof r){return e.getOutputPattern()}if(e instanceof o&&e.oFormat){return e.oFormat.oFormatOptions.pattern}return undefined};g.prototype._getFormatterInstance=function(t,e,r,o){var i;if(this._checkStyle(t)){i=this._getFormatInstance({style:t,strictParsing:true,relative:e,calendarType:r})}else{i=this._getFormatInstance({pattern:t,strictParsing:true,relative:e,calendarType:r})}return i};g.prototype._getFormatInstance=function(t,e){return i.getTimeInstance(t)};g.prototype._formatValue=function(t){if(t){return this._getFormatter().format(t)}return""};g.prototype._isFormatSupport24=function(){var t=this._getDisplayFormatPattern();return t.indexOf("HH")!==-1||t.indexOf("H")!==-1};g.prototype._formatNumberToString=function(t,e,r,o){var i;if(e&&t<10){i="0"+t}else if(t===r&&o!==""){i=o}else{i=t.toString()}return i};g.prototype._setAriaLabel=function(t){this._sAriaLabel=t;return this};g.prototype._getAriaLabel=function(){return this._sAriaLabel};g.prototype._setAriaRoleDescription=function(t){this._sAriaRoleDescription=t;return this};g.prototype._getAriaRoleDescription=function(){return this._sAriaRoleDescription};g._replaceZeroHoursWith24=function(t,e,r){var o=2,i=e;if(e===-1){o=1;i=r}return t.substr(0,i)+"24"+t.substr(i+o)};g._replace24HoursWithZero=function(t,e,r){var o=2,i=e;if(e===-1){o=1;i=r}return t.substr(0,i)+f(0,o)+t.substr(i+2)};g._isHoursValue24=function(t,e,r){if(e===-1&&r===-1){return false}var o=e;if(e===-1){o=r}return t.substr(o,2)==="24"};g.prototype._getCurrentTimeButton=function(){if(!this._oNowButton){this._oNowButton=new u(this.getId()+"-now",{icon:"sap-icon://present",tooltip:this._oResourceBundle.getText("TIMEPICKER_TOOLTIP_NOW"),type:h.Transparent,visible:false,press:function(){this._setTimeValues(p.getInstance())}.bind(this)}).addStyleClass("sapMTPNow")}return this._oNowButton};function f(t,e){var r="";for(var o=0;o<e;o++){r+=t}return r}return g});
//# sourceMappingURL=TimePickerInternals.js.map