/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/array/diff","sap/ui/base/Object","sap/base/util/merge","sap/base/util/deepEqual","sap/m/p13n/SelectionPanel","sap/m/p13n/modules/xConfigAPI","sap/ui/core/Configuration","sap/ui/core/mvc/View"],function(e,t,r,n,o,a,i,s){"use strict";var p=t.extend("sap.m.p13n.SelectionController",{constructor:function(e){t.call(this);this._oAdaptationControl=e.control;this._aStableKeys=e.stableKeys||[];if(!this._oAdaptationControl){throw new Error("Always provide atleast a 'control' configuration when creating a new p13n controller!")}this._sTargetAggregation=e.targetAggregation;this._fSelector=e.getKeyForItem;this._oP13nData=null;this._bLiveMode=false;this._bResetEnabled=false;this._bReorderingEnabled=e.hasOwnProperty("enableReorder")?e.enableReorder:true}});p.prototype.getAdaptationControl=function(){return this._oAdaptationControl};p.prototype.getTargetAggregation=function(){return this._sTargetAggregation};p.prototype.getChangeOperations=function(){return{add:"addItem",remove:"removeItem",move:"moveItem"}};p.prototype.getSelectorForReset=function(){return this._oAdaptationControl};p.prototype.sanityCheck=function(e){return e};p.prototype.initAdaptationUI=function(e){var t=this.mixInfoAndState(e);this._oPanel=this.createUI(t);return Promise.resolve(this._oPanel)};p.prototype.createUI=function(e){var t=new o({showHeader:true,enableCount:true});t.setEnableReorder(this._bReorderingEnabled);return t.setP13nData(e.items)};var u=function(e){if(e instanceof s){return e}if(e&&typeof e.getParent==="function"){e=e.getParent();return u(e)}};p.prototype._calcPresentState=function(){const e=[],t=this.getAdaptationControl().getAggregation(this.getTargetAggregation())||[];const r=u(this.getAdaptationControl());t.forEach((t,n)=>{const o=t.data("p13nKey");const a=r?r.getLocalId(t.getId()):t.getId();const i=o||(this._fSelector?this._fSelector(t):t.getVisible());if(i){e.push({key:typeof i==="boolean"?a:i})}});return e};p.prototype.getCurrentState=function(){const e=this._calcPresentState();const t=a.readConfig(this.getAdaptationControl())||{};const r=t.hasOwnProperty("aggregations")?t.aggregations[this._sTargetAggregation]:{};const n=[];if(r){Object.entries(r).forEach(([e,t])=>{n.push({key:e,position:t.position,visible:t.visible})});n.sort((e,t)=>e.position-t.position)}n.sort((e,t)=>e.position-t.position);n.forEach(({key:t})=>{const n=e.map(e=>e.key);let o=n.indexOf(t);const a=r[t].position;const i=r[t].visible!==false;const s=a!==undefined;if(i&&o===-1){e.push({key:t})}if(i&&s&&e.length>0){var p=e.splice(o,1)[0];e.splice(a,0,p);o=a}if(r[t].visible===false&&o>-1){e.splice(o,1)}});return e};p.prototype.getStateKey=function(){return"items"};p.prototype.getDelta=function(e){var t=this._getPresenceAttribute(e.externalAppliance);var r;var o=function(e){return e.hasOwnProperty(t)&&e[t]===false?false:true};r=e.applyAbsolute?e.changedState.filter(o):this._getFilledArray(e.existingState,e.changedState,t).filter(o);this._aStableKeys.forEach(function(e,t){var n=this.arrayToMap(this.getCurrentState());var o=this.arrayToMap(r);var a=n[e]||t-1;if(!o.hasOwnProperty(e)){r.splice(a,0,n[e])}}.bind(this));e.changedState=r;if(n(e.existingState,r)){return[]}else{return this.getArrayDeltaChanges(e)}};p.prototype.getArrayDeltaChanges=function(e){var t=e.existingState;var r=e.changedState;var n=e.control;var o=e.changeOperations.add;var a=e.changeOperations.remove;var i=e.changeOperations.move;var s=e.deltaAttributes||[];var p=this._calculateDeleteInserts(t,r,s);var u=this._createAddRemoveChanges(p.deletes,n,a,s);if(i){var l=this._removeItems(t,p.deletes);var c=this._removeItems(r,p.inserts);var h=this._createMoveChanges(l,c,n,i,s);u=u.concat(h)}var g=this._createAddRemoveChanges(p.inserts,n,o,s);u=u.concat(g);return u};p.prototype._createMoveChanges=function(t,r,n,o,a){var i,s,p,u=[];if(t.length===r.length){var l=function(e){var t="";a.forEach(function(r){t=t+e[r]});return t};var c=e(t,r,l);var h=[];for(var g=0;g<c.length;g++){if(c[g].type==="delete"){p=t[c[g].index];h.push(p)}else if(c[g].type==="insert"){i=r[c[g].index].key||r[c[g].index].name;s=c[g].index;h.forEach(function(e){if(i!=e.key){var r=this._indexOfByKeyName(t,e.key||e.name);if(r<c[g].index){s++}}}.bind(this));u.push(this._createMoveChange(i,Math.min(s,r.length),o,n))}}}return u};p.prototype._createAddRemoveChanges=function(e,t,r,n){var o=[];for(var a=0;a<e.length;a++){o.push(this._createAddRemoveChange(t,r,this._getChangeContent(e[a],n)))}return o};p.prototype._removeItems=function(e,t){var r;var n=[];for(var o=0;o<e.length;o++){r=e[o].key||e[o].name;if(this._indexOfByKeyName(t,r)===-1){n.push(e[o])}}return n};p.prototype._indexOfByKeyName=function(e,t){var r=-1;e.some(function(e,n){if(e.key===t||e.name===t){r=n}return r!=-1});return r};p.prototype._calculateDeleteInserts=function(e,t,n){var o,a,i,s;var p={deletes:[],inserts:[]};for(o=0;o<e.length;o++){a=e[o].key||e[o].name;s=this._indexOfByKeyName(t,a);if(s===-1){i=r({},e[o]);p.deletes.push(i)}else if(n.length){if(this._verifyDeltaAttributes(e[o],t[s],n)){p.deletes.push(e[o]);i=r({},t[s]);i.index=s;p.inserts.push(i)}}}for(o=0;o<t.length;o++){a=t[o].key||t[o].name;if(this._indexOfByKeyName(e,a)===-1){i=r({},t[o]);i.index=o;p.inserts.push(i)}}return p};p.prototype._verifyDeltaAttributes=function(e,t,r){var n=false;r.some(function(r){if(!e.hasOwnProperty(r)&&t.hasOwnProperty(r)||e.hasOwnProperty(r)&&!t.hasOwnProperty(r)||e[r]!=t[r]){n=true}return n});return n};p.prototype._getChangeContent=function(e,t){var r={};if(e.hasOwnProperty("index")&&e.index>=0){r.index=e.index}t.forEach(function(t){if(e.hasOwnProperty(t)){r[t]=e[t]}});return r};p.prototype._createAddRemoveChange=function(e,t,r){var n=r;if(t.indexOf("set")!==0){n.value=t==this.getChangeOperations()["add"]}n.targetAggregation=this.getTargetAggregation();var o={selectorElement:e,changeSpecificData:{changeType:t,content:n}};return o};p.prototype._createMoveChange=function(e,t,r,n){var o={selectorElement:n,changeSpecificData:{changeType:r,content:{key:e,targetAggregation:this.getTargetAggregation(),index:t}}};return o};p.prototype._getPresenceAttribute=function(e){return"visible"};p.prototype.getBeforeApply=function(){return Promise.resolve()};p.prototype.mixInfoAndState=function(e){var t=this.getCurrentState();var r=this.arrayToMap(t);var n=this.prepareAdaptationData(e,function(e,t){var n=r[t.name||t.key];e.visible=!!n;e.position=n?n.position:-1;return!(t.visible===false||this._aStableKeys.indexOf(t.name||t.key)>-1)}.bind(this));this.sortP13nData({visible:"visible",position:"position"},n.items);n.items.forEach(function(e){delete e.position});return n};p.prototype.getP13nData=function(){return this._oPanel?this._oPanel.getP13nData():this._oAdaptationModel&&this._oAdaptationModel.getProperty("/items")};p.prototype.model2State=false;p.prototype.update=function(e){if(this._oPanel){if(!this._oPanel.isDestroyed()){var t=this.mixInfoAndState(e);this._oPanel.setP13nData(t.items)}}else if(this._oAdaptationModel){var r=this.mixInfoAndState(e);this._oAdaptationModel.setProperty("/items",r.items);this._oAdaptationModel.setProperty("/itemsGrouped",r.itemsGrouped)}};p.prototype._getFilledArray=function(e,t,n){var o=r([],e);var a=r([],t);a.forEach(function(e){var t=this.arrayToMap(o);var r=t[e.key];if(!e.hasOwnProperty(n)||e[n]){var a=e.position;if(r){a=a>-1?a:r.position;var i=r.position;o.splice(a,0,o.splice(i,1)[0])}else{a=a>-1?a:o.length;o.splice(a,0,e)}o[a]=e}else if(r){o[r.position][n]=false}}.bind(this));return o};p.prototype.getPropertySetterChanges=function(e){var t=e.control;var r=e.existingState;var n=e.changedState;var o=e.operation;var a=e.deltaAttribute;var i=[];n.forEach(function(e){if(e.hasOwnProperty(a)){var n=r.find(function(t){return t.name==e.name});var s=n&&n.hasOwnProperty(a)&&n[a];var p=e[a];var u=s!==p;if(u){i.push(this._createAddRemoveChange(t,o,{[e.hasOwnProperty("key")?"key":"name"]:e.key||e.name,targetAggregation:this.getTargetAggregation(),value:e[a]}))}}}.bind(this));return i};p.prototype.changesToState=function(e){var t=[];e.forEach(function(e){var n=r({},e.changeSpecificData.content);var o=n.index;delete n.index;if(o!==undefined){n.position=o}if(e.changeSpecificData.changeType===this.getChangeOperations()["remove"]){n[this._getPresenceAttribute()]=false}t.push(n)}.bind(this));return t};p.prototype.prepareAdaptationData=function(e,t,r){var n=[];var o=r?{}:null;var a=t instanceof Function;e.getProperties().forEach(function(e){var r={};r.key=e.name||e.key;r.name=e.name||e.key;if(a){var i=t(r,e);if(!i){return}}r.label=e.label||r.key;r.tooltip=e.tooltip;if(o){r.group=e.group?e.group:"BASIC";r.groupLabel=e.groupLabel;o[r.group]=o[r.group]?o[r.group]:[];o[r.group].push(r)}n.push(r)});var i={items:n};if(o){i.itemsGrouped=this._buildGroupStructure(o)}return i};p.prototype._buildGroupStructure=function(e){var t=[];Object.keys(e).forEach(function(r){this.sortP13nData("generic",e[r]);t.push({group:r,groupLabel:e[r][0].groupLabel||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("p13n.BASIC_DEFAULT_GROUP"),groupVisible:true,items:e[r]})}.bind(this));return t};p.prototype.sortP13nData=function(e,t){var r=e;var n=r.position;var o=r.visible;var a=i.getLocale().toString();var s=window.Intl.Collator(a,{});t.sort(function(e,t){if(e[o]&&t[o]){return(e[n]||0)-(t[n]||0)}else if(e[o]){return-1}else if(t[o]){return 1}else if(!e[o]&&!t[o]){return s.compare(e.label,t.label)}})};p.prototype.arrayToMap=function(e){return e.reduce(function(e,t,r){e[t.key]=t;e[t.key].position=r;return e},{})};p.prototype.destroy=function(){t.prototype.destroy.apply(this,arguments);this._oAdaptationControl=null;this._bLiveMode=null;this._oPanel=null;this._bResetEnabled=null;this._oAdaptationModel=null};return p});
//# sourceMappingURL=SelectionController.js.map