/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Core","sap/ui/core/Element","sap/ui/core/HTML","sap/m/Button","sap/m/Image","sap/m/PDFViewer","sap/m/Dialog","sap/m/IllustratedMessage","sap/m/IllustratedMessageType","sap/m/Carousel","sap/base/Log"],function(e,t,i,o,s,a,n,r,l,c,u){"use strict";const h=e.getLibraryResourceBundle("sap.m");const g={Png:"image/png",Bmp:"image/bmp",Jpeg:"image/jpeg",Gif:"image/gif",Txt:"text/plain",Pdf:"application/pdf",ChromePdf:"application/x-google-chrome-pdf",Mpeg:"video/mpeg",Mp4:"video/mp4",Quicktime:"video/quicktime",MsVideo:"video/x-msvideo",Vds:"model/vnd.sap.vds"};const d=t.extend("sap.m.upload.FilePreviewDialog",{library:"sap.m",metadata:{properties:{showCarouselArrows:{type:"boolean",defaultValue:true},maxFileSizeforPreview:{type:"float",defaultValue:null}},defaultAggregation:"additionalFooterButtons",aggregations:{additionalFooterButtons:{type:"sap.m.Button",multiple:true}}},_previewItem:null,_items:[],init:function(){this._oRichTextEditor=null;this._oDialog=null;this._oViewer=null;this._oContentResource=null},_open:async function(){const e=this._items;if(e?.length&&this._previewItem){this._oCarousel=await this._createCarousel();if(!this._oDialog){this._oDialog=this._createDialog()}else{this._oDialog.setTitle(this._previewItem?.getFileName()||"");this._oDialog.removeAllContent();this._oDialog.insertContent(this._oCarousel)}this.fireEvent("beforePreviewDialogOpen",{oDialog:this._oDialog});this._oDialog.open()}},_loadVkDependency:function(){return new Promise(function(t,i){e.loadLibrary("sap.ui.vk",{async:true}).then(()=>{sap.ui.require(["sap/ui/vk/Viewer","sap/ui/vk/ContentResource"],(e,i)=>{t({viewer:e,contentResource:i})},e=>{i(e)})}).catch(()=>{i("sap.ui.vk.Viewer Control not available.")})})},_loadRichTextEditorDependency:function(){return new Promise((t,i)=>{e.loadLibrary("sap.ui.richtexteditor",{async:true}).then(()=>{sap.ui.require(["sap/ui/richtexteditor/RichTextEditor"],e=>{t(e)},e=>{i(e)})}).catch(()=>{i("RichTextEditor Control not available.")})})},_createIllustratedMessage:function(e){const t=new r({illustrationType:l.NoData,title:e,description:h.getText("FILE_PREVIEW_DIALOG_NO_PREVIEW_AVAILABLE_MSG"),enableVerticalResponsiveness:true});return t},_createVdsViewer:async function(e){if(!this.oViewer||!this._oContentResource){try{const e=await this._loadVkDependency();this._oViewer=e.viewer;this._oContentResource=e.contentResource}catch(e){u.error(e);return null}}const t=new this._oViewer({contentResources:[new this._oContentResource({source:e.getUrl(),sourceType:"vds"})]});return t},_createRichTextEditor:async function(e){if(!this._oRichTextEditor){try{const e=await this._loadRichTextEditorDependency();this._oRichTextEditor=e}catch(e){u.error(e);return null}}const t=new this._oRichTextEditor({height:"100%",width:"100%",editable:false,busy:true});t.attachReady(function(){t.setBusy(false)});const i=new XMLHttpRequest;i.open("GET",e.getUrl(),false);i.send(null);const o=i.responseText;t.setValue(o);return t},_createCarousel:async function(){const e=this._previewItem;let t=!this.getShowCarouselArrows()?[this._previewItem]:this._items;let o="";t=t?.filter(e=>e?.isA("sap.m.upload.UploadSetwithTableItem"));const n=t.map(async t=>{const n=t.getMediaType();const r=t.getFileName();let l=this._createIllustratedMessage(r);if(t.getPreviewable()&&this.isFileSizeWithinMaxLimit(t)){switch(n?.toLowerCase()){case g.Png:case g.Bmp:case g.Jpeg:case g.Gif:{l=new s({src:t.getUrl()});break}case g.Txt:{const e=await this._createRichTextEditor(t);if(e){l=e}break}case g.Pdf:case g.ChromePdf:{l=new a({source:t.getUrl(),showDownloadButton:false});l.setBusy(true);break}case g.Mpeg:case g.Mp4:case g.Quicktime:case g.MsVideo:{l=new i({content:"<video controls width='100%' height='100%' src='"+t.getUrl()+"'>"});break}case g.Tiff:case g.Vds:{const e=await this._createVdsViewer(t);if(e){l=e}break}default:break}}l=!this.isFileSizeWithinMaxLimit(t)?this._getMaxSizePageIllustration(t):l;o=t?.getId()===e?.getId()?l?.getId():o;return l});const r=await Promise.all(n);const l=new c({showPageIndicator:this.getShowCarouselArrows()?true:false,pages:[r],activePage:o,height:"85vh",pageChanged:e=>{const i=r.findIndex(function(t){return t.sId===e.getParameter("newActivePageId")});const o=t[i].getFileName();this._oDialog.setTitle(o)}});if(!this.getShowCarouselArrows()){l.ontouchstart=l.ontouchmove=l.ontouchend=e=>{e.preventDefault()}}return l},_createDialog:function(){const e=this._getActiveUploadSetwithTableItem();const t=new n({title:e.getFileName(),content:this._oCarousel,horizontalScrolling:false,verticalScrolling:false,contentWidth:"100%",contentHeight:"100%",buttons:[this.getAdditionalFooterButtons(),new o({text:h.getText("UPLOAD_SET_TABLE_FILE_PREVIEW_DIALOG_DOWNLOAD"),press:()=>{this._getActiveUploadSetwithTableItem().download(true)}}),new o({text:h.getText("UPLOAD_SET_TABLE_FILE_PREVIEW_DIALOG_CLOSE"),press:()=>{this._oDialog.close()}})]});return t},_getActiveUploadSetwithTableItem:function(){const e=this._oCarousel.getActivePage();const t=this._oCarousel.getPages();const i=t.findIndex(t=>t.sId===e);return this._items[i]},isFileSizeWithinMaxLimit:function(e){let t=this.getMaxFileSizeforPreview();const i=e&&e.getFileSize?e.getFileSize():0;if(!t||!i){return true}t=t*d.MEGABYTE;return i<=t},_getMaxSizePageIllustration:function(e){const t=new r({illustrationType:l.NoData,title:e?.getFileName(),description:h.getText("FILE_PREVIEW_DIALOG_MAX_PREVIEW_SIZE_EXCEEDED",this.getMaxFileSizeforPreview()),enableVerticalResponsiveness:true});return t}});d.MEGABYTE=1048576;return d});
//# sourceMappingURL=FilePreviewDialog.js.map