/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/ui/core/Core","sap/ui/core/Item","sap/ui/core/Icon","sap/ui/core/InvisibleText","sap/ui/core/Renderer","sap/ui/core/IconPool","sap/ui/events/KeyCodes","sap/ui/core/library","sap/ui/util/openWindow","sap/ui/util/defaultLinkTypes","sap/ui/dom/jquery/Aria"],function(jQuery,t,e,i,s,a,n,r,o,p,l,c){"use strict";var d=p.TextAlign;var u=p.TextDirection;var g=i.extend("sap.tnt.NavigationListItem",{metadata:{library:"sap.tnt",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:""},expanded:{type:"boolean",group:"Misc",defaultValue:true},hasExpander:{type:"boolean",group:"Misc",defaultValue:true},visible:{type:"boolean",group:"Appearance",defaultValue:true},selectable:{type:"boolean",group:"Behavior",defaultValue:true},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},target:{type:"string",group:"Behavior",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.tnt.NavigationListItem",multiple:true,singularName:"item"},_expandIconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{select:{parameters:{item:{type:"sap.ui.core.Item"}}}},designtime:"sap/tnt/designtime/NavigationListItem.designtime"}});g.expandIcon="sap-icon://navigation-right-arrow";g.collapseIcon="sap-icon://navigation-down-arrow";g.selectionIndicatorIcon="sap-icon://circle-task-2";g._getInvisibleText=function(){if(!this._invisibleText){this._invisibleText=(new a).toStatic()}return this._invisibleText};g.prototype.init=function(){this._resourceBundle=e.getLibraryResourceBundle("sap.ui.core");this._resourceBundleMLib=e.getLibraryResourceBundle("sap.m");this._resourceBundleTNTLib=e.getLibraryResourceBundle("sap.tnt")};g.prototype._getUniqueKey=function(){var t=this.getKey();if(t){return t}return this.getId()};g.prototype._getExpandIconControl=function(){var t=this.getAggregation("_expandIconControl");if(!t){var e=this.getExpanded();t=new s({src:e?g.collapseIcon:g.expandIcon,visible:this.getItems().length>0&&this.getHasExpander(),useIconTooltip:false,tooltip:this._getExpandIconTooltip(!e)}).addStyleClass("sapTntNavLIExpandIcon");this.setAggregation("_expandIconControl",t,true)}return t};g.prototype._getExpandIconTooltip=function(t){if(!this.getEnabled()){return""}var e=t?"Icon.expand":"Icon.collapse";return this._resourceBundle.getText(e)};g.prototype.getLevel=function(){var t=0;var e=this.getParent();if(e.getMetadata().getName()=="sap.tnt.NavigationListItem"){return e.getLevel()+1}return t};g.prototype.getNavigationList=function(){var t=this.getParent();while(t&&t.getMetadata().getName()!="sap.tnt.NavigationList"){t=t.getParent()}return t};g.prototype.getFocusDomRef=function(){var t=this.getDomRef("focusable");if(t){return t}return this.getDomRef()};g.prototype._isListExpanded=function(){var t=this.getNavigationList();return t.getExpanded()||t.hasStyleClass("sapTntNavLIPopup")};g.prototype.createPopupList=function(){var t=[],e=this.getNavigationList(),i=e.getSelectedItem(),s,a,n,r=this.getItems();for(var o=0;o<r.length;o++){a=r[o];if(a.getVisible()){n=new g({key:a.getId(),text:a.getText(),textDirection:a.getTextDirection(),enabled:a.getEnabled(),selectable:a.getSelectable(),href:a.getHref(),target:a.getTarget(),tooltip:a.getTooltip()});t.push(n);if(i===a){s=n}}}var p=new g({expanded:true,hasExpander:false,selectable:this.getSelectable(),key:this.getId(),text:this.getText(),enabled:this.getEnabled(),textDirection:this.getTextDirection(),href:this.getHref(),target:this.getTarget(),tooltip:this.getTooltip(),items:t});var l=e.getMetadata().getClass().prototype.constructor;var c=new l({itemSelect:this.onPopupItemSelect.bind(this),items:[p]}).addStyleClass("sapTntNavLIPopup");if(i==this){s=p;c.isGroupSelected=true}c.setSelectedItem(s);return c};g.prototype.onPopupItemSelect=function(t){var i=t.getParameter("item");i=e.byId(i.getKey());i._selectItem(t)};g.prototype._selectItem=function(t){var e={item:this},i=this.getNavigationList();this.fireSelect(e);if(this.getSelectable()){i._selectItem(e)}this._openUrl()};g.prototype._openUrl=function(){var t=this.getHref();if(t){l(t,this.getTarget()||"_self")}};g.prototype.onkeydown=function(t){if(t.isMarked("subItem")){return}t.setMarked("subItem");if(this.getLevel()>0){return}var i=e.getConfiguration().getRTL();if(t.shiftKey&&t.which==189||t.which==o.NUMPAD_MINUS||t.which==o.ARROW_RIGHT&&i||t.which==o.ARROW_LEFT&&!i){if(this.collapse()){t.preventDefault();t.stopPropagation()}}else if(t.which==o.NUMPAD_PLUS||t.shiftKey&&t.which==o.PLUS||t.which==o.ARROW_LEFT&&i||t.which==o.ARROW_RIGHT&&!i){if(this.expand()){t.preventDefault();t.stopPropagation()}}};g.prototype.expand=function(t){if(this.getExpanded()||!this.getHasExpander()||this.getItems().length==0||this.getLevel()>0){return}this.setProperty("expanded",true,true);this.$().find(".sapTntNavLIGroup").attr("aria-expanded",true);var e=this._getExpandIconControl();e.setSrc(g.collapseIcon);e.setTooltip(this._getExpandIconTooltip(false));var i=this.$().find(".sapTntNavLIGroupItems");var s=this.getDomRef();i.stop(true,true).slideDown(t||"fast",function(){s.querySelector(".sapTntNavLIGroupItems").classList.toggle("sapTntNavLIHiddenGroupItems")});this.getNavigationList()._updateNavItems();return true};g.prototype.collapse=function(t){if(!this.getExpanded()||!this.getHasExpander()||this.getItems().length==0||this.getLevel()>0){return}this.setProperty("expanded",false,true);this.$().find(".sapTntNavLIGroup").attr("aria-expanded",false);var e=this._getExpandIconControl();e.setSrc(g.expandIcon);e.setTooltip(this._getExpandIconTooltip(true));var i=this.$().find(".sapTntNavLIGroupItems");var s=this.getDomRef();i.stop(true,true).slideUp(t||"fast",function(){s.querySelector(".sapTntNavLIGroupItems").classList.toggle("sapTntNavLIHiddenGroupItems")});this.getNavigationList()._updateNavItems();return true};g.prototype.ontap=function(t){var e=this.getNavigationList(),i=jQuery(t.target).closest(".sapUiIcon"),s=this.getLevel(),a,n;if(t.isMarked("subItem")){return}t.setMarked("subItem");if(!this.getEnabled()){return}if(s===1){a=this.getParent();if(this.getEnabled()&&a.getEnabled()){this._selectItem(t)}return}if(e.getExpanded()||!this.getItems().length){if(!i.length||!i.hasClass("sapTntNavLIExpandIcon")){this._selectItem(t);return}t.preventDefault();if(this.getExpanded()){this.collapse()}else{this.expand()}}else{n=this.createPopupList();e._openPopover(this,n)}};g.prototype.onsapenter=g.prototype.ontap;g.prototype.onsapspace=g.prototype.ontap;g.prototype.render=function(t,e){if(!this.getVisible()){return}if(this.getLevel()===0){this.renderFirstLevelNavItem(t,e)}else{this.renderSecondLevelNavItem(t,e)}};g.prototype.renderGroupItem=function(t,e){var i=this._isListExpanded(),s=this.getExpanded(),a=this._getVisibleItems(this),n=a.length,r=this.getText(),o=this.getHref(),p=this.getTarget(),l=this.getSelectable(),d,u={level:"1",role:"treeitem",roledescription:this._resourceBundleTNTLib.getText("NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_TREE_ITEM")},h=this.getItems().length>0&&this.getHasExpander();if(i){t.openStart("div",this.getId()+"-focusable")}else{t.openStart("div")}t.class("sapTntNavLIItem");t.class("sapTntNavLIGroup");if(l){if(e._selectedItem===this){u.selected=true;t.class("sapTntNavLIItemSelected")}else{u.selected=false}}if(!this.getEnabled()){t.class("sapTntNavLIItemDisabled")}if(!i&&this._hasSelectedChild(e._selectedItem)){t.class("sapTntNavLIItemSelected")}if(h){t.class("sapTntNavLIItemWithExpander")}if(i){d=this.getTooltip_AsString()||r;if(d){t.attr("title",d)}if(this.getEnabled()){t.attr("tabindex","-1")}if(n>0){u.expanded=s}t.accessibilityState(u)}t.openEnd();t.openStart("a",this.getId()+"-a");t.attr("tabindex","-1");t.accessibilityState({role:"link"});if(!i){t.accessibilityState({hidden:true})}if(o){t.attr("href",o)}if(p){t.attr("target",p);t.attr("rel",c("",p))}t.openEnd();this._renderIcon(t);this._renderText(t);if(e.getExpanded()){var I=this._getExpandIconControl();I.setVisible(h);I.setSrc(this.getExpanded()?g.collapseIcon:g.expandIcon);I.setTooltip(this._getExpandIconTooltip(!this.getExpanded()));t.icon(g.selectionIndicatorIcon,["sapTntNavLISelectionIndicator"]);t.renderControl(I)}t.close("a");t.close("div")};g.prototype.renderFirstLevelNavItem=function(t,e){var i,s=this._getVisibleItems(this),a=s.length,n=this.getExpanded(),r=this._isListExpanded(),o,p=this.getSelectable(),l={role:p?"menuitemradio":"menuitem",roledescription:this._resourceBundleTNTLib.getText("NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_MENUITEM")};t.openStart("li",this);if(!r){if(this.getEnabled()){t.attr("tabindex","-1")}o=this.getTooltip_AsString()||this.getText();if(o){t.attr("title",o)}if(a>0){if(this.getEnabled()){t.class("sapTnTNavLINotExpandedTriangle")}l.haspopup="tree"}if(this._isOverflow){t.class("sapTnTNavLIOverflow");t.class("sapTnTNavLIHiddenItem");t.attr("tabindex","-1");l.haspopup="menu"}if(p){l.checked=e._selectedItem===this}t.accessibilityState(l)}else{t.attr("aria-hidden","true")}t.openEnd();this.renderGroupItem(t,e);if(r){t.openStart("ul");t.attr("aria-hidden","true");t.attr("role","group");t.class("sapTntNavLIGroupItems");if(!n){t.class("sapTntNavLIHiddenGroupItems")}t.openEnd();for(var c=0;c<a;c++){i=s[c];i.render(t,e,c,a)}t.close("ul")}t.close("li")};g.prototype.renderSecondLevelNavItem=function(t,e){var i=this.getParent(),s=this.getHref(),a=this.getTarget(),n=this.getSelectable(),r={role:"treeitem",level:"2",roledescription:this._resourceBundleTNTLib.getText("NAVIGATION_LIST_ITEM_ROLE_DESCRIPTION_TREE_ITEM")};t.openStart("li",this);t.class("sapTntNavLIItem");t.class("sapTntNavLIGroupItem");if(n){if(e._selectedItem===this){r.selected=true;t.class("sapTntNavLIItemSelected")}else{r.selected=false}}if(!this.getEnabled()||!i.getEnabled()){t.class("sapTntNavLIItemDisabled")}else{t.attr("tabindex","-1")}var o=this.getText();var p=this.getTooltip_AsString()||o;if(p){t.attr("title",p)}t.accessibilityState(r);t.openEnd();t.openStart("a",this.getId()+"-a");t.attr("tabindex","-1");t.accessibilityState({role:"link"});if(s){t.attr("href",s)}if(a){t.attr("target",a);t.attr("rel",c("",a))}t.openEnd();this._renderText(t);t.icon("sap-icon://circle-task-2",["sapTntNavLISelectionIndicator"]);t.close("a");t.close("li")};g.prototype._renderIcon=function(t){var e=this.getIcon(),i=r.getIconInfo(e);if(e){t.openStart("span");t.class("sapUiIcon");t.class("sapTntNavLIGroupIcon");t.attr("aria-hidden",true);if(i&&!i.suppressMirroring){t.class("sapUiIconMirrorInRTL")}if(i){t.attr("data-sap-ui-icon-content",i.content);t.style("font-family","'"+i.fontFamily+"'")}t.openEnd();t.close("span")}else{t.openStart("span");t.class("sapUiIcon");t.class("sapTntNavLIGroupIcon");t.attr("aria-hidden",true);t.openEnd();t.close("span")}};g.prototype._renderText=function(t){t.openStart("span");t.class("sapMText");t.class("sapTntNavLIText");t.class("sapMTextNoWrap");var e=this.getTextDirection();if(e!==u.Inherit){t.attr("dir",e.toLowerCase())}var i=n.getTextAlign(d.Begin,e);if(i){t.style("text-align",i)}t.openEnd();t.text(this.getText());t.close("span")};g.prototype._unselect=function(){var t=this.$(),e=this.getNavigationList();if(!e){return}if(this._isListExpanded()){if(this.getLevel()===0){t=t.find(".sapTntNavLIGroup")}t.attr("aria-selected",false)}else{t.attr("aria-checked",false);t=t.find(".sapTntNavLIGroup");if(this.getParent().isA("sap.tnt.NavigationListItem")){this.getParent().$().find(".sapTntNavLIGroup").removeClass("sapTntNavLIItemSelected")}}t.removeClass("sapTntNavLIItemSelected")};g.prototype._select=function(){var t=this.$(),e=this.getNavigationList();if(!e){return}if(this._isListExpanded()){if(this.getLevel()===0){t=t.find(".sapTntNavLIGroup")}t.attr("aria-selected",true)}else{t.attr("aria-checked",true);t=t.find(".sapTntNavLIGroup");if(this.getParent().isA("sap.tnt.NavigationListItem")){this.getParent().$().find(".sapTntNavLIGroup").addClass("sapTntNavLIItemSelected sapTntNavLIItemNoHoverEffect")}e._closePopover()}t.addClass("sapTntNavLIItemSelected")};g.prototype._getDomRefs=function(){var t=[];if(!this.getEnabled()){return t}var e=this.$();t.push(e.find(".sapTntNavLIGroup")[0]);if(this.getExpanded()){var i=e.find(".sapTntNavLIGroupItem");for(var s=0;s<i.length;s++){t.push(i[s])}}return t};g.prototype._getVisibleItems=function(t){var e=[];var i=t.getItems();var s;for(var a=0;a<i.length;a++){s=i[a];if(s.getVisible()){e.push(s)}}return e};g.prototype.onclick=function(t){if(this.getHref()){t.preventDefault()}};g.prototype.onfocusout=function(){var t=this.getDomRef()&&this.getDomRef().querySelector(".sapTntNavLIGroup");if(t){t.classList.remove("sapTntNavLIItemNoHoverEffect")}};g.prototype.onmouseover=g.prototype.onfocusout;g.prototype.onmousedown=function(t){if(this.getHref()){t.preventDefault()}};g.prototype.onfocusin=function(t){if(t.srcControl!==this){return}this._updateAccessibilityText()};g.prototype._updateAccessibilityText=function(){var t=this.getNavigationList(),e=g._getInvisibleText();if(!t.getExpanded()){e.setText("");return}var i=this._resourceBundleMLib,s=this._getAccessibilityItem(),a=t._selectedItem===this?i.getText("LIST_ITEM_SELECTED"):"",n=i.getText("ACC_CTR_TYPE_TREEITEM"),r=this._getAccessibilityPosition(),o=i.getText("LIST_ITEM_POSITION",[r.index,r.size]),p=this.getText(),l=n+" "+a+" "+p+" "+o;e.setText(l);s.addAriaLabelledBy(e.getId())};g.prototype._getAccessibilityPosition=function(){var t=this.getParent(),e=this._getVisibleItems(t),i=e.length,s=e.indexOf(this)+1;return{index:s,size:i}};g.prototype._getAccessibilityItem=function(){var t=this.$(),e=this.getNavigationList(),i=e.getExpanded();if(i&&this.getLevel()===0){t=t.find(".sapTntNavLIGroup")}return t};g.prototype._hasSelectedChild=function(t){var e=this.getItems(),i;for(i=0;i<e.length;i++){if(e[i]===t){return true}}return false};return g});
//# sourceMappingURL=NavigationListItem.js.map