/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/m/library","sap/ui/base/ManagedObjectObserver","sap/ui/core/Control","sap/ui/Device","sap/ui/core/ResizeHandler","./ToolPageRenderer"],function(e,t,i,n,r,s,o){"use strict";var a=t.PageBackgroundDesign;var d=n.extend("sap.tnt.ToolPage",{metadata:{library:"sap.tnt",properties:{sideExpanded:{type:"boolean",group:"Misc",defaultValue:true},contentBackgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:a.Standard}},aggregations:{header:{type:"sap.tnt.IToolHeader",multiple:false},subHeader:{type:"sap.tnt.IToolHeader",multiple:false},sideContent:{type:"sap.tnt.SideNavigation",multiple:false},mainContents:{type:"sap.ui.core.Control",multiple:true,singularName:"mainContent"}},events:{}},renderer:o});d.prototype.init=function(){this._oContentObserver=new i(this._onContentChange.bind(this));this._oContentObserver.observe(this,{aggregations:["subHeader","sideContent"]});this._oContentVisibilityObserver=new i(this._onContentVisibilityChange.bind(this));this._deregisterControl()};d.prototype.exit=function(){this._deregisterControl();if(this._oContentObserver){this._oContentObserver.disconnect();this._oContentObserver=null}if(this._oContentVisibilityObserver){this._oContentVisibilityObserver.disconnect();this._oContentVisibilityObserver=null}};d.prototype.onBeforeRendering=function(){this._deregisterControl()};d.prototype.onAfterRendering=function(){this._ResizeHandler=s.register(this.getDomRef(),this._mediaQueryHandler.bind(this));this._updateLastMediaQuery()};d.prototype.toggleSideContentMode=function(){return this.setSideExpanded(!this.getSideExpanded())};d.prototype.setSideExpanded=function(e){this.setProperty("sideExpanded",e,true);var t=this.getSideContent();if(t){var i=r.system.phone?true:e;t.setExpanded(i)}else{return this}var n=this.getDomRef();if(!n){return this}if(e){n.querySelector(".sapTntToolPageContentWrapper").classList.remove("sapTntToolPageAsideCollapsed")}else{n.querySelector(".sapTntToolPageContentWrapper").classList.add("sapTntToolPageAsideCollapsed")}return this};d.prototype._deregisterControl=function(){if(this._ResizeHandler){s.deregister(this._ResizeHandler);this._ResizeHandler=null}};d.prototype._mediaQueryHandler=function(){var e=this.getSideContent();if(e===null){return}this._currentMediaQuery=this._getDeviceAsString();if(this._getLastMediaQuery()===this._currentMediaQuery){return}switch(this._currentMediaQuery){case"Combi":this.setSideExpanded(true);break;case"Tablet":this.setSideExpanded(false);break;case"Phone":this.setSideExpanded(false);e.setExpanded(true);break;default:this.setSideExpanded(true)}this._updateLastMediaQuery()};d.prototype._getLastMediaQuery=function(){return this._lastMediaQuery};d.prototype._updateLastMediaQuery=function(){this._lastMediaQuery=this._getDeviceAsString();return this};d.prototype._getDeviceAsString=function(){if(r.system.combi){return"Combi"}if(r.system.phone){return"Phone"}if(r.system.tablet){return"Tablet"}return"Desktop"};d.prototype._onContentChange=function(e){switch(e.mutation){case"insert":this._oContentVisibilityObserver.observe(e.child,{properties:["visible"]});break;case"remove":this._oContentVisibilityObserver.unobserve(e.child,{properties:["visible"]});break}};d.prototype._onContentVisibilityChange=function(e){this.invalidate()};return d});
//# sourceMappingURL=ToolPage.js.map