/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/ui/core/CustomStyleClassSupport","sap/ui/core/Element","./Tree","sap/ui/core/Configuration"],function(jQuery,e,t,s,i,o){"use strict";var r=e.TreeSelectionMode;var a=s.extend("sap.ui.commons.TreeNode",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{text:{type:"string",group:"Misc",defaultValue:null},expanded:{type:"boolean",group:"Misc",defaultValue:true},hasExpander:{type:"boolean",group:"Misc",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},isSelected:{type:"boolean",group:"Misc",defaultValue:false},selectable:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"nodes",aggregations:{nodes:{type:"sap.ui.commons.TreeNode",multiple:true,singularName:"node"}},associations:{selectedForNodes:{type:"sap.ui.commons.TreeNode",multiple:true,singularName:"selectedForNode",visibility:"hidden"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{toggleOpenState:{parameters:{opened:{type:"boolean"}}},selected:{}}}});a.prototype.getSelectedForNodes=function(){return this.getAssociation("selectedForNodes",[])};a.ANIMATION_DURATION=600;t.apply(a.prototype);a.prototype.expand=function(e,t){this.setProperty("expanded",true,true);var s=null;if(!t){s=l.bind(this)}var i=this.$();if(i.hasClass("sapUiTreeNodeCollapsed")){i.toggleClass("sapUiTreeNodeCollapsed");i.toggleClass("sapUiTreeNodeExpanded");i.attr("aria-expanded","true");var o=this.$("children");if(o){if(e){o.show()}else{o.stop(true,true);o.show(a.ANIMATION_DURATION,s)}o.css({display:"block"})}this.fireToggleOpenState({opened:true})}if(e){var r=this._getNodes();for(var n=0;n<r.length;n++){r[n].expand(e,true)}s&&s()}};a.prototype.collapse=function(e,t){this.setProperty("expanded",false,true);var s=null;if(!t){s=n.bind(this)}var i=this.$();if(i.hasClass("sapUiTreeNodeExpanded")){i.toggleClass("sapUiTreeNodeCollapsed");i.toggleClass("sapUiTreeNodeExpanded");i.attr("aria-expanded","false");var o=this.$("children");if(o){if(e){o.hide()}else{o.stop(true,true);o.hide(a.ANIMATION_DURATION,s)}}this.fireToggleOpenState({opened:false})}if(e){var r=this._getNodes();for(var l=0;l<r.length;l++){r[l].collapse(e,true)}s&&s()}};a.prototype.select=function(e){var t=this.getTree();if(t){t.setSelection(this,e)}else{this._select()}};function l(){var e=this.getTree();if(e){e._adjustSelectionOnExpanding(this)}}function n(){var e=this.getTree();if(e){e._adjustSelectionOnCollapsing(this);e._adjustFocus()}}a.prototype._select=function(e){this.setProperty("isSelected",true,true);if(!e){this.fireSelected()}if(this.getDomRef()){this.$().closest(".sapUiTreeNode").addClass("sapUiTreeNodeSelected").attr("aria-selected","true");this.scrollIntoView()}};a.prototype._deselect=function(e){this.setProperty("isSelected",false,true);if(this.getDomRef()){this.$().removeClass("sapUiTreeNodeSelected").removeAttr("aria-selected")}};a.prototype._getNodes=function(){return this.mAggregations.nodes||[]};a.prototype.hasSelectedHiddenChild=function(){var e=this._getNodes();for(var t=0;t<e.length;t++){if(!e[t].isVisible()&&e[t].getIsSelected()||e[t].hasSelectedHiddenChild()){return true}}return false};a.prototype.setIsSelected=function(e){var t=this.getTree();if(!this.getSelectable()){return this}if(e==this.getProperty("isSelected")){return this}if(t){t._setNodeSelection(this,e,true)}else{this.setProperty("isSelected",e,true)}return this};a.prototype.setSelectable=function(e){if(!e&&this.getIsSelected()){this.setIsSelected(false)}this.setProperty("selectable",e);return this};a.prototype.onclick=function(e){var t=e.target,s=this.getTree();if(jQuery(t).is(".sapUiTreeNode")||jQuery(t).is(".sapUiTreeNodeNotSelectable")){if(jQuery(t).is(".sapUiTreeNodeNotSelectable")){t=jQuery(t).closest(".sapUiTreeNode")[0]}if(jQuery(t).hasClass("sapUiTreeNodeExpanded")){this.collapse()}else{this.expand()}s.placeFocus(t);t.focus()}else if(jQuery(t).is(".sapUiTreeNodeContent")||jQuery(t).is(".sapUiTreeIcon")){var o=i.SelectionType.Select;if(s.getSelectionMode()==r.Multi){if(e.shiftKey){o=i.SelectionType.Range}if(e.metaKey||e.ctrlKey){o=i.SelectionType.Toggle}}s.setSelection(this,false,o);t=jQuery(t).closest(".sapUiTreeNode")[0];s.placeFocus(t);t.focus()}};a.prototype.onsapselect=function(e){if(this.getSelectable()){this.getTree().setSelection(this)}else if(this.getExpanded()){this.collapse()}else{this.expand()}};a.prototype.onsapexpand=function(e){this.expand()};a.prototype.onsapcollapse=function(e){this.collapse()};a.prototype.onsapleft=function(e){if(o.getRTL()){this.expand()}else{this.collapse()}e.preventDefault()};a.prototype.onsapright=function(e){if(o.getRTL()){this.collapse()}else{this.expand()}e.preventDefault()};a.prototype.focus=function(){var e=this.getFocusDomRef();if(e){e.setAttribute("tabindex","0");e.focus()}};a.prototype.blur=function(){var e=this.getFocusDomRef();if(e){e.setAttribute("tabindex","-1")}};a.prototype.getTree=function(){var e=this.getParent();while(e instanceof a){e=e.getParent()}return e};a.prototype.hasChildren=function(){var e=this._getNodes();if(e.length){return true}return false};a.prototype.isVisible=function(){var e=this.getParent();while(e instanceof a){if(!e.getExpanded()){return false}e=e.getParent()}return true};a.prototype.scrollIntoView=function(){var e=this.$(),t=this.getTree().$(),s=t.find(".sapUiTreeCont"),i=e[0].offsetTop,o=s.scrollTop(),r=s.height(),a,l=e[0].offsetLeft,n=s.scrollLeft(),p=s.width(),d;if(i>o+r||i<o){a=i-Math.floor(r*.5);a=Math.max(a,0)}if(l>n+p||l<n){d=l-Math.floor(p*.5);d=Math.max(d,0)}if(a!==undefined||d!==undefined){var u={};if(a!==undefined){u.scrollTop=a}if(d!==undefined){u.scrollLeft=d}s.stop(true,true).animate(u)}};a.prototype.getTooltip_AsString=function(){var e;var t=this.getTooltip();if(typeof t==="string"||t instanceof String){e=t}if(!e){e=this.getText()}return e};return a});
//# sourceMappingURL=TreeNode.js.map