/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/ui/Device","sap/ui/base/Object","sap/ui/core/IntervalTrigger","sap/ui/core/ResizeHandler","sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes"],function(t,i,o,e,s,jQuery,l){"use strict";var r=o.extend("sap.ui.core.delegate.ScrollEnablement",{constructor:function(t,i,e){o.apply(this);this._oControl=t;this._oControl.addDelegate(this,e.callBefore);this._sContentId=i;this._sContainerId=e.scrollContainerId;this._bHorizontal=!!e.horizontal;this._bVertical=!!e.vertical;this._scrollX=0;this._scrollY=0;this._scrollCoef=.9;this._iLastMaxScrollTop=0;this._iScrollPaddingTop=0;h(this);if(this._init){this._init.apply(this,arguments)}},setHorizontal:function(t){this._bHorizontal=!!t;this._setOverflow&&this._setOverflow()},setVertical:function(t){this._bVertical=!!t;this._setOverflow&&this._setOverflow()},getHorizontal:function(){return this._bHorizontal},getVertical:function(){return this._bVertical},setBounce:function(t){},setPullDown:function(t){this._oPullDown=t;return this},setGrowingList:function(t,i,o){this._fnScrollLoadCallback=t;this._sScrollLoadDirection=i;this.onOverflowChange(o);return this},onOverflowChange:function(t){this._fnOverflowChangeCallback=t;if(!this._fnOverflowChangeCallback){this._deregisterOverflowMonitor()}},setOnAfterScrollToElement:function(t){this._fnAfterScrollToElement=t},setIconTabBar:function(t,i,o){this._oIconTabBar=t;if(i){this._fnScrollEndCallback=i.bind(t)}if(o){this._fnScrollStartCallback=o.bind(t)}return this},setScrollPaddingTop:function(t){if(typeof t==="number"){this._iScrollPaddingTop=t}},scrollTo:function(t,i,o,e){this._scrollX=t;this._scrollY=i;this._scrollTo(t,i,o,e);return this},getChildPosition:function(t){var i=t instanceof jQuery?t:jQuery(t),o=i.position(),e=i.offsetParent(),s;while(!e.is(this._$Container)&&!e.is("html")&&e.length){s=e.position();o.top+=s.top;o.left+=s.left;e=e.offsetParent()}return o},scrollToElement:function(t,i,o,e){o=o||[0,0];if(!this._$Container[0].contains(t)||t.style.display==="none"||t.offsetParent.nodeName.toUpperCase()==="HTML"){return this}o[1]-=this._iScrollPaddingTop;if(e&&this._isInScrollport(t,o)){return this}var s=jQuery(t),l=this.getChildPosition(s),r=this.getScrollLeft()+l.left+o[0],n=this.getScrollTop()+l.top+o[1];if(this._bFlipX){r=this.getScrollLeft()-(l.left-this._$Container.width())-s.width()}this._scrollTo(r,n,i,this._fnAfterScrollToElement);return this},destroy:function(){if(this._exit){this._exit()}if(this._oControl){this._oControl.removeDelegate(this);this._oControl=undefined}},refresh:function(){if(this._refresh){this._refresh()}},_useDefaultScroll:function(t){return t.isContentEditable},onkeydown:function(i){if(this._useDefaultScroll(i.target)){return}var o=this._$Container[0];if(i.altKey&&this.getHorizontal()){switch(i.keyCode){case l.PAGE_UP:this._customScrollTo(this._scrollX-o.clientWidth,this._scrollY,i);break;case l.PAGE_DOWN:this._customScrollTo(this._scrollX+o.clientWidth,this._scrollY,i);break}}if(i.ctrlKey&&!i.altKey){switch(i.keyCode){case l.ARROW_UP:if(this.getVertical()){this._customScrollTo(this._scrollX,this._scrollY-o.clientHeight*this._scrollCoef,i)}break;case l.ARROW_DOWN:if(this.getVertical()){this._customScrollTo(this._scrollX,this._scrollY+o.clientHeight*this._scrollCoef,i)}break;case l.ARROW_LEFT:if(this.getHorizontal()){this._customScrollTo(this._scrollX-o.clientWidth,this._scrollY,i)}break;case l.ARROW_RIGHT:if(this.getHorizontal()){this._customScrollTo(this._scrollX+o.clientWidth,this._scrollY,i)}break;case l.HOME:if(this.getHorizontal()){this._customScrollTo(0,this._scrollY,i)}if(this.getVertical()){this._customScrollTo(this._scrollX,0,i)}break;case l.END:var e=o.scrollWidth-o.clientWidth;var s=o.scrollHeight-o.clientHeight;if(!this.getHorizontal()){s=this._scrollY}if(!this.getVertical()){e=t.getRTL()?o.clientWidth-o.scrollWidth:this._scrollX}this._customScrollTo(e,s,i);break}}},_customScrollTo:function(t,i,o){var e=o.target.nodeName;if(e!="INPUT"&&e!="TEXTAREA"){o.preventDefault();o.setMarked();this._scrollTo(t,i)}}});var n={getScrollTop:function(){return this._scrollY||0},getScrollLeft:function(){return this._scrollX||0},getScrollHeight:function(){var t=this._$Container;return t&&t[0]?t[0].scrollHeight:0},getMaxScrollTop:function(){var t=this._$Container;return t&&t[0]?t[0].scrollHeight-t[0].clientHeight:-1},getContainerDomRef:function(){return this._$Container&&this._$Container[0]},_cleanup:function(){if(this._sResizeListenerId){s.deregister(this._sResizeListenerId);this._sResizeListenerId=null}this._deregisterOverflowMonitor()},_setOverflow:function(){var t=this._$Container;if(!t||!t[0]){return}if(i.os.ios){t.css("overflow-x",this._bHorizontal&&!this._bDragScroll?"scroll":"hidden").css("overflow-y",this._bVertical&&!this._bDragScroll?"scroll":"hidden").css("-webkit-overflow-scrolling","touch")}else{t.css("overflow-x",this._bHorizontal&&!this._bDragScroll?"auto":"hidden").css("overflow-y",this._bVertical&&!this._bDragScroll?"auto":"hidden")}},_refresh:function(){var t=this._$Container;if(!(t&&t.length)){return}if(this._oPullDown&&this._oPullDown._bTouchMode){var i=this._oPullDown.getDomRef();if(i){i.style.marginTop=this._oPullDown._iState==2?"":"-"+i.offsetHeight+"px"}}if(t.scrollTop()!=this._scrollY){t.scrollTop(this._scrollY)}if(!(this._oPullDown&&this._oPullDown._bTouchMode)&&!this._fnScrollLoadCallback){s.deregister(this._sResizeListenerId);this._sResizeListenerId=null}},_onScroll:function(){var t=this._$Container,i=t.scrollTop(),o=i-this._scrollY;this._scrollX=t.scrollLeft();this._scrollY=i;if(this._fnScrollLoadCallback){if(this._sScrollLoadDirection=="Upwards"){if(o<0&&i<10){this._fnScrollLoadCallback()}}else if(o>=0&&t[0].scrollHeight-i-t[0].clientHeight<100){this._fnScrollLoadCallback()}}if(this._oIconTabBar&&this._fnScrollEndCallback){this._fnScrollEndCallback()}},_onStart:function(t){var i=this._$Container[0];if(!i){return}this._bDoDrag=this._bDragScroll;var o=t.touches?t.touches[0]:t;this._iX=o.pageX;this._iY=o.pageY;this._bPullDown=false;this._iDirection=""},_onTouchMove:function(t){var i=this._$Container[0];var o=t.touches?t.touches[0]:t;var e=o.pageX-this._iX;var s=o.pageY-this._iY;if(this._iDirection==""){if(e!=0||s!=0){this._iDirection=Math.abs(s)>Math.abs(e)?"v":"h"}if(this._oPullDown&&this._oPullDown._bTouchMode&&this._iDirection=="v"&&i.scrollTop<=1){if(s>Math.abs(e)){this._bPullDown=true}}}if(this._bPullDown===true){var l=this._oPullDown.getDomRef();var r=t.touches[0].pageY-this._iY-l.offsetHeight;if(r>20){r=20}l.style.marginTop=r+"px";this._oPullDown.doPull(r);t.preventDefault();this._bDoDrag=false}if(this._bDoDrag){var n=i.scrollLeft,h=i.scrollTop;if(this._bHorizontal){if(this._bFlipX){i.scrollLeft=n-this._iX+o.pageX}else{i.scrollLeft=n+this._iX-o.pageX}}if(this._bVertical){i.scrollTop=h+this._iY-o.pageY}if(i.scrollLeft!=n||i.scrollTop!=h){t.setMarked&&t.setMarked();t.preventDefault()}this._iX=o.pageX;this._iY=o.pageY;return}},_onEnd:function(t){if(this._oPullDown&&this._oPullDown._bTouchMode){this._oPullDown.doScrollEnd();this._refresh()}if(this._bDragScroll&&this._iDirection){t.setMarked&&t.setMarked()}},_onMouseDown:function(t){if(this._bDragScroll&&t.button==0){this._bScrolling=true;this._onStart(t)}},_onMouseMove:function(t){if(this._bScrolling){var i=t.originalEvent||t;var o=i.buttons||i.which;if(o==1||t.pressure){var e=this._$Container[0];if(this._bHorizontal){if(this._bFlipX){e.scrollLeft=e.scrollLeft-this._iX+t.pageX}else{e.scrollLeft=e.scrollLeft+this._iX-t.pageX}}if(this._bVertical){e.scrollTop=e.scrollTop+this._iY-t.pageY}this._iX=t.pageX;this._iY=t.pageY}}},_onMouseUp:function(){if(this._bScrolling){this._bScrolling=false;this._onEnd()}},onBeforeRendering:function(){if(this._sResizeListenerId){s.deregister(this._sResizeListenerId);this._sResizeListenerId=null}this._deregisterOverflowMonitor();var t=this._$Container;if(t){if(t.height()>0){this._scrollX=t.scrollLeft();this._scrollY=t.scrollTop()}t.off()}},_checkOverflowChange:function(t){var i=this.getMaxScrollTop(),o=i>0&&this._iLastMaxScrollTop===0,e=i===0&&this._iLastMaxScrollTop>0,s=o||e;if(s){this._fnOverflowChangeCallback(o,i)}this._iLastMaxScrollTop=i},_registerOverflowMonitor:function(){this._fnOverflowChangeCallback&&e.addListener(this._checkOverflowChange,this)},_deregisterOverflowMonitor:function(){e.removeListener(this._checkOverflowChange,this)},onAfterRendering:function(){var t=this._$Container=this._sContainerId?jQuery(document.getElementById(this._sContainerId)):jQuery(document.getElementById(this._sContentId)).parent();var o=this._refresh;var e=t.is(":visible");t.addClass("sapUiScrollDelegate");this._setOverflow();if(this._scrollX!==0||this._scrollY!==0){this._scrollTo(this._scrollX,this._scrollY)}this._refresh();if(!e||this._oPullDown||this._fnScrollLoadCallback){this._sResizeListenerId=s.register(t[0],o.bind(this))}if(this._fnOverflowChangeCallback){this._iOverflowTimer&&window.cancelAnimationFrame(this._iOverflowTimer);this._iOverflowTimer=window.requestAnimationFrame(this._registerOverflowMonitor.bind(this))}t.on("scroll",this._onScroll.bind(this));var l=t[0];function r(t,i){t.split(" ").forEach(function(t){l&&l.addEventListener(t,i)})}function n(t){return t.pointerType=="touch"?this._onStart(t):this._onMouseDown(t)}function h(t){return t.pointerType=="touch"?this._onTouchMove(t):this._onMouseMove(t)}function c(t){return t.pointerType=="touch"?this._onEnd(t):this._onMouseUp(t)}if(i.support.pointer&&i.system.desktop){if(this._bDragScroll){r("pointerdown",n.bind(this));r("pointermove",h.bind(this));r("pointerup pointercancel pointerleave",c.bind(this))}}else if(i.support.touch){if(this._bDragScroll||this._oPullDown&&this._oPullDown._bTouchMode){t.on("touchcancel touchend",this._onEnd.bind(this)).on("touchstart",this._onStart.bind(this)).on("touchmove",this._onTouchMove.bind(this))}}else if(this._bDragScroll){t.on("mouseup mouseleave",this._onMouseUp.bind(this)).on("mousedown",this._onMouseDown.bind(this)).on("mousemove",this._onMouseMove.bind(this))}},_readActualScrollPosition:function(){if(this._$Container.width()>0){this._scrollX=this._$Container.scrollLeft()}if(this._$Container.height()>0){this._scrollY=this._$Container.scrollTop()}},_scrollTo:function(t,i,o,e){if(this._$Container.length>0){if(o>0){this._$Container.finish().animate({scrollTop:i,scrollLeft:t},{duration:o,complete:this._readActualScrollPosition.bind(this),always:e})}else{this._$Container.scrollTop(i);this._$Container.scrollLeft(t);this._readActualScrollPosition();e&&e()}}},_isInScrollport:function(t,i){var o=t.getBoundingClientRect(),e=this._$Container[0].getBoundingClientRect(),s=e.top-i[1];return Math.ceil(o.top)>=Math.floor(s)&&Math.floor(o.bottom)<=Math.ceil(e.bottom)}};function h(i){var o={_init:function(i,o,e){if(jQuery.event&&jQuery.event.special&&jQuery.event.special.swipe&&jQuery.event.special.swipe.scrollSupressionThreshold<120){jQuery.event.special.swipe.scrollSupressionThreshold=120}Object.assign(this,n);if(e.nonTouchScrolling===true){this._bDragScroll=true}if(t.getRTL()){this._scrollX=9999}},_exit:function(){if(this._cleanup){this._cleanup()}}};Object.assign(i,o)}return r});
//# sourceMappingURL=ScrollEnablement.js.map