/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/strings/formatMessage","sap/base/util/deepEqual","sap/base/util/extend","sap/ui/core/CalendarType","sap/ui/core/Configuration","sap/ui/core/Core","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/ui/core/Supportability","sap/ui/core/date/CalendarUtils","sap/ui/core/date/CalendarWeekNumbering","sap/ui/core/date/UI5Date","sap/ui/core/date/UniversalDate","sap/ui/core/format/TimezoneUtil"],function(e,t,a,r,n,i,o,s,l,u,f,c,d,h,m){"use strict";var g=function(){throw new Error};var p={DATE:"date",TIME:"time",DATETIME:"datetime",DATETIME_WITH_TIMEZONE:"datetimeWithTimezone"};var y={};var v=function(e){if(typeof e!=="string"&&!(e instanceof String)&&e!=null){throw new TypeError("The given timezone must be a string.")}};g.oDateInfo={type:p.DATE,oDefaultFormatOptions:{style:"medium",relativeScale:"day",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd"},{pattern:"yyyyMMdd",strictParsing:true}],bShortFallbackFormatOptions:true,bPatternFallbackWithoutDelimiter:true,getPattern:function(e,t,a){return e.getDatePattern(t,a)},oRequiredParts:{text:true,year:true,weekYear:true,month:true,day:true},aRelativeScales:["year","month","week","day"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["Era","FullYear","Quarter","Month","Week","Date"]};g.oDateTimeInfo={type:p.DATETIME,oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"yyyy-MM-dd'T'HH:mm:ss"},{pattern:"yyyyMMdd HHmmss"}],getPattern:function(e,t,a){var r=t.indexOf("/");if(r>0){return e.getCombinedDateTimePattern(t.substr(0,r),t.substr(r+1),a)}else{return e.getCombinedDateTimePattern(t,t,a)}},oRequiredParts:{text:true,year:true,weekYear:true,month:true,day:true,hour0_23:true,hour1_24:true,hour0_11:true,hour1_12:true},aRelativeScales:["year","month","week","day","hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["Era","FullYear","Quarter","Month","Week","Date","DayPeriod","Hours","Minutes","Seconds"]};g._getDateTimeWithTimezoneInfo=function(e){var t=e.showDate===undefined||e.showDate;var a=e.showTime===undefined||e.showTime;var r=e.showTimezone===undefined||e.showTimezone;var n=g.oDateTimeInfo;if(t&&!a){n=g.oDateInfo}else if(!t&&a){n=g.oTimeInfo}return Object.assign({},n,{type:p.DATETIME_WITH_TIMEZONE,getTimezonePattern:function(e){if(!t&&!a&&r){return"VV"}else if(!r){return e}else{return e+" VV"}},getPattern:function(e,i,o){if(!t&&!a&&r){return"VV"}if(!r){return n.getPattern(e,i,o)}var s=n.getPattern(e,i,o);return e.applyTimezonePattern(s)}})};g.oTimeInfo={type:p.TIME,oDefaultFormatOptions:{style:"medium",relativeScale:"auto",relativeStyle:"wide"},aFallbackFormatOptions:[{style:"short"},{style:"medium"},{pattern:"HH:mm:ss"},{pattern:"HHmmss"}],getPattern:function(e,t,a){return e.getTimePattern(t,a)},oRequiredParts:{text:true,hour0_23:true,hour1_24:true,hour0_11:true,hour1_12:true},aRelativeScales:["hour","minute","second"],aRelativeParseScales:["year","quarter","month","week","day","hour","minute","second"],aIntervalCompareFields:["DayPeriod","Hours","Minutes","Seconds"]};g.getInstance=function(e,t){return this.getDateInstance(e,t)};g.getDateInstance=function(e,t){return this.createInstance(e,t,this.oDateInfo)};g.getDateTimeInstance=function(e,t){return this.createInstance(e,t,this.oDateTimeInfo)};g.getDateTimeWithTimezoneInstance=function(e,t){if(e&&!(e instanceof s)){(function(){e=Object.assign({},e);if(typeof e.showTimezone==="string"){var t=e.showTimezone;if(e.showDate===undefined&&e.showTime===undefined){if(t==="Hide"){e.showTimezone=false}else if(t==="Only"){e.showDate=false;e.showTime=false}}e.showTimezone=t!=="Hide"}})();if(e.showDate===false&&e.showTime===false&&e.showTimezone===false){throw new TypeError("Invalid Configuration. One of the following format options must be true: "+"showDate, showTime or showTimezone.")}}return this.createInstance(e,t,g._getDateTimeWithTimezoneInfo(e||{}))};g.getTimeInstance=function(e,t){return this.createInstance(e,t,this.oTimeInfo)};g.createInstance=function(e,t,a,n){var o,u,f;u=Object.create(this.prototype);if(e instanceof s){t=e;e=undefined}if(!t){t=i.getFormatSettings().getFormatLocale()}u.oLocale=t;u.oLocaleData=l.getInstance(t);u.oFormatOptions=r({},a.oDefaultFormatOptions,e);if(a.type===p.DATETIME_WITH_TIMEZONE){u.oFormatOptions.interval=false;u.oFormatOptions.singleIntervalValue=false;u.oFormatOptions.UTC=false}else{u.oFormatOptions.showTimezone=undefined;u.oFormatOptions.showDate=undefined;u.oFormatOptions.showTime=undefined}u.type=a.type;if(!u.oFormatOptions.calendarType){u.oFormatOptions.calendarType=i.getCalendarType()}if(u.oFormatOptions.firstDayOfWeek===undefined&&u.oFormatOptions.minimalDaysInFirstWeek!==undefined||u.oFormatOptions.firstDayOfWeek!==undefined&&u.oFormatOptions.minimalDaysInFirstWeek===undefined){throw new TypeError("Format options firstDayOfWeek and minimalDaysInFirstWeek need both to be set, but only one was provided.")}if(u.oFormatOptions.calendarWeekNumbering&&!Object.values(c).includes(u.oFormatOptions.calendarWeekNumbering)){throw new TypeError("Illegal format option calendarWeekNumbering: '"+u.oFormatOptions.calendarWeekNumbering+"'")}if(!u.oFormatOptions.pattern){if(u.oFormatOptions.format){u.oFormatOptions.pattern=u.oLocaleData.getCustomDateTimePattern(u.oFormatOptions.format,u.oFormatOptions.calendarType)}else{u.oFormatOptions.pattern=a.getPattern(u.oLocaleData,u.oFormatOptions.style,u.oFormatOptions.calendarType)}}if(u.oFormatOptions.interval){var d,h=u.oFormatOptions.intervalDelimiter;if(u.oFormatOptions.format){u.intervalPatterns=u.oLocaleData.getCustomIntervalPattern(u.oFormatOptions.format,null,u.oFormatOptions.calendarType);if(typeof u.intervalPatterns==="string"){u.intervalPatterns=[u.intervalPatterns]}d=u.oLocaleData.getCustomDateTimePattern(u.oFormatOptions.format,u.oFormatOptions.calendarType);u.intervalPatterns.push(d)}else{d=u.oFormatOptions.pattern;u.intervalPatterns=[u.oLocaleData.getCombinedIntervalPattern(u.oFormatOptions.pattern,u.oFormatOptions.calendarType),u.oFormatOptions.pattern]}u.intervalPatterns.push(u.oFormatOptions.pattern+" - "+u.oFormatOptions.pattern);if(h){h=h.replace(/'/g,"''");h="'"+h+"'";u.intervalPatterns.unshift(d+h+d)}u.intervalPatterns=Array.from(new Set(u.intervalPatterns))}if(!n){o=a.aFallbackFormatOptions;if(a.bShortFallbackFormatOptions){f=a.getPattern(u.oLocaleData,"short");o=o.concat(g._createFallbackOptionsWithoutDelimiter(f))}if(u.oFormatOptions.pattern&&a.bPatternFallbackWithoutDelimiter){o=g._createFallbackOptionsWithoutDelimiter(u.oFormatOptions.pattern).concat(o)}o=o.reduce(function(e,t){var a=Object.keys(t),r=e.some(function(e){return Object.keys(e).length===a.length&&a.every(function(a){return e[a]===t[a]})});if(!r){e.push(t)}return e},[]);u.aFallbackFormats=g._createFallbackFormat(o,u.oFormatOptions.calendarType,t,a,u.oFormatOptions)}u.oRequiredParts=a.oRequiredParts;u.aRelativeScales=a.aRelativeScales;u.aRelativeParseScales=a.aRelativeParseScales;u.aIntervalCompareFields=a.aIntervalCompareFields;u.init();return u};g.prototype.init=function(){var e=this.oFormatOptions.calendarType;this.aMonthsAbbrev=this.oLocaleData._getMonthsWithAlternatives("abbreviated",e);this.aMonthsWide=this.oLocaleData.getMonths("wide",e);this.aMonthsNarrow=this.oLocaleData.getMonths("narrow",e);this.aMonthsAbbrevSt=this.oLocaleData._getMonthsStandAloneWithAlternatives("abbreviated",e);this.aMonthsWideSt=this.oLocaleData.getMonthsStandAlone("wide",e);this.aMonthsNarrowSt=this.oLocaleData.getMonthsStandAlone("narrow",e);this.aDaysAbbrev=this.oLocaleData.getDays("abbreviated",e);this.aDaysWide=this.oLocaleData.getDays("wide",e);this.aDaysNarrow=this.oLocaleData.getDays("narrow",e);this.aDaysShort=this.oLocaleData.getDays("short",e);this.aDaysAbbrevSt=this.oLocaleData.getDaysStandAlone("abbreviated",e);this.aDaysWideSt=this.oLocaleData.getDaysStandAlone("wide",e);this.aDaysNarrowSt=this.oLocaleData.getDaysStandAlone("narrow",e);this.aDaysShortSt=this.oLocaleData.getDaysStandAlone("short",e);this.aQuartersAbbrev=this.oLocaleData.getQuarters("abbreviated",e);this.aQuartersWide=this.oLocaleData.getQuarters("wide",e);this.aQuartersNarrow=this.oLocaleData.getQuarters("narrow",e);this.aQuartersAbbrevSt=this.oLocaleData.getQuartersStandAlone("abbreviated",e);this.aQuartersWideSt=this.oLocaleData.getQuartersStandAlone("wide",e);this.aQuartersNarrowSt=this.oLocaleData.getQuartersStandAlone("narrow",e);this.aErasNarrow=this.oLocaleData.getEras("narrow",e);this.aErasAbbrev=this.oLocaleData.getEras("abbreviated",e);this.aErasWide=this.oLocaleData.getEras("wide",e);this.aDayPeriodsAbbrev=this.oLocaleData.getDayPeriods("abbreviated",e);this.aDayPeriodsNarrow=this.oLocaleData.getDayPeriods("narrow",e);this.aDayPeriodsWide=this.oLocaleData.getDayPeriods("wide",e);this.oFlexibleDayPeriodsAbbrev=this.oLocaleData.getFlexibleDayPeriods("abbreviated",e);this.oFlexibleDayPeriodsNarrow=this.oLocaleData.getFlexibleDayPeriods("narrow",e);this.oFlexibleDayPeriodsWide=this.oLocaleData.getFlexibleDayPeriods("wide",e);this.oFlexibleDayPeriodsAbbrevSt=this.oLocaleData.getFlexibleDayPeriodsStandAlone("abbreviated",e);this.oFlexibleDayPeriodsNarrowSt=this.oLocaleData.getFlexibleDayPeriodsStandAlone("narrow",e);this.oFlexibleDayPeriodsWideSt=this.oLocaleData.getFlexibleDayPeriodsStandAlone("wide",e);this.aFormatArray=this.parseCldrDatePattern(this.oFormatOptions.pattern);this.sAllowedCharacters=this.getAllowedCharacters(this.aFormatArray)};g._createFallbackFormat=function(e,t,a,r,n){return e.map(function(e){var i=Object.assign({},e);i.showDate=n.showDate;i.showTime=n.showTime;i.showTimezone=n.showTimezone;if(typeof r.getTimezonePattern==="function"&&i.pattern){i.pattern=r.getTimezonePattern(i.pattern)}if(n.interval){i.interval=true}i.calendarType=t;return g.createInstance(i,a,r,true)})};g._createFallbackOptionsWithoutDelimiter=function(e){var t=/[^dMyGU]/g,a={regex:/d+/g,replace:"dd"},r={regex:/M+/g,replace:"MM"},n={regex:/[yU]+/g,replace:["yyyy","yy"]};e=e.replace(t,"");e=e.replace(a.regex,a.replace);e=e.replace(r.regex,r.replace);return n.replace.map(function(t){return{pattern:e.replace(n.regex,t),strictParsing:true}})};var D={isNumber:function(e){return e>=48&&e<=57},findNumbers:function(e,t){var a=0;while(a<t&&this.isNumber(e.charCodeAt(a))){a++}return e.substr(0,a)},startsWithIgnoreCase:function(e,t,a){if(e.startsWith(t)){return true}try{var r=t.toLocaleUpperCase(a);var n=e.toLocaleUpperCase(a);if(r.length!==t.length||n.length!==e.length){return false}return n.startsWith(r)}catch(e){return false}},findEntry:function(e,t,a){let r=-1;let n=0;t.forEach((t,i)=>{(Array.isArray(t)?t:[t]).forEach(t=>{if(t.length>n&&this.startsWithIgnoreCase(e,t,a)){r=i;n=t.length}})});return{index:r,length:n}},parseTZ:function(e,t){var a=0;var r=e.charAt(0)==="+"?-1:1;var n;if(e[0]==="Z"){return{length:1,tzDiff:0}}a++;n=this.findNumbers(e.substr(a),2);var i=parseInt(n);a+=2;if(t){a++}n=this.findNumbers(e.substr(a),2);var o=0;if(n){a+=2;o=parseInt(n)}return{length:a,tzDiff:(o+60*i)*60*r}},checkValid:function(e,t,a){if(e in a.oRequiredParts&&t){return false}return true}};g._oParseHelper=D;g._createPatternSymbol=function(e){var t=typeof e.isNumeric==="function"&&e.isNumeric||function(){return e.isNumeric||false};return{name:e.name,format:e.format||function(){return""},parse:e.parse||function(){return{}},isNumeric:t}};g.prototype.oSymbols={"":g._createPatternSymbol({name:"text",format:function(e,t){return e.value},parse:function(e,t,a,r){var n;var i=true;var o=0;var s=0;var l="-~‐‑‒–—﹘﹣－～";const u=g._normalize(t.value);for(;s<u.length;s++){n=u.charAt(s);if(n===" "){while(e.charAt(o)===" "){o++}}else if(l.includes(n)){if(!l.includes(e.charAt(o))){i=false}o++}else{if(e.charAt(o)!==n){i=false}o++}if(!i){break}}if(i){return{length:o}}else{var f=false;if(r.index<r.formatArray.length-1){f=r.formatArray[r.index+1].type in a.oRequiredParts}return{valid:D.checkValid(t.type,f,a)}}}}),G:g._createPatternSymbol({name:"era",format:function(e,t,a,r){var n=t.getUTCEra();if(e.digits<=3){return r.aErasAbbrev[n]}else if(e.digits===4){return r.aErasWide[n]}else{return r.aErasNarrow[n]}},parse:function(e,t,a,r){var n=[a.aErasWide,a.aErasAbbrev,a.aErasNarrow];for(var i=0;i<n.length;i++){var o=n[i];var s=D.findEntry(e,o,a.oLocaleData.sCLDRLocaleId);if(s.index!==-1){return{era:s.index,length:s.length}}}return{era:a.aErasWide.length-1,valid:D.checkValid(t.type,true,a)}}}),y:g._createPatternSymbol({name:"year",format:function(e,t,a,r){var i=t.getUTCFullYear();var o=String(i);var s=r.oFormatOptions.calendarType;if(e.digits===2&&o.length>2){o=o.substr(o.length-2)}if(s!==n.Japanese&&e.digits===1&&i<100){o=o.padStart(4,"0")}return o.padStart(e.digits,"0")},parse:function(e,t,a,r){var i,o,s,l=a.oFormatOptions.calendarType;if(t.digits===1){i=4}else if(t.digits===2){i=2}else{i=t.digits}o=D.findNumbers(e,i);s=o===""||r.exactLength&&o.length!==i;var u=parseInt(o);if(l!==n.Japanese&&o.length<=2){var f=h.getInstance(d.getInstance(),l),c=f.getUTCFullYear(),m=Math.floor(c/100),g=m*100+u-c;if(g<-70){u+=(m+1)*100}else if(g<30){u+=m*100}else{u+=(m-1)*100}}return{length:o.length,valid:D.checkValid(t.type,s,a),year:u}},isNumeric:true}),Y:g._createPatternSymbol({name:"weekYear",format:function(e,t,a,r){var i=t.getUTCWeek(r.oLocale,T(r.oFormatOptions));var o=i.year;var s=String(o);var l=r.oFormatOptions.calendarType;if(e.digits===2&&s.length>2){s=s.substr(s.length-2)}if(l!==n.Japanese&&e.digits===1&&o<100){s=s.padStart(4,"0")}return s.padStart(e.digits,"0")},parse:function(e,t,a,r){var i,o,s,l=a.oFormatOptions.calendarType;if(t.digits===1){i=4}else if(t.digits===2){i=2}else{i=t.digits}o=D.findNumbers(e,i);s=o===""||r.exactLength&&o.length!==i;var u=parseInt(o);var f=u;if(l!==n.Japanese&&o.length<=2){var c=h.getInstance(d.getInstance(),l),m=c.getUTCFullYear(),g=Math.floor(m/100),p=g*100+f-m;if(p<-70){f+=(g+1)*100}else if(p<30){f+=g*100}else{f+=(g-1)*100}}return{length:o.length,valid:D.checkValid(t.type,s,a),year:u,weekYear:f}},isNumeric:true}),M:g._createPatternSymbol({name:"month",format:function(e,t,a,r){var n=t.getUTCMonth();if(e.digits===3){const e=r.aMonthsAbbrev[n];return Array.isArray(e)?e[0]:e}else if(e.digits===4){return r.aMonthsWide[n]}else if(e.digits>4){return r.aMonthsNarrow[n]}else{return String(n+1).padStart(e.digits,"0")}},parse:function(e,t,a,r){var n,i,o,s,l=[a.aMonthsWide,a.aMonthsWideSt,a.aMonthsAbbrev,a.aMonthsAbbrevSt,a.aMonthsNarrow,a.aMonthsNarrowSt];if(t.digits<3){i=D.findNumbers(e,Math.max(t.digits,2));o=i===""||r.exactLength&&i.length<2;s=D.checkValid(t.type,o,a);n=parseInt(i)-1;if(r.strict&&(n>11||n<0)){s=false}}else{for(var u=0;u<l.length;u++){var f=l[u];var c=D.findEntry(e,f,a.oLocaleData.sCLDRLocaleId);if(c.index!==-1){return{month:c.index,length:c.length}}}s=D.checkValid(t.type,true,a)}return{month:n,length:i?i.length:0,valid:s}},isNumeric:function(e){return e<3}}),L:g._createPatternSymbol({name:"monthStandalone",format:function(e,t,a,r){var n=t.getUTCMonth();if(e.digits===3){const e=r.aMonthsAbbrevSt[n];return Array.isArray(e)?e[0]:e}else if(e.digits===4){return r.aMonthsWideSt[n]}else if(e.digits>4){return r.aMonthsNarrowSt[n]}else{return String(n+1).padStart(e.digits,"0")}},parse:function(e,t,a,r){var n,i,o,s,l=[a.aMonthsWide,a.aMonthsWideSt,a.aMonthsAbbrev,a.aMonthsAbbrevSt,a.aMonthsNarrow,a.aMonthsNarrowSt];if(t.digits<3){i=D.findNumbers(e,Math.max(t.digits,2));o=i===""||r.exactLength&&i.length<2;s=D.checkValid(t.type,o,a);n=parseInt(i)-1;if(r.strict&&(n>11||n<0)){s=false}}else{for(var u=0;u<l.length;u++){var f=l[u];var c=D.findEntry(e,f,a.oLocaleData.sCLDRLocaleId);if(c.index!==-1){return{month:c.index,length:c.length}}}s=D.checkValid(t.type,true,a)}return{month:n,length:i?i.length:0,valid:s}},isNumeric:function(e){return e<3}}),w:g._createPatternSymbol({name:"weekInYear",format:function(e,t,a,r){var n=t.getUTCWeek(r.oLocale,T(r.oFormatOptions));var i=n.week;var o=String(i+1);if(e.digits<3){o=o.padStart(e.digits,"0")}else{o=r.oLocaleData.getCalendarWeek(e.digits===3?"narrow":"wide",o.padStart(2,"0"))}return o},parse:function(e,t,a,r){var n,i,o,s,l=0;if(t.digits<3){n=D.findNumbers(e,2);l=n.length;s=parseInt(n)-1;i=!n||r.exactLength&&l<2;o=D.checkValid(t.type,i,a)}else{n=a.oLocaleData.getCalendarWeek(t.digits===3?"narrow":"wide");n=n.replace("{0}","([0-9]+)");var u=new RegExp(n),f=u.exec(e);if(f){l=f[0].length;s=parseInt(f[f.length-1])-1}else{o=D.checkValid(t.type,true,a)}}return{length:l,valid:o,week:s}},isNumeric:function(e){return e<3}}),W:g._createPatternSymbol({name:"weekInMonth"}),D:g._createPatternSymbol({name:"dayInYear"}),d:g._createPatternSymbol({name:"day",format:function(e,t){var a=t.getUTCDate();return String(a).padStart(e.digits,"0")},parse:function(e,t,a,r){var n=D.findNumbers(e,Math.max(t.digits,2)),i=n===""||r.exactLength&&n.length<2,o=D.checkValid(t.type,i,a),s=parseInt(n);if(r.strict&&(s>31||s<1)){o=false}return{day:s,length:n.length,valid:o}},isNumeric:true}),Q:g._createPatternSymbol({name:"quarter",format:function(e,t,a,r){var n=t.getUTCQuarter();if(e.digits===3){return r.aQuartersAbbrev[n]}else if(e.digits===4){return r.aQuartersWide[n]}else if(e.digits>4){return r.aQuartersNarrow[n]}else{return String(n+1).padStart(e.digits,"0")}},parse:function(e,t,a,r){var n,i,o,s;var l=[a.aQuartersWide,a.aQuartersWideSt,a.aQuartersAbbrev,a.aQuartersAbbrevSt,a.aQuartersNarrow,a.aQuartersNarrowSt];if(t.digits<3){n=D.findNumbers(e,Math.max(t.digits,2));i=n===""||r.exactLength&&n.length<2;s=D.checkValid(t.type,i,a);o=parseInt(n)-1;if(r.strict&&o>3){s=false}}else{for(var u=0;u<l.length;u++){var f=l[u];var c=D.findEntry(e,f,a.oLocaleData.sCLDRLocaleId);if(c.index!==-1){return{quarter:c.index,length:c.length}}}s=D.checkValid(t.type,true,a)}return{length:n?n.length:0,quarter:o,valid:s}},isNumeric:function(e){return e<3}}),q:g._createPatternSymbol({name:"quarterStandalone",format:function(e,t,a,r){var n=t.getUTCQuarter();if(e.digits===3){return r.aQuartersAbbrevSt[n]}else if(e.digits===4){return r.aQuartersWideSt[n]}else if(e.digits>4){return r.aQuartersNarrowSt[n]}else{return String(n+1).padStart(e.digits,"0")}},parse:function(e,t,a,r){var n,i,o,s;var l=[a.aQuartersWide,a.aQuartersWideSt,a.aQuartersAbbrev,a.aQuartersAbbrevSt,a.aQuartersNarrow,a.aQuartersNarrowSt];if(t.digits<3){n=D.findNumbers(e,Math.max(t.digits,2));i=n===""||r.exactLength&&n.length<2;s=D.checkValid(t.type,i,a);o=parseInt(n)-1;if(r.strict&&o>3){s=false}}else{for(var u=0;u<l.length;u++){var f=l[u];var c=D.findEntry(e,f,a.oLocaleData.sCLDRLocaleId);if(c.index!==-1){return{quarter:c.index,length:c.length}}}s=D.checkValid(t.type,true,a)}return{length:n?n.length:0,quarter:o,valid:s}},isNumeric:function(e){return e<3}}),F:g._createPatternSymbol({name:"dayOfWeekInMonth"}),E:g._createPatternSymbol({name:"dayNameInWeek",format:function(e,t,a,r){var n=t.getUTCDay();if(e.digits<4){return r.aDaysAbbrev[n]}else if(e.digits===4){return r.aDaysWide[n]}else if(e.digits===5){return r.aDaysNarrow[n]}else{return r.aDaysShort[n]}},parse:function(e,t,a,r){var n=[a.aDaysWide,a.aDaysWideSt,a.aDaysAbbrev,a.aDaysAbbrevSt,a.aDaysShort,a.aDaysShortSt,a.aDaysNarrow,a.aDaysNarrowSt];for(var i=0;i<n.length;i++){var o=n[i];var s=D.findEntry(e,o,a.oLocaleData.sCLDRLocaleId);if(s.index!==-1){return{dayOfWeek:s.index,length:s.length}}}}}),c:g._createPatternSymbol({name:"dayNameInWeekStandalone",format:function(e,t,a,r){var n=t.getUTCDay();if(e.digits<4){return r.aDaysAbbrevSt[n]}else if(e.digits===4){return r.aDaysWideSt[n]}else if(e.digits===5){return r.aDaysNarrowSt[n]}else{return r.aDaysShortSt[n]}},parse:function(e,t,a,r){var n=[a.aDaysWide,a.aDaysWideSt,a.aDaysAbbrev,a.aDaysAbbrevSt,a.aDaysShort,a.aDaysShortSt,a.aDaysNarrow,a.aDaysNarrowSt];for(var i=0;i<n.length;i++){var o=n[i];var s=D.findEntry(e,o,a.oLocaleData.sCLDRLocaleId);if(s.index!==-1){return{day:s.index,length:s.length}}}}}),u:g._createPatternSymbol({name:"dayNumberOfWeek",format:function(e,t,a,r){var n=t.getUTCDay();return r._adaptDayOfWeek(n)},parse:function(e,t,a,r){var n=D.findNumbers(e,t.digits),i=r.exactLength&&n.length!==t.digits;return{dayNumberOfWeek:parseInt(n),length:n.length,valid:D.checkValid(t.type,i,a)}},isNumeric:true}),a:g._createPatternSymbol({name:"amPmMarker",format:function(e,t,a,r){var n=t.getUTCDayPeriod();if(e.digits<=3){return r.aDayPeriodsAbbrev[n]}else if(e.digits===4){return r.aDayPeriodsWide[n]}else{return r.aDayPeriodsNarrow[n]}},parse:function(e,t,a,r,n){var i,o,s,l,u,f,c=[a.aDayPeriodsWide,a.aDayPeriodsAbbrev,a.aDayPeriodsNarrow];i=/[aApP](?:\.)?[\x20\xA0]?[mM](?:\.)?/;u=e.match(i);o=u&&u.index===0;function d(e){return e.replace(/[\x20\xA0]/g,"").replace(/\./g,"")}if(o){e=d(e)}for(l=0;l<c.length;l+=1){f=c[l].map(e=>g._normalize(e));if(o){f=f.map(d)}s=D.findEntry(e,f,a.oLocaleData.sCLDRLocaleId);if(s.index!==-1){return{pm:s.index===1,length:o?u[0].length:s.length}}}return{valid:false}}}),B:g._createPatternSymbol({name:"flexibleDayPeriod",format:function(e,t,a,r){var n=r.aFormatArray.some(function(e){return"hHKk".includes(e.symbol)}),i=r.oLocaleData.getFlexibleDayPeriodOfTime(t.getUTCHours(),t.getUTCMinutes());if(n){if(e.digits<=3){return r.oFlexibleDayPeriodsAbbrev[i]}if(e.digits===4){return r.oFlexibleDayPeriodsWide[i]}return r.oFlexibleDayPeriodsNarrow[i]}if(e.digits<=3){return r.oFlexibleDayPeriodsAbbrevSt[i]}if(e.digits===4){return r.oFlexibleDayPeriodsWideSt[i]}return r.oFlexibleDayPeriodsNarrowSt[i]},parse:function(e,t,a,r){var n,i,o,s=a.aFormatArray.some(function(e){return"hHKk".includes(e.symbol)}),l=[a.oFlexibleDayPeriodsWide,a.oFlexibleDayPeriodsAbbrev,a.oFlexibleDayPeriodsNarrow];if(s){for(n=0;n<l.length;n++){o=l[n];i=D.findEntry(e,Object.values(o),a.oLocaleData.sCLDRLocaleId);if(i.index!==-1){return{flexDayPeriod:Object.keys(o)[i.index],length:i.length}}}}return{valid:false}}}),H:g._createPatternSymbol({name:"hour0_23",format:function(e,t){var a=t.getUTCHours();return String(a).padStart(e.digits,"0")},parse:function(e,t,a,r){var n=D.findNumbers(e,Math.max(t.digits,2)),i=parseInt(n),o=n===""||r.exactLength&&n.length<2,s=D.checkValid(t.type,o,a);if(r.strict&&i>23){s=false}return{hour:i,length:n.length,valid:s}},isNumeric:true}),k:g._createPatternSymbol({name:"hour1_24",format:function(e,t){var a=t.getUTCHours();var r=a===0?"24":String(a);return r.padStart(e.digits,"0")},parse:function(e,t,a,r){var n=D.findNumbers(e,Math.max(t.digits,2)),i=parseInt(n),o=n===""||r.exactLength&&n.length<2,s=D.checkValid(t.type,o,a);if(i===24){i=0}if(r.strict&&i>23){s=false}return{hour:i,length:n.length,valid:s}},isNumeric:true}),K:g._createPatternSymbol({name:"hour0_11",format:function(e,t){var a=t.getUTCHours();var r=String(a>11?a-12:a);return r.padStart(e.digits,"0")},parse:function(e,t,a,r){var n=D.findNumbers(e,Math.max(t.digits,2)),i=parseInt(n),o=n===""||r.exactLength&&n.length<2,s=D.checkValid(t.type,o,a);if(r.strict&&i>11){s=false}return{hour:i,length:n.length,valid:s}},isNumeric:true}),h:g._createPatternSymbol({name:"hour1_12",format:function(e,t){var a=t.getUTCHours();var r;if(a>12){r=String(a-12)}else if(a===0){r="12"}else{r=String(a)}return r.padStart(e.digits,"0")},parse:function(e,t,a,r){var n=r.dateValue.pm,i=D.findNumbers(e,Math.max(t.digits,2)),o=parseInt(i),s=i===""||r.exactLength&&i.length<2,l=D.checkValid(t.type,s,a);if(o===12){o=0;n=n===undefined?true:n}if(r.strict&&o>11){l=false}return{hour:o,length:i.length,pm:n,valid:l}},isNumeric:true}),m:g._createPatternSymbol({name:"minute",format:function(e,t){var a=t.getUTCMinutes();return String(a).padStart(e.digits,"0")},parse:function(e,t,a,r){var n=D.findNumbers(e,Math.max(t.digits,2)),i=parseInt(n),o=n===""||r.exactLength&&n.length<2,s=D.checkValid(t.type,o,a);if(r.strict&&i>59){s=false}return{length:n.length,minute:i,valid:s}},isNumeric:true}),s:g._createPatternSymbol({name:"second",format:function(e,t){var a=t.getUTCSeconds();return String(a).padStart(e.digits,"0")},parse:function(e,t,a,r){var n=Math.max(t.digits,2),i=D.findNumbers(e,n),o=i===""||r.exactLength&&i.length<n,s=parseInt(i),l=D.checkValid(t.type,o,a);if(r.strict&&s>59){l=false}return{length:i.length,second:s,valid:l}},isNumeric:true}),S:g._createPatternSymbol({name:"fractionalsecond",format:function(e,t){var a=t.getUTCMilliseconds();var r=String(a);var n=r.padStart(3,"0");n=n.substr(0,e.digits);n=n.padEnd(e.digits,"0");return n},parse:function(e,t,a,r){var n=D.findNumbers(e,t.digits),i=n.length,o=r.exactLength&&i<t.digits;n=n.substr(0,3);n=n.padEnd(3,"0");var s=parseInt(n);return{length:i,millisecond:s,valid:D.checkValid(t.type,o,a)}},isNumeric:true}),z:g._createPatternSymbol({name:"timezoneGeneral",format:function(e,t,a,r,n){if(e.digits>3&&t.getTimezoneLong&&t.getTimezoneLong()){return t.getTimezoneLong()}else if(t.getTimezoneShort&&t.getTimezoneShort()){return t.getTimezoneShort()}var i=m.calculateOffset(t,n);var o="GMT";var s=Math.abs(i/60);var l=i>0;var u=Math.floor(s/60);var f=Math.floor(s%60);if(!a&&s!==0){o+=l?"-":"+";o+=String(u).padStart(2,"0");o+=":";o+=String(f).padStart(2,"0")}else{o+="Z"}return o},parse:function(e,t,a,r){var n=0;var i;var o=e.substring(0,3);if(o==="GMT"||o==="UTC"){n=3}else if(e.substring(0,2)==="UT"){n=2}else if(e.charAt(0)==="Z"){n=1;i=0}else{return{error:"cannot be parsed correctly by sap.ui.core.format.DateFormat: The given timezone is not supported!"}}if(e.charAt(0)!=="Z"){var s=D.parseTZ(e.substr(n),true);n+=s.length;i=s.tzDiff}return{length:n,tzDiff:i}}}),Z:g._createPatternSymbol({name:"timezoneRFC822",format:function(e,t,a,r,n){var i=m.calculateOffset(t,n);var o=Math.abs(i/60);var s=i>0;var l=Math.floor(o/60);var u=Math.floor(o%60);var f="";if(!a){f+=s?"-":"+";f+=String(l).padStart(2,"0");f+=String(u).padStart(2,"0")}return f},parse:function(e,t,a,r){return D.parseTZ(e,false)}}),X:g._createPatternSymbol({name:"timezoneISO8601",format:function(e,t,a,r,n){var i=m.calculateOffset(t,n);var o=Math.abs(i/60);var s=i>0;var l=Math.floor(o/60);var u=Math.floor(o%60);var f="";if(!a&&o!==0){f+=s?"-":"+";f+=String(l).padStart(2,"0");if(e.digits>1||u>0){if(e.digits===3||e.digits===5){f+=":"}f+=String(u).padStart(2,"0")}}else{f+="Z"}return f},parse:function(e,t,a,r){if(e.charAt(0)==="Z"){return{length:1,tzDiff:0}}else{return D.parseTZ(e,t.digits===3||t.digits===5)}}}),V:g._createPatternSymbol({name:"timezoneID",format:function(e,t,a,r,n){if(!a&&e.digits===2){return r.oLocaleData.getTimezoneTranslations()[n]||n}return""},parse:function(e,t,a,r,n){var i={timezone:"",length:0};if(t.digits===2){var o=a.oLocaleData.getTimezoneTranslations();if(e===o[n]){return{timezone:n,length:e.length}}var s=Object.values(o);var l=D.findEntry(e,s,a.oLocaleData.sCLDRLocaleId);if(l.index!==-1){return{timezone:Object.keys(o)[l.index],length:l.length}}var u="";for(var f=e.length;f>0;f-=1){u=e.slice(0,f);if(m.isValidTimezone(u)){i.timezone=u;i.length=u.length;break}}}return i}})};g.prototype._format=function(e,t,a){if(this.oFormatOptions.relative){var r=this.formatRelative(e,t,this.oFormatOptions.relativeRange,a);if(r){return r}}var n=this.oFormatOptions.calendarType;var i=h.getInstance(e,n);var o=[],s,l,f;for(var c=0;c<this.aFormatArray.length;c++){s=this.aFormatArray[c];f=s.symbol||"";o.push(this.oSymbols[f].format(s,i,t,this,a))}l=o.join("");if(u.collectOriginInfo()){l=new String(l);l.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString(),style:this.oFormatOptions.style,pattern:this.oFormatOptions.pattern}}return l};g.prototype.format=function(t,a){var r;if(this.type===p.DATETIME_WITH_TIMEZONE){r=a;a=false;v(r);if(r&&!m.isValidTimezone(r)){e.error("The given timezone isn't valid.");return""}}var o=this.oFormatOptions.calendarType,s;if(a===undefined){a=this.oFormatOptions.UTC}r=r||i.getTimezone();if(Array.isArray(t)){if(!this.oFormatOptions.interval){e.error("Non-interval DateFormat can't format more than one date instance.");return""}if(t.length!==2){e.error("Interval DateFormat can only format with 2 date instances but "+t.length+" is given.");return""}t=t.map(function(e){return S(e,r,a)});if(this.oFormatOptions.singleIntervalValue){if(t[0]===null){e.error("First date instance which is passed to the interval DateFormat shouldn't be null.");return""}if(t[1]===null){s=this._format(t[0],a,r)}}if(s===undefined){if(!t.every(k)){e.error("At least one date instance which is passed to the interval DateFormat isn't valid.");return""}s=this._formatInterval(t,a)}}else{if(!k(t)){if(this.type===p.DATETIME_WITH_TIMEZONE&&this.oFormatOptions.pattern.includes("VV")){return this.oLocaleData.getTimezoneTranslations()[r]||r}e.error("The given date instance isn't valid.");return""}if(this.oFormatOptions.interval){e.error("Interval DateFormat expects an array with two dates for the first argument but only one date is given.");return""}t=S(t,r,a);s=this._format(t,a,r)}if(o===n.Japanese&&this.oLocale.getLanguage()==="ja"){s=s.replace(/(^|[^\d])1年/g,"$1元年")}return s};g.prototype._useCustomIntervalDelimiter=function(e){var t;if(!this.oFormatOptions.intervalDelimiter){return false}if(this.oFormatOptions.format){t=this.oLocaleData._parseSkeletonFormat(this.oFormatOptions.format);return t.some(function(t){return e[t.group]})}return true};g.prototype._formatInterval=function(e,t){var a,r,n,i,o=[],s=this.oFormatOptions.calendarType,l=[],u=h.getInstance(e[0],s),f=h.getInstance(e[1],s),c=this._getDiffFields([u,f]);if(!c){return this._format(e[0],t)}if(this._useCustomIntervalDelimiter(c)){n=this.intervalPatterns[0]}else if(this.oFormatOptions.format){n=this.oLocaleData.getCustomIntervalPattern(this.oFormatOptions.format,c,s)}else{n=this.oLocaleData.getCombinedIntervalPattern(this.oFormatOptions.pattern,s)}l=this.parseCldrDatePattern(n);a=u;for(var d=0;d<l.length;d++){r=l[d];i=r.symbol||"";if(r.repeat){a=f}o.push(this.oSymbols[i].format(r,a,t,this))}return o.join("")};var b={Era:"Era",FullYear:"Year",Quarter:"Quarter",Month:"Month",Week:"Week",Date:"Day",DayPeriod:"DayPeriod",Hours:"Hour",Minutes:"Minute",Seconds:"Second"};g.prototype._getDiffFields=function(e){var t=false,r={};this.aIntervalCompareFields.forEach(function(n){var i="getUTC",o=i+n,s=b[n],l=e[0][o].apply(e[0]),u=e[1][o].apply(e[1]);if(!a(l,u)){t=true;r[s]=true}});if(t){return r}return null};g.prototype._parse=function(e,t,a,n,i){var o,s,l,u,f,c,d,h={valid:true,lastTimezonePatternSymbol:""},m=0,g={formatArray:t,dateValue:h,strict:n},p=this;function y(e){return p.oSymbols[e.symbol||""]}function v(e){return!!e&&y(e).isNumeric(e.digits)}for(var D=0;D<t.length;D++){d=e.substr(m);l=t[D];f=t[D-1];s=t[D+1];g.index=D;g.exactLength=v(l)&&(v(f)||v(s));c=y(l).parse(d,l,this,g,i)||{};if(c.tzDiff!==undefined||c.timezone){c.lastTimezonePatternSymbol=l.symbol}h=r(h,c);if(c.valid===false){break}m+=c.length||0}h.index=m;u=h.pm;if(h.flexDayPeriod&&h.hour*60+(h.minute||0)<720){o=this.oLocaleData.getFlexibleDayPeriodOfTime(h.hour+12,h.minute||0);u=h.flexDayPeriod===o}if(u){h.hour+=12}if(h.dayNumberOfWeek===undefined&&h.dayOfWeek!==undefined){h.dayNumberOfWeek=this._adaptDayOfWeek(h.dayOfWeek)}if(h.quarter!==undefined&&h.month===undefined&&h.day===undefined){h.month=3*h.quarter;h.day=1}return h};g.prototype._parseInterval=function(e,t,a,r,n){var i,o,s;this.intervalPatterns.some(function(t){var l=this.parseCldrDatePattern(t);o=undefined;for(var u=0;u<l.length;u++){if(l[u].repeat){o=u;break}}if(o===undefined){s=this._parse(e,l,a,r,n);if(s.index===0||s.index<e.length){s.valid=false}if(s.valid===false){return}i=[s,s];return true}else{i=[];s=this._parse(e,l.slice(0,o),a,r,n);if(s.valid===false){return}i.push(s);var f=s.index;s=this._parse(e.substring(f),l.slice(o),a,r,n);if(s.index===0||s.index+f<e.length){s.valid=false}if(s.valid===false){return}i.push(s);return true}}.bind(this));return i};function T(e){if(e.calendarWeekNumbering){return e.calendarWeekNumbering}else if(e.firstDayOfWeek!==undefined&&e.minimalDaysInFirstWeek!==undefined){return{firstDayOfWeek:e.firstDayOfWeek,minimalDaysInFirstWeek:e.minimalDaysInFirstWeek}}return undefined}var S=function(e,t,a){if(!a&&k(e)){return m.convertToTimezone(e,t)}return e};var F=function(e,t,a,r,n,i,o){if(!e.valid){return null}var s,l=typeof e.year==="number"?e.year:1970;s=h.getInstance(new Date(0),t);s.setUTCEra(e.era||h.getCurrentEra(t));s.setUTCFullYear(l,e.month||0,e.day||1);s.setUTCHours(e.hour||0);s.setUTCMinutes(e.minute||0);s.setUTCSeconds(e.second||0);s.setUTCMilliseconds(e.millisecond||0);if(r&&(e.day||1)!==s.getUTCDate()){return null}if(e.week!==undefined&&(e.month===undefined||e.day===undefined)){s.setUTCWeek({year:e.weekYear||e.year,week:e.week},o,T(i));if(e.dayNumberOfWeek!==undefined){s.setUTCDate(s.getUTCDate()+e.dayNumberOfWeek-1)}}s=s.getJSDate();if(!a&&(e.lastTimezonePatternSymbol==="V"&&e.timezone||e.tzDiff===undefined)){if(e.timezone){n=e.timezone}if(n){e.tzDiff=m.calculateOffset(s,n)}}if(e.tzDiff){s.setUTCSeconds(s.getUTCSeconds()+e.tzDiff)}return s};function O(e,t){if(e===t){return e}var a={};Object.keys(e).forEach(function(t){a[t]=e[t]});Object.keys(t).forEach(function(e){if(!a.hasOwnProperty(e)){a[e]=t[e]}});return a}function w(e,t){if(e.getTime()>t.getTime()){return false}return true}function k(e){return e&&typeof e.getTime==="function"&&!isNaN(e.getTime())}g.prototype.parse=function(t,a,r){var o=this.oFormatOptions.showDate===undefined||this.oFormatOptions.showDate;var s=this.oFormatOptions.showTime===undefined||this.oFormatOptions.showTime;if(this.type===p.DATETIME_WITH_TIMEZONE&&(o&&!s||!o&&s)){throw new TypeError("The input can only be parsed back to date if both date and time are supplied.")}var l;if(a===undefined&&this.type!==p.DATETIME_WITH_TIMEZONE){a=this.oFormatOptions.UTC}var u=a;if(this.type===p.DATETIME_WITH_TIMEZONE){l=a;a=false;v(l);if(l&&!m.isValidTimezone(l)){e.error("The given timezone isn't valid.");return null}}t=t==null?"":String(t).trim();t=g._normalize(t);var f;var c=this.oFormatOptions.calendarType;l=l||i.getTimezone();if(r===undefined){r=this.oFormatOptions.strictParsing}if(c===n.Japanese&&this.oLocale.getLanguage()==="ja"){t=t.replace(/元年/g,"1年")}if(!this.oFormatOptions.interval){var d=this.parseRelative(t,a);if(d){return d}f=this._parse(t,this.aFormatArray,a,r,l);if(f.index===0||f.index<t.length){f.valid=false}d=F(f,c,a,r,l,this.oFormatOptions,this.oLocale);if(d){if(this.type===p.DATETIME_WITH_TIMEZONE){var h=this.oFormatOptions.showTimezone===undefined||this.oFormatOptions.showTimezone;if(!h&&o&&s){return[d,undefined]}else if(h&&!o&&!s){return[undefined,f.timezone]}return[d,f.timezone||undefined]}return d}}else{var y=this._parseInterval(t,c,a,r,l);var D,b;if(y&&y.length===2){var T=O(y[0],y[1]);var S=O(y[1],y[0]);D=F(T,c,a,r,l,this.oFormatOptions,this.oLocale);b=F(S,c,a,r,l,this.oFormatOptions,this.oLocale);if(D&&b){if(this.oFormatOptions.singleIntervalValue&&D.getTime()===b.getTime()){return[D,null]}var k=w(D,b);if(r&&!k){e.error("StrictParsing: Invalid date range. The given end date is before the start date.");return[null,null]}return[D,b]}}}if(this.aFallbackFormats){var I;this.aFallbackFormats.every(function(e){I=e.parse(t,u,r);if(Array.isArray(I)){if(e.type===p.DATETIME_WITH_TIMEZONE){return false}return!(I[0]&&I[1])}else{return!I}});return I}if(!this.oFormatOptions.interval){return null}else{return[null,null]}};g.prototype.parseCldrDatePattern=function(e){if(y[e]){return y[e]}var t=[],a,r=false,n=null,i="",o="",s={},l=false;for(a=0;a<e.length;a++){var u=e.charAt(a),f,c,d;if(r){if(u==="'"){c=e.charAt(a-1);d=e.charAt(a-2);f=e.charAt(a+1);if(c==="'"&&d!=="'"){r=false}else if(f==="'"){a+=1}else{r=false;continue}}if(i==="text"){n.value+=u}else{n={type:"text",value:u};t.push(n);i="text"}}else{if(u==="'"){r=true}else if(this.oSymbols[u]){o=this.oSymbols[u].name;if(i===o){n.digits++}else{n={type:o,symbol:u,digits:1};t.push(n);i=o;if(!l){if(s[o]){n.repeat=true;l=true}else{s[o]=true}}}}else{if(i==="text"){n.value+=u}else{n={type:"text",value:u};t.push(n);i="text"}}}}y[e]=t;return t};g.prototype.parseRelative=function(e,t){var a,r,n,i,o;if(!e){return null}a=this.oLocaleData.getRelativePatterns(this.aRelativeParseScales,this.oFormatOptions.relativeStyle);for(var s=0;s<a.length;s++){r=a[s];n=new RegExp("^\\s*"+r.pattern.replace(/\{0\}/,"(\\d+)")+"\\s*$","i");i=n.exec(e);if(i){if(r.value!==undefined){return l(r.value,r.scale)}else{o=parseInt(i[1]);return l(o*r.sign,r.scale)}}}function l(e,a){var r=d.getInstance();if(t){r.setUTCFullYear(r.getFullYear(),r.getMonth(),r.getDate());r.setUTCHours(r.getHours(),r.getMinutes(),r.getSeconds(),r.getMilliseconds());switch(a){case"second":r.setUTCSeconds(r.getUTCSeconds()+e);break;case"minute":r.setUTCMinutes(r.getUTCMinutes()+e);break;case"hour":r.setUTCHours(r.getUTCHours()+e);break;case"day":r.setUTCDate(r.getUTCDate()+e);break;case"week":r.setUTCDate(r.getUTCDate()+e*7);break;case"month":r.setUTCMonth(r.getUTCMonth()+e);break;case"quarter":r.setUTCMonth(r.getUTCMonth()+e*3);break;case"year":r.setUTCFullYear(r.getUTCFullYear()+e);break}}else{switch(a){case"second":r.setSeconds(r.getSeconds()+e);break;case"minute":r.setMinutes(r.getMinutes()+e);break;case"hour":r.setHours(r.getHours()+e);break;case"day":r.setDate(r.getDate()+e);break;case"week":r.setDate(r.getDate()+e*7);break;case"month":r.setMonth(r.getMonth()+e);break;case"quarter":r.setMonth(r.getMonth()+e*3);break;case"year":r.setFullYear(r.getFullYear()+e);break}}return r}};g.prototype.formatRelative=function(e,a,r,n){var i,o,s,l,u=S(new Date,n),f=this.oFormatOptions.relativeScale||"day";s=(e.getTime()-u.getTime())/1e3;if(this.oFormatOptions.relativeScale==="auto"){f=this._getScale(s,this.aRelativeScales);f=I(e,u,f,s)}if(!r){r=this._mRanges[f]}if(f==="year"||f==="month"||f==="day"){u=new Date(Date.UTC(u.getUTCFullYear(),u.getUTCMonth(),u.getUTCDate()));i=new Date(0);i.setUTCFullYear(e.getUTCFullYear(),e.getUTCMonth(),e.getUTCDate());e=i}o=this._getDifference(f,[u,e]);if(this.oFormatOptions.relativeScale!=="auto"&&(o<r[0]||o>r[1])){return null}l=this.oLocaleData.getRelativePattern(f,o,s>0,this.oFormatOptions.relativeStyle);return t(l,[Math.abs(o)])};g.prototype._mRanges={second:[-60,60],minute:[-60,60],hour:[-24,24],day:[-6,6],week:[-4,4],month:[-12,12],year:[-10,10]};g.prototype._mScales={second:1,minute:60,hour:3600,day:86400,week:604800,month:2592e3,quarter:7776e3,year:31536e3};g.prototype._getScale=function(e,t){var a,r;e=Math.abs(e);for(var n=0;n<t.length;n++){r=t[n];if(e>=this._mScales[r]){a=r;break}}if(!a){a=t[t.length-1]}return a};function I(e,t,a,r){var n=Math.abs(e.getUTCMonth()-t.getUTCMonth());if(a==="week"&&n===2){return"month"}else if(a==="week"&&n===1){if(e.getUTCDate()===t.getUTCDate()||r<0&&e.getUTCDate()<t.getUTCDate()||r>0&&e.getUTCDate()>t.getUTCDate()){return"month"}}else if(a==="month"&&n===1){if(r>0&&e.getUTCDate()<t.getUTCDate()||r<0&&e.getUTCDate()>t.getUTCDate()){return"week"}}return a}function M(e,t){var a,r=["FullYear","Month","Date","Hours","Minutes","Seconds","Milliseconds"],n=new Date(e.getTime());for(var i=t;i<r.length;i++){a="setUTC"+r[t];n[a].apply(n,[0])}return n}var P={year:function(e,t){return t.getUTCFullYear()-e.getUTCFullYear()},month:function(e,t){return t.getUTCMonth()-e.getUTCMonth()+this.year(e,t)*12},week:function(e,t,a){var r=a._adaptDayOfWeek(e.getUTCDay());var n=a._adaptDayOfWeek(t.getUTCDay());e=M(e,3);t=M(t,3);return(t.getTime()-e.getTime()-(n-r)*a._mScales.day*1e3)/(a._mScales.week*1e3)},day:function(e,t,a){e=M(e,3);t=M(t,3);return(t.getTime()-e.getTime())/(a._mScales.day*1e3)},hour:function(e,t,a){e=M(e,4);t=M(t,4);return(t.getTime()-e.getTime())/(a._mScales.hour*1e3)},minute:function(e,t,a){e=M(e,5);t=M(t,5);return(t.getTime()-e.getTime())/(a._mScales.minute*1e3)},second:function(e,t,a){e=M(e,6);t=M(t,6);return(t.getTime()-e.getTime())/(a._mScales.second*1e3)}};g.prototype._adaptDayOfWeek=function(e){var t=T(this.oFormatOptions),a;if(typeof t==="object"){a=t.firstDayOfWeek}else{a=f.getWeekConfigurationValues(t,this.oLocale).firstDayOfWeek}var r=e-(a-1);if(r<=0){r+=7}return r};g.prototype._getDifference=function(e,t){var a=t[0];var r=t[1];return Math.round(P[e](a,r,this))};g.prototype.getAllowedCharacters=function(e){if(this.oFormatOptions.relative){return""}var t="";var a=false;var r=false;var n;for(var i=0;i<e.length;i++){n=e[i];switch(n.type){case"text":if(t.indexOf(n.value)<0){t+=n.value}break;case"day":case"year":case"weekYear":case"dayNumberOfWeek":case"weekInYear":case"hour0_23":case"hour1_24":case"hour0_11":case"hour1_12":case"minute":case"second":case"fractionalsecond":if(!a){t+="0123456789";a=true}break;case"month":case"monthStandalone":if(n.digits<3){if(!a){t+="0123456789";a=true}}else{r=true}break;default:r=true;break}}if(r){t=""}return t};g.prototype.getPlaceholderText=function(){var e=o.getLibraryResourceBundle();return e.getText("date.placeholder",[this.format.apply(this,this.getSampleValue())])};g.prototype.getSampleValue=function(){var e,t=d.getInstance().getFullYear(),a=this.oFormatOptions.UTC;function r(e,t,r,n,i,o,s){return a?d.getInstance(Date.UTC(e,t,r,n,i,o,s)):d.getInstance(e,t,r,n,i,o,s)}e=r(t,11,31,23,59,58,123);if(this.type===p.DATETIME_WITH_TIMEZONE){return[e,i.getTimezone()]}if(this.oFormatOptions.interval){return[[r(t,11,22,9,12,34,567),e]]}return[e]};const C=/[\u200e\u200f\u202a\u202b\u202c]/g;const L=/\s/g;g._normalize=function(e){return e.replace(C,"").replace(L," ")};return g},true);
//# sourceMappingURL=DateFormat.js.map