/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/ObjectPath","sap/base/util/extend","sap/ui/base/EventProvider","sap/ui/base/ManagedObject","sap/ui/core/mvc/ControllerMetadata","sap/ui/core/mvc/ControllerExtension","sap/ui/core/mvc/ControllerExtensionProvider","sap/ui/core/mvc/OverrideExecution","sap/ui/util/_enforceNoReturnValue","sap/base/Log"],function(e,t,n,r,o,i,a,s,l,u){"use strict";var f={};var c=n.extend("sap.ui.core.mvc.Controller",{metadata:{stereotype:"controller",methods:{byId:{public:true,final:true},getInterface:{public:false,final:true},getMetadata:{public:true,final:true},getView:{public:true,final:true},isA:{public:true,final:true},onExit:{public:false,final:false,overrideExecution:s.Before},onInit:{public:false,final:false,overrideExecution:s.After},onAfterRendering:{public:false,final:false,overrideExecution:s.After},onBeforeRendering:{public:false,final:false,overrideExecution:s.Before}}},constructor:function(e){var r=null;if(typeof e=="string"){if(!f[e]){u.warning("Do not call sap.ui.core.mvc.Controller constructor for non typed scenario!")}r=f[e]}n.apply(this,arguments);if(r){t(this,f[e])}if(this.extension){throw new Error("The keyword 'extension' cannot be used as a member of a controller")}this["_sapui_Extensions"]={};c.extendByMember(this,false);this._sapui_isExtended=false;this._aDestroyables=[]},_isExtended:function(){return this._sapui_isExtended},getInterface:function(){var e={};var t=this.getMetadata();var n=t._aAllPublicMethods;n.forEach(function(t){var n=this[t];if(typeof n==="function"){e[t]=function(){var e=n.apply(this,arguments);return e instanceof c?e.getInterface():e}.bind(this)}}.bind(this));this.getInterface=function(){return e};return e}},o);function d(t,n,r){var o=n.getMetadata().getName();var a=t.getMetadata();var s=t["_sapui_Extensions"];var l=t.getInterface();var f=i.getMetadata().getLifecycleConfiguration();var c={namespace:o,extension:n,reloadNeeded:false};n._setController(l);if(n.getMetadata().hasOverrides()){var d,p,h,g,v=n.getMetadata().getOverrides(),x=n.getMetadata().getStaticOverrides();for(g in x){h=n.getMetadata();if(!h.isMethodFinal(g)){i.overrideMethod(g,n,x,n,h.getOverrideExecution(g))}else{u.error("[FUTURE FATAL] Method '"+g+"' of extension '"+o+"' is flagged final and cannot be overridden by calling 'override'")}}for(g in v){if(g!=="extension"){if(g in n.base){u.debug("Overriding  member '"+g+"' of original controller.");var y=v[g];var m=t[g];if(typeof m=="object"&&typeof y=="object"){p=s[g];h=p.extension.getMetadata();for(d in y){if(!h.isMethodFinal(d)){i.overrideMethod(d,m,y,n,h.getOverrideExecution(d))}else{u.error("[FUTURE FATAL] Method '"+d+"' of extension '"+p.namespace+"' is flagged final and cannot be overridden by extension '"+o+"'")}}}else if(!a.isMethodFinal(g)){i.overrideMethod(g,t,v,n,a.getOverrideExecution(g))}else{u.error("[FUTURE FATAL] Method '"+g+"' of controller '"+t.getMetadata().getName()+"' is flagged final and cannot be overridden by extension '"+o+"'")}}else if(g in f){i.overrideMethod(g,t,v,n,a.getOverrideExecution(g))}else if(g.startsWith("extHook")&&t[g]===null){i.overrideMethod(g,t,v,n)}else{u.error("[FUTURE FATAL] Method '"+g+"' does not exist in controller "+t.getMetadata().getName()+" and cannot be overridden")}}c.reloadNeeded=true}if(v&&v.extension){for(var E in v.extension){h=s[E].extension.getMetadata();var b=e.create(E,t.extension);var M=s[E].extension;var w=v.extension[E];for(d in w){if(!h.isMethodFinal(d)){i.overrideMethod(d,b,w,n,h.getOverrideExecution(d));i.overrideMethod(d,M,w,n,h.getOverrideExecution(d))}else{u.error("[FUTURE FATAL] Method '"+d+"' of extension '"+E+"' is flagged final and cannot be overridden by extension '"+o+"'")}}}}}var C=n.getInterface();if(r){s[r]=c;c.location=r;t[r]=C;l[r]=C}else{s[o]=c;c.location="extension."+o;e.set("extension."+o,C,t);e.set("extension."+o,C,l)}}function p(e,t,n){if(t instanceof i){d(e,t,n)}else if(t.getMetadata&&t.getMetadata().getStereotype()=="controllerextension"){var r=new t;d(e,r,n)}else{var o=i.getMetadata().getLifecycleConfiguration();for(var a in t){if(a in o){i.overrideMethod(a,e,t,e,o[a].overrideExecution)}else{i.overrideMethod(a,e,t)}}}}function h(t,n){if(!t){throw new Error("Controller name ('sName' parameter) is required")}var r=t.replace(/\./g,"/")+".controller",o=i(sap.ui.require(r));function i(n){if(n){return n}else if(f[t]){return c}else{return e.get(t)}}if(!n){if(!o){o=sap.ui.requireSync(r);return i(o)}else{return o}}return new Promise(function(e,t){if(!o){sap.ui.require([r],function(t){e(i(t))},t)}else{e(o)}})}function g(e,t){var n;if(f[t]){n=new e(t)}else{n=new e}if(!n){throw new Error("Controller "+t+" couldn't be instantiated")}return n}c.extendByMember=function(e,t){var n;for(n in e){if(e[n]&&e[n].getMetadata&&e[n].getMetadata().getStereotype()=="controllerextension"){e[n]=new e[n]}}for(n in e){if(e[n]&&e[n].getMetadata&&e[n].getMetadata().getStereotype()=="controllerextension"){p(e,e[n],n)}}if(t){return Promise.resolve(e)}else{return e}};c.applyExtensions=function(e,t,n,r,o){function i(e,t){if(e){return h(t,true).then(function(e){e=f[t]||e;if(e!==undefined){if(e.getMetadata&&e.getMetadata().isA("sap.ui.core.mvc.Controller")){u.fatal("[FUTURE-FATAL] Attempt to load Extension Controller "+t+" was not successful","Controller extension should be a plain object.",null,function(){return{type:"ControllerExtension",name:t}})}return e}},function(e){u.error("[FUTURE FATAL] Attempt to load Extension Controller "+t+" was not successful - is the Controller correctly defined in its file?")})}else{if(!f[t]&&!sap.ui.require(t)){h(t)}if(f[t]!==undefined){return f[t]}else{u.error("Attempt to load Extension Controller "+t+" was not successful - is the Controller correctly defined in its file?",null,function(){return{type:"ControllerExtension",name:t}});return{}}}}if(o){return a.getControllerExtensions(t,n,r,o).then(function(t){var n=t.customizingControllerNames.map(function(e){return i(true,e)});return Promise.all(n).then(function(n){var r=n.concat(t.providerControllers);for(var o=0,i=r.length;o<i;o++){p(e,r[o])}return e})},function(t){u.error("[FUTURE FATAL] Controller Extension Provider: Error '"+t+"' thrown in "+c._sExtensionProvider+"; extension provider ignored.");return e})}else{var s=a.getControllerExtensions(t,n,r,o);var l=s.customizingControllerNames.map(i.bind(null,false));var d=l.concat(s.providerControllers);for(var g=0,v=d.length;g<v;g++){p(e,d[g])}}return e};c.create=function(e){return v(e.name,undefined,true,e._viewId)};sap.ui.controller=function(e,t,n,r){if(n){u.info("Do not use deprecated factory function 'sap.ui.controller("+e+")'. Use 'sap.ui.core.mvc.Controller.create(...)' instead.","sap.ui.controller",null,function(){return{type:"sap.ui.controller",name:e}})}else{u.warning("Do not use synchronous controller creation for controller '"+e+"'! Use the new asynchronous factory 'sap.ui.core.mvc.Controller.create(...)' instead.","sap.ui.controller",null,function(){return{type:"sap.ui.controller",name:e}})}return v.apply(this,arguments)};function v(e,t,n,o){var i,a,s=r._sOwnerId;if(typeof t==="boolean"){t=undefined}if(!t){if(n){return h(e,n).then(function(t){return g(t,e)}).then(function(t){return c.applyExtensions(t,e,s,o,n)}).then(function(e){e._sapui_isExtended=true;return e})}else{a=h(e,n);i=g(a,e);i=c.applyExtensions(i,e,s,o,n);i._sapui_isExtended=true}return i}else{f[e]=t;u.info("For defining controllers use Controller.extend instead")}}c.prototype.getPublicMethods=function(){var e={},n=this.getMetadata(),r=n.getAllMethods(),o=n.getLifecycleConfiguration();Object.keys(r).forEach(function(t){if(n.isMethodPublic(t)){e[t]=r[t];e[t].reloadNeeded=!!(t in o)}});delete e.extension;var i=this["_sapui_Extensions"];Object.keys(i).forEach(function(n){var r=i[n];var o=r.extension.getInterface();var a=r.extension.getMetadata().getAllMethods();Object.keys(o).forEach(function(n){delete e[r.location];var o=t({},a[n],{reloadNeeded:r.reloadNeeded});e[r.location+"."+n]=o})});return e};c.prototype._getDestroyables=function(){if(!this._aDestroyables){u.error("[FUTURE FATAL] Mandatory super constructor not called for Controller: '"+this.getMetadata().getName()+"'.",null,"sap.ui.support",function(){return{type:"missingSuperConstructor"}});this._aDestroyables=[]}return this._aDestroyables};c.prototype.destroyFragments=function(){function e(e){e=Array.isArray(e)?e:[e];for(var t=0;t<e.length;t++){if(!e[t].isDestroyed()){e[t].destroy()}}}var t=this._getDestroyables();for(var n=0;n<t.length;n++){t[n]=t[n].then(e)}};c.prototype.destroy=function(){if(this["_sapui_Extensions"]){Object.keys(this["_sapui_Extensions"]).forEach(function(t){var n=this["_sapui_Extensions"][t];e.set(n.location,null,this)}.bind(this));delete this["_sapui_Extensions"]}n.prototype.destroy.apply(this,arguments)};c.prototype.getView=function(){return this.oView};c.prototype.byId=function(e){return this.oView?this.oView.byId(e):undefined};c.prototype.createId=function(e){return this.oView?this.oView.createId(e):undefined};c.prototype.getOwnerComponent=function(){var e=sap.ui.require("sap/ui/core/Component");if(e){return e.getOwnerComponentFor(this.getView())}else{return undefined}};c.prototype.connectToView=function(e){this.oView=e;const t=this.oView.getControllerName?.()||"sap.ui.core.mvc.Controller";if(this.onInit){const n=function(){l(this.onInit.apply(this,arguments),{name:"onInit",component:t})};e.attachAfterInit(n,this)}if(this.onExit){const n=function(){l(this.onExit.apply(this,arguments),{name:"onExit",component:t})};e.attachBeforeExit(n,this)}if(e.bControllerIsViewManaged){const n=function(){l(this.destroyFragments.apply(this,arguments),{name:"destroyFragments",component:t})};e.attachBeforeExit(n,this)}if(this.onAfterRendering){const n=function(){l(this.onAfterRendering.apply(this,arguments),{name:"onAfterRendering",component:t})};e.attachAfterRendering(n,this)}if(this.onBeforeRendering){const n=function(){l(this.onBeforeRendering.apply(this,arguments),{name:"onBeforeRendering",component:t})};e.attachBeforeRendering(n,this)}};c.prototype.loadFragment=function(e){if(!this.getView()){throw new Error("Calling 'loadFragment' without a view attached is not supported!")}else if(!e||!e.name){throw new Error("oOptions must provide at least a fragment name!")}var t=this.getOwnerComponent();var n=e.addToDependents!==false;var r=e.autoPrefixId!==false;var o={name:e.name,type:e.type,id:e.id,controller:this};var i=this._getDestroyables();var a=new Promise(function(e,t){sap.ui.require(["sap/ui/core/Fragment"],function(t){e(t)},t)}).then(function(n){if(!e.id&&r){o.id=this.getView().getId()}else if(r){o.id=this.createId(e.id)}if(t){return t.runAsOwner(function(){return n.load(o)})}else{return n.load(o)}}.bind(this)).then(function(e){if(n){this.getView().applySettings({dependents:e})}i.splice(i.indexOf(a),1);return e}.bind(this));i.push(a);return a};c._sExtensionProvider=null;c.registerExtensionProvider=function(e){c._sExtensionProvider=e;a.registerExtensionProvider(e)};return c});
//# sourceMappingURL=Controller.js.map