/*
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/base/util/isEmptyObject","sap/ui/base/ManagedObject","sap/ui/core/util/DraftEnabledMockServer","sap/ui/model/odata/ODataMetadata","sap/ui/thirdparty/jquery","sap/ui/thirdparty/sinon"],function(e,t,r,n,a,jQuery,s){"use strict";var o=r.extend("sap.ui.core.util.MockServer",{constructor:function(e,t){r.apply(this,arguments);o._aServers.push(this)},metadata:{library:"sap.ui.core",properties:{rootUri:"string",recordRequests:{type:"boolean",defaultValue:true},requests:{type:"object[]",defaultValue:[]}}},_oServer:null,_aFilter:null,_oMockdata:null,_oMetadata:null,_sMetadataUrl:null,_sMockdataBaseUrl:null,_mEntitySets:null,_oErrorMessages:{INVALID_SYSTEM_QUERY_OPTION_VALUE:"Invalid system query options value",IS_NOT_A_VALID_SYSTEM_QUERY_OPTION:"## is not a valid system query option",URI_VIOLATING_CONSTRUCTION_RULES:"The URI is violating the construction rules defined in the Data Services specification",UNSUPPORTED_FORMAT_VALUE:"Unsupported format value. Only json format is supported",MALFORMED_SYNTAX:"The Data Services Request could not be understood due to malformed syntax",RESOURCE_NOT_FOUND:"Resource not found",INVALID_SORTORDER_DETECTED:"Invalid sortorder ## detected",PROPERTY_NOT_FOUND:"Property ## not found",INVALID_FILTER_QUERY_STATEMENT:"Invalid filter query statement",INVALID_FILTER_OPERATOR:"Invalid $filter operator ##",RESOURCE_NOT_FOUND_FOR_SEGMENT:"Resource not found for the segment ##",MALFORMED_URI_LITERAL_SYNTAX_IN_KEY:"Malformed URI literal syntax in key ##",INVALID_KEY_NAME:"Invalid key name in key predicate. Expected name is ##",INVALID_KEY_PREDICATE_QUANTITY:"Invalid key predicate. The quantity of provided keys does not match the expected value",INVALID_KEY_TYPE:"Invalid key predicate. The key literal for key property ## does not match its type."},_oRandomSeed:{}});o.prototype._getPseudoRandomNumber=function(e){if(!this._oRandomSeed){this._oRandomSeed={}}if(!this._oRandomSeed.hasOwnProperty(e)){this._oRandomSeed[e]=0}this._oRandomSeed[e]=(this._oRandomSeed[e]+11)*25214903917%0xffffffffffff;return this._oRandomSeed[e]/0xffffffffffff};o.prototype._resetPseudoRandomNumberGenerator=function(){this._oRandomSeed={}};o.prototype.start=function(){this._oServer=o._getInstance();this._aFilters=[];var e=this.getRequests();var t=this;e.forEach(function(e){var r;if(t.getRecordRequests()===false&&e.response){r=function(){e.response.apply(this,arguments);t._oServer.requests=[]}}else{r=e.response}t._addRequestHandler(e.method,e.path,r)})};o.prototype.stop=function(){if(this.isStarted()){this._removeAllRequestHandlers();this._removeAllFilters();this._oServer=null}};o.prototype.attachBefore=function(e,t,r){r=r?r:"";this.attachEvent(e+r+":before",t)};o.prototype.attachAfter=function(e,t,r){r=r?r:"";this.attachEvent(e+r+":after",t)};o.prototype.detachBefore=function(e,t,r){r=r?r:"";this.detachEvent(e+r+":before",t)};o.prototype.detachAfter=function(e,t,r){r=r?r:"";this.detachEvent(e+r+":after",t)};o.prototype.isStarted=function(){return!!this._oServer};o.prototype.getEntitySetData=function(t){var r=this;var n;if(this._oMockdata&&this._oMockdata.hasOwnProperty(t)){n=jQuery.extend(true,[],r._oMockdata[t])}else{e.error("Unrecognized EntitySet name: "+t)}return n};o.prototype.setEntitySetData=function(t,r){if(this._oMockdata&&this._oMockdata.hasOwnProperty(t)){this._oMockdata[t]=r}else{e.error("Unrecognized EntitySet name: "+t)}};o.prototype._applyQueryOnCollection=function(e,t,r,n){var a=t.split("=");var s=a[1];if(s===""){return}if(s.lastIndexOf(",")===s.length-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.URI_VIOLATING_CONSTRUCTION_RULES)}switch(a[0]){case"$top":if(!new RegExp(/^\d+$/).test(s)){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE)}e.results=e.results.slice(0,s);break;case"$skip":if(!new RegExp(/^\d+$/).test(s)){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE)}e.results=e.results.slice(s,e.results.length);break;case"$orderby":e.results=this._getOdataQueryOrderby(e.results,s,r);break;case"$filter":e.results=this._recursiveOdataQueryFilter(e.results,s);break;case"search-focus":break;case"search":var o="";for(var i=0;i<n.length;i++){if(n[i].indexOf("search-focus")!=-1){o=n[i].split("=")[1];break}}e.results=this._recursiveOdataQuerySearch(e.results,s,o,r);break;case"$select":e.results=this._getOdataQuerySelect(e.results,s,r);break;case"$inlinecount":var u=this._getOdataInlineCount(e.results,s);if(u){e.__count=u}break;case"$expand":e.results=this._getOdataQueryExpand(e.results,s,r);break;case"$format":e.results=this._getOdataQueryFormat(e.results,s);break;default:this._logAndThrowMockServerCustomError(400,this._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,a[0])}};o.prototype._applyQueryOnEntry=function(e,t,r){var n=t.split("=");var a=n[1];if(a===""){return}if(a.lastIndexOf(",")===a.length-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.URI_VIOLATING_CONSTRUCTION_RULES)}switch(n[0]){case"$filter":return this._recursiveOdataQueryFilter([e],a)[0];case"$select":return this._getOdataQuerySelect([e],a,r)[0];case"$expand":return this._getOdataQueryExpand([e],a,r)[0];case"$format":return this._getOdataQueryFormat([e],a);default:this._logAndThrowMockServerCustomError(400,this._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,n[0])}};o.prototype._getOdataQueryOrderby=function(e,t,r){var n=t.split(",");var a=this;jQuery.each(n,function(e,t){n[e]=a._trim(t)});var s=function e(t,s){for(var o=0;o<n.length;o++){var i=n[o].split(" ");var u=1;if(i.length>1){switch(i[1]){case"asc":u=1;break;case"desc":u=-1;break;default:a._logAndThrowMockServerCustomError(400,a._oErrorMessages.INVALID_SORTORDER_DETECTED,i[1])}}var f,c;var d=i[0].indexOf("/");if(d!==-1){f=i[0].substring(d+1);c=i[0].substring(0,d);if(!t[c].hasOwnProperty(f)){var p=false;var l=[];if(c){var h=a._mEntitySets[r].navprops[c].to.entitySet;l=a._mEntityTypes[a._mEntitySets[h].type].properties;for(var o=0;o<l.length;o++){if(l[o].name===f){p=true;break}}}if(!p){a._logAndThrowMockServerCustomError(400,a._oErrorMessages.PROPERTY_NOT_FOUND,f)}}if(t[c][f]<s[c][f]){return-1*u}if(t[c][f]>s[c][f]){return 1*u}}else{f=i[0];if(!t.hasOwnProperty(f)){a._logAndThrowMockServerCustomError(400,a._oErrorMessages.PROPERTY_NOT_FOUND,f)}if(t[f]<s[f]){return-1*u}if(t[f]>s[f]){return 1*u}}}return 0};return e.sort(s)};o.prototype._arrayUnique=function(e){var t=e.concat();for(var r=0;r<t.length;++r){for(var n=r+1;n<t.length;++n){if(t[r]===t[n]){t.splice(n--,1)}}}return t};o.prototype._getBracketIndices=function(e){var t=[];var r=0;var n,a=0;for(var s=0;s<e.length;s++){if(e[s]==="("){if(/[substringof|endswith|startswith]$/.test(e.substring(0,s))){++r}else{t.push(e[s]);if(n===undefined){n=s}}}else if(e[s]===")"){if(!r){t.pop();a=s;if(t.length===0){return{start:n,end:a}}}else{--r}}}return{start:n,end:a}};o.prototype._recursiveOdataQueryFilter=function(e,t){var r=this._getBracketIndices(t);if(r.start===0&&r.end===t.length-1){t=this._trim(t.substring(r.start+1,r.end));return this._recursiveOdataQueryFilter(e,t)}var n=/([^substringof|endswith|startswith]|^)\((.*)\)/,a,s;var o;if(n.test(t)){var i=t.substring(r.start,r.end+1);var u=new RegExp("(.*) +(or|and) +("+this._trim(this._escapeStringForRegExp(i))+".*)");if(r.start===0){u=new RegExp("("+this._trim(this._escapeStringForRegExp(i))+") +(or|and) +(.*)")}var f=u.exec(t);if(f===null){return this._getOdataQueryFilter(e,this._trim(t))}var c=f[1];o=f[2];var d=f[3];var p=this._recursiveOdataQueryFilter(e,c);if(o==="or"){a=this._recursiveOdataQueryFilter(e,d);return this._arrayUnique(p.concat(a))}if(o==="and"){return this._recursiveOdataQueryFilter(p,d)}}else{s=t.split(/ +and | or +/);if(s.length===1){return this._getOdataQueryFilter(e,this._trim(t))}var l=this._recursiveOdataQueryFilter(e,s[0]);var h;for(var v=1;v<s.length;v++){h=new RegExp(this._trim(this._escapeStringForRegExp(s[v-1]))+" +(and|or) +"+this._trim(this._escapeStringForRegExp(s[v])));o=h.exec(t)[1];if(o==="or"){a=this._recursiveOdataQueryFilter(e,s[v]);l=this._arrayUnique(l.concat(a))}if(o==="and"){l=this._recursiveOdataQueryFilter(l,s[v])}}return l}};o.prototype._getOdataQueryFilter=function(t,r){if(t.length===0){return t}var n=new RegExp("(.*) (eq|ne|gt|lt|le|ge) (.*)");var a=new RegExp("(endswith|startswith|substringof)\\((.*)");var s=null;var o=n.exec(r);if(o){s=o[2]}else{o=a.exec(r);if(o){s=o[1]}else{this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_FILTER_QUERY_STATEMENT)}}var i=this;var u=function(a,s,o,u){var f,c,d;if(!a){f=n.exec(r);c=i._trim(f[s+1]);d=i._trim(f[o+1])}else{var p=new RegExp("(substringof|startswith|endswith)\\(([^\\)]*),(.*)\\)");f=p.exec(r);c=i._trim(f[s+2]);d=i._trim(f[o+2])}if(/^\(.+\)$/.test(c)){c=c.replace(/^\(|\)$/g,"")}if(c.indexOf("datetime")===0){c=i._getJsonDate(c)}else if(c.indexOf("guid")===0){c=c.substring(5,c.length-1)}else if(c==="true"){c=true}else if(c==="false"){c=false}else if(i._isValidNumber(c)){c=parseFloat(c)}else if(c.charAt(0)==="'"&&c.charAt(c.length-1)==="'"){c=c.substr(1,c.length-2)}var l=d.indexOf("/");if(l!==-1){var h=d.substring(l+1);var v=d.substring(0,l);if(t[0][v]){if(!t[0][v].hasOwnProperty(h)){var _=i._oErrorMessages.PROPERTY_NOT_FOUND.replace("##","'"+h+"'");e.error("MockServer: navigation property '"+v+"' was not expanded, so "+_);return t}}else{i._logAndThrowMockServerCustomError(400,i._oErrorMessages.PROPERTY_NOT_FOUND,d)}return u(d,c,v,h)}else{if(!t[0].hasOwnProperty(d)){i._logAndThrowMockServerCustomError(400,i._oErrorMessages.PROPERTY_NOT_FOUND,d)}return u(d,c)}};switch(s){case"substringof":return u(true,0,1,function(e,r,n,a){return t.filter(function(t){if(n&&a){return typeof t[n][a]==="string"&&t[n][a].indexOf(r)!==-1}return typeof t[e]==="string"&&t[e].indexOf(r)!==-1})});case"startswith":return u(true,1,0,function(e,r,n,a){return t.filter(function(t){if(n&&a){return typeof t[n][a]==="string"&&t[n][a].indexOf(r)===0}return typeof t[e]==="string"&&t[e].indexOf(r)===0})});case"endswith":return u(true,1,0,function(e,r,n,a){return t.filter(function(t){if(n&&a){return typeof t[n][a]==="string"&&t[n][a].indexOf(r)===t[n][a].length-r.length}return typeof t[e]==="string"&&t[e].indexOf(r)===t[e].length-r.length})});case"eq":return u(false,2,0,function(e,r,n,a){return t.filter(function(t){if(n&&a){return t[n][a]===r}return t[e]===r})});case"ne":return u(false,2,0,function(e,r,n,a){return t.filter(function(t){if(n&&a){return t[n][a]!==r}return t[e]!==r})});case"gt":return u(false,2,0,function(e,r,n,a){return t.filter(function(t){if(n&&a){return t[n][a]>r}return t[e]>r})});case"lt":return u(false,2,0,function(e,r,n,a){return t.filter(function(t){if(n&&a){return t[n][a]<r}return t[e]<r})});case"ge":return u(false,2,0,function(e,r,n,a){return t.filter(function(t){if(n&&a){return t[n][a]>=r}return t[e]>=r})});case"le":return u(false,2,0,function(e,r,n,a){return t.filter(function(t){if(n&&a){return t[n][a]<=r}return t[e]<=r})});default:this._logAndThrowMockServerCustomError(400,i._oErrorMessages.INVALID_FILTER_OPERATOR,s)}};o.prototype._recursiveOdataQuerySearch=function(e,t,r,n){var a="";if(r==""||r==undefined){for(var s=0;s<this._mEntitySets[n].keys.length;s++){if(s!=0){a=a+" or "}a=a+"startswith("+this._mEntitySets[n].keys[s]+",'"+t+"')"}}else{a="substringof('"+t+"',"+r+")"}return this._recursiveOdataQueryFilter(e,a)};o.prototype._getOdataQuerySelect=function(e,t,r){var n=this;var a=t.split(",");var s=[];var o=e[0]?e[0][a[0].split("/")[0]]:null;if(!(o!=null&&o.results&&o.results.length>0)){var i=function(e,t,a,s){jQuery.each(e,function(e,o){if(t["__metadata"]){a["__metadata"]=t["__metadata"]}if(o.indexOf("/")>-1){var u=o.split("/");var f=u[0];var c=u.splice(1).join("/");a[f]=a[f]||{};if(t[f]&&t[f].results){var d=a[f].results=a[f].results||[];jQuery.each(t[f].results,function(e,t){d[e]=i([c],t,d[e]||{},f)})}else{a[f]=i([c],t[f],a[f]||{},f)}}else{if(t&&!t.hasOwnProperty(o)){var p=false;var l=[];if(s){var h=n._mEntitySets[r].navprops[s].to.entitySet;l=n._mEntityTypes[n._mEntitySets[h].type].properties;for(var e=0;e<l.length;e++){if(l[e].name===o){p=true;break}}}if(!p){n._logAndThrowMockServerCustomError(404,n._oErrorMessages.RESOURCE_NOT_FOUND_FOR_SEGMENT,o)}}a[o]=t[o]}});return a};if(a.indexOf("*")!==-1){return e}jQuery.each(a,function(e,t){a[e]=n._trim(t)});jQuery.each(e,function(e,t){s.push(i(a,t,{}))})}else{var u=function(e,t,r){var n={};r=r||"";if(typeof e!=="object"){return e}if(typeof e.slice==="function"){return e.map(function(e,n){return u(e,t,r)})}if(e.__metadata!==undefined&&r.length===0){n.__metadata=e.__metadata}t.filter(function(e){return(e+"/").indexOf(r)===0}).forEach(function(t,a,s){var o=t.substr(r.length).split("/")[0];if(e[o]!==undefined){n[o]=u(e[o],s,r+o+"/")}});if(e.results!==undefined){n.results=u(e.results,t,r)}return n};s=u(e,a)}return s};o.prototype._getOdataInlineCount=function(e,t){var r=t.split(",");if(r.length!==1||r[0]!=="none"&&r[0]!=="allpages"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_SYSTEM_QUERY_OPTION_VALUE)}if(r[0]==="none"){return}return e.length};o.prototype._getOdataQueryFormat=function(e,t){if(t!=="json"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.UNSUPPORTED_FORMAT_VALUE)}return e};o.prototype._getOdataQueryExpand=function(e,t,r){var n=this;var a=t.split(",");jQuery.each(a,function(e,t){a[e]=n._trim(t)});var s=n._mEntitySets[r].navprops;jQuery.each(e,function(e,t){jQuery.each(a,function(e,a){var o=a.split("/");var i=o[0];if(!t[i]){n._logAndThrowMockServerCustomError(404,n._oErrorMessages.RESOURCE_NOT_FOUND_FOR_SEGMENT,i)}var u=t[i].results||t[i];if(!u||u.__deferred){u=jQuery.extend(true,[],n._resolveNavigation(r,t,i,t))}else if(!Array.isArray(u)){u=[u]}if(u&&o.length>1){var f=o.splice(1,o.length).join("/");u=n._getOdataQueryExpand(u,f,s[i].to.entitySet)}if(s[i].to.multiplicity==="*"){t[i]={results:u}}else{t[i]=u[0]?u[0]:{}}})});return e};o.prototype._refreshData=function(){var e=this._loadMetadata(this._sMetadataString);if(!e){return}this._mEntitySets=this._findEntitySets(this._oMetadata);this._mEntityTypes=this._findEntityTypes(this._oMetadata);if(!this._sMockdataBaseUrl){this._generateMockdata(this._mEntitySets,this._oMetadata)}else{if(!this._sMockdataBaseUrl.endsWith("/")&&!this._sMockdataBaseUrl.endsWith(".json")){this._sMockdataBaseUrl+="/"}this._loadMockdata(this._mEntitySets,this._sMockdataBaseUrl)}};o.prototype._getRootUri=function(){var e=this.getRootUri();e=e&&/([^?#]*)([?#].*)?/.exec(e)[1];return e};o.prototype._loadMetadata=function(t){var t;t=t.trim();if(t.substring(0,1)!=="<"){t=i({url:t,dataType:"text"}).data;if(!t){e.error('MockServer: The metadata for url "'+t+'" could not be found!')}}this._sMetadata=t;try{this._oMetadata=jQuery.parseXML(t)}catch(t){e.error("MockServer: Invalid metadata XML! Reason: "+t)}return this._oMetadata};o.prototype._findEntitySets=function(e){var t={};var r=jQuery(e).find("Principal");var n=jQuery(e).find("Dependent");jQuery(e).find("EntitySet").each(function(e,r){var n=jQuery(r);var a=/((.*)\.)?(.*)/.exec(n.attr("EntityType"));t[n.attr("Name")]={name:n.attr("Name"),schema:a[2],type:a[3],keys:[],keysType:{},navprops:{},props:{}}});var a=function(e,t,a,s){var o=jQuery(a).find("End[Role='"+e+"']").attr("EntitySet");var i=jQuery(t).find("End[Role='"+e+"']").attr("Multiplicity");var u=[];var f=jQuery(t).find("ReferentialConstraint > [Role='"+e+"']");if(f&&f.length>0){jQuery(f[0]).children("PropertyRef").each(function(e,t){u.push(jQuery(t).attr("Name"))})}else{var c=s?r:n;jQuery(c).each(function(t,r){if(e===jQuery(r).attr("Role")){jQuery(r).children("PropertyRef").each(function(e,t){u.push(jQuery(t).attr("Name"))});return false}})}return{role:e,entitySet:o,propRef:u,multiplicity:i}};jQuery.each(t,function(t,r){var n=jQuery(e).find("EntityType[Name='"+r.type+"']");var s=jQuery(n).find("PropertyRef");jQuery.each(s,function(e,t){var a=jQuery(t).attr("Name");r.keys.push(a);r.keysType[a]=jQuery(n).find("Property[Name='"+a+"']").attr("Type")});var o=jQuery(e).find("EntityType[Name='"+r.type+"'] Property");jQuery.each(o,function(e,t){var n=jQuery(t);r.props[n.attr("Name")]={name:n.attr("Name"),type:n.attr("Type")}});var i=jQuery(e).find("EntityType[Name='"+r.type+"'] NavigationProperty");jQuery.each(i,function(t,n){var s=jQuery(n);var o=s.attr("Relationship").split(".");var i=jQuery(e).find("AssociationSet[Association = '"+o.join(".")+"']");var u=o.pop();var f=jQuery(e).find("Association[Name = '"+u+"']");r.navprops[s.attr("Name")]={name:s.attr("Name"),from:a(s.attr("FromRole"),f,i,true),to:a(s.attr("ToRole"),f,i,false)}})});return t};o.prototype._findEntityTypes=function(e){var t={};jQuery(e).find("EntityType").each(function(e,r){var n=jQuery(r);t[n.attr("Name")]={name:n.attr("Name"),properties:[],keys:[]};n.find("Property").each(function(e,r){var a=jQuery(r);var s=a.attr("Type");t[n.attr("Name")].properties.push({schema:s.substring(0,s.lastIndexOf(".")),type:s.substring(s.lastIndexOf(".")+1),name:a.attr("Name"),precision:a.attr("Precision"),scale:a.attr("Scale")})});n.find("PropertyRef").each(function(e,r){var a=jQuery(r);var s=a.attr("Name");t[n.attr("Name")].keys.push(s)})});return t};o.prototype._findComplexTypes=function(e){var t={};jQuery(e).find("ComplexType").each(function(e,r){var n=jQuery(r);t[n.attr("Name")]={name:n.attr("Name"),properties:[]};n.find("Property").each(function(e,r){var a=jQuery(r);var s=a.attr("Type");t[n.attr("Name")].properties.push({schema:s.substring(0,s.lastIndexOf(".")),type:s.substring(s.lastIndexOf(".")+1),name:a.attr("Name"),precision:a.attr("Precision"),scale:a.attr("Scale")})})});return t};o.prototype._createKeysString=function(e,t){var r=this;var n="";if(t){jQuery.each(e.keys,function(a,s){if(n){n+=","}var o=t[s];if(e.keysType[s]==="Edm.String"){o=encodeURIComponent("'"+o+"'")}else if(e.keysType[s]==="Edm.DateTime"){o=r._getDateTime(o);o=encodeURIComponent(o)}else if(e.keysType[s]==="Edm.Guid"){o="guid'"+o+"'"}if(e.keys.length===1){n+=o;return n}n+=s+"="+o})}return n};o.prototype._loadMockdata=function(t,r){var n=this,a={};this._oMockdata={};var s=function(t,r){var n=i({url:t,dataType:"json"});if(n.success){if(n.data.d){if(n.data.d.results){a[r.name]=n.data.d.results}else{e.error('The mock data format for entity set "'+r.name+'" invalid')}}else{if(Array.isArray(n.data)){a[r.name]=n.data}else{e.error('The mock data for entity set "'+r.name+'" could not be loaded due to wrong format!');return false}}return true}else{if(n.status==="parsererror"){e.error('The mock data for entity set "'+r.name+'" could not be loaded due to a parsing error!')}return false}};if(r.endsWith(".json")){var o=i({url:r,dataType:"json"});if(o.success){a=o.data}else{e.warning('The mock data for all the entity types could not be found at "'+r+'"!')}}else{var u={};if(n._aEntitySetsNames&&n._aEntitySetsNames.length>0){var f;for(var c=0;c<n._aEntitySetsNames.length;c++){f=n._aEntitySetsNames[c];if(t[f]){u[f]=t[f]}}}else{u=t}jQuery.each(u,function(t,o){if(!a[o.type]||!a[o.name]){var i=r+o.name+".json";if(!s(i,o)){e.warning('The mock data for entity set "'+o.name+'" could not be found at "'+r+'"!');var u=r+o.type+".json";if(!s(u,o)){e.warning('The mock data for entity type "'+o.type+'" could not be found at "'+r+'"!');if(n._bGenerateMissingMockData){var f={};f[o.name]=o;a[o.type]=n._generateODataMockdataForEntitySet(f,n._oMetadata)[o.name]}}}}})}jQuery.each(t,function(e,t){n._oMockdata[e]=[];if(a[t.name]){jQuery.each(a[t.name],function(t,r){n._oMockdata[e].push(jQuery.extend(true,{},r))})}else if(a[t.type]){jQuery.each(a[t.type],function(t,r){n._oMockdata[e].push(jQuery.extend(true,{},r))})}});jQuery.each(t,function(e,t){if(n._oMockdata[e].length>0){n._enhanceWithMetadata(t,n._oMockdata[e]);n._oMockdata[e].forEach(function(e){Object.keys(t.props).forEach(function(r){switch(t.props[r].type){case"Edm.DateTime":case"Edm.DateTimeOffset":if(e[r]!=null){var n=new Date(e[r]);if(n&&!isNaN(n)){e[r]="/Date("+n.getTime()+")/"}}break;default:}})})}});return this._oMockdata};o.prototype._enhanceWithMetadata=function(e,r){if(r){var n=this,a=this._getRootUri(),s=e&&e.name;jQuery.each(r,function(r,o){o.__metadata=o.__metadata||{};o.__metadata.id=a+s+"("+n._createKeysString(e,o)+")";o.__metadata.type=e.schema+"."+e.type;o.__metadata.uri=a+s+"("+n._createKeysString(e,o)+")";jQuery.each(e.navprops,function(r,i){if(o[r]&&!t(o[r])&&!o[r]["__deferred"]){n._oMockdata[i.to.entitySet]=n._oMockdata[i.to.entitySet].concat(o[r])}o[r]={__deferred:{uri:a+s+"("+n._createKeysString(e,o)+")/"+r}}})})}};o.prototype._isRequestedKeysValid=function(e,t){if(t.length===1){var r=t[0].split("=");if(this._trim(r[0])!==e.keys[0]){t=[e.keys[0]+"="+t[0]]}}for(var n=0;n<t.length;n++){var a=this._trim(t[n].substring(0,t[n].indexOf("=")));var s=this._trim(t[n].substring(t[n].indexOf("=")+1));var o=s.charAt(0);var i=s.charAt(s.length-1);if(e.keysType[a]==="Edm.String"){if(o!=="'"||i!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,a)}}else if(e.keysType[a]==="Edm.DateTime"){if(o==="'"||i!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,a)}}else if(e.keysType[a]==="Edm.Guid"){if(o==="'"||i!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,a)}}else if(e.keysType[a]==="Edm.Binary"){if(!new RegExp("(binary|X)'[A-Fa-f0-9][A-Fa-f0-9]*'").test(s)){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,a)}}else{if(o==="'"&&i!=="'"||i==="'"&&o!=="'"){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.MALFORMED_URI_LITERAL_SYNTAX_IN_KEY,a)}}var u=e.keys.join(",");if(e.keys.indexOf(a)===-1){this._logAndThrowMockServerCustomError(400,this._oErrorMessages.INVALID_KEY_NAME,u)}}};o.prototype._parseKeys=function(e,t){var r={};var n=e.split(",");var a,s,o;for(var i=0;i<n.length;i++){o=n[i].split("=");if(o.length===1&&t.keys.length===1){a=t.keys[0];s=o[0]}else{if(o.length===2){a=o[0];s=o[1]}}r[a]=s;switch(t.keysType[a]){case"Edm.String":r[a]=r[a].replace(/^\'|\'$/g,"");break;case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":r[a]=parseFloat(r[a]);break;case"Edm.Guid":r[a]=r[a].replace(/^guid\'|\'$/g,"");break;case"Edm.Boolean":case"Edm.Binary":case"Edm.DateTimeOffset":default:}}return r};o.prototype._generatePropertyValue=function(e,t,r,n){var a=n;if(!a){a=Math.floor(this._getPseudoRandomNumber("String")*1e4)+101}switch(t){case"String":return e+" "+a;case"DateTime":var s=new Date;s.setFullYear(2e3+Math.floor(this._getPseudoRandomNumber("DateTime")*20));s.setDate(Math.floor(this._getPseudoRandomNumber("DateTime")*30));s.setMonth(Math.floor(this._getPseudoRandomNumber("DateTime")*12));s.setMilliseconds(0);return"/Date("+s.getTime()+")/";case"Int16":case"Int32":case"Int64":return Math.floor(this._getPseudoRandomNumber("Int")*1e4);case"Decimal":return Math.floor(this._getPseudoRandomNumber("Decimal")*1e6)/100;case"Boolean":return this._getPseudoRandomNumber("Boolean")<.5;case"Byte":return Math.floor(this._getPseudoRandomNumber("Byte")*10);case"Double":return this._getPseudoRandomNumber("Double")*10;case"Single":return this._getPseudoRandomNumber("Single")*1e9;case"SByte":return Math.floor(this._getPseudoRandomNumber("SByte")*10);case"Time":return"PT"+Math.floor(this._getPseudoRandomNumber("Time")*23)+"H"+Math.floor(this._getPseudoRandomNumber("Time")*59)+"M"+Math.floor(this._getPseudoRandomNumber("Time")*59)+"S";case"Guid":return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){var t=this._getPseudoRandomNumber("Guid")*16|0,r=e==="x"?t:t&3|8;return r.toString(16)}.bind(this));case"Binary":var o=Math.floor(-2147483648+this._getPseudoRandomNumber("Binary")*4294967295),i="";for(var u=0,f=o;u<32;u++,i+=String(f>>>31),f<<=1);return i;case"DateTimeOffset":var s=new Date;s.setFullYear(2e3+Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*20));s.setDate(Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*30));s.setMonth(Math.floor(this._getPseudoRandomNumber("DateTimeOffset")*12));s.setMilliseconds(0);return"/Date("+s.getTime()+"+0000)/";default:return this._generateDataFromEntity(r[t],a,r)}};o.prototype._isFalseyValue=function(e,t,r){switch(r){case"Edm.String":return e==="";case"Edm.Boolean":return e===false;case"Edm.Int16":case"Edm.Int32":case"Edm.Int64":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":return e===0||isNaN(e);default:return false}};o.prototype._completeKey=function(e,t,r){if(r){for(var n=0;n<e.keys.length;n++){var a=e.keys[n];if(t[a]!==undefined&&t[a]!==null){if(!r[a]){switch(e.keysType[a]){case"Edm.DateTime":r[a]=this._getJsonDate(t[a]);break;case"Edm.Guid":r[a]=t[a].replace(/^guid\'|\'$/g,"");break;default:r[a]=t[a]}}}else{if(!r[a]){r[a]=this._generatePropertyValue(a,e.keysType[a].substring(e.keysType[a].lastIndexOf(".")+1))}}}}};o.prototype._generateDataFromEntity=function(e,t,r){var n={};if(!e){return n}for(var a=0;a<e.properties.length;a++){var s=e.properties[a];n[s.name]=this._generatePropertyValue(s.name,s.type,r,t)}return n};o.prototype._generateDataFromEntitySet=function(e,t,r){var n=t[e.type];var a=[];for(var s=0;s<100;s++){a.push(this._generateDataFromEntity(n,s+1,r))}return a};o.prototype._generateMockdata=function(e,t){var r=this;var n={};var a=this._getRootUri();jQuery.each(e,function(e,a){var s={};s[a.name]=a;n[e]=r._generateODataMockdataForEntitySet(s,t)[e]});jQuery.each(e,function(e,t){for(var s in t.navprops){var o=t.navprops[s];var i=o.from.propRef.length;for(var u=0;u<i;u++){for(var f=0;f<n[e].length;f++){var c=n[e][f];n[o.to.entitySet][f][o.to.propRef[u]]=c[o.from.propRef[u]]}}}jQuery.each(n[e],function(n,s){s.__metadata={uri:a+e+"("+r._createKeysString(t,s)+")",type:t.schema+"."+t.type};jQuery.each(t.navprops,function(n,o){s[n]={__deferred:{uri:a+e+"("+r._createKeysString(t,s)+")/"+n}}})})});this._oMockdata=n};o.prototype._generateODataMockdataForEntitySet=function(e,t){var r=this,n={};var a=this._findEntityTypes(t);var s=this._findComplexTypes(t);jQuery.each(e,function(e,t){n[e]=r._generateDataFromEntitySet(t,a,s)});return n};o.prototype._resolveNavigation=function(e,t,r){var n=this._mEntitySets[e];var a=n.navprops[r];if(!a){this._logAndThrowMockServerCustomError(404,this._oErrorMessages.RESOURCE_NOT_FOUND)}var s=[];var o=a.from.propRef.length;if(o===0){if(a.to.multiplicity==="*"){return this._oMockdata[a.to.entitySet]}else{s.push(this._oMockdata[a.to.entitySet][0]);return s}}jQuery.each(this._oMockdata[a.to.entitySet],function(e,r){var n=true;for(var i=0;i<o;i++){if(t[a.from.propRef[i]]!==r[a.to.propRef[i]]){n=false;break}}if(n){s.push(r)}});return s};o.prototype.simulate=function(r,s){var i=this;this._sMetadataString=r;if(!s||typeof s==="string"){this._sMockdataBaseUrl=s}else{this._sMockdataBaseUrl=s.sMockdataBaseUrl;this._bGenerateMissingMockData=s.bGenerateMissingMockData;this._aEntitySetsNames=s.aEntitySetsNames}var u=this._loadMetadata(this._sMetadataString);if(!u){return}if(this._sMetadata){var f=a.getServiceAnnotations(this._sMetadata);n.handleDraft(f,this)}this._resetPseudoRandomNumberGenerator();this._refreshData();var c=function(e,t){if(e.requestHeaders["x-csrf-token"]==="Fetch"||e.requestHeaders["X-CSRF-Token"]==="Fetch"){t["X-CSRF-Token"]="42424242424242424242424242424242"}};var d=function(e,t){t=decodeURIComponent(t);var r;var n=i._mEntitySets[e];var a=n.keys;var s=t.split(",");if(s.length!==a.length){i._logAndThrowMockServerCustomError(400,i._oErrorMessages.INVALID_KEY_PREDICATE_QUANTITY)}i._isRequestedKeysValid(n,s);if(s.length===1&&!s[0].split("=")[1]){s=[a[0]+"="+s[0]]}jQuery.each(i._oMockdata[e],function(e,t){for(var o=0;o<s.length;o++){var u=s[o].split("=");var f=i._trim(u[0]);if(!a||a.indexOf(f)===-1){return true}var c=i._trim(u[1]);var d=t[f];switch(n.keysType[f]){case"Edm.String":c=c.replace(/^\'|\'$/g,"");break;case"Edm.Time":case"Edm.DateTime":d=i._getDateTime(d);break;case"Edm.Int16":case"Edm.Int32":case"Edm.Decimal":case"Edm.Byte":case"Edm.Double":case"Edm.Single":case"Edm.SByte":if(!i._isValidNumber(c)){return false}c=parseFloat(c);break;case"Edm.Guid":c=c.replace(/^guid\'|\'$/g,"");break;case"Edm.Boolean":if(["true","false"].indexOf(c)===-1){i._logAndThrowMockServerCustomError(400,i._oErrorMessages.INVALID_KEY_TYPE,f)}c=c==="true";break;case"Edm.Binary":case"Edm.DateTimeOffset":default:}if(d!==c){return true}}r={index:e,entry:t};return false});return r};var p=function(e,t,r){var n=e.name;var a;if(r){a=e.navprops[r]}if(a){n=a.to.entitySet}return n};var l=function(e){var t=[];var r=function(e){var t=e.indexOf("'");var r=e.indexOf('"');if(t===-1&&r===-1){return null}else{if(t>-1&&r===-1){return"appost"}if(r>-1&&t===-1){return"doublequotes"}if(t>-1&&r>-1&&t<r){return"appost"}if(t>-1&&r>-1&&r<t){return"doublequotes"}}};var n=function(e,t,r,n){var a=e[r];var s=r+1;while(s<e.length&&e[s].indexOf(n)===-1){a=a+"&"+e[s];s++}a=a+"&"+e[s];t.push(a);r=s;return r};for(var a=0;a<e.length;a++){if(!r(e[a])){t.push(e[a])}if(r(e[a])==="appost"){var s=e[a].indexOf("'");if(e[a].indexOf("'",s+1)===-1){a=n(e,t,a,"'")}else{t.push(e[a])}}if(r(e[a])==="doublequotes"){var o=e[a].indexOf('"');if(e[a].indexOf('"',o+1)===-1){a=n(e,t,a,'"')}else{t.push(e[a])}}}return t};var h=function(e,t,r,n){r=r?decodeURIComponent(r):r;var a=JSON.parse(e.requestBody);if(a){var s={};if(r){s=i._parseKeys(r,i._mEntitySets[t])}i._completeKey(i._mEntitySets[t],s,a);i._enhanceWithMetadata(i._mEntitySets[t],[a]);return a}return null};var v=[];v.push({method:"GET",path:new RegExp("\\$metadata([?#].*)?"),response:function(t){e.debug("MockServer: incoming request for url: "+t.url);var r={"Content-Type":"application/xml;charset=utf-8"};c(t,r);t.respond(200,r,i._sMetadata);e.debug("MockServer: response sent with: 200, "+i._sMetadata);return true}});v.push({method:"HEAD",path:new RegExp("$"),response:function(t){e.debug("MockServer: incoming request for url: "+t.url);var r={"Content-Type":"application/json;charset=utf-8"};c(t,r);t.respond(200,r);e.debug("MockServer: response sent with: 200");return true}});v.push({method:"GET",path:new RegExp("$"),response:function(t){e.debug("MockServer: incoming request for url: "+t.url);var r={"Content-Type":"application/json;charset=utf-8"};c(t,r);var n=[];jQuery.each(i._mEntitySets,function(e,t){n.push(e)});var a={EntitySets:n};t.respond(200,r,JSON.stringify({d:a}));e.debug("MockServer: response sent with: 200, "+JSON.stringify({d:a}));return true}});v.push({method:"POST",path:new RegExp("\\$batch([?#].*)?"),response:function(t){e.debug("MockServer: incoming request for url: "+t.url);var r=function(e){switch(e.statusCode){case 200:return"200 OK";case 201:return"201 Created";case 204:return"204 No Content";case 400:return"400 Bad Request";case 401:return"401 Unauthorized";case 403:return"403 Forbidden";case 404:return"404 Not Found";case 405:return"405 Method Not Allowed";case 409:return"409 Conflict";case 412:return"412 Precondition Failed";case 415:return"415 Unsupported Media Type";case 500:return"500 Internal Server Error";case 501:return"501 Not Implemented";case 503:return"503 Service Unavailable";default:return e.statusCode+" "+e.status}};var n=function(e,t){var n;if(e.success){n=JSON.stringify(e.data)||""}else{n=e.errorResponse}t=t||"application/json";if(e.responseHeaders){return"HTTP/1.1 "+r(e)+"\r\n"+e.responseHeaders+"dataserviceversion: 2.0\r\n\r\n"+n+"\r\n"}else{return"HTTP/1.1 "+r(e)+"\r\nContent-Type: "+t+"\r\nContent-Length: "+n.length+"\r\ndataserviceversion: 2.0\r\n\r\n"+n+"\r\n"}};var a=function(e,t,r,a,s){var o;var i=function(e,t,r){o={success:true,data:e,status:t,statusCode:r&&r.status,responseHeaders:r&&r.getAllResponseHeaders()}};var u=function(e,t,r){o={success:false,data:undefined,status:t,error:r,statusCode:e.status,errorResponse:e.responseText,responseHeaders:e&&e.getAllResponseHeaders()}};jQuery.ajax({type:r,async:false,url:e,headers:s,data:t,dataType:"json",success:i,error:u});if(o.statusCode===400||o.statusCode===404){var f=n(o);throw new Error(f)}a.push(n(o))};var s=function(e,t){var r;var a;var s=function(e,t,n){r={success:true,data:e,status:t,statusCode:n&&n.status,responseHeaders:n&&n.getAllResponseHeaders()}};var o=function(e,t,n){r={success:false,data:undefined,status:t,error:n,statusCode:e.status,errorResponse:e.responseText,responseHeaders:e&&e.getAllResponseHeaders()}};jQuery.ajax({async:false,url:e,dataType:"json",success:s,error:o});var a;if(e.indexOf("$count")!==-1){a=n(r,"text/plain")}else{a=n(r)}t.push("\r\nContent-Type: application/http\r\n"+"Content-Length: "+a.length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+a)};var o=function(e){var t={};e.split("HTTP/1.1")[1].split("{")[0].split("\n").forEach(function(e){if(e.indexOf(":")!==-1){var r=e.split(":");t[r[0].trim()]=r[1].trim()}});delete t["Content-Length"];return t};var u=t.requestBody;var f=new RegExp("--batch_[a-z0-9-]*");var d=f.exec(u)[0];if(d){var p=[];var l=u.split(d);var h=t.url.split("$")[0];var v=new RegExp("PUT (.*) HTTP");var _=new RegExp("MERGE (.*) HTTP");var E=new RegExp("POST (.*) HTTP");var y=new RegExp("DELETE (.*) HTTP");var g=new RegExp("GET (.*) HTTP");for(var m=1;m<l.length-1;m++){var T=l[m];if(g.test(T)&&T.indexOf("multipart/mixed")===-1){if(v.test(T)||E.test(T)||y.test(T)){t.respond(400,null,"The Data Services Request could not be understood due to malformed syntax");e.debug("MockServer: response sent with: 400");return true}s(h+g.exec(T)[1],p)}else{var S=jQuery.extend(true,{},i._oMockdata);var M=[];var O=T.substring(T.indexOf("boundary=")+9,T.indexOf("\r\n\r\n"));var R=T.split("--"+O);try{for(var k=1;k<R.length-1;k++){var b=R[k];var N;if(g.test(b)){i._oMockdata=S;t.respond(400,null,"The Data Services Request could not be understood due to malformed syntax");e.debug("MockServer: response sent with: 400");return}else{var N=b.substring(b.indexOf("{"),b.lastIndexOf("}")+1),x=o(b),D,P;if(v.test(b)){P="PUT";D=v.exec(b)[1]}else if(_.test(b)){P="MERGE";D=_.exec(b)[1]}else if(E.test(b)){P="POST";D=E.exec(b)[1]}else if(y.test(b)){P="DELETE";N=undefined;D=y.exec(b)[1]}a(h+D,N,P,M,x)}}var I="\r\nContent-Type: multipart/mixed; boundary=ejjeeffe1\r\n\r\n--ejjeeffe1";for(var w=0;w<M.length;w++){I+="\r\nContent-Type: application/http\r\n"+"Content-Length: "+M[w].length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+M[w]+"--ejjeeffe1"}I+="--\r\n";p.push(I)}catch(e){i._oMockdata=S;var A="\r\nContent-Type: application/http\r\n"+"Content-Length: "+e.message.length+"\r\n"+"content-transfer-encoding: binary\r\n\r\n"+e.message;p.push(A)}}}var C="--ejjeeffe0";for(var H=0;H<p.length;H++){C+=p[H]+"--ejjeeffe0"}C+="--";var x={"Content-Type":"multipart/mixed; boundary=ejjeeffe0"};c(t,x);t.respond(202,x,C);e.debug("MockServer: response sent with: 202, "+C)}else{t.respond(202)}return true}});jQuery.each(this._mEntitySets,function(r,n){v.push({method:"GET",path:new RegExp("("+r+")/\\$count/?(.*)?"),response:function(t,r,n){e.debug("MockServer: incoming request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.GET+r+":before",{oXhr:t,sUrlParams:n});i.fireEvent(o.HTTPMETHOD.GET+":before",{oXhr:t,sUrlParams:n});var a={"Content-Type":"text/plain;charset=utf-8"};c(t,a);try{var s=i._oMockdata[r];if(s){var u={results:jQuery.extend(true,[],s)};if(n){var f=decodeURIComponent(n).replace("?","&").split("&");f=l(f);if(f.length>1){f=i._orderQueryOptions(f)}jQuery.each(f,function(e,t){i._applyQueryOnCollection(u,t,r,f)})}i.fireEvent(o.HTTPMETHOD.GET+r+":after",{oXhr:t,oFilteredData:u});i.fireEvent(o.HTTPMETHOD.GET+":after",{oXhr:t,oFilteredData:u});t.respond(200,a,""+u.results.length);e.debug("MockServer: response sent with: 200, "+u.results.length)}else{i._logAndThrowMockServerCustomError(404,i._oErrorMessages.RESOURCE_NOT_FOUND)}}catch(r){if(r.error){t.respond(r.error.code,a,JSON.stringify(r))}else{e.error("MockServer: request failed due to invalid system query options value!");t.respond(parseInt(r.message||r.number))}}return true}});v.push({method:"GET",path:new RegExp("("+r+")/?(\\?(.*))?"),response:function(t,r,n){e.debug("MockServer: incoming request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.GET+r+":before",{oXhr:t,sUrlParams:n});i.fireEvent(o.HTTPMETHOD.GET+":before",{oXhr:t,sUrlParams:n});var a={"Content-Type":"application/json;charset=utf-8"};c(t,a);try{var s=i._oMockdata[r];if(s){var u={results:jQuery.extend(true,[],s)};if(n){var f=decodeURIComponent(n).replace("?","&").split("&");f=l(f);if(f.length>1){f=i._orderQueryOptions(f)}jQuery.each(f,function(e,t){i._applyQueryOnCollection(u,t,r,f)})}i.fireEvent(o.HTTPMETHOD.GET+r+":after",{oXhr:t,oFilteredData:u});i.fireEvent(o.HTTPMETHOD.GET+":after",{oXhr:t,oFilteredData:u});t.respond(200,a,JSON.stringify({d:u}));e.debug("MockServer: response sent with: 200, "+JSON.stringify({d:u}))}else{i._logAndThrowMockServerCustomError(404,i._oErrorMessages.RESOURCE_NOT_FOUND)}}catch(r){if(r.error){t.respond(r.error.code,a,JSON.stringify(r))}else{e.debug("MockServer: response sent with: "+parseInt(r.message||r.number));t.respond(parseInt(r.message||r.number))}}return true}});v.push({method:"GET",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/?(\\?(.*))?"),response:function(r,n,a,s){e.debug("MockServer: incoming request for url: "+r.url);i.fireEvent(o.HTTPMETHOD.GET+n+":before",{oXhr:r,sKeys:a,sUrlParams:s});i.fireEvent(o.HTTPMETHOD.GET+":before",{oXhr:r,sKeys:a,sUrlParams:s});var u={"Content-Type":"application/json;charset=utf-8"};try{var f=jQuery.extend(true,{},d(n,a));if(!t(f)){if(s){var c=decodeURIComponent(s).replace("?","&").split("&");c=l(c);if(c.length>1){c=i._orderQueryOptions(c)}jQuery.each(c,function(e,t){f.entry=i._applyQueryOnEntry(f.entry,t,n)})}i.fireEvent(o.HTTPMETHOD.GET+n+":after",{oXhr:r,oEntry:f.entry});i.fireEvent(o.HTTPMETHOD.GET+":after",{oXhr:r,oEntry:f.entry});r.respond(200,u,JSON.stringify({d:f.entry}));e.debug("MockServer: response sent with: 200, "+JSON.stringify({d:f.entry}))}else{i._logAndThrowMockServerCustomError(404,i._oErrorMessages.RESOURCE_NOT_FOUND)}}catch(t){if(t.error){r.respond(t.error.code,u,JSON.stringify(t))}else{e.debug("MockServer: response sent with: "+parseInt(t.message||t.number));r.respond(parseInt(t.message||t.number))}}return true}});jQuery.each(n.navprops,function(t,n){v.push({method:"GET",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/("+t+")/\\$count/?(.*)?"),response:function(t,r,n,a,s){e.debug("MockServer: incoming request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.GET+r+":before",{oXhr:t,sKeys:n,sNavProp:a,sUrlParams:s});i.fireEvent(o.HTTPMETHOD.GET+":before",{oXhr:t,sKeys:n,sNavProp:a,sUrlParams:s});var u={"Content-Type":"text/plain;charset=utf-8"};c(t,u);try{var f=d(r,n);if(f){var p,h={};p=i._resolveNavigation(r,f.entry,a);var v=i._mEntitySets[r].navprops[a].to.multiplicity;if(v==="*"){h={results:jQuery.extend(true,[],p)}}else{h=jQuery.extend(true,{},p[0])}if(p&&p.length!==0){if(s){var _=decodeURIComponent(s).replace("?","&").split("&");_=l(_);if(_.length>1){_=i._orderQueryOptions(_)}if(v==="*"){jQuery.each(_,function(e,t){i._applyQueryOnCollection(h,t,i._mEntitySets[r].navprops[a].to.entitySet,_)})}else{jQuery.each(_,function(e,t){h=i._applyQueryOnEntry(h,t,i._mEntitySets[r].navprops[a].to.entitySet)})}}}i.fireEvent(o.HTTPMETHOD.GET+r+":after",{oXhr:t,oFilteredData:h});i.fireEvent(o.HTTPMETHOD.GET+":after",{oXhr:t,oFilteredData:h});h.results=h.results||[];t.respond(200,u,""+h.results.length);e.debug("MockServer: response sent with: 200, "+h.results.length)}else{i._logAndThrowMockServerCustomError(404,i._oErrorMessages.RESOURCE_NOT_FOUND)}}catch(r){if(r.error){t.respond(r.error.code,u,JSON.stringify(r))}else{e.debug("MockServer: response sent with: "+parseInt(r.message||r.number));t.respond(parseInt(r.message||r.number))}}return true}});v.push({method:"GET",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/("+t+")/?(\\?(.*))?"),response:function(t,r,n,a,s){e.debug("MockServer: incoming request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.GET+r+":before",{oXhr:t,sKeys:n,sNavProp:a,sUrlParams:s});i.fireEvent(o.HTTPMETHOD.GET+":before",{oXhr:t,sKeys:n,sNavProp:a,sUrlParams:s});var u={"Content-Type":"application/json;charset=utf-8"};c(t,u);try{var f=d(r,n);if(f){var p,h={};p=i._resolveNavigation(r,f.entry,a,f.entry);var v=i._mEntitySets[r].navprops[a].to.multiplicity;if(v==="*"){h={results:jQuery.extend(true,[],p)}}else{h=jQuery.extend(true,{},p[0])}if(p&&p.length!==0){if(s){var _=decodeURIComponent(s).replace("?","&").split("&");_=l(_);if(_.length>1){_=i._orderQueryOptions(_)}if(v==="*"){jQuery.each(_,function(e,t){i._applyQueryOnCollection(h,t,i._mEntitySets[r].navprops[a].to.entitySet,_)})}else{jQuery.each(_,function(e,t){h=i._applyQueryOnEntry(h,t,i._mEntitySets[r].navprops[a].to.entitySet)})}}}i.fireEvent(o.HTTPMETHOD.GET+r+":after",{oXhr:t,oFilteredData:h});i.fireEvent(o.HTTPMETHOD.GET+":after",{oXhr:t,oFilteredData:h});t.respond(200,u,JSON.stringify({d:h}));e.debug("MockServer: response sent with: 200, "+JSON.stringify({d:h}))}else{i._logAndThrowMockServerCustomError(404,i._oErrorMessages.RESOURCE_NOT_FOUND)}}catch(r){if(r.error){t.respond(r.error.code,u,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}})});v.push({method:"POST",path:new RegExp("("+r+")(\\(([^/\\?#]+)\\)/?(.*)?)?"),response:function(t,r,a,s,u){var f=false;if(t.requestHeaders["x-http-method"]==="MERGE"){f=true}e.debug("MockServer: incoming create request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.POST+r+":before",{oXhr:t,sKeys:s,sNavName:u});i.fireEvent(o.HTTPMETHOD.POST+":before",{oXhr:t,sKeys:s,sNavName:u});var c=null;var l=null;var v=405;try{if(s&&!s.split("=")[1]){s=i._mEntitySets[r].keys[0]+"="+s}var _=p(n,decodeURIComponent(s),u);if(_){var E=h(t,_,s,u);if(E){l={"Content-Type":"application/json;charset=utf-8"};i.fireEvent(o.HTTPMETHOD.POST+r+":after",{oXhr:t,oEntity:E});i.fireEvent(o.HTTPMETHOD.POST+":after",{oXhr:t,oEntity:E});if(f){var y=d(r,s);if(y){jQuery.extend(i._oMockdata[r][y.index],E)}v=204}else{var g=i._getRootUri()+_+"("+i._createKeysString(i._mEntitySets[_],E)+")";c=JSON.stringify({d:E,uri:g});i._oMockdata[_]=i._oMockdata[_].concat([E]);v=201}}}t.respond(v,l,c);e.debug("MockServer: response sent with: "+v+", "+c)}catch(r){if(r.error){var m={"Content-Type":"text/plain;charset=utf-8"};t.respond(r.error.code,m,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}});v.push({method:"PUT",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(t,r,a,s){e.debug("MockServer: incoming update request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.PUT+r+":before",{oXhr:t,sKeys:a,sNavName:s});i.fireEvent(o.HTTPMETHOD.PUT+":before",{oXhr:t,sKeys:a,sNavName:s});var u=405;var f=null;var c=null;try{var l=p(n,decodeURIComponent(a),s);if(l){var v=h(t,l,a,s);if(v){c={"Content-Type":"application/json;charset=utf-8"};i.fireEvent(o.HTTPMETHOD.PUT+r+":after",{oXhr:t,oEntity:v});i.fireEvent(o.HTTPMETHOD.PUT+":after",{oXhr:t,oEntity:v});var _=d(r,a);if(_){i._oMockdata[r][_.index]=v}u=204}}t.respond(u,c,f);e.debug("MockServer: response sent with: "+u+", "+f)}catch(r){if(r.error){var E={"Content-Type":"text/plain;charset=utf-8"};t.respond(r.error.code,E,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}});v.push({method:"MERGE",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(t,r,a,s){e.debug("MockServer: incoming merge update request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.MERGE+r+":before",{oXhr:t,sKeys:a,sNavName:s});i.fireEvent(o.HTTPMETHOD.MERGE+":before",{oXhr:t,sKeys:a,sNavName:s});var u=405;var f=null;var c=null;try{var l=p(n,decodeURIComponent(a),s);if(l){var v=h(t,l,a,s);if(v){c={"Content-Type":"application/json;charset=utf-8"};i.fireEvent(o.HTTPMETHOD.MERGE+r+":after",{oXhr:t,oEntity:v});i.fireEvent(o.HTTPMETHOD.MERGE+":after",{oXhr:t,oEntity:v});var _=d(r,a);if(_){jQuery.extend(i._oMockdata[r][_.index],v)}u=204}}t.respond(u,c,f);e.debug("MockServer: response sent with: "+u+", "+f)}catch(r){if(r.error){var E={"Content-Type":"text/plain;charset=utf-8"};t.respond(r.error.code,E,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}});v.push({method:"PATCH",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(t,r,a,s){e.debug("MockServer: incoming patch update request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.PATCH+r+":before",{oXhr:t,sKeys:a,sNavName:s});i.fireEvent(o.HTTPMETHOD.PATCH+":before",{oXhr:t,sKeys:a,sNavName:s});var u=405;var f=null;var c=null;try{var l=p(n,decodeURIComponent(a),s);if(l){var v=h(t,l,a,s);if(v){c={"Content-Type":"application/json;charset=utf-8"};i.fireEvent(o.HTTPMETHOD.PATCH+r+":after",{oXhr:t,oEntity:v});i.fireEvent(o.HTTPMETHOD.PATCH+":after",{oXhr:t,oEntity:v});var _=d(r,a);if(_){jQuery.extend(i._oMockdata[r][_.index],v)}u=204}}t.respond(u,c,f);e.debug("MockServer: response sent with: "+u+", "+f)}catch(r){if(r.error){var E={"Content-Type":"text/plain;charset=utf-8"};t.respond(r.error.code,E,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}});v.push({method:"DELETE",path:new RegExp("("+r+")\\(([^/\\?#]+)\\)/?(.*)?"),response:function(t,r,n,a){e.debug("MockServer: incoming delete request for url: "+t.url);i.fireEvent(o.HTTPMETHOD.DELETE+r+":before",{oXhr:t});i.fireEvent(o.HTTPMETHOD.DELETE+":before",{oXhr:t});var s=204;try{var u=d(r,n);if(u){i._oMockdata[r].splice(u.index,1)}else{s=400}i.fireEvent(o.HTTPMETHOD.DELETE+r+":after",{oXhr:t});i.fireEvent(o.HTTPMETHOD.DELETE+":after",{oXhr:t});t.respond(s,null,null);e.debug("MockServer: response sent with: "+s)}catch(r){if(r.error){var f={"Content-Type":"text/plain;charset=utf-8"};t.respond(r.error.code,f,JSON.stringify(r))}else{t.respond(parseInt(r.message||r.number));e.debug("MockServer: response sent with: "+parseInt(r.message||r.number))}}return true}})});this.setRequests(v)};o.prototype._orderQueryOptions=function(e){var t,r,n,a,s,o,i,u,f,c,d=[];var p=this;jQuery.each(e,function(d,l){var h=e.indexOf(l);switch(l.split("=")[0]){case"$top":a=h;break;case"$skip":n=h;break;case"$orderby":s=h;break;case"$expand":i=h;break;case"$filter":t=h;break;case"$select":o=h;break;case"$inlinecount":r=h;break;case"$format":u=h;break;case"search-focus":c=h;break;case"search":f=h;break;default:if(l.split("=")[0].indexOf("$")===0){p._logAndThrowMockServerCustomError(400,p._oErrorMessages.IS_NOT_A_VALID_SYSTEM_QUERY_OPTION,l.split("=")[0])}}});if(i>=0){d.push(e[i])}if(t>=0){d.push(e[t])}if(c>=0){d.push(e[c])}if(f>=0){d.push(e[f])}if(r>=0){d.push(e[r])}if(s>=0){d.push(e[s])}if(n>=0){d.push(e[n])}if(a>=0){d.push(e[a])}if(o>=0){d.push(e[o])}if(u>=0){d.push(e[u])}return d};o.prototype._removeAllRequestHandlers=function(){var e=this.getRequests();var t=e.length;for(var r=0;r<t;r++){o._removeResponse(e[r].response)}};o.prototype._removeAllFilters=function(){for(var e=0;e<this._aFilters.length;e++){o._removeFilter(this._aFilters[e])}this._aFilters=null};o.prototype._addRequestHandler=function(t,r,n){t=t?t.toUpperCase():t;if(typeof t!=="string"){throw new Error("Error in request configuration: value of 'method' has to be a string")}if(!(typeof r==="string"||r instanceof RegExp)){throw new Error("Error in request configuration: value of 'path' has to be a string or a regular expression")}if(typeof n!=="function"){throw new Error("Error in request configuration: value of 'response' has to be a function")}var a=this._getRootUri();a=a&&new RegExp(this._escapeStringForRegExp(a));if(r&&!(r instanceof RegExp)){r=new RegExp(this._createRegExpPattern(r))}var s=this._createRegExp(a?a.source+r.source:r.source);this._addFilter(this._createFilter(t,s));this._oServer.respondWith(t,s,n);e.debug("MockServer: adding "+t+" request handler for pattern "+s)};o.prototype._createRegExp=function(e){return new RegExp("^"+e+"$")};o.prototype._createRegExpPattern=function(e){return e.replace(/:([\w\d]+)/g,"([^/]+)")};o.prototype._escapeStringForRegExp=function(e){return e.replace(/[\\\/\[\]\{\}\(\)\-\*\+\?\.\^\$\|]/g,"\\$&")};o.prototype._trim=function(e){return e&&e.replace(/^\s+|\s+$/g,"")};o.prototype._isValidNumber=function(e){if(/^([-+]?)0*(\d+)(\.\d+|)([eE][-+]?\d+[d]?|[mldf])?$/i.test(e)){var t=parseFloat(e);return!isNaN(t)&&isFinite(t)}return false};o.prototype._getDateTime=function(e){if(!e){return}return"datetime'"+new Date(Number(e.replace("/Date(","").replace(")/",""))).toJSON().substring(0,19)+"'"};o.prototype._getJsonDate=function(e){if(!e){return}var t=function(e){var t=jQuery.map(e.slice(0,-5).split(/\D/),function(e){return parseInt(e)||0});t[1]-=1;t=new Date(Date.UTC.apply(Date,t));var r=e.slice(-5);var n=parseInt(r)/100;if(r.slice(0,1)==="+"){n*=-1}t.setHours(t.getHours()+n);return t.getTime()};if(e.indexOf("datetimeoffset")>-1){return"/Date("+t(e.substring("datetimeoffset'".length,e.length-1))+")/"}else{return"/Date("+t(e.substring("datetime'".length,e.length-1))+")/"}};o.prototype._addFilter=function(e){this._aFilters.push(e);o._addFilter(e)};o.prototype._createFilter=function(e,t){return function(r,n,a,s,o){return e===r&&t.test(n)}};o.prototype._logAndThrowMockServerCustomError=function(t,r,n){if(r.indexOf("##")>-1&&n){r=r.replace("##","'"+n+"'")}e.error("MockServer: "+r);throw{error:{code:t,message:{lang:"en",value:r}}}};o.prototype.destroy=function(e){r.prototype.destroy.apply(this,arguments);this.stop();var t=o._aServers;var n=t.indexOf(this);t.splice(n,1)};o._aFilters=[];o._oServer=null;o._aServers=[];o._getInstance=function(){if(!this._oServer){this._oServer=window.sinon.fakeServer.create();this._oServer.autoRespond=true}return this._oServer};o.config=function(e){var t=this._getInstance();t.autoRespond=e.autoRespond===false?false:true;t.autoRespondAfter=e.autoRespondAfter||0;t.fakeHTTPMethods=e.fakeHTTPMethods||false};o.respond=function(){this._getInstance().respond()};o.startAll=function(){for(var e=0;e<this._aServers.length;e++){this._aServers[e].start()}};o.stopAll=function(){for(var e=0;e<this._aServers.length;e++){this._aServers[e].stop()}this._getInstance().restore();this._oServer=null};o.destroyAll=function(){this.stopAll();while(this._aServers.length>0){this._aServers[0].destroy()}};o.HTTPMETHOD={GET:"GET",POST:"POST",DELETE:"DELETE",PUT:"PUT",MERGE:"MERGE",PATCH:"PATCH"};o._addFilter=function(e){this._aFilters.push(e)};o._removeFilter=function(e){this._aFilters.splice(this._aFilters.indexOf(e),1)};o._removeResponse=function(e){var t=this._oServer.responses;var r=t.length;for(var n=0;n<r;n++){if(t[n].response===e){t.splice(n,1);return true}}return false};function i(e){var t;Object.assign(e,{async:false,success:function(e,r,n){t={success:true,data:e,status:r,statusCode:n&&n.status}},error:function(e,r,n){t={success:false,data:undefined,status:r,error:n,statusCode:e.status,errorResponse:e.responseText}}});jQuery.ajax(e);return t}o._syncAjax=i;window.sinon.FakeXMLHttpRequest.useFilters=true;window.sinon.FakeXMLHttpRequest.addFilter(function(e,t,r,n,a){var s=o._aFilters;for(var i=0;i<s.length;i++){var u=s[i];if(u(e,t,r,n,a)){return false}}return true});var u=function(e){if(/.*\.json$/i.test(e)){return"JSON"}if(/.*\.xml$/i.test(e)){return"XML"}if(/.*metadata$/i.test(e)){return"XML"}return null};window.sinon.FakeXMLHttpRequest.prototype.respondFile=function(e,t,r){var n=i({url:r,dataType:"text"});if(!n.success){throw new Error("Could not load file from: "+r)}var a=n.data;var s=u(r);if(this["respond"+s]){this["respond"+s](e,t,a)}else{this.respond(e,t,a)}};window.sinon.FakeXMLHttpRequest.prototype.respondJSON=function(e,t,r){t=t||{};t["Content-Type"]=t["Content-Type"]||"application/json";this.respond(e,t,typeof r==="string"?r:JSON.stringify(r))};window.sinon.FakeXMLHttpRequest.prototype.respondXML=function(e,t,r){t=t||{};t["Content-Type"]=t["Content-Type"]||"application/xml";this.respond(e,t,r)};return o});
//# sourceMappingURL=MockServer.js.map