/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/ResizeHandler","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/XML2JSONUtils","sap/ui/Device","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/util/Resources","sap/ui/documentation/sdk/controller/util/ResponsiveImageMap","sap/ui/documentation/sdk/controller/util/SidyBySideImageMap","sap/m/LightBox","sap/m/LightBoxItem","./util/DataTableHelper","./util/DataTable","sap/m/Button","sap/m/MessageToast","sap/ui/dom/includeStylesheet","sap/ui/dom/includeScript","sap/ui/util/openWindow"],function(jQuery,t,e,i,a,n,s,o,r,c,l,u,h,d,g,p,f,m,b){"use strict";var T="https://sap.github.io/openui5-docs/#/",_={SPECIAL_CHARS:/[\\\/:*\?"<>|]/g,SPACES:/\s+/g};return e.extend("sap.ui.documentation.sdk.controller.TopicDetail",{onInit:function(){var t,e;this.oPage=this.byId("topicDetailPage");this.oPage.addStyleClass("docuPage");this.oHtml=this.byId("staticContent");this.aWaitingDatatables=[];this.aResponsiveImageMaps=[];this.oLayout=this.byId("staticContentLayout");this.oHtml.attachEvent("afterRendering",this._onHtmlRendered.bind(this));this._oConfig=e=this.getConfig();this.oMatchedTopicDataTablesConfig={};if(!window.hljs){f("resources/sap/ui/documentation/sdk/thirdparty/highlight.js/styles.css");m({url:"resources/sap/ui/documentation/sdk/thirdparty/highlight.js/highlight.js"})}f("resources/sap/ui/documentation/sdk/thirdparty/DataTables/DataTables-1.10.15/css/dataTables.jqueryui.css");f("resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/css/buttons.jqueryui.css");m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/DataTables-1.10.15/js/jquery.dataTables.js"}).then(function(){return m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/DataTables-1.10.15/js/dataTables.jqueryui.js"})}).then(function(){return m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/js/dataTables.buttons.js"})}).then(function(){return m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/js/buttons.jqueryui.js"})}).then(function(){return m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/js/buttons.html5.js"})}).then(function(){return m({url:"resources/sap/ui/documentation/sdk/thirdparty/DataTables/Buttons-1.4.0/js/buttons.colVis.js"})}).then(function(){t=o.getResourceOriginPath(e.docuPath+"dataTablesConfig.json");return jQuery.ajax({url:t})}).then(function(t){this.oDataTablesConfig=t;this.bDataTablesPluginLoaded=true;this._getDataTableHelper().addMiddlewares();if(this.aWaitingDatatables.length>0){this.aWaitingDatatables.forEach(function(t){this._enableDataTable(t)},this);this.aWaitingDatatables=[]}}.bind(this));this.getRouter().getRoute("topicId").attachPatternMatched(this._onTopicMatched,this);this.getRouter().getRoute("subTopicId").attachPatternMatched(this._onTopicMatched,this);this.jsonDefModel=new i;this.getView().setModel(this.jsonDefModel)},onBeforeRendering:function(){var e=this.getView().getDomRef();if(e&&this.fnOnPageClickListener){e.removeEventListener("click",this.fnOnPageClickListener)}t.deregister(this._onResize.bind(this));n.orientation.detachHandler(this._onOrientationChange,this)},onAfterRendering:function(){var e=this.getView().getDomRef();this.fnOnPageClickListener=this._onPageClick.bind(this);if(e){e.addEventListener("click",this.fnOnPageClickListener)}t.register(this.getView().getDomRef(),this._onResize.bind(this));n.orientation.attachHandler(this._onOrientationChange,this)},_getCopyButtons:function(t){var e="Copied to clipboard.";this.aButtonElements=t.querySelectorAll(".copyButton");this.aButtonElements.forEach(function(t){var i=new g({icon:"sap-icon://copy"});i.placeAt(t);t.addEventListener("click",function(){var i=document.createElement("textarea");i.value=t.parentNode.innerText;document.body.appendChild(i);i.select();document.execCommand("copy");document.body.removeChild(i);p.show(e)})})},onExit:function(){this.aResponsiveImageMaps.forEach(function(t){t.removeEventListeners()});t.deregister(this._onResize.bind(this));n.orientation.detachHandler(this._onOrientationChange,this)},_onResize:function(){this.aResponsiveImageMaps.forEach(function(t){t.resize()})},_onPageClick:function(t){var e=t.target,i=e.classList,a=i.contains("collapsible-icon"),n=i.contains("lightbox-img"),s;if(n){this._onThumbnailClicked(e)}if(a){s=e.parentNode;s.classList.toggle("expanded")}},_onThumbnailClicked:function(t){var e=this._getLightBox(),i=e.getImageContent()[0],a=t.getAttribute("src"),n=t.getAttribute("title"),s=t.getAttribute("alt");i.setImageSrc(a);i.setTitle(n);i.setAlt(s);e.open()},_getLightBox:function(){if(!this._oLightBox){this._oLightBox=new l({imageContent:new u})}return this._oLightBox},_getDataTableHelper:function(){return h.getInstance()},_onHtmlResourceLoaded:function(t){var e;if(!t){setTimeout(function(){this.onRouteNotFound()}.bind(this),0);return}e=a.XML2JSON(t,this._oConfig);e.bIsPhone=n.system.phone;e.topicURL=this.sTopicURL;if(e.shortdesc){e.shortdesc=e.shortdesc.trim().replace(/(\r\n|\n|\r)/gm," ")}this.jsonDefModel.setData(e);this.oHtml.setContent(e.html);this.oLayout.invalidate();this._scrollContentToTop();this.searchResultsButtonVisibilitySwitch(this.byId("topicDetailBackToSearch"));this.appendPageTitle(this.getModel().getProperty("/topictitle1"))},_onTopicMatched:function(t){var e=decodeURIComponent(t.getParameter("arguments").id),i=e.split("#"),a=i[0],n=i[1];this.sTopicId=a.replace(".html","");this.sSubTopicId=n;this.sTopicURL=o.getResourceOriginPath(this._oConfig.docuPath+a+(a.match(/\.html/)?"":".html"));this.sSubTopicId=t.getParameter("arguments").subId||n;jQuery.ajax(this.sTopicURL).done(this._onHtmlResourceLoaded.bind(this)).fail(this.onRouteNotFound.bind(this))},_onHtmlRendered:function(){this._getDataTableHelper().destroyDatatables();var t,e=this.oPage.$().find("#d4h5-main-container :not(.imagemap_sidebyside)>.imagemap"),i=this.oPage.$().find("#d4h5-main-container .imagemap_sidebyside"),a=this.oPage.$().find("#d4h5-main-container table.datatable"),n=this.oPage.$().find("#d4h5-main-container img"),s=this.oLayout.getDomRef();this._fixExternalLinks(s);this._getCopyButtons(s);this._computeColumnGroupValues(s);if(this.sSubTopicId){t=document.getElementById(this.sSubTopicId);if(t){t.scrollIntoView(true)}}this.aResponsiveImageMaps.forEach(function(t){t.removeEventListeners()});this.aResponsiveImageMaps=[];if(a.length){a.each(function(t,e){if(this.bDataTablesPluginLoaded){this._enableDataTable(e)}else{this.aWaitingDatatables.push(e)}}.bind(this))}e.each(function(t,e){this._enableImageMap(e)}.bind(this));i.each(function(t,e){this._enableImageMap(e,true)}.bind(this));n.each(function(t,e){var i=e.getAttribute("src");e.setAttribute("src",o.getResourceOriginPath(i))});if(window.hljs){document.querySelectorAll('pre:not([class*="lines"])').forEach(function(t){window.hljs.highlightBlock(t)})}},_enableImageMap:function(t,e){var i=t.querySelector("img"),a,n,s=/<img[^>]+src="([^">]+)/g,o=this;if(i.complete){this._addResponsiveImageMap(t,e)}else{a=new Image;a.onload=function(){o._addResponsiveImageMap(t,e)};n=s.exec(i.outerHTML);if(n){a.src=n&&n[1]}}},_enableDataTable:function(t){var e=t.id,i=this._getDataTableConfig(e),a;if(i){a=(new d).init(e,t,i);this._getDataTableHelper().addDatatable(a)}},_getDataTableConfig:function(t){var e=this.oDataTablesConfig[this.sSubTopicId]||this.oDataTablesConfig[this.sTopicId]||{};return e[t]},_addResponsiveImageMap:function(t,e){var i=e?c:r;this.aResponsiveImageMaps.push(new i(t))},_fixExternalLinks:function(t){var e=t.querySelectorAll("a.external-link"),i,a,n,s="http://help.sap.com/disclaimer?site=";for(i=0;i<e.length;i++){a=e[i];n=a.getAttribute("href");a.setAttribute("href",s+n);this._addIconToExternalUrl(a,n)}},_computeColumnGroupValues:function(t){var e,i,a,n,s,o=t.querySelectorAll("colgroup");o=[].slice.call(o);o.forEach(function(t){e=0;a=[];s=[].slice.call(t.children);s.forEach(function(t,n){i=parseInt(t.getAttribute("width"));a[n]=i;e+=i});s.forEach(function(t,i){n=a[i]/e*100;t.setAttribute("width",n+"%")})})},_addIconToExternalUrl:function(t,e){var i=this._isSAPHostedUrl(e),a="Information published on "+(i?"":"non ")+"SAP site",n=new Image,s=i?"link-sap":"link-external";n.onload=function(){t.appendChild(n)};n.src="./resources/sap/ui/documentation/sdk/images/"+s+".png";n.setAttribute("title",a);n.className="sapUISDKExternalLink"},_isSAPHostedUrl:function(t){return/^https?:\/\/([\w.]*\.)?(?:sap|hana\.ondemand|sapfioritrial)\.com/.test(t)},_scrollContentToTop:function(){if(this.oPage&&this.oPage.$().length>0){this.oPage.getScrollDelegate().scrollTo(0,1)}},_formatHTML:function(t){return"<div>"+t+"</div>"},backToSearch:function(t){this.onNavBack()},onToggleFullScreen:function(t){s.updateMode(t,this.getView(),this)},onEditGitHubPress:function(t){b(this.jsonDefModel.getProperty("/mdEditLink"))},_formatToGitHubUrl:function(t,e){var i=e.trim().replace(_.SPECIAL_CHARS,"").replace(_.SPACES,"_");i+="_";i+=t.split("/").pop().substring(0,7);i+=".md";return T+i}})});
//# sourceMappingURL=TopicDetail.controller.js.map