/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/dt/TaskManager","sap/ui/dt/Util","sap/base/Log"],function(s,t,e){"use strict";var a=function(e){if(!e||!e.taskManager||!(e.taskManager instanceof s)){throw t.createError("TaskRunner#constructor","sap.ui.dt.TaskRunner: TaskManager required")}this._oTaskManager=e.taskManager;this._sInitialTaskType=e.taskType;this._sObservedTaskType=e.taskType;this._iRequestId=undefined;this.bIsStopped=true;this._oTaskPromise=Promise.resolve()};a.prototype._shouldObserveBreak=function(){if(this.bIsStopped||!this._oTaskManager||this._oTaskManager.bIsDestroyed){this.bIsStopped=true;return true}return false};a.prototype._observe=function(s){this._oTaskPromise=this._oTaskPromise.then(function(){if(this._shouldObserveBreak()){this.stop()}else{this._runTasksFromManager(s)}}.bind(this))};a.prototype._runTasksFromManager=function(){var s=this._oTaskManager.getQueuedTasks(this._sObservedTaskType);if(s.length){this._runTasks(s)}};a.prototype._runTasks=function(s){s.forEach(function(s){if(s.callbackFn){s.callbackFn().then(function(){this._oTaskManager.complete(s.id)}.bind(this)).catch(function(a){this._oTaskManager.complete(s.id);e.error(`${t.errorToString(a)} / related task: ${JSON.stringify(s)}`)}.bind(this))}}.bind(this))};a.prototype.run=function(s){this._sObservedTaskType=s||this._sInitialTaskType;this.bIsStopped=false;this._oTaskManager.attachAdd(this._observe,this);this._observe()};a.prototype.stop=function(){this.bIsStopped=true;this._oTaskManager.detachAdd(this._observe,this)};return a});
//# sourceMappingURL=TaskRunner.js.map