/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/restricted/_union","sap/base/util/includes","sap/base/util/merge","sap/base/Log","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Component","sap/ui/fl/apply/_internal/changes/Applier","sap/ui/fl/apply/_internal/changes/Utils","sap/ui/fl/apply/_internal/flexObjects/FlexObjectFactory","sap/ui/fl/apply/_internal/flexObjects/States","sap/ui/fl/apply/_internal/flexState/changes/DependencyHandler","sap/ui/fl/apply/_internal/flexState/controlVariants/VariantManagementState","sap/ui/fl/apply/_internal/flexState/DataSelector","sap/ui/fl/apply/_internal/flexState/FlexState","sap/ui/fl/initial/api/Version","sap/ui/fl/registry/Settings","sap/ui/fl/write/_internal/condenser/Condenser","sap/ui/fl/write/_internal/Storage","sap/ui/fl/Layer","sap/ui/fl/LayerUtils","sap/ui/fl/Utils","sap/ui/performance/Measurement"],function(e,t,n,a,r,i,s,o,c,h,p,l,u,f,g,d,C,m,y,_,v,D){"use strict";const S=new u({id:"variantIndependentUIChanges",parentDataSelector:f.getFlexObjectsDataSelector(),executeFunction(e){return e.filter(function(e){const t=e.isA("sap.ui.fl.apply._internal.flexObjects.UIChange");const n=e.isA("sap.ui.fl.apply._internal.flexObjects.ControllerExtensionChange");const a=e.getFileType()==="change"||e.getFileType()==="codeExt";return(t||n)&&a&&!e.getVariantReference()&&!e.getSelector().persistencyKey})}});var b=function(e){this._mComponent=e;this._mChanges=p.createEmptyDependencyMap();this._bChangesMapCreated=false;this._mChangesInitial=n({},this._mChanges);if(!this._mComponent||!this._mComponent.name){a.error("The Control does not belong to an SAPUI5 component. Personalization and changes for this control might not work as expected.");throw new Error("Missing component name.")}this._aDirtyChanges=[];this._oMessagebundle=undefined;this._mChangesEntries={};S.clearCachedResult({reference:this._mComponent.name})};async function F(e,t,n){try{if(n){await f.update(t)}await f.getStorageResponse(e)}catch(e){a.error("Error during ChangePersistence.prototype.getChangesForComponent")}}b.prototype.getChangesForComponent=async function(e,t){e||={};await F(this._mComponent.name,e,t);const n=f.getFlexObjectsDataSelector().get({reference:this._mComponent.name});if(!n.length){return[]}let a=S.get({reference:this._mComponent.name});if(!e.includeCtrlVariants){a=a.concat(l.getInitialChanges({reference:this._mComponent.name}))}else{a=a.concat(l.getVariantDependentFlexObjects(this._mComponent.name))}if(e.currentLayer){a=_.filterChangeOrChangeDefinitionsByCurrentLayer(a,e.currentLayer)}a.forEach(function(e){this._mChangesEntries[e.getId()]=e}.bind(this));return a};b.prototype.loadChangesMapForComponent=function(e){return this.getChangesForComponent({component:e}).then(t.bind(this));function t(t){D.start("fl.createDependencyMap","Measurement of creating initial dependency map");this._mChanges=p.createEmptyDependencyMap();t.forEach(this.addChangeAndUpdateDependencies.bind(this,e));this._mChangesInitial=n({},this._mChanges);D.end("fl.createDependencyMap","Measurement of creating initial dependency map");this._bChangesMapCreated=true;return this.getChangesMapForComponent.bind(this)}};b.prototype.getOpenDependentChangesForControl=function(e,t){return p.getOpenDependentChangesForControl(this._mChanges,r.getControlIdBySelector(e,t),t)};function I(e){var t=n({},this._mChangesInitial.mDependencies);return t[e.getId()]}function O(e,n,a,i){var s;var o=[];e.controlsDependencies.forEach(function(e){if(!r.bySelector(e,a)){s=r.getControlIdBySelector(e,a);o.push(e);this._mChanges.mControlsWithDependencies[s]||=[];if(!t(this._mChanges.mControlsWithDependencies[s],i.getId())){this._mChanges.mControlsWithDependencies[s].push(i.getId())}}}.bind(this));e.dependencies=n;e.controlsDependencies=o;if(n.length||o.length){this._mChanges.mDependencies[i.getId()]=e}}b.prototype.copyDependenciesFromInitialChangesMap=function(e,t,n){var a=I.call(this,e);if(a){var r=[];a.dependencies.forEach(function(n){if(t(n)){this._mChanges.mDependentChangesOnMe[n]||=[];this._mChanges.mDependentChangesOnMe[n].push(e.getId());r.push(n)}}.bind(this));O.call(this,a,r,n,e)}return this._mChanges};b.prototype.addChangeAndUpdateDependencies=function(e,t,n){t.setInitialApplyState();if(n){p.insertChange(t,this._mChanges,n)}p.addChangeAndUpdateDependencies(t,e,this._mChanges)};b.prototype._addRunTimeCreatedChangeAndUpdateDependencies=function(e,t){p.addRuntimeChangeAndUpdateDependencies(t,e,this._mChanges,this._mChangesInitial)};b.prototype.getChangesMapForComponent=function(){return this._mChanges};b.prototype.getAllUIChanges=function(t){var n=e(this.getChangesMapForComponent().aChanges,t.includeDirtyChanges&&this.getDirtyChanges()).filter(function(e){return Boolean(e)&&e.getFileType()==="change"&&_.compareAgainstCurrentLayer(e.getLayer(),t.layer)===0});return n};b.prototype.isChangeMapCreated=function(){return this._bChangesMapCreated};b.prototype.getChangesForView=function(e){return this.getChangesForComponent(e).then(function(t){return t.filter(o.filterChangeByView.bind(undefined,e))})};function x(e,t){this._addRunTimeCreatedChangeAndUpdateDependencies(t,e);this._mChangesEntries[e.getId()]=e;this._addPropagationListener(t)}b.prototype.addChange=function(e,t){var n=this.addDirtyChange(e);x.call(this,n,t);return n};b.prototype.addChanges=function(e,t){var n=this.addDirtyChanges(e);n.forEach(function(e){x.call(this,e,t)}.bind(this));return n};b.prototype.addDirtyChange=function(e,t){var n;if(typeof e.isA==="function"&&e.isA("sap.ui.fl.apply._internal.flexObjects.FlexObject")){n=e}else{n=c.createFromFileContent(e)}if(this._aDirtyChanges.indexOf(n)===-1){this._aDirtyChanges.push(n);if(!t){f.addDirtyFlexObject(this._mComponent.name,n)}}return n};b.prototype.addDirtyChanges=function(e){var t=e.map(function(e){return this.addDirtyChange(e,true)}.bind(this));f.addDirtyFlexObjects(this._mComponent.name,t);return t};b.prototype._addPropagationListener=function(e){var t=v.getAppComponentForControl(e);if(t instanceof i){var n=function(e){return!e._bIsSapUiFlFlexControllerApplyChangesOnControl};var a=t.getPropagationListeners().every(n);if(a){var r=sap.ui.require("sap/ui/fl/FlexControllerFactory");var o=r.create(this._mComponent.name);var c=s.applyAllChangesForControl.bind(s,this.getChangesMapForComponent.bind(this),t,o);c._bIsSapUiFlFlexControllerApplyChangesOnControl=true;t.addPropagationListener(c)}}};b.prototype._deleteNotSavedChanges=function(e,t,n){e.filter(function(e){return!t.some(function(t){return e.getId()===t.getId()})}).forEach(function(e){if(n){this.removeChange(e);f.updateStorageResponse(this._mComponent.name,[{flexObject:e.convertToFileContent(),type:"delete"}])}else{this.deleteChange(e)}}.bind(this))};function E(e,t){var n=e.map(function(e){return e[t]()});var a=n.filter(function(e,t,n){return n.indexOf(e)===t});return a.length===1}function L(e,t,n){var a=false;if(!e||t.length<2||!E(t,"getLayer")){return false}if(n){a=true}else{var r=t[0].getLayer();if([y.CUSTOMER,y.USER].includes(r)){a=true}}var i=new URLSearchParams(window.location.search);if(i.has("sap-ui-xx-condense-changes")){a=i.get("sap-ui-xx-condense-changes")==="true"}return a}function M(e){var t=d.getInstanceOrUndef()&&d.getInstanceOrUndef().isCondensingEnabled();if(t&&!E(e,"getNamespace")){t=false}return t}function T(e,t,n,a){this._massUpdateCacheAndDirtyState(t,n);this._deleteNotSavedChanges(e,t,a)}function U(e,t,n,a){if(!e.length&&!n){return[]}var r=this._mChanges.aChanges.filter(function(e){if(a===y.CUSTOMER&&t){return e.getState()===h.LifecycleState.PERSISTED&&t.includes(e.getId())}return e.getState()===h.LifecycleState.PERSISTED&&_.compareAgainstCurrentLayer(e.getLayer(),a)===0});return r.concat(e)}function A(e){if(e.length){var t=w(e);var n=true;if(d.getInstanceOrUndef()&&d.getInstanceOrUndef().hasPersoConnector()){var a=P(e);n=a.length===1}return t.length===1&&n}return true}function j(e,t,n,a,r,i){var s=[];var o=Promise.resolve();var c=i.filter(function(e){if(e.getState()===h.LifecycleState.DELETED){s.push(e);return false}return true});if(s.length){o=this.saveSequenceOfDirtyChanges(s,a,n)}return o.then(function(){if(c.length){return m.write({layer:e,flexObjects:V(c),transport:t,isLegacyVariant:false,parentVersion:n}).then(function(e){e?.response?.forEach(function(e){c.find(function(t){return t.getId()===e.fileName}).update(e)});T.call(this,r,c,a);return e}.bind(this))}return this._deleteNotSavedChanges(r,i)}.bind(this))}b.prototype.saveDirtyChanges=function(e,t,n,a,r,i,s){var o=n||this._aDirtyChanges;var c=o.length&&o[0].getLayer()||s;var h=U.call(this,o,r,i,c);var p=M(h)&&L(e,h,i);var l=p?h:o;var u=l.slice(0);var f=w(o);if(A(o)){var g=Promise.resolve(u);if(L(e,u,i)){g=C.condense(e,u)}return g.then(function(e){var n=f[0];if(p){return m.condense({allChanges:l,condensedChanges:e,layer:c,transport:n,isLegacyVariant:false,parentVersion:a}).then(function(n){T.call(this,l,e,t,true);return n}.bind(this))}return j.call(this,c,n,a,t,l,e)}.bind(this))}return this.saveSequenceOfDirtyChanges(o,t,a)};b.prototype.saveSequenceOfDirtyChanges=function(e,t,n){var a;if(n){var r=e.filter(function(e){return e.getState()===h.LifecycleState.NEW});a=[].concat(r).shift()}return e.reduce(function(e,r){return e.then(R.bind(undefined,r,a,n)).then(this._updateCacheAndDirtyState.bind(this,r,t))}.bind(this),Promise.resolve())};function R(e,t,n){switch(e.getState()){case h.LifecycleState.NEW:if(n!==undefined){n=e===t?n:g.Number.Draft}return m.write({layer:e.getLayer(),flexObjects:[e.convertToFileContent()],transport:e.getRequest(),parentVersion:n});case h.LifecycleState.DELETED:return m.remove({flexObject:e.convertToFileContent(),layer:e.getLayer(),transport:e.getRequest(),parentVersion:n});default:return Promise.resolve()}}b.prototype._updateCacheAndDirtyState=function(e,t){this._aDirtyChanges=this._aDirtyChanges.filter(function(t){return e.getId()!==t.getId()});if(!t){switch(e.getState()){case h.LifecycleState.NEW:f.updateStorageResponse(this._mComponent.name,[{type:"add",flexObject:e.convertToFileContent()}]);break;case h.LifecycleState.DELETED:f.updateStorageResponse(this._mComponent.name,[{type:"delete",flexObject:e.convertToFileContent()}]);break;case h.LifecycleState.DIRTY:f.updateStorageResponse(this._mComponent.name,[{type:"update",flexObject:e.convertToFileContent()}]);break;default:}}};b.prototype._massUpdateCacheAndDirtyState=function(e,t){e.forEach(function(e){this._updateCacheAndDirtyState(e,t)},this)};function w(e){var t=[];e.forEach(function(e){var n=e.getRequest();if(t.indexOf(n)===-1){t.push(n)}});return t}function P(e){var t=[];e.forEach(function(e){var n=e.getLayer();if(t.indexOf(n)===-1){t.push(n)}});return t}function V(e){var t=[];e.forEach(function(e){t.push(e.convertToFileContent())});return t}b.prototype.getDirtyChanges=function(){return this._aDirtyChanges};b.prototype.deleteChange=function(e,t,n){var a=this._aDirtyChanges.indexOf(e);if(a>-1){if(e.getState()===h.LifecycleState.DELETED){return}this._aDirtyChanges.splice(a,1);if(!n){f.removeDirtyFlexObject(this._mComponent.name,e)}this._deleteChangeInMap(e,t);return}e.markForDeletion();this.addDirtyChange(e);this._deleteChangeInMap(e,t)};b.prototype.deleteChanges=function(e,t){e.forEach(function(e){this.deleteChange(e,t,true)}.bind(this));f.removeDirtyFlexObjects(this._mComponent.name,e)};b.prototype.removeChange=function(e){var t=this._aDirtyChanges.indexOf(e);if(t>-1){this._aDirtyChanges.splice(t,1);f.removeDirtyFlexObject(this._mComponent.name,e)}this._deleteChangeInMap(e)};b.prototype._deleteChangeInMap=function(e,t){var n=e.getId();p.removeChangeFromMap(this._mChanges,n);p.removeChangeFromDependencies(t?this._mChangesInitial:this._mChanges,n)};function N(e,t){return(t.getRequest()==="$TMP"||t.getRequest()==="")&&t.getLayer()===e}function q(e,t){return t.getState()===h.LifecycleState.PERSISTED&&t.getLayer()===e}function B(){var e=[];var t=f.getCompVariantsMap(this._mComponent.name);for(var n in t){for(var a in t[n].byId){e.push(t[n].byId[a])}}return e}b.prototype.transportAllUIChanges=function(e,t,n,a){return this.getChangesForComponent({currentLayer:n,includeCtrlVariants:true}).then(function(e){var r=B.call(this);e=e.concat(r.filter(N.bind(this,n)));return m.publish({transportDialogSettings:{styleClass:t},layer:n,reference:this._mComponent.name,localChanges:e,appVariantDescriptors:a})}.bind(this))};b.prototype._getChangesFromMapByNames=function(e){return this._mChanges.aChanges.filter(function(t){return e.indexOf(t.getId())!==-1})};b.prototype.removeDirtyChanges=function(e,t,n,a,i){var s=[].concat(e||[]);var o=this._aDirtyChanges;var c=o.filter(function(e){var o=true;if(s.length&&!s.includes(e.getLayer())){return false}if(a&&e.getSupportInformation().generator!==a){return false}if(n){var c=e.getSelector();o=n.getId()===r.getControlIdBySelector(c,t)}if(i){o&&=i.indexOf(e.getChangeType())!==-1}return o});f.removeDirtyFlexObjects(this._mComponent.name,c);c.forEach(function(e){var t=o.indexOf(e);o.splice(t,1)});return Promise.resolve(c)};b.prototype.resetChanges=async function(e,t,n,a){const r=n&&n.length>0;const i=a&&a.length>0;const s=d.getInstanceOrUndef()&&d.getInstanceOrUndef().isPublicLayerAvailable();const o=t===undefined&&n===undefined&&a===undefined;const c=s&&o?B.call(this).filter(q.bind(this,e)):[];const h=await this.getChangesForComponent({currentLayer:e,includeCtrlVariants:true});const p=h.concat(c);const l={reference:this._mComponent.name,layer:e,changes:p};if(t){l.generator=t}if(r){l.selectorIds=n}if(i){l.changeTypes=a}const u=await m.reset(l);if(n||a){const e=[];if(u&&u.response&&u.response.length>0){u.response.forEach(function(t){e.push(t.fileName)})}const t=this._getChangesFromMapByNames(e);f.updateStorageResponse(this._mComponent.name,t.map(e=>({flexObject:e.convertToFileContent(),type:"delete"})));return t}return[]};return b});
//# sourceMappingURL=ChangePersistence.js.map