/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/merge","sap/ui/core/Lib","sap/ui/fl/write/connectors/BaseConnector","sap/ui/fl/initial/_internal/connectors/LrepConnector","sap/ui/fl/initial/_internal/connectors/Utils","sap/ui/fl/write/_internal/connectors/Utils","sap/ui/fl/write/_internal/transport/TransportSelection","sap/ui/fl/registry/Settings","sap/ui/fl/Layer","sap/ui/fl/Utils","sap/ui/core/Component","sap/ui/core/BusyIndicator","sap/base/Log","sap/m/MessageBox","sap/base/util/restricted/_pick"],function(e,t,r,n,a,s,i,o,l,u,p,c,f,d,T){"use strict";var g={FLEX_INFO:"/flex/info/",PUBLISH:"/actions/make_changes_transportable/",CHANGES:"/changes/",CONDENSE:"/actions/condense/",VARIANTS:"/variants/",SETTINGS:"/flex/settings",TOKEN:"/actions/getcsrftoken/",APPVARIANTS:"/appdescr_variants/",APPVARIANTS_OVERVIEW:"/app_variant_overview/",UI2PERSONALIZATION:"/ui2personalization/",CONTEXTS:"/flex/contexts/",VERSIONS:{GET:"/flex/versions/",ACTIVATE:"/flex/versions/activate/",DISCARD:"/flex/versions/draft/",PUBLISH:"/flex/versions/publish/"},CONTEXT_BASED_ADAPTATION:"/flex/apps/",MANI_FIRST_SUPPORTED:"/sap/bc/ui2/app_index/ui5_app_mani_first_supported"};var v="/adaptations/";var E=function(e){var t;if(e.isLegacyVariant){t=g.VARIANTS}else if(e.isAppVariant){t=g.APPVARIANTS}else if(e.isContextSharing){t=g.CONTEXTS}else if(e.isCondensingEnabled){t=g.CONDENSE}else if(e.isContextBasedAdaptationEnabled){t=g.CONTEXT_BASED_ADAPTATION+e.appId+v}else{t=g.CHANGES}var r=e.transport?{changelist:e.transport}:{};if(e.skipIam){r.skipIam=e.skipIam}if(e.parentVersion){r.parentVersion=e.parentVersion}a.addSAPLogonLanguageInfo(r);n._addClientInfo(r);if(e.flexObject&&!e.isAppVariant){e.fileName=e.flexObject.fileName}var i=a.getUrl(t,e,r);delete e.reference;delete e.fileName;var o=a.getUrl(g.TOKEN,e);var l=s.getRequestOptions(n,o,e.flexObjects||e.flexObject,"application/json; charset=utf-8","json");return s.sendRequest(i,e.method,l)};var O=function(e){var t=e.getDefinition().layer===l.VENDOR?e.getPackage():"";return{package:t,namespace:e.getNamespace(),name:e.getDefinition().fileName,type:e.getDefinition().fileType}};var R=function(e){var t;if(e.transport){t=Promise.resolve({transport:e.transport})}else if(e.isForSmartBusiness){return Promise.resolve()}else{var r=O(e.appVariant);t=(new i).openTransportSelection(r)}return t.then(function(e){if(e==="cancel"){return Promise.reject("cancel")}if(e&&e.transport!==undefined){return e.transport}return Promise.reject(new Error("Transport information could not be determined"))})};function S(e){e.version=e.versionId;delete e.versionId;return e}return e({},r,{initialConnector:n,layers:n.layers,reset(e){c.show(0);var t=[];var r=Promise.resolve();if(e.layer!==l.USER){t=e.changes;r=o.getInstance().then(function(r){if(!r.isProductiveSystem()){return(new i).setTransports(t,p.getComponentById(e.reference)).then(function(){t.some(function(t){if(t.getRequest()){e.changelist=t.getRequest();return true}return false})})}})}return r.then(function(){c.show(0);var t=["reference","layer","changelist","generator"];var r=T(e,t);n._addClientInfo(r);if(e.selectorIds){r.selector=e.selectorIds}if(e.changeTypes){r.changeType=e.changeTypes}delete e.reference;var i=a.getUrl(g.CHANGES,e,r);var o=a.getUrl(g.TOKEN,e);var l=s.getRequestOptions(n,o);return s.sendRequest(i,"DELETE",l).then(function(e){if(e&&e.response){e.response.forEach(function(e){e.fileName=e.name;delete e.name})}c.hide();return e}).catch(function(e){c.hide();return Promise.reject(e)})})},publish(e){var r=t.getResourceBundleFor("sap.ui.fl");var n=function(t){c.hide();var n=r.getText("MSG_TRANSPORT_ERROR",t?[t.message||t]:undefined);var a=r.getText("HEADER_TRANSPORT_ERROR");f.error(`transport error: ${t}`);d.show(n,{icon:d.Icon.ERROR,title:a,styleClass:e.transportDialogSettings.styleClass});return"Error"};var a=new i;return a.openTransportSelection(null,e.transportDialogSettings.rootControl,e.transportDialogSettings.styleClass).then(function(t){if(a.checkTransportInfo(t)){c.show(0);var n={reference:e.reference,layer:e.layer};return a._prepareChangesForTransport(t,e.localChanges,e.appVariantDescriptors,n).then(function(){c.hide();if(t.transport==="ATO_NOTIFICATION"){return r.getText("MSG_ATO_NOTIFICATION")}return r.getText("MSG_TRANSPORT_SUCCESS")})}return"Cancel"}).catch(n)},getFlexInfo(e){var t=["layer"];var r=T(e,t);n._addClientInfo(r);var s=a.getUrl(g.FLEX_INFO,e,r);return a.sendRequest(s,"GET",{initialConnector:n}).then(function(e){return e.response})},getContexts(e){var t=["type","$skip","$filter"];var r=T(e,t);n._addClientInfo(r);var s=a.getUrl(g.CONTEXTS,e,r);return a.sendRequest(s,"GET",{initialConnector:n}).then(function(e){return e.response})},loadContextDescriptions(e){e.method="POST";e.isContextSharing=true;return E(e).then(function(e){return e.response})},isContextSharingEnabled(){return Promise.resolve(true)},loadFeatures(e){if(n.settings){return Promise.resolve(n.settings)}var t={};n._addClientInfo(t);var r=a.getUrl(g.SETTINGS,e,t);return a.sendRequest(r,"GET",{initialConnector:n}).then(function(e){e.response.isVariantAdaptationEnabled=!!e.response.isPublicLayerAvailable;e.response.isContextSharingEnabled=true;e.response.isLocalResetEnabled=true;return e.response})},write(e){e.method="POST";return E(e)},condense(e){e.method="POST";e.isCondensingEnabled=true;return E(e)},update(e){if(e.flexObject.fileType==="variant"){e.isLegacyVariant=true}e.method="PUT";return E(e)},remove(e){var t={namespace:e.flexObject.namespace,layer:e.flexObject.layer};if(e.transport){t.changelist=e.transport}if(e.parentVersion){t.parentVersion=e.parentVersion}n._addClientInfo(t);e.fileName=e.flexObject.fileName;var r=e.flexObject.fileType==="variant"?g.VARIANTS:g.CHANGES;var i=a.getUrl(r,e,t);i=decodeURIComponent(i);delete e.fileName;var o=a.getUrl(g.TOKEN,e);var l=s.getRequestOptions(n,o,undefined,"application/json; charset=utf-8","json");return s.sendRequest(i,"DELETE",l)},appVariant:{getManifirstSupport(e){var t=`${g.MANI_FIRST_SUPPORTED}/?id=${e.appId}`;return a.sendRequest(t,"GET",{initialConnector:n}).then(function(e){return e.response})},getManifest(e){var t=e.appVarUrl;var r=s.getRequestOptions(n,u.getLrepUrl()+g.TOKEN,undefined,"application/json; charset=utf-8","json");return s.sendRequest(t,"GET",r)},load(e){var t=a.getUrl(g.APPVARIANTS,e);var r=s.getRequestOptions(n,u.getLrepUrl()+g.TOKEN,undefined,"application/json; charset=utf-8","json");return s.sendRequest(t,"GET",r)},create(e){e.method="POST";e.isAppVariant=true;return E(e)},assignCatalogs(e){var t={};t.action=e.action;delete e.action;t.assignFromAppId=e.assignFromAppId;delete e.assignFromAppId;var r=a.getUrl(g.APPVARIANTS,e,t);delete e.reference;var i=a.getUrl(g.TOKEN,e);var o=s.getRequestOptions(n,i,undefined,"application/json; charset=utf-8","json");return s.sendRequest(r,"POST",o)},unassignCatalogs(e){var t={};t.action=e.action;delete e.action;var r=a.getUrl(g.APPVARIANTS,e,t);delete e.reference;var i=a.getUrl(g.TOKEN,e);var o=s.getRequestOptions(n,i,undefined,"application/json; charset=utf-8","json");return s.sendRequest(r,"POST",o)},update(e){return R(e).then(function(t){if(t){e.transport=t}delete e.isForSmartBusiness;e.method="PUT";e.isAppVariant=true;return E(e)})},remove(e){return R(e).then(function(t){var r={};if(t){r.changelist=t}delete e.isForSmartBusiness;var i=a.getUrl(g.APPVARIANTS,e,r);delete e.reference;var o=a.getUrl(g.TOKEN,e);var l=s.getRequestOptions(n,o,undefined,"application/json; charset=utf-8","json");return s.sendRequest(i,"DELETE",l)})},list(e){var t={};t.layer=e.layer;t["sap.app/id"]=e.reference;delete e.layer;delete e.reference;var r=a.getUrl(g.APPVARIANTS_OVERVIEW,e,t);var i=s.getRequestOptions(n,undefined,undefined,"application/json; charset=utf-8","json");return s.sendRequest(r,"GET",i)}},contextBasedAdaptation:{create(e){e.isContextBasedAdaptationEnabled=true;e.method="POST";return E(e)},reorder(e){e.isContextBasedAdaptationEnabled=true;e.method="PUT";return E(e)},update(e){e.isContextBasedAdaptationEnabled=true;e.method="PUT";e.reference=e.adaptationId;return E(e)},load(e){var t=["version"];var r=T(e,t);n._addClientInfo(r);e.reference=e.appId+v;var s=a.getUrl(g.CONTEXT_BASED_ADAPTATION,e,r);return a.sendRequest(s,"GET",{initialConnector:n}).then(function(e){return e.response})},remove(e){e.isContextBasedAdaptationEnabled=true;e.method="DELETE";e.reference=e.adaptationId;return E(e)}},ui2Personalization:{create(e){e.initialConnector=this.initialConnector;var t=u.getLrepUrl();var r=s.getRequestOptions(n,t+g.TOKEN,e.flexObjects||e.flexObject,"application/json; charset=utf-8","json");var a=t+g.UI2PERSONALIZATION;return s.sendRequest(a,"PUT",r)},remove(e){e.initialConnector=this.initialConnector;var t=a.getUrl(g.UI2PERSONALIZATION,{url:u.getLrepUrl()},{reference:e.reference,containerkey:e.containerKey,itemname:e.itemName});return s.sendRequest(t,"DELETE")}},versions:{load(e){var t=s.getRequestOptions(n,a.getUrl(g.TOKEN,e));var r={};a.addSAPLogonLanguageInfo(r);r.limit=e.limit;var i=a.getUrl(g.VERSIONS.GET,e,r);return s.sendRequest(i,"GET",t).then(function(e){return e.response.versions.map(function(e){return S(e)})})},activate(e){var t=s.getRequestOptions(n,a.getUrl(g.TOKEN,e),{title:e.title},"application/json; charset=utf-8","json");var r={version:e.version};a.addSAPLogonLanguageInfo(r);var i=a.getUrl(g.VERSIONS.ACTIVATE,e,r);return s.sendRequest(i,"POST",t).then(function(e){var t=e.response;return S(t)})},discardDraft(e){var t=s.getRequestOptions(n,a.getUrl(g.TOKEN,e));var r=a.getUrl(g.VERSIONS.DISCARD,e);return s.sendRequest(r,"DELETE",t)},publish(e){var r=t.getResourceBundleFor("sap.ui.fl");var o=function(t){c.hide();var n=r.getText("MSG_TRANSPORT_ERROR",t?[t.message||t]:undefined);var a=r.getText("HEADER_TRANSPORT_ERROR");f.error(`transport error${t}`);d.show(n,{icon:d.Icon.ERROR,title:a,styleClass:e.styleClass});return"Error"};var l=new i;return l.openTransportSelection(null,e.rootControl,e.styleClass,false).then(function(t){if(l.checkTransportInfo(t)){c.show(0);if(!t.transport){return Promise.reject(new Error("no transport provided as attribute of mParameters"))}if(!e.reference){return Promise.reject(new Error("no reference provided as attribute of mParameters"))}if(!e.version){return Promise.reject(new Error("no version provided as attribute of mParameters"))}var i={transport:t.transport,version:e.version};var o=a.getUrl(g.VERSIONS.PUBLISH,{url:u.getLrepUrl(),reference:e.reference},i);var p=a.getUrl(g.TOKEN,{url:u.getLrepUrl()});var f=s.getRequestOptions(n,p,undefined,"application/json; charset=utf-8","json");return s.sendRequest(o,"POST",f).then(function(){c.hide();if(t.transport==="ATO_NOTIFICATION"){return r.getText("MSG_ATO_NOTIFICATION")}return r.getText("MSG_TRANSPORT_SUCCESS")})}return"Cancel"}).catch(o)}}})});
//# sourceMappingURL=LrepConnector.js.map