/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/integration/designtime/baseEditor/util/findClosestInstance","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/util/escapeParameter","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/deepEqual"],function(t,e,i,r,o,n,a,s){"use strict";var p="config";var g="propertyName";var h=t.extend("sap.ui.integration.designtime.baseEditor.PropertyEditor",{metadata:{library:"sap.ui.integration",interfaces:["sap.ui.core.IFormContent"],properties:{propertyName:{type:"string"},renderLabel:{type:"boolean"},value:{type:"any"},config:{type:"object"}},aggregations:{propertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor",multiple:false,visibility:"hidden"}},associations:{editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor",multiple:false}},events:{editorChange:{parameters:{previousEditor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"},editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"}}},propertyEditorChange:{parameters:{previousPropertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"},propertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"}}},configChange:{parameters:{previousConfig:{type:"object"},config:{type:"object"}}},propertyNameChange:{parameters:{previousPropertyName:{type:"string"},propertyName:{type:"string"}}},ready:{},validationErrorChange:{parameters:{hasError:{type:"boolean"}}},beforeValueChange:{parameters:{path:{type:"string"},value:{type:"any"},nextValue:{type:"any"}}},valueChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},designtimeMetadataChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},init:{}}},_bEditorAutoDetect:false,_sCreatedBy:null,constructor:function(){t.prototype.constructor.apply(this,r(arguments,function(t,e){return e==="config"&&o.hasType(t.type)}));if(!this.getEditor()){this._bEditorAutoDetect=true}this._propagationListener=this._propagationListener.bind(this);this.attachEditorChange(function(t){if(this._sCreatedBy){this._removePropertyEditor(t.getParameter("previousEditor"))}this._initPropertyEditor()});this.attachConfigChange(function(t){var e=t.getParameter("previousConfig");var i=t.getParameter("config");var r=this.getAggregation("propertyEditor");if(this._fnCancelInit||!r||!e||!i||e.type!==i.type||e.path!==i.path){this._removePropertyEditor(this.getEditor());this._initPropertyEditor()}else{r.setConfig(i);if(i.visible!==false&&e.visible===false){r.setValue(this.getValue())}}});this.attachPropertyNameChange(function(){if(this._sCreatedBy===g){this._removePropertyEditor(this.getEditor())}if(this._sCreatedBy!==p){this._initPropertyEditor()}});this._initPropertyEditor()},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e);t.style("display","inline-block");t.style("width","100%");t.openEnd();t.renderControl(e.getAggregation("propertyEditor"));t.close("div")}}});h.prototype.init=function(){Promise.resolve().then(function(){this.fireInit()}.bind(this))};h.prototype.getEditor=function(){return sap.ui.getCore().byId(this.getAssociation("editor"))};h.prototype._prepareConfig=function(t){var e=this.getEditor();var i=t.type&&e?(e.getConfig().propertyEditorConfigs||{})[t.type]:{};return n({},i,t)};h.prototype.setConfig=function(t){var e=this.getConfig();var i=t&&n({},{designtime:undefined},this._prepareConfig(t));if(!s(e,i)){this.setProperty("config",i);this.fireConfigChange({previousConfig:e,config:i})}};h.prototype.setPropertyName=function(t){var e=this.getPropertyName();if(e!==t){this.setProperty("propertyName",t);this.firePropertyNameChange({previousPropertyName:e,propertyName:t})}};h.prototype.setEditor=function(t){var e=this.getEditor();var i=typeof t==="string"?sap.ui.getCore().byId(t):t;if(e!==i){this.setAssociation("editor",t);var i=this.getEditor();this.fireEditorChange({previousEditor:e,editor:i});this.setConfig(this.getConfig())}};h.prototype.destroy=function(){this._removePropertyEditor(this.getEditor());t.prototype.destroy.apply(this,arguments)};h.prototype._cleanupCancelledInit=function(t){t.destroy()};h.prototype._removePropertyEditor=function(t){var e=this.getAggregation("propertyEditor");if(this._fnCancelInit){this._fnCancelInit().then(this._cleanupCancelledInit);delete this._fnCancelInit}if(e){this.setAggregation("propertyEditor",null);e.detachReady(this._onPropertyEditorReady,this);e.detachValidationErrorChange(this._onPropertyEditorError,this);e.destroy();this._sCreatedBy=null;this.firePropertyEditorChange({propertyEditor:null})}if(t&&this._mConfig&&this._isAbsolutePath(this._mConfig.path)){t.deregisterPropertyEditor(this,this._mConfig.__propertyName)}};h.prototype.isReady=function(){var t=this.getAggregation("propertyEditor");return t&&t.isReady()||false};h.prototype.hasError=function(){var t=this.getAggregation("propertyEditor");return t&&t.hasError()};h.prototype.ready=function(){return new Promise(function(t){var e=function(e){e.ready().then(t)};var i=this.getAggregation("propertyEditor");if(i){e(i)}else{var r=function(t){var i=t.getParameter("propertyEditor");if(i){this.detachPropertyEditorChange(r,this);e(i)}};this.attachPropertyEditorChange(r,this)}}.bind(this))};h.prototype._onPropertyEditorReady=function(){this.fireReady()};h.prototype._onPropertyEditorError=function(t){this.fireValidationErrorChange({hasError:t.getParameter("hasError")})};h.prototype._initPropertyEditor=function(){if(!this.getEditor()){return}if(this.getConfig()||!this.getBindingInfo("config")&&this.getPropertyName()&&this.getEditor()){if(this._fnCancelInit){this._fnCancelInit().then(this._cleanupCancelledInit);delete this._fnCancelInit}this._mConfig=this.getConfig()||this.getEditor().getPropertyConfigByName(this.getPropertyName());var t=this.getConfig()?p:g;var e=i(function(t,e){o.create(this._mConfig.type).then(t).catch(e)}.bind(this));this._fnCancelInit=e.cancel;if(this._isAbsolutePath(this._mConfig.path)){this.getEditor().registerPropertyEditor(this,this._mConfig.__propertyName)}e.promise.then(function(e){e.setModel(this.getEditor().getModel("i18n"),"i18n");e.setConfig(a(n({},this._mConfig),"__propertyName"));e.attachBeforeValueChange(function(t){this.fireBeforeValueChange(a(t.getParameters(),"id"))},this);e.attachValueChange(function(t){this.setValue(t.getParameter("value"));this.fireValueChange(a(t.getParameters(),"id"))},this);e.attachDesigntimeMetadataChange(function(t){this.fireDesigntimeMetadataChange(a(t.getParameters(),"id"))},this);e.setValue(this.getValue(),true);this._sCreatedBy=t;this.setAggregation("propertyEditor",e);var i=this.getRenderLabel();if(i!==undefined){e.setRenderLabel(i)}e.attachReady(this._onPropertyEditorReady,this);if(e.isReady()){this.fireReady()}e.attachValidationErrorChange(this._onPropertyEditorError,this);if(e.hasError()){this.fireValidationErrorChange({hasError:true})}this.firePropertyEditorChange({propertyEditor:e});delete this._fnCancelInit}.bind(this))}};h.prototype._isAbsolutePath=function(t){return t&&t.startsWith("/")};h.prototype._propagationListener=function(){var t=e(this.getParent(),"sap.ui.integration.designtime.baseEditor.BaseEditor");if(t){this.setEditor(t);this.removePropagationListener(this._propagationListener)}};h.prototype.setParent=function(i){t.prototype.setParent.apply(this,arguments);if(this._bEditorAutoDetect){var r=e(i,"sap.ui.integration.designtime.baseEditor.BaseEditor");if(r){this.setEditor(r)}else{this.addPropagationListener(this._propagationListener)}}};h.prototype.setRenderLabel=function(t){this.setProperty("renderLabel",t);var e=this.getAggregation("propertyEditor");if(e){e.setRenderLabel(t)}};h.prototype.getContent=function(){var t=this.getAggregation("propertyEditor");return t&&t.getContent()};h.prototype.setValue=function(t){this.setProperty("value",t);var e=this.getAggregation("propertyEditor");if(e){e.setValue(t,true)}};h.prototype.getRuntimeConfig=function(){return this._mConfig};h.prototype.enhanceAccessibilityState=function(t,e){var i=this.getParent();if(i&&i.enhanceAccessibilityState){i.enhanceAccessibilityState(this,e)}};h.prototype.getFocusDomRef=function(){var t=this.getAggregation("propertyEditor");if(t){return t.getFocusDomRef()}};h.prototype.getIdForLabel=function(){var t=this.getAggregation("propertyEditor");if(t){return t.getIdForLabel()}};return h});
//# sourceMappingURL=PropertyEditor.js.map