/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/editor/fields/BaseField","sap/m/Text","sap/m/TextArea","sap/m/Input","sap/m/NavContainer","sap/m/Page","sap/m/Popover","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/Button","sap/ui/model/json/JSONModel","sap/ui/table/Table","sap/ui/table/Column","sap/ui/table/rowmodes/Fixed","sap/m/Label","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/base/util/deepEqual","sap/ui/core/Icon","sap/m/Switch","sap/m/CheckBox","sap/m/MessageBox","sap/m/MessageToast","sap/base/util/deepClone","sap/m/Link","sap/ui/layout/form/SimpleForm","sap/base/util/merge","sap/ui/model/Sorter","sap/ui/integration/util/Utils","sap/m/table/columnmenu/Menu","sap/m/ComboBox","sap/ui/core/ListItem"],function(e,t,a,r,o,n,i,l,s,d,u,p,_,c,g,v,f,T,b,h,O,y,P,E,m,I,D,S,L,w,C,x){"use strict";var V=/\{\{(?!parameters.)(?!destinations.)([^\}\}]+)\}\}/g;var A=e.extend("sap.ui.integration.editor.fields.ObjectField",{metadata:{library:"sap.ui.integration",events:{tableUpdated:{}}},renderer:e.getMetadata().getRenderer()});A.prototype.initVisualization=function(e){var t=this;t._newObjectTemplate={_dt:{_selected:true,_uuid:""}};var a=e.visualization;if(!a){if(e.value&&!e.properties&&(!e.values||e.values&&!e.values.metadata)){t.parseValueProperties()}if(e.values){a=t.createTableVisualization(e)}else if(e.properties){a=t.createSimpleFormVisualization(e)}else{a=t.createTextAreaVisualization(e)}e.withLabel=true}this._visualization=a;this.attachAfterInit(this._afterInit)};A.prototype._afterInit=function(){var e=this;var t=this.getAggregation("_field");if(t instanceof I){t.addStyleClass("sapUiIntegrationEditorItemObjectFieldForm");var a=E(e.getConfiguration().value,500)||{};t.setModel(new u({value:a,editMode:"Properties"}))}else if(t instanceof p){t.addStyleClass("sapUiIntegrationEditorItemObjectFieldTable");e._oMenu=new w;var r=t.getColumns();for(var o=0;o<r.length;o++){if(r[o].getFilterProperty()||r[o].getSortProperty()){r[o].setHeaderMenu(e._oMenu.getId())}}}};A.prototype.parseValueProperties=function(){var e=this;var t=e.getConfiguration();if(typeof t.value==="object"&&!T(t.value,{})&&!Array.isArray(t.value)&&!t.properties){var a={};for(var r in t.value){if(r!=="_dt"){var o=typeof t.value[r];var n=o==="string"?{}:{type:o};a[r]=n}}if(!T(a,{})){t.properties=a;t._propertiesParsedFromValue=true}}};A.prototype.createTableVisualization=function(e){var t=this;var a=t.createTableToolbar(e);var r=[];var o=e.values?e.values.data.path||"/":"/value";if(e.values&&e.values.metadata){r={path:"meta>/"+e.values.metadata.namespace+"."+e.values.metadata.entityTypeName,filters:new v({path:"$kind",operator:f.EQ,value1:"Property"}),factory:t.columnFactory.bind(t)}}else{r=t.buildTableColumns()}var n={type:p,settings:{rowMode:new c({rowCount:5}),busy:"{currentSettings>_loading}",busyIndicatorDelay:200,columns:r,selectionBehavior:"RowOnly",rowSelectionChange:t.onTableSelectionChange.bind(t),extension:a,filter:t.onFilter.bind(t)}};if(e.type==="object"){n.settings.rows="{"+o+"}"}else{n.settings.rows="{path: '"+o+"', sorter: {path: '_dt/_position', descending: false}}"}return n};A.prototype.createSimpleFormVisualization=function(e){var t=this;var a=t.getParameterId();var r=t.getResourceBundle();var o=function(){var e=this.getAggregation("_field").getModel();e.checkUpdate(true);var t=e.getProperty("/value")||{};if(!t._dt){t._dt={_uuid:L.generateUuidV4()}}else if(!t._dt._uuid){t._dt._uuid=L.generateUuidV4()}t=E(t,500);this.setValue(t)}.bind(t);var n=t.createFormContents(o,"/value/",false,t.openTranslationPopup);var i=new d(a+"_control_form_editmode_btn",{icon:{path:"/editMode",formatter:function(e){if(e==="Properties"){return"sap-icon://syntax"}else{return"sap-icon://form"}}},tooltip:{path:"/editMode",formatter:function(e){if(e==="Properties"){return r.getText("EDITOR_FIELD_OBJECT_FORM_EDITMODE_JSON")}else{return r.getText("EDITOR_FIELD_OBJECT_FORM_EDITMODE_PROPERTIES")}}},press:function(){var e=t.getAggregation("_field").getModel();var a=e.getProperty("/editMode");if(a==="Properties"){e.setProperty("/editMode","Json")}else{e.setProperty("/editMode","Properties")}}});var u=new d(a+"_control_form_delete_btn",{icon:"sap-icon://delete",tooltip:r.getText("EDITOR_FIELD_OBJECT_DELETE"),visible:e.enabled,enabled:{path:"currentSettings>value",formatter:function(e){if(!e||e===""){return false}return true}},press:function(e){t.setValue(undefined);var a=t.getAggregation("_field").getModel();var r=a.getProperty("/value");if(r&&r._dt&&r._dt._uuid){t.deleteTranslationValueInTexts(undefined,r._dt._uuid)}a.setProperty("/value",{});a.checkUpdate(true)}});var p={type:I,settings:{layout:"ResponsiveGridLayout",visible:e.visible,labelSpanXL:2,labelSpanL:2,labelSpanM:2,labelSpanS:12,emptySpanXL:1,emptySpanL:1,emptySpanM:1,emptySpanS:0,columnsXL:1,columnsL:1,columnsM:1,toolbar:new l({content:[new s,i,u]}).addStyleClass("sapMTB"),content:n}};return p};A.prototype.createTextAreaVisualization=function(e){var t=this;var r={type:a,settings:{value:{path:"currentSettings>value",formatter:function(e){if(!e||e===""){return undefined}e=JSON.stringify(e,null,"\t");if(typeof e==="object"&&!e.length){e=e.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(e){return e.substring(3,e.length-3)})}return e}},editable:"{config/editable}",width:"100%",enabled:"{config/enabled}",placeholder:"{config/placeholder}",visible:e.visible,change:this.onChangeOfTextArea.bind(t),rows:7}};return r};A.prototype.buildSelectionColumnLabels=function(){var e=this;var t=e.getConfiguration();var a=e.getResourceBundle();return new d(e.getParameterId()+"_control_table_column_selection_label_clearall_btn",{icon:"sap-icon://clear-all",type:"Transparent",enabled:typeof t.values==="undefined"?false:"{/_hasSelected}",tooltip:a.getText("EDITOR_FIELD_OBJECT_TABLE_COLUMN_SELECTION_TOOLTIP_REMOVE"),press:e.onUnSelectAll.bind(e)})};A.prototype.buildTableColumns=function(){var e=this;var a=e.getParameterId();var o=e.getConfiguration();var n=[];var i=Object.keys(o.properties);if(i.length>0){var l=e.getResourceBundle();var s=typeof o.values==="undefined"?false:true;if(s){s=typeof o.showSelectionColumn==="undefined"?true:o.showSelectionColumn}var d=e.buildSelectionColumnLabels();var p=new _(a+"_control_table_column_selection",{width:"3.2rem",hAlign:"Center",visible:s,multiLabels:[d],template:new O({selected:"{_dt/_selected}",enabled:typeof o.values==="undefined"?false:true,tooltip:{path:"_dt/_selected",formatter:function(e){if(e){if(o.type==="object"){return l.getText("EDITOR_FIELD_OBJECT_TABLE_COLUMN_SELECTION_CELL_TOOLTIP_UNSELECT")}else{return l.getText("EDITOR_FIELD_OBJECT_LIST_TABLE_COLUMN_SELECTION_CELL_TOOLTIP_REMOVE")}}else if(o.type==="object"){return l.getText("EDITOR_FIELD_OBJECT_TABLE_COLUMN_SELECTION_CELL_TOOLTIP_SELECT")}else{return l.getText("EDITOR_FIELD_OBJECT_LIST_TABLE_COLUMN_SELECTION_CELL_TOOLTIP_ADD")}}},select:e.onSelectionChange.bind(e)})});n.push(p);for(var c in o.properties){var v=a+"_control_table_column_property_"+c;var f=o.properties[c];var T=f.label||c;var y="{"+c+"}";if(f.defaultValue){e._newObjectTemplate[c]=f.defaultValue}var P={width:"7rem",label:T};if(f.column){P=D(P,f.column)}if(P.label.match(V)){P.label="{i18n>"+P.label.substring(2,P.label.length-1)}P.tooltip=P.label;P.label=new g({text:P.label});var I=f.cell&&f.cell.type?f.cell.type:f.type||"Text";var L;var w;var A=E(f.cell)||{};delete A.type;if(I==="string"&&A.values){I="ComboBox"}if(I==="Text"&&A.editable){I="Input"}switch(I){case"int":case"number":w={text:y,wrapping:false};w=D(w,A);L=new t(w);break;case"string":case"Text":w={text:y,wrapping:false};w=D(w,A);var B=w.text;var R=new u({translatable:f.translatable||false,property:c});if(typeof B==="string"){var M=e.getTranslationKey(B);if(M){w.text=l.getText(M)}else if(B.startsWith("{")&&B.endsWith("}")){w.text={path:B.substring(1,B.length-1),formatter:function(t){var a=this.getBindingContext(),r,o=this.getModel("settings").getData(),n=e.getTranslationKey(t);if(o.translatable||n){if(a&&a.getObject()&&a.getObject()._dt){r=e.getTranslationValueInTexts(l.sLocale.replaceAll("_","-"),a.getObject()._dt._uuid,o.property);if(r){return r}}if(n){t=l.getText(n);return t}}return t}}}}w.tooltip=A.tooltip||w.text;L=new t(w);L.setModel(R,"settings");break;case"Icon":w={src:y};w=D(w,A);L=new b(w);break;case"boolean":w={selected:y,enabled:false};w=D(w,A);L=new O(w);break;case"Switch":w={state:y,enabled:false};w=D(w,A);L=new h(w);break;case"Link":w={text:y,target:"_blank",href:y};w=D(w,A);L=new m(w);break;case"ComboBox":w={width:"100%",selectedKey:y,items:{path:"settings>"+A.values.data.path,template:new x(A.values.item)}};if(A.values.sorter){w.items.sorter=[new S({path:A.values.sorter})]}if(A.change){w.change=A.change}var j=new u(A.values.data.json);L=new C(w);L.setModel(j,"settings");break;case"Input":w={value:y};if(A.text){w.value=A.text}w.tooltip=A.tooltip||w.text;L=new r(w);break;default:L=new t({text:y,wrapping:false});break}P.template=L;var U=new _(v,P);n.push(U)}}return n};A.prototype.checkHasFilterDefined=function(e){var t=true;if(e._propertiesParsedFromValue===true){t=false}else{var a=JSON.stringify(e.properties,null,"\t");t=a.indexOf("filterProperty")>-1?true:false}return t};A.prototype.createTableToolbar=function(e){var t=this;var a=t.getParameterId();var r=t.getResourceBundle();var o=t.checkHasFilterDefined(e);var n=e.enabled!==false;var i=e.addButtonText||r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_ADD_TOOLTIP");if(n&&e.values){n=e.values.allowAdd===true}var u=[new s,new d(a+"_control_table_add_btn",{icon:"sap-icon://add",visible:n,tooltip:i,press:t.addNewObject.bind(t)}),new d(a+"_control_table_edit_btn",{icon:"sap-icon://edit",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_EDIT_TOOLTIP"),enabled:"{= !!${/_hasTableSelected}}",visible:t.getAllowPopover(),press:t.onEditOrViewDetail.bind(t)}),new d(a+"_control_table_delete_btn",{icon:"sap-icon://delete",tooltip:r.getText("EDITOR_FIELD_OBJECT_DELETE"),enabled:"{= !!${/_canDelete}}",press:t.onDelete.bind(t)}),new d(a+"_control_table_filter_btn",{icon:"sap-icon://clear-filter",visible:o,enabled:"{= !!${/_hasFilter}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_CLEAR_ALL_FILTERS_TOOLTIP"),press:t.clearAllFilters.bind(t)}),new d(a+"_control_table_multiselect_all_btn",{icon:"sap-icon://multiselect-all",visible:false,enabled:"{= !${/_hasTableAllSelected}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_SELECT_ALL_SELETIONS_TOOLTIP"),press:t.selectAllTableSelections.bind(t)}),new d(a+"_control_table_multiselect_none_btn",{icon:"sap-icon://multiselect-none",visible:false,enabled:"{= !!${/_hasTableSelected}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_CLEAR_ALL_SELETIONS_TOOLTIP"),press:t.clearAllTableSelections.bind(t)})];if(e.type==="object[]"){u=u.concat([new d(a+"_control_table_navigationup_btn",{icon:"sap-icon://navigation-up-arrow",enabled:"{= !!${/_hasOnlyOneRowSelected}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_MOVE_UP_TOOLTIP"),press:t.moveRowUp.bind(t)}),new d(a+"_control_table_navigationdown_btn",{icon:"sap-icon://navigation-down-arrow",enabled:"{= !!${/_hasOnlyOneRowSelected}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_MOVE_DOWN_TOOLTIP"),press:t.moveRowDown.bind(t)})])}return new l({content:u})};A.prototype.onUnSelectAll=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getBindingContext().getPath();var o=a.getModel();var n=o.getProperty(r);n.forEach(function(e){e._dt=e._dt||{};e._dt._selected=false});o.setProperty("/_hasSelected",false);o.checkUpdate(true);t.setValue(undefined)};A.prototype.onEditOrViewDetail=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getSelectedIndices()[0];var o=a.getBinding("rows").getContexts();var n=o[r].getObject();var i=a.getFirstVisibleRow();var l=a.getRows()[r-i];var s=l.getCells()[0];t.openObjectDetailsPopover(n,s,!n._dt||n._dt._editable!==false?"update":"view")};A.prototype.onFilter=function(e){var t=this;var a=t.getAggregation("_field");a.detachEvent("rowsUpdated",t.updateTable,t);a.attachEventOnce("rowsUpdated",t.updateTable,t)};A.prototype.updateTable=function(e){var t=this;t.updateSelectionColumn();t.updateToolbar();t.fireTableUpdated()};A.prototype.updateSelectionColumn=function(){var e=this;var t=e.getAggregation("_field");var a=t.getBinding("rows").getContexts();var r=false;for(var o=0;o<a.length;o++){var n=a[o].getObject();if(n._dt&&n._dt._selected){r=true;break}}t.getModel().setProperty("/_hasSelected",r)};A.prototype.updateToolbar=function(){var e=this;var t=e.getAggregation("_field");var a=t.getColumns();var r=false;for(var o=0;o<a.length;o++){if(a[o].getFiltered()){r=true;break}}t.getModel().setProperty("/_hasFilter",r)};A.prototype.columnFactory=function(e,a){var r=a.getPath();var o=r.substring(a.getPath().lastIndexOf("/")+1);var n=a.getProperty("$Type");var i=a.getProperty("$MaxLength");var l="7rem";i=i?parseInt(i):10;i=i<7?7:i;if(i>50){l="15rem"}else if(i>9){l="10rem"}return new _(e,{visible:true,filterProperty:n&&n.indexOf("String")>=0?o:null,width:l,label:new g({text:o}),hAlign:n&&n.indexOf("Decimal")>=0?"End":"Begin",template:new t({text:{path:o},wrapping:false})})};A.prototype.onTableSelectionChange=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getModel();var o=a.getSelectedIndices();if(o.length>0){r.setProperty("/_hasTableSelected",true);if(o.length===1){r.setProperty("/_hasOnlyOneRowSelected",true)}else{r.setProperty("/_hasOnlyOneRowSelected",false)}}else{r.setProperty("/_hasTableSelected",false);r.setProperty("/_hasOnlyOneRowSelected",false);r.setProperty("/_canDelete",false);return}if(o.length===a.getBinding("rows").getContexts().length){r.setProperty("/_hasTableAllSelected",true)}else{r.setProperty("/_hasTableAllSelected",false)}var n=[];var i=a.getBinding("rows").getContexts();o.forEach(function(e){var t=i[e].getObject();if(t._dt&&t._dt._editable!==false){var a=i[e].getPath();n.push(a)}});if(n.length===0){r.setProperty("/_canDelete",false)}else{r.setProperty("/_canDelete",true)}};A.prototype.selectAllTableSelections=function(e){var t=this;var a=t.getAggregation("_field");a.selectAll();a.getModel().setProperty("/_hasTableAllSelected",true)};A.prototype.clearAllTableSelections=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getModel();a.clearSelection();r.setProperty("/_hasTableSelected",false);r.setProperty("/_hasOnlyOneRowSelected",false);r.setProperty("/_canDelete",false);r.setProperty("/_hasTableAllSelected",false)};A.prototype.moveRowUp=function(e){this.moveSelectedRow("Up")};A.prototype.moveRowDown=function(e){this.moveSelectedRow("Down")};A.prototype.moveSelectedRow=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getModel();var o=a.getSelectedIndices()[0];var n=a.getContextByIndex(o);var i=o+(e==="Up"?-1:1);var l=a.getContextByIndex(i);if(!l){return}var s=l.getProperty("_dt/_position");var d=n.getProperty("_dt/_position");r.setProperty("_dt/_position",s,n);r.setProperty("_dt/_position",d,l);r.refresh(true);a.setSelectedIndex(i);t.refreshValue()};A.prototype.onSelectionChange=function(e){var t=this;var a=e.getSource();var r=e.getParameter("selected");var o=t.getAggregation("_field");var n=o.getBindingContext().getPath();var i=o.getModel();if(r){var l=i.getProperty(n);l.forEach(function(e){e._dt=e._dt||{};e._dt._selected=false});var s=a.getBindingContext().getObject();s._dt._selected=true;var d=E(s);i.setProperty("/_hasSelected",true);t.setValue(d)}else{i.setProperty("/_hasSelected",false);t.setValue(undefined)}};A.prototype.addNewObject=function(e){var t=this;var a=e.getSource();t._newObjectTemplate._dt._uuid=L.generateUuidV4();if(t.getAllowPopover()){t.openObjectDetailsPopover(t._newObjectTemplate,a,"add")}else{t.onAddDirectly(t._newObjectTemplate)}};A.prototype.mergeValueWithRequestResult=function(e){var t=this;var a=t.getConfiguration();var r=t.getAggregation("_field");var o=r.getModel();var n=r.getBinding("rows").getPath();if(a.value&&typeof a.value==="object"&&!T(a.value,{})){var i=E(a.value,500);if(Array.isArray(e)&&e.length>0){if(i._dt&&i._dt._editable===false){var l=i._dt._uuid||L.generateUuidV4();delete i._dt._uuid;e.forEach(function(e){if(T(e,i)){e._dt._selected=true;e._dt._uuid=l}else{e._dt._uuid=L.generateUuidV4()}})}else{e.forEach(function(e){e._dt._uuid=L.generateUuidV4()});i._dt=i._dt||{};i._dt._selected=true;i._dt._uuid=i._dt._uuid||L.generateUuidV4();e.unshift(i)}}else{i._dt=i._dt||{};i._dt._selected=true;i._dt._uuid=i._dt._uuid||L.generateUuidV4();e=[i]}o.setProperty("/_hasSelected",true);o.setProperty(n,e)}else{if(Array.isArray(e)&&e.length>0){e.forEach(function(e){e._dt._uuid=L.generateUuidV4()})}else{o.setProperty(n,{})}o.setProperty("/_hasSelected",false)}o.checkUpdate();t.updateTable()};A.prototype.onChangeOfTextArea=function(e){var t=this;var a=t.getResourceBundle();var r=e.getSource();var o=r.getValue();if(!o||o===""){t.saveValue(undefined,r)}else{try{var n=JSON.parse(o);if(n instanceof Array){r.setValueState("Error");r.setValueStateText(a.getText("EDITOR_VAL_NOT_A_SINGLE_JSONOBJECT"));return}t.saveValue(n,r)}catch(e){r.setValueState("Error");r.setValueStateText(a.getText("EDITOR_VAL_NOT_A_JSONOBJECT"))}}};A.prototype.onChangeOfTextAreaInPopover=function(e){var t=this;var a=t.getResourceBundle();var r=e.getSource();var o=r.getValue();if(!o||o===""){t.saveValue(undefined,r,true)}else{try{var n=JSON.parse(o);if(n instanceof Array){r.setValueState("Error");r.setValueStateText(a.getText("EDITOR_VAL_NOT_A_SINGLE_JSONOBJECT"));return}t.saveValue(n,r,true)}catch(e){r.setValueState("Error");r.setValueStateText(a.getText("EDITOR_VAL_NOT_A_JSONOBJECT"))}}};A.prototype.createFormContents=function(e,t,r,o){var n=this;var i=n.getConfiguration();var l=n.createPropertyContents(e,t,r,o);l.push(new g({visible:false}).addStyleClass("sapFormLabel"));var s=r?n.getParameterId()+"_control_objectdetails_popover_form_textarea":n.getParameterId()+"_control_form_textarea";l.push(new a(s,{value:{path:t,formatter:function(e){if(!e||e===""){return undefined}if(T(e,{})&&!r&&!n._getCurrentProperty("value")){return undefined}e=JSON.stringify(e,null,"\t");if(typeof e==="object"&&!e.length){e=e.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(e){return e.substring(3,e.length-3)})}return e}},editable:i.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",width:"100%",placeholder:"{config/placeholder}",visible:"{= ${/editMode} === 'Json'}",change:r===true?this.onChangeOfTextAreaInPopover.bind(n):this.onChangeOfTextArea.bind(n),rows:r===true?11:7}));return l};A.prototype.createPropertyContents=function(e,t,o,n){var i=this;var l=i.getParameterId();var s=o?l+"_control_objectdetails_popover_form_property_":l+"_control_form_property_";var d=i.getConfiguration();var p=[];if(!t){t="currentSettings>value/"}var _={};if(d.values&&d.values.metadata){var c=i.getModel("meta");var v="/"+d.values.metadata.namespace+"."+d.values.metadata.entityTypeName;var f=c.getProperty(v);for(var b in f){var y=f[b];var P=y["$Type"];if(y["$kind"]==="Property"&&P){if(P.indexOf("Int")>=0){_[b]={type:"int"}}else if(P.indexOf("Boolean")>=0){_[b]={type:"boolean"}}else if(P.indexOf("Decimal")>=0){_[b]={type:"number"}}else{_[b]={type:"string"}}}}}if(T(_,{})){_=d.properties}for(var m in _){var I=_[m];var S=I.label||m;if(S.match(V)){var L=S.substring(2,S.length-2);S="{i18n>"+L+"}"}var w=s+m+"_label";var C=s+m+"_control";var x=new g(w,{text:S,visible:"{= ${/editMode} === 'Properties'}",required:I.required||false});p.push(x);var A;var B=E(I,500);delete B.type;delete B.label;delete B.translatable;delete B.defaultValue;delete B.formatter;delete B.column;delete B.cell;var R;switch(I.type){case"boolean":if(I.cell&&I.cell.type==="Switch"){R={state:"{"+t+m+"}",visible:"{= ${/editMode} === 'Properties'}",enabled:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",change:e};if(I.cell.customTextOn){R.customTextOn=I.cell.customTextOn}if(I.cell.customTextOff){R.customTextOff=I.cell.customTextOff}R=D(R,B);A=new h(C,R)}else{R={selected:"{"+t+m+"}",visible:"{= ${/editMode} === 'Properties'}",enabled:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",select:e};R=D(R,B);A=new O(C,R)}break;case"int":case"integer":R={value:{path:t+m,type:"sap.ui.model.type.Integer",formatOptions:I.formatter},visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",type:"Number",change:e};R=D(R,B);A=new r(C,R);break;case"number":R={value:{path:t+m,type:"sap.ui.model.type.Float",formatOptions:I.formatter},visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",type:"Number",change:e};R=D(R,B);A=new r(C,R);break;case"object":R={value:{path:t+m,formatter:function(e){if(!e||e===""){return undefined}e=JSON.stringify(e,null,"\t");if(typeof e==="object"&&!e.length){e=e.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(e){return e.substring(3,e.length-3)})}return e}},visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",change:e,rows:3};R=D(R,B);A=new a(C,R);break;default:var M=new u({translatable:I.translatable||false,uuidPath:t+"_dt/_uuid",property:m});R={value:"{"+t+m+"}",visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",change:function(t){var a=t.getSource();var r=t.getParameter("value");if(r&&r.match(V)){var o=r.substring(2,r.length-2);r="{i18n>"+o+"}";a.setValue(r);a.fireChange()}else if(e){e(t)}}};R=D(R,B);if(n){R.valueHelpIconSrc="sap-icon://translate";R.valueHelpRequest=n.bind(i,m);if(I.translatable){R.showValueHelp=true}else{R.showValueHelp={path:t+m,formatter:function(e){var t=this.getModel("settings").getData();var a=this.getModel().getProperty(t.uuidPath);var r="translatable";if(i.getTranslationKey(e)){if(!this.getShowValueHelp()&&i.getObjectPropertyConfigValueInDesigntime(a,t.property,r)===false){i.setObjectPropertyConfigValueInDesigntime(a,t.property,r,true)}return true}if(this.getShowValueHelp()){i.deleteTranslationValueInTexts(undefined,a,t.property);i.setObjectPropertyConfigValueInDesigntime(a,t.property,r,false);i._oUpdatedTranslations={}}return false}}}}A=new r(C,R);A.setModel(M,"settings")}p.push(A)}return p};A.prototype.saveValue=function(e,t,a){var r=this;var o;if(!a){r.setValue(e);o=r.getAggregation("_field").getModel();if(o){e=E(e,500);o.setProperty("/value",e||{})}t.setValueState("None");t.setValueStateText("");if(r.getConfiguration()._propertiesParsedFromValue){r.refreshSimpleForm()}}else{o=t.getModel();o.setProperty("/value",e);t.setValueState("None");t.setValueStateText("")}};A.prototype.refreshSimpleForm=function(){var e=this;var t=e.getConfiguration();var a=e.getAggregation("_field");var r=a.removeAllContent().slice(-2);delete t.properties;e.parseValueProperties();var o=function(){var t=a.getModel();t.checkUpdate(true);var r=t.getProperty("/value");r=E(r,500);e.setValue(r)};var n=e.createPropertyContents(o,"/value/");n=n.concat(r);n.forEach(function(e){a.addContent(e)})};A.prototype.getOriginTranslatedValues=function(e){var t=[];var a=this._oEditorResourceBundles.getResourceBundles();for(var r in a){var o=a[r];var n="";var i="";if(e&&o){var l=o.resourceBundle&&o.resourceBundle.getText(e);n=l;i=l}else{n="";i=""}var s={key:r,description:o.language,value:n,originValue:i,editable:true};t.push(s)}return t};A.prototype.buildPropertyTranslationValues=function(e){var t=[];var a=this._oEditorResourceBundles.getResourceBundles();for(var r in a){t.push({key:r,description:a[r].language,value:e,originValue:e,editable:true})}return t};A.prototype.openObjectDetailsPopover=function(e,t,a){var r=this;var p=r.getParameterId();var _=r.getResourceBundle();var c=E(e,500);var g;var v="Right";if(a==="add"){v=this.getPopoverPlacement(t)}if(!r._oObjectDetailsPopover){var f=new d(p+"_control_objectdetails_popover_add_btn",{text:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_ADD"),visible:a==="add",enabled:{path:"/value",formatter:function(e){if(typeof e!=="object"||T(e,{})){return false}else{var t=E(e);delete t._dt;if(T(t,{})){return false}}return true}},press:r.onAdd.bind(r)});var b=new d(p+"_control_objectdetails_popover_update_btn",{text:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_UPDATE"),visible:a==="update",enabled:{path:"/value",formatter:function(e){if(!e||e===""||T(e,{})){return false}return true}},press:r.onUpdate.bind(r)});var h=new d(p+"_control_objectdetails_popover_cancel_btn",{text:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_CANCEL"),visible:a!=="view",press:function(){if(a==="add"){var e=r._oObjectDetailsPopover.getModel().getProperty("/value");r.deleteTranslationValueInTexts(undefined,e._dt._uuid)}r._oObjectDetailsPopover.close()}});var O=new d(p+"_control_objectdetails_popover_close_btn",{text:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_CLOSE"),visible:a==="view",press:function(){r._oObjectDetailsPopover.close()}});var y=new d(p+"_control_objectdetails_popover_editmode_btn",{icon:{path:"/editMode",formatter:function(e){if(e==="Properties"){return"sap-icon://syntax"}else{return"sap-icon://form"}}},tooltip:{path:"/editMode",formatter:function(e){if(e==="Properties"){return _.getText("EDITOR_FIELD_OBJECT_FORM_EDITMODE_JSON")}else{return _.getText("EDITOR_FIELD_OBJECT_FORM_EDITMODE_PROPERTIES")}}},press:function(e){var t=e.getSource();var a=t.getModel();var r=a.getProperty("/editMode");if(r==="Properties"){a.setProperty("/editMode","Json")}else{a.setProperty("/editMode","Properties")}}});var P;r._oNavContainer=new o;r._oObjectDetailsPage=new n({title:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_TITLE"),headerContent:y,footer:new l({content:[new s,f,b,h,O]})});var m=function(e){r._oNavContainer.back();r._oObjectDetailsPage.focus()};var D=r.buildTranslationsList(p+"_control_objectdetails_popover_translation_page_value_list");var S=r.buildTranslationsFooter(D,false);r._oTranslationListPage=new n({title:_.getText("EDITOR_FIELD_OBJECT_TRANSLATION_LIST_TITLE","{languages>/property}"),showNavButton:true,navButtonPress:m,content:D,footer:S});var L=function(e){var t=r._oObjectDetailsPopover.getModel();t.checkUpdate(true);var a=t.getProperty("/value");if(a&&a!==""&&typeof a==="object"&&!T(a,{})){f.setEnabled(true)}else{f.setEnabled(false)}};var w=function(){};if(e._dt&&e._dt._editable===false){P=r.createFormContents(w,"/value/",true,r.navToTranslationPage)}else{P=r.createFormContents(L,"/value/",true,r.navToTranslationPage)}var C=new I({layout:"ResponsiveGridLayout",labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:12,emptySpanXL:1,emptySpanL:1,emptySpanM:1,emptySpanS:0,columnsXL:1,columnsL:1,columnsM:1,content:P});r._oObjectDetailsPage.addContent(C);r._oNavContainer.addPage(r._oObjectDetailsPage);r._oNavContainer.addPage(r._oTranslationListPage);r._oObjectDetailsPopover=new i(p+"_control_objectdetails_popover",{placement:v,showHeader:false,contentWidth:"300px",contentHeight:"345px",modal:true,content:r._oNavContainer}).addStyleClass("sapUiIntegrationEditorItemObjectFieldDetailsPopover");g=new u({value:c,editMode:"Properties"});r._oObjectDetailsPopover.setModel(g);r._oObjectDetailsPopover.setModel(r.getModel("i18n"),"i18n");r._oObjectDetailsPopover._oAddButton=f;r._oObjectDetailsPopover._oUpdateButton=b;r._oObjectDetailsPopover._oCancelButton=h;r._oObjectDetailsPopover._oCloseButton=O;r._oObjectDetailsPopover._openBy=t}else{g=r._oObjectDetailsPopover.getModel();g.setProperty("/value",c);g.checkUpdate(true);if(a==="add"){r._oObjectDetailsPopover._oAddButton.setVisible(true);r._oObjectDetailsPopover._oUpdateButton.setVisible(false);r._oObjectDetailsPopover._oCancelButton.setVisible(true);r._oObjectDetailsPopover._oCloseButton.setVisible(false)}else if(a==="update"){r._oObjectDetailsPopover._oAddButton.setVisible(false);r._oObjectDetailsPopover._oUpdateButton.setVisible(true);r._oObjectDetailsPopover._oCancelButton.setVisible(true);r._oObjectDetailsPopover._oCloseButton.setVisible(false)}else{r._oObjectDetailsPopover._oAddButton.setVisible(false);r._oObjectDetailsPopover._oUpdateButton.setVisible(false);r._oObjectDetailsPopover._oCancelButton.setVisible(false);r._oObjectDetailsPopover._oCloseButton.setVisible(true)}r._oObjectDetailsPopover._openBy=t;r._oObjectDetailsPopover.setPlacement(v);r._oNavContainer.back()}r._oObjectDetailsPopover.openBy(t)};A.prototype.buildTranslationsData=function(e,t,a,r){var o=this;var n=o.getResourceBundle();o._oOriginTranslatedValues=o._oOriginTranslatedValues||{};o._oUpdatedTranslations=o._oUpdatedTranslations||{};var i=a+"_"+r;var l=e;if(t==="key"){if(!o._oOriginTranslatedValues[e]){o._oOriginTranslatedValues[e]=o.getOriginTranslatedValues(e)}}else if(t==="property"){l=i;o._oOriginTranslatedValues[l]=o.buildPropertyTranslationValues(e)}var s=[];o._oOriginTranslatedValues[l].forEach(function(e){var t=E(e,500);t.status=n.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_NOTUPDATED");var i=o.getTranslationValueInTexts(t.key,a,r);if(i){t.value=i;if(Array.isArray(o._oUpdatedTranslations[l])&&o._oUpdatedTranslations[l].includes(t.key)){t.value=o.getTranslationValueInTexts(t.key,a,r);t.status=n.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_UPDATED")}else{t.originValue=t.value}}if(t.key===n.sLocale.replaceAll("_","-")){t.description+=" ("+n.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_CURRENTLANGUAGE")+")";s.unshift(t)}else{s.push(t)}});var d={isUpdated:false,key:e,translationKey:l,translationType:t,uuid:a,property:r,translatedLanguages:s};return d};A.prototype.getTranslationKey=function(e){var t;if(e&&e.match(V)){t=e.substring(2,e.length-2)}else if(e&&e.startsWith("{i18n>")&&e.endsWith("}")){t=e.substring(6,e.length-1)}return t};A.prototype.buildTranslationsFooter=function(e,t){var a=this;var r=a.getParameterId();var o=a.getResourceBundle();var n=o.sLocale.replaceAll("_","-");var i=t?r+"_control_translation_popover":r+"_control_objectdetails_popover_translation_page";var u=new d(i+"_save_btn",{type:"Emphasized",text:o.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_SAVE"),enabled:"{languages>/isUpdated}",press:function(){var r=e.getModel("languages");var o=r.getData();var i=[];var l=o.key;var s=o.translationKey;var d=o.translationType;var u=o.uuid;var p=o.property;o.translatedLanguages.forEach(function(e){if(e.value!==e.originValue){a.setTranslationValueInTexts(e.key,u,p,e.value);i.push(e.key)}});var _=false;if(i.length>0){a._oUpdatedTranslations=a._oUpdatedTranslations||{};a._oUpdatedTranslations[s]=i;if(i.includes(n)){_=true}}o=a.buildTranslationsData(l,d,u,p);r.setData(o);r.checkUpdate(true);if(a.getModel()){a.getModel().checkUpdate(true)}if(_&&a._oValueBinding){a._oValueBinding.fireEvent("change")}if(t){a._oTranslationPopover.close()}}});var p=new d(i+"_reset_btn",{text:o.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_RESET"),enabled:"{languages>/isUpdated}",press:function(t){var a=e.getModel("languages");var r=a.getData();r.translatedLanguages.forEach(function(e){e.value=e.originValue;e.status=o.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_LISTITEM_GROUP_NOTUPDATED")});r.isUpdated=false;a.setData(r);a.checkUpdate(true)}});var _=new d(i+"_cancel_btn",{text:o.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_CANCEL"),visible:t,press:function(){a._oTranslationPopover.close()}});return new l({content:[new s,u,p,_]})};A.prototype.openTranslationPopup=function(e,t){var a=this;var r=t.getSource();var o=a.getResourceBundle();var n=r.getModel().getProperty("/value");if(!n._dt){n._dt={_uuid:L.generateUuidV4()}}else if(!n._dt._uuid){n._dt._uuid=L.generateUuidV4()}var l=r.getValue();var s=a.getTranslationKey(l);var d="property";if(s&&s!==""){d="key"}else{s=l}var u=a.buildTranslationsData(s,d,n._dt._uuid,e);var p;var _=this.getPopoverPlacement(r._oValueHelpIcon);if(!a._oTranslationPopover){var c=a.getParameterId();var g=a.buildTranslationsList(c+"_control_translation_popover_value_list");var v=a.buildTranslationsFooter(g,true);a._oTranslationPopover=new i(c+"_control_translation_popover",{placement:_,contentWidth:"300px",contentHeight:"345px",title:o.getText("EDITOR_FIELD_OBJECT_TRANSLATION_LIST_TITLE","{languages>/property}"),content:g,footer:v}).addStyleClass("sapUiIntegrationFieldTranslation");p=a.buildTranslationsModel(u);a._oTranslationPopover.setModel(p,"languages")}else{a._oTranslationPopover.setPlacement(_);p=a._oTranslationPopover.getModel("languages");p.setData(u);p.checkUpdate(true)}a._oTranslationPopover.openBy(r._oValueHelpIcon)};A.prototype.navToTranslationPage=function(e,t){var a=this;var r=a._oObjectDetailsPopover.getModel().getProperty("/value");var o=r[e];var n=a.getTranslationKey(o);var i="property";if(n&&n!==""){i="key"}else{n=o}var l=a.buildTranslationsData(n,i,r._dt._uuid,e);var s=a._oTranslationListPage.getModel("languages");if(!s){s=a.buildTranslationsModel(l);a._oTranslationListPage.setModel(s,"languages")}else{s.setData(l)}a._oNavContainer.to(a._oTranslationListPage);a._oTranslationListPage.focus()};A.prototype.onAdd=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getModel();var o=t._oObjectDetailsPopover.getModel().getProperty("/value");var n=a.getBinding("rows").getPath();var i=r.getProperty(n);i.forEach(function(e){if(e._dt._selected){e._dt._selected=false}});i.push(o);r.setProperty("/_hasSelected",true);r.setProperty("/_hasTableAllSelected",false);r.setProperty("/_hasTableSelected",false);r.setProperty("/_hasOnlyOneRowSelected",false);r.checkUpdate();t.refreshValue();t.updateTable();t._oObjectDetailsPopover.close()};A.prototype.onAddDirectly=function(e){var t=this;var a=E(e,500);var r=t.getAggregation("_field");var o=r.getModel();var n=r.getBinding("rows").getPath();var i=o.getProperty(n);var l=1;i.unshift(a);i.forEach(function(e){e._dt=e._dt||{};e._dt._selected=false;e._dt._position=l;l++});o.checkUpdate();t.refreshValue();t.updateTable()};A.prototype.onUpdate=function(e){var t=this;var a=t.getAggregation("_field");var r=t._oObjectDetailsPopover.getModel().getProperty("/value");var o=a.getModel();var n=t._oObjectDetailsPopover._openBy.getParent();var i=n.getIndex();var l=a.getBinding("rows").getContexts();var s=l[i].getPath();o.setProperty(s,E(r,500));o.checkUpdate();if(r._dt&&r._dt._selected){t.refreshValue()}t.updateTable();t._oObjectDetailsPopover.close()};A.prototype.onDelete=function(e){var t=this;var a=t.getAggregation("_field");var r=t.getResourceBundle();var o=a.getSelectedIndices();var n=[];var i=a.getBinding("rows").getContexts();o.forEach(function(e){var t=i[e].getObject();if(t._dt&&t._dt._editable!==false){var a=i[e].getPath();var r=a.substring(a.lastIndexOf("/")+1);n.push(r)}});if(n.length===0){y.error(r.getText("EDITOR_FIELD_OBJECT_DELETE_ERROR_MSG"));return}if(t.getAllowPopover()){y.confirm(r.getText("EDITOR_FIELD_OBJECT_DELETE_CONFIRM_MSG"),{title:r.getText("EDITOR_FIELD_OBJECT_DELETE_CONFIRM_TITLE"),onClose:function(e){if(e===y.Action.OK){var o=a.getBindingContext().getPath();var i=a.getModel();var l=i.getProperty(o);var s=[];for(var d=0;d<l.length;d++){if(n.includes(d+"")){t.deleteTranslationValueInTexts(undefined,l[d]._dt._uuid)}else{s.push(l[d])}}i.setProperty(o,s);i.checkUpdate(true);t.refreshValue();t.updateTable()}else{P.show(r.getText("EDITOR_FIELD_OBJECT_DELETE_CONFIRM_CANCLE"))}}})}else{var l=a.getBinding("rows").getPath();var s=a.getModel();var d=s.getProperty(l);var u=[];for(var p=0;p<d.length;p++){if(n.includes(p+"")){t.deleteTranslationValueInTexts(undefined,d[p]._dt._uuid)}else{u.push(d[p])}}s.setProperty(l,u);s.checkUpdate(true);t.refreshValue();t.updateTable()}};A.prototype.refreshValue=function(){var e=this;var t=e.getAggregation("_field");var a=t.getModel();var r=t.getBinding("rows").getPath();var o=a.getProperty(r);var n;for(var i=0;i<o.length;i++){var l=o[i];if(l._dt._selected){n=E(l);break}}e.setValue(n)};A.prototype.resetControl=function(){var e=this;var t=e.getAggregation("_field");var a=e._getCurrentProperty("value");var r=t.getModel();if(t instanceof I){var o=r.getProperty("/value");if(o&&o._dt&&o._dt._uuid){e.deleteTranslationValueInTexts(undefined,o._dt._uuid)}a=a||{};r.setProperty("/value",a);r.checkUpdate(true)}else if(t instanceof p){var n=e.getConfiguration();var i;if(n.values){var l=t.getBinding("rows").getPath();i=r.getProperty(l);i.forEach(function(e){delete e._dt._selected})}e.mergeValueWithRequestResult(i)}};A.prototype.clearAllFilters=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getColumns();for(var o=0;o<r.length;o++){var n=r[o];if(o<r.length-1){n._applySelection=false}a.filter(n,undefined)}};A.prototype.setValue=function(e){var t=this;t.cleanDT(e);t._setCurrentProperty("value",e)};A.prototype.cleanDT=function(e){if(e&&e._dt&&e._dt._selected){delete e._dt._selected}if(e&&e._dt&&T(e._dt,{})){delete e._dt}};A.prototype.getTranslationValueInTexts=function(e,t,a){var r=this;var o=r.getConfiguration();var n="/texts/"+e;var i=this._settingsModel.getProperty(n)||{};var l=i[o.manifestpath];var s;if(l&&l[t]){s=l[t][a]}return s};A.prototype.setObjectPropertyConfigValueInDesigntime=function(e,t,a,r){var o=this;var n=o.getConfiguration();var i="/:designtime";var l=this._settingsModel.getData();if(!l){return}var s;if(!l.hasOwnProperty(":designtime")){s={}}else{s=E(l[":designtime"],500)}if(!s.hasOwnProperty(n.manifestpath)){s[n.manifestpath]={}}if(!s[n.manifestpath].hasOwnProperty(e)){s[n.manifestpath][e]={}}if(!s[n.manifestpath][e].hasOwnProperty(t)){s[n.manifestpath][e][t]={}}s[n.manifestpath][e][t][a]=r;this._settingsModel.setProperty(i,s)};A.prototype.getObjectPropertyConfigValueInDesigntime=function(e,t,a){var r=this;var o;var n=r.getConfiguration();var i=this._settingsModel.getData();if(i&&i[":designtime"]&&i[":designtime"][n.manifestpath]&&i[":designtime"][n.manifestpath][e]&&i[":designtime"][n.manifestpath][e][t]&&i[":designtime"][n.manifestpath][e][t].hasOwnProperty(a)){o=i[":designtime"][n.manifestpath][e][t][a]}return o};A.prototype.setTranslationValueInTexts=function(e,t,a,r){var o=this;var n=o.getConfiguration();var i="/texts";var l=this._settingsModel.getData();if(!l){return}var s;if(!l.hasOwnProperty("texts")){s={}}else{s=E(l.texts,500)}if(!s.hasOwnProperty(e)){s[e]={}}if(!s[e].hasOwnProperty(n.manifestpath)){s[e][n.manifestpath]={}}if(!s[e][n.manifestpath].hasOwnProperty(t)){s[e][n.manifestpath][t]={}}s[e][n.manifestpath][t][a]=r;this._settingsModel.setProperty(i,s)};A.prototype.deleteTranslationValueInTexts=function(e,t,a){var r=this;var o=r._settingsModel.getData();if(!o||!o.texts||!t){return}var n=r.getConfiguration();var i="/texts";var l=E(o.texts,500);if(e){if(l[e]&&l[e][n.manifestpath]&&l[e][n.manifestpath][t]){if(a){if(l[e][n.manifestpath][t].hasOwnProperty(a)){delete l[e][n.manifestpath][t][a];if(T(l[e][n.manifestpath][t],{})){delete l[e][n.manifestpath][t]}this._settingsModel.setProperty(i,l)}}else{delete l[e][n.manifestpath][t];if(T(l[e][n.manifestpath],{})){delete l[e][n.manifestpath];if(T(l[e],{})){delete l[e]}}this._settingsModel.setProperty(i,l)}}}else{for(var s in l){r.deleteTranslationValueInTexts(s,t,a)}}};return A});
//# sourceMappingURL=ObjectField.js.map