/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/util/RequestDataProvider","sap/base/Log","sap/ui/core/Core","sap/base/util/deepExtend","sap/ui/core/date/UI5Date"],function(e,t,a,s,i){"use strict";var r=31536e3;function n(e){var t=e.url,a=e.data,s,i;if(e.method!=="GET"){return e.url}s=new URL(t,window.location.href);for(i in a){s.searchParams.set(i,a[i])}return s.href}var o=e.extend("sap.ui.integration.util.CacheAndRequestDataProvider");o.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oRefreshWithoutCacheBound=this.refreshWithoutCache.bind(this)};o.prototype.destroy=function(){this._unsubscribeFromHostMessages();this._detachTimestampPress();e.prototype.destroy.apply(this,arguments)};o.prototype.getHostInstance=function(){return a.byId(this.getHost())};o.prototype.getCardInstance=function(){return a.byId(this.getCard())};o.prototype.getCardInstanceHeader=function(){var e=this.getCardInstance();if(!e){return null}return e.getCardHeader()};o.prototype.onDataRequestComplete=function(){var e;if(this._iUpdateIntervalTimeout){clearTimeout(this._iUpdateIntervalTimeout);this._iUpdateIntervalTimeout=null}if(!this.getSettings()||!this.getSettings().updateInterval){return}e=parseInt(this.getSettings().updateInterval);if(isNaN(e)){return}this._iUpdateIntervalTimeout=setTimeout(function(){this.refreshWithoutCache()}.bind(this),e*1e3)};o.prototype._request=function(t){var a,s=this.getCardInstanceHeader();this._sCurrentRequestFullUrl=n(t.url);this._subscribeToHostMessages();a=e.prototype._request.apply(this,arguments);a.then(function(e){var t=e[1],a=t.headers.get("Date");if(a&&s){this._attachTimestampPress();s.setDataTimestamp(i.getInstance(a).toISOString())}}.bind(this));return a};o.prototype.refreshWithoutCache=function(){var e=this.getCardInstanceHeader();if(e){e.setDataTimestampUpdating(true)}setTimeout(function(){this._bCacheOnly=false;this._bNoCache=true;this._triggerDataUpdate()}.bind(this),200)};o.prototype.refreshFromCache=function(){var e=this.getCardInstanceHeader();if(e){e.setDataTimestampUpdating(true)}setTimeout(function(){this._bCacheOnly=true;this._bNoCache=false;this._triggerDataUpdate()}.bind(this),200)};o.prototype._modifyRequestBeforeSent=function(t,a){a.request=this._addCacheSettings(a.request);return e.prototype._modifyRequestBeforeSent.call(this,t,a)};o.prototype._addCacheSettings=function(e){var t={cache:{enabled:true,maxAge:0,staleWhileRevalidate:true}},a=s(t,e),i=a.cache;if(i.noStore){i.enabled=false}if(i.enabled){if(this._bCacheOnly){i.maxAge=r;i.staleWhileRevalidate=false}else if(this._bNoCache){i.maxAge=0;i.staleWhileRevalidate=false}}return a};o.prototype._getRequestSettings=function(){return this._addCacheSettings(this.getSettings().request)};o.prototype._subscribeToHostMessages=function(){var e=this.getHostInstance();if(this._bIsSubscribed){return}if(!e){return}e.attachMessage(this._handleHostMessage,this);this._bIsSubscribed=true};o.prototype._unsubscribeFromHostMessages=function(){var e=this.getHostInstance();if(!e){return}e.detachMessage(this._handleHostMessage,this);this._bIsSubscribed=false};o.prototype._handleHostMessage=function(e){var a=e.getParameter("data");if(a.type!=="ui-integration-card-update"){return}if(a.url!==this._sCurrentRequestFullUrl){return}t.info("[CARDS CACHE] message ui-integration-card-update received for "+a.url);this.refreshFromCache()};o.prototype._attachTimestampPress=function(e){var t=this.getCardInstance(),a=this.getCardInstanceHeader();if(this._oHeaderDelegate){return}if(!a){return}this._oHeaderDelegate={onBeforeRendering:function(){var e=t.$().find(".sapFCardDataTimestamp");e.off("click",this._oRefreshWithoutCacheBound)}.bind(this),onAfterRendering:function(){var e=t.$().find(".sapFCardDataTimestamp");e.on("click",this._oRefreshWithoutCacheBound)}.bind(this)};a.addEventDelegate(this._oHeaderDelegate)};o.prototype._detachTimestampPress=function(e){var t=this.getCardInstance(),a=this.getCardInstanceHeader(),s=t&&t.$().find(".sapFCardDataTimestamp");if(!a){return}s.off("click",this._oRefreshWithoutCacheBound);a.removeEventDelegate(this._oHeaderDelegate);this._oHeaderDelegate=null};return o});
//# sourceMappingURL=CacheAndRequestDataProvider.js.map