/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/CustomData","./library","sap/ui/core/library","sap/ui/core/ResizeHandler","sap/ui/core/RenderManager","./SplitterRenderer","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/layout/SplitterLayoutData","sap/ui/core/Configuration"],function(e,t,i,r,s,a,o,n,jQuery,h,u){"use strict";var l=r.Orientation;var d=16;var c=e.extend("sap.ui.layout.Splitter",{metadata:{library:"sap.ui.layout",properties:{orientation:{type:"sap.ui.core.Orientation",group:"Behavior",defaultValue:l.Horizontal},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"}},defaultAggregation:"contentAreas",aggregations:{contentAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"contentArea"}},events:{resize:{parameters:{id:{type:"string"},oldSizes:{type:"int[]"},newSizes:{type:"int[]"}}}},designtime:"sap/ui/layout/designtime/Splitter.designtime"},renderer:o});c.prototype.init=function(){this._liveResize=true;this._keyboardEnabled=true;this._bHorizontal=true;this._calculatedSizes=[];this._move={};this._resizeTimeout=null;this._resizeCallback=function(e){this._delayedResize(0)}.bind(this);this._resizeHandlerId=null;this._autoResize=true;this.enableAutoResize();this._boundBarMoveEnd=this._onBarMoveEnd.bind(this);this._boundBarMove=this._onBarMove.bind(this);this._initOrientationProperties();this._bRtl=u.getRTL();this._keyListeners={increase:this._onKeyboardResize.bind(this,"inc",20),decrease:this._onKeyboardResize.bind(this,"dec",20),increaseMore:this._onKeyboardResize.bind(this,"incMore",20),decreaseMore:this._onKeyboardResize.bind(this,"decMore",20),max:this._onKeyboardResize.bind(this,"max",20),min:this._onKeyboardResize.bind(this,"min",20)};this._enableKeyboardListeners()};c.prototype.exit=function(){this.disableAutoResize();delete this._resizeCallback;delete this._boundBarMoveEnd;delete this._boundBarMove;delete this._$SplitterOverlay;delete this._$SplitterOverlayBar};c.prototype.onBeforeRendering=function(){this._initOrientationProperties()};c.prototype.onAfterRendering=function(){this._$SplitterOverlay=this.$("overlay");this._$SplitterOverlayBar=this.$("overlayBar");this._resize()};c.prototype.triggerResize=function(e){if(e){this._resize()}else{this._delayedResize()}};c.prototype.resetContentAreasSizes=function(){var e=this._getContentAreas();for(var t=0;t<e.length;t++){e[t].getLayoutData().setSize("auto")}};c.prototype.getCalculatedSizes=function(){return this._calculatedSizes};c.prototype.enableAutoResize=function(e){if(e&&!this._autoResize){return}this._autoResize=true;var t=this;sap.ui.getCore().attachInit(function(){t._resizeHandlerId=s.register(t,t._resizeCallback)});this._delayedResize()};c.prototype.disableAutoResize=function(e){s.deregister(this._resizeHandlerId);if(!e){this._autoResize=false}};c.prototype.enableLiveResize=function(){this._liveResize=true;this.removeStyleClass("sapUiLoSplitterAnimated")};c.prototype.disableLiveResize=function(){this._liveResize=false;this.addStyleClass("sapUiLoSplitterAnimated")};c.prototype.enableKeyboardSupport=function(){var e=this.$().find(".sapUiLoSplitterBar");e.attr("tabindex","0");this._enableKeyboardListeners()};c.prototype.disableKeyboardSupport=function(){var e=this.$().find(".sapUiLoSplitterBar");e.attr("tabindex","-1");this._disableKeyboardListeners()};c.prototype.onLayoutDataChange=function(){this._delayedResize()};c.prototype.ontouchstart=function(e){if(this._ignoreTouch){return}var t=this._getBar(e.target);if(!t){return}if(!e.changedTouches||!e.changedTouches[0]){return}this._ignoreMouse=true;this._onBarMoveStart(e.changedTouches[0],t,true)};c.prototype.onmousedown=function(e){if(this._ignoreMouse){return}var t=this._getBar(e.target);if(!t){return}this._ignoreTouch=true;this._onBarMoveStart(e,t);this._oLastDOMclicked=t};c.prototype._onBarMoveStart=function(e,t,i){var r=this.getId();this.disableAutoResize(true);var s=e[this._moveCord];var a=parseInt(t.id.substr((r+"-splitbar-").length));var o=jQuery(t);var n=this.getCalculatedSizes();var h=this._bHorizontal?o.outerWidth():o.outerHeight();var u=this._getContentAreas();var l=u[a].getLayoutData();var d=u[a+1].getLayoutData();if(!l.getResizable()||!d.getResizable()){v(i);return}var c=0-h;for(var p=0;p<=a;++p){c+=n[p]+h}this._move={start:s,relStart:c,barNum:a,$bar:o,c1Size:n[a],c1MinSize:l.getMinSize(),c2Size:n[a+1],c2MinSize:d.getMinSize()};if(i){document.addEventListener("touchend",this._boundBarMoveEnd);document.addEventListener("touchmove",this._boundBarMove)}else{document.addEventListener("mouseup",this._boundBarMoveEnd);document.addEventListener("mousemove",this._boundBarMove)}this._$SplitterOverlay.css("display","block");this._$SplitterOverlayBar.css(this._sizeDirNot,"");this._move.$bar.css("visibility","hidden");this._onBarMove(e)};c.prototype._onBarMove=function(e){if(e.preventDefault&&!e.changedTouches){e.preventDefault()}var t=e;if(e.changedTouches&&e.changedTouches[0]){t=t.changedTouches[0]}var i=t[this._moveCord];var r=i-this._move.start;if(this.getOrientation()==l.Horizontal&&this._bRtl){r=-r}var s=this._move.c1Size+r;var a=this._move.c2Size-r;var o=s>=0&&a>=0&&s>=this._move.c1MinSize&&a>=this._move.c2MinSize;if(o){this._$SplitterOverlayBar.css(this._sizeDir,this._move.relStart+r);if(this._liveResize){var n=this._move["start"]-t[this._moveCord];if(this.getOrientation()==l.Horizontal&&this._bRtl){n=-n}this._resizeContents(this._move["barNum"],-n,false)}}};c.prototype._onBarMoveEnd=function(e){this._ignoreMouse=false;this._ignoreTouch=false;var t=e;if(e.changedTouches&&e.changedTouches[0]){t=t.changedTouches[0]}var i=t[this._moveCord];var r=this._move["start"]-i;if(this.getOrientation()==l.Horizontal&&this._bRtl){r=-r}this._resizeContents(this._move["barNum"],-r,true);this._move.$bar.css("visibility","");this._$SplitterOverlay.css("display","");document.removeEventListener("mouseup",this._boundBarMoveEnd);document.removeEventListener("mousemove",this._boundBarMove);document.removeEventListener("touchend",this._boundBarMoveEnd);document.removeEventListener("touchmove",this._boundBarMove);this.enableAutoResize(true);if(this._move.$bar){this._move.$bar.trigger("focus")}};c.prototype._resizeContents=function(e,t,i){if(isNaN(t)){n.warning("Splitter: Received invalid resizing values - resize aborted.");return}var r=this._getContentAreas();var s=r[e].getLayoutData();var a=r[e+1].getLayoutData();var o=s.getSize();var h=a.getSize();var u=this.$("content-"+e);var l=this.$("content-"+(e+1));var d=parseFloat(this._move.c1Size).toFixed(5);var c=parseFloat(this._move.c2Size).toFixed(5);var p=parseFloat(d)+t;var v=parseFloat(c)-t;var _=parseInt(s.getMinSize());var f=parseInt(a.getMinSize());var g,z;var y;if(p<_){y=_-p;t+=y;p=_;v-=y}else if(v<f){y=f-v;t-=y;v=f;p-=y}if(i){var b=this._calcAvailableContentSize();if(o==="auto"&&h!=="auto"){z=this._calcAreaSizeWithUnit(v,b,a._getSizeUnit());a.setSize(z);a._markModified()}else if(o!=="auto"&&h==="auto"){g=this._calcAreaSizeWithUnit(p,b,s._getSizeUnit());s.setSize(g);s._markModified()}else{g=this._calcAreaSizeWithUnit(p,b,s._getSizeUnit());z=this._calcAreaSizeWithUnit(v,b,a._getSizeUnit());s.setSize(g);a.setSize(z);s._markModified();a._markModified()}}else{var S=this._getTotalSize();g=this._pxToPercent(p,S);z=this._pxToPercent(v,S);u.css(this._sizeType,g);l.css(this._sizeType,z)}};c.prototype._calcAreaSizeWithUnit=function(e,t,i){if(i==="px"){return e+"px"}if(i==="rem"){return e/d+"rem"}return this._pxToPercent(e,t)};c.prototype._pxToPercent=function(e,t){return e*100/t+"%"};c.prototype._delayedResize=function(e){if(e===undefined){e=0}if(this.getDomRef()){clearTimeout(this._resizeTimeout);this._resizeTimeout=setTimeout(this._resize.bind(this),e)}};c.prototype._resizeBars=function(e){var t,i,r=this._bHorizontal?this.$().innerHeight():this.$().innerWidth();for(t=0;t<e.length-1;++t){i=this.$("splitbar-"+t);i.css(this._sizeTypeNot,"")}for(t=0;t<e.length-1;++t){i=this.$("splitbar-"+t);i.css(this._sizeType,"");i.css(this._sizeTypeNot,r+"px")}};c.prototype._resize=function(){var e=this.getDomRef();if(!e||a.getPreserveAreaRef().contains(e)||e.scrollHeight===0||e.scrollWidth===0){return}var t=0,i;var r=this._getContentAreas();this._resizeBars(r);var s=this.getCalculatedSizes();this._recalculateSizes();var o=this.getCalculatedSizes();var n=false;for(t=0;t<o.length;++t){if(o[t]!==0){n=true;break}}if(!n){this._delayedResize(100);return}var h=true;for(t=0;t<r.length;++t){var u=this.$("content-"+t);var l=r[t];u.css(this._sizeType,o[t]+"px");u.css(this._sizeTypeNot,"");var d=l.getLayoutData();var c=d&&d.getResizable();if(t>0){var v=c&&h;i=this.$("splitbar-"+(t-1));i.toggleClass("sapUiLoSplitterNoResize",!v);i.attr("tabindex",v&&this._keyboardEnabled?"0":"-1")}h=c}this._resizeBars(r);if(p(s,o)){this.fireResize({oldSizes:s,newSizes:o})}};c.prototype._getTotalSize=function(){return this._bHorizontal?this.$().innerWidth():this.$().innerHeight()};c.prototype._calcAvailableContentSize=function(){return this._getTotalSize()-this._calcBarsSize()};c.prototype._calcBarsSize=function(){var e=0,t=this._getContentAreas().length-1;for(var i=0;i<t;i++){e+=this._bHorizontal?this.$("splitbar-"+i).outerWidth():this.$("splitbar-"+i).outerHeight()}return e};c.prototype._recalculateSizes=function(){var e,t,i,r;var s=[];var a=this._getContentAreas();var o=this._calcAvailableContentSize();var h=[];var u=[];var l=[];this._calculatedSizes=[];for(e=0;e<a.length;++e){s.push(a[e].getLayoutData().getSize())}for(e=0;e<s.length;++e){var c=s[e];var p;if(c.indexOf("rem")>-1){p=parseFloat(c)*d;o-=p;this._calculatedSizes[e]=p}else if(c.indexOf("px")>-1){p=parseInt(c);o-=p;this._calculatedSizes[e]=p}else if(c.indexOf("%")>-1){l.push(e)}else if(c==="auto"){if(a[e].getLayoutData().getMinSize()!==0){u.push(e)}else{h.push(e)}}else{n.error("Illegal size value: "+s[e])}}var v=false;if(o<0){v=true;o=0}o=this._calcPercentBasedSizes(l,o);if(o<0){v=true;o=0}var _=Math.floor(o/(u.length+h.length),0);for(e=0;e<u.length;++e){t=_;i=u[e];r=a[i].getLayoutData().getMinSize();if(t>o){t=o}if(t<r){t=r}this._calculatedSizes[i]=t;o-=t}if(o<0){v=true;o=0}var f=h.length;_=Math.floor(o/f,0);for(e=0;e<f;++e){i=h[e];this._calculatedSizes[i]=_;o-=_}if(v){this._logConstraintsViolated()}};c.prototype._calcPercentBasedSizes=function(e,t){var i=this._getContentAreas(),r=this._calcAvailableContentSize();for(let n=0;n<e.length;++n){var s=e[n];var a=parseFloat(i[s].getLayoutData().getSize())/100*r;var o=i[s].getLayoutData().getMinSize();if(a<o){a=o}this._calculatedSizes[s]=a;t-=a}var n=i.filter(function(e){return e.getLayoutData().getSize()==="auto"}).reduce(function(e,t){return e+t.getLayoutData().getMinSize()},0);if(t<n){var h=Math.abs(t-n);for(var u=e.length-1;u>=0;u--){var l=e[u],d=i[l],c=this._calculatedSizes[l],p=d.getLayoutData();if(p._isMarked()){var v=c-h;if(v<p.getMinSize()){v=p.getMinSize()}this._calculatedSizes[l]=v;var _=c-v;h-=_;t+=_}if(h<=0){break}}}return t};c.prototype._logConstraintsViolated=function(){n.warning("The set sizes and minimal sizes of the splitter contents are bigger than the available space in the UI.",null,"sap.ui.layout.Splitter")};c.prototype._initOrientationProperties=function(){this._bHorizontal=this.getOrientation()===l.Horizontal;if(this._bHorizontal){this._sizeDirNot="top";this._sizeTypeNot="height";this._sizeType="width";this._moveCord="pageX";if(this._bRtl){this._sizeDir="right"}else{this._sizeDir="left"}}else{this._moveCord="pageY";this._sizeType="height";this._sizeTypeNot="width";this._sizeDir="top";this._sizeDirNot="left"}};c.prototype._onKeyboardResize=function(e,t,i){var r=this.getId()+"-splitbar-";if(!i||!i.target||!i.target.id||i.target.id.indexOf(r)!==0){return}var s=999999;var a=parseInt(i.target.id.substr(r.length));var o=this.getCalculatedSizes();this._move.c1Size=o[a];this._move.c2Size=o[a+1];var h=0;switch(e){case"inc":h=t;break;case"incMore":h=t*10;break;case"dec":h=0-t;break;case"decMore":h=0-t*10;break;case"max":h=s;break;case"min":h=0-s;break;default:n.warn("[Splitter] Invalid keyboard resize type");break}this._resizeContents(a,h,true)};c.prototype._enableKeyboardListeners=function(){this.onsapright=this._keyListeners.increase;this.onsapdown=this._keyListeners.increase;this.onsapleft=this._keyListeners.decrease;this.onsapup=this._keyListeners.decrease;this.onsappageup=this._keyListeners.decreaseMore;this.onsappagedown=this._keyListeners.increaseMore;this.onsapend=this._keyListeners.max;this.onsaphome=this._keyListeners.min;this._keyboardEnabled=true};c.prototype._disableKeyboardListeners=function(){delete this.onsapincreasemodifiers;delete this.onsapdecreasemodifiers;delete this.onsapendmodifiers;delete this.onsaphomemodifiers;this._keyboardEnabled=false};c.prototype._getBar=function(e){var t=e,i=this.getId();if(t.classList.contains("sapUiLoSplitterBarGripIcon")){t=e.parentElement}if(t.classList.contains("sapUiLoSplitterBarDecorationBefore")||t.classList.contains("sapUiLoSplitterBarDecorationAfter")||t.classList.contains("sapUiLoSplitterBarGrip")){t=t.parentElement}if(!t.id||t.id.indexOf(i+"-splitbar")!==0){return null}return t};function p(e,t){if(e===t){return false}if(!e||!t||e.length===undefined||t.length===undefined){return true}if(e.length!=t.length){return true}for(var i=0;i<e.length;++i){if(e[i]!==t[i]){return true}}return false}function v(e){var t=function(t){if(!e){t.preventDefault()}};var i=null;i=function(){document.removeEventListener("touchend",i);document.removeEventListener("touchmove",t);document.removeEventListener("mouseup",i);document.removeEventListener("mousemove",t)};if(e){this._ignoreMouse=true;document.addEventListener("touchend",i);document.addEventListener("touchmove",t)}else{document.addEventListener("mouseup",i);document.addEventListener("mousemove",t)}}c.prototype._ensureLayoutData=function(e){var t=e.getLayoutData();if(t&&(!t.getResizable||!t.getSize||!t.getMinSize)){n.warning('Content "'+e.getId()+'" for the Splitter contained wrong LayoutData. '+"The LayoutData has been replaced with default values.");t=null}if(!t){e.setLayoutData(new h)}};c.prototype.invalidate=function(i){var r=i&&this.indexOfContentArea(i)!=-1||i&&i instanceof t&&i.getWriteToDom()||i===undefined;if(r){e.prototype.invalidate.apply(this,arguments)}};c.prototype.addContentArea=function(e){this._ensureLayoutData(e);return this.addAggregation("contentAreas",e)};c.prototype.insertContentArea=function(e,t){this._ensureLayoutData(e);return this.insertAggregation("contentAreas",e,t)};c.prototype._getContentAreas=function(){return this.getContentAreas()};return c});
//# sourceMappingURL=Splitter.js.map