/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Core","sap/ui/mdc/ActionToolbar","sap/m/OverflowToolbarRenderer","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarToggleButton","sap/m/Title","sap/ui/mdc/chart/ChartTypeButton","./ChartSelectionDetails","sap/ui/core/InvisibleText","sap/m/OverflowToolbarLayoutData","sap/ui/core/library","sap/ui/Device","sap/ui/core/ShortcutHintsMixin","sap/ui/mdc/enums/ChartToolbarActionType"],function(t,e,n,o,i,a,s,r,l,h,c,d,g,u){"use strict";const p=c.aria.HasPopup;const _=e.extend("sap.ui.mdc.chart.ChartToolbar",{metadata:{library:"sap.ui.mdc",interfaces:[],defaultAggregation:"",properties:{},aggregations:{},associations:{},events:{}},renderer:n});const T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");_.prototype.init=function(){e.prototype.init.apply(this,arguments)};_.prototype.createToolbarContent=function(t){this._oChart=t;this._chartInternalButtonsToEnable=[];this._oInvTitle=new l(t.getId()+"-invTitle",{text:t.getHeader()});this._oInvTitle.toStatic();this.addAriaLabelledBy(this._oInvTitle);this._oTitle=new a(t.getId()+"-title",{text:t.getHeader(),level:t.getHeaderLevel(),titleStyle:t.getHeaderStyle(),visible:t.getHeaderVisible()});this.addBegin(this._oTitle);if(t.getAggregation("variant")){this.addVariantManagement(t.getAggregation("variant"))}if(t.getShowSelectionDetails()){this._oChartSelectionDetails=new r(t.getId()+"-selectionDetails",{});this._oChartSelectionDetails.attachBeforeOpen(function(e){this._updateSelectionDetailsActions(t)}.bind(this));this.addEnd(this._oChartSelectionDetails)}const e=t.getP13nMode()||[];if(e.indexOf("Item")>-1&&(!t.getIgnoreToolbarActions().length||t.getIgnoreToolbarActions().indexOf(u.DrillDownUp)<0)){this._oDrillDownBtn=new o(t.getId()+"-drillDown",{icon:"sap-icon://drill-down",tooltip:T.getText("chart.CHART_DRILLDOWN_TITLE"),text:T.getText("chart.CHART_DRILLDOWN_TITLE"),enabled:false,ariaHasPopup:p.ListBox,layoutData:new h({closeOverflowOnInteraction:false}),press:function(e){t._showDrillDown(this._oDrillDownBtn)}.bind(this)});this.addEnd(this._oDrillDownBtn);this._chartInternalButtonsToEnable.push(this._oDrillDownBtn)}if(!t.getIgnoreToolbarActions().length||t.getIgnoreToolbarActions().indexOf(u.Legend)<0){this._oLegendBtn=new i(t.getId()+"btnLegend",{type:"Transparent",text:T.getText("chart.LEGENDBTN_TEXT"),tooltip:T.getText("chart.LEGENDBTN_TOOLTIP"),icon:"sap-icon://legend",pressed:"{$mdcChart>/legendVisible}",enabled:false});this.addEnd(this._oLegendBtn);this._chartInternalButtonsToEnable.push(this._oLegendBtn)}if(!t.getIgnoreToolbarActions().length||t.getIgnoreToolbarActions().indexOf(u.ZoomInOut)){this.oZoomInButton=new o(t.getId()+"btnZoomIn",{icon:"sap-icon://zoom-in",tooltip:T.getText("chart.TOOLBAR_ZOOM_IN"),text:T.getText("chart.TOOLBAR_ZOOM_IN"),enabled:false,press:function e(n){t.zoomIn();this.toggleZoomButtons(t)}.bind(this)});this.oZoomOutButton=new o(t.getId()+"btnZoomOut",{icon:"sap-icon://zoom-out",tooltip:T.getText("chart.TOOLBAR_ZOOM_OUT"),text:T.getText("chart.TOOLBAR_ZOOM_OUT"),enabled:false,press:function e(n){t.zoomOut();this.toggleZoomButtons(t)}.bind(this)});this.addEnd(this.oZoomInButton);this.addEnd(this.oZoomOutButton)}if(e.indexOf("Sort")>-1||e.indexOf("Item")>-1||e.indexOf("Filter")>-1){this._oSettingsBtn=new o(t.getId()+"-chart_settings",{icon:"sap-icon://action-settings",tooltip:T.getText("chart.SETTINGS"),text:T.getText("chart.SETTINGS"),enabled:false,press:function(e){const n=t.getP13nMode();const o=n.indexOf("Type");if(o>-1){n.splice(o,1)}if(t.isPropertyHelperFinal()){t.getEngine().show(t,n)}else{t.finalizePropertyHelper().then(function(){t.getEngine().show(t,n)})}}});g.addConfig(this._oSettingsBtn,{addAccessibilityLabel:true,messageBundleKey:d.os.macintosh?"mdc.PERSONALIZATION_SHORTCUT_MAC":"mdc.PERSONALIZATION_SHORTCUT"},this);this.addEnd(this._oSettingsBtn);this._chartInternalButtonsToEnable.push(this._oSettingsBtn)}if(t._getTypeBtnActive()){this._oChartTypeBtn=new s(this.getId()+"-btnChartType",{type:"Transparent",enabled:false,ariaHasPopup:p.ListBox,layoutData:new h({closeOverflowOnInteraction:false}),chart:t});this.addEnd(this._oChartTypeBtn);this._chartInternalButtonsToEnable.push(this._oChartTypeBtn)}this._updateVariantManagement()};_.prototype.addVariantManagement=function(t){if(t){if(this._oVariantManagement){this.removeBetween(this._oVariantManagement)}this._oVariantManagement=t;this.addBetween(this._oVariantManagement);this._updateVariantManagement()}};_.prototype.toggleZoomButtons=function(t){const e=this._getZoomEnablement(t);if(e.enabled){this.oZoomInButton.setEnabled(e.enabledZoomIn);this.oZoomOutButton.setEnabled(e.enabledZoomOut)}else{this.oZoomInButton.setEnabled(false);this.oZoomOutButton.setEnabled(false)}};_.prototype.updateToolbar=function(t){this.toggleZoomButtons(t);if(!this._toolbarInitialUpdated){this.setEnabled(true);this._chartInternalButtonsToEnable.forEach(function(t){t.setEnabled(true)});this._toolbarInitialUpdated=true}const e=t.getSelectionHandler();if(e&&t.getShowSelectionDetails()){this._oChartSelectionDetails.attachSelectionHandler(e.eventId,e.listener)}};_.prototype._getVariantReference=function(){return this._oVariantManagement};_.prototype._getZoomEnablement=function(t){let e;try{e=t.getZoomState()}catch(t){e={enabled:false}}if(e&&e.hasOwnProperty("currentZoomLevel")&&e.currentZoomLevel!=null&&e.enabled){const t={enabled:true};t.enabledZoomOut=e.currentZoomLevel>0;t.enabledZoomIn=e.currentZoomLevel<1;return t}else{return{enabled:false}}};_.prototype._updateSelectionDetailsActions=function(t){if(!t.getShowSelectionDetails()){return}const e=t.getSelectionDetailsActions();let n;if(e){const t=this._oChartSelectionDetails.getItems();t.forEach(function(t){const o=e.getDetailsItemActions();o.forEach(function(e){n=e.clone();t.addAction(n)})});const o=e.getDetailsActions();this._oChartSelectionDetails.removeAllActions();o.forEach(function(t){n=t.clone();this._oChartSelectionDetails.addAction(n)}.bind(this));const i=e.getActionGroups();this._oChartSelectionDetails.removeAllActionGroups();i.forEach(function(t){n=t.clone();this._oChartSelectionDetails.addActionGroup(n)}.bind(this))}};_.prototype._setHeader=function(t){this._oTitle?.setText(t);this._oInvTitle?.setText(t)};_.prototype._setHeaderLevel=function(t){this._oTitle?.setLevel(t);this._updateVariantManagement()};_.prototype._setHeaderStyle=function(t){this._oTitle?.setTitleStyle(t);this._updateVariantManagement()};_.prototype._setHeaderVisible=function(t){this._oTitle?.setVisible(t);this._updateVariantManagement()};_.prototype._updateVariantManagement=function(){if(this._oVariantManagement&&this._oChart){this._oVariantManagement.setShowAsText(this._oChart.getHeaderVisible());this._oVariantManagement.setTitleStyle(this._oChart.getHeaderStyle());this._oVariantManagement.setHeaderLevel(this._oChart.getHeaderLevel())}};_.prototype.getSettingsButton=function(){return this._oSettingsBtn};_.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oInvTitle){this._oInvTitle.destroy();this._oInvTitle=null}};return _});
//# sourceMappingURL=ChartToolbar.js.map