/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["sap/ui/base/Object","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/ParseException","sap/base/Log","sap/base/util/merge","sap/base/util/deepEqual","./Condition","sap/ui/mdc/enums/ConditionValidated","sap/base/strings/escapeRegExp","sap/ui/mdc/enums/OperatorOverwrite","sap/ui/mdc/enums/OperatorValueType"],function(e,t,a,i,s,r,o,n,l,u,p,f){"use strict";let h=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");sap.ui.getCore().attachLocalizationChanged(function(){h=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc")});const d=e.extend("sap.ui.mdc.condition.Operator",{constructor:function(t){e.apply(this,arguments);if(!t){throw new Error("Operator configuration missing")}if(!t.name){s.warning("Operator configuration expects a name property")}if(!t.filterOperator&&!t.getModelFilter){throw new Error("Operator configuration for "+t.name+" needs a default filter operator from sap.ui.model.FilterOperator or the function getModelFilter")}this._enableOverwrites(t);this.name=t.name;if(t.alias){this.alias=t.alias}this.filterOperator=t.filterOperator;this.valueTypes=t.valueTypes;this.paramTypes=t.paramTypes;this.displayFormats=t.displayFormats;const a="operators."+this.name;const i=a+".longText";const r=a+".tokenText";this.longText=t.longText||c(i)||"";this.tokenText=t.tokenText||c(r)||"";if(this.longText===i){this.longText=this.tokenText.replace(/\{0\}/g,"X").replace(/\{1\}/g,"Y")}if(this.tokenText===r){this.tokenText=this.longText}if(this.tokenText){let e;let a;if(t.tokenParse){a=u(this.tokenText);this.tokenParse=t.tokenParse.replace(/#tokenText#/g,a);for(let e=0;e<this.valueTypes.length;e++){const t=this.paramTypes?this.paramTypes[e]:this.valueTypes[e];this.tokenParse=this.tokenParse.replace(new RegExp("\\\\\\$"+e+"|"+e+"\\\\\\$"+"|"+"\\\\\\{"+e+"\\\\\\}","g"),t)}e=this.tokenParse}else{e=u(this.tokenText)}this.tokenParseRegExp=new RegExp(e,"i");if(t.tokenFormat){a=this.tokenText;this.tokenFormat=t.tokenFormat.replace(/\#tokenText\#/g,a)}else{this.tokenFormat=this.tokenText}}if(t.additionalInfo!==undefined){this.additionalInfo=t.additionalInfo}this.exclude=!!t.exclude;this.validateInput=!!t.validateInput;if(t.group){this.group=t.group}else{this.group={id:!this.exclude?"1":"2"};if(!this.group.text){this.group.text=h.getText("VALUEHELP.OPERATOR.GROUP"+this.group.id)}}},destroy:function(){this._oMethodOverwrites=null;e.protoype.destroy.apply(this,arguments)}});d.ValueType={Self:"self",Static:"static",SelfNoParse:"selfNoParse"};function c(e,t){if(t==="time"||t==="datetime"){t="date"}const a=e+(t?"."+t:"");let i;i=h.getText(a,undefined,true);if(i===a||i===undefined){if(t){i=h.getText(e,undefined,true);if(i===a||i===undefined){i=e}}else{i=a}}return i}d.prototype.getLongText=function(e){const t=this.textKey||"operators."+this.name+".longText";let a=c(t,e.toLowerCase());if(a===t){a=this.longText}return a};d.prototype.getModelFilter=function(e,i,s,r,o){let n=e.values[0];let u;let p;const f=i.split(",");if(Array.isArray(n)&&f.length>1){n=n[0];i=f[0];p=new t({path:f[1],operator:a.EQ,value1:e.values[0][1]})}if(p&&n===undefined){u=p;p=undefined}else if(!this.valueTypes[1]){if(!r&&e.validated===l.Validated){r=true}u=new t({path:i,operator:this.filterOperator,value1:n,caseSensitive:r===false?false:undefined})}else{let a=e.values[1];if(Array.isArray(a)&&f.length>1){a=a[0]}u=new t({path:i,operator:this.filterOperator,value1:n,value2:a,caseSensitive:r===false?false:undefined})}if(p){u=new t({filters:[u,p],and:true})}if(e.inParameters){const i=[u];for(const s in e.inParameters){if(s.startsWith("conditions/")){i.push(new t({path:s.slice(11),operator:a.EQ,value1:e.inParameters[s]}))}}if(i.length>1){u=new t({filters:i,and:true})}}return u};d.prototype.isEmpty=function(e,t){let a=false;if(e){for(let t=0;t<this.valueTypes.length;t++){if(this.valueTypes[t]!==f.Static){const i=e.values[t];if(i===null||i===undefined||i===""){a=true;break}}}}return a};d.prototype.format=function(e,t,a,i,s,r,o){const n=e.values;const l=this.valueTypes.length;let u=i&&l===1?"{0}":this.tokenFormat;for(let e=0;e<l;e++){let a;let i;if(this.valueTypes[e]!==f.Static){if(this.valueTypes[e]===f.Self){a=t;i=s}else if(this.valueTypes[e]===null){a=r;i=o}else{a=this._createLocalType(this.valueTypes[e],t)}let l=n[e];if(l===undefined||l===null){l=a?a.parseValue("","string"):""}let p=this._formatValue(l,a,i);if(typeof p==="string"){p=p.replace(/\$/g,"$$$")}u=u.replace(new RegExp("\\$"+e+"|"+e+"\\$"+"|"+"\\{"+e+"\\}","g"),p)}}return u};d.prototype._formatValue=function(e,t,a){let i;if(t){if(t.isA("sap.ui.model.CompositeType")&&t.getUseInternalValues()&&Array.isArray(e)&&a){e=r([],e);for(let t=0;t<e.length;t++){if(a[t]){const i=a[t].getModelFormat();if(i&&typeof i.parse==="function"){e[t]=i.parse(e[t])}}}}i=t.formatValue(e,"string")}else{i=e}return i};d.prototype.parse=function(e,t,a,i,r,o,n){const l=this.getValues(e,a,i);let u;if(l){u=[];for(let e=0;e<this.valueTypes.length;e++){let a;let i;if(this.valueTypes[e]===f.Self){a=t;i=r}else if(this.valueTypes[e]===null){a=o;i=n}else if(this.valueTypes[e]&&this.valueTypes[e]!==f.Static){a=this._createLocalType(this.valueTypes[e],t)}try{if(this.valueTypes[e]!==f.Static){let t;if(a&&l[e]!==undefined){t=this._parseValue(l[e],a,i)}else{t=l[e]}u.push(t)}}catch(e){s.warning(e.message);throw e}}}return u};d.prototype._parseValue=function(e,t,a){if(e===undefined){return e}let i;if(t&&t.isA("sap.ui.model.CompositeType")&&t._aCurrentValue&&t.getParseWithValues()){i=t._aCurrentValue}const s=t?t.parseValue(e,"string",i):e;if(t&&t.isA("sap.ui.model.CompositeType")&&Array.isArray(s)&&(t._aCurrentValue||t.getUseInternalValues()&&a)){for(let e=0;e<s.length;e++){if(s[e]===undefined&&t._aCurrentValue){s[e]=t._aCurrentValue[e]===undefined?null:t._aCurrentValue[e]}else if(t.getUseInternalValues()&&a&&a[e]){const t=a[e].getModelFormat();if(t&&typeof t.format==="function"){s[e]=t.format(s[e])}}}}return s};d.prototype.validate=function(e,t,a,i,s,o){const n=this.valueTypes.length;for(let l=0;l<n;l++){if((this.valueTypes[l]||this.valueTypes[l]===null)&&this.valueTypes[l]!==f.Static){let n;let u;if(this.valueTypes[l]===f.Self){n=t;u=a}else if(this.valueTypes[l]===null){n=s;u=o}else{n=this._createLocalType(this.valueTypes[l],t)}if(e.length<l+1&&this.valueTypes[l]){throw new Error("value "+l+" for operator "+this.name+" missing")}if(n&&e.length>l){let t=e[l];if(t===undefined||t===null){t=n?n.parseValue("","string"):""}if(n.isA("sap.ui.model.CompositeType")&&Array.isArray(t)&&u){t=r([],t);for(let e=0;e<t.length;e++){if(u[e]){if(i===undefined||e===i){u[e].validateValue(t[e])}if(n.getUseInternalValues()){const a=u[e].getModelFormat();if(a&&typeof a.parse==="function"){t[e]=a.parse(t[e])}}}}}n.validateValue(t)}}}};d.prototype._createLocalType=function(e,t){if(!this._aTypes){this._aTypes=[]}let a;let i;let s;let n;if(e===f.SelfNoParse){a=t.getMetadata().getName();i=r({},t.getFormatOptions());s=r(t.getConstraints())}else if(typeof e==="string"){a=e}else if(e&&typeof e==="object"){a=e.name;i=e.formatOptions;s=e.constraints}for(let e=0;e<this._aTypes.length;e++){const t=this._aTypes[e];if(t.name===a&&o(t.formatOptions,i)&&o(t.constraints,s)){n=t.type;break}}if(!n){const t=sap.ui.require(a.replace(/\./g,"/"));n=new t(i,s);n._bCreatedByOperator=true;if(e===f.SelfNoParse){n.parseValue=function(e,a){t.prototype.parseValue.apply(this,arguments);return e};n.validateValue=function(e){const a=t.prototype.parseValue.apply(this,[e,"string"]);t.prototype.validateValue.apply(this,[a])};n.formatValue=function(e,a){t.prototype.formatValue.apply(this,arguments);return e}}this._aTypes.push({name:a,formatOptions:i,constraints:s,type:n})}return n};d.prototype.test=function(e){return this.tokenParseRegExp.test(e)};d.prototype.getValues=function(e,t,a){const i=e.match(this.tokenParseRegExp);let s;if(i||a&&e){s=[];for(let t=0;t<this.valueTypes.length;t++){let r;if(i){r=i[t+1]}else if(a){if(t>0){break}r=e}s.push(r)}}return s};d.prototype.getCondition=function(e,t,a,s,r,o,l){if(this.test(e)||s&&e&&this.hasRequiredValues()){const u=this.parse(e,t,a,s,r,o,l);if(u.length==this.valueTypes.length||this.valueTypes[0]===f.Static||u.length===1&&this.valueTypes.length===2&&!this.valueTypes[1]){const e=n.createCondition(this.name,u);this.checkValidated(e);return e}else{throw new i("Parsed value don't meet operator")}}return null};d.prototype.isSingleValue=function(){if(this.valueTypes.length>1&&this.valueTypes[1]){return false}return true};d.prototype.getCheckValue=function(e){if(this.valueTypes[0]&&this.valueTypes[0]===f.Static){return{}}else{return{values:e.values}}};d.prototype.hasRequiredValues=function(){if(this.valueTypes[0]&&this.valueTypes[0]!==f.Static){return true}else{return false}};d.prototype.compareConditions=function(e,t){let a=false;if(e.operator===this.name&&e.operator===t.operator){const i=this.getCheckValue(e);const s=this.getCheckValue(t);if(e.inParameters&&t.inParameters){i.inParameters=e.inParameters;s.inParameters=t.inParameters}if(e.outParameters&&t.outParameters){i.outParameters=e.outParameters;s.outParameters=t.outParameters}if(e.payload||t.payload){i.payload=e.payload;s.payload=t.payload}if(e.validated&&t.validated){i.validated=e.validated;s.validated=t.validated}if(o(i,s)){a=true}}return a};d.prototype.checkValidated=function(e){e.validated=l.NotValidated};d.prototype._enableOverwrites=function(e){this._oMethodOverwrites={};["format","parse","validate","getModelFilter","isEmpty","createControl","getCheckValue","getValues","checkValidated","getLongText"].forEach(function(t){Object.defineProperty(this,t,{get:function(){return this._oMethodOverwrites&&this._oMethodOverwrites[t]||Object.getPrototypeOf(this)[t]}});if(e&&e[t]){this._oMethodOverwrites[t]=e[t]}}.bind(this))};const y=Object.values(p);d.prototype.overwrite=function(e,t){if(y.indexOf(e)>=0){const a=this[e];this._oMethodOverwrites[e]=t;return a.bind(this)}throw"Operator: Illegal overwrite detected. Please see sap.ui.mdc.enums.OperatorOverwrite"};return d});
//# sourceMappingURL=Operator.js.map