/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/Control","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/FieldEditMode","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/field/FieldBaseRenderer","sap/ui/mdc/field/ConditionType","sap/ui/mdc/field/ConditionsType","sap/ui/mdc/field/splitValue","sap/ui/mdc/field/content/ContentFactory","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/ConditionValidateException","sap/ui/mdc/util/loadModules","sap/ui/core/library","sap/ui/core/LabelEnablement","sap/ui/core/message/MessageMixin","sap/base/util/deepEqual","sap/base/util/merge","sap/base/util/restricted/_debounce","sap/ui/dom/containsOrEquals","sap/ui/model/BindingMode","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/base/ManagedObjectModel","sap/ui/base/ManagedObjectObserver","sap/ui/events/KeyCodes"],function(t,e,i,n,a,o,s,l,r,h,c,d,g,u,p,f,y,C,v,m,_,F,b,I,D,T,V,P,E){"use strict";const M=f.ValueState;const O=f.TextAlign;const A=f.TextDirection;const S=t.extend("sap.ui.mdc.field.FieldBase",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.ui.core.ISemanticFormContent","sap.m.IOverflowToolbarContent"],designtime:"sap/ui/mdc/designtime/field/FieldBase.designtime",library:"sap.ui.mdc",properties:{dataType:{type:"string",group:"Data",defaultValue:"sap.ui.model.type.String"},dataTypeConstraints:{type:"object",group:"Data",defaultValue:null},dataTypeFormatOptions:{type:"object",group:"Data",defaultValue:null},editMode:{type:"sap.ui.mdc.enums.FieldEditMode",group:"Data",defaultValue:i.Editable},required:{type:"boolean",group:"Data",defaultValue:false},display:{type:"sap.ui.mdc.enums.FieldDisplay",defaultValue:n.Value},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:O.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:A.Inherit},placeholder:{type:"string",group:"Misc",defaultValue:""},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:M.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},multipleLines:{type:"boolean",group:"Appearance",defaultValue:false},maxConditions:{type:"int",group:"Behavior",defaultValue:-1},conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true,bindable:"bindable"},label:{type:"string",group:"Misc",defaultValue:""},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/field/FieldBaseDelegate",payload:{}}},showEmptyIndicator:{type:"boolean",group:"Appearance",defaultValue:false},_valueHelpEnabled:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},_ariaAttributes:{type:"object",defaultValue:{},byValue:true,visibility:"hidden"},_operators:{type:"string[]",defaultValue:[],visibility:"hidden"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false},contentEdit:{type:"sap.ui.core.Control",multiple:false},contentDisplay:{type:"sap.ui.core.Control",multiple:false},_content:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},fieldInfo:{type:"sap.ui.mdc.field.FieldInfoBase",multiple:false}},associations:{fieldHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false},valueHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},press:{},submit:{parameters:{promise:{type:"Promise"}}}},publicMethods:[],defaultAggregation:"content"},renderer:s,_oManagedObjectModel:null,_oInvalidInput:null});C.call(S.prototype);const H={onsapup:at,onsapdown:at,onsaphome:at,onsapend:at,onsappageup:at,onsappagedown:at,onsapbackspace:at,onkeydown:at,onchange:Nt,onsapfocusleave:wt,onpaste:j};const x={onsapenter:R};let B;S._init=function(){if(B&&B.bool&&B.bool.control){B.bool.control.destroy()}if(B&&B.defineConditions&&B.defineConditions.control){B.defineConditions.control.destroy()}B={bool:{modules:["sap/ui/mdc/ValueHelp","sap/ui/mdc/valuehelp/Popover","sap/ui/mdc/valuehelp/content/Bool"],id:"BoolDefaultHelp",contentProperties:{},dialog:false,control:undefined,updateTitle:function(t,e){}},defineConditions:{modules:["sap/ui/mdc/ValueHelp","sap/ui/mdc/valuehelp/Dialog","sap/ui/mdc/valuehelp/content/Conditions"],id:"Field-DefineConditions-Help",contentProperties:{},dialog:true,control:undefined,updateTitle:function(t,e){t.getDialog().setTitle(e);t.getDialog().getContent()[0].setLabel(e)}}}};S._init();S.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oObserver=new P(this.observeChanges.bind(this));this._oObserver.observe(this,{properties:["display","editMode","dataType","dataTypeFormatOptions","dataTypeConstraints","multipleLines","maxConditions","conditions","delegate"],aggregations:["fieldInfo","content","contentEdit","contentDisplay"],associations:["fieldHelp","valueHelp","ariaLabelledBy"]});this.attachEvent("modelContextChange",this.handleModelContextChange,this);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");this._aAsyncChanges=[];this._bPreventGetDescription=false;this._oContentFactory=this.getContentFactory();this._oCreateContentPromise=undefined;this._sFilterValue=""};S.prototype.getContentFactory=function(){if(this.isFieldDestroyed()){return}if(!this._oContentFactory){this._oContentFactory=new c(this.getId()+"-contentFactory",{field:this,handleTokenUpdate:mt.bind(this),handleContentChange:pt.bind(this),handleContentLiveChange:yt.bind(this),handleValueHelpRequest:Dt.bind(this),handleEnter:R.bind(this),handleContentPress:vt.bind(this)})}return this._oContentFactory};const w=function(t){const e=bt.call(this);if(this.getEditMode()===i.Editable&&e&&!this._iFocusTimer&&e.shouldOpenOnFocus()&&!e.isOpen()){this._iFocusTimer=setTimeout(function(){if(!this.isFieldDestroyed()&&!e.isOpen()){Dt.call(this,t,true);this._redirectFocus(t,e)}this._iFocusTimer=null}.bind(this),300)}};const N=function(){if(this._iFocusTimer){clearTimeout(this._iFocusTimer);this._iFocusTimer=null}};S.prototype.exit=function(){N.call(this);const t=this.getFieldInfo();if(t){t.detachEvent("dataUpdate",kt,this)}const e=this.getContent();if(e){Z.call(this,e)}const i=this.getContentEdit();if(i){Z.call(this,i)}const n=this.getContentDisplay();if(n){Z.call(this,n)}if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel}this._oObserver.disconnect();this._oObserver=undefined;this._oCreateContentPromise=undefined;const a=bt.call(this);if(a){a.detachEvent("dataUpdate",St,this);if(this._bConnected){xt.call(this,a);a.connect()}}if(this._oContentFactory){this._oContentFactory.destroy();this._oContentFactory=undefined}Ct.call(this);delete this._fnLiveChangeTimer};S.prototype.applySettings=function(){t.prototype.applySettings.apply(this,arguments);if(!this.bDelegateInitialized&&!this.bDelegateLoading){this.initControlDelegate()}this.triggerCheckCreateInternalContent();this._bSettingsApplied=true;return this};S.prototype.setProperty=function(e,n,a){if(e==="editMode"){const t=this.getEditMode();if(t!==i.Display&&t!==i.EditableDisplay&&n!==i.Display&&n!==i.EditableDisplay){a=true}}else if(e!=="width"&&e!=="multipleLines"&&e!=="showEmptyIndicator"){a=true}return t.prototype.setProperty.apply(this,[e,n,a])};S.prototype.onBeforeRendering=function(){tt.call(this)};S.prototype.onAfterRendering=function(){};S.prototype.focus=function(e){this._oFocusInfo=e;t.prototype.focus.call(this,e);delete this._oFocusInfo};S.prototype.onfocusin=function(t){Bt.call(this);if(!this._oFocusInfo?.targetInfo?.silent){w.call(this,t)}};S.prototype.onsapfocusleave=function(t){N.call(this);Ct.call(this);if(this._aAsyncChanges.length===0&&!this._bPendingChange){this._bDirty=false}};function L(t){const e=t.getParameter("fieldGroupIds");t.cancelBubble();t.preventDefault();const i=e.indexOf(this.getId());if(i>-1){if(this._bPendingChange){const t=bt.call(this);if(!(t&&Gt.call(t))){const t=Rt.call(this);if(t){U.call(this,undefined,undefined,undefined,t)}else{U.call(this,this.getConditions(),!this.isInvalidInput())}}}if(e.length>1){e.splice(i,1);this.fireValidateFieldGroup({fieldGroupIds:e})}}else{this.fireValidateFieldGroup({fieldGroupIds:e})}}S.prototype.onsapup=function(t){this._handleNavigate(t,-1)};S.prototype.onsapdown=function(t){this._handleNavigate(t,1)};S.prototype.onsaphome=function(t){this._handleNavigate(t,-9999)};S.prototype.onsappageup=function(t){this._handleNavigate(t,-10)};S.prototype.onsappagedown=function(t){this._handleNavigate(t,10)};S.prototype.onsapend=function(t){this._handleNavigate(t,9999)};S.prototype._handleNavigate=function(t,e){if(this.getEditMode()===i.Editable){const i=bt.call(this);const n=t.srcControl;if(i){if(i.isNavigationEnabled(e)&&(!this.getContentFactory().isMeasure()||n.getShowValueHelp())){t.preventDefault();t.stopPropagation();i.setFilterValue(this._sFilterValue);i.navigate(e)}}}};S.prototype.onsapenter=function(t){const e=bt.call(this);if(e&&e.isOpen()){e.close()}this._sFilterValue="";if(this._oNavigateCondition){const e=t.srcControl;this._oNavigateCondition=undefined;this.getContentFactory().updateConditionType();if(e.selectText&&e.getDOMValue){e.selectText(e.getDOMValue().length,e.getDOMValue().length)}}};S.prototype.onsapescape=function(t){this.onsapenter(t)};S.prototype._redirectFocus=function(t,e){const i=t.srcControl;if(e.isOpen()&&(!this.getContentFactory().isMeasure()||i.getShowValueHelp&&i.getShowValueHelp())){i.addStyleClass("sapMFocus");e.removeFocus()}};S.prototype.ontap=function(t){const e=bt.call(this);if(this.getEditMode()===i.Editable&&e){if(e.shouldOpenOnClick()&&!e.isOpen()){Dt.call(this,t,true)}this._redirectFocus(t,e)}};S.prototype.clone=function(e,i){this.detachEvent("modelContextChange",this.handleModelContextChange,this);const n=this.getContent();if(n){Z.call(this,n)}const a=this.getContentEdit();if(a){Z.call(this,a)}const o=this.getContentDisplay();if(o){Z.call(this,o)}const s=this.getFieldInfo();if(s){s.detachEvent("dataUpdate",kt,this)}const l=t.prototype.clone.apply(this,arguments);this.attachEvent("modelContextChange",this.handleModelContextChange,this);if(n){X.call(this,n)}if(a){X.call(this,a)}if(o){X.call(this,o)}if(s){s.attachEvent("dataUpdate",kt,this)}if(this._bTriggerable){l._bTriggerable=this._bTriggerable}return l};S.prototype.getFieldPath=function(){const t=this.getBindingPath("conditions");if(t&&t.startsWith("/conditions/")){return t.slice(12)}else{return""}};function k(t,e,i,n){if(this.getCurrentContent().length>1){this._bPendingChange=true}else{U.call(this,t,e,i,n)}}function U(t,e,i,n){if(!n){if(e){n=Promise.resolve(this.getResultForChangePromise(t))}else{const t=this._getInvalidInputException();if(t){n=Promise.reject(t)}else{n=Promise.reject(i)}}}if(this._aAsyncChanges.length===0){this._bDirty=false}this.fireChangeEvent(t,e,i,n);this._bPendingChange=false}S.prototype.fireChangeEvent=function(t,e,i,n){};function R(t){const e=this.getEditMode();if(this._aAsyncChanges.length===0){this._bDirty=false}if(c._getEditable(e)&&(this.hasListeners("submit")||this._bPendingChange)){let t=Rt.call(this);let e=false;if(t){e=true}else if(this.isInvalidInput()){t=Promise.reject()}else{t=Promise.resolve(this.getResultForChangePromise(this.getConditions()))}if(this._bPendingChange){if(e){U.call(this,undefined,undefined,undefined,t)}else{U.call(this,this.getConditions(),!this.isInvalidInput(),undefined,t)}}this.fireSubmit({promise:t})}}function j(t){const e=this.getMaxConditions();if(e===1){return}const i=t.originalEvent.clipboardData.getData("text/plain");const n=h(i,true);if(n.length<=1){return}const a=t.srcControl;let o;for(const t in a.getMetadata().getAllProperties()){if(a.getBindingPath(t)==="/conditions"){o=t;break}}a.updateModelProperty(o,i,a.getProperty(o));t.stopImmediatePropagation(true);t.preventDefault();t.source=t.srcControl;t.parameters={};const s=this._aAsyncChanges.length;let l;let r;let c;if(s>0){this._aAsyncChanges[s-1].changeFired=true;this._aAsyncChanges[s-1].changeEvent=t;l=this._aAsyncChanges[s-1].promise}else{r=!this._bParseError;c=this.getConditions()}k.call(this,c,r,undefined,l)}S.prototype.initDataType=function(){if(this.getContentFactory().getDataType()){this.getContentFactory().getDataType().destroy();this.getContentFactory().setDataType(undefined)}if(this.getContentFactory().getDateOriginalType()){if(this.getContentFactory().getDateOriginalType()._bCreatedByField){this.getContentFactory().getDateOriginalType().destroy()}this.getContentFactory().setDateOriginalType(undefined)}if(this.getContentFactory().getUnitOriginalType()){if(this.getContentFactory().getUnitOriginalType()._bCreatedByField){this.getContentFactory().getUnitOriginalType().destroy()}this.getContentFactory().setUnitOriginalType(undefined)}this.getContentFactory().setIsMeasure(false)};function $(){const t=this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType()||this.getContentFactory().getDataType();if(t&&typeof t==="object"){return t.getMetadata().getName()}else if(this.bDelegateInitialized){return this.getTypeMap().getDataTypeClassName(this.getDataType())}else{return this.getDataType()}}function q(){const t=this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType()||this.getContentFactory().getDataType();if(t&&typeof t==="object"&&t.getConstraints()){return t.getConstraints()}else{return this.getDataTypeConstraints()}}function G(){const t=this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType()||this.getContentFactory().getDataType();if(t&&typeof t==="object"&&t.getFormatOptions()){return t.getFormatOptions()}else{return this.getDataTypeFormatOptions()}}S.prototype.getBaseType=function(){const t=$.call(this);const e=q.call(this);const i=G.call(this);const n=this.getTypeMap().getBaseType(t,i,e);return n};function z(t,e){const i=bt.call(this);if(i&&this._bConnected){It.call(this,t,i)}}S.prototype.getCurrentContent=function(){let t=this.getContent();if(!t){if(this.getEditMode()===i.Display){t=this.getContentDisplay()}else{t=this.getContentEdit()}}if(t){return[t]}else{return this.getAggregation("_content",[])}};S.prototype.handleModelContextChange=function(t){};function Q(t){this.setValueState(M.Error);this.setValueStateText(t)}S.prototype._removeUIMessage=function(){this.setValueState(M.None);this.setValueStateText()};S.prototype.observeChanges=function(t){if(t.name==="dataType"){if(this.getContentFactory().getDataType()){const e=function(t){this.getContentFactory().checkDataTypeChanged(t).then(function(t){if(t&&!this.isFieldDestroyed()){this.initDataType();this.destroyAggregation("_content");this.getContentFactory().updateConditionType()}}.bind(this)).catch(function(t){throw t})}.bind(this);if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){e.call(this,t.current)}.bind(this));return}e.call(this,t.current)}}if(t.name==="dataTypeFormatOptions"||t.name==="dataTypeConstraints"){if(this.getContentFactory().getDataType()){this.initDataType();this.destroyAggregation("_content");this.getContentFactory().updateConditionType()}}if(t.name==="maxConditions"){this.updateInternalContent()}if(t.name==="conditions"){this.resetInvalidInput(!this._bKeepValueState);z.call(this,t.current,t.old);let e=false;let n=0;for(n=0;n<this._aAsyncChanges.length;n++){const i=this._aAsyncChanges[n];if(i.waitForUpdate&&v(i.result,t.current)){ft.call(this,i);e=true;break}}if(e){this._aAsyncChanges.splice(n,1)}if((t.current.length===0||t.old.length===0)&&this.getShowEmptyIndicator()&&this.getEditMode()===i.Display&&!this.getContent()&&!this.getContentDisplay()){this.invalidate()}}if(t.name==="display"){this.destroyInternalContent();this.getContentFactory().updateConditionType()}if((t.name==="fieldHelp"||t.name==="valueHelp")&&t.ids){_t.call(this,t.ids,t.mutation);this.getContentFactory().updateConditionType()}if(t.name==="fieldInfo"&&t.child){Lt.call(this,t.child,t.mutation)}if(t.name==="content"&&t.child){Y.call(this,t.child,t.mutation,t.name)}if(t.name==="contentEdit"&&t.child){Y.call(this,t.child,t.mutation,t.name)}if(t.name==="contentDisplay"&&t.child){Y.call(this,t.child,t.mutation,t.name)}if(t.name==="delegate"&&!this.bDelegateInitialized&&!this.bDelegateLoading){this.initControlDelegate.call(this)}if(t.name==="ariaLabelledBy"&&t.ids){W.call(this,t.ids,t.mutation)}if(t.name==="editMode"){J.call(this);if(this._bSettingsApplied&&(t.old===i.Display||t.old===i.EditableDisplay||t.current===i.Display||t.current===i.EditableDisplay)){this.triggerCheckCreateInternalContent()}}};S.prototype.updateInternalContent=function(){if(this.getAggregation("_content",[]).length>0){tt.call(this);this.getContentFactory().updateConditionType()}};S.prototype.getFocusDomRef=function(){const t=this.getCurrentContent();if(t.length>0){return t[0].getFocusDomRef()}else{return this.getDomRef()}};S.prototype.getIdForLabel=function(){let t;const e=this.getCurrentContent();if(e.length>0){t=e[0].getIdForLabel()}else{t=it.call(this)}return t};S.prototype.getEditable=function(){return c._getEditable(this.getEditMode())};S.prototype.getControlForSuggestion=function(){const t=this.getCurrentContent();if(t.length>0){if(this.getContentFactory().isMeasure()&&t.length>1){return t[1]}else{return t[0]}}else{return this}};S.prototype.getFocusElementForValueHelp=function(t){const e=this.getControlForSuggestion();const i=e&&e.getMetadata().getAllPrivateAggregations()._endIcon&&e.getAggregation("_endIcon",[]);let n;if(i){for(let t=0;t<i.length;t++){if(i[t].getVisible()){n=i[t];break}}}return t||!n?e:n};S.prototype.getMaxConditionsForHelp=function(){if(this.getContentFactory().isMeasure()){return 1}else{return this.getMaxConditions()}};S.prototype.getFormFormattedValue=function(){const t=this.getConditions();const e=this.getShowEmptyIndicator()&&t.length===0&&!this.getContent()&&!this.getContentDisplay();if(e){if(!this._oResourceBundleM){this._oResourceBundleM=sap.ui.getCore().getLibraryResourceBundle("sap.m")}return this._oResourceBundleM.getText("EMPTY_INDICATOR")}else if(this.getContentFactory().isMeasure()&&this.getContentFactory().getUnitOriginalType(true)){const e=t.length>0?t[0].values[0]:[0,null];return this.getContentFactory().getUnitOriginalType().formatValue(e,"string")}else if(this.getContentFactory().getDateOriginalType(true)){const e=t.length>0?t[0].values[0]:null;return this.getContentFactory().getDateOriginalType().formatValue(e,"string")}else{const e=this.getContentFactory().getConditionsType();const i=e.getFormatOptions();const n=i.noFormatting;i.noFormatting=false;e.setFormatOptions(i);const a=e.formatValue(t);i.noFormatting=n;e.setFormatOptions(i);return a}};S.prototype.getFormValueProperty=function(){return"conditions"};S.prototype.getOverflowToolbarConfig=function(){return{canOverflow:true,invalidationEvents:[],propsUnrelatedToSize:["conditions","editMode","display","valueState","valueStateText"]}};S.prototype.enhanceAccessibilityState=function(t,e){const i=this.getParent();if(i&&i.enhanceAccessibilityState){i.enhanceAccessibilityState(t,e)}};S.prototype.getAccessibilityInfo=function(){const t=this.getCurrentContent();if(t.length===1&&t[0].getAccessibilityInfo){return t[0].getAccessibilityInfo()}else if(t.length>0){return{children:t}}else{return{}}};function W(t,e){const i=this.getAggregation("_content",[]);let n=this.getContent();if(n){i.push(n)}n=this.getContentDisplay();if(n){i.push(n)}n=this.getContentEdit();if(n){i.push(n)}for(let a=0;a<i.length;a++){n=i[a];if(n.getMetadata().getAllAssociations().ariaLabelledBy){if(e==="remove"){n.removeAriaLabelledBy(t)}else if(e==="insert"){n.addAriaLabelledBy(t)}}}}function K(t,e){const i={aria:{}};const n=bt.call(this);if(n){const a=n.getAriaAttributes(this.getMaxConditionsForHelp());const o=a.roleDescription;i["role"]=a.role;if(o){i.aria["roledescription"]=o}i.aria["haspopup"]=a.ariaHasPopup;i["autocomplete"]="off";if(t){if(a.role){i.aria["expanded"]="true"}i.aria["controls"]=a.contentId;if(e){i.aria["activedescendant"]=e}}else if(a.role){i.aria["expanded"]="false"}i["valueHelpEnabled"]=a.valueHelpEnabled;if(a.autocomplete&&a.autocomplete!=="none"){i.aria["autocomplete"]=a.autocomplete}}this.setProperty("_ariaAttributes",i,true)}S.prototype.connectLabel=function(t){nt.call(this,t);t.bindProperty("text",{path:"$field>/label"});t.setLabelFor(this);return this};function J(){const t=y.getReferencingLabels(this);for(let e=0;e<t.length;e++){const i=sap.ui.getCore().byId(t[e]);i.invalidate()}}function Y(t,e,i){if(e==="remove"){Z.call(this,t);st.call(this,t);if(this.getContentFactory().getContentConditionTypes()){delete this.getContentFactory().getContentConditionTypes()[i]}t.setModel(null,"$field")}else if(e==="insert"){if(!t.isA("sap.ui.core.IFormContent")){throw new Error(t+" is not a valid content! Only use valid content in "+this)}ot.call(this,t,true);X.call(this,t);if(this.getAggregation("_content",[]).length>0){this.destroyInternalContent()}if(!this.getContentFactory().getContentConditionTypes()){this.getContentFactory().setContentConditionTypes({})}if(!this.getContentFactory().getContentConditionTypes()[i]){this.getContentFactory().getContentConditionTypes()[i]={}}this.getContentFactory().setNoFormatting(false);this.awaitControlDelegate().then(function(){if(!this.isFieldDestroyed()){const t=ct.call(this,this.getSupportedOperators());if(t!==this.getContentFactory().getHideOperator()){this.getContentFactory().setHideOperator(t);this.getContentFactory()._setUsedConditionType(this.getContent(),this.getContentEdit(),this.getContentDisplay(),this.getEditMode())}}}.bind(this));let e;let n;let a=false;for(n in t.getMetadata().getAllProperties()){if(t.getBindingPath(n)==="/conditions"){e=t.getBindingInfo(n);if(e&&e.type&&e.type instanceof r){this.getContentFactory().getContentConditionTypes()[i].oConditionsType=e.type}a=true}if(n==="editable"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/editMode",formatter:c._getEditable})}if(n==="enabled"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/editMode",formatter:c._getEnabled})}if(n==="displayOnly"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/editMode",formatter:c._getDisplayOnly})}if(n==="required"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/required"})}if(n==="textAlign"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/textAlign"})}if(n==="textDirection"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/textDirection"})}if(n==="valueState"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/valueState"})}if(n==="valueStateText"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/valueStateText"})}if(n==="placeholder"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/placeholder"})}if(n==="showValueHelp"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/_valueHelpEnabled"})}if(n==="valueHelpIconSrc"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.setValueHelpIconSrc(this._getValueHelpIcon())}}for(const o in t.getMetadata().getAllAggregations()){if(t.getBindingPath(o)==="/conditions"){e=t.getBindingInfo(o);if(e&&e.template){for(n in e.template.getMetadata().getAllProperties()){const t=e.template.getBindingInfo(n);if(t&&t.type&&t.type instanceof l){this.getContentFactory().getContentConditionTypes()[i].oConditionType=t.type;if(a){this.getContentFactory().setNoFormatting(true)}break}}}}if(o==="tooltip"&&!t.getBindingPath(o)&&!t.getAggregation(o)){t.bindProperty(o,{path:"$field>/tooltip"})}}if(t.getMetadata().getAllAssociations().ariaLabelledBy){this.getContentFactory().setAriaLabelledBy(t)}}}function X(t){if(t.getMetadata().getEvents().change){t.attachEvent("change",pt,this)}if(t.getMetadata().getEvents().liveChange){t.attachEvent("liveChange",yt,this)}if(t.getMetadata().getEvents().press){t.attachEvent("press",vt,this)}if(t.getMetadata().getEvents().valueHelpRequest){t.attachEvent("valueHelpRequest",Dt,this)}if(t.getMetadata().getEvents().tokenUpdate){t.attachEvent("tokenUpdate",mt,this)}if(t.getMetadata().getEvents().validateFieldGroup){t.attachEvent("validateFieldGroup",L,this)}}function Z(t){if(t.getMetadata().getEvents().change){t.detachEvent("change",pt,this)}if(t.getMetadata().getEvents().liveChange){t.detachEvent("liveChange",yt,this)}if(t.getMetadata().getEvents().press){t.detachEvent("press",vt,this)}if(t.getMetadata().getEvents().valueHelpRequest){t.detachEvent("valueHelpRequest",Dt,this)}if(t.getMetadata().getEvents().tokenUpdate){t.detachEvent("tokenUpdate",mt,this)}if(t.getMetadata().getEvents().validateFieldGroup){t.detachEvent("validateFieldGroup",L,this)}}function tt(){const t=function(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(function(){tt.call(this)}.bind(this))}else{et.call(this)}};if(this._oCreateContentPromise){this._oCreateContentPromise.then(function(){tt.call(this)}.bind(this))}else{t.call(this)}}S.prototype.checkCreateInternalContent=function(){if(!this.isFieldDestroyed()&&this.getVisible()){tt.call(this)}};S.prototype.triggerCheckCreateInternalContent=function(){if(!this._oCheckCreateInternalContentPromise){this._oCheckCreateInternalContentPromise=this.awaitControlDelegate().then(function(){delete this._oCheckCreateInternalContentPromise;this.checkCreateInternalContent()}.bind(this))}};function et(){if(this.isFieldDestroyed()){return}const t=this.getEditMode();const e=this.getContent();const n=this.getContentEdit();const a=this.getContentDisplay();this.getContentFactory()._setUsedConditionType(e,n,a,t);Ft.call(this,this._getValueHelp());K.call(this,false);if(e||t===i.Display&&a||t!==i.Display&&n){this.destroyInternalContent();const t=this.getCurrentContent();if(t.length===1){nt.call(this,t[0])}return}const o=this.getMaxConditions();const s=this.getSupportedOperators();const l=this.getAggregation("_content",[]);let r;let h;const c=this.getMultipleLines();const d=this._bTriggerable;const g=this.getContentFactory().getContentType(this.getBaseType(),this.getMaxConditions(),d);if(l.length>0){r=l[0];h=r.getMetadata().getName().replace(/\./g,"/")}const u=this.getContentFactory().getContentMode(g,t,o,c,s);const p=g.getControlNames(u,s[0]);const f=p[0];if(f!==h){this.getContentFactory().setHideOperator(ct.call(this,s));if(r){this.destroyInternalContent();if(r.isA("sap.m.DateTimeField")){this.initDataType()}this.getContentFactory().updateConditionType()}if(ht.call(this,g,s,t,o)){lt.call(this,g.getUseDefaultValueHelp().name)}else if(this._sDefaultValueHelp){delete this._sDefaultValueHelp}const e=it.call(this);this._oCreateContentPromise=this.getContentFactory().createContent(g,u,e);this._oCreateContentPromise.then(function(t){delete this._oCreateContentPromise;for(let e=0;e<t.length;e++){const i=t[e];i.attachEvent("parseError",dt,this);i.attachEvent("validationError",gt,this);i.attachEvent("validationSuccess",ut,this);i.attachEvent("validateFieldGroup",L,this);ot.call(this,i,g.getUseDefaultEnterHandler());nt.call(this,i);this.addAggregation("_content",i)}J.call(this)}.bind(this)).catch(function(t){delete this._oCreateContentPromise;throw t}.bind(this))}}function it(){return this.getId()+"-inner"}S.prototype.destroyInternalContent=function(){this.destroyAggregation("_content");if(this.getContentFactory().getDateOriginalType()){this.getContentFactory().setDataType(this.getContentFactory().getDateOriginalType());this.getContentFactory().setDateOriginalType(undefined)}else if(this.getContentFactory().getUnitOriginalType()){this.getContentFactory().setDataType(this.getContentFactory().getUnitOriginalType());this.getContentFactory().setUnitOriginalType(undefined)}if(this.isInvalidInput()){this.resetInvalidInput(true)}if(this.getContentFactory().isMeasure()){this.getContentFactory().setIsMeasure(false)}};function nt(t){if(!this._oManagedObjectModel&&!this.isFieldDestroyed()){this._oManagedObjectModel=new V(this)}t.setModel(this._oManagedObjectModel,"$field")}function at(t){let e=false;const i=bt.call(this);if(!i){return}else{switch(t.type){case"sapup":e=i.isNavigationEnabled(-1);break;case"sapdown":e=i.isNavigationEnabled(1);break;case"saphome":e=i.isNavigationEnabled(-9999);break;case"sapend":e=i.isNavigationEnabled(9999);break;case"sappageup":e=i.isNavigationEnabled(-10);break;case"sappagedown":e=i.isNavigationEnabled(10);break;case"sapbackspace":e=i.isOpen();this._bPreventAutocomplete=true;break;case"keydown":if(t.which!==E.BACKSPACE&&t.which!==E.DELETE){this._bPreventAutocomplete=false}break;default:e=i.isOpen();break}}if(e){t.stopPropagation();t.stopImmediatePropagation(true);switch(t.type){case"sapup":this.onsapup(t);break;case"sapdown":this.onsapdown(t);break;case"saphome":this.onsaphome(t);break;case"sapend":this.onsapend(t);break;case"sappageup":this.onsappageup(t);break;case"sappagedown":this.onsappagedown(t);break;default:break}}}function ot(t,e){t.addDelegate(H,true,this);if(e){t.addDelegate(x,false,this)}}function st(t){t.removeDelegate(H);t.removeDelegate(x)}function lt(t){this._sDefaultValueHelp=B[t].id;let e=B[t].control;if(e&&e.isDestroyed()){B[t].control=undefined;e=undefined}if(!e){if(B[t].promise){B[t].promise.then(rt.bind(this,B[t].id))}else{B[t].promise=p(B[t].modules).catch(function(e){throw new Error("loadModules promise rejected in sap.ui.mdc.field.FieldBase:_createDefaultValueHelp function call - could not load controls "+JSON.stringify(B[t].modules))}).then(function(i){const n=i[0];const a=i[1];const o=i[2];e=new n(B[t].id,{delegate:{name:"sap/ui/mdc/ValueHelpDelegate",payload:{isDefaultHelp:true}}});const s=new a(B[t].id+"-container",{content:[new o(B[t].id+"-content",B[t].contentProperties)]});e._bIsDefaultHelp=true;e._sDefaultHelpType=t;B[t].control=e;if(B[t].dialog){e.setDialog(s)}else{e.setTypeahead(s)}e.connect(this);rt.call(this,B[t].id)}.bind(this)).unwrap()}}else{rt.call(this,B[t].id)}K.call(this,false)}function rt(t){_t.call(this,t,"insert")}function ht(t,e,n,a){const o=t.getUseDefaultValueHelp();if(o&&!this._getValueHelp()&&n!==i.Display){if(a===1&&o.single||a!==1&&o.multi){if(e.length===1){const i=ct.call(this,e);if(a===1){if(!(t.getEditOperator()&&t.getEditOperator()[e[0]])&&(o.oneOperatorSingle||!i)){return true}}else if(o.oneOperatorMulti||!i){return true}}else{return true}}}return false}function ct(t){if(t.length===1){const e=d.getOperator(t[0]);return!e||e.isSingleValue()}else{return false}}S.prototype._setInvalidInput=function(t,e,i,n){const a=n?n.getId():this.getId();if(!this._oInvalidInput){this._oInvalidInput={}}this._oInvalidInput[a]={exception:t,value:e,reason:i}};S.prototype._getInvalidInputException=function(t){let e;if(this._oInvalidInput){if(t){if(this._oInvalidInput[t.getId()]){return this._oInvalidInput[t.getId()].exception}else if(this._oInvalidInput[this.getId()]){return this._oInvalidInput[this.getId()].exception}}else{for(const t in this._oInvalidInput){e=this._oInvalidInput[t].exception;if(e){break}}}}return e};S.prototype.resetInvalidInput=function(t){if(this._oInvalidInput){this._oInvalidInput=null;if(t){this._removeUIMessage()}}};S.prototype.isInvalidInput=function(){return!!this._oInvalidInput};S.prototype._isInvalidInputForContent=function(t){return this._oInvalidInput&&(this._oInvalidInput[t.getId()]||this._oInvalidInput[this.getId()])};function dt(t){const e=t.getParameter("newValue");const i=t.getParameter("exception");const n=t.getSource();this._setInvalidInput(i,e,"ParseError",n);this._sFilterValue="";const a=n.getBinding("valueState");if(a&&a.getBindingMode()===b.OneWay){Q.call(this,t.getParameter("message"))}}function gt(t){const e=t.getParameter("newValue");const i=t.getParameter("exception");const n=t.getSource();this._setInvalidInput(i,e,"ValidationError",n);this._sFilterValue="";const a=i&&i instanceof u&&i.getConditions();let o=false;let s=0;for(s=0;s<this._aAsyncChanges.length;s++){const n=this._aAsyncChanges[s];if(n.waitForUpdate&&Array.isArray(n.result)){if(n.result.length===0&&e===""){n.reject(t.getParameter("exception"));o=true;break}else if(v(n.result,a)){n.reject(i);o=true;break}}}if(o){this._aAsyncChanges.splice(s,1)}const l=n.getBinding("valueState");if(l&&l.getBindingMode()===b.OneWay){Q.call(this,t.getParameter("message"))}}function ut(t){const e=t.getSource();if(this._isInvalidInputForContent(e)){const t=e.getBinding("valueState");let i=false;if(t&&t.getBindingMode()===b.OneWay){i=true}this.resetInvalidInput(i)}}function pt(t){const e={parameters:m({},t.getParameters()),source:t.getSource()};const i=this._aAsyncChanges.length;if(i>0&&!this._aAsyncChanges[i-1].changeFired){this._aAsyncChanges[i-1].changeFired=true;this._aAsyncChanges[i-1].changeEvent=e;k.call(this,undefined,undefined,undefined,this._aAsyncChanges[i-1].promise);return}const n={changeEvent:e};ft.call(this,n)}function ft(t){const e=this.getConditions();let i=true;let n;const a=t.changeEvent.source;if(t.changeEvent.parameters.hasOwnProperty("valid")){i=t.changeEvent.parameters["valid"]}else if(this.isInvalidInput()){i=false}if(!i&&t.changeEvent.parameters.hasOwnProperty("value")){n=t.changeEvent.parameters["value"]}const o=bt.call(this);if(o&&this._bConnected){if(sap.ui.getCore().getCurrentFocusedControlId()===a.getId()){o.close()}this._sFilterValue="";if(i){It.call(this,e,o);o.onControlChange()}Ct.call(this)}if(this._oNavigateCondition){this._oNavigateCondition=undefined;this.getContentFactory().updateConditionType();if(a.selectText&&a.getDOMValue){a.selectText(a.getDOMValue().length,a.getDOMValue().length)}}if(t.resolve){jt.call(this,t)}else{k.call(this,e,i,n)}}function yt(t){let e;let i;let n=false;const a=t.getSource();this._oNavigateCondition=undefined;this.getContentFactory().updateConditionType();if("value"in t.getParameters()){e=t.getParameter("value")}else if("newValue"in t.getParameters()){e=t.getParameter("newValue")}if("escPressed"in t.getParameters()){n=t.getParameter("escPressed")}if("previousValue"in t.getParameters()){i=t.getParameter("previousValue")}else{const t=this.getConditions();i=t[0]&&t[0].values[0]}const o=bt.call(this);if(o&&(!this.getContentFactory().isMeasure()||a.getShowValueHelp())){if(n){if(o.isOpen()){o.close();It.call(this,this.getConditions(),o);Ct.call(this);this._sFilterValue=""}}else{const t=this.getSupportedOperators();let i=false;for(let e=0;e<t.length;e++){const n=d.getOperator(t[e]);if(n.validateInput){i=true;break}}if(i){this._bIgnoreInputValue=false;this._vLiveChangeValue=e;if(!this._fnLiveChangeTimer){N.call(this);this._fnLiveChangeTimer=_(function(){const t=this.getDisplay();if(typeof this._vLiveChangeValue!=="undefined"){this._sFilterValue=""}if(this._vLiveChangeValue){const e=d.getEQOperator();const i=e.getValues(this._vLiveChangeValue,t,true);if(i[0]){this._sFilterValue=i[0];if(i[1]){this._sFilterValue=this._sFilterValue+" "}}if(i[1]){this._sFilterValue=this._sFilterValue+i[1]}}const e=function(){if(Gt.call(this)){const t=o.isOpen();if(this.getMaxConditionsForHelp()===1&&o.getConditions().length>0){o.setConditions([])}o.setFilterValue(this._sFilterValue);if(!t){o.open(true)}else{Tt.call(this,false)}delete this._vLiveChangeValue}}.bind(this);if(this._bConnected&&this.getCurrentContent()[0]){o.isTypeaheadSupported().then(function(t){return!!t&&e()});delete this._vLiveChangeValue}}.bind(this),300,{leading:false,trailing:true});o.initBeforeOpen(true)}const t=o.isTypeaheadSupported();if(t instanceof Promise){t.then(function(t){if(Gt.call(this)&&this._fnLiveChangeTimer){this._fnLiveChangeTimer()}this._bOpenByTyping=t}.bind(this))}this._fnLiveChangeTimer()}}}this._bDirty=true;this.fireLiveChange({value:e,escPressed:n,previousValue:i})}function Ct(){if(this._fnLiveChangeTimer){this._fnLiveChangeTimer.cancel();delete this._vLiveChangeValue}}function vt(t){const e=this.getFieldInfo();if(e){e.getTriggerHref().then(function(t){if(!t){e.open(this.getCurrentContent()[0]);K.call(this,true)}}.bind(this))}this.firePress()}function mt(t){if(t.getParameter("type")==="removed"){const e=t.getParameter("removedTokens");let i=this.getConditions();let n;let a;let o;for(o=0;o<e.length;o++){const t=e[o];const n=t.getBindingContext("$field").sPath;const a=parseInt(n.slice(n.lastIndexOf("/")+1));i[a].delete=true}for(o=i.length-1;o>=0;o--){if(i[o].delete){if(this.getContentFactory().isMeasure()){n=i[o].values[0][1];a=i[o].payload}i.splice(o,1)}}if(this.getContentFactory().isMeasure()&&n&&i.length===0){i=[g.createItemCondition([undefined,n],undefined,undefined,undefined,a)]}this.setProperty("conditions",i,true);U.call(this,i,true);t.preventDefault(true)}}function _t(t,e){let i;if(e==="remove"){i=sap.ui.getCore().byId(t);if(i){xt.call(this,i);i.detachEvent("dataUpdate",St,this)}this.resetProperty("_valueHelpEnabled")}else if(e==="insert"){if(this._sDefaultValueHelp&&t!==this._sDefaultValueHelp){_t.call(this,this._sDefaultValueHelp,"remove");delete this._sDefaultValueHelp}Ft.call(this,t);const e=this.getCurrentContent()[0];if(e&&e.setValueHelpIconSrc){e.setValueHelpIconSrc(this._getValueHelpIcon())}}z.call(this,this.getConditions())}function Ft(t){if(t&&this.isPropertyInitial("_valueHelpEnabled")){const e=sap.ui.getCore().byId(t);if(e){e.attachEvent("dataUpdate",St,this);if(e.getIcon()){this.setProperty("_valueHelpEnabled",true,true)}}}}S.prototype._getValueHelp=function(){return this.getValueHelp()||this.getFieldHelp&&this.getFieldHelp()};function bt(){let t=this._getValueHelp();let e;if(!t&&this._sDefaultValueHelp){t=this._sDefaultValueHelp}if(t){e=sap.ui.getCore().byId(t)}return e}function It(t,e){if(!e){e=bt.call(this)}let i;if(this.isInvalidInput()&&this.getMaxConditionsForHelp()===1){i=[]}else if(this.getContentFactory().isMeasure()){i=[];for(let e=0;e<t.length;e++){const n=t[e];if(n.values[0]&&n.values[0][1]){const t=g.createItemCondition(n.values[0][1],undefined,n.inParameters,n.outParameters,n.payload);i.push(t)}}}else{i=t}e.setConditions(i)}function Dt(t,e){const i=bt.call(this);if(i){if(this._fnLiveChangeTimer){this._fnLiveChangeTimer.flush()}i.setFilterValue(this._sFilterValue);const n=this.getConditions();It.call(this,n,i);i.toggleOpen(!!e);const a=t.srcControl||t.getSource();if(!i.isFocusInHelp()){if(a.bValueHelpRequested){a.bValueHelpRequested=false}}}}function Tt(t){this.getCurrentContent().forEach(function(e){if(e.closeValueStateMessage&&!t){e.closeValueStateMessage()}if(e.setShowValueStateMessage){e.setShowValueStateMessage(t)}})}function Vt(t){let e=this.getConditions();const i=t.getParameter("conditions");const n=t.getParameter("add");const s=t.getParameter("close");const l=t.oSource;const r=this.getMaxConditions();let h;const c=this.getControlForSuggestion();let u;let p=0;if(this.getContentFactory().isMeasure()){if(i.length>1){throw new Error("Only one item must be selected! "+this)}if(i[0].operator!==o.EQ){throw new Error("Only EQ allowed! "+this)}if(e.length>0){for(p=0;p<e.length;p++){e[p].values[0][1]=i[0].values[0];if(e[p].operator===o.BT){e[p].values[1][1]=i[0].values[0]}if(i[0].inParameters){e[p].inParameters=i[0].inParameters}if(i[0].outParameters){e[p].outParameters=i[0].outParameters}if(i[0].payload){e[p].payload=i[0].payload}}}else{const t=d.getEQOperator(this.getSupportedOperators());const n=[null,i[0].values[0]];h=g.createCondition(t.name,[n],i[0].inParameters,i[0].outParameters,a.NotValidated,i[0].payload);e.push(h);const o=this.getContentFactory().getConditionType(true);const s=this.getContentFactory().getUnitConditionsType(true);if(o){u=o.formatValue(h)}else if(s){u=s.formatValue(e)}}}else{if(!n){e=[]}for(p=0;p<i.length;p++){h=i[p];if(!qt.call(this,h.operator)){continue}const t=n?d.indexOfCondition(h,e):-1;if(t===-1){e.push(h)}else if(h.validated===a.Validated&&h.values.length>1&&(e[t].values.length===1||h.values[1]!==e[t].values[1])){e[t].values=h.values}}}if(r>0&&r<e.length){e.splice(0,e.length-r)}let f=false;if(c&&c.setDOMValue){if(this.getMaxConditionsForHelp()===1&&e.length>0){if(this.getContentFactory().isMeasure()&&this.getContentFactory().getUnitConditionsType(true)){u=this.getContentFactory().getUnitConditionsType().formatValue(e)}else if(this.getContentFactory().getConditionType(true)){u=this.getContentFactory().getConditionType().formatValue(e[0])}else if(this.getContentFactory().getConditionsType(true)){u=this.getContentFactory().getConditionsType().formatValue(e)}const t=function(t){const i=c.getDOMValue();c.setDOMValue("");c.setDOMValue(t);if(i!==t&&r===1){this.fireLiveChange({value:e[0].values[0]})}}.bind(this);if(u instanceof Promise){u.then(function(e){t(e)})}else{t(u)}this._sFilterValue=""}else if(s){c.setDOMValue("");this._sFilterValue="";this._bIgnoreInputValue=false}else{this._bIgnoreInputValue=true}if(this.isInvalidInput()){this.resetInvalidInput(true);f=true}}const y=this.getConditions();if(!v(e,y)){this._oNavigateCondition=undefined;this.getContentFactory().updateConditionType();this.setProperty("conditions",e,true);if(!d.compareConditionsArray(e,y)){l.onControlChange();k.call(this,e,true)}}else if(f){k.call(this,e,true)}}function Pt(t){let e=t.getParameter("value");let i=t.getParameter("key");let s=t.getParameter("condition");const l=t.getParameter("itemId");const r=t.getParameter("leaveFocus");if(!s&&i){s=g.createItemCondition(i,e)}let h;let c;const u=this.getControlForSuggestion();const p=d.getEQOperator(this.getSupportedOperators());const f=bt.call(this);if(r){u.addStyleClass("sapMFocus");u.focus();f.removeFocus();return}if(s){this._oNavigateCondition=m({},s);this._oNavigateCondition.operator=p.name;i=s.values[0];e=s.values[1]}else{this._oNavigateCondition=g.createCondition(p.name,[i,e],undefined,undefined,a.Validated)}if(this.getContentFactory().isMeasure()){const t=this.getConditions();if(t.length>0){this._oNavigateCondition.operator=t[0].operator;this._oNavigateCondition.values[0]=[t[0].values[0][0],i];if(t[0].operator===o.BT){this._oNavigateCondition.values[1]=[t[0].values[1][0],this._oNavigateCondition.values[0][1]]}else if(this._oNavigateCondition.values.length>1){this._oNavigateCondition.values.splice(1)}}else{this._oNavigateCondition.values=[[null,i]]}}this._bPreventGetDescription=true;this.getContentFactory().updateConditionType();if(this.getDisplay()!==n.Value){h=i}else if(e){h=e}else{h=i}const y=f.isOpen();if(u&&u.setDOMValue){if(!c){if(this.getContentFactory().isMeasure()&&this.getContentFactory().getUnitConditionsType(true)&&this._oNavigateCondition){c=this.getContentFactory().getUnitConditionsType().formatValue([this._oNavigateCondition])}else if(this.getContentFactory().getConditionType(true)&&this._oNavigateCondition){c=this.getContentFactory().getConditionType().formatValue(this._oNavigateCondition)}else if(this.getContentFactory().getConditionsType(true)&&this._oNavigateCondition){c=this.getContentFactory().getConditionsType().formatValue([this._oNavigateCondition])}else{c=e||i}}u.setDOMValue(c);if(u._doSelect){u._doSelect()}if(y){u.removeStyleClass("sapMFocus")}}this._bPreventGetDescription=false;this.getContentFactory().updateConditionType();K.call(this,y,l);this._bIgnoreInputValue=false;this._bDirty=true;this.fireLiveChange({value:h})}function Et(t){const e=t.getParameter("condition");const i=t.getParameter("filterValue");const n=t.getParameter("itemId");const a=this.getControlForSuggestion();const s=d.getEQOperator(this.getSupportedOperators());if(Gt.call(this)&&a&&a.setDOMValue&&a.selectText&&!this._bPreventAutocomplete&&(!a.isComposingCharacter||!a.isComposingCharacter())){const t=this.getContentFactory();const l=t.isMeasure();const r=this.getControlDelegate();let h;if(l){const t=this.getContentFactory().getCompositeTypes();if(t&&t.length>1){h=t[1]}}else{h=t.getDataType()}const c=r.getAutocomplete(this,e,this._vLiveChangeValue||this._sFilterValue,i,h,t.getAdditionalDataType());if(c&&c.text){this._oNavigateCondition=m({},e);this._oNavigateCondition.operator=s.name;if(l){const t=this.getConditions();if(t.length>0){this._oNavigateCondition.operator=t[0].operator;this._oNavigateCondition.values[0]=[t[0].values[0][0],e.values[0]];if(t[0].operator===o.BT){this._oNavigateCondition.values[1]=[t[0].values[1][0],this._oNavigateCondition.values[0][1]]}else if(this._oNavigateCondition.values.length>1){this._oNavigateCondition.values.splice(1)}}else{this._oNavigateCondition.values=[[null,e.values[0]]]}}a.setDOMValue(c.text);a.selectText(c.selectionStart,c.selectionEnd);t.updateConditionType();K.call(this,true,n)}}}function Mt(t){const e=this.getControlForSuggestion();if(this._bIgnoreInputValue){this._bIgnoreInputValue=false;e.setDOMValue("");this._sFilterValue="";this.getContentFactory().updateConditionType();if(this.getMaxConditions()!==1){this._oManagedObjectModel.checkUpdate(true)}}Tt.call(this,true);K.call(this,false);const i=t.getSource();const n=this.getConditions();It.call(this,n,i)}function Ot(t){let e;if(this.getMaxConditionsForHelp()===1||this._sFilterValue){e=t.getParameter("itemId")}K.call(this,true,e);Tt.call(this,false)}function At(t){const e=this.getControlForSuggestion();e.focus();if(e.fireValueHelpRequest){e.bValueHelpRequested=true;e.fireValueHelpRequest()}}function St(t){const e=this.getEditMode()===i.Editable&&this.getCurrentContent().length>0&&sap.ui.getCore().getCurrentFocusedControlId()===this.getCurrentContent()[0].getId();if(!e&&!this._bPendingConditionUpdate&&this.getConditions().length>0&&(this.getMaxConditions()!==1||this.getDisplay()!==n.Value&&!this.isInvalidInput())&&this._oManagedObjectModel){this._oManagedObjectModel.checkUpdate(true)}}function Ht(t){const e=bt.call(this);xt.call(this,e)}function xt(t){if(this._bConnected){t.detachEvent("select",Vt,this);t.detachEvent("navigated",Pt,this);t.detachEvent("disconnect",Ht,this);t.detachEvent("afterClose",Mt,this);t.detachEvent("switchToValueHelp",At,this);t.detachEvent("closed",Mt,this);t.detachEvent("opened",Ot,this);t.detachEvent("typeaheadSuggested",Et,this);this._bConnected=false}}function Bt(){const t=bt.call(this);if(t){let e;const i=this.getContentFactory().isMeasure();if(i){const t=this.getContentFactory().getCompositeTypes();if(t&&t.length>1){e=t[1]}}else{e=this.getContentFactory().getDataType()}const a={maxConditions:this.getMaxConditions(),dataType:e,additionalDataType:this.getContentFactory().getAdditionalDataType(),operators:this.getSupportedOperators(),display:i?n.Value:this.getDisplay(),delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),defaultOperatorName:this.getDefaultOperator?this.getDefaultOperator():null};t.connect(this,a);if(!this._bConnected){this._bConnected=true;t.attachEvent("select",Vt,this);t.attachEvent("navigated",Pt,this);t.attachEvent("disconnect",Ht,this);t.attachEvent("afterClose",Mt,this);t.attachEvent("switchToValueHelp",At,this);t.attachEvent("closed",Mt,this);t.attachEvent("opened",Ot,this);t.attachEvent("typeaheadSuggested",Et,this);const e=this.getConditions();It.call(this,e,t);if(t._bIsDefaultHelp){B[t._sDefaultHelpType].updateTitle(t,this.getLabel())}}}}function wt(t){const e=bt.call(this);const i=this.getControlForSuggestion();const n=t.srcControl;if(e&&i===n){const n=sap.ui.getCore().byId(t.relatedControlId);if(n){if(F(e.getDomRef(),n.getFocusDomRef())){t.stopPropagation();t.stopImmediatePropagation(true);if(i.bValueHelpRequested){i.bValueHelpRequested=false}if(this._sFilterValue){i.setDOMValue(this._sFilterValue)}}else{e.skipOpening()}}}}function Nt(t){if(bt.call(this)){t.stopImmediatePropagation(true)}}S.prototype._getValueHelpIcon=function(){const t=bt.call(this);if(t){return t.getIcon()}};function Lt(t,e){if(e==="remove"){t.detachEvent("dataUpdate",kt,this)}else if(e==="insert"){t.attachEvent("dataUpdate",kt,this);kt.call(this)}}function kt(){const t=this.getFieldInfo();const e=this;t.isTriggerable().then(function(n){e._bTriggerable=n;let a=e.getAggregation("_content",[]);if(a.length>0&&e.getEditMode()===i.Display){tt.call(e);if(e._bTriggerable){a=e.getAggregation("_content",[]);const i=a[0];t.getDirectLinkHrefAndTarget().then(function(t){c._updateLink(i,t)})}}})}S.prototype.getFormatOptions=function(){if(!this._asyncParsingCall){this._asyncParsingCall=Ut.bind(this)}return{valueType:this.getContentFactory().retrieveDataType(),originalDateType:this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType(),additionalType:this.getContentFactory().getUnitType(),compositeTypes:this.getContentFactory().getCompositeTypes(),additionalValueType:this.getContentFactory().retrieveAdditionalDataType(),additionalCompositeTypes:this.getContentFactory().getAdditionalCompositeTypes(),display:this.getContentFactory().isMeasure()?n.Value:this.getDisplay(),valueHelpID:this.getContentFactory().isMeasure()?undefined:this._getValueHelp()||this._sDefaultValueHelp,operators:this.getSupportedOperators(),hideOperator:this.getContentFactory().getHideOperator(),maxConditions:this.getMaxConditions(),bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription,convertWhitespaces:this.getEditMode()===i.Display||this.getMaxConditions()!==1,control:this,defaultOperatorName:this.getDefaultOperator?this.getDefaultOperator():null,getConditions:this.getConditions.bind(this),noFormatting:this.getContentFactory().getNoFormatting(),keepValue:this._bIgnoreInputValue?this._sFilterValue:null,multipleLines:this.getMultipleLines()}};S.prototype.checkValueInitial=function(t){if(t===null||t===undefined){return true}if(t===""||typeof t==="string"&&t.match(/^0+$/)){const e=this.getContentFactory().retrieveDataType();const i=e.parseValue("","string");if(i===t){return true}else{try{e.validateValue(i)}catch(t){return true}}}else{const i=$.call(this);if(this.getTypeMap().getBaseType(i)===e.Unit&&Array.isArray(t)&&t.length>1&&(t[0]===undefined||t[0]===null)&&!t[1]){return true}}return false};S.prototype.getUnitFormatOptions=function(){if(!this._asyncParsingCall){this._asyncParsingCall=Ut.bind(this)}return{valueType:this.getContentFactory().getUnitType(),originalDateType:this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType(),additionalType:this.getContentFactory().retrieveDataType(),compositeTypes:this.getContentFactory().getCompositeTypes(),additionalValueType:this.getContentFactory().retrieveAdditionalDataType(),additionalCompositeTypes:this.getContentFactory().getAdditionalCompositeTypes(),display:this.getDisplay(),valueHelpID:this._getValueHelp()||this._sDefaultValueHelp,operators:[o.EQ],hideOperator:true,maxConditions:1,bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription,convertWhitespaces:this.getEditMode()===i.Display||this.getEditMode()===i.EditableDisplay,control:this,getConditions:this.getConditions.bind(this),noFormatting:false,multipleLines:false}};function Ut(t){const e=bt.call(this);if(e&&e.isOpen()&&(Gt.call(this)||Gt.call(e))){e.close()}const i={};const n=new Promise(function(e,n){i.resolve=e;i.reject=n;t.then(function(t){i.result=t;this.resetInvalidInput();const e=this.getConditions();if(v(t,e)){jt.call(this,i);$t.call(this,i)}else{i.waitForUpdate=true}}.bind(this)).catch(function(t){if(t&&!(t instanceof D)&&!(t instanceof I)&&!(t instanceof T)){throw t}const e=this.getControlForSuggestion();this._setInvalidInput(t,undefined,"AsyncParsing",e);n(t);$t.call(this,i)}.bind(this))}.bind(this));i.promise=n;this._aAsyncChanges.push(i)}function Rt(){const t=[];for(let e=0;e<this._aAsyncChanges.length;e++){t.push(this._aAsyncChanges[e].promise)}if(t.length>0){return Promise.all(t).then(function(){return this.getResultForChangePromise(this.getConditions())}.bind(this))}return null}S.prototype.getResultForChangePromise=function(t){return t};function jt(t){if(this._aAsyncChanges.length<=1){this._bDirty=false}t.resolve(this.getResultForChangePromise(t.result))}function $t(t){let e=false;let i=0;for(i=0;i<this._aAsyncChanges.length;i++){if(t===this._aAsyncChanges[i]){e=true;break}}if(e){this._aAsyncChanges.splice(i,1)}if(this._aAsyncChanges.length===0){this._bDirty=false}return e}S.prototype.getSupportedOperators=function(){let t;if(this.isSearchField()){t=[o.Contains]}else{let i=this.getBaseType();if(i===e.Unit){i=e.Numeric}t=d.getOperatorsForType(i)}this.setProperty("_operators",t,true);return t};S.prototype.isSearchField=function(){const t=new RegExp("^\\*(.*)\\*|\\$search$");const e=this.getFieldPath();return t.test(e)&&this.getMaxConditions()===1};function qt(t){const e=this.getSupportedOperators();for(let i=0;i<e.length;i++){if(t===e[i]){return true}}return false}S.prototype.isFieldPropertyInitial=function(t){if(this.isBound(t)&&!this.getBinding(t)){return!Object.hasOwn(this.mProperties,t)}else{return this.isPropertyInitial(t)}};S.prototype.isFieldDestroyed=function(){return this.isDestroyed()||this.isDestroyStarted()};S.prototype.hasPendingUserInput=function(){return!!this._bDirty};S.prototype.getAdditionalDataTypeConfiguration=function(){return null};function Gt(){const t=document.activeElement;return t&&F(this.getDomRef(),t)}return S});
//# sourceMappingURL=FieldBase.js.map