/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","./PanelRenderer","sap/ui/layout/VerticalLayout","sap/base/Log","sap/ui/layout/HorizontalLayout","sap/m/HBox","sap/m/VBox","sap/m/ImageContent","sap/m/Link","sap/m/Label","sap/m/Text","sap/m/Button","sap/m/FlexItemData","sap/ui/model/json/JSONModel","sap/ui/model/BindingMode","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/p13n/subcontroller/LinkPanelController","sap/m/p13n/Engine","sap/ui/mdc/mixin/AdaptationMixin","sap/ui/mdc/link/PanelItem","sap/ui/core/CustomData","./Factory"],function(t,e,n,i,o,r,a,s,l,c,u,p,d,g,m,h,f,I,y,P,b,_){"use strict";const k=t.extend("sap.ui.mdc.link.Panel",{metadata:{library:"sap.ui.mdc",defaultAggregation:"items",properties:{enablePersonalization:{type:"boolean",defaultValue:true,invalidate:true},metadataHelperPath:{type:"string"},beforeNavigationCallback:{type:"function"}},aggregations:{items:{type:"sap.ui.mdc.link.PanelItem",multiple:true,singularName:"item"},additionalContent:{type:"sap.ui.core.Control",multiple:true},_content:{type:"sap.ui.layout.VerticalLayout",visibility:"hidden",multiple:false}},events:{beforeSelectionDialogOpen:{},afterSelectionDialogClose:{}}},renderer:e});k.prototype.init=function(){t.prototype.init.call(this);I.getInstance().register(this,{controller:{LinkItems:new f({control:this})}});y.call(k.prototype);I.getInstance().defaultProviderRegistry.attach(this,"Global");sap.ui.require([this.getMetadataHelperPath()||"sap/ui/mdc/Link"],function(t){this._oMetadataHelper=t}.bind(this));const e=new g({countAdditionalContent:0,countItemsWithIcon:0,countItemsWithoutIcon:0,showResetEnabled:false,runtimeItems:[],contentTitle:""});e.setDefaultBindingMode(m.TwoWay);e.setSizeLimit(1e3);this.setModel(e,"$sapuimdclinkPanel");this._oObserver=new h(W.bind(this));this._oObserver.observe(this,{properties:["enablePersonalization"],aggregations:["items","additionalContent"]})};const C=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");k.prototype.applySettings=function(){this._createContent();t.prototype.applySettings.apply(this,arguments)};k.prototype.exit=function(t){if(this._oObserver){this._oObserver.disconnect();this._oObserver=null}if(this._oMetadataHelper){this._oMetadataHelper=null}};const v=0,A=1,w=2,L=3;k.prototype._createContent=function(){const t=[];t[v]=this._createAdditionalContentArea();t[A]=this._createSeparator();t[w]=this._createLinkArea();t[L]=this._createFooterArea();const e=new n({width:"100%",content:t});this.setAggregation("_content",e)};k.prototype._createAdditionalContentArea=function(){const t=new a({fitContainer:false,items:this.getAdditionalContent()});return t};k.prototype._createSeparator=function(){const t=new a({fitContainer:false,visible:{parts:[{path:"$sapuimdclinkPanel>/countAdditionalContent"},{path:"$sapuimdcLink>/metadata"}],formatter:function(t,e){return t>0&&e.length>0}}});t.addStyleClass("mdcbaseinfoPanelSeparator");t.setModel(this._getInternalModel(),"$sapuimdclinkPanel");t.setModel(this.getModel("$sapuimdcLink"),"$sapuimdcLink");return t};k.prototype._createLinkArea=function(){const t=new a({fitContainer:false,items:{path:"$sapuimdclinkPanel>/runtimeItems",templateShareable:false,factory:this._fnLinkItemFactory.bind(this)}});t.addStyleClass("mdcbaseinfoPanelSectionLinks");t.setModel(this._getInternalModel(),"$sapuimdclinkPanel");return t};k.prototype._fnLinkItemFactory=function(t,e){const n=new s({src:"{$sapuimdclinkPanel>icon}",visible:{path:"$sapuimdclinkPanel>icon",formatter:function(t){return!!t}}});const i=new l({text:"{$sapuimdclinkPanel>text}",href:"{$sapuimdclinkPanel>href}",target:"{$sapuimdclinkPanel>target}",visible:{path:"$sapuimdclinkPanel>href",formatter:function(t){return!!t}},press:this.onPressLink.bind(this),wrapping:true,customData:new b({key:"internalHref",value:"{$sapuimdclinkPanel>internalHref}"})});const p=new c({text:"{$sapuimdclinkPanel>text}",visible:{path:"$sapuimdclinkPanel>href",formatter:function(t){return!t}},wrapping:true});const g=new u({text:"{$sapuimdclinkPanel>description}",visible:{path:"$sapuimdclinkPanel>description",formatter:function(t){return!!t}},wrapping:true});const m=new a({items:[i,p,g]});const h=new r({layoutData:new d({styleClass:e.getProperty("description")?"mdcbaseinfoPanelItemsGroup":"mdcbaseinfoPanelItemsWithoutGroup"}),items:[n,m]});const f=new o({visible:"{$sapuimdclinkPanel>visible}",content:[h]});f.addStyleClass("mdcbaseinfoPanelListItem");return f};k.prototype._createFooterArea=function(){const t=new p(this.getId()+"--idSectionPersonalizationButton",{type:"Transparent",text:C.getText("info.POPOVER_DEFINE_LINKS"),press:this.onPressLinkPersonalization.bind(this)});const e=new r({visible:{path:"$sapuimdcLink>/metadata",formatter:function(t){return t.length>0}},justifyContent:"End",items:[t]});e.addStyleClass("mdcbaseinfoPanelPersonalizationButton");return e};k.prototype.onPressLink=function(t){const e=t.getSource();const n=t.getParameters().ctrlKey||t.getParameters().metaKey;if(this.getBeforeNavigationCallback()&&e&&e.getTarget()!=="_blank"&&!n){const n=e&&e.getCustomData()&&e.getCustomData()[0]&&e.getCustomData()[0].getValue();const i=n?e.getCustomData()[0].getValue():e.getHref();t.preventDefault();this.getBeforeNavigationCallback()(t).then(function(t){if(t){k.navigate(i)}})}};k.oNavigationPromise=undefined;k.navigate=function(t){const e=_.getUShellContainer();if(t.indexOf("#")===0&&e){if(!k.oNavigationPromise){k.oNavigationPromise=_.getServiceAsync("CrossApplicationNavigation").then(function(e){e.toExternal({target:{shellHash:t.substring(1)}});k.oNavigationPromise=undefined})}}else{window.location.href=t}};k.prototype.onPressLinkPersonalization=function(){this._openPersonalizationDialog()};k.prototype._openPersonalizationDialog=function(){return new Promise(function(t,e){sap.ui.require([this.getMetadataHelperPath()||"sap/ui/mdc/Link"],function(e){const n=this._getInternalModel();const i=e.retrieveBaseline(this);const o=i;const r=function(t){let e=t._oListControl.getItems().filter(function(t){return t.getSelected()});e=e.map(function(e){const n=t._getP13nModel().getProperty(e.getBindingContext(t.P13N_MODEL).sPath);return{id:n.name,description:n.description,href:n.href,internalHref:n.internalHref,target:n.target,text:n.text,visible:n.visible}});const n=k._showResetButtonEnabled(o,e);this._getInternalModel().setProperty("/showResetEnabled",n)};const a=this.getParent();if(a.isA("sap.m.Popover")){a.setModal(true)}I.getInstance().uimanager.show(this,"LinkItems",{contentWidth:"28rem",contentHeight:"35rem",close:function(){if(a.isA("sap.m.Popover")){a.setModal(false)}}}).then(function(e){const i=e.getCustomHeader().getContentRight()[0];const o=e.getContent()[0];i.setModel(n,"$sapuimdclinkPanel");i.bindProperty("enabled",{path:"$sapuimdclinkPanel>/showResetEnabled"});r.call(this,o);o.attachChange(function(t){r.call(this,o);o.attachChange(function(t){r.call(this,o)}.bind(this));e.attachAfterClose(function(){if(a.isA("sap.m.Popover")){a.setModal(false)}})}.bind(this));t(e)}.bind(this))}.bind(this))}.bind(this))};k._showResetButtonEnabled=function(t,e){let n=false;const i=k._getVisibleItems(e);const o=k._getVisibleItems(t);if(e.length!==t.length){n=true}else if(o.length&&i.length){const t=k._allItemsIncludedInArray(o,i);const e=k._allItemsIncludedInArray(i,o);n=!t||!e}return n};k._allItemsIncludedInArray=function(t,e){let n=true;t.forEach(function(t){const i=k._getItemsById(t.id,e);if(i.length===0){n=false}});return n};k._getItemsById=function(t,e){return e.filter(function(e){return e.id===t})};k._getItemById=function(t,e){return k._getItemsById(t,e)[0]};k._getVisibleItems=function(t){return t.filter(function(t){return t.id!==undefined&&t.visible})};k.prototype._getInternalModel=function(){return this.getModel("$sapuimdclinkPanel")};k.prototype._propagateDefaultIcon=function(t){if(!t){return}const e=this._getInternalModel();e.getProperty("/runtimeItems").forEach(function(t,n){if(t.icon){return}e.setProperty("/runtimeItems/"+n+"/icon","sap-icon://chain-link")})};let M,x,$,S,B;function W(t){const e=this._getInternalModel();if(t.object.isA("sap.ui.mdc.link.Panel")){switch(t.name){case"additionalContent":M=t.child?[t.child]:t.children;M.forEach(function(e){switch(t.mutation){case"insert":this._getAdditionalContentArea().addItem(e);break;case"remove":break;default:i.error("Mutation '"+t.mutation+"' is not supported yet.")}}.bind(this));e.setProperty("/countAdditionalContent",M.length);break;case"items":x=t.child?[t.child]:t.children;x.forEach(function(n){const o=e.getProperty("/runtimeItems/");switch(t.mutation){case"insert":e.setProperty("/countItemsWithIcon",n.getIcon()?e.getProperty("/countItemsWithIcon")+1:e.getProperty("/countItemsWithIcon"));e.setProperty("/countItemsWithoutIcon",n.getIcon()?e.getProperty("/countItemsWithoutIcon"):e.getProperty("/countItemsWithoutIcon")+1);o.splice(this.indexOfItem(n),0,n.getJson());e.setProperty("/runtimeItems",o);this._propagateDefaultIcon(e.getProperty("/countItemsWithIcon")>0&&e.getProperty("/countItemsWithoutIcon")>0);this._oObserver.observe(n,{properties:["visible"]});break;case"remove":e.setProperty("/countItemsWithIcon",n.getIcon()?e.getProperty("/countItemsWithIcon")-1:e.getProperty("/countItemsWithIcon"));e.setProperty("/countItemsWithoutIcon",n.getIcon()?e.getProperty("/countItemsWithoutIcon"):e.getProperty("/countItemsWithoutIcon")-1);$=o.find(function(t){return t.id===n.getId()});o.splice(o.indexOf($),1);e.setProperty("/runtimeItems",o);this._propagateDefaultIcon(e.getProperty("/countItemsWithIcon")>0&&e.getProperty("/countItemsWithoutIcon")>0);this._oObserver.unobserve(n);n.destroy();this.invalidate();break;default:i.error("Mutation '"+t.mutation+"' is not supported yet.")}},this);break;case"enablePersonalization":this._getPersonalizationButton().setVisible(t.current);break;default:i.error("The property or aggregation '"+t.name+"' has not been registered.")}}else if(t.object.isA("sap.ui.mdc.link.PanelItem")){switch(t.name){case"visible":S=t.object;B=this.indexOfItem(S);if(S.getVisibleChangedByUser()){e.setProperty("/runtimeItems/"+B+"/visible",S.getVisible())}else{e.setProperty("/baselineItems/"+B+"/visible",S.getVisible());e.setProperty("/runtimeItems/"+B+"/visible",S.getVisible())}break;default:i.error("The '"+t.name+"' of PanelItem is not supported yet.")}}this._updateContentTitle()}k.prototype.getContentTitle=function(){const t=this._getInternalModel();const e=t.getProperty("/contentTitle");if(e){return e}else{this._updateContentTitle();return this.getContentTitle()}};k.prototype.getCurrentState=function(){const t=[];let e;this.getItems().forEach(function(n,i){e=n&&n.getId();if(n.getVisible()){t.push({name:e})}});return{items:t}};k.prototype.initPropertyHelper=function(){const t=this._oMetadataHelper.retrieveAllMetadata(this);return Promise.resolve({getProperties:function(){const e=[];t.forEach(function(t){e.push({name:t.id,getName:function(){return t.id},getLabel:function(){return t.text},text:t.text,href:t.href,internalHref:t.internalHref,description:t.description,target:t.target,visible:t.visible})});return e}})};k.prototype._updateContentTitle=function(){const t=this._getInternalModel();const e=this._getAdditionalContentArea().getItems();let n=this._getPersonalizationButton();if(e.length>0){n=e[0]}else{const t=this._getLinkControls();if(t.length>0){n=t[0]}}t.setProperty("/contentTitle",n)};k.prototype._getAdditionalContentArea=function(){return this.getAggregation("_content").getContent()[v]};k.prototype._getSeparator=function(){return this.getAggregation("_content").getContent()[A]};k.prototype._getLinkArea=function(){return this.getAggregation("_content").getContent()[w]};k.prototype._getLinkControls=function(){return this._getLinkArea().getItems().map(t=>t.getContent()[0].getItems()[1].getItems()[0])};k.prototype._getFooterArea=function(){return this.getAggregation("_content").getContent()[L]};k.prototype._getPersonalizationButton=function(){return this._getFooterArea().getItems()[0]};return k});
//# sourceMappingURL=Panel.js.map