/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/dnd/DragDropBase","sap/ui/core/dnd/DragInfo","sap/ui/core/dnd/DropInfo","sap/ui/base/ManagedObjectObserver"],function(t,o,e,r){"use strict";const n=t.extend("sap.ui.mdc.table.DragDropConfig",{metadata:{library:"sap.ui.mdc",properties:{draggable:{type:"boolean",defaultValue:false},droppable:{type:"boolean",defaultValue:false},dropEffect:{type:"sap.ui.core.dnd.DropEffect",defaultValue:"Move"},dropPosition:{type:"sap.ui.core.dnd.DropPosition",defaultValue:"On"}},events:{dragStart:{allowPreventDefault:true,parameters:{bindingContext:{type:"sap.ui.model.Context"}}},dragEnd:{parameters:{bindingContext:{type:"sap.ui.model.Context"}}},dragEnter:{allowPreventDefault:true},dragOver:{},drop:{}}}});n.prototype.init=function(){this._oObserver=new r(this._observeChanges.bind(this))};n.prototype.exit=function(){this._oObserver.destroy();this._oObserver=null};n.prototype.setDraggable=function(t){this.setProperty("draggable",t,true);this.getDraggable()?this._addDragInfoToTable():this._removeDragInfoFromTable();return this};n.prototype.setDroppable=function(t){this.setProperty("droppable",t,true);this.getDroppable()?this._addDropInfoToTable():this._removeDropInfoFromTable();return this};n.prototype.setEnabled=function(t){this.setProperty("enabled",t,true);this._oDragInfo?.setEnabled(t);this._oDropInfo?.setEnabled(t);return this};n.prototype.setGroupName=function(t){this.setProperty("groupName",t,true);this._oDragInfo?.setGroupName(t);this._oDropInfo?.setGroupName(t);return this};n.prototype.setDropEffect=function(t){this.setProperty("dropEffect",t,true);this._oDropInfo?.setDropEffect(t);return this};n.prototype.setDropPosition=function(t){this.setProperty("dropPosition",t,true);this._oDropInfo?.setDropPosition(t);return this};n.prototype.setParent=function(){const o=this.getParent();o&&this._disconnectFromParent(o);t.prototype.setParent.apply(this,arguments);const e=this.getParent();e&&this._connectToParent(e)};n.prototype._connectToParent=function(t){this._oObserver.observe(t,{aggregations:["_content"]});const o=t.getAggregation("_content");o&&this._connectToTable(o)};n.prototype._disconnectFromParent=function(t){this._oObserver?.unobserve(t,{aggregations:["_content"]});this._disconnectFromTable()};n.prototype._observeChanges=function(t){if(t.mutation=="insert"){this._connectToTable(t.child)}else{this._disconnectFromTable()}};n.prototype._connectToTable=function(t){this._oTable=t;this._addDragInfoToTable();this._addDropInfoToTable()};n.prototype._disconnectFromTable=function(){this._removeDragInfoFromTable();this._removeDropInfoFromTable();this._oTable=null};n.prototype._addDragInfoToTable=function(){if(this._oTable&&!this._oDragInfo&&this.getDraggable()){this._oDragInfo=new o({enabled:this.getEnabled(),groupName:this.getGroupName(),sourceAggregation:this._oTable.isA("sap.m.Table")?"items":"rows",dragStart:[this._onDragInfoEvent,this],dragEnd:[this._onDragInfoEvent,this]});this._oTable.addDragDropConfig(this._oDragInfo)}};n.prototype._removeDragInfoFromTable=function(){if(this._oTable&&this._oDragInfo){this._oTable.removeDragDropConfig(this._oDragInfo);this._oDragInfo.destroy();this._oDragInfo=null}};n.prototype._addDropInfoToTable=function(){if(this._oTable&&!this._oDropInfo&&this.getDroppable()){this._oDropInfo=new e({enabled:this.getEnabled(),groupName:this.getGroupName(),dropEffect:this.getDropEffect(),dropPosition:this.getDropPosition(),targetAggregation:this._oTable.isA("sap.m.Table")?"items":"rows",dragEnter:[this._onDropInfoEvent,this],dragOver:[this._onDropInfoEvent,this],drop:[this._onDropInfoEvent,this]});this._oTable.addDragDropConfig(this._oDropInfo)}};n.prototype._removeDropInfoFromTable=function(){if(this._oTable&&this._oDropInfo){this._oTable.removeDragDropConfig(this._oDropInfo);this._oDropInfo.destroy();this._oDropInfo=null}};function s(t){const o=t.isA("sap.m.ListItemBase")?"items":"rows";const e=t.getParent().getBindingInfo(o)||{};return t.getBindingContext(e.model)}function i(t){let o;const e=t.getDragControl();if(e?.isA("sap.m.ListItemBase")){o=s(e)}else if(e?.isA("sap.ui.table.Row")){o=t.getComplexData("sap.ui.table-"+e.getParent().getId()).draggedRowContext}return o||e}n.prototype._onDragInfoEvent=function(t){const o=t.getParameter("dragSession");const e=i(o);const r=t.getId()=="dragStart";const n={bindingContext:e};const s=this.fireEvent(t.getId(),n,r);if(r&&!s){t.preventDefault()}};n.prototype._onDropInfoEvent=function(t){const o=t.getParameter("dragSession");const e=i(o);const r=o.getDropControl();const n=s(r);const a=t.getParameter("dropPosition");const p=t.getId()=="dragEnter";const g={bindingContext:n,dragSource:e};if(a){g.dropPosition=a}const f=this.fireEvent(t.getId(),g,p);if(p&&!f){t.preventDefault()}};return n});
//# sourceMappingURL=DragDropConfig.js.map