/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/valuehelp/base/Container","sap/ui/mdc/valuehelp/base/DialogTab","sap/ui/mdc/util/loadModules","sap/ui/Device","sap/m/VBox","sap/m/FlexItemData","sap/ui/model/resource/ResourceModel","sap/ui/mdc/util/Common","sap/ui/mdc/enums/ValueHelpSelectionType","sap/base/strings/formatMessage","sap/ui/core/library","sap/ui/core/InvisibleMessage","sap/ui/mdc/util/DensityHelper"],function(e,t,n,o,i,s,l,a,r,c,u,p,d){"use strict";let h=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc");sap.ui.getCore().attachLocalizationChanged(function(){h=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc")});let g,f,C,y,m,b;let _,T,I,S,v;const M=u.InvisibleMessageMode;const k=e.extend("sap.ui.mdc.valuehelp.Dialog",{metadata:{library:"sap.ui.mdc",interfaces:["sap.ui.mdc.valuehelp.IDialogContainer","sap.ui.core.PopupInterface"],properties:{_selectedContentKey:{type:"string",visibility:"hidden"},_quickSelectEnabled:{type:"boolean",visibility:"hidden",defaultValue:false},_selectableContents:{type:"object[]",visibility:"hidden",defaultValue:[]},groupConfig:{type:"object",defaultValue:{}}},defaultAggregation:"content"}});function P(){if(o.system.desktop){return"700px"}if(o.system.tablet){return o.orientation.landscape?"600px":"600px"}}function B(){if(o.system.desktop){return"1080px"}if(o.system.tablet){return o.orientation.landscape?"920px":"600px"}}function x(e){const t=this.getContent();return t.filter(function(t){return!!t.getVisible()&&t.getGroup&&t.getGroup()===e}).length>1}k.prototype._handleContentSelectionChange=function(e){this.fireRequestDelegateContent({container:this.getId(),contentId:e});return this.getRetrieveDelegateContentPromise().then(function(){const t=this.getProperty("_selectedContentKey");const n=this.getContent();const o=t&&n&&n.find(function(e){return e.getId()===t});if(o){if(o.setCollectiveSearchSelect){o.setCollectiveSearchSelect(undefined)}o.onHide();this.unbindContentFromContainer(o)}return this._renderSelectedContent(e)}.bind(this))};k.prototype._onTabBarSelect=function(e){const t=e&&e.getParameter("key");this._handleContentSelectionChange(t)};k.prototype.invalidate=function(t){if(t){const n=this.getContent();const o=n.indexOf(t);if(this._oIconTabBar&&o!==-1&&!this.isDestroyStarted()){const e=this._oIconTabBar.getItems();if(e[o]){e[o].invalidate(t)}}else{e.prototype.invalidate.apply(this,arguments)}}};k.prototype.getUIAreaForContent=function(){const t=this.getAggregation("_container");if(t){return t.getUIArea()}return e.prototype.getUIAreaForContent.apply(this,arguments)};k.prototype.handleConfirmed=function(e){this.fireConfirm({close:true})};k.prototype.handleClosed=function(t){const n=this.getSelectedContent();if(n){n.onHide()}this.getContent().forEach(function(e){e.onContainerClose()});this.setProperty("_selectedContentKey",this._sInitialContentKey);e.prototype.handleClosed.apply(this,arguments)};k.prototype.getContainerControl=function(){if(!this.getModel("$i18n")){this.setModel(new l({bundleName:"sap/ui/mdc/messagebundle",async:false}),"$i18n")}const e=this.getAggregation("_container");if(!e){return this._retrievePromise("dialog",function(){return n(["sap/m/Dialog","sap/m/Button","sap/ui/model/base/ManagedObjectModel","sap/m/library"]).then(function(e){g=e[0];C=e[1];y=e[2];f=e[3];const t=f.ButtonType;if(!this._oResourceBundle){this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.mdc")}this.oButtonOK=new C(this.getId()+"-ok",{text:this._oResourceBundle.getText("valuehelp.OK"),enabled:"{$valueHelp>/_valid}",type:t.Emphasized,press:this.handleConfirmed.bind(this),visible:{parts:["$valueHelp>/_config/maxConditions","$help>/_quickSelectEnabled"],formatter:function(e,t){return e!==1||!t}}});this.oButtonCancel=new C(this.getId()+"-cancel",{text:this._oResourceBundle.getText("valuehelp.CANCEL"),press:this.handleCanceled.bind(this)});this._oManagedObjectModel=new y(this);const n=new g(this.getId()+"-dialog",{contentHeight:P(),contentWidth:B(),horizontalScrolling:false,verticalScrolling:false,title:{parts:["$help>/title","$help>/_selectableContents"],formatter:function(e,t){if(t&&t.length==1){const n=t[0];const o=n.getFormattedShortTitle()?n.getFormattedShortTitle():n.getTitle();if(o){e=this._oResourceBundle.getText("valuehelp.DIALOGSHORTTITLECOLONTITLE",[o,e])}}return e}.bind(this)},stretch:o.system.phone,resizable:true,draggable:true,afterOpen:this.handleOpened.bind(this),afterClose:this.handleClosed.bind(this),buttons:[this.oButtonOK,this.oButtonCancel]});d.syncDensity(n);n.setModel(this._oManagedObjectModel,"$help");this.setAggregation("_container",n,true);n.isPopupAdaptationAllowed=function(){return false};n.addStyleClass("sapMdcValueHelp");n.addStyleClass("sapMdcValueHelpTitle");const s=new i(this.getId()+"-Content",{fitContainer:true});s.addStyleClass("sapMdcValueHelpPanel");n.addContent(s);return n}.bind(this))}.bind(this))}return e};k.prototype.placeContent=function(e){const n=e.getContent()[0];const o=this.getProperty("_selectableContents");if(!o.length){return Promise.resolve(e)}const i=o.length>1;const l=[];if(i){l.push(this._getIconTabBar(e))}else{if(!this._oStandaloneTab){this._oStandaloneTab=new t(this.getId()+"-Standalone-DT",{content:{path:"/_selectableContents/0/displayContent",model:"$help"},layoutData:new s({growFactor:1,minHeight:"0"})})}l.push(this._oStandaloneTab)}if(E(this.getMaxConditions(),this.getContent())){l.push(this._getTokenizerPanel())}return Promise.all(l).then(function(t){n.removeAllItems();t.forEach(function(e){n.addItem(e)});if(i){e.addStyleClass("sapMdcValueHelpTitleShadow")}else{e.removeStyleClass("sapMdcValueHelpTitleShadow")}return e})};k.prototype.handleSelect=function(t){e.prototype.handleSelect.apply(this,arguments);if(this.getProperty("_quickSelectEnabled")&&this.isSingleSelect()){const e=t.getParameter("conditions");const n=[r.Set,r.Add].indexOf(t.getParameter("type"))!==-1;const o=e&&e.length;if(n&&o){this.fireConfirm({close:true})}}};k.prototype.observeChanges=function(t){if(t.name==="content"){const e=this.getContent();this.setProperty("_quickSelectEnabled",e&&e.every(function(e){return e.isQuickSelectSupported()}));this._updateInitialContentKey();if(t.mutation==="insert"&&!this.getProperty("_selectedContentKey")){this.setProperty("_selectedContentKey",this._sInitialContentKey)}this.setProperty("_selectableContents",this._getSelectableContents());if(E(this.getMaxConditions(),this.getContent())){const e=this.getAggregation("_container");if(e&&e.getContent()[0].getItems().length===1){Promise.all([this._getTokenizerPanel()]).then(function(t){t.forEach(function(t){e.getContent()[0].addItem(t)})})}}}e.prototype.observeChanges.apply(this,arguments)};k.prototype._updateInitialContentKey=function(){const e=this.getContent().find(function(e){return!!e.getVisible()});this._sInitialContentKey=e&&e.getId()};k.prototype.getSelectedContent=function(){const e=this.getProperty("_selectedContentKey");return this.getContent().find(function(t){return t.getId()===e})};k.prototype._getSelectableContents=function(){const e=this.getSelectedContent();const t=e&&e.getGroup&&e.getGroup();const n=e?t:"";const o=[n];return this.getContent().filter(function(t){if(!t.getVisible()){return false}const n=t.getGroup&&t.getGroup();const i=n&&x.call(this,n);if(i&&t!==e){if(o.indexOf(n)>=0){return false}else{o.push(n)}}return true}.bind(this))};k.prototype._updateGroupSelectModel=function(){if(this._oGroupSelectModel){const e=this.getSelectedContent();const t=e&&e.getGroup&&e.getGroup();const n=t?this.getContent().filter(function(e){return!!e.getVisible()&&e.getGroup&&e.getGroup()===t}):[];this._oGroupSelectModel.setData(n.reduce(function(e,t){e.entries.push({key:t.getId(),text:t.getFormattedTitle()});return e},{entries:[]}));if(this._oGroupSelect){const e=this._oGroupSelect.getSelectedItemKey();const t=n.map(function(e){return e.getId()});const o=this.getProperty("_selectedContentKey");if(t.indexOf(e)==-1||e!==o){this._oGroupSelect.setSelectedItemKey(n[0].getId())}}}};k.prototype._retrieveGroupSelect=function(){return this._retrievePromise("collectiveSearchSelect",function(){return n(["sap/ui/mdc/filterbar/vh/CollectiveSearchSelect","sap/m/VariantItem","sap/ui/model/json/JSONModel"]).then(function(e){const t=e[0];const n=e[1];const i=e[2];if(!this._oGroupSelectModel){this._oGroupSelectModel=new i}if(!this._oGroupSelect){const e=new n(this.getId()+"-collSearchItem",{key:"{$select>key}",text:"{$select>text}"});this._oGroupSelect=new t(this.getId()+"--Select",{title:"{$i18n>COL_SEARCH_SEL_TITLE}",items:{path:"$select>/entries",template:e},select:function(e){this._handleContentSelectionChange(e.getParameter("key"))}.bind(this),selectedItemKey:this.getSelectedContent().getId(),maxWidth:o.system.phone?"5em":"25rem"});this._oGroupSelect.setModel(this._oGroupSelectModel,"$select")}return this._oGroupSelect}.bind(this))}.bind(this))};k.prototype._getIconTabBar=function(){if(!this._oIconTabBar){return this._retrievePromise("IconTabBar",function(){return n(["sap/m/IconTabBar","sap/m/IconTabFilter"]).then(function(e){m=e[0];b=e[1];const n=f.IconTabHeaderMode;this._oIconTabBar=new m(this.getId()+"-ITB",{expandable:false,upperCase:false,stretchContentHeight:true,headerMode:n.Inline,select:this._onTabBarSelect.bind(this),layoutData:new s({growFactor:1}),selectedKey:"{path: '$help>/_selectedContentKey', mode: 'OneWay'}"});this._oIconTabBar.addStyleClass("sapUiNoContentPadding");const o=new b(this.getId()+"-ITF",{key:{path:"$help>id"},content:new t(this.getId()+"-DT",{content:{path:"$help>displayContent"}}),text:{parts:["$help>","$valueHelp>/conditions"],formatter:function(e,t){let n="none";if(e){const o=e.getGroup&&e.getGroup();const i=e.getCount(t,o);n=o?this._getFormattedContentGroupLabel(o,i):e.getFormattedTitle(i)}return n}.bind(this)}});this._oIconTabBar.bindAggregation("items",{path:"/_selectableContents",model:"$help",templateShareable:false,template:o});return this._oIconTabBar}.bind(this))}.bind(this))}return this._oIconTabBar};k.prototype._getFormattedContentGroupLabel=function(e,t){const n=this.getGroupConfig();const o=n&&n[e];let i=o&&(t?o.label:o.nnLabel);i=i&&c(i,t?t:"");i=i||this._oResourceBundle.getText(t?"valuehelp.SELECTFROMLIST":"valuehelp.SELECTFROMLISTNONUMBER",[t]);return i};k.prototype._getTokenizerPanel=function(e){if(!this.oTokenizerPanel){return this._retrievePromise("TokenizerPanel",function(){return n(["sap/m/Panel","sap/m/HBox","sap/m/VBox","sap/ui/mdc/field/FieldMultiInput","sap/m/Token","sap/ui/model/Filter","sap/ui/mdc/field/ConditionType"]).then(function(e){_=e[0];T=e[1];i=e[2];I=e[3];S=e[4];v=e[5];const t=e[6];const n=f.BackgroundDesign;const o=f.ButtonType;this.oTokenizerPanel=new _(this.getId()+"-TokenPanel",{backgroundDesign:n.Transparent,expanded:true,visible:{parts:["$valueHelp>/_config/maxConditions","$help>/content"],formatter:E},headerText:{parts:["$valueHelp>/conditions","$help>/_selectableContents"],formatter:function(e,t){let n=0;for(let t=0;t<e.length;t++){const o=e[t];if(o.isEmpty!==true){n++}}let o;if(t&&t.length==1){o=t[0].getFormattedTokenizerTitle(n);return o}else{o=this._oResourceBundle.getText("valuehelp.TOKENIZERTITLE");if(n===0){o=this._oResourceBundle.getText("valuehelp.TOKENIZERTITLENONUMBER")}return c(o,n)}}.bind(this)}});this.oTokenizerPanel.addStyleClass("sapMdcTokenizerPanel");const l=new T(this.getId()+"-TokenBox",{fitContainer:true,width:"100%"});const a=w.call(this);this._oConditionType=new t(a);this._oConditionType._bVHTokenizer=true;this.oTokenMultiInput=new I(this.getId()+"-Tokenizer",{width:"100%",showValueHelp:false,editable:true,ariaAttributes:{role:"listbox",aria:{readonly:true,roledescription:this._oResourceBundle.getText("valuehelp.TOKENIZER_ARIA_ROLE_DESCRIPTION")}},ariaLabelledBy:this.oTokenizerPanel,tokenUpdate:function(e){if(e.getParameter("removedTokens")){const t=e.getParameter("removedTokens");const n=this.getModel("$valueHelp").getObject("/conditions");const o=[];t.forEach(function(e,t){const i=e.getBindingContext("$valueHelp").sPath;const s=parseInt(i.slice(i.lastIndexOf("/")+1));o.push(n[s])});this.fireSelect({type:r.Remove,conditions:o})}}.bind(this),layoutData:new s({growFactor:1,maxWidth:"calc(100% - 2rem)"})});this.oTokenMultiInput._setValueVisible=function(e){this.$("inner").css("opacity","0")};const u=this.oTokenMultiInput.onAfterRendering;this.oTokenMultiInput.onAfterRendering=function(){u.apply(this.oTokenMultiInput,arguments);this.oTokenMultiInput._setValueVisible();this.oTokenMultiInput.setValue("")}.bind(this);O.call(this,true);this.oRemoveAllBtn=new C(this.getId()+"-TokenRemoveAll",{press:function(e){this.fireSelect({type:r.Set,conditions:[]});this.oInvisibleMessage.announce(h.getText("valuehelp.REMOVEALLTOKEN_ANNOUNCE"),M.Assertive)}.bind(this),type:o.Transparent,icon:"sap-icon://decline",tooltip:"{$i18n>valuehelp.REMOVEALLTOKEN}",layoutData:new s({growFactor:0,baseSize:"2rem"})});this.oRemoveAllBtn.addStyleClass("sapUiTinyMarginBegin");l.addItem(this.oTokenMultiInput);l.addItem(this.oRemoveAllBtn);this.oTokenizerPanel.addContent(l);return this.oTokenizerPanel}.bind(this))}.bind(this))}else{const e=w.call(this);this._oConditionType.setFormatOptions(e)}return this.oTokenizerPanel};function E(e,t){let n=e!==1;if(n&&t&&t.every(function(e){return!e.getRequiresTokenizer()})){n=false}return n}function w(){const e=this.getModel("$valueHelp");const t=e?e.getProperty("/_config"):{};const n=this.getParent();const o=this.getControl();return{maxConditions:-1,valueType:t.dataType,additionalValueType:t.additionalDataType,operators:t.operators,display:t.display,valueHelpID:n&&n.getId(),control:o,delegate:o&&o.getControlDelegate&&o.getControlDelegate(),delegateName:o&&o.getDelegate&&o.getDelegate()&&o.getDelegate().name,payload:o&&o.getPayload&&o.getPayload(),convertWhitespaces:true}}function O(e){if(this.oTokenMultiInput){const t=this.oTokenMultiInput.getBindingInfo("tokens");if(e){if(!t){const e=new v({path:"isEmpty",operator:"NE",value1:true});this._oConditionType.setFormatOptions(w.call(this));const t=new S(this.getId()+"-Token",{text:{path:"$valueHelp>",type:this._oConditionType}});this.oTokenMultiInput.bindAggregation("tokens",{path:"/conditions",model:"$valueHelp",templateShareable:false,template:t,filters:e})}}else if(t){this.oTokenMultiInput.unbindAggregation("tokens")}}}k.prototype.openContainer=function(e){this._mAlreadyShownContents={};if(e){this._updateInitialContentKey();const t=function(){this._renderSelectedContent(this._sInitialContentKey,function(){const t=this.getContent().find(function(e){return e.getId()===this.getProperty("_selectedContentKey")}.bind(this));const n=t.getInitialFocusedControl();if(n){e.setInitialFocus(n)}e.open();this.getContent().forEach(function(e){e.onContainerOpen()})}.bind(this))}.bind(this);if(E(this.getMaxConditions(),this.getContent())&&e.getContent()[0].getItems().length===1){Promise.all([this._getTokenizerPanel()]).then(function(n){n.forEach(function(t){e.getContent()[0].addItem(t)});t()})}else{if(this.oTokenMultiInput){O.call(this,true)}t()}}};k.prototype._renderSelectedContent=function(e,t){const n=this.getContent().find(function(t){return t.getId()===e});if(!n){throw new Error("sap.ui.mdc.ValueHelp: No content found.")}const o=[n.getContent()];const i=n.getGroup&&n.getGroup();let s;if(i&&x.call(this,i)){s=this._retrieveGroupSelect();o.push(s)}const l=!this._mAlreadyShownContents[e];return Promise.all(o).then(function(){this.bindContentToContainer(n)}.bind(this)).then(function(){return Promise.resolve(n.onBeforeShow(l))}).then(function(){this._mAlreadyShownContents[e]=true;this.setProperty("_selectedContentKey",e);this.setProperty("_selectableContents",this._getSelectableContents());this._oManagedObjectModel.checkUpdate(true,false,function(e){if(e.getPath().indexOf("displayContent")>=0){return true}});if(s){this._updateGroupSelectModel()}if(n.setCollectiveSearchSelect){n.setCollectiveSearchSelect(s?this._oGroupSelect:undefined)}if(t){t()}return this._retrievePromise("open").then(function(){n.onShow(l);return n})}.bind(this))};k.prototype.closeContainer=function(){const e=this.getAggregation("_container");if(e){e.close();if(this.oTokenMultiInput){O.call(this,false)}}};k.prototype.getValueHelpIcon=function(){return"sap-icon://value-help"};k.prototype.getAriaAttributes=function(e){return{contentId:null,ariaHasPopup:"dialog",role:null,roleDescription:null,valueHelpEnabled:true,autocomplete:"none"}};k.prototype.isMultiSelect=function(){return this.getMaxConditions()!==1};k.prototype.init=function(){e.prototype.init.apply(this,arguments);this.oInvisibleMessage=p.getInstance()};k.prototype.exit=function(){a.cleanup(this,["_oManagedObjectModel","_oResourceBundle","oButtonOK","oButtonCancel","oTokenizerPanel","oTokenMultiInput","_oIconTabBar","_oGroupSelect","_oGroupSelectModel","_sInitialContentKey","_mAlreadyShownContents","oInvisibleMessage","_oStandaloneTab"]);e.prototype.exit.apply(this,arguments)};return k});
//# sourceMappingURL=Dialog.js.map