/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Binding","sap/ui/base/SyncPromise","sap/ui/model/ChangeReason","sap/base/Log","sap/base/assert","./SimpleType","./DataState"],function(t,e,n,r,a){"use strict";var o=t.extend("sap.ui.model.PropertyBinding",{constructor:function(e,n,r,a){t.apply(this,arguments);this.fnFormatter=undefined;this.sInternalType=undefined;this.sMode=undefined;this.oType=undefined},metadata:{abstract:true,publicMethods:["getValue","setValue","setType","getType","setFormatter","getFormatter","getExternalValue","setExternalValue","getBindingMode"]}});o.prototype._getBoundValue=function(t){var e=this.getValue();return t(e)};o.prototype._setBoundValue=function(t,n){var r=this.getDataState(),a=this;if(this.oType){return e.resolve(t).then(function(t){return n(t)}).then(function(t){return e.all([t,a.oType.validateValue(t)])}).then(function(t){return t[0]}).then(function(t){r.setInvalidValue(undefined);a.setValue(t)}).catch(function(e){r.setInvalidValue(t);a.checkDataState();throw e}).unwrap()}else{r.setInvalidValue(undefined);a.setValue(t);return undefined}};o.prototype._rawToExternal=function(t){if(this.oType){t=this.oType.formatValue(t,this.sInternalType)}if(this.fnFormatter){t=this.fnFormatter(t)}return t};o.prototype._externalToRaw=function(t){if(this.oType){t=this.oType.parseValue(t,this.sInternalType)}return t};o.prototype._rawToInternal=function(t){var e;if(this.oType&&t!==null&&t!==undefined){e=this.oType.getModelFormat();a(e&&typeof e.parse==="function","The input format of "+this.oType+" should be an object with the 'parse' method");t=e.parse(t)}return t};o.prototype._internalToRaw=function(t){var e;if(t!==null&&t!==undefined){e=this.oType.getModelFormat();a(e&&typeof e.format==="function","The model format of "+this.oType+" should be an object with the 'format' method");t=e.format(t)}return t};o.prototype.getExternalValue=function(){switch(this.sInternalType){case"raw":return this.getRawValue();case"internal":return this.getInternalValue();default:return this._getBoundValue(this._rawToExternal.bind(this))}};o.prototype.setExternalValue=function(t){switch(this.sInternalType){case"raw":return this.setRawValue(t);case"internal":return this.setInternalValue(t);default:if(this.fnFormatter){r.warning("Tried to use twoway binding, but a formatter function is used");return undefined}return this._setBoundValue(t,this._externalToRaw.bind(this))}};o.prototype.getInternalValue=function(){return this._getBoundValue(this._rawToInternal.bind(this))};o.prototype.setInternalValue=function(t){return this._setBoundValue(t,this._internalToRaw.bind(this))};o.prototype.getRawValue=function(){return this._getBoundValue(function(t){return t})};o.prototype.setRawValue=function(t){return this._setBoundValue(t,function(t){return t})};o.prototype.setType=function(t,e){const r=this.oType;this.oType=t;this.sInternalType=e;if(this.fnTypeChangedCallback&&t&&r!==t){this.fnTypeChangedCallback();this._fireChange({reason:n.Change})}};o.prototype.getType=function(){return this.oType};o.prototype.setFormatter=function(t){this.fnFormatter=t};o.prototype.getFormatter=function(){return this.fnFormatter};o.prototype.getBindingMode=function(){return this.sMode};o.prototype.setBindingMode=function(t){this.sMode=t};o.prototype.registerTypeChanged=function(t){this.fnTypeChangedCallback=t};o.prototype.resume=function(){this.bSuspended=false;this.checkUpdate(true)};return o});
//# sourceMappingURL=PropertyBinding.js.map